Ext.define('ICTest.view.SnmpGenerate', {
	extend: 'Ext.container.Container',
	alias: 'widget.snmpgenerate',
	layout: {
		type: 'vbox',
		pack: 'center',
		align: 'center'
	},
	margin: 10,
	items: [
		{
			xtype: 'scrollcombo',
			cls : 'dropdown',
			id:'elements',
			name:'elements',
			labelSeparator: ' ',
			labelWidth: 200,
			width: 450,
			fieldLabel: 'Element Category',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField:'displayField',
			valueField:'valueField',
			queryMode : 'local',
			editable: false,
			margin: '5 10 10 10'
		},
		{
			xtype:'container',
			id: 'multiGroup',
			hidden: true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 450,
				labelWidth: 200
			},
			items:
			[
				{
					xtype: 'container',
					layout: {
						type: 'hbox'
					},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: elmtId,
							id:'elementOid',
							name:'elementOid',
							labelSeparator: '',
							width: 425,
							labelWidth: 200
						},
						{
							xtype: 'button',
							iconCls:'iconTree',
							border:0,
							style:{
								'background':'none'
							},
							 listeners: {
								el: {
									click: function() {
										snmpCtrlr.showMibTree('config','ElementOID');
									}
								}
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: {
						type: 'hbox'
					},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: elmtStatus,
							id:'validOid',
							name:'validOid',
							labelSeparator: '',
							width: 425,
							labelWidth: 200
						},
						{
							xtype: 'button',
							iconCls:'iconTree',
							border:0,
							style:{
								'background':'none'
							},
							 listeners: {
								el: {
									click: function() {
										snmpCtrlr.showMibTree('config','StatusOID');
									}
								}
							}
						}
					]
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: elmtValidStatus,
					id:'validValue',
					name:'validValue'
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: rediscPeriod,
					id:'rediscPeriod',
					name:'rediscPeriod'
				}
			]
		},
		{
			xtype: 'scrollcombo',
			cls : 'dropdown',
			id:'dbSizeGen',
			name:'dbSizeGen',
			labelSeparator: ' ',
			labelWidth: 200,
			width: 450,
			hidden:true,
			fieldLabel: dbColSize,
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField:'displayField',
			valueField:'valueField',
			queryMode : 'local',
			editable: false,
			margin: '5 10 10 10'
		},
		{
			xtype: 'checkboxgroup',
			fieldLabel: descBasedTest,
			id: 'descCheckBox',
			labelSeparator: ' ',
			margin:'0 10 10 10',
			columns: 1,
			vertical: false,
			items: [
				{name: 'isDescriptorBasedTestSnmp',id:'isDescriptorBasedTestSnmp',inputValue: 'yes',checked: false,cls: 'checkbt',margin:'5 0 0 0',hidden: true}
			],
			labelWidth: 195,
			width: 450
		},
		{
			xtype: 'button',
			cls : 'button20',
			text: generate,
			id:'generate',
			name:'generate',
			margin:10,
			width: 80,
		}
	]
});



