Ext.define('ICTest.view.Tests', {
	extend: 'utilities.innerScrollContainer',
	margin : '8 8 0 8',
	cls:'outerpanel',
	alias: 'widget.tests',
	title: pageTitle1,

	requires: [
		'utilities.ScrollCombo',
		'utilities.adminMsg',
		'utilities.CustomGrid'
	],

	dockedItems: [
		{
			xtype: 'adminmsg',
			align:'center',
			addIcon:'iconAdminInfo',
			html: pageDesc1,
			spaceforImg:5,
			padding: 5
		}
	],

	items: [
		{
			xtype: 'container',
			flex:1,
			id : 'testCnt',
			layout: {
				type: 'hbox',
				align:'stretch'
			},
			items: [
				{
					xtype: 'customgrid',
					cls:'gridSkin',
					frame:false,
					border:true,
					padding:0,
					scroll:true,
					id:'udGrid',
					title: udTests,
					store: new Ext.data.Store({
						fields: ['test','type','testType','jspPage'],
						groupField: 'type',
						data : []
					}),
					features : Ext.create('Ext.grid.feature.Grouping',{
						groupByText : 'type',
						groupHeaderTpl: '{[values.rows[0].data.type]} Test(s)',
					}),
					autoScroll: true,
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: test,
								dataIndex: 'test',
								flex:1
							},
							{
								text: 'Type',
								dataIndex: 'type',
								hidden: true,
								flex:1
							},
							{
								text: 'Category',
								dataIndex: 'testType',
								flex: 1
							},
							{
								text: '',
								dataIndex: 'jspPage',
								hidden: true
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-edit-column-header',
								width: 36,
								//icon: '../../../../admin/extjs/resources/images/edit_task.png',
								iconCls: 'iconModify',
								//tooltip: modifyTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='"+modifyTooltip+"' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.modifyTest(grid, rowIndex, colIndex);
								}
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-delete-column-header',
								width: 36,
								//icon: '../../../../admin/extjs/resources/images/delete.png',
								iconCls: 'iconDelete',
								//tooltip: deleteTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='"+deleteTooltip+"' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.deleteTest(grid, rowIndex, colIndex);
								}
							}
						]
					},
					margin: 10,
					flex: 1,
					emptyText:  '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noUdTestsAlrtDiv">'+noTestsFnd+'</div></td></tr></table>',
					viewConfig: {
						deferEmptyText: false
					},
					tools: [
						/*{
							xtype:'tbfill',
						},*/
						{
							xtype: 'trigger',
							cls:'whitedropdown_search',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							emptyText: 'Search',
							id:'searchBox',
							padding:0,
							margin:'0 5 0 0',
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								ctrler.searchTest();
							},
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							}
						},
						{
							xtype: 'toolbar',
							ui: 'footer',
							padding:0,
							margin:0,
							items: [
								{
									xtype: 'button',
									cls:'button20',
									padding:0,
									margin:0,
									id: 'addTestButton',
									text: addTest
								}
							]
						}
					]
				}
			]
		}
	]
});



