<%
/*
 *       Name            :      EgConfigTestMeasure.jsp
 *       Purpose         :		IC Test - Measure
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="egurkha.*" %>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	private int getConfigTestSizeIndex(int dbsize)
	{
		int val=-1;
		switch(dbsize)
		{
			case 32: val=1;break;
			case 64: val=2;break;
			case 128: val=3;break;
			case 256: val=4;break;
			case 512: val=5;break;
			case 1024: val=6;break;
		}
		return val;
	}	
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();
	JSONObject obj = new JSONObject();

	IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String factors [] = iniUI.getVariables("CONVERSION_FACTORS");
	String helpuploadDir=EgInstallInfo.getInstallDir()+	"/manager/tomcat/webapps/final/eghelp/";
	helpuploadDir=StringUtils.replace(helpuploadDir,"\\","/");

	boolean isDouble=EgDbInfo.doubleByteEnabled;
	User user=registry.getUser(session.getId());
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	Hashtable factorsMapping = new Hashtable();
	if(factors != null)
	{
		for (int i=0;i<factors.length;i++)
		{
			String var = (String) factors[i];
			String val = iniUI.getValue("CONVERSION_FACTORS", var);
			factorsMapping.put(val, var);
		}
	}
	
	
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String test = request.getParameter("test");
	boolean isConfigTest = EgInstallInfo.isConfigTest(test);
	String mname = request.getParameter("measure");
	String dbsize = request.getParameter("dbsize");
	String unitValue = request.getParameter("unit");
	String index = request.getParameter("index");
	String otherCount = request.getParameter("checkOtherCount");

	String factor = request.getParameter("factor");
	if(factor == null || factor.length() == 0 || factor.equals("null"))
		factor = "1";

	String scrollPosition = request.getParameter("position");
	scrollPosition = scrollPosition == null?"0":scrollPosition;

	//session.setAttribute("factorsMapping", factorsMapping);

	String [] factorSel = new String[factors.length];
	for(int i=0; i<factorSel.length; i++)
	{
		if(iniUI.getValue("CONVERSION_FACTORS",(String)factors[i]).equals(factor))
			factorSel[i] = "selected";
		else
			factorSel[i] = "";
	}


	int iConfigFieldSize=new EgTesterInfo("manager").getConfigTestFieldSize(test);
	if(otherCount == null)
		otherCount="0";

	TestBean testBean = new TestBean(true);

	ArrayList units = testBean.getAllUnits();

	Collections.sort(units,String.CASE_INSENSITIVE_ORDER);

	ArrayList measures_list = testBean.getMeasuresForTest(test);

	boolean bDescriptorBasedTest=false;
	if(isConfigTest)
	{
		bDescriptorBasedTest=testBean.isThisDescriptorBasedTest(test);
	}

	int i_mes_count = 0;
	if(measures_list != null)
	{
		i_mes_count = measures_list.size();
	}

	String size1 = "";
	String size2 = "";
	String size3 = "";
	String size4 = "";
	String size5 = "";
	String size6 = "";
	String path = "";
	String lib = "";
	
	if(request.getParameter("classPath") == null)
		path =  testBean.getPath(test);
	else
		path = request.getParameter("classPath");
		
	if(request.getParameter("libPath") == null)
		lib = testBean.getLib(test);
	else		
		request.getParameter("libPath");

	if(mname == null || mname.length() == 0)
		mname = "";
	if(dbsize != null && dbsize.length() != 0)
	{
		if(dbsize.equals("1"))
			size1 = "selected";
		else if(dbsize.equals("2"))
			size2 = "selected";
		else if(dbsize.equals("3"))
			size3 = "selected";
		else if(dbsize.equals("4"))
			size4 = "selected";
		else if(dbsize.equals("5"))
			size5 = "selected";
		else if(dbsize.equals("6"))
			size6 = "selected";
	}

	Hashtable factVals = testBean.getFactors(test);

	IniFile udMeasures = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	String oldClass = udMeasures.getValue("PATH",test);
	rootJSON.put("oldClass",oldClass);

	ArrayList measures = testBean.getMeasuresForTest(test);
	if(measures == null || measures.size() == 0)
	{
		rootJSON.put("noMeasuresAdded",true);
	}
	else
	{
		//new var initialization for file upload
		rootJSON.put("noMeasuresAdded",false);
		String Path="";
		String upload="";
		String uploadtype="";
		if(request.getParameter("uploadFile")!=null)
			upload = request.getParameter("uploadFile");
		if(upload.equals("") && upload.length()==0)
			upload = "false";
		if(request.getParameter("uploadType")!=null)
			uploadtype = request.getParameter("uploadType");
		String pathLib="";
		

		//maintain session for libPath and classPath as well
		if(request.getParameter("libPath")!=null)
		{
			if(lib == null || lib.length()==0)
				lib = request.getParameter("libPath");
		}

		if(request.getParameter("classPath")!=null && request.getParameter("classPath").length()>0)
		{
			if(uploadtype.equalsIgnoreCase("loadClass"))
				path = request.getParameter("classPath");
			else if((path == null || path.length()==0) || (uploadtype.equalsIgnoreCase("loadLib")))	
				path = request.getParameter("classPath");
		}

		if((path!= null) && (path.length()> 0 && path.indexOf("\\")> -1))
			path = path.replace('\\','/');

		if((lib!= null) && (lib.length()> 0 && lib.indexOf("\\")> -1))
			lib = lib.replace('\\','/');

		String key = null;
		String value = null;
		String unit = null;
		String tmpInd = null;
		String alarm_msg = null;
		String factVal = null;
		String org_factor = null;
		Integer idx;
		String temp = null;
		String org_measure = null;
		String tmpUnit = null;
		int ind = 0;
		int count = 0;
		// Measures List
		JSONArray measureList = new JSONArray();
		for(int i=0; i<measures.size(); i++)
		{
			obj = new JSONObject();
			temp = (String) measures.get(i);

			ind = temp.indexOf(":");
			if(ind < 0)
				continue;

			if(!isConfigTest)
			{
				key = temp.substring(0, ind);
				temp = temp.substring(ind+1);
				ind = temp.indexOf(":");
				if(ind < 0)
					continue;

				value = temp.substring(0, ind);
				temp = temp.substring(ind + 1);
				ind = temp.indexOf(":");
				if(ind < 0)
					continue;

				unit = temp.substring(0, ind);
				temp = temp.substring(ind + 1);
				//new code to effect alarm display string starts
				ind = temp.indexOf(":");
				if(ind < 0)
					continue;

				if(ind == 0)
				{
					alarm_msg = "";
					idx = new Integer(temp.substring(ind + 1));
				}
				else
				{
					alarm_msg = temp.substring(0, ind);//alarm msg
					idx = new Integer(temp.substring(ind + 1));
				}

				//new code to effect alarm display string ends
				tmpInd = idx.toString();
				tmpUnit = "";
				if(unit.equals("%"))
				{
					tmpUnit = unit;
					for(int x=0;x<tmpUnit.length();x++)
					{
						if(tmpUnit.charAt(x) == '%')
							tmpUnit = tmpUnit.replace('%','|');
						else
							continue;
					}
				}
				else
				{
					tmpUnit = unit;
				}

				count++;
				String s_tmpInd="";
				if(alarm_msg != null)
					s_tmpInd = alarm_msg+":"+tmpInd;
				else
					s_tmpInd = tmpInd;

				if(tmpUnit.equals("|"))
					org_measure = key+":"+value+":"+tmpUnit+":"+s_tmpInd;
				else
					org_measure = key+":"+value+":"+unit+":"+s_tmpInd;

			}
			else
			{
				key = temp.substring(0, ind);       // measure name

				temp=temp.substring(ind+1);
				ind=temp.indexOf(":");
				if(ind < 0)
					continue;

				unit = temp.substring(0, ind);
				temp = temp.substring(ind + 1);
				
				idx = new Integer(temp.substring(0));
				tmpInd = idx.toString();
				org_measure = key+":"+unit+":"+tmpInd;
				tmpUnit = unit;
			}

			if(factVals.containsKey(key))
				factVal = (String) factVals.get(key);

			org_factor = key+":"+factVal;

			obj.put("measureIndex",tmpInd);
			obj.put("measureName",key);
			
			String alrmMsg = (alarm_msg!=null)?EgURLEncoder.encode(alarm_msg,"UTF-8"):"";						
			String modifyURL = "EgModifyMeasuresJson.jsp?org_measure="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(org_measure),"UTF-8")+"&org_factor="+org_factor+"&test="+test+"&measure="+key+"&factor="+factVal+"&dbsize="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(value),"UTF-8")+"&unit="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(tmpUnit),"UTF-8")+"&index="+tmpInd+"&from=EgConfigTestMeasure.jsp&alarmdescription="+alrmMsg;
			String deleteURL = "EgconfigtestmeasurepJson.jsp?add=del&test="+test+"&measure="+key;
			obj.put("modifyURL",modifyURL);
			obj.put("deleteURL",deleteURL);

			if(!isConfigTest)
			{
				String tempVal;
				tempVal = mappingInfo.getTextDescription("admin.ic."+value.substring(0,value.indexOf("(")));
				value=tempVal+value.substring(value.indexOf("("),value.length());
				obj.put("databaseColumnSize",value);
				obj.put("unit",unit);

				if(factVal != null && factVal.length() > 0 && !factVal.equals("none"))
				{
					obj.put("hideConversionFactor",false);
					obj.put("conversionFactor",factorsMapping.get(factVal).toString());
				}
				else
				{
					obj.put("hideConversionFactor",true);
				}
				if((alarm_msg != null && alarm_msg.length()>0) )
				{
					obj.put("hideAlarmDispStr",false);
					obj.put("alarmDispString",alarm_msg);
				}
				else
				{
					obj.put("hideAlarmDispStr",true);
				}
			}
			measureList.add(obj);
		}
		rootJSON.put("measuresList",measureList);
		//New code for remote upload test start
		hiddens.put("test",test);
		hiddens.put("uploadType",uploadtype);
		hiddens.put("libPath",lib);
		hiddens.put("classPath","");
		hiddens.put("measure",key);
		//New code for remote upload test end
		rootJSON.put("path",path);
		rootJSON.put("libFile",lib);
		if(lib != null && lib.length() > 0)
		{
			rootJSON.put("loadLibChecked",true);
		}
		else
		{
			rootJSON.put("loadLibChecked",false);
		}
					
		if(!isConfigTest)
		{
			String checked="";
			value = udMeasures.getValue("MEASURES", test);
			List measureValues = new LinkedList();
			if (!StringUtils.isNull(value))
			{
				String[] tokens = StringUtils.getTokens(value, "#");
				for (int a=0; a<tokens.length; a++)
				{
					measureValues.add(tokens[a].substring(0, tokens[a].indexOf(EgConstants.COLON)));
				}
			}

			if (measureValues.size() > 0)
			{
				IniFile formatIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_format.ini");
				String[] tests = formatIni.getVariables("FORMAT");
				for (int a =0; a<measureValues.size(); a++)
				{
					value = formatIni.getValue("FORMAT", test+":"+measureValues.get(a));
					if (!StringUtils.isNull(value))
					{
						checked = "checked";
						break;
					}
				}
			}
			rootJSON.put("ddForMeasureCheck",checked);
		}
		else
		{
			int ss=getConfigTestSizeIndex(iConfigFieldSize);
			JSONArray dbCols = new JSONArray();
			String[] dbColsDisp = new String[]{"32","64","128","256","512","1024"};
			String[] dbColsVal = new String[]{"1","2","3","4","5","6"};
			for (int i=0; i<dbColsDisp.length; i++)
			{
				obj = new JSONObject();
				obj.put("displayField",dbColsDisp[i]);
				obj.put("valueField",dbColsVal[i]);
				dbCols.add(obj);
			}
			rootJSON.put("dbColSizeList",dbCols);
			rootJSON.put("dbColSizeSelected",ss+"");
			rootJSON.put("descriptorBasedTestCheck",bDescriptorBasedTest?"checked":"");
		}
		hiddens.put("add","gen");
		hiddens.put("test",test);
	}	//else block
	hiddens.put("configtestflag",isConfigTest?"true":"");
	rootJSON.put("measIndex",(++i_mes_count)+"");

	String flag1 = request.getParameter("flag1");
	if (flag1 != null && flag1.equals("true"))
	{
		rootJSON.put("measNameValue",mname);
	}
	else
	{
		rootJSON.put("measNameValue","");
	}
	if(!isConfigTest)
	{
		JSONArray dbCols = new JSONArray();
		String num = _mapping.getTextDescription("admin.ic.Number");
		String[] dbColsDisp = new String[]{num+"(20,4)",num+"(7,4)",num+"(16)"};
		String[] dbColsVal = new String[]{"2","1","3"};
		for (int i=0; i<dbColsDisp.length; i++)
		{
			obj = new JSONObject();
			obj.put("displayField",dbColsDisp[i]);
			obj.put("valueField",dbColsVal[i]);
			dbCols.add(obj);
		}
		rootJSON.put("dbColSizeList",dbCols);
		rootJSON.put("dbColSizeSelected",dbsize);
		if(unitValue == null || unitValue.length() == 0)
		{
			JSONArray unitsArr = new JSONArray();
			obj = new JSONObject();
			obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a unit"));
			obj.put("valueField","-1");
			unitsArr.add(obj);
			if(units != null && units.size() > 0)
			{
				for(int i=0; i<units.size(); i++)
				{
					String un = (String) units.get(i);
				//	if(un.equals("%"))
				//		continue;
					obj = new JSONObject();
					obj.put("displayField",un);
					obj.put("valueField",un);
					unitsArr.add(obj);
				}
			}
			obj = new JSONObject();
			obj.put("displayField",_mapping.getTextDescription("admin.ic.Other"));
			obj.put("valueField","other");
			unitsArr.add(obj);
			rootJSON.put("unitsList",unitsArr);
		}
		else if(!unitValue.equals("other"))
		{
			JSONArray unitsArr = new JSONArray();
			obj = new JSONObject();
			obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a unit"));
			obj.put("valueField","-1");
			unitsArr.add(obj);
			if(units != null && units.size() > 0)
			{
				for(int i=0; i<units.size(); i++)
				{
					String un = (String) units.get(i);
				//	if(un.equals("%"))
				//		continue;
					if(un.equals(unitValue))
					{
						rootJSON.put("unitSelected",un);
					}
					obj = new JSONObject();
					obj.put("displayField",un);
					obj.put("valueField",un);
					unitsArr.add(obj);
				}
			}
			obj = new JSONObject();
			obj.put("displayField",_mapping.getTextDescription("admin.ic.Other"));
			obj.put("valueField","other");
			unitsArr.add(obj);
			rootJSON.put("unitsList",unitsArr);
		}
		else
		{
			otherCount="1";
			JSONArray unitsArr = new JSONArray();
			obj = new JSONObject();
			obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a unit"));
			obj.put("valueField","-1");
			unitsArr.add(obj);

			if(units != null && units.size() > 0)
			{
				for(int i=0; i<units.size(); i++)
				{
					String un = (String) units.get(i);
				//	if(un.equals("%"))
				//		continue;
					obj = new JSONObject();
					obj.put("displayField",un);
					obj.put("valueField",un);
					unitsArr.add(obj);
				}
			}
			obj = new JSONObject();
			obj.put("displayField",_mapping.getTextDescription("admin.ic.Other"));
			obj.put("valueField","other");
			unitsArr.add(obj);
			rootJSON.put("unitsList",unitsArr);
			rootJSON.put("showOtherTextBox",true);
		}

		JSONArray convFacts = new JSONArray();
		String tmpFact = "none";
		for(int i=0; i<factors.length; i++)
		{
			String fact = iniUI.getValue("CONVERSION_FACTORS", factors[i].toString());
			String tmpSel = factorSel[i];
			
			if(tmpSel.equals("selected"))
			{
				tmpFact = fact;
				rootJSON.put("convFactorSelected",fact);
			}
			obj = new JSONObject();
			obj.put("valueField",fact);
			obj.put("displayField",factors[i].toString());
			convFacts.add(obj);
		}
		rootJSON.put("convFactorList",convFacts);
		hiddens.put("factor",tmpFact);
		String alarmDisplay= request.getParameter("alarmDisplay");
		if (alarmDisplay == null)
		{
			alarmDisplay = "";
		}
		rootJSON.put("alarmDispStrValue",alarmDisplay);
	}
	hiddens.put("add","add");
	hiddens.put("test",test);
	hiddens.put("checkOtherCount",otherCount);
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>

<%
//session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigTestMeasure.jsp?"+request.getQueryString());
%>






