Ext.define('ICTestExportImport.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'icexportimportconfig', ref:'icexportimportconfig'},
		{selector:'downloadutils', ref:'downloadutils'}
	],
	init:function(){
		me = this,
		this.control({
			'icexportimportconfig':
			{
				'afterrender': this.loadGridChanges
			},
			'icexportimportconfig combobox[id="exportTestTypeCombo"]' :
			{
				'select' : this.loadGridChanges
			},
			'icexportimportconfig button[id="icExportBtn"]':
			{
				'click': this.exportICData
			},
			'icexportimportconfig tabpanel[id="icexportimportTab"]':
			{
				'tabchange': this.tabChange
			},
			'icexportimportconfig combobox[id="importTestTypeCombo"]' :
			{
				'select' : this.loadImportGridData
			},
			'icexportimportconfig button[id="icImportBtn"]':
			{
				'click': this.importICData
			},
			'icexportimportconfig button[id="cancelBtn"]':
			{
				'click':this.removeUploadData
			},
			'icexportimportconfig trigger[id="searchBox"]':
			{
				'change': this.searchTest
			},
			'icexportimportconfig trigger[id="searchBoxImport"]':
			{
				'change': this.searchImportTest
			},
			'icexportimportconfig button[id="uploadBtn"]':
			{
				'click':this.uploadSelectedData
			}
		});
	},
	tabChange: function(type)
	{
		var me = this;
		var testSelected = false;
		var selectTab = Ext.getCmp('icexportimportTab').getActiveTab().getItemId();
		var viewStoreObj = Ext.getCmp('icExpImpGrid');
		var storeObj = viewStoreObj.getStore();
		var selectionModelObj = viewStoreObj.getSelectionModel();
		if(selectionModelObj.getSelection().length > 0)
			testSelected = true;

		if(selectTab == 'icTestExportTab')
		{
			this.afterMainRender();
		}
		else if (selectTab == 'icTestImportTab')
		{
			this.removeUploadData();
			Ext.getCmp('searchBox').setValue('');
			var rowIndex=0;
			while(typeof(Ext.getCmp('icExpImpGrid').getStore().getAt(rowIndex))!='undefined') {
				var record = Ext.getCmp('icExpImpGrid').getStore().getAt(rowIndex);
				Ext.getCmp('icExpImpGrid').getSelectionModel().deselect(rowIndex, true);
				rowIndex++;
			}
		}
		Ext.Ajax.request({
			url: 'ExportImport/data/exportimporthelpJson.jsp?selectTab='+selectTab,
			method: 'POST',
			async: false
		});
	},
	removeUploadData: function()
	{
		if (Ext.getCmp('icImportGrid').isVisible())
		{
			Ext.getCmp('icImportGrid').hide();
		}
		if (Ext.getCmp('importBtnContainer').isVisible())
		{
			Ext.getCmp('importBtnContainer').hide();
		}
		Ext.getCmp('uploadFileContainer').show();
	},

	searchTest : function()
	{
		var me = this;
		var searchValue = Ext.getCmp('searchBox').getValue();
		var selectedTestType = Ext.getCmp('exportTestTypeCombo').getRawValue();
		if (searchValue == "" || searchValue.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url : 'ICTestExportImport/data/EgIcExportConfigureFilesJson.jsp?',
			params :
			{
				'searchValue' : searchValue,
				'selectedTestType' : selectedTestType,
				'reqFrom' : 'searchTest'
			},
			method : 'POST',
			async: false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var rowIndex=0;
					while(typeof(Ext.getCmp('icExpImpGrid').getStore().getAt(rowIndex))!='undefined') {
						var record = Ext.getCmp('icExpImpGrid').getStore().getAt(rowIndex);
						Ext.getCmp('icExpImpGrid').getSelectionModel().deselect(rowIndex, true);
						rowIndex++;
					}

					var emptyMsg = 'No test(s) found for your current search';
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					Ext.getCmp('icExpImpGrid').getStore().removeAll();
					var searchGrid = jsonData['SearchGridData'];
					if(searchGrid != null && searchGrid != '')
					{
						Ext.getCmp('icExpImpGrid').getStore().loadRawData(searchGrid);
					}
					else
					{
						var gridView = Ext.getCmp('icExpImpGrid').getView();
						gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
						gridView.refresh();
					}
				}
			}
		});
	},
	searchImportTest : function()
	{
		var me = this;
		var searchValue = Ext.getCmp('searchBoxImport').getValue();
		var hiddenFieldVal = Ext.getCmp('hiddenFieldImport').getValue();
		var selectedTestType = Ext.getCmp('importTestTypeCombo').getRawValue();

		if (searchValue == "" || searchValue.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url : 'ICTestExportImport/data/EgICImportConfigureFilesJson.jsp?',
			params :
			{
				'searchValue' : searchValue,
				'selectedTestType' : selectedTestType,
				'fileName' : hiddenFieldVal,
				'reqFrom' : 'searchTest'
			},
			method : 'POST',
			async: false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var rowIndex=0;
					while(typeof(Ext.getCmp('icExpImpGrid').getStore().getAt(rowIndex))!='undefined') {
						var record = Ext.getCmp('icExpImpGrid').getStore().getAt(rowIndex);
						Ext.getCmp('icExpImpGrid').getSelectionModel().deselect(rowIndex, true);
						rowIndex++;
					}

					var emptyMsg = 'No test(s) found for your current search';
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					Ext.getCmp('icImportGrid').getStore().removeAll();
					var searchGrid = jsonData['SearchGridData'];
					if(searchGrid != null && searchGrid != '')
					{
						Ext.getCmp('icImportGrid').getStore().loadRawData(searchGrid);
					}
					else
					{
						var gridView = Ext.getCmp('icImportGrid').getView();
						gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
						gridView.refresh();
					}
				}
			}
		});
	},
	loadGridChanges : function()
	{
		var testTypeVal = Ext.getCmp('exportTestTypeCombo').getRawValue();
		Ext.Ajax.request({
			url: 'ICTestExportImport/data/EgIcExportConfigureFilesJson.jsp?selectedTestType='+encodeURIComponent(testTypeVal)+"&reqFrom="+encodeURIComponent("loadData"),
			method : 'POST',
			async : false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					var testTypeCombo = jsonData['testTypeCombo'];
					var emptyMsg = jsonData['screenLabels']['No_Data_Msg'];
					Ext.getCmp('exportTestTypeCombo').getStore().loadRawData(testTypeCombo);
					if(testTypeVal == "All")
					{
						var allTestGridData = jsonData['AllTestTypeGrid'];
						if(allTestGridData != null && allTestGridData != '' && allTestGridData != undefined)
						{
							Ext.getCmp('icExpImpGrid').getStore().loadRawData(allTestGridData);
						}
						else
						{
							Ext.getCmp('icExpImpGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icExpImpGrid').getView();
							gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "Custom")
					{
						var customTestGridData = jsonData['CustomTestTypeGrid'];
						if(customTestGridData != null && customTestGridData != '' && customTestGridData != undefined)
						{
							Ext.getCmp('icExpImpGrid').getStore().loadRawData(customTestGridData);
						}
						else
						{
							Ext.getCmp('icExpImpGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icExpImpGrid').getView();
							gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "Script/Batch File")
					{
						var scriptTestGridData = jsonData['ScriptTestTypeGrid'];
						if(scriptTestGridData != null && scriptTestGridData != '' && scriptTestGridData != undefined)
						{
							Ext.getCmp('icExpImpGrid').getStore().loadRawData(scriptTestGridData);
						}
						else
						{
							Ext.getCmp('icExpImpGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icExpImpGrid').getView();
							gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "SQL Query")
					{
						var sqlTestGridData = jsonData['SqlTestTypeGrid'];
						if(sqlTestGridData != null && sqlTestGridData != '' && sqlTestGridData != undefined)
						{
							Ext.getCmp('icExpImpGrid').getStore().loadRawData(sqlTestGridData);
						}
						else
						{
							Ext.getCmp('icExpImpGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icExpImpGrid').getView();
							gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}

					}
					else if(testTypeVal == "Perfmon")
					{
						var perfmonTestGridData = jsonData['PerfmonTestTypeGrid'];
						if(perfmonTestGridData != null && perfmonTestGridData != '' && perfmonTestGridData != undefined)
						{
							Ext.getCmp('icExpImpGrid').getStore().loadRawData(perfmonTestGridData);
						}
						else
						{
							Ext.getCmp('icExpImpGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icExpImpGrid').getView();
							gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "SNMP")
					{
						var snmpTestGridData = jsonData['SnmpTestTypeGrid'];
						if(snmpTestGridData != null && snmpTestGridData != '' && snmpTestGridData != undefined)
						{
							Ext.getCmp('icExpImpGrid').getStore().loadRawData(snmpTestGridData);
						}
						else
						{
							Ext.getCmp('icExpImpGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icExpImpGrid').getView();
							gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "Jmx")
					{
						var jmxTestGridData = jsonData['JmxTestTypeGrid'];
						if(jmxTestGridData != null && jmxTestGridData != '' && jmxTestGridData != undefined)
						{
							Ext.getCmp('icExpImpGrid').getStore().loadRawData(jmxTestGridData);
						}
						else
						{
							Ext.getCmp('icExpImpGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icExpImpGrid').getView();
							gridView.emptyText = '<table height="250" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
				}
			}
		});
	},
	afterMainRender: function()
	{
		me= this;
		Ext.Ajax.request({
			url:'ICTestExportImport/data/EgIcExportConfigureFilesJson.jsp?',
			params : 
			{
				'selectedTestType' : "All",
				'reqFrom' : 'loadData'
			},
			method:'post',	
			scope:this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var exportgridData = publicJson['testTypeCombo'];
					Ext.getCmp('exportTestTypeCombo').getStore().loadRawData(exportgridData);
					me.loadGridChanges();
				}
			}
		});
	},
	exportICData : function(btn)
	{
		var viewStoreObj = Ext.getCmp('icExpImpGrid');
		var storeObj = viewStoreObj.getStore();
		var noOfRecords = storeObj.getCount();
		var selectionModelObj = viewStoreObj.getSelectionModel();
		if(noOfRecords > 0)
		{
			var testSelected = false;
			var testName = "";
			var testType = "";
			var exportData = "";
			var totalVal = "";
			if(selectionModelObj.getSelection().length > 0)
				testSelected = true;
			if(testSelected)
			{
				var selectedTest = selectionModelObj.getSelection();
				for(var i = 0;i< selectedTest.length; i++)
				{
					var exportTest = selectedTest[i];
					testName = exportTest.get('testName');
					totalVal = testName + ",";
					exportData += totalVal;
				}
				var qString = "selectedIC="+encodeURIComponent(exportData)+"&requestFrom="+encodeURIComponent("ICTests");
				var s_qryString = "/final/servlet/com.egurkha.admin.EgICExportConfigureServlet?"+qString;
				var downloadUtils =  Ext.widget('downloadutils');
				downloadUtils.savePDF(s_qryString);
			}
			else
			{
				Ext.Msg.show({
					title: pageName,
					msg: alert5,
					width: alert5.length * 7,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}
	},
	uploadSelectedData: function()
	{
		me = this;
		var fileName = Ext.getCmp('icImportFileField').getValue();
		var testTypeVal = Ext.getCmp('importTestTypeCombo').getRawValue();
		var fileExt = ".zip";
		var hiddenFieldVal = Ext.getCmp('hiddenFieldImport').setValue(fileName);

		if(fileName.lastIndexOf(".zip") == -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert1+" '"+fileExt+"'",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('icImportFileField').reset();
			Ext.getCmp('icImportFileField').focus();
			return;
		}
		var frmMain = this.getIcexportimportconfig().getForm();
		if (frmMain.isValid())
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
			myMask.show();
			this.getIcexportimportconfig().submit({
				url: 'ICTestExportImport/data/EgICImportConfigureFilesJson.jsp?fileName='+encodeURIComponent(fileName)+"&selectedTestType="+encodeURIComponent(testTypeVal)+"&reqFrom="+encodeURIComponent("loadData")+"&com.eg.CSRF_NONCE="+csrfToken,
				method: 'POST',
				success: function(form, action){
					myMask.hide();
					var jsonText = action.response.responseText;
					publicJson = Ext.decode(jsonText);
					var validZipFile = publicJson['validZipFile'];
					if(validZipFile=="true")
					{
						Ext.getCmp('importTestTypeCombo').show();
						var testTypeCombo = publicJson['testTypeCombo'];
						Ext.getCmp('importTestTypeCombo').getStore().loadRawData(testTypeCombo);
						var emptyMsg = publicJson['screenLabels']['emptyTextMsg'];

						if(testTypeVal == "All")
						{
							var allTestGridData = publicJson['AllTestTypeGrid'];
							if(allTestGridData != null && allTestGridData != '' && allTestGridData != undefined)
							{
								Ext.getCmp('icImportGrid').getStore().loadRawData(allTestGridData);
							}
							else
							{
								Ext.getCmp('icImportGrid').getStore().removeAll();
								var gridView = Ext.getCmp('icImportGrid').getView();
								gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
								gridView.refresh();
							}
						}
						else if(testTypeVal == "Custom")
						{
							var customTestGridData = publicJson['CustomTestTypeGrid'];
							if(customTestGridData != null && customTestGridData != '' && customTestGridData != undefined)
							{
								Ext.getCmp('icImportGrid').getStore().loadRawData(customTestGridData);
							}
							else
							{
								Ext.getCmp('icImportGrid').getStore().removeAll();
								var gridView = Ext.getCmp('icImportGrid').getView();
								gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
								gridView.refresh();
							}
						}
						else if(testTypeVal == "Script/Batch File")
						{
							var scriptTestGridData = publicJson['ScriptTestTypeGrid'];
							if(scriptTestGridData != null && scriptTestGridData != '' && scriptTestGridData != undefined)
							{
								Ext.getCmp('icImportGrid').getStore().loadRawData(scriptTestGridData);
							}
							else
							{
								Ext.getCmp('icImportGrid').getStore().removeAll();
								var gridView = Ext.getCmp('icImportGrid').getView();
								gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
								gridView.refresh();
							}
						}
						else if(testTypeVal == "SQL Query")
						{
							var sqlTestGridData = publicJson['SqlTestTypeGrid'];
							if(sqlTestGridData != null && sqlTestGridData != '' && sqlTestGridData != undefined)
							{
								Ext.getCmp('icImportGrid').getStore().loadRawData(sqlTestGridData);
							}
							else
							{
								Ext.getCmp('icImportGrid').getStore().removeAll();
								var gridView = Ext.getCmp('icImportGrid').getView();
								gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
								gridView.refresh();
							}
						}
						else if(testTypeVal == "Perfmon")
						{
							var perfmonTestGridData = publicJson['PerfmonTestTypeGrid'];
							if(perfmonTestGridData != null && perfmonTestGridData != '' && perfmonTestGridData != undefined)
							{
								Ext.getCmp('icImportGrid').getStore().loadRawData(perfmonTestGridData);
							}
							else
							{
								Ext.getCmp('icImportGrid').getStore().removeAll();
								var gridView = Ext.getCmp('icImportGrid').getView();
								gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
								gridView.refresh();
							}
						}
						else if(testTypeVal == "SNMP")
						{
							var snmpTestGridData = publicJson['SnmpTestTypeGrid'];
							if(snmpTestGridData != null && snmpTestGridData != '' && snmpTestGridData != undefined)
							{
								Ext.getCmp('icImportGrid').getStore().loadRawData(snmpTestGridData);
							}
							else
							{
								Ext.getCmp('icImportGrid').getStore().removeAll();
								var gridView = Ext.getCmp('icImportGrid').getView();
								gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
								gridView.refresh();
							}
						}
						else if(testTypeVal == "Jmx")
						{
							var jmxTestGridData = publicJson['JmxTestTypeGrid'];
							if(jmxTestGridData != null && jmxTestGridData != '' && jmxTestGridData != undefined)
							{
								Ext.getCmp('icImportGrid').getStore().loadRawData(jmxTestGridData);
							}
							else
							{
								Ext.getCmp('icImportGrid').getStore().removeAll();
								var gridView = Ext.getCmp('icImportGrid').getView();
								gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
								gridView.refresh();
							}
						}
						//me.loadImportGridData(fileName);
						Ext.getCmp('icImportGrid').show();
						Ext.getCmp('uploadFileContainer').hide();
						Ext.getCmp('importBtnContainer').show();
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg: alertZipMsg,
							width: alertZipMsg.length * 7,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						Ext.getCmp('uploadFileContainer').show();
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					var jsonText = Ext.decode(action.response.responseText);
					var jsonText = action.response.responseText;
					publicJson = Ext.decode(jsonText);
					var isNoData = publicJson['isNoData'];
					var alertMsg = publicJson['screenLabels']['No_Data_Msg'];
					if(!Ext.isEmpty(isNoData) && isNoData)
					{
						Ext.Msg.show({
							title: pageName,
							msg: alertMsg,
							width: alertMsg.length * 7,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			});
		}
	},
	importICData : function()
	{
		var viewStoreImpObj = Ext.getCmp('icImportGrid');
		var storeObj = viewStoreImpObj.getStore();
		var noOfRecords = storeObj.getCount();
		var selectionModelObj = viewStoreImpObj.getSelectionModel();
		//var hiddenFieldVal = Ext.getCmp('hiddenFieldImport').getValue();
		var fileName = publicJson['folderName'];
		if(noOfRecords > 0)
		{
			var testSelected = false;
			var testName = "";
			var testType = "";
			var importData = "";
			if(selectionModelObj.getSelection().length > 0)
				testSelected = true;
			if(testSelected)
			{
				var selectedTest = selectionModelObj.getSelection();
				for(var i = 0;i< selectedTest.length; i++)
				{
					var exportTest = selectedTest[i];
					testName = exportTest.get('testName');
					importData += testName + "," ;
				}
				var urlStr =  'ICTestExportImport/data/EgICImportConfigurefilesp.jsp?selectedTest='+encodeURIComponent(importData)+"&folderName="+encodeURIComponent(fileName)+"&requestFrom="+encodeURIComponent("overwriteImportData");
				Ext.Ajax.request(
				{
					url : 'ICTestExportImport/data/EgICImportConfigurefilesp.jsp',
					params :
					{
						'selectedTest' : importData,
						'folderName' : fileName,
						'requestFrom' : 'validateImportData'
					},
					method : 'POST',
					success : function(response)
					{
						var jsonText = response.responseText;
						validataJsonData = Ext.decode(jsonText);
						var result = validataJsonData['IcTestExist'];
						var isValidImport = validataJsonData['isValidImport'];

						var testVal = validataJsonData['ExistingTestNameArr'];
						if(isValidImport)
						{
							if(result != null && result != undefined && result == 'true')
							{
								Ext.MessageBox.confirm({
									title: pageName,
									msg:valAlert,
									buttons: Ext.Msg.YESNO,
									icon: 'iconInformation',
									fn: function(btn)
									{
										if(btn == 'yes')
										{
											var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
											myMask.show();
											Ext.Ajax.request({
												url:urlStr,
												method:'POST',
												scope:this,
												//async: false,
												timeout: 600000000,
												success:function(response)
												{
													if(response.status == 200 && !Ext.isEmpty(response.responseText))
													{
														myMask.hide();
														var jsonText = Ext.decode(response.responseText);
														Ext.Msg.show({
															title: pageName,
															msg: alert3,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function() {
																me.removeUploadData();
															}
														});
													}
												}
											});
										}
										else
										{
											var urlVal =  'ICTestExportImport/data/EgICImportConfigurefilesp.jsp?selectedTest='+encodeURIComponent(importData)+"&folderName="+encodeURIComponent(fileName)+"&requestFrom="+encodeURIComponent("nonOverwriteImportData")+"&existTestsVal="+encodeURIComponent(testVal);

											if(!selectedTest.length == 1)
											{
												var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
												myMask.show();
												Ext.Ajax.request({
													url:urlVal,
													method:'POST',
													scope:this,
													//async: false,
													timeout: 600000000,
													success:function(response)
													{
														if(response.status == 200 && !Ext.isEmpty(response.responseText))
														{
															myMask.hide();
															var jsonText = Ext.decode(response.responseText);
															Ext.Msg.show({
																title: pageName,
																msg: alert3,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function() {
																	me.removeUploadData();
																}
															});
														}
													}
												});
											}
											else
											{
												me.removeUploadData();
											}
										}
									}
								});
							}
							else
							{
								Ext.MessageBox.confirm({
									title: pageName,
									msg:alert6,
									buttons: Ext.Msg.YESNO,
									icon: 'iconInformation',
									fn : function(btn)
									{
										if(btn == 'yes')
										{
											var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
											myMask.show();
											Ext.Ajax.request({
												url:urlStr,
												method:'POST',
												scope:this,
												//async: false,
												timeout: 600000000,
												success:function(response)
												{
													if(response.status == 200 && !Ext.isEmpty(response.responseText))
													{
														myMask.hide();
														var jsonText = Ext.decode(response.responseText);
														Ext.Msg.show({
															title: pageName,
															msg: alert3,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function() {
																me.removeUploadData();
															}
														});
													}
												}
											});
										}
										else
										{
											me.removeUploadData();
										}
									}
								});
							}

						}
						else
						{
							Ext.Msg.show({
								title: pageName,
								msg: alert9,
								width: alert9.length * 7,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									me.removeUploadData();
								}
							});
							return false;
						}
					}
				});
			}
			else
			{
				Ext.Msg.show({
					title: pageName,
					msg: alert4,
					width: alert4.length * 7,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}
	},
	/*loadImportGridData : function(fileName)
	{
		var testTypeVal = Ext.getCmp('importTestTypeCombo').getRawValue();
		var hiddenFieldVal = Ext.getCmp('hiddenFieldImport').getValue();
		Ext.Ajax.request({
			url: 'ICTestExportImport/data/EgICImportConfigureFilesJson.jsp?fileName='+encodeURIComponent(hiddenFieldVal)+"&selectedTestType="+encodeURIComponent(testTypeVal)+"&reqFrom="+encodeURIComponent("loadData"),
			method : 'POST',
			async : false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var emptyMsg = publicJson['screenLabels']['emptyTextMsg'];

					if(testTypeVal == "All")
					{
						var allTestGridData = publicJson['AllTestTypeGrid'];
						if(allTestGridData != null && allTestGridData != '' && allTestGridData != undefined)
						{
							Ext.getCmp('icImportGrid').getStore().loadRawData(allTestGridData);
						}
						else
						{
							Ext.getCmp('icImportGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icImportGrid').getView();
							gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "Custom")
					{
						var customTestGridData = publicJson['CustomTestTypeGrid'];
						if(customTestGridData != null && customTestGridData != '' && customTestGridData != undefined)
						{
							Ext.getCmp('icImportGrid').getStore().loadRawData(customTestGridData);
						}
						else
						{
							Ext.getCmp('icImportGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icImportGrid').getView();
							gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "Script/Batch File")
					{
						var scriptTestGridData = publicJson['ScriptTestTypeGrid'];
						if(scriptTestGridData != null && scriptTestGridData != '' && scriptTestGridData != undefined)
						{
							Ext.getCmp('icImportGrid').getStore().loadRawData(scriptTestGridData);
						}
						else
						{
							Ext.getCmp('icImportGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icImportGrid').getView();
							gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "SQL Query")
					{
						var sqlTestGridData = publicJson['SqlTestTypeGrid'];
						if(sqlTestGridData != null && sqlTestGridData != '' && sqlTestGridData != undefined)
						{
							Ext.getCmp('icImportGrid').getStore().loadRawData(sqlTestGridData);
						}
						else
						{
							Ext.getCmp('icImportGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icImportGrid').getView();
							gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "Perfmon")
					{
						var perfmonTestGridData = publicJson['PerfmonTestTypeGrid'];
						if(perfmonTestGridData != null && perfmonTestGridData != '' && perfmonTestGridData != undefined)
						{
							Ext.getCmp('icImportGrid').getStore().loadRawData(perfmonTestGridData);
						}
						else
						{
							Ext.getCmp('icImportGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icImportGrid').getView();
							gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "SNMP")
					{
						var snmpTestGridData = publicJson['SnmpTestTypeGrid'];
						if(snmpTestGridData != null && snmpTestGridData != '' && snmpTestGridData != undefined)
						{
							Ext.getCmp('icImportGrid').getStore().loadRawData(snmpTestGridData);
						}
						else
						{
							Ext.getCmp('icImportGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icImportGrid').getView();
							gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
					else if(testTypeVal == "Jmx")
					{
						var jmxTestGridData = publicJson['JmxTestTypeGrid'];
						if(jmxTestGridData != null && jmxTestGridData != '' && jmxTestGridData != undefined)
						{
							Ext.getCmp('icImportGrid').getStore().loadRawData(jmxTestGridData);
						}
						else
						{
							Ext.getCmp('icImportGrid').getStore().removeAll();
							var gridView = Ext.getCmp('icImportGrid').getView();
							gridView.emptyText = '<table height="200" width="100%"><tr><td align=center><img src="/final/images/spacer.gif" class="iconInformation"><div class="commonErrorMsgText">' + emptyMsg + '.</div></td></tr></table>';
							gridView.refresh();
						}
					}
				}
			}
		});
	}*/
});
