Ext.define('IncludeExcludeComponents.controller.Main',{
	extend:'Ext.app.Controller',

	views:['FormItems'],

	refs:[
		{
			selector: 'formitems',
			ref: 'formitems'
		},
	],

	init:function(){
		appCtrl = this;
		this.buildMainData()

		this.control({
			'formitems': {
				'afterrender': this.afterMainRender
			},
			'formitems combo[id="compType"]': {
				'select': this.comboLoad
			},
			'formitems combo[id="testType"]': {
				'select': this.comboLoad
			},
			'formitems multiselectSi[id="components"]': {
				'change': this.getDataLoad
			},
			'formitems combo[itemId="components"]': {
				'select': this.getDataLoad
			},
			'formitems button[id="UpdateBTN"]': {
				'click': this.updation
			}
		});
	},

	buildMainData: function() {
		Ext.Ajax.request({
			url: 'IncludeExcludeComponents/data/EgIncludeExcludeComponentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	emptyLoad: function(isCtrlPressed) {
		var selTest = Ext.getCmp('components').getValue();
		var getSelectedTest = selTest;
		if (selTest.length == 1 && isCtrlPressed && getSelectedTest == selTest)
		{
			if (Ext.getCmp('itemselectComp').fromField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectComp').fromField.store.removeAll();
			}
			if (Ext.getCmp('itemselectComp').toField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectComp').toField.store.removeAll();
			}
		}
	},

	comboLoad: function() {
		var componentType = Ext.getCmp('compType').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == false )
		{
			testType = "PerformanceTest";
		}
		Ext.Ajax.request({
			url: 'IncludeExcludeComponents/data/EgIncludeExcludeComponentsJson.jsp?componentType='+encodeURIComponent(componentType)+'&testType='+testType,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}

				var componentsAllowedLimitsExceed = publicJSON['componentsAllowedLimitsExceed'];
				if (!Ext.isEmpty(componentsAllowedLimitsExceed) && componentsAllowedLimitsExceed)
				{
					Ext.getCmp('multiSelCont').hide();
					Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].setDisabled(false);
					Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].show();
					Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].getStore().loadRawData(publicJSON['TestName']);
					Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].setValue(publicJSON['TestName'][0].valueField);
				}
				else
				{
					Ext.getCmp('multiSelCont').show();
					Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].hide();
					Ext.getCmp('components').setDisabled(false);
					Ext.getCmp('components').getStore().loadRawData(publicJSON['TestName']);
				}
				if (Ext.getCmp('itemselectComp').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectComp').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectComp').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectComp').toField.store.removeAll();
				}

				Ext.getCmp('itemselectComp').fromField.store.add(publicJSON['includedArray']);
				Ext.getCmp('itemselectComp').toField.store.add(publicJSON['excludedArray']);
			}
		});
	},

	getDataLoad: function() {
		var loadSelector = this;
		var componentsAllowedLimitsExceed = publicJSON['componentsAllowedLimitsExceed'];

		var testComboObj = Ext.getCmp('components');
		if (!Ext.isEmpty(componentsAllowedLimitsExceed) && componentsAllowedLimitsExceed)
		{
			testComboObj = Ext.ComponentQuery.query('combo[itemId="components"]')[0];
		}

		var disabledTestList = testComboObj.getValue();
		var componentType = Ext.getCmp('compType').getValue();
		if (Ext.isEmpty(disabledTestList) || disabledTestList.length == 0)
		{
			return;
		}

		var userTest = publicJSON['usrBasedTests'];
		var namedUserTest = '';
		var userTestStr = '';
		var userTestToken = '';
		if (userTest != undefined && userTest.length > 0)
		{
			userTestStr = userTest.toString();
			userTestToken = userTestStr.split(",");
		}

		var isNamedUser = false;
		var isRumParentTest = false;
		var disableArr = new Array();
		var namedUserValue = '';
		var webDispName = '';

		for (var j=0;j<userTestToken.length ;j++)
		{
			for (var k=0;k<disabledTestList.length ;k++)
			{
				if (disabledTestList[k] == userTestToken[j])
				{
					isNamedUser = true;
					var displayIndex = testComboObj.getStore().find('valueField',userTestToken[j],0,false,true,true);
					var dispName = testComboObj.getStore().getAt(displayIndex).get('displayField');
					var dispValue = testComboObj.getStore().getAt(displayIndex).get('valueField');
					namedUserTest += ","+dispName;
					namedUserValue += ","+dispValue;
				}
			}
		}
		for (var k=0;k<disabledTestList.length ;k++)
		{
			if (!Ext.isEmpty(componentType) && componentType == 'Real_user_monitor')
			{
				if (!Ext.isEmpty(disabledTestList[k]) && disabledTestList[k] == 'RUMAppTest')
				{
					isRumParentTest = true;
					var dispIndex = testComboObj.getStore().find('valueField',disabledTestList[k],0,false,true,true);
					var dispName = testComboObj.getStore().getAt(dispIndex).get('displayField');
					webDispName = dispName;
				}
				
				if (!Ext.isEmpty(disabledTestList[k]) && disabledTestList[k] != 'RUMAppTest')
				{
					disableArr[disableArr.length] = disabledTestList[k];
				}
				else
				{
					continue;
				}
			}
			else if (namedUserValue.indexOf(disabledTestList[k]) == -1)
			{
				disableArr[disableArr.length] = disabledTestList[k];
			}
			else
			{
				continue;
			}
		}

		if (isRumParentTest)
		{
			if (disabledTestList.length == 1)
			{
				if (Ext.getCmp('itemselectComp').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectComp').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectComp').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectComp').toField.store.removeAll();
				}
				Ext.Msg.show(
				{
					title : pageTitle,
					msg : webDispName+ ' test cannot be excluded.',
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
			}
			else
			{
				Ext.Msg.show(
				{
					title : pageTitle,
					msg : webDispName+ ' test cannot be excluded.',
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
			}
		}
		
		if (isNamedUser)
		{
			if (disabledTestList.length == 1)
			{
				if (Ext.getCmp('itemselectComp').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectComp').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectComp').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectComp').toField.store.removeAll();
				}
				Ext.Msg.show(
				{
					title : pageTitle,
					msg : publicJSON['screenLabels']['NamedUserAlert']+publicJSON['screenLabels']['NamedUserAlertName']+" "+namedUserTest.substring(1),
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
			}
			else
			{
				Ext.Msg.show(
				{
					title : pageTitle,
					msg : publicJSON['screenLabels']['NamedUserAlert']+publicJSON['screenLabels']['NamedUserAlertName']+" "+namedUserTest.substring(1),
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
			}
		}
		
		var componentType = Ext.getCmp('compType').getValue();
		
		var testType = Ext.getCmp('testType').getValue();
		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == false )
		{
			testType = "PerformanceTest";
		}
		var selectTest = testComboObj.getValue();

		var selectedTest = '';
		if (!Ext.isEmpty(selectTest) && selectTest != null && selectTest != undefined && selectTest.length > 0)
		{
			selectedTest = selectTest;
		}
		if (selectedTest != null && selectedTest.length > 0)
		{
			Ext.Ajax.request({
				url: 'IncludeExcludeComponents/data/EgIncludeExcludeComponentsJson.jsp?componentType='+encodeURIComponent(componentType)+'&testType='+testType+'&selectedTest='+selectedTest+'&previousComponentType='+encodeURIComponent(componentType)+'&previousTestType='+testType,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					if (Ext.getCmp('itemselectComp').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectComp').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselectComp').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectComp').toField.store.removeAll();
					}
					Ext.getCmp('itemselectComp').fromField.store.add(publicJSON['includedArray']);
					Ext.getCmp('itemselectComp').toField.store.add(publicJSON['excludedArray']);
				}
			});
		}
	},

	updation: function(btn) {
		var componentType = Ext.getCmp('compType').getValue();
		if (componentType == "-1")
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.test.Please choose a component type']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		var componentsAllowedLimitsExceed = publicJSON['componentsAllowedLimitsExceed'];
		var seletedTestList = '';
		if (!Ext.isEmpty(componentsAllowedLimitsExceed) && componentsAllowedLimitsExceed)
		{
			Ext.ComponentQuery.query('combo[itemId="components"]')[0].setDisabled(false);
			seletedTestList = Ext.ComponentQuery.query('combo[itemId="components"]')[0].getValue();
			Ext.getCmp('components').setDisabled(true);
		}
		else
		{
			Ext.getCmp('components').setDisabled(false);
			seletedTestList = Ext.getCmp('components').getValue();
			Ext.ComponentQuery.query('combo[itemId="components"]')[0].setDisabled(true);
		}

		if (seletedTestList == "" || seletedTestList == "null")
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.test.Please select the test']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		var testType = Ext.getCmp('testType').getValue();
		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == false )
		{
			testType = "PerformanceTest";
		}

		var existingIncludedComponents = publicJSON['includedArray'];//publicJSON['existingComponents'];
		var existIncludedCompArr = new Array();
		if (!Ext.isEmpty(existingIncludedComponents))
		{
			for (var j=0;j<existingIncludedComponents.length;j++)
			{
				existIncludedCompArr.push(existingIncludedComponents[j].valueField);
			}
		}

		var existingExcludedCompents = publicJSON['excludedArray'];
		var existingExcludedCompArr = new Array();
		if (!Ext.isEmpty(existingExcludedCompents))
		{
			for (var m=0;m<existingExcludedCompents.length;m++)
			{
				existingExcludedCompArr.push(existingExcludedCompents[m].valueField);
			}
		}

		var noOfExcludeAgent = Ext.getCmp('itemselectComp').toField.store.getCount();
		var excludedHostsArr = new Array();
		for (var i=0;i < noOfExcludeAgent;i++)
		{
			excludedHostsArr[excludedHostsArr.length] = Ext.getCmp('itemselectComp').toField.store.getAt(i).get('valueField');
		}

		if (excludedHostsArr == undefined)
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.test.Please include/exclude component(s)']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}

		var excludedResultArr = new Array();
		for (var k=0;k<excludedHostsArr.length;k++)
		{
			if (!Ext.isEmpty(existingExcludedCompArr) && existingExcludedCompArr.length > 0)
			{
				if (existingExcludedCompArr.indexOf(excludedHostsArr[k]) == -1)
				{
					excludedResultArr[excludedResultArr.length] = excludedHostsArr[k];
				}
			}
			else
			{
				excludedResultArr[excludedResultArr.length]= excludedHostsArr[k];
			}
		}
		var strExcludedMovedComp = excludedResultArr;

		var includedResultArr = new Array();
		var noOfManAgent = Ext.getCmp('itemselectComp').fromField.store.getCount();

		var includedHostsArr = new Array();
		for (var i=0;i < noOfManAgent;i++)
		{
			includedHostsArr[includedHostsArr.length] = Ext.getCmp('itemselectComp').fromField.store.getAt(i).get('valueField');
		}

		for (var m=0;m<includedHostsArr.length;m++ )
		{
			if (!Ext.isEmpty(existIncludedCompArr) && existIncludedCompArr.length > 0)
			{
				if (existIncludedCompArr.indexOf(includedHostsArr[m]) == -1)
				{
					includedResultArr[includedResultArr.length] = includedHostsArr[m];
				}
			}
			else
			{
				includedResultArr[includedResultArr.length] = includedHostsArr[m];
			}
		}
		var strIncludedMovedComp = includedResultArr;


		//var qString = "IncludeExcludeComponents/data/EgIncludeExcludeComponentsJson.jsp?";
		//var includeExcludeCmpObj = Ext.getCmp('IncludeExcludeComponents').getForm();
		//if (includeExcludeCmpObj.isValid())
		//{
			//Ext.getCmp('strIncludedMovedComp').setValue(strIncludedMovedComp);
			//Ext.getCmp('strExcludedMovedComp').setValue(strExcludedMovedComp);
			//includeExcludeCmpObj.submit({
				//url: qString,
				//method: 'POST',
				//timeout: 120,
				//standardSubmit: false,
				//success: function( form,action )
				//{
					//var jsonText = action.response.responseText;
					//publicJSON = Ext.decode(jsonText);
					//if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
					//{
						//Ext.getCmp('strIncludedMovedComp').setValue('');
						//Ext.getCmp('strExcludedMovedComp').setValue('');
					//}
				//},
				//failure: function ( response )
				//{
					//Ext.getCmp('strIncludedMovedComp').setValue('');
					//Ext.getCmp('strExcludedMovedComp').setValue('');
				//}
			//});
		//}

		//var noOfEnableValues = Ext.getCmp('itemselectComp').fromField.store.getCount();
		//var allEnableValue = new Array();
		//for (var i=0;i < noOfEnableValues;i++)
		//{
			//allEnableValue[allEnableValue.length]=Ext.getCmp('itemselectComp').fromField.store.getAt(i).get('valueField');
		//}

		//var enabledCompList = allEnableValue;
		//if (enabledCompList.length == 0)
		//{
			//enabledCompList = "";
		//}

		//var noOfDisableValues = Ext.getCmp('itemselectComp').toField.store.getCount();
		//var allDisableValue = new Array();
		//for (var i=0;i < noOfDisableValues;i++)
		//{
			//allDisableValue[allDisableValue.length]=Ext.getCmp('itemselectComp').toField.store.getAt(i).get('valueField');
		//}
		//var disabledCompList = allDisableValue;
		//if (disabledCompList.length == 0)
		//{
			//disabledCompList = "";
		//}

		if (strIncludedMovedComp.length > 0 || strExcludedMovedComp.length > 0)
		{
			var myIncExcMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myIncExcMask.show();

			Ext.getCmp('strIncludedMovedComp').setValue(strIncludedMovedComp);
			Ext.getCmp('strExcludedMovedComp').setValue(strExcludedMovedComp);

			var hiddenObj = Ext.getCmp('hiddencontainer');
			urlLink = "IncludeExcludeComponents/data/EgIncludeExcludeComponentspJson.jsp?componentType="+encodeURIComponent(componentType);
			var temp = {
				xtype: 'hiddenfield',
				name: 'seletedTestList',
				value: seletedTestList,
			};
			hiddenObj.add(temp);

			//temp = {
				//xtype: 'hiddenfield',
				//name: 'enabledCompList',
				//value: enabledCompList,
			//};
			//hiddenObj.add(temp);

			//temp = {
				//xtype: 'hiddenfield',
				//name: 'disabledCompList',
				//value: disabledCompList,
			//};
			//hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'testType',
				value: testType,
			};
			hiddenObj.add(temp);

			var includeExcludeCmpObj = Ext.getCmp('IncludeExcludeComponents').getForm();
			includeExcludeCmpObj.submit({
				url: urlLink,
				method: 'POST',
				timeout:120,
				success: function( form,action )
				{
					var jsonText = action.response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
					{
						Ext.getCmp('strIncludedMovedComp').setValue('');
						Ext.getCmp('strExcludedMovedComp').setValue('');

						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							myIncExcMask.hide();
							var resultStatus = publicJSON['result'];
							Ext.MessageBox.show({
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								fn : function(btn)
								{
									var qrrString = '';
									if (isConfigSupported == false)
									{
										qrrString = "componentType="+encodeURIComponent(componentType)+"&previousComponentType="+encodeURIComponent(componentType)+"&testName="+seletedTestList+"&previousTestName="+seletedTestList+"&selectedTest="+seletedTestList;
									}
									else
									{
										qrrString = "componentType="+encodeURIComponent(componentType)+"&previousComponentType="+encodeURIComponent(componentType)+"&testName="+seletedTestList+"&previousTestName="+seletedTestList+"&selectedTest="+seletedTestList+"&testType="+testType+"&previousTestType="+testType;
									}
									Ext.Ajax.request({
										url: 'IncludeExcludeComponents/data/EgIncludeExcludeComponentsJson.jsp?'+qrrString,
										method: 'POST',
										timout: 120000,
										success: function( response )
										{
											if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
											{
												var jsonText = response.responseText;
												publicJSON = Ext.decode( jsonText );
											}

											var componentsAllowedLimitsExceed = publicJSON['componentsAllowedLimitsExceed'];
											if (!Ext.isEmpty(componentsAllowedLimitsExceed) && componentsAllowedLimitsExceed)
											{
												Ext.ComponentQuery.query('combo[itemId="components"]')[0].setDisabled(false);
												Ext.getCmp('components').setDisabled(true);
											}
											else
											{
												Ext.getCmp('components').setDisabled(false);
												Ext.ComponentQuery.query('combo[itemId="components"]')[0].setDisabled(true);
											}

											if (Ext.getCmp('itemselectComp').fromField.store.getCount() >= 1)
											{
												Ext.getCmp('itemselectComp').fromField.store.removeAll();
											}
											if (Ext.getCmp('itemselectComp').toField.store.getCount() >= 1)
											{
												Ext.getCmp('itemselectComp').toField.store.removeAll();
											}

											Ext.getCmp('itemselectComp').fromField.store.add(publicJSON['includedArray']);
											Ext.getCmp('itemselectComp').toField.store.add(publicJSON['excludedArray']);
										}
									});
								}
							});
						}
					}
					hiddenObj.removeAll();
				},
				failure: function ( response )
				{
					myIncExcMask.hide();
					Ext.getCmp('strIncludedMovedComp').setValue('');
					Ext.getCmp('strExcludedMovedComp').setValue('');

					hiddenObj.removeAll();
				}
			});
		}
		else
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.test.Please include/exclude component(s)']+".");
		}
	},

	initializeFields : function() {
		var me=this;
		var executiveForm = this.getFormitems().getForm();

		if (componType == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['componentTypeArray'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['componentTypeArray'],componType);
		}

		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == true)
		{
			if (testTypeStr == "null")
			{
				me.setValueWithOptionInList(executiveForm, 'testType', publicJSON['TestType'],'');
			}
			else
			{
				me.setValueWithOptionInList(executiveForm, 'testType', publicJSON['TestType'],testTypeStr);
			}
		}
	},

	setValueWithOptionInList : function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().clearFilter(true);
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function() {
		this.initializeFields();
		Ext.getCmp('itemselectComp').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.test.INCLUDED COMPONENTS']);
		Ext.getCmp('itemselectComp').toField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.test.EXCLUDED COMPONENTS']);
		Ext.getCmp('compType').setFieldLabel(publicJSON['screenLabels']['admin.server.Component type']);
		Ext.getCmp('testType').setFieldLabel(publicJSON['screenLabels']['admin.server.Test type']);

		Ext.getCmp('componentLbl').setText(publicJSON['screenLabels']['admin.server.Test name']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.test.Update']);

		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == false)
		{
			Ext.getCmp('testType').hide();
		}
		if (((componType != null && !Ext.isEmpty(componType)) || (testTypeStr != null && !Ext.isEmpty(testTypeStr))) || (testNameStr != null && !Ext.isEmpty(testNameStr)))
		{
			var qrrString = '';
			if (isConfigSupported == false)
			{
				qrrString = "componentType="+encodeURIComponent(componType)+"&previousComponentType="+encodeURIComponent(componType)+"&testName="+testNameStr+"&previousTestName="+testNameStr+"&selectedTest="+testNameStr;
			}
			else
			{
				qrrString = "componentType="+encodeURIComponent(componType)+"&previousComponentType="+encodeURIComponent(componType)+"&testName="+testNameStr+"&previousTestName="+testNameStr+"&selectedTest="+testNameStr+"&testType="+testTypeStr+"&previousTestType="+testTypeStr;
			}
			Ext.Ajax.request({
				url: 'IncludeExcludeComponents/data/EgIncludeExcludeComponentsJson.jsp?'+qrrString,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}

					if (Ext.getCmp('itemselectComp').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectComp').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselectComp').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectComp').toField.store.removeAll();
					}
					var componentsAllowedLimitsExceed = publicJSON['componentsAllowedLimitsExceed'];

					if (!Ext.isEmpty(componentsAllowedLimitsExceed) && componentsAllowedLimitsExceed)
					{
						Ext.getCmp('multiSelCont').hide();
						Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].show();
						Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].getStore().loadRawData(publicJSON['TestName']);
						if (testNameStr != null && !Ext.isEmpty(testNameStr))
						{
							Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].setValue(testNameStr);
						}
						else
						{
							Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].setValue(publicJSON['TestName'][0].valueField);
						}
					}
					else
					{
						Ext.getCmp('multiSelCont').show();
						Ext.ComponentQuery.query('formitems combo[itemId="components"]')[0].hide();
						Ext.getCmp('components').getStore().loadRawData(publicJSON['TestName']);
						if (testNameStr != null && !Ext.isEmpty(testNameStr))
						{
							Ext.getCmp('components').setValue(testNameStr);
						}
					}

					Ext.getCmp('itemselectComp').fromField.store.add(publicJSON['includedArray']);
					Ext.getCmp('itemselectComp').toField.store.add(publicJSON['excludedArray']);
				}
			});
		}
	}

});