	Ext.Loader.setConfig({
		enabled: true,
		disableCaching: false,
		paths: {
			'Ext.ux': '/final/scripts/ux',
			'utilities':'/final/scripts/utilities'
		}
	});

	function showHourlyGraph(val)
	{
		var actualDate = val.substring(0,val.indexOf('^'));
		var dispDate = val.substring(val.indexOf('^')+1);
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.groupWindow',
			title : concUsrGrTitle+' '+dispDate,
			id:'ccUsersGraph',
			width: 950,
			height: 505,
			padding : '5px',
			modal : true,
			border : false,
			ghost:false,
			floatable:true,
			floating :true,
			autoScroll:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			layout:{
				type:'fit'
			},
			items:[{
				xtype : 'ccusersdrilldownreport',
				listeners:{
					'resize': function () {
						var chartHeight = ($('#ccUsrDrillRedId').height())-68;
						var chartWidth = ($('#ccUsrDrillRedId').width())-40;
						resizeDrillDownHighChart('ccUserGraph',chartWidth,chartHeight);
					}
				}
			}]
		}).show();
		
		Ext.getCmp('selDate').setValue(actualDate);
		var graphURL = "/final/admin/License/data/EgCcUserDetailedGraph.jsp?";
		var grMode = Ext.getCmp('ccGraphMode').getValue();
		graphURL += "&er_mode="+grMode;
		graphURL += "&selDate="+actualDate;
		
		var chartData=null;
		Ext.Ajax.request(
		{
			url: graphURL,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					chartData = Ext.decode( jsonText );
					if(!Ext.isEmpty(chartData) && Ext.isEmpty(chartData.errormsg))
					{
						var highChart = {};
						highChart = jQuery.extend(true, {}, getHighChartsBarInstance('ccUserGraph',chartData.chartHeight,chartData.chartWidth), highChart);
						highChart.setData(chartData,'<%=currentDateFormat%>','',chartData.chartType);
						highChart.drawChart();
						drillDownHighChartIns = highChart;
					}
					else if(Ext.isEmpty(chartData))
					{
						Ext.fly("ccUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b> '+errorMsg +' </b></div></td></tr></table>');
					}
					else if(!Ext.isEmpty(chartData.errormsg))
					{
						Ext.fly("ccUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b>'+ errorMsg + '</b></div></td></tr></table>');
					}
				}
				
			},
			failure:function()
			{
				Ext.fly("ccUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b>'+ errorMsg + '</b></div></td></tr></table>');
			}
		});
	}
	Ext.application({
		name: 'License',
		autoCreateViewport: true,
		appFolder: ['License/app'],
		controllers:['License.controller.Main']
	});



