var tplData = new Ext.XTemplate(
		'<div class="x-table"><table cellspacing="0" width="100%" cellpadding="5" border="0" align="center"  class="x-grid-table x-table-border" style="width:100%;">',
		'<tpl for=".">',
			'<tr class="x-grid-row">',
				'<td class="x-grid-cell"><div class="x-grid-cell-inner" >{col_1}<div></td>',
				'<td class="x-grid-cell"><div class="x-grid-cell-inner" >{col_2}<div></td>',
				'<td class="x-grid-cell"><div class="x-grid-cell-inner" >{col_3}<div></td>',
			'</tr>',
		'</tpl>',
		'</table></div>'
	)
	var failLoadCount = 0;var colCount = 4;var user_colCount = 4;var primaryManager = ""; var secondaryManager = "";

Ext.define('License.controller.Main',{
	extend:'Ext.app.Controller',
	views:['LicenseInfo','NamedUsersReport','UserNames','CcUsersDrillDownReport','UsedCountDetails'],
	requires:['License.view.LicenseInfo'],
	refs:[
		{selector:'licenseinfo', ref:'licenseinfo'},
		{selector:'namedusersreport', ref:'namedusersreport'},
		{selector:'ccusersdrilldownreport', ref:'ccusersdrilldownreport'},
		{selector:'usernames', ref:'usernames'},
		{selector:'usedcountdetails', ref:'usedcountdetails'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'licenseinfo':
			{
				'afterrender': this.afterMainRender
			},
			'namedusersreport combo[id="graphDuration"]':
			{
				'select': this.durationChange
			},
			'namedusersreport button[id="show"]':
			{
				'click': this.graphModeChangeAny
			},
			'usernames  button[id="saveCSV"]':
			{
				'click': this.saveInCSVUserNames
			},
			'usernames button[id="backBtn"]':
			{
				'click':this.goBack
			},
			'usernames button[id="submit"]':
			{
				'click':this.dateWiseUserNames
			},
			'usedcountdetails button[id="backBtn"]':
			{
				'click':this.goBack
			},
			'usedcountdetails  button[id="saveCSV"]':
			{
				'click': this.saveInCSVFormat
			},
			'ccusersdrilldownreport combo[id="ccGraphMode"]':
			{
				'select': this.ccUserGraphmodeChange
			},
			'licenseinfo button[id="agentStatus"]':
			{
				'click': this.goToAgentStatus
			},
			'licenseinfo button[id="backBtnMain"]':
			{
				'click': this.goHome
			},
			'licenseinfo trigger[id="searchBox"]':
			{
				'change': this.searchUser
			},
			'licenseinfo trigger[id="searchBoxZone"]':
			{
				'change': this.searchZone
			},
			'licenseinfo  button[id="saveCSVOrg"]':
			{
				'click': this.saveInCSVFormatOrg
			},
			'licenseinfo  button[id="saveCSVUser"]':
			{
				'click': this.saveInCSVFormatUser
			},
			'licenseinfo  button[id="saveCSVZone"]':
			{
				'click': this.saveInCSVFormatZone
			},
			'licenseinfo  button[id="saveCSVUserNew"]': 
			{
			        "click": this.saveInCSVFormatUserNew
			},
			'licenseinfo  button[id="saveCSVLicUsage"]':
			{
				'click': this.saveInCSVTotalUsage
			}
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'License/data/EgLicenseInfoJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );										
				}
			}
		});
	},
	tabchange : function(tab)
	{
		Ext.Ajax.request({
			url: 'License/data/licensehelpJson.jsp?selectTab='+tab,
			method: 'POST',
			async: false
		});
		/*if (tab == 'tab3')
		{
			ctrler.userWiseTabLoad();
		}
		else if (tab == 'tab4')
		{
			ctrler.zoneWiseTabLoad();
		}*/
	},
	afterMainRender: function()
	{
		if (isLimitedAdmin == "false")
		{
			Ext.getCmp('product').setValue(publicJSON.product);
			Ext.getCmp('version').setValue(publicJSON.version);
			Ext.getCmp('ipAddr').setValue(publicJSON.IPAddress);
			Ext.getCmp('hostID').setValue(publicJSON.hostID);
			Ext.getCmp('expDate').setValue(publicJSON.expDate);
			Ext.getCmp('certValid').setValue(publicJSON.licIsValidFor);
			Ext.getCmp('mailSender').setValue(publicJSON.mailSenderID);
			Ext.getCmp('companyName').setValue(publicJSON.companyName);
			Ext.getCmp('clusType').setValue(publicJSON.clusterType);
			primaryManager = publicJSON.primaryManager;
			secondaryManager = publicJSON.secondaryManager;
			Ext.getCmp('ic').setValue(publicJSON.IC);
			Ext.getCmp('ttMgr').setValue(publicJSON.TTMgr);
			Ext.getCmp('dd').setValue(publicJSON.DD);
			Ext.getCmp('extSuperMgr').setValue(publicJSON.extSuperMgr);
			Ext.getCmp('egSuperMgr').setValue(publicJSON.eGSuperMgr);
			Ext.getCmp('egReporter').setValue(publicJSON.eGReporter);
			Ext.getCmp('remCtrlActs').setValue(publicJSON.rmtCtrlActs);
			Ext.getCmp('smsAlerts').setValue(publicJSON.SMSAlerts);
			Ext.getCmp('configMgmt').setValue(publicJSON.configMgmt);
			Ext.getCmp('metricAgg').setValue(publicJSON.metricAgg);
			Ext.getCmp('agentPerSys').setValue(publicJSON.agentPerSys);
			Ext.getCmp('clntEmul').setValue(publicJSON.clientEmul);
			Ext.getCmp('advAnalytics').setValue(publicJSON.advAnalytics);
			if (publicJSON.showLicenseId)
			{
				Ext.getCmp('licenseId').show();
				Ext.getCmp('licenseId').setValue(publicJSON.licenseId);
			}
			else
			{
				Ext.getCmp('licenseId').hide();
			}
			Ext.getCmp('grid1').getStore().loadRawData(publicJSON.grid1);
			if(Ext.isEmpty(publicJSON.grid2))
			{
				Ext.getCmp('grid2').hide();
			}else
			{
				Ext.getCmp('grid2').show();
				Ext.getCmp('grid2').getStore().loadRawData(publicJSON.grid2);
				if (publicJSON.CCUsersCertCheck != undefined)
				{
					CCUsersCertCheck = publicJSON.CCUsersCertCheck;
				}
			}
			if (from == 'AdminHome')
			{
				Ext.getCmp('backBtnMain').show();
			}

			if (userWiseCertUsg == 'true')
			{
				Ext.getCmp('certInfoTab').child('#tab3').tab.show();
				ctrler.userWiseTabLoad();
			}
			else
			{
				Ext.getCmp('certInfoTab').child('#tab3').tab.hide();
			}

			if (zoneWiseCertUsg == 'true')
			{
				Ext.getCmp('certInfoTab').child('#tab4').tab.show();
				ctrler.zoneWiseTabLoad();
			}
			else
			{
				Ext.getCmp('certInfoTab').child('#tab4').tab.hide();
			}
		}
		else
		{
			Ext.getCmp('certInfoTab').child('#tab1').tab.hide();
			Ext.getCmp('certInfoTab').child('#tab2').tab.hide();
			Ext.getCmp('certInfoTab').child('#tab4').tab.hide();
			Ext.getCmp('certInfoTab').setActiveTab(Ext.getCmp('usrWiseTabNew'));
			Ext.getCmp('certInfoTab').child('#tab5').tab.show();
			ctrler.userWiseTabLoadNew();
			if(showUsersTab == 'true')
			{
				Ext.getCmp('certInfoTab').child('#tab3').tab.show();
				ctrler.userWiseTabLoad();
			}
		}
		this.orgTabLoad();
		if ((from != null || from !== undefined) && from.toLowerCase() == "agentstatus")
		{
			Ext.getCmp('certInfoTab').setActiveTab(1);
			ctrler.tabchange('certUsage');
		}
		else
		{
			var selTab = Ext.getCmp('certInfoTab').getActiveTab().id;
			Ext.getCmp('certInfoTab').setActiveTab(selTab);
			ctrler.tabchange(Ext.getCmp(selTab).getItemId());
		}
	},
	showGraph : function ()
	{
		this.buildMainData();
		var tempObj = this;
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.groupWindow',
			title : totNamedUsrs,
			id:'namedUsersGraph',
			width: 900,
			height: 505,
			padding : '5px',
			modal : true,
			border : false,
			floatable:true,
			floating :true,
			autoScroll:false,
			ghost:false,
			draggable:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			layout:{
				type:'fit'
			},
			items:[{
				xtype : 'namedusersreport',
				listeners:{
					'resize': function () {
						var chartHeight = ($('#nameUserReportId').height())-108;
						var chartWidth = ($('#nameUserReportId').width())-230;
						if (failLoadCount != 0 )
						{
							resizeHighChart('namedUserGraph',chartWidth,chartHeight);
						}
					}
				}
			}]
		}).show();
		Ext.getCmp('graphDuration').getStore().loadRawData(publicJSON.timelines);
		Ext.getCmp('graphDuration').setValue(publicJSON.timelineSelected);
		Ext.getCmp('graphMode').getStore().loadRawData(publicJSON.modes);
		Ext.getCmp('graphMode').setValue('3D');
		this.modeChange();
	},
	showHourlyGraph : function (val)
	{
		var actualDate = val.substring(0,val.indexOf('^'));
		var dispDate = val.substring(val.indexOf('^')+1);
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.groupWindow',
			title : concUsrGrTitle+' '+dispDate,
			id:'ccUsersGraph',
			width: 900,
			height: 505,
			padding : '5px',
			modal : true,
			border : false,
			ghost:false,
			floatable:true,
			floating :true,
			autoScroll:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			layout:{
				type:'fit'
			},
			items:[{
				xtype : 'ccusersdrilldownreport',
			}]
		}).show();
		
		Ext.getCmp('selDate').setValue(actualDate);
		var graphURL = "/final/admin/License/data/EgCcUserDetailedGraph.jsp?";
		var grMode = Ext.getCmp('ccGraphMode').getValue();
		graphURL += "&er_mode="+grMode;
		graphURL += "&selDate="+actualDate;
		var graphCtnrObj = Ext.select("#ccUserGraph");		
		graphCtnrObj.set({
			src : graphURL
		});
	},
	durationChange : function()
	{
		this.modeChange();
	},
	modeChange :  function()
	{
		var grDuration = Ext.getCmp('graphDuration').getValue();
		if(grDuration == 'Any')
		{
			Ext.getCmp('datepickfrom').enable();
			Ext.getCmp('datepickTo').enable();
			Ext.getCmp('show').enable();
			grDuration = "2 weeks";
		}
		else
		{
			Ext.getCmp('datepickfrom').disable();
			Ext.getCmp('datepickTo').disable();
			Ext.getCmp('show').disable();
		
		}
		var graphURL = "/final/admin/License/data/EgUserLicenseInfoGraph.jsp?er_timeline="+grDuration;
		Ext.Ajax.request(
		{
			url: graphURL,
			method: 'POST',
			async:false,
			success: function( response )
			{
				
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonLocal = response.responseText;
					var publicJSON_Local = Ext.decode(jsonLocal);
					Ext.getCmp('datepickfrom').setValue(publicJSON_Local['startDate']);
					Ext.getCmp('datepickTo').setValue(publicJSON_Local['endDate']);
					var jsonText = response.responseText;
					var chartJson = Ext.decode(jsonText);
					if(!Ext.isEmpty(chartJson) && Ext.isEmpty(chartJson.errormsg))
					{
						highChart = {};
						highChart = jQuery.extend(true, {}, getHighChartsBarInstance('namedUserGraph',chartJson.chartHeight,chartJson.chartWidth), highChart);						
						chartJson.offset = 80;
						highChart.setData(chartJson,'<%=currentDateFormat%>','',chartJson.chartType);
						highChart.drawChart();
						highChartIns = highChart;
						failLoadCount++;
					}

					else if(Ext.isEmpty(chartJson))
					{
						failLoadCount = 0;
						Ext.fly("namedUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b> '+errorMsg+' </b></div></td></tr></table>');
					}
					else if(!Ext.isEmpty(chartJson.errormsg))
					{
						failLoadCount = 0;
						Ext.fly("namedUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b>'+ errorMsg + '</b></div></td></tr></table>');
					}
				}
			},
			failure:function()
			{
				Ext.fly("namedUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b> '+errorMsg+' </b></div></td></tr></table>');
			}
		});
	},
	graphModeChangeAny : function()
	{
		var grDuration = Ext.getCmp('graphDuration').getValue();
		var datePickFrom = Ext.getCmp('datepickfrom').getValue();
		var datePickFromChg = Ext.Date.format(datePickFrom, "m/d/y");
		var datePickTo =  Ext.getCmp('datepickTo').getValue();
		var datePickToChg = Ext.Date.format(datePickTo, "m/d/y");
		datePickFrom = datePickFrom.toString();
		datePickFrom = datePickFrom.substring(4,10)+","+datePickFrom.substring(10,15) ;
		datePickTo = datePickTo.toString();
		datePickTo = datePickTo.substring(4,10)+","+datePickTo.substring(10,15) ;
		var graphURL = "/final/admin/License/data/EgUserLicenseInfoGraph.jsp?er_timeline="+grDuration;
		
		if (dateValidation(datePickFromChg,datePickToChg) == -1) 
		{
			Ext.MessageBox.show({
					title: "Alert",
					msg: dateAlert,
					buttons: Ext.Msg.OK,
					icon: "iconExclamation",
			});
		} 
		else
		{
			Ext.Ajax.request(
			{
				url: graphURL,
				method: 'POST',
				params :
				{
					'datePickFrom' : datePickFrom,
					'datePickTo' : datePickTo
				},
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var chartJson = Ext.decode(jsonText);
						if(!Ext.isEmpty(chartJson) && Ext.isEmpty(chartJson.errormsg))
						{
							highChart = {};
							highChart = jQuery.extend(true, {}, getHighChartsBarInstance('namedUserGraph',chartJson.chartHeight,chartJson.chartWidth), highChart);
							highChart.setData(chartJson,'<%=currentDateFormat%>','',chartJson.chartType);
							highChart.drawChart();
							highChartIns = highChart;
							failLoadCount++;
						}
						else if(Ext.isEmpty(chartJson))
						{
							failLoadCount = 0;
							Ext.fly("namedUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b> '+errorMsg+' </b></div></td></tr></table>');
						}
						else if(!Ext.isEmpty(chartJson.errormsg))
						{
							failLoadCount = 0;
							Ext.fly("namedUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b>'+ errorMsg + '</b></div></td></tr></table>');
						}
					}
				},
				failure:function()
				{
					Ext.fly("namedUserGraph").update('<table style="text-align:center;width:100%;height:100%;margin:12% auto 0px auto"><tr><td valign="middle"><div class = "iconExclamation" style="margin:0 auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b> '+errorMsg+' </b></div></td></tr></table>');
				}
			});
		}
	},
	ccUserGraphmodeChange : function()
	{
		var graphURL = "/final/admin/License/data/EgCcUserDetailedGraph.jsp?";
		var grMode = Ext.getCmp('ccGraphMode').getValue();
		var selDate = Ext.getCmp('selDate').getValue();
		graphURL += "&er_mode="+grMode;
		graphURL += "&selDate="+selDate;
		var graphCtnrObj = Ext.select("#ccUserGraph");		
		graphCtnrObj.set({
			src : graphURL
		});
	},

	getSelectedUsersData : function(obj)
	{
		var usertype = obj.getValue();
		var date = Ext.getCmp('datepick').getValue();
		var datePickVal = date.toString().substring(4,15);
		var nextDate = Ext.Date.add (date,Ext.Date.DAY,1);
		date = Ext.util.Format.date(nextDate, 'm/d/Y');
		Ext.getCmp('usersCnt').hide();
		Ext.getCmp('defaultCont').hide();
		Ext.getCmp('NoUserAvailable').hide();

		if (this.getUsernames().down('#searchTrigger'))
		{
			this.getUsernames().down('#searchTrigger').disable();
			this.getUsernames().down('#searchTrigger').setValue('');
		}


		var getElObj = Ext.getCmp('userNames').getEl();
		var getPanelObj = Ext.getCmp('gridCont');
		getElObj.mask("Loading...","maskCenter");

		var urlStr = "License/data/UserNamesJson.jsp?date="+date+"&datePickVal="+datePickVal+'&usertype='+usertype;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			//async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					var selectedUsersDataArr = publicJSON['selectedUsersDataArr'];

					if (!Ext.isEmpty(selectedUsersDataArr))
					{
						Ext.getCmp('userGrid').getStore().removeAll();
						Ext.getCmp('pagingtoolbarid').getStore().removeAll();

						var resultMsg = setCountLabelTitle(fromUserType,usertype,publicJSON);
						if (!Ext.isEmpty(resultMsg))
						{
							Ext.getCmp('usersCnt').show();
							Ext.getCmp('usersCnt').update(resultMsg);
						}

						var gridColArr = publicJSON['columnArr'];
						var genStoreModel = new Array();
						var colArr = new Array();
						for ( var i = 0; i < gridColArr.length; i++ )
						{
							var columnWidth = 65;
							if ( i == 0 || ( i == gridColArr.length - 1 ) )
							{
								columnWidth = 170;
							}
							genStoreModel[genStoreModel.length] = gridColArr[i];
							colArr.push({
								header: gridColArr[i],
								minWidth: columnWidth,
								flex: 0.2,
								dataIndex: gridColArr[i],
								renderer: function( val )
								{
									return '<div style="white-space:normal !important;word-wrap:break-word;">'+ val +'</div>';
								}
							});
						}

						Ext.define('GridModel', {
							extend: 'Ext.data.Model',
							fields: gridColArr
						});

						var store = Ext.create('Ext.data.Store', {
							pageSize: 250,
							model: 'GridModel',
							proxy: {
								type: 'ajax',
								url: urlStr,
								reader: {
									type: 'json',
									root: 'selectedUsersDataArr',
									totalProperty: 'totalProperty',
								}
							},
							storeId: 'store',
							sorters: [{
								property: 'User',
								direction: 'ASC'
							}],
							remoteFilter: true,
							remoteSort: false
						});
						Ext.getCmp('userGrid').reconfigure(store,colArr);
						Ext.getCmp('pagingtoolbarid').bindStore(store);
						ctrler.getUsernames().down('#searchTrigger').enable();

						Ext.getCmp('saveCSV').enable();
						store.load();

					}
					else
					{
						Ext.getCmp('userGrid').getStore().removeAll();
						Ext.getCmp('pagingtoolbarid').getStore().removeAll();

						Ext.getCmp('saveCSV').disable();
						Ext.getCmp('pagingtoolbarid').onLoad();
						Ext.getCmp('pagingtoolbarid').down('#refresh').setDisabled(true);
						Ext.getCmp('userGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="250"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">No data found.</td></tr></table></td></tr></table>';
						Ext.getCmp('userGrid').getView().refresh();

					}
					getPanelObj.doLayout();
					getElObj.unmask();
				}
			},
			failure: function(action, response)
			{
				getPanelObj.doLayout();
				getElObj.unmask();
			}
		});
	},
	showUserNames : function()
	{
		var date = new Date();
		var datePickVal = Ext.Date.add (date,Ext.Date.DAY,-1);
		datePickVal = datePickVal.toString().substring(4,15);
		date = Ext.util.Format.date(date, 'm/d/Y');
		var usertype = 'all';
		var urlStr = "License/data/UserNamesJson.jsp?date="+date+"&datePickVal="+datePickVal+"&usertype="+usertype;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var mainContainerObj = Ext.getCmp('licenseviewport');
		mainContainerObj.removeAll();
		mainContainerObj.add({
			xtype : 'usernames'
		});

		var currDate = Ext.Date.add (new Date(),Ext.Date.DAY,-1);
		var dval = Ext.Date.format(currDate, mgrDateFormat);            
		Ext.getCmp('datepick').setValue(dval);

		var isDefaultViewInUserNames = publicJSON.isDefaultViewInUserNames;
		if (isDefaultViewInUserNames)
		{
			if(fromUserType == "NamedUsers")
			{
				Ext.getCmp('totCnt').update("Total Named Users: "+publicJSON.totCount);
			}
			else
			{
				Ext.getCmp('totCnt').update("Total Concurrent Users: "+publicJSON.totCount);
			}

			if(publicJSON.totCount > 0)
			{
				Ext.getCmp('saveCSV').enable();
				var ctxFldSetObj = Ext.getCmp('ctxFldSet');
				var vdiFldSetObj = Ext.getCmp('vdiFldSet');
				var trmFldSetObj = Ext.getCmp('trmFldSet');
				Ext.getCmp('defaultCont').show();
				if(publicJSON.ctxCount > 0)
				{
					ctxFldSetObj.show();
					ctxFldSetObj.setTitle("Citrix Users ("+publicJSON.ctxCount+")");
				}
				else
				{
					ctxFldSetObj.hide();
				}
				if(publicJSON.vdiCount > 0)
				{
					vdiFldSetObj.show();
					vdiFldSetObj.setTitle("VDI Users ("+publicJSON.vdiCount+")");
				}
				else
				{
					vdiFldSetObj.hide();
				}
				if(publicJSON.trmCount > 0)
				{
					trmFldSetObj.show();
					trmFldSetObj.setTitle("Cloud/Terminal Users ("+publicJSON.trmCount+")");
				}
				else
				{
					trmFldSetObj.hide();
				}
				
				var ctxObj = Ext.getCmp('ctxData');
				ctxObj.tpl=tplData;
				ctxObj.update(publicJSON.ctxUsers);

				var vdiObj = Ext.getCmp('vdiData');
				vdiObj.tpl=tplData;
				vdiObj.update(publicJSON.vdiUsers);

				var trmObj = Ext.getCmp('trmData');
				trmObj.tpl=tplData;
				trmObj.update(publicJSON.trmUsers);
			}
			else
			{
				Ext.getCmp('defaultCont').hide();
				Ext.getCmp('NoUserAvailable').show();
			}
		}
		else
		{
			var getElObj = Ext.getCmp('userNames').getEl();
			var getPanelObj = Ext.getCmp('gridCont');
			getElObj.mask("Loading...","maskCenter");
			if (publicJSON.totCount > 0)
			{
				Ext.getCmp('saveCSV').enable();
				Ext.getCmp('NoUserAvailable').hide();
				Ext.getCmp('defaultCont').hide();
				Ext.getCmp('gridCont').show();

				var allUsersDataArr = publicJSON['selectedUsersDataArr'];
				if ( !Ext.isEmpty(allUsersDataArr))
				{
					var gridColArr = publicJSON['columnArr'];
					var genStoreModel = new Array();
					var colArr = new Array();
					for ( var i = 0; i < gridColArr.length; i++ )
					{
						var columnWidth = 65;
						//if ( i == 0 || ( i == gridColArr.length - 1 ) )
						//{
							//columnWidth = 170;
						//}
						genStoreModel[genStoreModel.length] = gridColArr[i];
						colArr.push({
							header: gridColArr[i],
							minWidth: columnWidth,
							flex: 0.2,
							dataIndex: gridColArr[i],
							renderer: function( val )
							{
								return '<div style="white-space:normal !important;word-wrap:break-word;">'+ val +'</div>';
							}
						});
					}
					
					Ext.define('GridModel', {
						extend: 'Ext.data.Model',
						fields: gridColArr
					});

					 // create the Data Store
					var store = Ext.create('Ext.data.Store', {
						pageSize: 250,
						model: 'GridModel',
						proxy: {
							type: 'ajax',
							url: urlStr,
							reader: {
								type: 'json',
								root: 'selectedUsersDataArr',
								totalProperty: 'totalProperty',
							}
						},
						storeId: 'store',
						remoteFilter: true,
						remoteSort: false,
						sorters: [{
							property: 'User',
							direction: 'ASC'
						}],
					});

					getPanelObj.add({
						xtype: 'customgrid',
						cls:'gridSkin',
						id:'userGrid',
						margin: 10,
						flex:1,
						//loadMask: true,
						scroll: true,
						//height: 380,
						autoScroll: true,
						store: store,
						dockedItems:[{
							xtype: 'pagingtoolbar',
							id:'pagingtoolbarid',
							store: store,
							dock: 'bottom',
							cls:'pagingtoolbar',
							displayInfo: true
						}],
						columns: colArr,
						tbar: [
							{
								xtype:'scrollcombo',
								editable : false,
								fieldLabel:'User type',
								itemId: 'filterby',
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : [
										{'displayField':'All','valueField':'all'},
										{'displayField':'Citrix users','valueField':'ctxusers'},
										{'displayField':'VDI users','valueField':'vdiusers'},
										{'displayField':'Cloud/Terminal users','valueField':'termusers'}
									]
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								value : 'all',
								queryMode : 'local',
								labelAlign: 'left',
								labelSeparator: ' ',
								width: 250,
								labelWidth: 80,
								margin: '5 5 5 0',
								listeners:{
									select: function() {
										ctrler.getSelectedUsersData(this);
									}
								}
							},
							{
								xtype: 'label',
								text:"",
								labelSeparator: ' ',
								id:'usersCnt',
								margin: '5 5 5 10'
							},
							{
								xtype:'tbfill',
							},
							{
								xtype: 'toolbar',
								ui: 'footer',
								items: [
									{
										xtype: 'trigger',
										labelAlign: 'top',
										labelSeparator: ' ',
										itemId: 'searchTrigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										cls: 'whitedropdown_search',
										emptyText: 'Search user',
										disabled: true,
										getTriggerMarkup: function() {
											var me = this,
											i = 0,
											hideTrigger = (me.readOnly || me.hideTrigger),
											triggerCls,
											triggerBaseCls = me.triggerBaseCls,
											triggerConfigs = [],
											unselectableCls = Ext.dom.Element.unselectableCls,
											style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
											cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}
											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function()
										{
											this.reset();
										},
										onTrigger2Click: function()
										{
											ctrler.onSearchAction(this);
										}
									}
								]
							}
						]
					});
					store.load();
				}
				var resultMsg = setCountLabelTitle(fromUserType,usertype,publicJSON);
				if (!Ext.isEmpty(resultMsg))
				{
					Ext.getCmp('usersCnt').show();
					Ext.getCmp('usersCnt').update(resultMsg);

				}
				else
				{
					Ext.getCmp('usersCnt').hide();
				}

				if (this.getUsernames().down('#searchTrigger'))
				{
					this.getUsernames().down('#searchTrigger').enable();
				}
			}
			else
			{
				//Ext.getCmp('totCnt').hide();
				//Ext.getCmp('ctxFldSet').hide();
				//Ext.getCmp('vdiFldSet').hide();
				//Ext.getCmp('trmFldSet').hide();
				Ext.getCmp('gridCont').hide();
				Ext.getCmp('defaultCont').hide();
				Ext.getCmp('saveCSV').disable();

				if (this.getUsernames().down('#searchTrigger'))
				{
					this.getUsernames().down('#searchTrigger').disable();
				}

				Ext.getCmp('NoUserAvailable').show();
			}
			getPanelObj.doLayout();
			getElObj.unmask();
		}
	},
  onSearchAction: function(obj)
	{
		var usertype = this.getUsernames().down('#filterby').getValue();
		var store = Ext.getStore("store");
		value = obj.getValue();

		Ext.getCmp('usersCnt').hide();
		Ext.getCmp('saveCSV').disable();

		store.clearFilter(true);
		if(value)
		{
			store.filter('User', value);
		}
		//store.load();
		var getElObj = Ext.getCmp('userNames').getEl();
		var getPanelObj = Ext.getCmp('gridCont');
		getElObj.mask("Loading...","maskCenter");

		store.load(
				function(records, operation, success) {
				// the operation object
				// contains all of the details of the load operation
				if (success)
				{
					var emptyMsg = "No data found";
					var jsonTxt = operation.response.responseText;
					var jsonObj = Ext.decode(jsonTxt);
					var resultMsg = setCountLabelTitle(fromUserType,usertype,jsonObj);
					if (!Ext.isEmpty(resultMsg))
					{
						Ext.getCmp('usersCnt').show();
						Ext.getCmp('usersCnt').update(resultMsg);
					}
					if (jsonObj.totalProperty == 0)
					{
						Ext.getCmp('saveCSV').disable();
						emptyMsg = "No data found for your search";
						Ext.getCmp('userGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="250"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+emptyMsg+'.</td></tr></table></td></tr></table>';
					}
					else
					{
						Ext.getCmp('saveCSV').enable();
						Ext.getCmp('userGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="250"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+emptyMsg+'.</td></tr></table></td></tr></table>';
					}

					Ext.getCmp('userGrid').getView().refresh();
				}
			}
		);

		getPanelObj.doLayout();
		getElObj.unmask();


    },
	showPeakUserNames : function()
	{
		var date = peakdateForUserNames;
		var datePickVal = Ext.Date.add (date,Ext.Date.DAY,-1);
		datePickVal = datePickVal.toString().substring(4,15);
		date = Ext.util.Format.date(date, 'm/d/Y');
 		var usertype = 'all';
		var urlStr = "License/data/UserNamesJson.jsp?currentValue=peakUsage&date="+date+"&datePickVal="+datePickVal+'&usertype='+usertype;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var mainContainerObj = Ext.getCmp('licenseviewport');
		mainContainerObj.removeAll();
		mainContainerObj.add({
			xtype : 'usernames'
			});
		currDate = new Date(publicJSON.datePick);
		var dval = Ext.Date.format(currDate, mgrDateFormat); 
		Ext.getCmp('datepick').setValue(dval);

		var isDefaultViewInUserNames = publicJSON.isDefaultViewInUserNames;
		if (isDefaultViewInUserNames)
		{
			if(fromUserType == "NamedUsers")
			{
				Ext.getCmp('totCnt').update("Total Named Users: "+publicJSON.totCount);
			}
			if(fromUserType == "ConcurrentUser")
			{
				Ext.getCmp('totCnt').update("Total Concurrent Users: "+publicJSON.totCount);
			}

			if(publicJSON.totCount > 0)
			{
			Ext.getCmp('saveCSV').enable();
			Ext.getCmp('NoUserAvailable').hide();
			var ctxFldSetObj = Ext.getCmp('ctxFldSet');
			var vdiFldSetObj = Ext.getCmp('vdiFldSet');
			var trmFldSetObj = Ext.getCmp('trmFldSet');
			Ext.getCmp('gridCont').hide();
			Ext.getCmp('defaultCont').show();


			if(publicJSON.ctxCount > 0)
			{
				ctxFldSetObj.show();
				ctxFldSetObj.setTitle("Citrix Users ("+publicJSON.ctxCount+")");
			}
			else
			{
				Ext.getCmp('totCnt').hide();
				Ext.getCmp('ctxFldSet').hide();
				Ext.getCmp('vdiFldSet').hide();
				Ext.getCmp('trmFldSet').hide();
			}
			if(publicJSON.vdiCount > 0)
			{
				vdiFldSetObj.show();
				vdiFldSetObj.setTitle("VDI Users ("+publicJSON.vdiCount+")");
			}
			else
			{
				vdiFldSetObj.hide();
			}
			if(publicJSON.trmCount > 0)
			{
				trmFldSetObj.show();
				trmFldSetObj.setTitle("Cloud/Terminal Users ("+publicJSON.trmCount+")");
			}
			else
			{
				trmFldSetObj.hide();
			}
			
			var ctxObj = Ext.getCmp('ctxData');
			ctxObj.tpl=tplData;
			ctxObj.update(publicJSON.ctxUsers);

			var vdiObj = Ext.getCmp('vdiData');
			vdiObj.tpl=tplData;
			vdiObj.update(publicJSON.vdiUsers);

			var trmObj = Ext.getCmp('trmData');
			trmObj.tpl=tplData;
			trmObj.update(publicJSON.trmUsers);
			}
			else
			{
				Ext.getCmp('gridCont').hide();
				Ext.getCmp('defaultCont').hide();
				Ext.getCmp('NoUserAvailable').show();
			}
		}
		else
		{
			var getElObj = Ext.getCmp('userNames').getEl();
			var getPanelObj = Ext.getCmp('gridCont');
			getElObj.mask("Loading...","maskCenter");
			if (publicJSON.totCount > 0)
			{
				Ext.getCmp('saveCSV').enable();
				Ext.getCmp('NoUserAvailable').hide();
				Ext.getCmp('gridCont').show();
				Ext.getCmp('defaultCont').hide();


				var allUsersDataArr = publicJSON['selectedUsersDataArr'];
				if ( !Ext.isEmpty(allUsersDataArr))
				{
					var gridColArr = publicJSON['columnArr'];
					var genStoreModel = new Array();
					var colArr = new Array();
					for ( var i = 0; i < gridColArr.length; i++ )
					{
						var columnWidth = 65;
						if ( i == 0 || ( i == gridColArr.length - 1 ) )
						{
							columnWidth = 170;
						}
						genStoreModel[genStoreModel.length] = gridColArr[i];
						colArr.push({
							header: gridColArr[i],
							minWidth: columnWidth,
							flex: 0.2,
							dataIndex: gridColArr[i],
							renderer: function( val )
							{
								return '<div style="white-space:normal !important;word-wrap:break-word;">'+ val +'</div>';
							}
						});
					}
					
					Ext.define('GridModel', {
						extend: 'Ext.data.Model',
						fields: gridColArr
					});

					 // create the Data Store
					var store = Ext.create('Ext.data.Store', {
						pageSize: 250,
						model: 'GridModel',
						proxy: {
							type: 'ajax',
							url: urlStr,
							reader: {
								type: 'json',
								root: 'selectedUsersDataArr',
								totalProperty: 'totalProperty',
							}
						},
						storeId: 'store',
						sorters: [{
							property: 'User',
							direction: 'ASC'
						}],
						remoteFilter: true,
						remoteSort: false
					});

					getPanelObj.add({
						xtype: 'customgrid',
						cls:'gridSkin',
						id:'userGrid',
						margin: 10,
						flex:1,
						//loadMask: true,
						scroll: true,
						height: 380,
						autoScroll: true,
						store: store,
						dockedItems:[{
							xtype: 'pagingtoolbar',
							id:'pagingtoolbarid',
							store: store,
							dock: 'bottom',
							cls:'pagingtoolbar',
							displayInfo: true
						}],
						columns: colArr,
						tbar: [
							{
								xtype:'scrollcombo',
								editable : false,
								fieldLabel:'User type',
								id: 'filterby',
								itemId: 'filterby',
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : [
										{'displayField':'All','valueField':'all'},
										{'displayField':'Citrix users','valueField':'ctxusers'},
										{'displayField':'VDI users','valueField':'vdiusers'},
										{'displayField':'Cloud/Terminal users','valueField':'termusers'}
									]
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								value : 'all',
								queryMode : 'local',
								labelAlign: 'left',
								labelSeparator: ' ',
								width: 250,
								labelWidth: 80,
								margin: '5 5 5 0',
								listeners:{
									select: function() {
										ctrler.getSelectedUsersData(this);
									}
								}
							},
							{
								xtype: 'label',
								text:"",
								labelSeparator: ' ',
								id:'usersCnt',
								margin: '5 5 5 10'
							},
							{
								xtype:'tbfill',
							},
							{
								xtype: 'toolbar',
								ui: 'footer',
								items: [
									{
										xtype: 'trigger',
										labelAlign: 'top',
										labelSeparator: ' ',
										itemId: 'searchTrigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										cls: 'whitedropdown_search',
										emptyText: 'Search user',
										disabled: true,
										getTriggerMarkup: function() {
											var me = this,
											i = 0,
											hideTrigger = (me.readOnly || me.hideTrigger),
											triggerCls,
											triggerBaseCls = me.triggerBaseCls,
											triggerConfigs = [],
											unselectableCls = Ext.dom.Element.unselectableCls,
											style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
											cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}
											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function()
										{
											this.reset();
										},
										onTrigger2Click: function()
										{
											ctrler.onSearchAction(this);
										}
									}
								]
							}
						]
					});
					store.load();
				}

				var resultMsg = setCountLabelTitle(fromUserType,usertype,publicJSON);
				if (!Ext.isEmpty(resultMsg))
				{
					Ext.getCmp('usersCnt').show();
					Ext.getCmp('usersCnt').update(resultMsg);
				}
				else
				{
					Ext.getCmp('usersCnt').hide();
				}

				if (this.getUsernames().down('#searchTrigger'))
				{
					this.getUsernames().down('#searchTrigger').enable();
				}

			}
			else
			{
				Ext.getCmp('gridCont').hide();
				Ext.getCmp('defaultCont').hide();
				if (this.getUsernames().down('#searchTrigger'))
				{
					this.getUsernames().down('#searchTrigger').disable();
				}

				Ext.getCmp('saveCSV').disable();
				Ext.getCmp('NoUserAvailable').show();
			}

			getPanelObj.doLayout();
			getElObj.unmask();
		}
	},
	dateWiseUserNames : function()
	{
		var date = Ext.getCmp('datepick').getValue();
		var datePickVal = date.toString().substring(4,15);
		var nextDate = Ext.Date.add (date,Ext.Date.DAY,1);
		date = Ext.util.Format.date(nextDate, 'm/d/Y');
		var usertype='all';
		var urlStr = "License/data/UserNamesJson.jsp?date="+date+"&datePickVal="+datePickVal+'&usertype='+usertype;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var mainContainerObj = Ext.getCmp('licenseviewport');
		mainContainerObj.removeAll();
		mainContainerObj.add({
			xtype : 'usernames'
		});

		var isDefaultViewInUserNames = publicJSON.isDefaultViewInUserNames;
		var currDate = new Date(publicJSON.datePick);
		var dval = Ext.Date.format(currDate, mgrDateFormat);            
		Ext.getCmp('datepick').setValue(dval);

		if (isDefaultViewInUserNames)
		{
			if(fromUserType == "NamedUsers")
			{
				Ext.getCmp('totCnt').update("Total Named Users: "+publicJSON.totCount);
			}
			else
			{
				Ext.getCmp('totCnt').update("Total Concurrent Users: "+publicJSON.totCount);
			}


			if(publicJSON.totCount > 0)
			{
				Ext.getCmp('saveCSV').enable();
				Ext.getCmp('NoUserAvailable').hide();
				var ctxFldSetObj = Ext.getCmp('ctxFldSet');
				var vdiFldSetObj = Ext.getCmp('vdiFldSet');
				var trmFldSetObj = Ext.getCmp('trmFldSet');
				Ext.getCmp('gridCont').hide();
				Ext.getCmp('defaultCont').show();

				if(publicJSON.ctxCount > 0)
				{
					ctxFldSetObj.show();
					ctxFldSetObj.setTitle("Citrix Users ("+publicJSON.ctxCount+")");
				}
				else
				{
					Ext.getCmp('totCnt').hide();
					Ext.getCmp('ctxFldSet').hide();
					Ext.getCmp('vdiFldSet').hide();
					Ext.getCmp('trmFldSet').hide();
				}
				if(publicJSON.vdiCount > 0)
				{
					vdiFldSetObj.show();
					vdiFldSetObj.setTitle("VDI Users ("+publicJSON.vdiCount+")");
				}
				else
				{
					vdiFldSetObj.hide();
				}
				if(publicJSON.trmCount > 0)
				{
					trmFldSetObj.show();
					trmFldSetObj.setTitle("Cloud/Teminal Users  ("+publicJSON.trmCount+")");
				}
				else
				{
					trmFldSetObj.hide();
				}
				
				var ctxObj = Ext.getCmp('ctxData');
				ctxObj.tpl=tplData;
				ctxObj.update(publicJSON.ctxUsers);

				var vdiObj = Ext.getCmp('vdiData');
				vdiObj.tpl=tplData;
				vdiObj.update(publicJSON.vdiUsers);

				var trmObj = Ext.getCmp('trmData');
				trmObj.tpl=tplData;
				trmObj.update(publicJSON.trmUsers);
			}
			else
			{
				Ext.getCmp('gridCont').hide();
				Ext.getCmp('defaultCont').hide();
				Ext.getCmp('NoUserAvailable').show();
			}
		}
		else
		{
			var getElObj = Ext.getCmp('userNames').getEl();
			var getPanelObj = Ext.getCmp('gridCont');
			getElObj.mask("Loading...","maskCenter");
			if (publicJSON.totCount > 0)
			{
				Ext.getCmp('saveCSV').enable();
				Ext.getCmp('NoUserAvailable').hide();
				Ext.getCmp('gridCont').show();
				Ext.getCmp('defaultCont').hide();

				var allUsersDataArr = publicJSON['selectedUsersDataArr'];
				if ( !Ext.isEmpty(allUsersDataArr))
				{
					var gridColArr = publicJSON['columnArr'];
					var genStoreModel = new Array();
					var colArr = new Array();
					for ( var i = 0; i < gridColArr.length; i++ )
					{
						var columnWidth = 65;
						if ( i == 0 || ( i == gridColArr.length - 1 ) )
						{
							columnWidth = 170;
						}
						genStoreModel[genStoreModel.length] = gridColArr[i];
						colArr.push({
							header: gridColArr[i],
							minWidth: columnWidth,
							flex: 0.2,
							dataIndex: gridColArr[i],
							renderer: function( val )
							{
								return '<div style="white-space:normal !important;word-wrap:break-word;">'+ val +'</div>';
							}
						});
					}
					
					Ext.define('GridModel', {
						extend: 'Ext.data.Model',
						fields: gridColArr
					});

					 // create the Data Store
					var store = Ext.create('Ext.data.Store', {
						pageSize: 250,
						model: 'GridModel',
						proxy: {
							type: 'ajax',
							url: urlStr,
							reader: {
								type: 'json',
								root: 'selectedUsersDataArr',
								totalProperty: 'totalProperty',
							}
						},
						storeId: 'store',
						sorters: [{
							property: 'User',
							direction: 'ASC'
						}],
						remoteFilter: true,
						remoteSort: false
					});

					getPanelObj.add({
						xtype: 'customgrid',
						cls:'gridSkin',
						id:'userGrid',
						margin: 10,
						flex:1,
						//loadMask: true,
						scroll: true,
						height: 380,
						autoScroll: true,
						store: store,
						dockedItems:[{
							xtype: 'pagingtoolbar',
							id:'pagingtoolbarid',
							store: store,
							dock: 'bottom',
							cls:'pagingtoolbar',
							displayInfo: true
						}],
						columns: colArr,
						tbar: [
							{
								xtype:'scrollcombo',
								editable : false,
								fieldLabel:'User type',
								itemId: 'filterby',
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : [
										{'displayField':'All','valueField':'all'},
										{'displayField':'Citrix users','valueField':'ctxusers'},
										{'displayField':'VDI users','valueField':'vdiusers'},
										{'displayField':'Cloud/Terminal users','valueField':'termusers'}
									]
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								value : 'all',
								queryMode : 'local',
								labelAlign: 'left',
								labelSeparator: ' ',
								width: 250,
								labelWidth: 80,
								margin: '5 5 5 0',
								listeners:{
									select: function() {
										ctrler.getSelectedUsersData(this);
									}
								}
							},
							{
								xtype: 'label',
								text:"",
								labelSeparator: ' ',
								id:'usersCnt',
								margin: '5 5 5 10'
							},
							{
								xtype:'tbfill',
							},
							{
								xtype: 'toolbar',
								ui: 'footer',
								items: [
									{
										xtype: 'trigger',
										labelAlign: 'top',
										labelSeparator: ' ',
										itemId: 'searchTrigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										cls: 'whitedropdown_search',
										emptyText: 'Search user',
										disabled: true,
										getTriggerMarkup: function() {
											var me = this,
											i = 0,
											hideTrigger = (me.readOnly || me.hideTrigger),
											triggerCls,
											triggerBaseCls = me.triggerBaseCls,
											triggerConfigs = [],
											unselectableCls = Ext.dom.Element.unselectableCls,
											style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
											cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}
											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function()
										{
											this.reset();
										},
										onTrigger2Click: function()
										{
											ctrler.onSearchAction(this);
										}
									}
								]
							}
						]
					});
					store.load();
				}

				var resultMsg = setCountLabelTitle(fromUserType,usertype,publicJSON);
				if (!Ext.isEmpty(resultMsg))
				{
					Ext.getCmp('usersCnt').show();
					Ext.getCmp('usersCnt').update(resultMsg);
				}
				else
				{
					Ext.getCmp('usersCnt').hide();
				}

				if (this.getUsernames().down('#searchTrigger'))
				{
					this.getUsernames().down('#searchTrigger').enable();
				}
			}
			else
			{
				//Ext.getCmp('totCnt').hide();
				//Ext.getCmp('ctxFldSet').hide();
				//Ext.getCmp('vdiFldSet').hide();
				//Ext.getCmp('trmFldSet').hide();
				Ext.getCmp('gridCont').hide();
				Ext.getCmp('defaultCont').hide();
				if (this.getUsernames().down('#searchTrigger'))
				{
					this.getUsernames().down('#searchTrigger').disable();
				}
				Ext.getCmp('saveCSV').disable();
				Ext.getCmp('NoUserAvailable').show();
			}

			getPanelObj.doLayout();
			getElObj.unmask();
		}
	},
	saveInCSVUserNames: function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage+"&filePrefix="+csvfilename;
	},
	saveInCSVFormat: function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage;
	},
	saveInCSVFormatUser: function()
	{
		var filePrefix = "UserWiseLicenseUsageReport";
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = "License/data/ZoneAndUserWiseReportJson.jsp?tab=User&searchStr="+searchStr;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false
		});
		
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage+"&filePrefix="+filePrefix;
	},
	saveInCSVFormatOrg: function()
	{
		var filePrefix = "OrgWiseLicenseUsageReport";
		var searchStr = Ext.getCmp('searchbox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = "License/data/LicenseUsageByOrgJson.jsp?searchStr="+searchStr;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false
		});
		
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage+"&filePrefix="+filePrefix;
	},
	saveInCSVFormatUserNew: function ()
	{
		var c = "UserWiseLicenseUsageReport";
		var a = Ext.getCmp("searchBox").getValue();
		a = encodeURIComponent(a);
		var b = "License/data/LicenseUsageForUserJson.jsp?tab=User&searchStr=" + a;
		Ext.Ajax.request(
		{
			url: b,
			method: "POST",
			async: false,
			waitMsg: 'downloading csv...',
		});
		window.location.href = "/final/servlet/com.eg.SaveInCSVFormat?user_language=" + userLanguage + "&filePrefix=" + c;
	},
	saveInCSVFormatZone: function()
	{
		var filePrefix = "ZoneWiseLicenseUsageReport";
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = "License/data/ZoneAndUserWiseReportJson.jsp?tab=Zone&searchStr="+searchStr;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false
		});
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage+"&filePrefix="+filePrefix;
	},
	saveInCSVTotalUsage: function()
	{
		var filePrefix = "TotalLicenseUsage";
		var urlStr = "License/data/EgLicenseInfoJson.jsp";
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false
		});
	window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage+"&filePrefix="+filePrefix;

	},
	goBack: function()
	{
		this.buildMainData();
		var mainContainerObj = Ext.getCmp('licenseviewport');
		mainContainerObj.removeAll();
		mainContainerObj.add({
			xtype : 'licenseinfo'
		});
		if(selectedTab == 'certUsage')
		{
			Ext.getCmp('certInfoTab').setActiveTab(1);
		}
		else 
		{
			Ext.getCmp('certInfoTab').setActiveTab(3);
		}
	},
	goToAgentStatus: function()
	{
		window.location.href="/final/admin/EgServerList.jsp?from=licenseoverview";
	},
	goHome: function()
	{
		window.location.href=backHref;
	},
	showDetails: function(attribute)
	{
		var urlStr = "License/data/UsedCountDetailsJson.jsp?attribute="+attribute;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var mainContainerObj = Ext.getCmp('licenseviewport');
		mainContainerObj.removeAll();
		mainContainerObj.add({
			xtype : 'usedcountdetails'
		});

		Ext.getCmp('usedCount').update(attribute+" : "+publicJSON.count);
		var detailsObj = Ext.getCmp('attributeData');
		detailsObj.tpl=tplData;
		detailsObj.update(publicJSON.details);
	},
	showZoneDetails: function(zoneAttr,zoneName)
	{
		var idx = zoneAttr.indexOf(",");
		var zoneName = zoneAttr.substring(idx+1);
		var zoneTrim = ','+zoneName;
		zoneAttr = zoneAttr.replace(zoneTrim,"");
		var urlStr = "License/data/UsedCountDetailsJson.jsp?zoneAttr="+zoneAttr+"&zoneName="+zoneName;
		
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var mainContainerObj = Ext.getCmp('licenseviewport');
		mainContainerObj.removeAll();
		mainContainerObj.add({
			xtype : 'usedcountdetails'
		});
		Ext.getCmp('usedCount').update(publicJSON.zoneName+":"+" "+zoneAttr+" : "+publicJSON.count);
		var detailsObj = Ext.getCmp('attributeData');
		detailsObj.tpl=tplData;
		detailsObj.update(publicJSON.details);
	},
	orgTabLoad: function()
	{
		var urlStr = "License/data/LicenseUsageByOrgJson.jsp";
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var isUsersCreated = publicJSON['isUsersCreated'];
					if (isUsersCreated != false)
					{
						var rootData = {
							text: 'Choose Organization / Organizational Unit',
							id: '-1',
							name: '-1',
							expanded: true,
							children:publicJSON['exportDataArr']
						};
						var gridObj = Ext.getCmp('unameTree');
						gridObj.setRootNode(rootData);
						gridObj.show();
						var elemNoData = Ext.getElementById('noUserFound');
						if (elemNoData)
						{
							elemNoData.style.display = "none";
						}

						var isUserBasedLic = ((publicJSON.isMgrUsedBased != undefined || publicJSON.isMgrUsedBased != "") && publicJSON.isMgrUsedBased == "true");
						if (isUserBasedLic)
						{
							gridObj.columns[5].show();
							gridObj.getView().refresh();
						}
						else if(!isUserBasedLic)
						{
							gridObj.columns[5].hide();
						}
					}
				}
			}
		});
	},
	userWiseTabLoad: function()
	{
		var urlStr = "License/data/ZoneAndUserWiseReportJson.jsp?tab=User";
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		user_colCount = 3;
		var gridObj = Ext.getCmp('UserWiseGrid');
		gridObj.getStore().loadRawData(publicJSON.gridDetails);

		if (publicJSON.enableSearch)
		{
			Ext.getCmp('searchBox').enable();
		}
		else
		{
			gridObj.store.loadData('');
			gridObj.normalGrid.getView().emptyText = '<table align="center" height="300px"><tr><td align="center" ><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noUsers+'</td></tr></table></td></tr></table>';
			gridObj.normalGrid.getView().refresh();

			//Ext.get('noUsersAlrtDiv').update(noUsers);
			Ext.getCmp('searchBox').disable();
			Ext.getCmp('saveCSVUser').disable();
		}
		if (publicJSON.hideExtAgtCol)
		{
			gridObj.normalGrid.columns[3].hide();
		}else
		{
			gridObj.normalGrid.columns[3].show();
			user_colCount += 1;
		}
		if (publicJSON.hideUserCertCol)
		{
			gridObj.normalGrid.columns[4].hide();
		}else
		{
			gridObj.normalGrid.columns[4].show();
			user_colCount += 1;
		}
		if (publicJSON.hideMonTrgtsCol)
		{
			gridObj.normalGrid.columns[5].hide();
		}else
		{
			gridObj.normalGrid.columns[5].show();
			user_colCount += 1;
		}
		if (publicJSON.hideAppsCol)
		{
			gridObj.normalGrid.columns[6].hide();
		}else 
		{
			gridObj.normalGrid.columns[6].show();
			user_colCount += 1;
		}
		if (publicJSON.hideNwDevsCol)
		{
			gridObj.normalGrid.columns[7].hide();
		}else 
		{
			gridObj.normalGrid.columns[7].show();
			user_colCount += 1;
		}
		if (publicJSON.hideServsCol)
		{
			gridObj.normalGrid.columns[8].hide();
		}else 
		{
			gridObj.normalGrid.columns[8].show();
			user_colCount += 1;
		}
		if (publicJSON.hideSegsCol)
		{
			gridObj.normalGrid.columns[9].hide();
		}else 
		{
			gridObj.normalGrid.columns[9].show();
			user_colCount += 1;
		}
	},
	searchUser: function()
	{
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr=filterEncode(searchStr);
		searchStr = encodeURIComponent(searchStr);
		var urlStr = "License/data/ZoneAndUserWiseReportJson.jsp?tab=User&searchStr="+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('UserTrigger_0').setStyle('display','none');
			Ext.get('UserTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('UserTrigger_1').setStyle('display','none');
			Ext.get('UserTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		Ext.getCmp('UserWiseGrid').getStore().loadRawData(publicJSON.gridDetails);
	},
	zoneWiseTabLoad: function()
	{
		var urlStr = "License/data/ZoneAndUserWiseReportJson.jsp?tab=Zone";
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		colCount = 4;
		var gridObj = Ext.getCmp('ZoneWiseGrid');
		gridObj.getStore().loadRawData(publicJSON.gridDetails);
		if (publicJSON.enableSearch)
		{
			Ext.getCmp('searchBoxZone').enable();			
		}
		else
		{
			gridObj.store.loadData('');
			gridObj.normalGrid.getView().emptyText = '<table align="center" height="300px"><tr><td align="center" ><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noZones+'</td></tr></table></td></tr></table>';
			gridObj.normalGrid.getView().refresh();

			//Ext.get('noZonesAlrtDiv').update(noZones);
			Ext.getCmp('searchBoxZone').disable();
			Ext.getCmp('saveCSVZone').disable();
		}
		if (publicJSON.hideUserCertCol)
		{
			gridObj.normalGrid.columns[4].hide();
		}else
		{
			colCount += 1;
			gridObj.normalGrid.columns[4].show();
		}
		if (publicJSON.hideMonTrgtsCol)
		{
			gridObj.normalGrid.columns[5].hide();
		}else
		{
			gridObj.normalGrid.columns[5].show();
			colCount += 1;
		}
		if (publicJSON.hideAppsCol)
		{
			gridObj.normalGrid.columns[6].hide();
		}else 
		{
			gridObj.normalGrid.columns[6].show();
			colCount += 1;
		}
		if (publicJSON.hideNwDevsCol)
		{
			gridObj.normalGrid.columns[7].hide();
		}else 
		{
			gridObj.normalGrid.columns[7].show();
			colCount += 1;
		}
		if (publicJSON.hideServsCol)
		{
			gridObj.normalGrid.columns[8].hide();
		}else 
		{
			gridObj.normalGrid.columns[8].show();
			colCount += 1;
		}
		if (publicJSON.hideSegsCol)
		{
			gridObj.normalGrid.columns[9].hide();
		}else 
		{
			gridObj.normalGrid.columns[9].show();
			colCount += 1;
		}
	},
	searchZone: function()
	{
		var searchStr = Ext.getCmp('searchBoxZone').getValue();
		searchStr = filterEncode(searchStr);
		searchStr = encodeURIComponent(searchStr);
		var urlStr = "License/data/ZoneAndUserWiseReportJson.jsp?tab=Zone&searchStr="+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('ZoneTrigger_0').setStyle('display','none');
			Ext.get('ZoneTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('ZoneTrigger_1').setStyle('display','none');
			Ext.get('ZoneTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		
		Ext.getCmp('ZoneWiseGrid').getStore().loadRawData(publicJSON.gridDetails);
	},
	userWiseTabLoadNew: function ()
	{
		var b = "License/data/LicenseUsageForUserJson.jsp?tab=User";
    		Ext.Ajax.request(
    		{
      			url: b,
      			method: "POST",
      			async: false,
      			success: function (c)
      			{
        			if (c.status == 200 && !Ext.isEmpty(c.responseText))
        			{
          				var d = c.responseText;
          				publicJSON = Ext.decode(d);
        			}
      			}
    		});
    		var a = Ext.getCmp("UserWiseNewGrid");
    		a.getStore().loadRawData(publicJSON.gridNewDetails);
  	},
	showManagerInfo: function ()
	{
		var clustDetailsObj = Ext.getCmp('managerInfo');
		var isClusterDetailsWinOpen = !Ext.isEmpty(clustDetailsObj);
		if(isClusterDetailsWinOpen)
		{
			clustDetailsObj.destroy();
		}
		var htmlText = '<table border="0">'
						+'<tr><th style="padding:5px;text-decoration:underline;">'+manager+'</th>'
						+'<th style="padding:5px;text-decoration:underline;">'+url+'</th></tr>'
						+'<tr><td style="padding:5px">'+primary+'</td><td style="padding:5px">'+primaryManager+'</td></tr>'
						+'<tr><td style="padding:5px">'+secondary+'</td><td style="padding:5px">'+secondaryManager+'</td></tr>'
						+'</table>';
		var x = Ext.getCmp("certInfoTab1").getBox().x;
		var y = Ext.getCmp("certInfoTab1").getBox().y;
		var x1 = Ext.getCmp("clusType").getBox().x;
		var y1 = Ext.getCmp("clusType").getBox().y;
		var xAxis = x + (x1-84);
		var yAxis = y + (y1-54);
		var offset = 130;
		if (x1 <= 58)
		{
			xAxis = x + (x1-94);
			//offset = 80;
			//x1 = 222;
		}
		Ext.create("Ext.tip.ToolTip",
		{
			target: "clusType",
			height: 120,
			width: 250,
			maxWidth: 900,
			
			anchor: "top",
			anchorOffset: offset,
			//mouseOffset:[-65,0],
			dismissDelay:60000,
			id: "managerInfo",
			cls: "adminInfoTooltip" ,
			title : 'Cluster Details',
			listeners: {
				hide: function ()
				{
					this.destroy();
				}
			},
			html: htmlText
		}).showAt([xAxis, yAxis]);//.show();//
	}
});

function dateValidation(k, e) {
	var fromyear = parseInt(k.substring((k.lastIndexOf("/") + 1)));
	var fromdate = parseInt(k.substring((k.indexOf("/") + 1), k.lastIndexOf("/")));
	var frommonth = parseInt(k.substring(0, k.indexOf("/")));
	var toyear = parseInt(e.substring((e.lastIndexOf("/") + 1)));
	var todate = parseInt(e.substring((e.indexOf("/") + 1), e.lastIndexOf("/")));
	var tomonth = parseInt(e.substring(0, e.indexOf("/")));
	var b = 0;
	if (fromyear > toyear) 
	{
		b = -1;
	} 
	else 
	{
		if (fromyear == toyear)
		{
			if (frommonth > tomonth)
			{
				b = -1;
			} 
			else 
			{
				if (frommonth == tomonth)
				{
					if (fromdate > todate)
					{
						b = -1;
					} 
				}
			}
		}
	}
	return b;
}

function setCountLabelTitle(fromUserType,usertype,publicJSON)
{
	var resultLbl="";
	var count = publicJSON.totalProperty;
	if (usertype.toLowerCase() != 'all')
	{
		if (usertype.toLowerCase() == 'ctxusers' )
		{
			if (count != 0)
			{
				resultLbl = 'Total Citrix Users: '+count;
			}
		}
		else if (usertype.toLowerCase() == 'vdiusers' )
		{
			if (count != 0)
			{
				resultLbl = 'Total VDI Users: '+count;
			}
		}
		else if (usertype.toLowerCase() == 'termusers' )
		{
			if (count != 0)
			{
				resultLbl = 'Total Cloud/Terminal Users: '+count;
			}
		}
	}
	else
	{
		if(fromUserType == "NamedUsers")
		{
			if (count != 0)
			{
				resultLbl = "Total Named Users: "+count;
			}
		}
		else
		{
			if (count != 0)
			{
				resultLbl = "Total Concurrent Users: "+count;
			}
		}
	}

	return resultLbl;
}

function egTitleSearch()
{
	var obj = Ext.getCmp("unameTree");
	var egTitleSearchStr = Ext.getCmp('searchbox').getValue();
	var firstId = 'MyTrigger_searchbox_0';
	var secondId = 'MyTrigger_searchbox_1';

	if (egTitleSearchStr == "" || egTitleSearchStr .length == 0)
	{
		Ext.get(firstId).setStyle('display','none');
		Ext.get(secondId).setStyle('display','block');
	}
	else
	{
		Ext.get(secondId).setStyle('display','none');
		Ext.get(firstId).setStyle('display','block');
	}
	if(egTitleSearchStr==null || egTitleSearchStr=="")
	{
		Ext.getCmp('unameTree').filterBy(egTitleSearchStr, 'UserID');
		//No data found message removal
		var elemNoData = Ext.getElementById('noDataFound');
		if (elemNoData)
		{
			elemNoData.style.display = "none";
		}
	}
	else
	{
		Ext.getCmp('unameTree').filterBy(egTitleSearchStr, 'UserID');
	}
}



