var CCUsersCertCheck = true;
var x1 = 100, x2 = 100;

Ext.define('License.view.LicenseInfo', {
	extend: 'Ext.form.Panel',
	alias: 'widget.licenseinfo',
	cls:'outerpanel',
	requires: [
		'Ext.ux.layout.Center',
		'utilities.CustomGrid',
		'Ext.ux.grid.FiltersFeature'
	],

	title: pageTitle,
	margin: '8 8 0 8',

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	tools: [
		{
			xtype : 'button',
			text : back,
			cls:'backbutton',
			id : 'backBtnMain',
			iconCls:'iconBack',
			hidden : true
		}
	],

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+'.</center>',
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'tabpanel',
			cls:'tablayout border_alt',
			style:{'box-shadow': 'none','-webkit-box-shadow': 'none','-moz-box-shadow': 'none'},
			plain: true,
			tabPosition: 'top',
			flex: 1,
			defaults: {
				autoScroll: true
			},
			id:'certInfoTab',
			margin:10,
			listeners: {
				'tabchange': function(tabPanel, newCard, oldCard, eOpts ) {
					selectedTab = tabPanel.getActiveTab().id;
					ctrler.tabchange(newCard.itemId);
					var clustDetailsObj = Ext.getCmp('managerInfo');
					var isClusterDetailsWinOpen = !Ext.isEmpty(clustDetailsObj);
					if(isClusterDetailsWinOpen)
					{
						clustDetailsObj.destroy();
					}
				}
			},
			items: [
				{
					title: certInfo,
					itemId:'tab1',
					id: "certInfoTab1",
					items: [
						{
							xtype: 'container',
							layout: 'ux.center',
							margin: 20,
							items : [
								{
									xtype: 'fieldset',
									title: '<b>'+heading+'</b>',
									width: 900,
									margin: '10 10 10 10',
									items: [
										{
											xtype: 'container',
											layout: 'column',
											defaultType: 'displayfield',
											defaults: {
												labelAlign: 'top',
												labelSeparator: '',
												columnWidth: 0.25
											},
											items: [
												{
													fieldLabel: '<b>'+product+'</b>',
													value: '',
													id:'product',
													margin: '5 0 30 0'
												},
												{
													fieldLabel: '<b>'+version+'</b>',
													value: '',
													margin: '5 0 30 10',
													id:'version'
												},
												{
													fieldLabel: '<b>'+ipAddr+'</b>',
													value: '',
													margin: '5 0 30 10',
													id:'ipAddr'
												},
												{
													fieldLabel: '<b>'+hostID+'</b>',
													value: '',
													margin: '5 0 30 10',
													id:'hostID'
												},
												{
													fieldLabel: '<b>'+expDate+'</b>',
													value: '',
													margin: '0 0 30 0',
													id:'expDate'
												},
												{
													fieldLabel: '<b>'+certValid+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'certValid'
												},
												{
													fieldLabel: '<b>'+mailId+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'mailSender'
												},
												{
													fieldLabel: '<b>'+companyName+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'companyName'
												},
												{
													fieldLabel: '<b>'+clusType+'</b>',
													value: '',
													//margin: '0 0 30 0',
													id:'clusType',
													renderer: function (b)
													{
														var a = b;
														if(a != undefined && a != "Not supported")
														{
															a = b+'&nbsp;&nbsp;<a id="mouse" onclick="ctrler.showManagerInfo()"><img src="/final/images/spacer.gif" style="cursor:hand;vertical-align:text-bottom;" class="iconInformationSmall" title="Click here to know the cluster details"/></a>';
														}
														return a;
													}
												},
												{
													fieldLabel: '<b>'+ic+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'ic'
												},
												{
													fieldLabel: '<b>'+ttMgr+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'ttMgr'
												},
												{
													fieldLabel: '<b>'+dd+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'dd'
												},
												{
													fieldLabel: '<b>'+extSuperMgr+'</b>',
													value: '',
													margin: '0 0 30 0',
													id:'extSuperMgr'
												},
												{
													fieldLabel: '<b>'+egSuperMgr+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'egSuperMgr'
												},
												{
													fieldLabel: '<b>'+egReporter+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'egReporter'
												},
												{
													fieldLabel: '<b>'+remCtrlActs+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'remCtrlActs'
												},
												{
													fieldLabel: '<b>'+smsAlerts+'</b>',
													value: '',
													margin: '0 0 30 0',
													id:'smsAlerts'
												},
												{
													fieldLabel: '<b>'+configMgmt+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'configMgmt'
												},
												{
													fieldLabel: '<b>'+metricAgg+'</b>',
													value: '',
														margin: '0 0 30 10',
													id:'metricAgg'
												},
												{
													fieldLabel: '<b>'+agentPerSys+'</b>',
													value: '',
														margin: '0 0 30 10',
													id:'agentPerSys'
												},
												{
													fieldLabel: '<b>'+clntEmul+'</b>',
													value: '',
														margin: '0 0 30 0',
													id:'clntEmul'
												},
												{
													fieldLabel: '<b>'+advAnalytics+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'advAnalytics'
												},
												{
													fieldLabel: '<b>'+LicenseID+'</b>',
													value: '',
													margin: '0 0 30 10',
													id:'licenseId',
													hidden: true
												}
											]
										}
									]
								}
							]
						}
					]
				},
				{
					id : 'certUsage',
					title: certUsage,
					itemId:'tab2',
					items: [
						{
							xtype: 'customgrid',
							cls:'gridSkin',
							id:'grid1',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							flex: 1,
							store: new Ext.data.Store({
								fields: ['Attribute','Allowed','Used','Available','Usage','Running','NotRunning'],
								data: []
							}),
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: attribute,
										dataIndex: 'Attribute',
										width: 250
									},
									{
										text: allowed,
										dataIndex: 'Allowed',
										flex: 1
									},
									{
										text: used,
										dataIndex: 'Used',
										flex: 1,
										renderer: function(value) {
											var idx = value.indexOf("@#@");
											var tmpValue = value;
											var attribute = '';
											if (idx != -1)
											{
												tmpValue = value.substring(0,idx);
												attribute = value.substring(idx+3);
											}
											var result = tmpValue;
											if (tmpValue != 0)
											{
												result = '<a id="mouse" onClick="ctrler.showDetails(\''+attribute+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
											}
											return result;
										}
									},
									{
										text: available,
										dataIndex: 'Available',
										flex: 1
									},
									{
										text: usage+'(%)',
										dataIndex: 'Usage',
										flex: 1
									},
									{
										text: run,
										dataIndex: 'Running',
										flex: 1
									},
									{
										text: notRun,
										dataIndex: 'NotRunning',
										flex: 1
									}
								]
							},
							margin: '15 10 5 10',
							
							tbar: [
								{
									xtype: 'tbfill',
								},
								{
									xtype:'container',
									margin: 0,
									padding: 0,
									items:[
										{
											xtype:'button',
											id: 'saveCSVLicUsage',
											iconCls:'iconCsv',
											margin: 0,
											padding: 0,
											style:{
												background:'none',border:'0px'
											},
											listeners:{
												afterrender:function(){
													Ext.create("Ext.tip.ToolTip",{
														target:this.id,
														anchor:"top",
														cls:"yellowTip",
														trackMouse:true,
														html:"CSV"
													});
												}
											}
										}
									]
								},
								{
									xtype: 'toolbar',
									ui: 'footer',
									items: [
										{
											xtype: 'button',
											id: 'addbutton',
											cls: 'button20',
											text: agentStatus,
											id: 'agentStatus'
										}
									]
								}
							]
						},
						{
							xtype: 'customgrid',
							cls:'gridSkin',
							id:'grid2',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							flex: 1,
							store: new Ext.data.Store({
								fields: ['Attribute','Allowed','Used','Available','Usage'],
								data: []
							}),
							features: [{
								ftype: 'rowbody',
									getAdditionalData: function(data, idx, record, orig) {
									var headerCt = this.view.headerCt,
									colspan  = headerCt.getColumnCount();
									if (data.Attribute == 'Concurrent Users')
									{
										if(peakUsgCnt!="")
										{
											return {
											rowBody:
											'&nbsp;&nbsp;&nbsp;&nbsp;'+peakUsageCaption+' <a id="mouse" onClick="javascript:showHourlyGraph(\''+graphPeakDate+'\');"><style="cursor:hand;vertical-align:text-bottom;" title="Peak usage graph"/>'+peakUsgDate+'</a>'+peakUsageCaption2+ '<a id="mouse" onClick="ctrler.showPeakUserNames()"><style="cursor:hand;vertical-align:text-bottom;" title="Concurrent Users"/>&nbsp;'+peakUsgCnt+'&nbsp;</a>' + usersCert+".",
											rowBodyCls: this.rowBodyCls,
											rowBodyColspan: colspan
											};
										}
									}
									else if (data.Attribute == 'Named Users')
									{
										if(peakUsgCnt!="")
										{
											return {
											rowBody:
											'&nbsp;&nbsp;&nbsp;&nbsp;'+peakUsageCaption+' <style="cursor:hand;vertical-align:text-bottom;"/>'+peakUsgDate+peakUsageCaption2+ '<a id="mouse" onClick="ctrler.showPeakUserNames()"><style="cursor:hand;vertical-align:text-bottom;" title="Named Users"/>'+peakUsgCnt+'&nbsp;</a>' + usersCert+".",
											rowBodyCls: this.rowBodyCls,
											rowBodyColspan: colspan
											};
										}
									}
								}
							}, {
								ftype: 'rowwrap'
							}],
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: attribute,
										dataIndex: 'Attribute',
										width: 250,
										renderer: function(value) {
											var result = value;
											if (value == usersCert)
											{
												result = value + '&nbsp;&nbsp;&nbsp;&nbsp;<a id="mouse" onClick="ctrler.showGraph()"><img src="/final/images/spacer.gif" style="cursor:hand;vertical-align:text-bottom;" class="iconLineChart" title="Graph"/></a>';
												if (isNamedUsers == 'true')
												{
													
													result += '<a id="mouse" onClick="ctrler.showUserNames()">&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand;vertical-align:text-bottom;" class="iconUser" title="Named Users"/></a>';
												}
												else
												{
													if (CCUsersCertCheck != null && CCUsersCertCheck == true )
													{
														result += '<a id="mouse" onClick="ctrler.showUserNames()">&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand;vertical-align:text-bottom;" class="iconUser" title="Concurrent Users"/></a>';
													}
												}
											}
											return result;
										}
									},
									{
										text: allowed,
										dataIndex: 'Allowed',
										flex: 1
									},
									{
										text: used,
										dataIndex: 'Used',
										flex: 1,
										renderer: function(value) {
											var idx = value.indexOf("@#@");
											var tmpValue = value;
											var attribute = '';
											if (idx != -1)
											{
												tmpValue = value.substring(0,idx);
												attribute = value.substring(idx+3);
											}
											var result = tmpValue;
											if (tmpValue != 0 && attribute != '') // To avoid Named/ConCur users count
											{
												result = '<a id="mouse" onClick="ctrler.showDetails(\''+attribute+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';												
											}
											return result;
										}
									},
									{
										text: available,
										dataIndex: 'Available',
										flex: 1
									},
									{
										text: usage+' (%)',
										dataIndex: 'Usage',
										flex: 1
									}
								]
							},
							margin: '15 10 5 10',
						}
					]
				},
				{
					title: "License Usage",
					itemId: "tab5",
					id: "usrWiseTabNew",
					hidden: true,
					items: [
					{
						xtype: "customgrid",
						cls: "gridSkin",
						id: "UserWiseNewGrid",
						flex: 1,
						requires: "Ext.ux.grid.FiltersFeature",
						store: new Ext.data.Store(
						{
							fields: ["detailsName","allowedCount","currentlyUsed","availCount","currentUsage"],
							data: []
						}),
						columns: {
							defaults: {
								sortable: false,
								hideable: false,
								menuDisabled: true,
								draggable: false,
								resizable: false
							},
							items: [
							{
								text: "Attribute",
								dataIndex: "detailsName",
								flex: 1
							},
							{
								text: "Allowed",
								flex: 1,
								dataIndex: "allowedCount",
								defaults: {
									cls: "groupHeaderLeftAlign"
								}
							},
							{
								text: used,
								flex: 1,
								dataIndex: "currentlyUsed",
								defaults: {
									cls: "groupHeaderLeftAlign"
								}
							},
							{
								text: "Available",
								flex: 1,
								dataIndex: "availCount",
								defaults: {
									cls: "groupHeaderLeftAlign"
								}
							},
							{
								text: usage + " (%)",
								flex: 1,
								dataIndex: "currentUsage",
								defaults: {
									cls: "groupHeaderLeftAlign"
								},
								renderer : function(value){
									var strDecimal = value.substring(value.indexOf("."));
									value = value.substring(0,value.indexOf("."));
									var result="<center><div align='left' class='cell_border1 cell_border2'><span style='float:left;text-align:right;width:50%'>"+value+"</span><span style='float:right;text-align:left;width:50%'>"+strDecimal+"</span></div></center>";
									return result;
								}
							}]
						},
						margin: "15 10 5 10",
						viewConfig: {
							deferEmptyText: false,
							emptyText: '<table border="0" width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noUsersAlrtDiv">' + noUsersFound + ".</div></td></tr></table>"
						},
						tbar: [
						{
							xtype: "tbfill",
						},
						{
							xtype: "container",
							items: [
								{
									xtype: "button",
									id: "saveCSVUserNew",
									iconCls: "iconCsv",
									margin: 2,
									style: {
										background: "none",
										border: "0px"
									},
									listeners: {
										afterrender: function ()
										{
											Ext.create("Ext.tip.ToolTip",
											{
												target: this.id,
												anchor: "top",
												cls: "yellowTip",
												trackMouse: true,
												html: "CSV"
											});
										}
									}
								}
							]
						}]
					}]
				},
				{
					title: tab6Label,
					itemId: 'tab6',
					id: 'orgWiseTabNew',
					flex: 1,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'treepanel',
							id: 'unameTree',
							name: 'unameTree',
							flex: 1,
							frame: false,
							border: false,
							autoScroll: true,
							scroll: true,
							margin: 10,
							store: Ext.create('Ext.data.TreeStore', {
								fields: [
									{name: 'UserID', sortType:Ext.data.SortTypes.asUCString},
									'totMons_TotalCnt', 'totMons_UsedCnt', 'totMons_AvailCnt',
									'premMons_TotalCnt', 'premMons_UsedCnt', 'premMons_AvailCnt',
									'basMons_TotalCnt', 'basMons_UsedCnt', 'basMons_AvailCnt',
									'nwDev_TotalCnt', 'nwDev_UsedCnt', 'nwDev_AvailCnt',
									'userBased_TotalCnt', 'userBased_UsedCnt', 'userBased_PeakCnt', 'userBased_PeakDate',
									'userCnt_TotalCnt', 'userCnt_UsedCnt', 'userCnt_AvailCnt'
								],
								sorters: [{
									property: 'UserID',
									direction: 'ASC' 
								}]
							}),
							rootVisible: false,
							columns: [
								{
									xtype: 'treecolumn',
									dataIndex: 'UserID',
									width:300,
									style: 'padding-top:20px;',
									text: orgUnitName,
									renderer: function (e, b, a, g, d, c, f)
									{
										var nodeId = a.data['UserID'];
										b.tdAttr = "data-qtip='"+nodeId+"' data-qclass='yellowTip'";
										return nodeId;
									}
								},
								{
									text: totMons,
									flex: 1,
									defaults:{
										cls:'groupHeaderLeftAlign'
									},
									columns: [
										{
											text: allowed,
											id: 'user_totMons_TotalCnt',
											dataIndex: 'totMons_TotalCnt'
										},
										{
											text: used,
											id: 'user_totMons_UsedCnt',
											dataIndex: 'totMons_UsedCnt'
										},
										{
											text: available,
											id: 'user_totMons_AvailCnt',
											dataIndex: 'totMons_AvailCnt'
										}
									]
								},
								{
									text: basMons,
									flex: 1,
									defaults:{
										cls:'groupHeaderLeftAlign'
									},
									columns: [
										{
											text: allowed,
											id: 'user_basMons_TotalCnt',
											dataIndex: 'basMons_TotalCnt'
										},
										{
											text: used,
											id: 'user_basMons_UsedCnt',
											dataIndex: 'basMons_UsedCnt'
										},
										{
											text: available,
											id: 'user_basMons_AvailCnt',
											dataIndex: 'basMons_AvailCnt'
										}
									]
								},
								{
									text: preMons,
									flex: 1,
									defaults:{
										cls:'groupHeaderLeftAlign'
									},
									columns: [
										{
											text: allowed,
											id: 'user_premMons_TotalCnt',
											dataIndex: 'premMons_TotalCnt'
										},
										{
											text: used,
											id: 'user_premMons_UsedCnt',
											dataIndex: 'premMons_UsedCnt'
										},
										{
											text: available,
											id: 'user_premMons_AvailCnt',
											dataIndex: 'premMons_AvailCnt'
										}
									]
								},
								{
									text: nwDevs,
									flex: 1,
									defaults:{
										cls:'groupHeaderLeftAlign'
									},
									columns: [
										{
											text: allowed,
											id: 'user_nwDev_TotalCnt',
											dataIndex: 'nwDev_TotalCnt'
										},
										{
											text: used,
											id: 'user_nwDev_UsedCnt',
											dataIndex: 'nwDev_UsedCnt'
										},
										{
											text: available,
											id: 'user_nwDev_AvailCnt',
											dataIndex: 'nwDev_AvailCnt'
										}
									]
								},
								{
									text: usersCert,
									flex: 1,
									defaults:{
										cls:'groupHeaderLeftAlign'
									},
									columns: [
										{
											text: allowed,
											id: 'user_userBased_TotalCnt',
											dataIndex: 'userBased_TotalCnt'
										},
										{
											text: used,
											id: 'user_userBased_UsedCnt',
											dataIndex: 'userBased_UsedCnt'
										},
										{
											text: 'Peak usage last month',
											id: 'user_userBased_PeakCnt',
											dataIndex: 'userBased_PeakCnt'
										},
										{
											text: 'Peak usage date',
											id: 'user_userBased_PeakDate',
											dataIndex: 'userBased_PeakDate'
										}
									]
								},
								{
									text: monUser,
									flex: 1,
									defaults:{
										cls:'groupHeaderLeftAlign'
									},
									columns: [
										{
											text: allowed,
											id: 'user_userCnt_TotalCnt',
											dataIndex: 'userCnt_TotalCnt'
										},
										{
											text: used,
											id: 'user_userCnt_UsedCnt',
											dataIndex: 'userCnt_UsedCnt'
										},
										{
											text: available,
											id: 'user_userCnt_AvailCnt',
											dataIndex: 'userCnt_AvailCnt'
										}
									]
								}
							],
							tbar: [
								{ 
									xtype: 'tbfill' 
								},
								{
									xtype: 'toolbar',
									ui: 'footer',
									items:[
										{
											xtype:'button',
											id: 'saveCSVOrg',
											iconCls:'iconCsv',
											margin: 2,
											style:{
												background:'none',border:'0px'
											},
											listeners:{
												afterrender:function(){
													Ext.create("Ext.tip.ToolTip",{
														target:this.id,
														anchor:"top",
														cls:"yellowTip",
														trackMouse:true,
														html:"CSV"
													});
												}
											}
										}
									]
								},
								{
									xtype: 'trigger',
									name:'searchbox',
									id:'searchbox',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger', 
									cls: 'whitedropdown_search',
									emptyText: searchLbl,
									onTrigger1Click: function() {
										this.reset();
									},
									onTrigger2Click: function() {
										egTitleSearch();
									},
									listeners :
									{
										change : function(field, newVal)
										{
											egTitleSearch();
										},
										specialkey: function(field, e){
											// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
											// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
											if (e.getKey() == e.ENTER) {
												egTitleSearch();
											}
										}
									},
									getTriggerMarkup: function() {
										var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth-20 + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
										// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
										// single triggerCls config. Should rethink this, perhaps something more structured like a list of
										// trigger config objects that hold cls, handler, etc.
										// triggerCls is a synonym for trigger1Cls, so copy it.
										if (!me.trigger1Cls) {
											me.trigger1Cls = me.triggerCls;
										}
										// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
										for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
											if (i == 0)
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+me.id+'_'+i,
													style: style + "display:none;",
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
											else
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+me.id+'_'+i,
													style: style,
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
										}
										triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
										return Ext.DomHelper.markup(triggerConfigs);
									},
									disabled: false
								},
								{
									xtype: 'button',
									id : 'nodeExpand',
									iconCls: 'iconExpandAll',
									hidden:true,
									tooltip: 'Expand all',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										'click':function(obj){
											this.hide();
											Ext.getCmp('nodeCollapse').show();
											Ext.getCmp('unameTree').expandAll();
										}
									}
								},
								{
									xtype:'button',
									id :'nodeCollapse',
									iconCls: 'iconCollapseAll',
									hidden:false,
									tooltip: 'Collapse all',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners:{
										'click':function(obj){
											this.hide();
											Ext.getCmp('nodeExpand').show();
											Ext.getCmp('unameTree').collapseAll();
										}
									}
								}
							],
							listeners: {
								afterrender : function()
								{
									Ext.getCmp('unameTree').addCls("gridSkin");
									var view = this.getView();
									//No users available message
									var isUsersCreated = publicJSON['isUsersCreated'];
									if (isUsersCreated != null && isUsersCreated !== undefined && !isUsersCreated)
									{
										Ext.DomHelper.append(Ext.get(view.id), {
											tag: 'div',
											style:{'height':'9 0%','width':'100%','textAlign':'center','display': 'table'}, 
											cls: 'new-div-cls', 
											id: 'noUserFound',
											html: LoadAlert1
										});
									}
								}
							},
							clearFilter: function() {
								var view = this.getView();
								if (this.getRootNode())
								{
									this.getRootNode().cascadeBy(function(tree, view){
										var uiNode = view.getNodeByRecord(this);

										if(uiNode) {
											Ext.get(uiNode).setDisplayed('table-row');
										}
									}, null, [this, view]);

									//No data found message removal
									var elemNoData = Ext.getElementById('noDataFound');
									if (elemNoData)
									{
										elemNoData.style.display = "none";
									}
								}
							},
							filterBy: function(text, by) {
								this.clearFilter();

								var view = this.getView(),
									me = this,
									nodesAndParents = [];

								// Find the nodes which match the search term, expand them.
								// Then add them and their parents to nodesAndParents.
								if (this.getRootNode())
								{
									this.getRootNode().cascadeBy(function(tree, view){
										var currNode = this;
										if(currNode && currNode.data[by] && currNode.data[by].toString().toLowerCase().indexOf(text.toLowerCase()) > -1) {
											me.expandPath(currNode.getPath());

											while(currNode.parentNode) {
												nodesAndParents.push(currNode.id);
												currNode = currNode.parentNode;
											}
										}
									}, null, [me, view]);

									// Hide all of the nodes which aren't in nodesAndParents
									this.getRootNode().cascadeBy(function(tree, view){
										var uiNode = view.getNodeByRecord(this);
										if(uiNode && !Ext.Array.contains(nodesAndParents, this.id) && this.data.id != -1) {
											Ext.get(uiNode).setDisplayed('none');
										}
										
									}, null, [me, view]);

									//No data found message show
									if(Ext.isEmpty(nodesAndParents))
									{
										var elemNoData = Ext.getElementById('noDataFound');
										if (elemNoData == null || elemNoData === undefined)
										{
											Ext.DomHelper.append(Ext.get(view.id), {
												tag: 'div',
												style:{'height':'100%','width':'100%','textAlign':'center','display': 'table'}, 
												cls: 'new-div-cls', 
												id: 'noDataFound',
												html: LoadSearchAlert
											});
										}
										else
										{
											elemNoData.style.display = "table";
										}
									}
								}
							}
						}
					]
				},
				{
					title: usrWiseUsg,
					itemId:'tab3',
					id: 'usrWiseTab',
					hidden: true,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					flex: 1,
					listeners:{
						afterrender:function(tabPanel)
						{
							var totalCols = [];
							var colNames = ["user_totMons","user_basMons","user_preMons","user_extAgns","user_usersCert","user_monTrgs","user_apps","user_nwDevs","user_servcs","user_segmns"];
							var colSubNames = ["_TotalCnt","_TotalUsg"];
							var userWiseTab = Ext.getCmp("certInfoTab");
							var userName = Ext.getCmp("userName");
							var userWiseTabWidth = userWiseTab.getWidth();
							var userNameWidth = userName.getWidth();

							if(user_colCount <= 5)
							{
								userWiseTabWidth = userWiseTabWidth - (userNameWidth);
								var equalWidth = userWiseTabWidth / user_colCount;
								x2 = (equalWidth/2);

								for (var x=0; x<colNames.length; x++)
								{
									for (var y=0; y<colSubNames.length; y++)
									{
										totalCols.push(colNames[x]+colSubNames[y]);
									}
								}
								for(var i=0;i<totalCols.length;i++)
								{
									Ext.getCmp(totalCols[i]).setWidth(x2);
								}
							}
						}
					},
					items: [
						{
							xtype: 'customgrid',
							id:'UserWiseGrid',
							cls:'newGridSkin gridSkin_locking',
							flex: 1,
							lockedViewConfig: {
								emptyText: ''
							},
							requires: 'Ext.ux.grid.FiltersFeature',
							store: new Ext.data.Store({
								fields: ['Name','TotalCnt','TotalUsg',
												'PremiumCnt','PremiumUsg',
												'BasicCnt','BasicUsg',
												'ExtAgentCnt','ExtAgentUsg',
												'UserCnt','UserUsg',
												'MonTrgtCnt','MonTrgtUsg',
												'AppsCnt','AppsUsg',
												'NWDevicesCnt','NWDevicesUsg',
												'ServicesCnt','ServicesUsg',
												'SegmentsCnt','SegmentsUsg'
								],
								data: []
							}),
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items:[
									{
										text     : users,
										dataIndex: 'Name',
										id: 'userName',
										width    : 305,
										locked : true
									}, 
									{
										text: totMons,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_totMons_TotalCnt',
												dataIndex: 'TotalCnt'
											}, 
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_totMons_TotalUsg',
												dataIndex: 'TotalUsg'
											}
										]
									},
									{
										text: basMons,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_basMons_TotalCnt',
												dataIndex: 'BasicCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_basMons_TotalUsg',
												dataIndex: 'BasicUsg'
											}
										]
									},
									{
										text: preMons,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_preMons_TotalCnt',
												dataIndex: 'PremiumCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_preMons_TotalUsg',
												dataIndex: 'PremiumUsg'
											}
										]
									},
									{
										text: extAgns,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_extAgns_TotalCnt',
												dataIndex: 'ExtAgentCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_extAgns_TotalUsg',
												dataIndex: 'ExtAgentUsg'
											}
										]
									},
									{
										text: usersCert,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns:[
											{
												text	 : user4VDIUsrs,
												//width	 : userWidth,
												id: 'user_usersCert_TotalCnt',
												dataIndex: 'UserCnt'
											},
											{
												text	 : usage+' (%)',
												//width	 : 80,
												id: 'user_usersCert_TotalUsg',
												dataIndex: 'UserUsg'
											}
										]
									},
									{
										text: monTrgs,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_monTrgs_TotalCnt',
												dataIndex: 'MonTrgtCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_monTrgs_TotalUsg',
												dataIndex: 'MonTrgtUsg'
											}
										]
									},
									{
										text: apps,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_apps_TotalCnt',
												dataIndex: 'AppsCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_apps_TotalUsg',
												dataIndex: 'AppsUsg'
											}
										]
									},
									{
										text: nwDevs,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_nwDevs_TotalCnt',
												dataIndex: 'NWDevicesCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_nwDevs_TotalUsg',
												dataIndex: 'NWDevicesUsg'
											}
										]
									},
									{
										text: servcs,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_servcs_TotalCnt',
												dataIndex: 'ServicesCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_servcs_TotalUsg',
												dataIndex: 'ServicesUsg'
											}
										]
									},
									{
										text: segmns,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
												text     : used,
												//width    : 80,
												id: 'user_segmns_TotalCnt',
												dataIndex: 'SegmentsCnt'
											},
											{
												text     : usage+' (%)',
												//width    : 80,
												id: 'user_segmns_TotalUsg',
												dataIndex: 'SegmentsUsg'
											}
										]
									}
								]
								
							},
							margin: '15 10 5 10',
							viewConfig: {
								deferEmptyText: false,
								emptyText: '<table border="0" width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noUsersAlrtDiv">'+noUsersFound+'.</div></td></tr></table>'
							},
							tbar: [
								{
									xtype:'tbfill',
								},
								{
									xtype:'container',
									items:[
										{
											xtype:'button',
											id: 'saveCSVUser',
											iconCls:'iconCsv',
											margin: 0,
											style:{
												background:'none',border:'0px'
											},
											listeners:{
												afterrender:function(){
													Ext.create("Ext.tip.ToolTip",{
														target:this.id,
														anchor:"top",
														cls:"yellowTip",
														trackMouse:true,
														html:"CSV"
													});
												}
											}
										}
									]
								},
								{
									xtype: 'trigger',
									cls:'whitedropdown_search',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger',
									emptyText: 'Search',
									padding: '2 5 2 2',
									disabled:true,
									onTrigger1Click: function() {
										this.reset();
									},
									onTrigger2Click: function() {
										ctrler.searchUser();
									},
									id: 'searchBox',
									getTriggerMarkup: function() {
										var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
										// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
										// single triggerCls config. Should rethink this, perhaps something more structured like a list of
										// trigger config objects that hold cls, handler, etc.
										// triggerCls is a synonym for trigger1Cls, so copy it.
										if (!me.trigger1Cls) {
											me.trigger1Cls = me.triggerCls;
										}
										// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
										for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
											if (i == 0)
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'UserTrigger_'+i,
													style: style + "display:none;",
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
											else
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'UserTrigger_'+i,
													style: style,
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
										}
										triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
										return Ext.DomHelper.markup(triggerConfigs);
									}
								}
							]
						}
					]
				},
				{
					title: zonWiseUsg,
					itemId:'tab4',
					id: 'zoneWiseTab',
					hidden: true,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					flex: 1,
					listeners:{
						afterrender:function(tabPanel)
						{
							var totalCols = [];
							var colNames = ["totMons","basMons","preMons","extAgns","usersCert","monTrgs","apps","nwDevs","servcs","segmns"];
							var colSubNames = ["_TotalCnt","_TotalUsg"];
							var colSubNames2 = ["_UserCnt","_UserUsg","_peakUsg","_peakDate"];
							var zoneWiseTab = Ext.getCmp('certInfoTab');
							var zoneName = Ext.getCmp('zoneName');
							var zoneWiseTabWidth = zoneWiseTab.getWidth();
							var zoneNameWidth = zoneName.getWidth();

							if(colCount == 4 || colCount == 5)
							{
								zoneWiseTabWidth = zoneWiseTabWidth - (zoneNameWidth);
								var equalWidth = (zoneWiseTabWidth) / colCount;
								x1 = (equalWidth/2);

								for (var x=0; x<colNames.length; x++)
								{
									if (colNames[x] == "usersCert")
									{
										for (var y=0; y<colSubNames2.length; y++)
										{
											totalCols.push(colNames[x]+colSubNames2[y]);
										}
									}
									else
									{
										for (var y=0; y<colSubNames.length; y++)
										{
											totalCols.push(colNames[x]+colSubNames[y]);
										}
									}
								}
								for(var i=0;i<totalCols.length;i++)
								{
									Ext.getCmp(totalCols[i]).setWidth(x1);
								}
							}
						}
					},
					items: [
						{
							xtype: 'customgrid',
							id:'ZoneWiseGrid',
							cls:'newGridSkin gridSkin_locking',
							flex: 1,
							ui:'newGridPanel',
							lockedViewConfig: {
								emptyText: ''
							},
							requires: 'Ext.ux.grid.FiltersFeature',
							store: new Ext.data.Store({
								fields: ['Name','TotalCnt','TotalUsg',
												'PremiumCnt','PremiumUsg',
												'BasicCnt','BasicUsg',
												'ExtAgentCnt','ExtAgentUsg',
												'UserCnt','UserUsg','peakUsg','peakDate',
												'MonTrgtCnt','MonTrgtUsg',
												'AppsCnt','AppsUsg',
												'NWDevicesCnt','NWDevicesUsg',
												'ServicesCnt','ServicesUsg',
												'SegmentsCnt','SegmentsUsg'
								],
								data: []
							}),
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items:[
									{
										text     : zones,
										dataIndex: 'Name',
										id: 'zoneName',
										width    : 305,
										locked   : true
									}, 
									{
										text: totMons,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'TotalCnt',
											id: 'totMons_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != null)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+totMons+','+name+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'totMons_TotalUsg',
												dataIndex: 'TotalUsg'
											}
										]
									},
									{
										text: basMons,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'BasicCnt',
											id: 'basMons_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != null)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+basMons+','+name+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'basMons_TotalUsg',
												dataIndex: 'BasicUsg'
											}
										]
									},
									{
										text: preMons,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'PremiumCnt',
											id: 'preMons_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != null)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+preMons+','+name+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'preMons_TotalUsg',
												dataIndex: 'PremiumUsg'
											}
										]
									},
									{
										text: extAgns,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'ExtAgentCnt',
											id: 'extAgns_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != null)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+extAgns+','+name+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'extAgns_TotalUsg',
												dataIndex: 'ExtAgentUsg'
											}
										]
									},
									{
										text: usersCert,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns:[
											{
												text	 : user4VDIUsrs,
												id: 'usersCert_UserCnt',
												dataIndex: 'UserCnt'
											},
											{
												text	 : usage+' (%)',
												id: 'usersCert_UserUsg',
												dataIndex: 'UserUsg'
											},
											{
												text	 : 'Peak usage <br> last month',
												id: 'usersCert_peakUsg',
												dataIndex: 'peakUsg'
											},
											{
												text	 : 'Peak usage date',
												id: 'usersCert_peakDate',
												dataIndex: 'peakDate'
											}
										]
									},
									{
										text: monTrgs,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'MonTrgtCnt',
											id: 'monTrgs_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != null)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+monTrgs+','+name+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'monTrgs_TotalUsg',
												dataIndex: 'MonTrgtUsg'
											}
										]
									},
									{
										text: apps,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'AppsCnt',
											id: 'apps_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != null)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+apps+','+name+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'apps_TotalUsg',
												dataIndex: 'AppsUsg'
											}
										]
									},
									{
										text: nwDevs,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'NWDevicesCnt',
											id: 'nwDevs_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != null)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+nwDevs+','+name+'\')">'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'nwDevs_TotalUsg',
												dataIndex: 'NWDevicesUsg'
											}
										]
									},
									{
										text: servcs,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'ServicesCnt',
											id: 'servcs_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != 0)
												{
													result = '<a id="mouse" onClick="ctrler.showZoneDetails(\''+servcs+','+name+'\')">&nbsp;'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'servcs_TotalUsg',
												dataIndex: 'ServicesUsg'
											}
										]
									},
									{
										text: segmns,
										defaults:{
											cls:'groupHeaderLeftAlign'	
										},
										columns: [
											{
											text: used,
											dataIndex: 'SegmentsCnt',
											id: 'segmns_TotalCnt',
											renderer: function(val, meta, rec, rowIndex, colIndex, store)
												{
												var name = rec.data['Name'];
												var tmpValue = val;
												if (tmpValue != 0)
												{
													result = '<a id="mouse"onClick="ctrler.showZoneDetails(\''+segmns+','+name+'\')">&nbsp;'+tmpValue+'&nbsp;&nbsp;&nbsp;&nbsp;<img src="/final/images/spacer.gif" style="cursor:hand"/></a>';
												}
												return result;
											}
											},
											{
												text     : usage+' (%)',
												id: 'segmns_TotalUsg',
												dataIndex: 'SegmentsUsg'
											}
										]
									}
								]
								
							},
							margin: '15 10 5 10',
							viewConfig: {
								deferEmptyText: false,
								emptyText: '<table border="0" width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noZonesAlrtDiv">'+noZonesFound+'.</div></td></tr></table>'
							},
							tbar: [
								{
									xtype:'tbfill',
								},
								{
									xtype:'container',
									items:[
										{
											xtype:'button',
											id: 'saveCSVZone',
											iconCls:'iconCsv',
											margin: 0,
											style:{
												background:'none',border:'0px'
											},
											listeners:{
												afterrender:function(){
													Ext.create("Ext.tip.ToolTip",{
														target:this.id,
														anchor:"top",
														cls:"yellowTip",
														trackMouse:true,
														html:"CSV"
													});
												}
											}
										}
									]
								},
								{
									xtype: 'trigger',
									cls:'whitedropdown_search',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger',
									emptyText: 'Search',
									padding: '2 5 2 2',
									disabled:true,
									onTrigger1Click: function() {
										this.reset();
									},
									onTrigger2Click: function() {
										ctrler.searchUser();
									},
									id: 'searchBoxZone',
									getTriggerMarkup: function() {
										var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
										// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
										// single triggerCls config. Should rethink this, perhaps something more structured like a list of
										// trigger config objects that hold cls, handler, etc.
										// triggerCls is a synonym for trigger1Cls, so copy it.
										if (!me.trigger1Cls) {
											me.trigger1Cls = me.triggerCls;
										}
										// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
										for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
											if (i == 0)
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'ZoneTrigger_'+i,
													style: style + "display:none;",
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
											else
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'ZoneTrigger_'+i,
													style: style,
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
										}
										triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
										return Ext.DomHelper.markup(triggerConfigs);
									}
								}
							]
						}
					]
				},
			]
		}
	]
});

Ext.define('Ext.ux.fix.Ext.grid.column.Column', {
    override: 'Ext.grid.column.Column'

    ,isOnLeftEdge: function(e) {
        return this.el && this.callParent(arguments);
    }
});
Ext.define('Ext.ux.fix.Ext.grid.plugin.HeaderResizer', {
    override: 'Ext.grid.plugin.HeaderResizer'

    ,onHeaderCtMouseMove: function(e, t) {
        // we've got no problem when we're dragging
        if (!this.headerCt.dragging) {
            var headerEl = e.getTarget('.' + this.colHeaderCls, 3, true),
                overHeader = Ext.getCmp(headerEl.id);
            if (!overHeader.el) {
                // that's the crashy case, so we're stopping process here

                // ... but what about trying to understand how we could end
                // here in the first place? look around, there's something
                // to be found ;) !
                //debugger

                return;
            }
        }
        // we're safe, continue
        this.callParent(arguments);
    }
});
