<%
/*
 *	Name            :   UserNamesJson.jsp
 *	Purpose         :   To list all named users. 
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.eg.EgUsersInfo"%>

<%@ page import="java.util.HashMap"%>
<%@ page import="java.util.List"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Date"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "egurkha.reporter.ErGeoDetailsBean" %>


<%@ page import="org.json.simple.JSONObject"%>
<%@ page import="org.json.simple.JSONArray"%>
<%@ page import="org.json.simple.parser.JSONParser"%>

<%	
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();

	List csvData = new ArrayList();
	boolean isNamedUsers = EgInstallInfo.isnamedUserLicense;
	boolean isConcUsers = EgInstallInfo.isconcurrentUserLicense;
	//String from = request.getParameter("from");

	//if (from == null) 
	//{
	//	from = "NamedUsers";
	//}
	String start = request.getParameter("start");
	String pageLimit = request.getParameter("limit");
	String pageNo = request.getParameter("page");
	String userType = request.getParameter("usertype");
	String filter = request.getParameter("filter");
	boolean isSearchEnable = false;
	String searchStr = "";

	if(!StringUtils.isNull(filter))
	{
		JSONParser parser = new JSONParser();
		JSONArray jsonArr = (JSONArray) parser.parse(filter);
		JSONObject jsonObj = (JSONObject) jsonArr.get(0);
		searchStr = jsonObj.get("value").toString();
		if ((!StringUtils.isNull(searchStr)))
		{
			isSearchEnable = true;
		}
	}

	if (StringUtils.isNull(userType))
	{
		userType = "all";
	}

	int maxPageItems = 50;
	if (!StringUtils.isNull(pageLimit))
	{
		maxPageItems = Integer.parseInt(pageLimit);
	}
 
	String date = request.getParameter("date");
	String currentValue = request.getParameter("currentValue");
	String datePick = request.getParameter("datePickVal");
	String uiFile = "eg_ui.ini";
	String mgrMiscFile = "eg_mgrmisc.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String startDate = DateUtil.changeDateFormat(datePick,"MMM dd yyyy",currentDateFormat);
	EgUsersInfo usersInfo = new EgUsersInfo();
	HashMap users = new HashMap();

	com.eg.IniFile egMgrMisc = new com.eg.IniFile(s_iniFile_dir + mgrMiscFile);
	String userNamesViewFormat = egMgrMisc.getValue("License_Usage","UserNamesView");
	String strGeoColumns = egMgrMisc.getValue("License_Usage","GeoColumns");
	boolean isDefaultViewInUserNames = true;
	boolean isAllViewForGeoDetails = false;
	if (!StringUtils.isNull(userNamesViewFormat) && userNamesViewFormat.equalsIgnoreCase("GeoDetails"))
	{
		if (!StringUtils.isNull(userType) && userType.equalsIgnoreCase("all"))
		{
			isAllViewForGeoDetails = true;
		}
	}

	if (isNamedUsers)
	{
		if(currentValue != null && currentValue.equals("peakUsage"))
		{
			csvData.add("Peak usage report ");
		}
		else
		{
			csvData.add("Named Users Report");
		}
	}
	else if(isConcUsers)
	{
		if(currentValue != null && currentValue.equalsIgnoreCase("peakUsage") && !currentValue.equalsIgnoreCase("null"))
		{
			csvData.add("Peak usage report ");
		}
		else
		{
			csvData.add("Concurrent Users Report");
		}
	}

	if (isAllViewForGeoDetails)
	{
		users = usersInfo.getUserNamesForTheDay(date,false);
	}
	else
	{
		users = usersInfo.getUserNamesForTheDay(date);
	}

	ArrayList ctxUsrs = (ArrayList)users.get("Citrix Users");
	ArrayList vdiUsrs = (ArrayList)users.get("VDI Users");
	ArrayList trmUsrs = (ArrayList)users.get("Terminal Users");

	if (ctxUsrs == null) ctxUsrs = new ArrayList();
	if (vdiUsrs == null) vdiUsrs = new ArrayList();
	if (trmUsrs == null) trmUsrs = new ArrayList();

	int ctxCnt = ctxUsrs.size();
	int vdiCnt = vdiUsrs.size();
	int trmCnt = trmUsrs.size();
	int totCnt = ctxCnt + vdiCnt + trmCnt;

	rootJSON.put("date",date);
	rootJSON.put("datePick",datePick);
	rootJSON.put("ctxCount",ctxCnt);
	rootJSON.put("vdiCount",vdiCnt);
	rootJSON.put("trmCount",trmCnt);
	rootJSON.put("totCount",totCnt);

	csvData.add("");
	csvData.add("\"Report Date: "+startDate+"\"");
	csvData.add("");

	if (!StringUtils.isNull(userNamesViewFormat) && userNamesViewFormat.equalsIgnoreCase("GeoDetails"))
	{
		HashMap allUsers = new HashMap();

		ErGeoDetailsBean geoDetailBean = new ErGeoDetailsBean();
		allUsers = geoDetailBean.getValuesForAllUsersForAdminGraph();

		ArrayList allKeys = new ArrayList();
		Iterator itr = allUsers.keySet().iterator();
		while (itr.hasNext()) 
		{ 
			allKeys.add(itr.next());
		}
		
		if (!com.egurkha.util.StringUtils.isNull(strGeoColumns))
		{
			isDefaultViewInUserNames = false;
			JSONArray columnArr = new JSONArray();

			int eventCount = 0;
			int offsetCount = 0;
			if (start != null && !start.equals("NaN"))
			{
				offsetCount = Integer.parseInt(start);
			}
			int startPosition = offsetCount;

			if (userType.equalsIgnoreCase("all"))
			{
				ArrayList allData = new ArrayList();
				if (ctxUsrs != null && ctxUsrs.size() > 0)
				{
					allData.addAll(ctxUsrs);
				}

				if (vdiUsrs != null && vdiUsrs.size() > 0)
				{
					allData.addAll(vdiUsrs);
				}

				if (trmUsrs != null && trmUsrs.size() > 0)
				{
					allData.addAll(trmUsrs);
				}
				eventCount = allData.size();
				rootJSON.put("totalProperty",eventCount);
				rootJSON.put("selectedUserCount",eventCount);

				ArrayList resultData = new ArrayList();
				if (allData != null && eventCount > 0)
				{
					if (isSearchEnable)
					{
						allData = getSearchData(allData,searchStr,true);
						rootJSON.put("totalProperty",allData.size());

						// for CSV
						csvData.add("Search string is ,"+searchStr+"");
						csvData.add("");
						if (isNamedUsers)
						{
							csvData.add("Total named users,"+allData.size()+"");
						}
						else if(isConcUsers)
						{
							csvData.add("Total concurrent users,"+allData.size()+"");
						}
					}
					else
					{
						// for CSV
						if (ctxCnt > 0)
						{
							csvData.add("Citrix users,"+ctxCnt+"");
						}
						if (vdiCnt > 0)
						{
							csvData.add("VDI users,"+vdiCnt+"");
						}
						if (trmCnt > 0)
						{
							csvData.add("Cloud/Terminal users,"+trmCnt+"");
						}

						if (isNamedUsers)
						{
							csvData.add("Total named users,"+totCnt+"");
						}
						else if(isConcUsers)
						{
							csvData.add("Total concurrent users,"+totCnt+"");
						}
					}
					csvData.add("");


					columnArr = getColumnJsonArray(strGeoColumns,true);
					csvData.add(getStringFromJSONArray(columnArr));

					offsetCount += maxPageItems;
					int size = allData.size();
					int fromIndex = Math.max(0, startPosition);
					int toIndex = Math.min(size, offsetCount);

					resultData = new ArrayList(allData.subList(fromIndex , toIndex));
					if (resultData != null && resultData.size() > 0)
					{
						JSONArray allUsersDataArr = new JSONArray();

						for (int a=0;a<resultData.size();a++)
						{
							String strAllUser = resultData.get(a).toString();
							if (StringUtils.isNull(strAllUser))
							{
								continue;
							}

							JSONObject allUsersDetailsObj = new JSONObject();
							int idx = strAllUser.indexOf("#"); 
							if (strAllUser.startsWith("ctx#"))
							{
								strAllUser = strAllUser.substring(idx+1);
								allUsersDetailsObj.put("User",strAllUser);
								allUsersDetailsObj.put("User type","Citrix");
							}
							else if (strAllUser.startsWith("vdi#"))
							{
								strAllUser = strAllUser.substring(idx+1);
								allUsersDetailsObj.put("User",strAllUser);
								allUsersDetailsObj.put("User type","VDI");
							}
							else if (strAllUser.startsWith("trm#"))
							{
								strAllUser = strAllUser.substring(idx+1);
								allUsersDetailsObj.put("User",strAllUser);
								allUsersDetailsObj.put("User type","Cloud/Terminal");
							}

							
							HashMap allUserDetailsList = (HashMap) allUsers.get(strAllUser.toLowerCase());
							for (int col=0;col<columnArr.size();col++)
							{
								String strColumnName = columnArr.get(col).toString();
								if (!StringUtils.isNull(strColumnName) && (strColumnName.equalsIgnoreCase("User") || strColumnName.equalsIgnoreCase("User type")))
								{
									continue;
								}
								String strColumVal = "-";
								if (allUserDetailsList != null && allUserDetailsList.size() > 0)
								{
									strColumVal = allUserDetailsList.get(strColumnName).toString();
									if (StringUtils.isNull(strColumnName))
									{
										strColumVal = "-";
									}
								}
								allUsersDetailsObj.put(strColumnName,strColumVal);
							}
							allUsersDataArr.add(allUsersDetailsObj);
						}
						rootJSON.put("selectedUsersDataArr",allUsersDataArr);
					}
					ArrayList tmpList = getCSVdata(allUsers,allData,columnArr,isSearchEnable,searchStr);
					if (tmpList != null && tmpList.size() > 0)
					{
						csvData.addAll(tmpList);
					}
				}
			}
			else
			{
				columnArr = getColumnJsonArray(strGeoColumns,false);
				if (userType.equalsIgnoreCase("ctxusers"))
				{
					eventCount = ctxUsrs.size();
					rootJSON.put("selectedUserCount",eventCount);
					if (ctxUsrs != null && eventCount > 0)
					{
						rootJSON.put("totalProperty",eventCount);
						rootJSON.put("ctxUsersDataCnt",eventCount);

						if (isSearchEnable)
						{
							ctxUsrs = getSearchData(ctxUsrs,searchStr,false);
							rootJSON.put("totalProperty",ctxUsrs.size());

							// for CSV
							csvData.add("Search string is ,"+searchStr+"");
							csvData.add("");
						}

						csvData.add("Citrix Users ("+ctxUsrs.size()+")");
						csvData.add("");
						csvData.add(strGeoColumns.toUpperCase());

						ArrayList resultData = new ArrayList();
						offsetCount += maxPageItems;
						int size = ctxUsrs.size();
						int fromIndex = Math.max(0, startPosition);
						int toIndex = Math.min(size, offsetCount);
						resultData = new ArrayList(ctxUsrs.subList(fromIndex , toIndex));

						JSONArray ctxUsersDataArr = new JSONArray();
						if (resultData != null && resultData.size() > 0)
						{
							for (int c=0;c<resultData.size();c++)
							{
								String strCtxUser = resultData.get(c).toString();
								if (StringUtils.isNull(strCtxUser))
								{
									continue;
								}

								HashMap ctxUserDetailsList = (HashMap) allUsers.get(strCtxUser.toLowerCase());
								JSONObject ctxUsersDetailsObj = new JSONObject();
								ctxUsersDetailsObj.put("User",strCtxUser);
								for (int col=0;col<columnArr.size();col++)
								{
									String strColumnName = columnArr.get(col).toString();
									if (!StringUtils.isNull(strColumnName) && strColumnName.equalsIgnoreCase("User"))
									{
										continue;
									}
									String strColumVal = "-";
									if (ctxUserDetailsList != null && ctxUserDetailsList.size() > 0)
									{
										strColumVal = ctxUserDetailsList.get(strColumnName).toString();
										if (StringUtils.isNull(strColumnName))
										{
											strColumVal = "-";
										}
									}

									ctxUsersDetailsObj.put(strColumnName,strColumVal);
								}
								ctxUsersDataArr.add(ctxUsersDetailsObj);
							}
						}

						rootJSON.put("selectedUsersDataArr",ctxUsersDataArr);
						ArrayList tmpList = getCSVdataForSpecificUsers(allUsers,ctxUsrs,columnArr,isSearchEnable,searchStr);
						if (tmpList != null && tmpList.size() > 0)
						{
							csvData.addAll(tmpList);
						}
					}
				}
				else if (userType.equalsIgnoreCase("vdiusers"))
				{
					eventCount = vdiUsrs.size();
					rootJSON.put("selectedUserCount",eventCount);
					if (vdiUsrs != null && eventCount > 0)
					{
						rootJSON.put("totalProperty",eventCount);
						rootJSON.put("vdiUsersDataCnt",eventCount);

						if (isSearchEnable)
						{
							vdiUsrs = getSearchData(vdiUsrs,searchStr,false);
							rootJSON.put("totalProperty",vdiUsrs.size());

							// for CSV
							csvData.add("Search string is ,"+searchStr+"");
							csvData.add("");
						}

						csvData.add("VDI Users ("+vdiUsrs.size()+")");
						csvData.add("");
						csvData.add(strGeoColumns.toUpperCase());

						ArrayList resultData = new ArrayList();
						offsetCount += maxPageItems;
						int size = vdiUsrs.size();
						int fromIndex = Math.max(0, startPosition);
						int toIndex = Math.min(size, offsetCount);
						resultData = new ArrayList(vdiUsrs.subList(fromIndex , toIndex));

						JSONArray vdiUsersDataArr = new JSONArray();
						if(resultData != null && resultData.size() >0)
						{
							for (int v=0;v<resultData.size();v++)
							{
								String strVdiUser = resultData.get(v).toString();
								if (StringUtils.isNull(strVdiUser))
								{
									continue;
								}

								HashMap vdiUserDetailsList = (HashMap) allUsers.get(strVdiUser.toLowerCase());
								JSONObject vdiUsersDetailsObj = new JSONObject();
								vdiUsersDetailsObj.put("User",strVdiUser);
								for (int col=0;col<columnArr.size();col++)
								{
									String strColumnName = columnArr.get(col).toString();
									if (!StringUtils.isNull(strColumnName) && strColumnName.equalsIgnoreCase("User"))
									{
										continue;
									}
									String strColumVal = "-";
									if (vdiUserDetailsList != null && vdiUserDetailsList.size() > 0)
									{
										strColumVal = vdiUserDetailsList.get(strColumnName).toString();
										if (StringUtils.isNull(strColumnName))
										{
											strColumVal = "-";
										}
									}
									vdiUsersDetailsObj.put(strColumnName,strColumVal);
								}
								vdiUsersDataArr.add(vdiUsersDetailsObj);
							}
						}
						rootJSON.put("selectedUsersDataArr",vdiUsersDataArr);
						ArrayList tmpList = getCSVdataForSpecificUsers(allUsers,vdiUsrs,columnArr,isSearchEnable,searchStr);
						if (tmpList != null && tmpList.size() > 0)
						{
							csvData.addAll(tmpList);
						}
					}
				}
				else if (userType.equalsIgnoreCase("termusers"))
				{
					eventCount = trmUsrs.size();
					rootJSON.put("selectedUserCount",eventCount);
					if (trmUsrs != null && eventCount > 0)
					{
						rootJSON.put("totalProperty",eventCount);
						rootJSON.put("trmUsersDataCnt",eventCount);

						if (isSearchEnable)
						{
							trmUsrs = getSearchData(trmUsrs,searchStr,false);
							rootJSON.put("totalProperty",trmUsrs.size());

							// for CSV
							csvData.add("Search string is ,"+searchStr+"");
							csvData.add("");
						}

						csvData.add("Cloud/Terminal Users ("+trmUsrs.size()+")");
						csvData.add("");
						csvData.add(strGeoColumns.toUpperCase());

						ArrayList resultData = new ArrayList();
						offsetCount += maxPageItems;
						int size = trmUsrs.size();
						int fromIndex = Math.max(0, startPosition);
						int toIndex = Math.min(size, offsetCount);
						resultData = new ArrayList(trmUsrs.subList(fromIndex , toIndex));

						JSONArray termUsersDataArr = new JSONArray();
						if (resultData != null && resultData.size() > 0)
						{
							for (int t=0;t<resultData.size();t++)
							{
								String strTermUser = resultData.get(t).toString();
								if (StringUtils.isNull(strTermUser))
								{
									continue;
								}

								HashMap termUserDetailsList = (HashMap) allUsers.get(strTermUser.toLowerCase());
								JSONObject termUsersDetailsObj = new JSONObject();
								termUsersDetailsObj.put("User",strTermUser);
								for (int col=0;col<columnArr.size();col++)
								{
									String strColumnName = columnArr.get(col).toString();
									if (!StringUtils.isNull(strColumnName) && strColumnName.equalsIgnoreCase("User"))
									{
										continue;
									}
									String strColumVal = "-";
									if (termUserDetailsList != null && termUserDetailsList.size() > 0)
									{
										strColumVal = termUserDetailsList.get(strColumnName).toString();
										if (StringUtils.isNull(strColumnName))
										{
											strColumVal = "-";
										}
									}
									termUsersDetailsObj.put(strColumnName,strColumVal);
								}
								termUsersDataArr.add(termUsersDetailsObj);
							}
						}

						rootJSON.put("selectedUsersDataArr",termUsersDataArr);
						ArrayList tmpList = getCSVdataForSpecificUsers(allUsers,trmUsrs,columnArr,isSearchEnable,searchStr);
						if (tmpList != null && tmpList.size() > 0)
						{
							csvData.addAll(tmpList);
						}
					}
				}
			}
			rootJSON.put("columnArr",columnArr);
		}
	}
	else 
	{
		String tblHd = "";
		if (ctxCnt > 0)
		{
			csvData.add("Citrix users,"+ctxCnt+"");
			tblHd = "Citrix users";
		}
		if (vdiCnt > 0)
		{
			csvData.add("VDI users,"+vdiCnt+"");
			if (tblHd.length() > 0)
				tblHd += ",";
			tblHd += "VDI users";
		}
		if (trmCnt > 0)
		{
			csvData.add("Cloud/Terminal users,"+trmCnt+"");
			if (tblHd.length() > 0)
				tblHd += ",";
			tblHd += "Cloud/Terminal users";
		}
		if (isNamedUsers)
		{
			csvData.add("Total named users,"+totCnt+"");
		}
		else if(isConcUsers)
		{
			csvData.add("Total concurrent users,"+totCnt+"");
		}
		csvData.add("");
		csvData.add(tblHd);
		int bigSz = (ctxCnt > vdiCnt)?ctxCnt:vdiCnt;
		bigSz = (bigSz > trmCnt)?bigSz:trmCnt;
		String rowData = "";
		for (int b=0; b<bigSz; b++)
		{
			rowData = "";
			if (ctxCnt > 0 && ctxCnt > b)
			{
				rowData = ctxUsrs.get(b).toString();
			}
			if (vdiCnt > 0 )
			{
				//if (rowData.length() > 0)
				if(ctxCnt > 0)
					rowData += ",";

				if (vdiCnt > b)
					rowData += vdiUsrs.get(b).toString();
			}
			if (trmCnt > 0)
			{
				if(vdiCnt > 0 || rowData.length() > 0 || ctxCnt > 0)
					rowData += ",";

				if (trmCnt > b)
					rowData += trmUsrs.get(b).toString();
			}
			csvData.add(rowData);
		}

			

		JSONArray jsonArr = new JSONArray();
		if(ctxCnt%3 == 1)
		{
			ctxUsrs.add("");
			ctxUsrs.add("");
		}
		else if (ctxCnt%3 == 2)
		{
			ctxUsrs.add("");
		}
		for(int c=0; c<ctxCnt; c+=3)
		{		
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("col_1",ctxUsrs.get(c).toString());
			tmpObj.put("col_2",ctxUsrs.get(c+1).toString());
			tmpObj.put("col_3",ctxUsrs.get(c+2).toString());
			jsonArr.add(tmpObj);
		}
		rootJSON.put("ctxUsers",jsonArr);
		
		jsonArr = new JSONArray();
		if(vdiCnt%3 == 1)
		{
			vdiUsrs.add("");
			vdiUsrs.add("");
		}
		else if (vdiCnt%3 == 2)
		{
			vdiUsrs.add("");
		}
		for(int c=0; c<vdiCnt; c+=3)
		{		
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("col_1",vdiUsrs.get(c).toString());
			tmpObj.put("col_2",vdiUsrs.get(c+1).toString());
			tmpObj.put("col_3",vdiUsrs.get(c+2).toString());
			jsonArr.add(tmpObj);
		}
		rootJSON.put("vdiUsers",jsonArr);

		jsonArr = new JSONArray();
		if(trmCnt%3 == 1)
		{
			trmUsrs.add("");
			trmUsrs.add("");
		}
		else if (trmCnt%3 == 2)
		{
			trmUsrs.add("");
		}
		for(int c=0; c<trmCnt; c+=3)
		{		
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("col_1",trmUsrs.get(c).toString());
			tmpObj.put("col_2",trmUsrs.get(c+1).toString());
			tmpObj.put("col_3",trmUsrs.get(c+2).toString());
			jsonArr.add(tmpObj);
		}
		rootJSON.put("trmUsers",jsonArr);
	}

	rootJSON.put("isDefaultViewInUserNames",isDefaultViewInUserNames);

	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");
	




	

	out.println(rootJSON);
%>

<%!
	private JSONArray getColumnJsonArray(String strGeoColumns, boolean isAddColumn)
	{
		JSONArray columnArr = new JSONArray();
		ArrayList colunmList = StringUtils.egTokenizer(strGeoColumns,",");
		for (int c=0;c<colunmList.size();c++)
		{
			String strColumn = colunmList.get(c).toString();
			columnArr.add(strColumn);
		}

		if (isAddColumn)
		{
			columnArr.add(1,"User type");
		}
		return columnArr;
	}

	private String getStringFromJSONArray(JSONArray columnArr)
	{
		String resultStr = "";
		int size = columnArr.size();
		for (int c=0;c<size;c++)
		{
			String strColumn = columnArr.get(c).toString();
			resultStr+=strColumn.toUpperCase()+",";
		}

		if (resultStr.endsWith(","))
		{
			resultStr = resultStr.substring(0,resultStr.length()-1);
		}
		return resultStr;
	}

	private ArrayList getCSVdata(HashMap allUsers, ArrayList resultData, JSONArray columnArr, boolean isSearchEnable,String searchStr)
	{
		ArrayList csvData = new ArrayList();
		if (resultData != null && resultData.size() > 0)
		{
			for (int a=0;a<resultData.size();a++)
			{
				String strAllUser = resultData.get(a).toString();
				if (StringUtils.isNull(strAllUser))
				{
					continue;
				}

				String rowData = "";
				int idx = strAllUser.indexOf("#"); 
				if (strAllUser.startsWith("ctx#"))
				{
					strAllUser = strAllUser.substring(idx+1);
					rowData = strAllUser+",Citrix";
				}
				else if (strAllUser.startsWith("vdi#"))
				{
					strAllUser = strAllUser.substring(idx+1);
					rowData = strAllUser+",VDI";
				}
				else if (strAllUser.startsWith("trm#"))
				{
					strAllUser = strAllUser.substring(idx+1);
					rowData = strAllUser+",Cloud/Terminal";
				}

				
				HashMap allUserDetailsList = (HashMap) allUsers.get(strAllUser.toLowerCase());
				for (int col=0;col<columnArr.size();col++)
				{
					String strColumnName = columnArr.get(col).toString();
					if (!StringUtils.isNull(strColumnName) && (strColumnName.equalsIgnoreCase("User") || strColumnName.equalsIgnoreCase("User type")))
					{
						continue;
					}
					String strColumVal = "-";
					if (allUserDetailsList != null && allUserDetailsList.size() > 0)
					{
						strColumVal = allUserDetailsList.get(strColumnName).toString();
						if (StringUtils.isNull(strColumnName))
						{
							strColumVal = "-";
						}
					}
					rowData +=","+"\""+strColumVal+"\"";
				}
				csvData.add(rowData);
			}
			csvData.add("");
		}
		return csvData;
	}

	private ArrayList getCSVdataForSpecificUsers(HashMap allUsers, ArrayList resultData, JSONArray columnArr, boolean isSearchEnable, String searchStr)
	{
		ArrayList csvData = new ArrayList();
		if (resultData != null && resultData.size() > 0)
		{
			for (int a=0;a<resultData.size();a++)
			{
				String strAllUser = resultData.get(a).toString();
				if (StringUtils.isNull(strAllUser))
				{
					continue;
				}

				String rowData = strAllUser;
				HashMap allUserDetailsList = (HashMap) allUsers.get(strAllUser.toLowerCase());
				for (int col=0;col<columnArr.size();col++)
				{
					String strColumnName = columnArr.get(col).toString();
					if (!StringUtils.isNull(strColumnName) && (strColumnName.equalsIgnoreCase("User") || strColumnName.equalsIgnoreCase("User type")))
					{
						continue;
					}
					String strColumVal = "-";
					if (allUserDetailsList != null && allUserDetailsList.size() > 0)
					{
						strColumVal = allUserDetailsList.get(strColumnName).toString();
						if (StringUtils.isNull(strColumnName))
						{
							strColumVal = "-";
						}
					}
					rowData +=","+"\""+strColumVal+"\"";
				}
				csvData.add(rowData);
			}
			csvData.add("");
		}
		return csvData;
	}

	private ArrayList getSearchData(ArrayList usersList,String searchStr, boolean isSubstring)
	{
		ArrayList resultList = new ArrayList();
		int size = usersList.size();
		if (com.egurkha.util.StringUtils.isNull(searchStr))
		{
			return usersList;
		}

		ArrayList searchList = new ArrayList();
		if (searchStr.indexOf(" ") != -1)
		{
			searchList = com.egurkha.util.StringUtils.egTokenizer(searchStr, " ");
		}
		else
		{
			searchList.add(searchStr);
		}

		for (int s=0;s<size;s++)
		{
			String strValue = usersList.get(s).toString();
			String tmpUser = strValue;
			if (isSubstring)
			{
				int idx = tmpUser.indexOf("#");
				if (!StringUtils.isNull(tmpUser))
				{
					tmpUser = tmpUser.substring(idx+1);
				}
			}
			if (searchList != null && searchList.size() > 0)
			{
				int searchCnt = searchList.size();
				if (searchCnt == 1)
				{
					if (isMatch(tmpUser,searchList.get(0).toString(),true))
					{
						resultList.add(strValue);
					}
				}
				else
				{
					for (int i=0;i<searchCnt;i++)
					{
						String strSearchVal = searchList.get(i).toString();
						if (isMatch(tmpUser,strSearchVal,true))
						{
							resultList.add(strValue);
						}
					}
				}
			}
			else
			{
				resultList.add(strValue);
			}
		}
		return resultList;
	}


	public static boolean isMatch(String o,String ss,boolean isNotCaseSensitive)
	{
		String valueString=o;
		String searchString=ss;
		if ((o == null) && (ss == null))
			return true;

		if(isNotCaseSensitive)
		{
			valueString = o.toLowerCase();
			searchString = ss.toLowerCase();
		}
		boolean flag = false;
		if (valueString.indexOf(searchString) != -1)
		{
			flag = true;
		}

		return(flag);
	}
	
%>