Ext.define('LimitedAdminHome.view.AllComponentsGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.allcomponentsgrid',
	id:'allcomponentsgrid',
	requires : ['Ext.ux.data.PagingMemoryProxy'],
	ui:'newGridPanel',
	emptyText: '<div class="emptyText"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+emptyMsg+'</div></div>',
	viewConfig: {
		deferEmptyText: false
	},
	margin:'10 0 10 10',
	flex : 1,
	initComponent : function() {
		this.dockedItems = [{
			xtype: 'pagingtoolbar',
			id:'pagingtoolbarid', 
			store: this.store,
			dock: 'bottom',
			cls:'newPagination',
			displayInfo: true
		},{
			xtype:'toolbar',
			dock:'top',
			ui:'plain',
			style:{
				'display':'flex'
			},
			margin:'0 0 10 0',
			items:[
				{
					xtype:'label',
					id:'serverTitleLbl',
					margin:'0 10 0 0',
					html:''
				},
				{
					xtype: 'button',
					id:'addNewButton',
					ui:'aButtonSmall',
					text: addButtonText,
					height:22,
					handler: function()
					{
						var CompType = Ext.getCmp('card-1').selectedType;
						appCnt.addNewComponent(fromAction,CompType);
					}
				},
				{
					xtype:'tbfill'
				},
			/*	{
					xtype: 'radiogroup',
					//defaultType: 'radiofield',
					layout: 'hbox',
					labelWidth:65,
					fieldLabel:'Showing',
					labelAlign:'right',
					labelCls:'aLabelFont mAlign',
					labelSeparator:'',
					columns: 2,
					vertical: true,
					defaults: {
						flex: 1,
						cls:'aRadiobt',
						margin: '0px 20px 0px 0px'
					},
					margin: '0 10 0 10',
					items: [
						{
							boxLabel  : Configured,
							name      : 'classify',
							inputValue: 'configured',
							id        : 'config',
							listeners: {
								click: {
									element: 'el',
									fn: function (obj)
									{
										Ext.getCmp('unconfig').setValue(false);
										Ext.getCmp('config').setValue(true);
		
										appCnt.getClassifiedComponents(Ext.getCmp('config'));
									}
								}
							}
						}, {
							boxLabel  : Unconfigured,
							name      : 'classify',
							inputValue: 'unconfigured',
							id        : 'unconfig',
							listeners: {
								click: {
									element: 'el',
									fn: function (obj)
									{
										Ext.getCmp('config').setValue(false);
										Ext.getCmp('unconfig').setValue(true);
										appCnt.getClassifiedComponents(Ext.getCmp('unconfig'));
									}
								}
							}
						}
					]
				},*/
				{
					xtype: 'scrollcombo',
					labelWidth:65,
					id:'filterBy',
					fieldLabel:'Showing',
					labelAlign:'right',
					labelCls:'aLabelFont mAlign',
					labelSeparator:'',
					width:265,
					editable: false,
					//cls:'dropdown',
					//margin: '0 20 0 0',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : [
							{'displayField': 'All', 'valueField':'all'},
							{'displayField': 'Configured', 'valueField':'configured'},
							{'displayField': 'Unconfigured', 'valueField':'unconfigured'}
						]
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					value:'',
					listeners: {
						select: function (){
							appCnt.getClassifiedComponents(this);
						}
					}
				},
				{
					xtype: 'trigger',
					//trigger1Cls: 'x-form-clear-trigger',
					//trigger2Cls: 'x-form-search-trigger',
                    			triggerCls: 'x-form-search-trigger',
					cls: 'aSearch',
					margin: '0 0 0 20',
					width:190,
					emptyText: searchEmptyText,
					id : 'compSearch',
					onTriggerClick : function() {
						var val = this.getValue();
						appCnt.moreComponentSearch(val);
					},
					/*getTriggerMarkup: function() {
						var me = this,
							i = 0,
							hideTrigger = (me.readOnly || me.hideTrigger),
							triggerCls,
							triggerBaseCls = me.triggerBaseCls,
							triggerConfigs = [],
							unselectableCls = Ext.dom.Element.unselectableCls,
							style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
							cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
		
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
		
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						var val = this.getValue();
						appCnt.moreComponentSearch(val);
					},*/
					listeners:
					{
						//change: function()
						//{
							//var val = this.getValue();
							//appCnt.moreComponentSearch(val);
						//}
						specialkey: function(field, e){
							if (e.getKey() == e.ENTER) {
								var val = this.getValue();
								appCnt.moreComponentSearch(val);
							}
						}
					}
				}
			]
		}];
		this.callParent();
	},

	tools: [],
	dockedItems:[],

	columns : [
		{
			text:compNameText,
			dataIndex:'DispCompName',
			flex : 3
		},
		{
			text:"IP",
			dataIndex:'DispIpName',
			hidden:true
		},
		{
			text:agentOragentlessText,
			dataIndex:'Agent/Agentless',
			align:'center',
			flex : 1,
			renderer : function(value, metaData, record, row, col, store, gridView)
			{
				metaData.style='text-align:center';
				return value;
			}
		},
		{
			text:agentStatusText,
			dataIndex:'MonitorStatus',
			align:'center',
			flex : 1,
			renderer : function(value, metaData, record, row, col, store, gridView)
			{
				
				var agentStatus = record.get('MonitorStatus');
				if (Ext.isEmpty(agentStatus) || agentStatus.toLowerCase() == 'ani' )
				{
					agentStatus = '<span class="statusNeverReported">'+agentStatusMsg1+'</span>';
				}
				else if (Ext.isEmpty(agentStatus) || agentStatus.toLowerCase() == 'anr' )
				{
					agentStatus = '<span class="statusNotReportingColor">'+agentStatusMsg2+'</span>';
				}
				else
				{
					agentStatus = '<span class="statusReportingColor">'+agentStatusMsg3+'</span>';
				}
				metaData.style='text-align:center';
				return "<div>"+agentStatus+"</div>";
			}
		},
		{
			xtype:'actioncolumn',
			id:'actionColumn',
			width:200,
			items:[
				{
					iconCls: 'iconModify awActionColumnIconMargin',
					tooltip: modifyTooltip,
					id:'modifyAction',
					handler: function(grid, rowIndex, colIndex) {
						var CompType = Ext.getCmp('card-1').selectedType;
						appCnt.modifyComponent(fromAction, CompType, grid, rowIndex, colIndex);
					}
				},
				{
					iconCls: 'awTestConfig16 awActionColumnIconMargin',
					id:'testAction',
					tooltip: configureTestTooltip,
					handler: function(value, row, col, item, e, record) 
					{
						var CompType = record.getData().CompType;
						var CompVariable = record.getData().CompVariable;
						var testType = record.getData().UnConfigTestType;
						appCnt.specificTestConfigWindow(fromAction,CompType,CompVariable,testType);
					}
				},
				{
					iconCls: 'awThresholds16 awActionColumnIconMargin',
					tooltip: setThresholdsTooltip,
					id:'threshAction',
					handler: function(value, row, col, item, e, record) 
					{
						var CompType = record.getData().CompType;
						var CompVariable = record.getData().CompVariable;
						var Testname = record.getData().Testname;
						var ComponentName = record.getData().ComponentName;
						appCnt.specificThresholdConfigWindow(fromAction,CompVariable,ComponentName,Testname,CompType);
					}
				},
				{
					iconCls: 'awMaintenance16 awActionColumnIconMargin',
					tooltip: setmaintenanceTooltip,
					id:'maintainAction',
					handler: function(value, row, col, item, e, record) 
					{
						var CompType = record.getData().CompType;
						var ComponentName = record.getData().ComponentName;
						appCnt.gotoMaintenancePolicyPage(fromAction,CompType,ComponentName);
					}
				},
				{
					iconCls: 'awUnmanage awActionColumnIconMargin',
					tooltip: unmanageTooltip,
					id:'unManageAction',
					handler: function(grid, rowIndex, colIndex) {
						appCnt.unmanageComponent(fromAction, grid, rowIndex, colIndex);
					}
				},
				{
					iconCls: 'iconDelete awActionColumnIconMargin',
					tooltip: deleteTooltip,
					id:'deleteAction',
					handler: function(grid, rowIndex, colIndex) {
						appCnt.deleteComponent(fromAction, grid, rowIndex, colIndex);
					}
				},
				{
					iconCls: 'iconIP awActionColumnIconMargin',
					tooltip: changeIpTooltip,
					id:'changeIpAction',
					handler: function(grid, rowIndex, colIndex) {
						var CompType = Ext.getCmp('card-1').selectedType;
						appCnt.changeIP(fromAction, CompType, grid, rowIndex, colIndex);
					}
				}
			],
			renderer : function(value, metaData, record, row, col, store, gridView)
			{
				var configured = record.get('Configured');
				var componentType = record.get('CompType');
				//this.items[0].iconCls = "iconModify awActionColumnIconMargin linkHand";
				if (!compGlanceJson.hasComponentMangamentEnabled)
				{
					this.items[0].iconCls = "";
				}
				else
				{
					////var unconfig = Ext.getCmp('filterBy').getValue();
					//if (!Ext.isEmpty(configured) && configured.toLowerCase() == 'no')
					//{
						//this.items[0].iconCls = "iconModify-Highlight awActionColumnIconMargin linkHand"
					//}
					//else
					{
						this.items[0].iconCls = "iconModify awActionColumnIconMargin linkHand";
					}
				}

				if (!compGlanceJson.hasTestEnabled)
				{
					this.items[1].iconCls = "";
				}
				else
				{
					//var unconfig = Ext.getCmp('filterBy').getValue();
					if (!Ext.isEmpty(configured) && configured.toLowerCase() == 'no')
					{
						this.items[1].iconCls = "awTestConfig16-Highlight awActionColumnIconMargin linkHand"
					}
					else
					{
						this.items[1].iconCls = "awTestConfig16 awActionColumnIconMargin linkHand";
					}
				}

				if (!compGlanceJson.hasThreshEnabled)
				{
					this.items[2].iconCls = "";
				}
				else
				{
					this.items[2].iconCls = "awThresholds16 awActionColumnIconMargin linkHand";
				}

				if (!compGlanceJson.hasMaintenancePolicyEnabled)
				{
					this.items[3].iconCls = "";
				}
				else
				{
					this.items[3].iconCls = "awMaintenance16 awActionColumnIconMargin linkHand";
				}

				if (!compGlanceJson.hasComponentMangamentEnabled)
				{
					this.items[4].iconCls = "";
					this.items[5].iconCls = "";
				}
				else
				{
					this.items[4].iconCls = "awUnmanage awActionColumnIconMargin linkHand";
					this.items[5].iconCls = "aIconTrash awActionColumnIconMargin linkHand";
				}

				if (!Ext.isEmpty(componentType) && componentType.startsWith('Agg_'))
				{
					this.items[6].iconCls = "";
				}
				else
				{
					//this.items[6].iconCls = "iconIP awActionColumnIconMargin linkHand";
					if (!compGlanceJson.hasComponentMangamentEnabled)
					{
						this.items[6].iconCls = "";
					}
					else
					{
						//var unconfig = Ext.getCmp('filterBy').getValue();
						//if (!Ext.isEmpty(configured) && configured.toLowerCase() == 'no')
						//{
							//this.items[6].iconCls = "iconIP-Highlight awActionColumnIconMargin linkHand"
						//}
						//else
						{
							this.items[6].iconCls = "iconIP awActionColumnIconMargin linkHand";
						}
					}
				}
			}
		}
	],
	listeners:{
		added: function( obj, container, pos, eOpts )
		{
			Ext.getCmp('ComponentDetailGrid').setLoading(false);
		},
		beforerender: function()
		{
			if (!compGlanceJson.hasComponentMangamentEnabled)
			{
				Ext.getCmp('addNewButton').hide();
			}

			if (!compGlanceJson.hasComponentMangamentEnabled && 
					!compGlanceJson.hasTestEnabled && 
					!compGlanceJson.hasThreshEnabled && 
					!compGlanceJson.hasMaintenancePolicyEnabled)
				{
					Ext.getCmp('actionColumn').hide();
				}
				else
				{
					Ext.getCmp('actionColumn').show();
				}
		}
	}
});



