Ext.define('LimitedAdminHome.view.ComponentDetailGrid', {
	extend:'Ext.container.Container',
	alias:'widget.ComponentDetailGrid',
	id:'ComponentDetailGrid',
	ui:'simplePanel simplePanelHeaderBorder',
	closable: true,
	margin: '0 10 0 0',
	requires: [
		'utilities.CustomGrid',
	],
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex: 1,
	listeners: {
		close: function() 
		{
			var viewportObj = Ext.getCmp('viewport');
			viewportObj.removeAll();
			fromAction = "componentsGlance";
			viewportObj.add({xtype:'adminwizard'});
		},
		boxready:function() 
		{
			var compType = Ext.getCmp('card-1').selectedType;
			var classify = Ext.getCmp('card-1').classify;
			fromAction = "componentsGlance_"+classify;

			Ext.getCmp('ComponentDetailGrid').setLoading(true);
			Ext.Ajax.request({
				url:"/final/admin/LimitedAdminHome/data/EgShowAllServerJson.jsp?server="+compType+"&fromAction="+fromAction+"&classify="+classify,
				async:true,
				success:function(response){
					isClassifyView = true;
					compGlanceJson = Ext.decode(response.responseText);
					appCnt.pagingGridMainRender(compGlanceJson);
				}
			});
		}
	}
});



