Ext.define('LimitedAdminHome.view.DownloadAgents', {
	extend:'Ext.container.Container',
	alias:'widget.DownloadAgents',
	id:'DownloadAgents',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex: 1,
	scroll:false,
	autoScroll:true,
	margin: '10 0 10 0',
	listeners: {
		boxready:function() 
		{
			var monitors = Ext.getCmp('card-0').monitors;
			var agentType = Ext.getCmp('card-0').agentType;
			fromAction = "downloadagents_"+monitors+":"+agentType;
			appCnt.loadAgentsForDownload(agentType);
		}
	},

	items: [
		{
			xtype: 'container',
			margin: '0 0 10 0',
			id: 'agentCont',
			layout: {
				type:'vbox',
				align:'stretch'
			},
			flex: 1,
			items: [
				{
					xtype: 'dataview',
					id: 'agentView',
					deferInitialRefresh: false,
					store: Ext.create('Ext.data.Store', {
						fields: ['displayField','valueField','className','folder','agentVersion','category','bit','version'],
						data: []
					}),
					displayField:'displayField',
					valueField:'valueField',
					boxWidth:320,
					boxHeight:65,
					boxMargin: 10,
					flex: 1,
					scroll: true,
					autoScroll: true,
					tpl: Ext.create(
						"Ext.XTemplate",
						"<ul>",
						'<tpl for=".">',
							'<li class="aBoxParentSimple">',
								'<div class="aBoxChildSimple"><a href="javascript:void(0)"onclick=\"javascript:appCnt.downloadAgentPack(\'' + '{valueField}'+ '\',\'' + '{folder}' + '\' ,\'' + '{agentVersion}' + '\',\'' + '{version} {bit}' + '\')\" class="iePositionFix">',
									'<div class="plainFrontSimple">', 
										'<div class="iconDiv {className} size42 iconColor"></div>',
										'<div class="centerDiv">',
											'<div class="innerText"><div style="line-height:1em">{version}</div><div class="aNormalFont" style="line-height:1.5em">{bit}</div></div>', 
										'</div>',
										'<div class="iconDiv gen-download size42 iconColor"></div>',
									'</div>',
								'</a></div>',
							'</li>',
						"</tpl>",
						"</ul>",
						'<div class="x-clear"></div>'
					),
					scrollbarVisible: function (view) {
						return view.el.dom.scrollHeight > view.el.dom.clientHeight;
					},
					listeners: {
						refresh: function(view) {
							appCnt.agentWidgetWidth(view);
						},
						resize: function (view, width, height,oldWidth,oldHeight,eOpts) {
							appCnt.agentWidgetWidth(view);
						},
						viewready:function(view){
							Ext.defer(function(){
								view.fireEvent('refresh',view);
							},50);
						}
					},
					itemSelector: "li.aBoxParentSimple"
				},
				{
					xtype: 'container',
					id: 'emptyAgentMsg',
					hidden: true,
					flex: 1,
					html: 'Empty Message'
				}
			]
		}
	]
});



