Ext.define('LimitedAdminHome.view.DownloadUtils',{
	alias:'widget.DownloadUtils',
	id:'DownloadUtils',
	download : function(s_qryString,osname,AgentToBeConfigured,defaultAgent)
	{
		var statusMsg = '<b>'+downloadStatusMsgPart1+' ('+osname.trim()+') '+downloadStatusMsgPart2+'...</b>';
		if (Ext.isEmpty(osname))
		{
			statusMsg = '<b>'+downloadStatusMsgPart1+' '+downloadStatusMsgPart2+'...</b>';
		}
		var progressBar = Ext.MessageBox.progress({
			title: downloadStatusTitle,
			value: 5,
			width: 500,
			increment: 15,
			closable: false,
			cls:'aProgressBar',
			progressText: 'Connecting..',
			wait: true,
			waitConfig: {
				interval: 200
			},
			msg: statusMsg
		});

		var iFrameExists = Ext.query("#pdfIframe");
		if(Ext.isEmpty(iFrameExists))
		{
			Ext.DomHelper.append(document.body, {
				tag: 'iframe',
				frameBorder: 0,
				width: 0,
				height: 0,
				css: 'display:none;visibility:hidden;height:1px;',
				src: s_qryString,
				id: 'pdfIframe'
			});
		}
		else
		{
			Ext.select('#pdfIframe').set( { src :  s_qryString });
		}

		Ext.Ajax.request(
		{
			url : '/final/admin/LimitedAdminHome/data/DownloadStatusJson.jsp?osname='+encodeURIComponent(osname),
			scope:this,
			timeout:240000,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData))
				{
					var downloadStatus = jsonData.isDownloaded;
					var downloadAgentTitleStr = downloadAgentTitle;
					var msg = downloadAgentSuccessMsg1+". "+downloadAgentSuccessMsg2+".";
					if (defaultAgent == true)
					{
						downloadAgentTitleStr = downloadAgentsTitle;
					}
					if (!hideDownloadInstaller)
					{
						downloadAgentTitleStr = downloadInstallerBtn;
						msg = downloadInstallerSuccessMsg+".";
					}

					if(downloadStatus == true)
					{
						progressBar.hide();
						Ext.Msg.show({
							title: downloadAgentTitleStr,
							msg: msg,
							buttons: Ext.Msg.OK,
						//	icon: 'iconInformation',
							icon: 'gen-info size32 color-info',
							fn: function() 
							{
								if (defaultAgent == false)
								{
									if (AgentToBeConfigured == 'Internal')
									{
										var svg = d3.select('#dashmenu_model_id');
										var g = svg.append('g');

										d3.selectAll('.menuImgC').classed('pressedC', false);
										d3.select("#svgButton"+1).select('.menuImgC').classed('pressedC', true);
								
										d3.select("#svgButton"+1).select('.imgBgC').attr("fill", "gray").attr('opacity',1);
										d3.select("#svgButton"+1).select('.imgC').attr("x", function (d) { return -21 }).attr("y", '-21px').transition().ease("easeLinear").duration(500).attr('xlink:href', function (d, j) {
											return "/final/images/Light/svg/" + d.menu_iconCls + "Hover.svg";
										});
										
										fromAction = "componentsGlance";  // for refresh handling
										Ext.getCmp('new_ground').layout.setActiveItem(1);

										var viewportObj = Ext.getCmp('viewport');
										viewportObj.removeAll();
										viewportObj.add({xtype:'adminwizard'});
									}
									else
									{
										appCnt.agentDownloadClose();
									}
								}
							}
						});
					}
					else
					{
						progressBar.hide();
						Ext.Msg.show({
							 title: downloadAgentTitleStr,
							 msg: downloadAgentFailureMsg+'!',
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.ERROR
						});
					}
				}
				else
				{
					progressBar.hide();
				}
			},
			failure: function()
			{
				progressBar.hide();
			}
		});
	},
	downloadJson : function(compType)
	{
		var dwnWinTitle = Ext.getCmp('agentLessParamPanel').title;
		var progressBar = Ext.MessageBox.progress({
			title: dwnWinTitle,
			value: 5,
			width: 500,
			increment: 15,
			closable: false,
			cls:'aProgressBar',
			progressText: 'Connecting..',
			wait: true,
			waitConfig: {
				interval: 200
			},
			msg: '<b>'+jsonDwnStatusMsg+'...</b>'
		});

		var s_qryString = '/final/servlet/com.eg.EgFileDownloadServlet?fileName='+encodeURIComponent(compType)+'&fileExtension='+encodeURIComponent(".json")+'&filePath='+encodeURIComponent("/bin/");

		var iFrameExists = Ext.query("#pdfIframe");
		if(Ext.isEmpty(iFrameExists))
		{
			Ext.DomHelper.append(document.body, {
				tag: 'iframe',
				frameBorder: 0,
				width: 0,
				height: 0,
				css: 'display:none;visibility:hidden;height:1px;',
				src: s_qryString,
				id: 'pdfIframe'
			});
		}
		else
		{
			Ext.select('#pdfIframe').set( { src :  s_qryString });
		}

		Ext.Ajax.request(
		{
			url : '/final/admin/LimitedAdminHome/data/DownloadStatusJson.jsp?reqFrom=fileDownload&compType='+encodeURIComponent(compType),
			scope:this,
			timeout:240000,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData))
				{
					var downloadStatus = jsonData.isDownloaded;
					if(downloadStatus == true)
					{
						progressBar.hide();
						Ext.Msg.show({
							title: dwnWinTitle,
							msg: jsonDwnSuccMsg,
							buttons: Ext.Msg.OK,
							icon: 'gen-info size32 color-info'
						});
					}
					else
					{
						progressBar.hide();
						Ext.Msg.show({
							 title: dwnWinTitle,
							 msg: dwnFailMsg+'!',
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.ERROR
						});
					}
				}
				else
				{
					progressBar.hide();
				}
			},
			failure: function()
			{
				progressBar.hide();
			}
		});
	}
});



