Ext.define('LimitedAdminHome.view.EgAgentlessDiscoveryServers', {
	extend:'Ext.container.Container',
	alias:'widget.EgAgentlessDiscoveryServers',
	id:'EgAgentlessDiscoveryServers',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex: 1,
	margin:'0 0 0 0',
	listeners: {
		boxready:function() 
		{
			var monitors = Ext.getCmp('card-0').monitors;
			fromAction = "monitors_"+monitors+":"+"category";
			Ext.getCmp('EgAgentlessDiscoveryServers').doLayout();
			appCnt.gotoAgentlessDiscoveryServers(monitors);
		}
	},

	items: [
		{
			xtype: 'container',
			id: 'agentlessservmsg',
			cls:'flexTopAlign',
			html: '<div class="aPanelRegularText aNewLineBottom" style="margin:15px 10px 0px 10px;">Choose the type of agentless servers you would like to discover/monitor?</div>'
		},
		{
			xtype: 'container',
			margin: '10 0 10 0',
			id: 'agentlessCont',
			flex: 1,
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			items: [
				{
					xtype: 'dataview',
					id: 'agentlessView',
					deferInitialRefresh: false,
					store: Ext.create('Ext.data.Store', {
						fields: ['displayField','valueField','content','image'],
						data: []
					}),
					flex: 1,
					scroll: true,
					autoScroll: true,
					boxWidth: 320,
					boxHeight:65,
					boxMargin: 10,
					displayField:'displayField',
					valueField:'valueField',
					tpl: Ext.create(
						"Ext.XTemplate",
						'<ul>',
							'<tpl for=".">', 
								'<li class="aBoxParentSimple" id={refineConfigItems}>',
									'<div class="aBoxChildSimple"><a href="javascript:void(0)" onclick="appCnt.gotoDiscovers(\'{valueField}\',\''+'{[this.getGroupLabel()]}'+'\')" class="iePositionFix">',
										'<div class="plainFrontSimple">',
											'<div class="iconDiv {image} size42 iconColor"></div>',
											'<div class="centerDiv">',
												'{displayField}',
											'</div>',
										'</div>',
									'</a></div>',
								'</li>',
							'</tpl>',
						'</ul>',
						{
							getGroupLabel:function()
							{
								var val = fromAction.substring(fromAction.indexOf('_')+1,fromAction.indexOf(':'));
								return val;
							}
						},
						'<div class="x-clear"></div>'
					),
					scrollbarVisible: function (view) {
						return view.el.dom.scrollHeight > view.el.dom.clientHeight;
					},
					listeners: {
						refresh: function(view) {
							appCnt.agentWidgetWidth(view);
						},
						resize: function (view, width, height,oldWidth,oldHeight,eOpts) {
							appCnt.agentWidgetWidth(view);
						},
						viewready:function(view){
							Ext.defer(function(){
								view.fireEvent('refresh',view);
							},50);
						}
					},
					itemSelector: "li.aBoxParentSimple",
					emptyText: '<table width="100%"><tr><td align="center" valign="middle"><div class="gen-info size32 color-info" style="margin:12% auto 0% auto"></div>'+'No '+monitors+' found'+'</td></tr></table>'
				}
			]
		}
	]
});



