Ext.define('LimitedAdminHome.view.EgCitrixNetScalerConfiguration', {
	extend:'Ext.container.Container',
	alias:'widget.EgCitrixNetScalerConfiguration',
	id:'EgCitrixNetScalerConfiguration',
	border:false,
	scroll:false,
	autoScroll:false,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	flex: 1,
	margin: '0 10 10 0',

	listeners: {
		boxready:function() 
		{
			Ext.getCmp('addCompButton').hide();
			Ext.getCmp('agentInstallerDwnld').hide();

			var compType = Ext.getCmp('card-1').selectedType;
			var classify = Ext.getCmp('card-1').classify;
			fromAction = "componentsGlance_"+classify;
			Ext.Ajax.request({
				url:"/final/admin/LimitedAdminHome/data/EgShowAllServerJson.jsp?server="+compType+"&fromAction="+fromAction+"&classify="+classify,
				async:true,
				success:function(response){
					isClassifyView = true;
					compGlanceJson = Ext.decode(response.responseText);
					appCnt.gotoCtxNetScalerConfiguration(compType);
				}
			});
		}
	},
	items: [
		{
			xtype: 'container',
			id: 'ctxpageMsgRecommendation',
			html: '<div class="aPanelRegularText" style="margin:15px 10px 5px 10px ;">'+ctxNetScalerLbl+':</div>'
		},
		{
			xtype: 'panel',
			ui:'adminFormPanel adminFormPanelHeaderBorder',
			layout : {
				type: 'vbox',
				align : 'center',
				pack : 'start'
			},
			flex: 1,
			bodyPadding : '25 10 10 10',
			margin : '10 0 10 10',
			buttonAlign : 'center',
			defaults: {
				labelSeparator: ' ',
				margin: 7,
				width: 660,
				labelWidth: 380
			},
			title: netScalerconftitle,
			items: [
				{
					fieldLabel: netScalerhostname,
					xtype: 'textfield',
					name: 'hostip',
					id: 'hostip',
					cls: 'aTextbox',
					maxLength: 32,
					enforceMaxLength: true
				},
				{
					fieldLabel: netScalernickname,
					xtype: 'textfield',
					name: 'hostname',
					id: 'hostname',
					cls: 'aTextbox',
					maxLength: 32,
					enforceMaxLength: true
				},
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					editable : false,
					fieldLabel:netScalerisSsl,
					name: 'ssl',
					id: 'ssl',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : [{'displayField':'Yes','valueField':'true'},
								{'displayField':'No','valueField':'false'}]
					}),
					value: 'false',
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local'
				},
				{
					fieldLabel: netScaleruname,
					xtype: 'textfield',
					name: 'uname',
					id: 'uname',
					cls: 'aTextbox'
				},
				{
					fieldLabel: netScalerpass,
					xtype: 'textfield',
					inputType : 'password',
					name: 'pass',
					id: 'pass',
					cls: 'aTextbox'
				},
				{
					fieldLabel: netScalercpass,
					xtype: 'textfield',
					inputType : 'password',
					name: 'confpasswd',
					id: 'confpasswd',
					cls: 'aTextbox'
				}
			],
			
			dockedItems:[{
				xtype: 'toolbar',
				ui:'aBottomToolbar',
				dock: 'bottom',
				margin:'0 10 0 10',
				layout: {
					pack: 'center',
					align: 'center'
				},
				items: [{
					xtype:'button',
					text: updateBtnText,
					ui:'aButtonSmall',
					id: 'submit',
					name: 'submit',
					margin: '10 10 10 10',
					listeners: {
						click : function ()
						{
							appCnt.submitNetScalerServerDetails();
						}
					}
				}]
			}]
		}
	]
});



