Ext.define('LimitedAdminHome.view.EgConfigureAgentLessServers', {
	extend:'Ext.container.Container',
	alias:'widget.EgConfigureAgentLessServers',
	id:'EgConfigureAgentLessServers',
	border:false,
	scroll:false,
	autoScroll:false,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	flex: 1,
	margin: '0 10 10 0',

	listeners: {
		boxready:function() 
		{
			var monitors = Ext.getCmp('card-0').monitors;
			var discover = Ext.getCmp('card-0').discover;
			fromAction = "monitors_"+monitors+":"+discover;
			appCnt.gotoAgentLessConfiguration(discover);
		}
	},
	items: [
		{
			xtype: 'container',
			id: 'agentlessMsgRecommendation',
			html: '<div class="aPanelRegularText" style="margin:15px 10px 5px 10px ;">'+'To monitor the component, specify the following'+':</div>'
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				align : 'stretch',
				pack : 'start'
			},
			flex: 1,
			items : [
				{
					xtype: 'form',
					ui:'adminFormPanel adminFormPanelHeaderBorder',
					layout : {
						type: 'vbox',
						align : 'center',
						pack : 'start'
					},
					id: 'agentLessParamPanel',
					flex: 1,
					margin : '10 0 10 10',
					buttonAlign : 'center',
					scroll: false,
					autoScroll: true,
					title: 'Component preferences',
					items: [
						{
							xtype: 'fieldset',
							ui:'newFieldSet',
							title: '<div>'+compInfoTitle+'</div>',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							margin: '30 20 20 20',
							width: 700,
							items: [
								{
									xtype: 'container',
									id: 'compInfoSet',
									layout: {
										type: 'vbox',
										align: 'center',
										pack: 'start'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 7,
										width: 600,
										labelWidth: 280
									}
								}
							]
						},
						{
							xtype: 'fieldset',
							ui:'newFieldSet',
							title: '<div>'+monitoringInfoTitle+'</div>',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							margin: '0 20 20 20',
							width: 700,
							id: 'compConf',
							items: [
								{
									xtype: 'container',
									id: 'compConfSet',
									layout: {
										type: 'vbox',
										align: 'center',
										pack: 'start'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 7,
										width: 600,
										labelWidth: 280
									}
								}
							]
						},
						{
							xtype: 'fieldset',
							ui:'newFieldSet',
							title: '<div>'+viewEventTitle+'</div>',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							margin: '0 20 20 20',
							width: 700,
							id: 'compConf1',
							items: [
								{
									xtype: 'container',
									id: 'compConfSet1',
									layout: {
										type: 'vbox',
										align: 'center',
										pack: 'start'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 7,
										width: 600,
										labelWidth: 280
									}
								}
							]
						},
						{
							xtype: 'fieldset',
							ui:'newFieldSet',
							title: '<div>'+userInfoTitle+'</div>',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							margin: '0 20 20 20',
							width: 700,
							id: 'specificConf3',
							items: [
								{
									xtype: 'container',
									id: 'specificConfSet3',
									layout: {
										type: 'vbox',
										align: 'center',
										pack: 'start'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 7,
										width: 600,
										labelWidth: 280
									}
								}
							]
						},
						{
							xtype: 'fieldset',
							ui:'newFieldSet',
							title: '<div>'+snmpInfoTitle+'</div>',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							margin: '0 20 20 20',
							width: 700,
							id: 'specificConf1',
							items: [
								{
									xtype: 'container',
									id: 'specificConfSet1',
									layout: {
										type: 'vbox',
										align: 'center',
										pack: 'start'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 7,
										width: 600,
										labelWidth: 280
									}
								}
							]
						},
						{
							xtype: 'fieldset',
							ui:'newFieldSet',
							title: '<div>'+hostProcessTitle+'</div>',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							margin: '0 20 20 20',
							width: 700,
							id: 'specificConf2',
							items: [
								{
									xtype: 'container',
									id: 'specificConfSet2',
									layout: {
										type: 'vbox',
										align: 'center',
										pack: 'start'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 7,
										width: 600,
										labelWidth: 280
									}
								}
							]
						},
						{
							xtype: 'fieldset',
							ui:'newFieldSet',
							title: '<div>'+logInfoTitle+'</div>',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							margin: '0 20 20 20',
							width: 700,
							id: 'specificConf4',
							items: [
								{
									xtype: 'container',
									id: 'specificConfSet4',
									layout: {
										type: 'vbox',
										align: 'center',
										pack: 'start'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 7,
										width: 600,
										labelWidth: 280
									}
								}
							]
						}
					],
					tools : [
						{
							xtype:'button',
							text: jsonDwnBtn,
							ui:'aButtonSmall',
							id: 'downloadJson',
							name: 'downloadJson',
							hidden: true,
							listeners: {
								click : function ()
								{
									appCnt.downloadJSON();
								}
							}
						}
					],
					dockedItems:[{
						xtype: 'toolbar',
						ui:'aBottomToolbar',
						dock: 'bottom',
						margin:'0 10 0 10',
						layout: {
							pack: 'center',
							align: 'center'
						},
						items: [{
							xtype:'button',
							text: updateBtnText,
							ui:'aButtonSmall',
							id: 'submitagentlessserv',
							name: 'submitagentlessserv',
							margin: '10 10 10 10',
							listeners: {
								click : function ()
								{
									appCnt.submitAgentLessServerDetails();
								}
							}
						}]
					}]
				},
				{
					xtype:'container',
					width: 400,
					id: 'agentlessMsgRecommendationHelp',
					margin : '10 0 10 20',
					layout : {
						type: 'vbox',
						align : 'center',
						pack : 'start'
					},
					items: [
						{
							xtype:'container',
							width: 400,
							height: 160,
							cls:'whatNext',
							id: 'WhatNextObjCont',
							items:[
								{
									xtype:'container',
									id: 'whatNextTextCont',
									style:{'overflow':'visible'},
									html:'<div class="whatNextHeader">'+howToConfTitle+'</div><div><ol class="listCount"><li>'+downloadJsonfile+'</li><li><a class="whatNextLink" href="javascript:void(0)" onclick="javascript:appCnt.fetchHelpDoc()">'+clickHere+'</a>'+' '+awsMsg1+'</li><li>'+awsMsg2+'</li></ol></div>'
								}
							]
						}
					]
				}
			]
		}
	]
});



