Ext.define('LimitedAdminHome.view.EgMSOfficeComponents', {
	extend:'Ext.form.Panel',
	alias:'widget.EgMSOfficeComponents',
	id:'egmsofficecomponents',
	ui:'adminFormPanel adminFormPanelHeaderBorder',
	
	title : office365CompsTitleLbl,

	layout : {
		type: 'vbox',
		align : 'stretch',
		pack : 'start'
	},

	flex: 1,
	margin: 10,

	dockedItems: [
		{
		xtype: 'toolbar',
		ui:'aBottomToolbar',
		dock: 'bottom',
		margin:'0 10 0 10',
		layout: {
			pack: 'center',
			align: 'center' // align center is the default
		},
		items: [
			{
				xtype:'button',
				text: updateBtnText,
				ui:'aButtonSmall',
				id: 'submit',
				name: 'submit',
				margin: '10 0 10 10',
				listeners: {
					click : function ()
					{
						appCnt.submitMsOfficeServerDetails();
					}
				}
			}
		]
	}],

	listeners: {
		boxready:function() 
		{
			comeFrom = "null";
			var monitors = Ext.getCmp('card-0').monitors;
			fromAction = "monitors_"+monitors;
		}
	},

	items: [
		{
			xtype: 'checkboxgroup',
			labelSeparator: ' ',
			//border:true,
			//style:'border: 1px solid blue',
			
			margin: '20 10 10 10',

			fieldLabel: office365CompsConfirmLbl + "&nbsp;?",
			columns: 1,
			vertical: true,
			labelAlign: 'top',
			id:'specificCompChkGrp',
			name:'chkt123',
			//ui:'checkbt',
			//height:130,
			width: 600,
			items: [
				{boxLabel:alertMsg54,name:'_exo',id:'exo',inputValue: 'yes',checked: false},
				{boxLabel:alertMsg52, name:'_365',id:'365',inputValue: 'yes',checked: false},
				{boxLabel:alertMsg53,name:'_spo',id:'spo',inputValue: 'yes',checked: false},
				{boxLabel:alertMsg58,name:'_sbo',id:'sbo',inputValue: 'yes',checked: false},
				{boxLabel:alertMsg67,name:'_mtm',id:'mtm',inputValue: 'yes',checked: false},
				{boxLabel:alertMsg68,name:'_odb',id:'odb',inputValue: 'yes',checked: false}
			]
		}
	]

});



