Ext.define('LimitedAdminHome.view.EgMSOfficeConfigurations', {
	extend:'Ext.form.Panel',
	alias:'widget.EgMSOfficeConfigurations',
	id:'EgMSOfficeConfigurations',
	ui:'adminFormPanel adminFormPanelHeaderBorder',
	title : offfice365TitleLbl,

	layout : {
		type: 'vbox',
		align: 'center',
		pack: 'start'
	},

	flex: 1,
	scroll: false,
	autoScroll: true,
	margin: 10,

	listeners: {
		boxready:function() 
		{
			comeFrom = "null";
			var monitors = Ext.getCmp('card-0').monitors;
			fromAction = "monitors_"+monitors+":"+"category";
			appCnt.gotoMSOfficeConfiguration();
		}
	},

	items: [
		{
			xtype: 'fieldset',
			ui:'newFieldSet',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			margin: '30 20 20 20',
			width: 700,
			items: [
				{
					xtype: 'container',
						layout: {
						type: 'vbox',
						align: 'center',
						pack: 'start'
					},
					defaults: {
						labelSeparator: ' ',
						margin: 7,
						width: 660,
						labelWidth: 380
					},
					items: [
						{
							fieldLabel: '* '+office365HostIPLbl,
							xtype: 'textfield',
							name: 'hostip',
							id: 'hostip',
							cls: 'aTextbox'
						},
						{
							fieldLabel: '* '+office365HostNameLbl,
							xtype: 'textfield',
							name: 'hostname',
							id: 'hostname',
							cls: 'aTextbox',
							maxLength: 28,
							enforceMaxLength: true
						},
						{
							fieldLabel: '* '+office365UNameLbl,
							xtype: 'textfield',
							name: 'O365_User_Name',
							id: 'O365_User_Name',
							cls: 'aTextbox'
						},
						{
							fieldLabel: '* '+office365PwdLbl,
							xtype: 'textfield',
							inputType: 'password',
							name: 'O365_Password',
							id: 'O365_Password',
							cls: 'aTextbox'
						}
					]
				}
			]
		},
		{
			xtype: 'fieldset',
			title: '<div>'+office365Lbl3+'</div>',
			collapsible: true,
			checkboxToggle:true,
			collapsed: true,
			hidden: hideProxySettingsForO365,
			ui:'newFieldSet',
			id: 'additionalParams',
			layout: {
				type: 'vbox',
				pack:'center',
				align:'center'
			},
			margin: '0 20 20 20',
			width: 700,
			cls:'tablayout',
			bodyStyle:{'overflow':'auto !important'},
			items: [
				{
					xtype: 'container',
					id : 'addtionalParamContainer',
					layout: {
						type: 'vbox',
						align: 'center',
						pack: 'start'
					},
					defaults: {
						labelSeparator: ' ',
						margin: 7,
						width: 660,
						labelWidth: 380
					},
					items: [
						{
							fieldLabel: office365DUNameLbl,
							xtype: 'textfield',
							name: 'Domain_User_Name',
							id: 'Domain_User_Name',
							cls: 'aTextbox'
						},
						{
							fieldLabel: office365DPwdLbl,
							xtype: 'textfield',
							inputType: 'password',
							name: 'Domain_Password',
							id: 'Domain_Password',
							cls: 'aTextbox'
						},
						{
							fieldLabel: office365DNameLbl,
							xtype: 'textfield',
							name: 'Domain_Name',
							id: 'Domain_Name',
							cls: 'aTextbox'
						},
						{
							fieldLabel: office365ProxyHostLbl,
							xtype: 'textfield',
							name: 'Proxy_Host',
							id: 'Proxy_Host',
							cls: 'aTextbox'
						},
						{
							fieldLabel: office365ProxyPortLbl,
							xtype: 'textfield',
							name: 'Proxy_Port',
							id: 'Proxy_Port',
							cls: 'aTextbox'
						},
						{
							fieldLabel: office365ProxyUNameLbl,
							xtype: 'textfield',
							name: 'Proxy_User_Name',
							id: 'Proxy_User_Name',
							cls: 'aTextbox'
						},
						{
							fieldLabel: office365ProxyPwdLbl,
							xtype: 'textfield',
							inputType: 'password',
							name: 'Proxy_Password',
							id: 'Proxy_Password',
							cls: 'aTextbox'
						}
					]
				}
			]
		}
	],

	dockedItems:[{
		xtype: 'toolbar',
		ui:'aBottomToolbar',
		dock: 'bottom',
		margin:'0 10 0 10',
		layout: {
			pack: 'center',
			align: 'center' // align center is the default
		},
		items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				align : 'center',
				pack : 'center'
			},
			items: [
				{
					xtype:'button',
					text: validateBtnText,
					ui:'aButtonSmall',
					id: 'validateMSOff',
					margin: '10 0 10 10',
					listeners: {
						click : function ()
						{
							appCnt.validateMSOffDetails();
						}
					}
				},
				{
					xtype:'button',
					text: office365NextLbl,
					ui:'aButtonSmall',
					id: 'submito365',
					name: 'submito365',
					margin: '10 10 10 10',
					listeners: {
						click : function ()
						{
							appCnt.submitMSConfigurations();
						}
					}
				}
			]
		}]
	}]
});



