function parallaxAnimationGetStarted() 
{
	var parallaxBox = document.getElementById ( 'boxCC' );
	var c1left = document.getElementById ( 'cc1' ).offsetLeft;
	var c1top = document.getElementById ( 'cc1' ).offsetTop;
	var c2left = document.getElementById ( 'cc2' ).offsetLeft;
	var c2top = document.getElementById ( 'cc2' ).offsetTop;

	parallaxBox.onmousemove = function ( event )
	{
		event = event || window.event;
		var x = event.clientX - parallaxBox.offsetLeft,
		y = event.clientY - parallaxBox.offsetTop;
		mouseParallax ( 'cc1', c1left, c1top, x, y, 20 );
		mouseParallax ( 'cc2', c2left, c2top, x, y, 45 );
	}
}

function mouseParallax ( id, left, top, mouseX, mouseY, speed ) 
{
	var obj = document.getElementById ( id );
	var parentObj = obj.parentNode;
	var containerWidth = parseInt( parentObj.offsetWidth );
	var containerHeight = parseInt( parentObj.offsetHeight );
	obj.style.left = left - ( ( ( mouseX - ( parseInt( obj.offsetWidth ) / 2 + left ) ) / containerWidth ) * speed ) + 'px';
	obj.style.top = top - ( ( ( mouseY - ( parseInt( obj.offsetHeight ) / 2 + top ) ) / containerHeight ) * speed ) + 'px';
}

Ext.define('LimitedAdminHome.view.GetStarted',{
	extend:'Ext.panel.Panel',
	alias:'widget.getstarted',
	id:'getstarted',
	margin:'8 8 0 8',
	padding:0,
	style:{
		'background':'#ffffff',
		'cursor':'pointer'
	},
	layout:{
		type:'fit',
		align:'stretch'
	}, 
	listeners:{
		afterRender:function(){
			parallaxAnimationGetStarted();
			var getStartedObj = Ext.get("getstarted");
			getStartedObj.on('click', function()
			{
				var viewportObj = Ext.getCmp('viewport');
				viewportObj.removeAll();
				viewportObj.add({
					xtype: 'adminwizard'
				});
				viewportObj.doLayout();
			})
		}
	},
	items:[
		{
			xtype:'container',
			layout:{
				type:'auto',
				align:'stretch'
			},
			id:'boxCC',
			border:false,
			scroll:false,
			autoScroll:false,
			padding:0,
			style:{'position':'relative','z-index':'0'},
			items:[
				{
					xtype:'container',
					id:'cc1',
					cls:'parallax_getstarted1',
					style:{'z-index':'1', 'width':'100%','height':'100%'}
				},
				{
					xtype:'container',
					id:'cc2',
					cls:'parallax_getstarted2',
					style:{'z-index':'2', 'width':'100%','height':'100%'}
				},
				{
					xtype:'container',
					style: { 'z-index': '4', 'position': 'absolute', 'width': '100%', 'height': '100%', 'margin-top': '100px', 'margin-left': '200px', 'align': 'left' },
					html:'<div class="getStartedHead">'+getStartedTitle+'</div>'
				},
				{
					xtype:'container',
					id:'cc5',
					cls:'parentContainerForFlex',
					style:{
						'z-index':'5',
						'position':'absolute',
						'overflow':'hidden',
						'width':'100%',
						'height':'100%'
					},
					items:[
						{
							xtype:'container',
							cls:'awgetStarted',
							layout:{
								type:'auto',
								align:'right'
							},
							items:[
								{
									xtype:'container',
									html: '<div class="awGetStartedStepStart"></div>',
									width: 19
								},
								{
									xtype:'container',
									cls:'awGetStartedStepBg',
									items:[
										{
											xtype:'container',
											cls:'awGetStartedStep1',
											items:[
												{
													xtype:'container',
													cls:'stepFontDiv',
													width: 175,
													html:'<div><span class="heading">'+getStartedDownloadStepTitle+'</span></div><div class="details">'+getStartedDownloadStepMsg+'</div>'
												},
												{
													xtype:'container',
													cls:'stepCountDiv',
													html:'<div class="stepFont">'+getStartedStep+'</div><div class="stepCount">1</div>'
												}
											]
										},
										{
											xtype:'container',
											cls:'awGetStartedStep2',
											items:[
												{
													xtype:'container',
													cls:'stepFontDiv',
													width: 210,
													html:'<div><span class="heading">'+getStartedInstallStepTitle+'</span></div><div class="details"><ul class="listCount"><li>'+getStartedInstallStepMsg1+'</li><li>'+getStartedInstallStepMsg2+'</li></ul></div>'
												},
												{
													xtype:'container',
													cls:'stepCountDiv',
													html:'<div class="stepFont">'+getStartedStep+'</div><div class="stepCount">2</div>'
												}
											]
										},
										{
											xtype:'container',
											cls:'awGetStartedStep3',
											items:[
												{
													xtype:'container',
													cls:'stepFontDiv',
													width: 180,
													html:'<div><span class="heading">'+getStartedRefineStepTitle+'</span></div><div class="details">'+getStartedRefineStepMsg+'</div>'
												},
												{
													xtype:'container',
													cls:'stepCountDiv',
													html:'<div class="stepFont">'+getStartedStep+'</div><div class="stepCount">3</div>'
												}
											]
										}
									]
								},
								{
									xtype: 'container',
									cls: 'awGetStartedStip',
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									minwidth: 216,
									items: [{
										xtype: 'container',
										cls: 'awGetStartedStip_left'
									}, {
										xtype: 'container',
										cls: 'awGetStartedStip_center',
										flex: 1,
										items: [{
											xtype: 'container',
											flex: 1,
											width: 300,
											margin: '0 45 0 10',
											html: '<div>'+getStartedNowMsg+'</div><div style="margin-top:20px"><a href="javascript:void(0)" id="getStartAniId" class="getStartedNowLink">'+getStartedNowButtonText+'</a></div>'
										}]
									}],
									listeners:{
										afterRender:function(){
											var aniId = Ext.get("getStartAniId");
											aniId.on('click', function()
											{
												var viewportObj = Ext.getCmp('viewport');
												viewportObj.removeAll();
												viewportObj.add({
													xtype: 'adminwizard'
												});
												viewportObj.doLayout();
											})
										}
									}
								}
							]
						}
					]
				}
			]
		}
	]
});



