Ext.define('LimitedAdminHome.view.ManagedComponents', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.ManagedComponents',
	requires: ['utilities.OuterPanel', 'utilities.CustomGrid'],
	margin : 0,
	padding:0,
	layout: {
		type: 'hbox',
		pack: 'center',
		align: 'stretch'
	},
	border: false,
	items: [
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			margin:0,
			padding:0,
			flex:.5,
			items: [
				{
					xtype : 'customgrid',
					cls:'gridSkin',
					style:{'border-top-width':'0px'},
					scroll:true,
					autoScroll:true,
					flex:1,
					margin:0,
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'top',
						id : 'componentDockItems1',
						layout:{
							type:'hbox',
							pack:'center',
							align:'center'
						},
						items: [
							{
								xtype:'container',
								id : 'displayMessage1',
								html:totManagedCompText
							}
						]
					}],
					id: 'componentView',
					border: false,
					defaults: {
						sortable: true,
						menuDisabled: true,
						draggable: false,
						resizable: false
					},
					store: new Ext.data.Store({
						fields: ['mcomponentType', 'count', 'hiddenColumn'],
						data: []
					}),
					columns: [
						{
							text: compTypeText,
							dataIndex: 'mcomponentType',
							flex: 1,
							menuDisabled: true,
							renderer: function (value, metaData, record, rowIndex, colIndex, store, view) 
							{
								var tmpTag = '<a id="mouse" href=\'javascript:loadURL("component","individual","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
								return tmpTag;
							}
						},
						{
							text: noOfCompText,
							dataIndex: 'count',
							flex: 1,
							menuDisabled: true,
							renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
								var tmpTag = '<a id="mouse" href=\'javascript:loadURL("component","individual","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
								return tmpTag;
							}
						}, 
						{
							text: '',
							dataIndex: 'hiddenColumn',
							flex: 1,
							hidden: true,
							menuDisabled: true
						}
					],
					emptyText: "<div style='margin:10% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='gen-info size32 color-info'></div><div class='commonErrorMsgText' id=\"deferMessage\">"+noCompMsg+".</div></td></tr></table></div>",
					viewConfig: {
						deferEmptyText: false
					}
				}
			]
		}
	]
});



