Ext.define('LimitedAdminHome.view.SvgMenu', {
	extend:'Ext.container.Container',
	alias:'widget.svgmenu',
	id:'dashmenu_model_id',
	width:'auto',
	maxWidth:400,
	border:false,
	listeners: {
		afterrender:function(c)
		{
			var butData = publicJson.menuItemArr;
			var selectCls = fromAction;
			var totalButton = 5;//butData.length;
			var maskShowHide =   Ext.get('maskId');
			var width = 90;
			var height =  Ext.getBody().getViewSize().height;
			var getWizObj = Ext.get('wiz-innerCt');
			var svg = d3.select('#'+c.id)
				.append('svg')
				.attr('width', width)
				.attr('height', 580)
				.attr('fill', 'red')
				.attr("viewBox", "0 0 90 580")

			var g = svg.append('g');
			var lineCurve = g.append('path').attr('stroke', 0).style("stroke", "transparent").attr('d', 'M27 1 S27 288 27 576').attr('fill-opacity', 0);
			var totalLength = lineCurve.node().getTotalLength();
			var yvalue = (totalLength / (totalButton + 1));
			var buttonClick = false;

			if (!Ext.isEmpty(selectCls) && selectCls.indexOf('_') != -1)
			{
				selectCls = selectCls.substring(0,selectCls.indexOf('_'));
			}

			butData.forEach(function (d, i) 
			{
				if (!Ext.isEmpty(selectCls))
				{
					if (d.name == selectCls)
					{
						d.selectClass = true;
					}
					else
					{
						d.selectClass = false;
					}
				}
				d.x = Math.round(lineCurve.node().getPointAtLength(totalLength - (i + 1) * (totalLength / (totalButton + 1))).x);
				d.y = Math.round(lineCurve.node().getPointAtLength((i + 1) * yvalue).y);
			});

			var datax = g.selectAll('.menuitemC').data(butData).enter();
			var menuitem = datax.append('g')
			.attr('class', function(d){
			  if(d.selected){
			  	return 'menuitemC'
			  }else{
			    return 'menuitemC'
			  }
			})

			.attr('transform', function (d,i) {
			  return 'translate(' + 45 + ',' + d.y + ')'
			})
			
			Ext.getCmp('wiz').setWidth(90);
			var getItemNoForNav = 0;
			var menuImg = menuitem.append('g')
				.attr('class', function(d) {
					if(d.selectClass)
					{
						getItemNoForNav = d.ItemNo;
						fromAction = d.id;  // for refresh handling
						return 'menuImgC pressedC'
					}
					else
					{
						return 'menuImgC'
					}
				}).attr('id',function(d,i){
					return "svgButton"+d.ItemNo
				})
			
			menuitem.on("mouseenter", function (d) {
				d3.event.stopPropagation();
				//maskShowHide.show();  //maskShowHide.hide();  // We should uncomment if mask needed 
				svg.style('overflow', 'visible')
				getWizObj.setStyle('overflow', 'visible')
				
				svg.transition()
				.duration(500).attr("viewBox", "0 0 "+width+" "+height).attr("preserveAspectRatio", "xMidYMid meet").attr('width', ""+(width)+"").attr('height', ""+(height)+"")

				d3.select(this).select('.labelTextC').transition().ease("easeLinear").duration(500).attr("opacity", 1).attr('fill', '#1d7cb9');
				d3.select(this).select('.imgBgC').attr("fill", 'transparent').attr("opacity", 1);
				d3.select(this).select('.imgC').transition().ease("easeLinear").duration(500).attr('xlink:href', function (d, j) {
					return "/final/images/Light/svg/" + d.menu_iconCls + "Hover.svg";
			  	}).attr("x", function (d) { return -21 }).attr("y", '-21px');
			})
			.on("mouseleave", function (d) {
				d3.event.stopPropagation();
				svg.style('overflow', 'hidden')
				//maskShowHide.hide();  // We should uncomment if mask needed 
				d3.select(this).select('.labelTextC').transition().ease("easeLinear").duration(500).attr("opacity", 0).attr('fill', '#1d7cb9');
				d3.select(this).select('.imgC').attr("x", function (d) { return -21 }).attr("y", '-21px').transition().ease("easeLinear").duration(500).attr('xlink:href', function (d, j) {
					if(d3.select(this.parentNode).classed('pressedC')){
						return "/final/images/Light/svg/" + d.menu_iconCls + "Hover.svg";
					}
					else{
						return "/final/images/Light/svg/" + d.menu_iconCls + ".svg";
					}
			 	}); 
			})
			.on("click", function (d, i) {
				d3.selectAll('.menuImgC').classed('pressedC', false);
				d3.select(this).select('.menuImgC').classed('pressedC', true);
				var datax = g.selectAll('.menuitemC').data(butData).enter();
		
				d3.select(this).select('.imgBgC').attr("fill", "gray").attr('opacity',1);
				d3.select(this).select('.imgC').attr("x", function (d) { return -21 }).attr("y", '-21px').transition().ease("easeLinear").duration(500).attr('xlink:href', function (d, j) {
					return "/final/images/Light/svg/" + d.menu_iconCls + "Hover.svg";
			  	});
				var getItemNo = d.ItemNo;
				clickIconPos = getItemNo;
				
				fromAction = d.id;  // for refresh handling
				task.stop();
				if (fromAction != 'componentsGlance')
				{
					isClassifyView = false;
					appCnt.refreshCompGlance("stop");
				}
				else
				{
					isClassifyView = false;
				}
				
				buttonClick = true;

				var viewportObj = Ext.getCmp('viewport');
				viewportObj.removeAll();
				viewportObj.add({xtype:'adminwizard'});
				Ext.getCmp('new_ground').layout.setActiveItem(getItemNo);
			});
			
			labelRect = menuImg.append('g').attr('class', 'labelRectC')
			 	.attr('transform', function (d) { return 'translate(' + 0 + ', ' + -15 + ')' });

			labelRect.append('rect')
				.attr('class', 'labelBox')
				.attr('width', '90px')
				.attr("height", "30px")
				.attr("fill", "transparent")
				.attr("stroke", "transparent")
				.attr("stroke-width", "0px")
				.attr("rx", 4)
				.attr("ry", 4)
				.attr("x", function (d) { return -50 })
				.attr("y", function (d) { return 40 })
				.attr('cursor', "pointer")

			labelRect.append('text')
				.attr("x", function (d) { return -50 })
				.attr("y", function (d) { return 48 })
				.attr("dy", function (d) { return .2 })
				.attr('fill', '#1d7cb9')
				.style('font-family','Roboto, sans-serif')
				.style('font-size','11px')
				.style('width','90px')
				.style('stroke-width','0px')
				.style('text-anchor','middle')
				.attr('class', 'labelTextC')
				.attr("opacity", 0)
				.attr('cursor', "pointer")
				.text(function (d) {
					return d.caption
			}).call(wrap,85)

			menuImg.append('circle')
				.attr('class', 'imgBgC')
				.attr('fill','transparent')
				.attr('stroke', "red")
				.attr("stroke-width", "0")
				.attr("r", '24px')
				.attr("cx", function (d) { return 0 })
				.attr("cy", function (d) { return 0 })
				.attr('cursor', "pointer")

			menuImg
				.append('image')
				.attr('class','imgC')
				.attr('xlink:href', function (d, j) {
					if(d.selectClass){
						return "/final/images/Light/svg/" + d.menu_iconCls + "Hover.svg";
					}else{
						return "/final/images/Light/svg/" + d.menu_iconCls + ".svg";
					}
				})
				.attr("width", '42')
				.attr("height", '42')
				.attr('cursor', "pointer")
				.transition()
				.ease("easeLinear")
				.duration(200)
				.attr("x", function (d) { return -21 })
				.attr("y", '-21px')
		}
	}
});


/*  wrap function for text content wrap and center alignment  */
function wrap(text, width) {
	text.each(function() {
	  var text = d3.select(this),
		  words = text.text().split(/\s+/).reverse(),
		  word,
		  line = [],
		  lineNumber = 0,
		  lineHeight = 1.1, // ems
		  y = text.attr("y"),
		  dy = parseFloat(text.attr("dy")),
		  tspan = text.text(null).append("tspan").attr("x", 0).attr("y", y).attr("dy", dy + "em")
	  while (word = words.pop()) {
		line.push(word)
		tspan.text(line.join(" "))
		if (tspan.node().getComputedTextLength() > width) {
			lineNumber = 	(++lineNumber * lineHeight + dy);
		  line.pop()
		  tspan.text(line.join(" "))
		  line = [word]

		  tspan = text.append("tspan").attr("x", 0).attr("y", y).attr("dy", lineNumber+'em').text(word)
		}
	  }
	})
  }
/*  wrap function for text content wrap and center alignment   */

