var originalShow = Ext.window.MessageBox.prototype.show;

Ext.override(Ext.window.MessageBox,{
	minWidth : 550,
	show: function(cfg) {
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}
		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;
			Ext.applyIf(cfg,{width : tmpWidth});
		} 
		return originalShow.apply(this, arguments);
	},
	alert: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}
			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon: 'gen-warning size32 color-warning',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},
	confirm: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}
			cfg = {
				title: cfg,
				//icon: 'iconConfirmation',
				icon: 'gen-question size32 color-question',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.override(Ext.LoadMask,{
	maskCls:'modalWhiteBg'
});

Ext.define('LimitedAdminHome.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	id: 'viewport',
	cls:'content-frame',
	requires: [
		'LimitedAdminHome.view.GetStarted',
		'LimitedAdminHome.view.WhatNext',
		'LimitedAdminHome.view.AdminWizard',
		'LimitedAdminHome.view.ComponentDetailGrid',
		'LimitedAdminHome.view.AllComponentsGrid',
		'LimitedAdminHome.view.UploadAgentsWizard',
		'LimitedAdminHome.view.DownloadAgentsWizard'
	],

	initComponent: function() 
	{
		var viewXtype = '';
		if (showUploadAgentUI)
		{
			viewXtype = 'UploadAgentsWizard';
		}
		else if (showDownloadAgentUI)
		{
			viewXtype = 'DownloadAgentsWizard';
		}
		else
		{
			viewXtype = 'getstarted';
			if (publicJson.hasManagedComponents)
			{
				viewXtype = 'adminwizard';
			}
		}

		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}

		this.items = [
			{
				xtype: viewXtype
			}
		];

		this.callParent();
	},
	listeners: 
	{
		'beforerender': function() 
		{
			if (showUploadAgentUI)
			{
				viewXtype = 'UploadAgentsWizard';
				var viewportObj = Ext.getCmp('viewport');
				viewportObj.removeAll();
				viewportObj.add({
					xtype: 'UploadAgentsWizard'
				});
				viewportObj.doLayout();
			}
			else if (showDownloadAgentUI)
			{
				viewXtype = 'DownloadAgentsWizard';
				var viewportObj = Ext.getCmp('viewport');
				viewportObj.removeAll();
				viewportObj.add({
					xtype: 'DownloadAgentsWizard'
				});
				viewportObj.doLayout();
			}
			else
			{
				if (!Ext.isEmpty(fromAction))
				{
					if (showWelcomeWizard != null && showWelcomeWizard != "yes")
					{
						if (fromAction.indexOf('_') != -1)
						{
							if (fromAction.indexOf('monitors_') != -1)
							{
								var viewportObj = Ext.getCmp('viewport');
								viewportObj.removeAll();

								viewportObj.add({
									xtype: 'adminwizard'
								});

								if (fromAction.indexOf(':') != -1)
								{
									var monitors = fromAction.substring(fromAction.indexOf('_')+1,fromAction.indexOf(':'));
									var category = fromAction.substring(fromAction.indexOf(':')+1);
									var remoteAgent = sessionStorage.getItem("remoteAgent");
									if (category == 'category')
									{
										appCnt.goToDiscoverServers(event,monitors,remoteAgent);
									}
									else
									{
										appCnt.gotoDiscovers(category,monitors);
									}
								}
								else
								{
									var monitors = fromAction.substring(fromAction.indexOf('_')+1);
									appCnt.gotoApplicationServers(monitors);
								}
							}
							else if (fromAction.indexOf('downloadagents_') != -1)
							{
								var viewportObj = Ext.getCmp('viewport');
								viewportObj.removeAll();

								viewportObj.add({
									xtype: 'adminwizard'
								});
								var monitors = fromAction.substring(fromAction.indexOf('_')+1,fromAction.indexOf(':'));
								var agentType = fromAction.substring(fromAction.indexOf(':')+1);
								appCnt.goToDownloadAgents(agentType,monitors);
							}
							else
							{
								var viewportObj = Ext.getCmp('viewport');
								viewportObj.removeAll();

								viewportObj.add({
									xtype: 'adminwizard'
								});
								Ext.getCmp('new_ground').layout.setActiveItem(1);

								classify = fromAction.substring(fromAction.indexOf('_')+1);
								//fromAction = fromAction.substring(0,fromAction.indexOf('_'));
								isClassifyView = true;
								if (!Ext.isEmpty(classify) && classify == 'componentConfiguration')
								{
									appCnt.addNewNetScalerComponent('componentsGlance','Citrix_NetScaler',classify);
								}
								else
								{
									appCnt.gotoMoreComponents(classify,strServer);
								}
							}
						}
					}
				}
			}
		}
	}
});



