<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "org.json.simple.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<%
	JSONObject rootJson = new JSONObject();
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,_user.getLoginID()); // For Limited admin
	ArrayList compNicks = roleInfo.getAllServerNicks();
	boolean isLimitedAdmin = !roleInfo.hasAllComponentAccess();

	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] s_eagent_servers = extInfo.getRemoteComponents();

	Vector v_eagent_servers = new Vector();
	String s_tmp = "";
	String s_val = "";
	String s_eagent = request.getParameter("eagent");
	s_eagent=(s_eagent==null)?"null":s_eagent;

	if(s_eagent != null && !s_eagent.equals("null"))
	{
		if (s_eagent_servers != null)
		{
			for(int i=0;i < s_eagent_servers.length;i++)
			{
				s_tmp = s_eagent_servers[i];
				s_val = extInfo.getRemoteAgentForHost(s_tmp);

				if (s_val.indexOf(",") > -1 
					&& (s_val.indexOf(s_eagent+",") > -1 
						|| s_val.startsWith(s_eagent+",") 
						|| s_val.endsWith(s_eagent)))
				{
					v_eagent_servers.addElement(s_tmp);
				}
				else if(s_val.equals(s_eagent))
				{
					v_eagent_servers.addElement(s_tmp);
				}
				else
				{
					continue;
				}
			}
		}
		v_eagent_servers.retainAll(compNicks);
	}

	String[] s_eagents = null;
	if (isLimitedAdmin)
	{
		EgUserElementsInfo userElmentsObj = new EgUserElementsInfo();
		ArrayList agentsList = userElmentsObj.getRemoteAgentsForUser(_user.getLoginID());
		s_eagents = (String[])agentsList.toArray(new String[0]);
	}
	else
	{
		s_eagents = extInfo.getAllRemoteAgents();
	}


	if (s_eagents != null)
	{
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
	}
	else
	{
		s_eagents = new String[0];
	}

	JSONArray ManagedHostByThisAgntInner = new JSONArray();
	JSONObject ManagedHostByThisAgntInnerObj = new JSONObject();

	JSONArray ManagedHostByThisAgnt = new JSONArray();
	JSONObject ManagedHostByThisAgntObj = new JSONObject();

	String keywordsearch = request.getParameter("keywordsearch");

	IniFile agentlessdiscIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_agentlessdisc.ini");
	IniFile mgrmiscIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_mgrmisc.ini");
	if (s_eagent != null && !s_eagent.equals("null"))
	{
		String discDetails [] = agentlessdiscIni.getVariables(s_eagent);
		if (discDetails != null && discDetails.length > 0)
		{
			for (int k=0; k<discDetails.length; k++)
			{
				ManagedHostByThisAgntInnerObj = new JSONObject();
				String discVar = discDetails[k];
				discVar = discVar.substring(0,discVar.indexOf("#"));
				String displayName = mgrmiscIni.getValue("HYPERVISORS_UI_MAPPINGS",discVar);
				if (keywordsearch != null && keywordsearch.trim().length() > 0)
				{
					if ((displayName.toLowerCase()).indexOf(keywordsearch.toLowerCase()) != -1)
					{
						ManagedHostByThisAgntInnerObj.put("displayField",displayName);
						ManagedHostByThisAgntInnerObj.put("valueField",discVar);
						ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
					}
				}
				else
				{
					ManagedHostByThisAgntInnerObj.put("displayField",displayName);
					ManagedHostByThisAgntInnerObj.put("valueField",discVar);
					ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
				}
			}
			if (!ManagedHostByThisAgntInner.isEmpty())
			{
				ManagedHostByThisAgntObj.put(_mapping.getTextDescription("admin.la.Discovery enabled for"),ManagedHostByThisAgntInner);
			}
			if (!ManagedHostByThisAgntObj.isEmpty())
			{
				ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);
			}
		}
	}
	
	ManagedHostByThisAgntObj = new JSONObject();
	ManagedHostByThisAgntInner = new JSONArray();

	int hostsCount = v_eagent_servers.size();
	if (hostsCount > 0)
	{
		Collections.sort(v_eagent_servers,String.CASE_INSENSITIVE_ORDER);
		for(int j=0; j<hostsCount; j++)
		{
			ManagedHostByThisAgntInnerObj = new JSONObject();
			String str_temp = (String)v_eagent_servers.get(j);

			if (keywordsearch != null && keywordsearch.trim().length() > 0)
			{
				if ((str_temp.toLowerCase()).indexOf(keywordsearch.toLowerCase()) != -1)
				{
					ManagedHostByThisAgntInnerObj.put("displayField",str_temp);
					ManagedHostByThisAgntInnerObj.put("valueField",str_temp);
					ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
				}
			}
			else
			{
				ManagedHostByThisAgntInnerObj.put("displayField",str_temp);
				ManagedHostByThisAgntInnerObj.put("valueField",str_temp);
				ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
			}
		}
		if (!ManagedHostByThisAgntInner.isEmpty())
		{
			ManagedHostByThisAgntObj.put(_mapping.getTextDescription("admin.la.Managed Hosts"),ManagedHostByThisAgntInner);
		}
		if (!ManagedHostByThisAgntObj.isEmpty())
		{
			ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);
		}
	}
	
	rootJson.put("ManagedHostByThisAgent",ManagedHostByThisAgnt);

	v_eagent_servers.removeAllElements();
	out.println(rootJson.toString());
%>



