
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.egurkha.ini.IniUI"	%>
<%@ page import = "org.json.simple.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootObj = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	JSONObject langEntries = new JSONObject();

	IniUI ui = (IniUI)IniUI.getInstance();
	String strSortPerCount = ui.getValue("SERVER_DISP_DETAILS", "SORTPERCOUNT");
	boolean sortPerCount = true;
	if (strSortPerCount == null || !strSortPerCount.equalsIgnoreCase("true"))
	{
		sortPerCount = false;
	}
	
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	List listManagedComponents = null;
	boolean aggregateSupported = EgInstallInfo.isAggregationSupported();
	String showOnly = request.getParameter("showOnly");
	if(aggregateSupported && showOnly != null && showOnly.equals("aggregate"))
	{
		listManagedComponents = ri.getAllAggregateServers();
	}
	else
	{
		showOnly="individual";
		listManagedComponents = ri.getAllNonAggregateServers();
	}

	ArrayList aListManagedComponents = new ArrayList(listManagedComponents);
	rootObj.put("aListManagedComponents",aListManagedComponents.size());
	rootObj.put("totalcount",_mapping.getTextDescription("admin.servertypes.Total Components") + " : "+aListManagedComponents.size());
	rootObj.put("aggregateSupported",new Boolean(aggregateSupported));

	if (sortPerCount)
	{
		JSONArray componentListArr = new JSONArray();
		EgInfrastructure egInfrastructure = new EgInfrastructure(aListManagedComponents,"HomePage");
		TreeMap tmapComponentsCount = egInfrastructure.getComponentsCount();
		
		if (tmapComponentsCount == null)
		{
			tmapComponentsCount = new TreeMap();
		}

		Iterator itrComponentsCount = tmapComponentsCount.keySet().iterator();
		while (itrComponentsCount.hasNext())
		{
			Integer intCountObj = (Integer)itrComponentsCount.next();
			int size=intCountObj.intValue();
			ArrayList aListComponentTypes = (ArrayList)tmapComponentsCount.get(intCountObj);
			aListComponentTypes = sorter.getSortedCompTypeList(aListComponentTypes);

			for (int i=0;i<aListComponentTypes.size();i++)
			{
				JSONObject tmpObj = new JSONObject();
				EgName nameObj = (EgName)aListComponentTypes.get(i);
				String server = nameObj.getActualName();
				String displayServer = nameObj.getLocalName();

				tmpObj.put("mcomponentType",displayServer);
				tmpObj.put("count",new Integer(size));
				tmpObj.put("hiddenColumn",server);
				componentListArr.add(tmpObj);
			}
		}
		rootObj.put("componentListArr",componentListArr);
	}
	else
	{
		EgInfrastructure egInfrastructure = new EgInfrastructure(aListManagedComponents,"HomePage");
		TreeMap tmapComponents = egInfrastructure.getComponents();
		Iterator itrComponents = tmapComponents.keySet().iterator();
		ArrayList aListComponentTypes = new ArrayList();
		TreeMap tmapCount = new TreeMap();
		while (itrComponents.hasNext())
		{
			String strComponentType = (String)itrComponents.next();
			ArrayList aListComponents = (ArrayList)tmapComponents.get(strComponentType);
			int compSize = aListComponents.size();
			aListComponentTypes.add(strComponentType);
			tmapCount.put(strComponentType,new Integer(compSize));
		}

		aListComponentTypes = sorter.getSortedCompTypeList(aListComponentTypes);
		JSONArray componentListArr = new JSONArray();
		for(int i=0; i<aListComponentTypes.size(); i++)
		{
			JSONObject tmpObj = new JSONObject();
			EgName nameObj = (EgName)aListComponentTypes.get(i);
			String server = nameObj.getActualName();
			String displayServer = nameObj.getLocalName();
			Integer intObjCount = (Integer)tmapCount.get(server);
			int size = intObjCount.intValue();

			tmpObj.put("mcomponentType",displayServer);
			tmpObj.put("count",new Integer(size));
			tmpObj.put("hiddenColumn",server);
			componentListArr.add(tmpObj);
		}
		rootObj.put("componentListArr",componentListArr);
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());

	out.println(rootObj.toString());

%>




