Ext.define('LockedAccounts.controller.Main', {
	extend	:'Ext.app.Controller',
	views	:['LockedAccounts'],
	refs	:[
		{
			selector:'lockedaccounts', 
			ref		:'lockedaccounts'
		},
	],
	init	:function() {
		appCnt = this;
		this.buildFieldData()
		this.control({
			'lockedaccounts': {
				'afterrender': this.afterMainRender
			},
			'lockedaccounts trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
		});
	},
	buildFieldData: function() {
		Ext.Ajax.request({
			url		: 'LockedAccounts/data/LockedAccountsJSON.jsp',
			method	: 'POST',
			async	: false,
			success	: function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function() {
		var resultsData = publicJSON['gridValues'];
			Ext.getCmp('gridDisplay').show();
			Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
		var noExtFound = publicJSON['NoExtFound'];
		if (noExtFound == "true")
		{
			Ext.getCmp('gridSearch').disable();
		}
		else
		{
			Ext.getCmp('gridSearch').enable();
		}
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url		: 'LockedAccounts/data/LockedAccountsJSON.jsp?egTitleSearchStr='+gridsearch,
			method	: 'POST',
			success	: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['gridValues'];
				Ext.getCmp('gridDisplay').show();
				if (value != null && value.length > 0){
					Ext.getCmp('gridDisplay').store.loadRawData(publicJSON['gridValues']);
				}
				else{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noSearchFound+'.</div></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
				Ext.getCmp('gridDisplay').getSelectionModel().deselectAll(true);
			}
		});
	},
	handleDeleteIconClick: function(gridView, row, col){
		var task = Ext.getCmp('gridDisplay').getStore().getAt(row);
		var userName = task.get('Username');
		this.deleteTask(userName,row);
	},
	deleteTask: function(userName,rowIndex) {
		var callInitMd = this;
		Ext.Msg.show({
			title	: 'Locked Accounts',
			msg		: deleteSingleAckttMsg+" '"+userName+"'"+"?",
			buttons	: Ext.Msg.YESNO,
			icon	: 'iconConfirmation',
			width : 300,
			fn		: function(response) {
			if (response === 'yes') {
					Ext.Ajax.request({
					url		: "LockedAccounts/data/LockedAccountsJSONp.jsp?deleteGroups="+userName+"&mode=delete",
					method	: 'POST',
					success	: function( response ) {
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
							var jsonText = response.responseText;
							publicJSON = Ext.decode(jsonText);
							Ext.getCmp('gridSearch').setRawValue('');
							callInitMd.buildFieldData()

							var resultsData = publicJSON['gridValues'];
							if (resultsData == null || resultsData.length == 0)
							{
								Ext.getCmp('gridSearch').disable()
								Ext.getCmp('gridDisplay').show();
								Ext.getCmp('gridDisplay').getStore().loadData('');
								Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noAccMsg+'.</div></td></tr></table>';
								Ext.getCmp('gridDisplay').getView().refresh();
							}
							else
							{
								Ext.getCmp('gridSearch').enable()
								Ext.getCmp('gridDisplay').show();
								Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
							}
							Ext.getCmp('gridDisplay').getSelectionModel().deselectAll(true);
						}
					}
					});
				}
			}
		});
		
	},
	handleDeleteSelected: function() {
		var callInitMd = this;
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if (grid=="") {
			Ext.MessageBox.show(
			{
				title :'Locked Accounts',
				msg : publicJSON['screenLabels']['no accounts selected']+'.',
				icon : 'iconInformation',
				buttons	: Ext.Msg.OK,
				width : 300
			});
			return false;
		}
		for (var i=0; i < grid.length ; i++) {
			values=grid[i];
			id=values.get('Username');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for (var j=0; j < array.length; j++) {
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.show(
		{
			title : mainPageTitle,
			msg : publicJSON['screenLabels']['deleteforSelectedMessage'],
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			width : 300,
			fn : function(buttonText) {
				if (buttonText == "yes") {
					var resultUrl = "LockedAccounts/data/LockedAccountsJSONp.jsp?deleteGroups="+selectedGroups+"&mode=delete";
					Ext.Ajax.request({
						url		: resultUrl,
						method	: 'POST',
						async	:false,
						success	: function( response ) {
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
								var jsonText = response.responseText;
								publicJSON = Ext.decode(jsonText);
								Ext.getCmp('gridSearch').setRawValue('');
								callInitMd.buildFieldData()

								var resultsData = publicJSON['gridValues'];
								if (resultsData == null || resultsData.length == 0) {
									Ext.getCmp('gridSearch').disable()
									Ext.getCmp('gridDisplay').show();
									Ext.getCmp('gridDisplay').getStore().loadData('');
									Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noAccMsg+'.</div></td></tr></table>';
									Ext.getCmp('gridDisplay').getView().refresh();
								}
								else {
									Ext.getCmp('gridSearch').enable()
									Ext.getCmp('gridDisplay').show();
									Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
								}
								Ext.getCmp('gridDisplay').getSelectionModel().deselectAll(true);
							}
						}
					});
				}
			}
		});
	},
});



