var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view)
	{
		meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
		return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
	},
//	selectAll: function(){
//		var rowIndex=0;
//		while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
//			var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
//			Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);
//			rowIndex++;
//		}
//		var view = Ext.getCmp('gridDisplay').getView();
//		var headerCt = view.headerCt;
//		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
//		console.log('this.store.getCount()',this.store.getCount());
//		console.log('this.selected.getCount()',this.selected.getCount());
//		console.log('selectall method',hdSelectStatus);
//		console.log('selectall method',rowIndex);
//		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
//		if (checkHd) {
//			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
//		}
//	},
	deselectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
			Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view = Ext.getCmp('gridDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('LockedAccounts.view.LockedAccounts',
{
	extend: 'Ext.form.Panel',
	alias: 'widget.lockedaccounts',
	cls:'outerpanel',
	id: 'mainUser',
	title: mainPageTitle,
	margin:'8 8 0 8',
	header:{cls:'zonereporthead'},

	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.CustomGrid',
		'utilities.innerScrollContainer'
	],

	dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		height: 25,
		border:true,
		padding: 3,
		layout:{pack:'center'},
		items:[
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDescc+'.</center>',
			}
		]
	}],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'gridDisplay',
			store:new Ext.data.Store({
				fields: ['Username'],
				data: []
			}),
			autoScroll:true,
			flex: 1,
			margin: 10,
			selModel:mySelectionModel,
			listeners:{
				rowclick: function (in_this, rowIndex, e)
				{
					var record = in_this.getStore().getAt(rowIndex);
				}
			},
			viewConfig: {
				deferEmptyText: true
			},
			emptyText:'<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noAccMsg+'.</div></td></tr></table>',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: Username,
						dataIndex: 'Username',
						id: 'DispUserName',
						width: 300,
						flex:1,
					},
					{
						header: '<div class="iconGroupedUnlock" data-qtip="Unlock Selected" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						id: 'DeleteOver',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleDeleteSelected();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Unlock' data-qclass='yellowTip'";
							return "<div style='cursor:pointer' onclick=\"javascript:appCnt.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconUnlock'></div>";
						}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					cls:'whitedropdown_search',
					id: 'gridSearch',
					name: 'gridSearch',
					emptyText: 'Search',
					padding: '2 6 2 0',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) 
						{
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) 
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id: 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id: 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset(); 
					},
					onTrigger2Click : function() {
						appCnt.mainGridSearch();
					}
				}
			]
		}
	]

});



