
Ext.define('LoggedInUsers.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'}
	],
	init:function()
	{
		this.buildMainData();
		this.control({	
			'main':
			{
				'boxready': this.loadMain
			},
			'main button[id="refreshPanel"]':
			{
				'click':this.refreshLoggedinDetailsPage
			}
		})
	},
	buildMainData : function()
	{
		var defaultUrl = 'LoggedInUsers/data/EgTestUserRegistryJSON.jsp';
		Ext.Ajax.request({
			url : defaultUrl,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	refreshLoggedinDetailsPage : function()
	{
		window.location.href = "/final/admin/testUserRegistry.jsp";
	},
	loadMain: function()
	{
		var userdetails = Ext.getCmp('userdetails');
		var userRawData = publicJSON['LoggedInUsers'];
		var sessionCount = publicJSON['sessionCount'];
		var unique_users = publicJSON['unique_users'];
		var gridColums = publicJSON['gridColums'];

		Ext.getCmp('sessionCount').setText(pageIntnl2 + " : " + sessionCount);
		Ext.getCmp('sessionCountUnique').setText(pageIntnl3 + " : " + unique_users);
		userdetails.getStore().loadRawData(userRawData);
		var gridLength = userdetails.columns.length;
		for (var i = 0;i<gridLength;i++)
		{
			userdetails.columns[i].setText(gridColums[i]);
		}
	}
});