Ext.define('LoggedInUsers.view.Main',{
	extend:'Ext.form.Panel',
	alias:'widget.main',
	id: pageTitle,
	cls:'outerpanel',
	margin :'8 8 0 8',
	title : pageTitle,

	requires: ['utilities.CustomGrid'],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc+'</center>',
			}
		]
	}],

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			name: 'userdetails',
			id : 'userdetails',
			margin: 10,
			flex: 1,
			title : pageIntnl1,
			store: new Ext.data.Store({
				fields: ['Host IP', 'User name','User Role','LOGIN TIME','LAST ACCESSED TIME'],
				data: []
			}),
			columns: [
				{
					dataIndex: 'Host IP',
					header: 'Host IP',
					flex: 1,
					doSort: function(state) {
						var ds = this.up('tablepanel').store;
						var field = this.getSortParam();
						customIPv4Sorting(ds,state,field);
						Ext.getCmp('userdetails').getView().refresh();
						var cssClassName = "x-column-header-sort-"+state;
						this.addCls(cssClassName);
					}
				},
				{
					dataIndex: 'User name',
					header: 'User name',
					flex:1
				},
				{
					dataIndex: 'User Role',
					header: 'User Role',
					flex:1
				},
				{
					dataIndex: 'LOGIN TIME',
					header: 'LOGIN TIME',
					flex: 1,
					doSort: function(state) {
						var ds = this.up('tablepanel').store;
						var field = this.getSortParam();
						customDateSorting(ds,state,field,userDateFormat);
						Ext.getCmp('userdetails').getView().refresh();
						var cssClassName = "x-column-header-sort-"+state;
						this.addCls(cssClassName);
					}
				},
				{
					dataIndex: 'LAST ACCESSED TIME',
					header: 'LAST ACCESSED TIME',
					flex: 1,
					doSort: function(state) {
						var ds = this.up('tablepanel').store;
						var field = this.getSortParam();
						customDateSorting(ds,state,field,userDateFormat);
						Ext.getCmp('userdetails').getView().refresh();
						var cssClassName = "x-column-header-sort-"+state;
						this.addCls(cssClassName);
					}
				}
			],
			hideHeaders: false,
			tbar: [
				{
					xtype: 'tbspacer',
					width: 6
				},
				{
					xtype: 'label',
					id: 'sessionCount',
					cls: 'font_bold11'
				},
				{
					xtype: 'tbseparator'
				},
				{
					xtype: 'tbspacer'
				},
				{
					xtype: 'label',
					id: 'sessionCountUnique',
					cls: 'font_bold11'
				}
			],
			tools : [
				{
					xtype : 'button',
					text : pageIntnl4,
					toolTip : 'refresh',
					cls: "button20",
					id : 'refreshPanel'
				}
			]
		}
	]

});



