Ext.define('LogoMessages.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AudibleAlerts','Configuration','FileUpload','Messages','Monitor','LoginScreen','Viewport','FileUploadForm','Reporter'],
	refs:[
		{selector:'settinglist', ref:'settinglist'},
		{selector:'loginscreen', ref:'loginscreen'},
		{selector:'viewport', ref:'viewport'},
		{selector:'fileupload', ref:'fileupload'},
		{selector:'fileuploadform', ref:'fileuploadform'},
		{selector:'monitor', ref:'monitor'},
		{selector:'reporter', ref:'reporter'},
		{selector:'configuration', ref:'configuration'},
		{selector:'audiblealerts', ref:'audiblealerts'},
		{selector:'messages', ref:'messages'}
	],
	init:function(){
		isDouble = '';
		this.control({
			'settinglist':
			{
				'itemclick': this.onClickData
			},
			'viewport':
			{
				'afterrender': this.afterMainRender
			},
			'loginscreen radio[name="loginlogo"]':
			{
				'change': this.radioChange
			},
			'loginscreen button[id="eg_back"]':
			{
				'click': this.uploadLoginWindow
			},
			'loginscreen button[id="loginUpdateBtn"]':
			{
				'click': this.loginImageUpdate
			},
			'monitor radio[name="monitorlogo"]':
			{
				'change': this.monitorRadioChange
			},
			'monitor button[id="monitorUpload"]':
			{
				'click': this.uploadMonitorWindow
			},
			'fileuploadform radio[name="cateChk"]':
			{
				'change': this.applyToModuleChange
			},
			'monitor button[id="monitorUpdateBtn"]':
			{
				'click': this.monitorImageUpdate
			},
			'reporter radio[name="reporterlogo"]':
			{
				'change': this.reporterRadioChange
			},
			'reporter button[id="reporterUpload"]':
			{
				'click': this.uploadReporterWindow
			},
			'reporter button[id="reporterUpdateBtn"]':
			{
				'click': this.reporterImageUpdate
			},
			'configuration radio[name="configlogo"]':
			{
				'change': this.configRadioChange
			},
			'configuration button[id="configUpload"]':
			{
				'click': this.uploadConfigWindow
			},
			'configuration button[id="configUpdateBtn"]':
			{
				'click': this.configImageUpdate
			},
			'audiblealerts radio[name="customwav"]':
			{
				'change': this.soundPrefRadioChange
			},
			'audiblealerts button[id="soundUploadBtn"]':
			{
				'click': this.uploadAudibleAlertWindow
			},
			'audiblealerts button[id="audibleAlertUpdateBtn"]':
			{
				'click': this.audibleAlertUpdate
			},
			'fileupload button[id="fileUploadBtn"]':
			{
				'click': this.fileUpload
			},
			'messages button[id="msgUpdateBtn"]':
			{
				'click': this.messagesUpdate
			},
		});
	},

	afterMainRender: function()
	{
		var mainViewIdObj = Ext.getCmp('mainViewId');
		var innerMainPanelObj = Ext.getCmp('innerPanel');

		var yesLoginlogoObj = Ext.getCmp('yesLoginlogoId');
		var noLoginlogoObj = Ext.getCmp('noLoginlogoId');

		var egBackObj = Ext.getCmp('eg_back');

		Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - LOGIN SCREEN');

		var process= 'loginscreen';
		if (!Ext.isEmpty(isHKTEnable) && isHKTEnable.toLowerCase() == "true")
		{
			process = 'audiblealerts';
		}
		var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if (process == 'loginscreen')
				{
					var loginYesStr = jsonData.loginScreenJson.loginYesStr;
					var loginNoStr = jsonData.loginScreenJson.loginNoStr;

					if (loginYesStr == 'checked')
					{
						yesLoginlogoObj.setValue('YES');
						egBackObj.setDisabled(false);
					}
				
					if (loginNoStr == 'checked')
					{
						noLoginlogoObj.setValue('NO');
						egBackObj.setDisabled(true);
					}

					var logoMessagesTree = Ext.getCmp('logoMsgTreePanel');
					var selectedNodeID = 'loginScrnId';

					var record = logoMessagesTree.getStore().getNodeById(selectedNodeID);
					logoMessagesTree.getSelectionModel().select(record);
				}
				else if (process == 'audiblealerts')
				{
					var innerMainPanelObj = Ext.getCmp('innerPanel');
					innerMainPanelObj.removeAll();
					innerMainPanelObj.add({ xtype: 'audiblealerts' });

					Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - AUDIBLE ALERTS');

					var custSoundPrefObj = Ext.getCmp('customSoundPref');
					var defaultSoundPrefObj = Ext.getCmp('defaultSoundPref');
					var noneSoundPrefObj = Ext.getCmp('noneSoundPref');
					var fileUploadObj = Ext.getCmp('soundUploadBtn');
					
					var isCustomOption = '';
					var isDefaultOption = '';
					var isNoneOption = '';

					isCustomOption = jsonData.audibleAlertsJson.customSelected;
					isDefaultOption = jsonData.audibleAlertsJson.defaultSelected;
					isNoneOption = jsonData.audibleAlertsJson.noneSelected;

					if (isCustomOption == 'checked')
					{
						custSoundPrefObj.setValue(true);
						fileUploadObj.setDisabled(false);
					}
					else if (isDefaultOption == 'checked')
					{
						if (!defaultSoundPrefObj.getValue())
						{
							defaultSoundPrefObj.setValue(true);
						}
						if (!fileUploadObj.isDisabled())
						{
							fileUploadObj.setDisabled(true);
						}
					}
					else if (isNoneOption == 'checked')
					{
						noneSoundPrefObj.setValue(true);
						if (!fileUploadObj.isDisabled())
						{
							fileUploadObj.setDisabled(true);
						}
					}

					var logoMessagesTree = Ext.getCmp('logoMsgTreePanel');
					var selectedNodeID = 'audioScrnId';

					var record = logoMessagesTree.getStore().getNodeById(selectedNodeID);
					logoMessagesTree.getSelectionModel().select(record);
				}
			}
		});
	},

	radioChange: function()
	{
		var yesLoginlogoObj = Ext.getCmp('yesLoginlogoId');
		var noLoginlogoObj = Ext.getCmp('noLoginlogoId');

		var egBackObj = Ext.getCmp('eg_back');

		if (yesLoginlogoObj.getValue())
		{
			egBackObj.setDisabled(false);
		}

		if (noLoginlogoObj.getValue())
		{
			egBackObj.setDisabled(true);
		}
	},

	onClickData: function(me, record, item, index, e, eOpts)
	{
		var mainViewIdObj = Ext.getCmp('mainViewId');
		var innerMainPanelObj = Ext.getCmp('innerPanel');
		var label = record.data.text;
		if (label == loginScreenTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'loginscreen'});

			var loginYesStr = '';
			var loginNoStr = '';
			var afterAjax = 'false';

			Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - LOGIN SCREEN');

			var yesLoginlogoObj = Ext.getCmp('yesLoginlogoId');
			var noLoginlogoObj = Ext.getCmp('noLoginlogoId');

			var egBackObj = Ext.getCmp('eg_back');

			var process = 'loginscreen';

			//discoveredComponents\app\controller
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				async : false,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;

					loginYesStr = jsonData.loginScreenJson.loginYesStr;
					loginNoStr = jsonData.loginScreenJson.loginNoStr;

					afterAjax = 'true';
				}
			});

			if (afterAjax == 'true')
			{
				if (loginYesStr == 'checked')
				{
					yesLoginlogoObj.setValue('YES');
					egBackObj.setDisabled(false);
				}

				if (loginNoStr == 'checked')
				{
					noLoginlogoObj.setValue('NO');
					if (!egBackObj.isDisabled())
					{
						egBackObj.setDisabled(true);
					}
				}
			}
		}

		if (label == monitorTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'monitor' });

			Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - MONITOR INTERFACE');

			var custLogoPrefObj = Ext.getCmp('custLogoPrefID');
			var defaultLogoPrefObj = Ext.getCmp('defaultLogoPrefID');
			var noneLogoPrefObj = Ext.getCmp('noneLogoPrefID');
			var fileUploadObj = Ext.getCmp('monitorUpload');

			var process = 'monitorinterface';

			var isCustomOption = '';
			var isDefaultOption = '';
			var isNoneOption = '';

			var afterAjax = 'false';

			//discoveredComponents\app\controller
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				async : false,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;

					var monitorCustomImage = jsonData.monitorInterfaceJson.monitorCustomImage;

					isCustomOption = jsonData.monitorInterfaceJson.customStr;
					isDefaultOption = jsonData.monitorInterfaceJson.defaultStr;
					isNoneOption = jsonData.monitorInterfaceJson.noneStr;

					afterAjax = 'true';
				}
			});

			if (afterAjax == 'true')
			{
				if (isCustomOption == 'checked')
				{
					custLogoPrefObj.setValue(true);
					fileUploadObj.setDisabled(false);
				}

				if (isDefaultOption == 'checked')
				{
					if (!defaultLogoPrefObj.getValue())
					{
						defaultLogoPrefObj.setValue(true);
					}
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}

				if (isNoneOption == 'checked')
				{
					noneLogoPrefObj.setValue(true);
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}
			}
		}

		if (label == reporterTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'reporter'});

			Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - REPORTER INTERFACE');

			var custLogoPrefObj = Ext.getCmp('reporterCustom');
			var defaultLogoPrefObj = Ext.getCmp('reporterDefault');
			var noneLogoPrefObj = Ext.getCmp('reporterNone');
			var fileUploadObj = Ext.getCmp('reporterUpload');

			var process = 'reporterinterface';

			var isCustomOption = '';
			var isDefaultOption = '';
			var isNoneOption = '';

			var afterAjax = 'false';

			//discoveredComponents\app\controller
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				async : false,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;
					var reporterCustomImage = jsonData.reporterInterfaceJson.reporterCustomImage;

					isCustomOption = jsonData.reporterInterfaceJson.repCustom;
					isDefaultOption = jsonData.reporterInterfaceJson.repDefault;
					isNoneOption = jsonData.reporterInterfaceJson.repNone;

					afterAjax = 'true';
				}
			});

			if (afterAjax == 'true')
			{
				if (isCustomOption == ' checked ')
				{
					custLogoPrefObj.setValue(true);
					fileUploadObj.setDisabled(false);
				}

				if (isDefaultOption == ' checked ')
				{
					if (!defaultLogoPrefObj.getValue())
					{
						defaultLogoPrefObj.setValue(true);
					}
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}

				if (isNoneOption == ' checked ')
				{
					noneLogoPrefObj.setValue(true);
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}
			}
		}

		if (label == configTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'configuration' });

			Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - CONFIGURATION MANAGEMENT INTERFACE');

			var custLogoPrefObj = Ext.getCmp('configCustom');
			var defaultLogoPrefObj = Ext.getCmp('configDefault');
			var noneLogoPrefObj = Ext.getCmp('configNone');
			var fileUploadObj = Ext.getCmp('configUpload');

			var process = 'configmanageinterface';

			var isCustomOption = '';
			var isDefaultOption = '';
			var isNoneOption = '';

			var afterAjax = 'false';

			//discoveredComponents\app\controller
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				async : false,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;
					var configCustomImage = jsonData.configMgmtInterfaceJson.configCustomImage;

					isCustomOption = jsonData.configMgmtInterfaceJson.configCustom;
					isDefaultOption = jsonData.configMgmtInterfaceJson.configDefault;
					isNoneOption = jsonData.configMgmtInterfaceJson.configNone;

					afterAjax = 'true';
				}
			});

			if (afterAjax == 'true')
			{
				if (isCustomOption == ' checked ')
				{
					custLogoPrefObj.setValue(true);
					fileUploadObj.setDisabled(false);
				}

				if (isDefaultOption == ' checked ')
				{
					if (!defaultLogoPrefObj.getValue())
					{
						defaultLogoPrefObj.setValue(true);
					}
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}

				if (isNoneOption == ' checked ')
				{
					noneLogoPrefObj.setValue(true);
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}
			}
		}

		if (label == alertsTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'audiblealerts' });

			Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - AUDIBLE ALERTS');

			var custSoundPrefObj = Ext.getCmp('customSoundPref');
			var defaultSoundPrefObj = Ext.getCmp('defaultSoundPref');
			var noneSoundPrefObj = Ext.getCmp('noneSoundPref');
			var fileUploadObj = Ext.getCmp('soundUploadBtn');

			var process = 'audiblealerts';

			var isCustomOption = '';
			var isDefaultOption = '';
			var isNoneOption = '';

			var afterAjax = 'false';

			//discoveredComponents\app\controller
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				async : false,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					//var configCustomImage = jsonData.configMgmtInterfaceJson.configCustomImage;
					isDouble = jsonData.isDouble;
					isCustomOption = jsonData.audibleAlertsJson.customSelected;
					isDefaultOption = jsonData.audibleAlertsJson.defaultSelected;
					isNoneOption = jsonData.audibleAlertsJson.noneSelected;

					afterAjax = 'true';
				}
			});

			if (afterAjax == 'true')
			{
				if (isCustomOption == 'checked')
				{
					custSoundPrefObj.setValue(true);
					fileUploadObj.setDisabled(false);
				}

				if (isDefaultOption == 'checked')
				{
					if (!defaultSoundPrefObj.getValue())
					{
						defaultSoundPrefObj.setValue(true);
					}
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}

				if (isNoneOption == 'checked')
				{
					noneSoundPrefObj.setValue(true);
					if (!fileUploadObj.isDisabled())
					{
						fileUploadObj.setDisabled(true);
					}
				}
			}
		}

		if (label == messagesTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'messages' });

			Ext.getCmp('innerPanel').setTitle('LOGO & MESSAGES - MESSAGES');

			var captionObj = Ext.getCmp('captionID');
			var msg1Obj = Ext.getCmp('msg1ID');
			var msg2Obj = Ext.getCmp('msg2ID');
			var msg3Obj = Ext.getCmp('msg3ID');
			var mailIdObj = Ext.getCmp('subscMailId');
			var pdffooterObj = Ext.getCmp('pdffooter');

			var process = 'messages';

			//discoveredComponents\app\controller
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;
					var captionText = jsonData.messagesJson.caption;
					var msg1 = jsonData.messagesJson.mess1;
					var msg2 = jsonData.messagesJson.mess2;
					var msg3 = jsonData.messagesJson.mess3;
					var mailId = jsonData.messagesJson.mailid;
					var pdfFooter = jsonData.messagesJson.pdfFooter;

					captionObj.setValue(captionText);
					msg1Obj.setValue(msg1);
					msg2Obj.setValue(msg2);
					msg3Obj.setValue(msg3);
					mailIdObj.setValue(mailId);
					pdffooterObj.setValue(pdfFooter);
				}
			});
		}
	},

	monitorRadioChange: function()
	{
		var custLogoPrefObj = Ext.getCmp('custLogoPrefID');
		var defaultLogoPrefObj = Ext.getCmp('defaultLogoPrefID');
		var noneLogoPrefObj = Ext.getCmp('noneLogoPrefID');
		var fileUploadObj = Ext.getCmp('monitorUpload');

		var process = 'monitorinterface';

		if (custLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(false);
		}

		if (defaultLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}

		if (noneLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}
	},

	reporterRadioChange: function()
	{
		var custLogoPrefObj = Ext.getCmp('reporterCustom');
		var defaultLogoPrefObj = Ext.getCmp('reporterDefault');
		var noneLogoPrefObj = Ext.getCmp('reporterNone');
		var fileUploadObj = Ext.getCmp('reporterUpload');

		var process = 'reporterinterface';

		if (custLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(false);
		}

		if (defaultLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}

		if (noneLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}
	},

	configRadioChange: function()
	{
		var custLogoPrefObj = Ext.getCmp('configCustom');
		var defaultLogoPrefObj = Ext.getCmp('configDefault');
		var noneLogoPrefObj = Ext.getCmp('configNone');
		var fileUploadObj = Ext.getCmp('configUpload');

		var process = 'configmanageinterface';

		if (custLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(false);
		}

		if (defaultLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}

		if (noneLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}
	},

	soundPrefRadioChange: function()
	{
		var custLogoPrefObj = Ext.getCmp('customSoundPref');
		var defaultLogoPrefObj = Ext.getCmp('defaultSoundPref');
		var noneLogoPrefObj = Ext.getCmp('noneSoundPref');
		var fileUploadObj = Ext.getCmp('soundUploadBtn');

		var process = 'audiblealerts';

		if (custLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(false);
		}

		if (defaultLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}

		if (noneLogoPrefObj.getValue())
		{
			fileUploadObj.setDisabled(true);
		}
	},

	uploadLoginWindow: function()
	{
		fileUploadModule = 'Login';
		Ext.widget('fileupload').show();
		Ext.getCmp('fileUpload').setHeight(120);
	},

	uploadMonitorWindow: function()
	{
		fileUploadModule = 'Monitor';
		Ext.widget('fileupload').show();
		Ext.getCmp('fileUpload').setHeight(240);

		Ext.getCmp('FILE_0').setFieldLabel('Custom Logo');

		Ext.getCmp('FILE_1').hide();
		Ext.getCmp('FILE_2').hide();
		Ext.getCmp('FILE_3').hide();

		Ext.getCmp('applyToOtherModules').show();

		if (Ext.getCmp('allModulesChk').getValue())
		{
			Ext.getCmp('selectModulesGrp').hide();
		}

		if (Ext.getCmp('specificCateId').getValue())
		{
			Ext.getCmp('selectModulesGrp').show();
		}
	},

	applyToModuleChange: function()
	{
		if (Ext.getCmp('specificCateId').getValue())
		{
			Ext.getCmp('selectModulesGrp').show();
		}

		if (Ext.getCmp('allModulesChk').getValue())
		{
			Ext.getCmp('selectModulesGrp').hide();
		}

		if (fileUploadModule == 'Monitor')
		{
			Ext.getCmp('selectedUIChk1ID').hide();
		}

		if (fileUploadModule == 'Reporter')
		{
			Ext.getCmp('selectedUIChk2ID').hide();
		}

		if (fileUploadModule == 'Config')
		{
			Ext.getCmp('selectedUIChk3ID').hide();
		}
		Ext.getCmp('selectModulesGrp').doComponentLayout();
	},

	uploadReporterWindow: function()
	{
		fileUploadModule = 'Reporter';
		Ext.widget('fileupload').show();
		Ext.getCmp('fileUpload').setHeight(240);

		Ext.getCmp('FILE_0').setFieldLabel('Custom Logo');

		Ext.getCmp('FILE_1').hide();
		Ext.getCmp('FILE_2').hide();
		Ext.getCmp('FILE_3').hide();

		Ext.getCmp('applyToOtherModules').show();

		if (Ext.getCmp('allModulesChk').getValue())
		{
			Ext.getCmp('selectModulesGrp').hide();
		}

		if (Ext.getCmp('specificCateId').getValue())
		{
			Ext.getCmp('selectModulesGrp').show();
		}

		Ext.getCmp('selectedUIChk2ID').hide();
	},

	uploadConfigWindow: function()
	{
		fileUploadModule = 'Config';
		Ext.widget('fileupload').show();
		Ext.getCmp('fileUpload').setHeight(240);

		Ext.getCmp('FILE_0').setFieldLabel('Custom Logo');

		Ext.getCmp('FILE_1').hide();
		Ext.getCmp('FILE_2').hide();
		Ext.getCmp('FILE_3').hide();

		Ext.getCmp('applyToOtherModules').show();

		if (Ext.getCmp('allModulesChk').getValue())
		{
			Ext.getCmp('selectModulesGrp').hide();
		}

		if (Ext.getCmp('specificCateId').getValue())
		{
			Ext.getCmp('selectModulesGrp').show();
		}

		Ext.getCmp('selectedUIChk3ID').hide();
	},

	uploadAudibleAlertWindow: function()
	{
		fileUploadModule = 'audibleAlert';
		Ext.widget('fileupload').show();
		Ext.getCmp('fileUpload').setHeight(200);

		Ext.getCmp('FILE_0').show();
		Ext.getCmp('FILE_0').setFieldLabel('Critical Alarm');

		Ext.getCmp('FILE_1').show();
		Ext.getCmp('FILE_1').setFieldLabel('Major Alarm');

		Ext.getCmp('FILE_2').show();
		Ext.getCmp('FILE_2').setFieldLabel('Minor Alarm');

		Ext.getCmp('FILE_3').hide();
		Ext.getCmp('applyToOtherModules').hide();
	},

	fileUpload: function()
	{
		selectedModule = '';

		var fileUpload = 'yes';
		var fileExt = 'gif/jpg/jpeg/png';

		if (fileUploadModule == 'Login')
		{
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process=loginscreen";

			var adminCustomImage = '';
			var adminSkin = '';

			var fileDetails = Ext.getCmp('FILE_0').getValue();
			var fileExtension = fileDetails.substring((fileDetails.lastIndexOf('.'))+1,fileDetails.length);

			var newFileName = 'manager/tomcat/webapps/final/admin/eg_images/logologin' + '.' + fileExtension;

			if (fileExtension.toLowerCase() != 'gif' && fileExtension.toLowerCase() != 'jpg' && fileExtension.toLowerCase() != 'jpeg' && fileExtension.toLowerCase() != 'png')
			{
				Ext.Msg.show({
					title: fileUploadMsg,
					msg: fileNotWithReqExt + ": '" +fileExt+ "'",
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (isDouble == 'false')
			{
				if(!validateSingleByte(fileDetails))
				{
					Ext.Msg.show({
						title: fileUploadMsg,
						msg: fileNameNotSingleByte,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					adminCustomImage = jsonData.loginScreenJson.adminCustomImage;
					adminSkin = jsonData.adminSkin;

					Ext.getCmp('dispCaptionID').setValue('Custom Logo');
					Ext.getCmp('requestFromID').setValue('../../../admin/EgSettingsTree.jsp');
					Ext.getCmp('uploadForID').setValue('login');
					Ext.getCmp('FILE_0_dstFileID').setValue(newFileName);
					Ext.getCmp('fileExtID').setValue(fileExtension);
					Ext.getCmp('titleID').setValue('Uploading Logo Files');
					Ext.getCmp('fileUploadID').setValue(fileUpload);

					var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=login&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;

					var fileUploadForm = this.getFileuploadform().getForm();
					if (fileUploadForm.isValid())
					{
						fileUploadForm.submit({
							url: urlForFile,
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: fileUploadMsg,
									msg: "Request has been processed successfully",
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								loginImageUploadStatus = "Uploaded";
								Ext.getCmp('fileUpload').destroy();
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							}
						});
					}
				}
			});
		}
		else if (fileUploadModule == 'Monitor')
		{
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process=monitorinterface";

			var monitorCustomImage = '';
			//var adminSkin = '';

			var fileDetails = Ext.getCmp('FILE_0').getValue();
			var fileExtension = fileDetails.substring((fileDetails.lastIndexOf('.'))+1,fileDetails.length);

			var newFileName = 'manager/tomcat/webapps/final/monitor/eg_images/logomonitor' + '.' + fileExtension;
			if (fileExtension.toLowerCase() != 'gif' && fileExtension.toLowerCase() != 'jpg' && fileExtension.toLowerCase() != 'jpeg' && fileExtension.toLowerCase() != 'png')
			{
				Ext.Msg.show({
					title: fileUploadMsg,
					msg: fileNotWithReqExt + ": '" +fileExt+ "'",
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (isDouble == 'false')
			{
				if(!validateSingleByte(fileDetails))
				{
					Ext.Msg.show({
						title: fileUploadMsg,
						msg: fileNameNotSingleByte,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					monitorCustomImage = jsonData.monitorInterfaceJson.monitorCustomImage;

					Ext.getCmp('dispCaptionID').setValue('CustomLogo');
					Ext.getCmp('requestFromID').setValue('../../../admin/EgSettingsTree.jsp');
					Ext.getCmp('uploadForID').setValue('monitor');
					Ext.getCmp('FILE_0_dstFileID').setValue(newFileName);
					Ext.getCmp('fileExtID').setValue(fileExtension);
					Ext.getCmp('titleID').setValue('Uploading Logo Files');
					Ext.getCmp('fileUploadID').setValue(fileUpload);
					Ext.getCmp('uploadAllID').setValue('on');

					var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=CustomLogo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=monitor&uploadDir="+ newFileName +"&fileExt="+fileExtension;

					var fileUploadForm = this.getFileuploadform().getForm();
					if (fileUploadForm.isValid())
					{
						fileUploadForm.submit({
							url: urlForFile,
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: fileUploadMsg,
									msg: "Request has been processed successfully",
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								monitorImageUploadStatus = "Uploaded";
								var selectCategory = Ext.getCmp('selectCategory').getValue();
								if (!Ext.isEmpty(selectCategory) && selectCategory != undefined )
								{
									if(selectCategory == 'all')
									{
										selectedModule = 'monSelected=enabled&repSelected=enabled&conSelected=enabled';
									}
									else
									{
										var chkModuleArr = Ext.getCmp('selectModulesGrp').getValue();
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk1 ) && chkModuleArr.selectedUIChk1 != undefined )
										{
											selectedModule = 'monSelected=enabled';
										}
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk2 ) && chkModuleArr.selectedUIChk2 != undefined )
										{
											selectedModule += '&repSelected=enabled';
										}
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk3 ) && chkModuleArr.selectedUIChk3 != undefined )
										{
											selectedModule += '&conSelected=enabled';
										}
									}
								}
								Ext.getCmp('fileUpload').destroy();
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								selectedModule = '';
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							}
						});
					}
				}
			});
		}
		else if (fileUploadModule == 'Reporter')
		{
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process=reporterinterface";

			var reporterCustomImage = '';
			//var adminSkin = '';

			var fileDetails = Ext.getCmp('FILE_0').getValue();
			var fileExtension = fileDetails.substring((fileDetails.lastIndexOf('.'))+1,fileDetails.length);

			if (fileExtension.toLowerCase() != 'gif' && fileExtension.toLowerCase() != 'jpg' && fileExtension.toLowerCase() != 'jpeg' && fileExtension.toLowerCase() != 'png')
			{
				Ext.Msg.show({
					title: fileUploadMsg,
					msg: fileNotWithReqExt + ": '" +fileExt+ "'",
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			var newFileName = 'manager/tomcat/webapps/final/reporter/images/logoreporter' + '.' + fileExtension;

			if (isDouble == 'false')
			{
				if(!validateSingleByte(fileDetails))
				{
					Ext.Msg.show({
						title: fileUploadMsg,
						msg: fileNameNotSingleByte,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					reporterCustomImage = jsonData.reporterInterfaceJson.reporterCustomImage;

					Ext.getCmp('dispCaptionID').setValue('CustomLogo');
					Ext.getCmp('requestFromID').setValue('../../../admin/EgSettingsTree.jsp');
					Ext.getCmp('uploadForID').setValue('reporter');
					Ext.getCmp('FILE_0_dstFileID').setValue(newFileName);
					Ext.getCmp('fileExtID').setValue(fileExtension);
					Ext.getCmp('titleID').setValue('Uploading Logo Files');
					Ext.getCmp('fileUploadID').setValue(fileUpload);
					Ext.getCmp('uploadAllID').setValue('on');

					var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&requestFrom=EgConfigLogoMsg.jsp&uploadFor=reporter&dispCaption=CustomLogo&uploadDir="+ newFileName +"&fileExt="+fileExtension;
					var fileUploadForm = this.getFileuploadform().getForm();
					if (fileUploadForm.isValid())
					{
						fileUploadForm.submit({
							url: urlForFile,
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: fileUploadMsg,
									msg: "Request has been processed successfully",
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								reporterImageUploadStatus = "Uploaded";
								var selectCategory = Ext.getCmp('selectCategory').getValue();
								if (!Ext.isEmpty(selectCategory) && selectCategory != undefined )
								{
									if(selectCategory == 'all')
									{
										selectedModule = 'monSelected=enabled&repSelected=enabled&conSelected=enabled';
									}
									else
									{
										var chkModuleArr = Ext.getCmp('selectModulesGrp').getValue();
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk1 ) && chkModuleArr.selectedUIChk1 != undefined )
										{
											selectedModule = 'monSelected=enabled';
										}
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk2 ) && chkModuleArr.selectedUIChk2 != undefined )
										{
											selectedModule += '&repSelected=enabled';
										}
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk3 ) && chkModuleArr.selectedUIChk3 != undefined )
										{
											selectedModule += '&conSelected=enabled';
										}
									}
								}
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								selectedModule = '';
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							}
						});
					}
				}
			});
		}
		else if (fileUploadModule == 'Config')
		{
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process=configmanageinterface";

			var configCustomImage = '';
			//var adminSkin = '';

			var fileDetails = Ext.getCmp('FILE_0').getValue();
			var fileExtension = fileDetails.substring((fileDetails.lastIndexOf('.'))+1,fileDetails.length);

			if (fileExtension.toLowerCase() != 'gif' && fileExtension.toLowerCase() != 'jpg' && fileExtension.toLowerCase() != 'jpeg' && fileExtension.toLowerCase() != 'png')
			{
				Ext.Msg.show({
					title: fileUploadMsg,
					msg: fileNotWithReqExt + ": '" +fileExt+ "'",
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			var newFileName = 'manager/tomcat/webapps/final/config/images/logoconfig' + '.' + fileExtension;

			if (isDouble == 'false')
			{
				if(!validateSingleByte(fileDetails))
				{
					Ext.Msg.show({
						title: fileUploadMsg,
						msg: fileNameNotSingleByte,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					configCustomImage = jsonData.configMgmtInterfaceJson.configCustomImage;

					Ext.getCmp('dispCaptionID').setValue('CustomLogo');
					Ext.getCmp('requestFromID').setValue('../../../admin/EgSettingsTree.jsp');
					Ext.getCmp('uploadForID').setValue('configMgmt');
					Ext.getCmp('FILE_0_dstFileID').setValue(newFileName);
					Ext.getCmp('fileExtID').setValue(fileExtension);
					Ext.getCmp('titleID').setValue('Uploading Logo Files');
					Ext.getCmp('fileUploadID').setValue(fileUpload);
					Ext.getCmp('uploadAllID').setValue('on');

					var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&requestFrom=EgConfigLogoMsg.jsp&uploadFor=configMgmt&dispCaption=CustomLogo&uploadDir="+ newFileName +"&fileExt="+fileExtension;

					var fileUploadForm = this.getFileuploadform().getForm();
					if (fileUploadForm.isValid())
					{
						fileUploadForm.submit({
							url: urlForFile,
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: fileUploadMsg,
									msg: "Request has been processed successfully",
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								configImageUploadStatus = "Uploaded";
								var selectCategory = Ext.getCmp('selectCategory').getValue();
								if (!Ext.isEmpty(selectCategory) && selectCategory != undefined )
								{
									if(selectCategory == 'all')
									{
										selectedModule = 'monSelected=enabled&repSelected=enabled&conSelected=enabled';
									}
									else
									{
										var chkModuleArr = Ext.getCmp('selectModulesGrp').getValue();
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk1 ) && chkModuleArr.selectedUIChk1 != undefined )
										{
											selectedModule = 'monSelected=enabled';
										}
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk2 ) && chkModuleArr.selectedUIChk2 != undefined )
										{
											selectedModule += '&repSelected=enabled';
										}
										if (!Ext.isEmpty(chkModuleArr.selectedUIChk3 ) && chkModuleArr.selectedUIChk3 != undefined )
										{
											selectedModule += '&conSelected=enabled';
										}
									}
								}
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								selectedModule = '';
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							}
						});
					}
				}
			});
		}
		else if (fileUploadModule == 'audibleAlert')
		{
			var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process=audiblealerts";
			//Ext.getCmp('FILE_0_dstFileID').setFieldLabel('Critical Alarm');
			//Ext.getCmp('FILE_1_dstFileID').setFieldLabel('Major Alarm');
			//Ext.getCmp('FILE_2_dstFileID').setFieldLabel('Minor Alarm');

			var audibleAlertUploadStatus = '';
			fileExt = 'wav';
			//var adminSkin = '';

			var fileDetailsCritical = Ext.getCmp('FILE_0').getValue();
			var fileExtensionCritical = fileDetailsCritical.substring((fileDetailsCritical.indexOf('.'))+1,fileDetailsCritical.length);

			var fileDetailsMajor = Ext.getCmp('FILE_1').getValue();
			var fileExtensionMajor = fileDetailsMajor.substring((fileDetailsMajor.indexOf('.'))+1,fileDetailsMajor.length);

			var fileDetailsMinor = Ext.getCmp('FILE_2').getValue();
			var fileExtensionMinor = fileDetailsMinor.substring((fileDetailsMinor.indexOf('.'))+1,fileDetailsMinor.length);

			if (fileExtensionCritical != fileExt || fileExtensionMajor != fileExt || fileExtensionMinor != fileExt)
			{
				Ext.Msg.show({
					title: fileUploadMsg,
					msg: fileNotWithReqExt + ": '" +fileExt+ "'",
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (isDouble == 'false')
			{
				if(!validateSingleByte(fileDetailsCritical) || !validateSingleByte(fileDetailsMajor) || !validateSingleByte(fileDetailsMinor))
				{
					Ext.Msg.show({
						title: fileUploadMsg,
						msg: fileNameNotSingleByte,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}

			//Ext.Ajax.request(
			//{
			//	url : url,
			//	scope:this,
			//	method : 'POST',
			//	success: function(response){
			//		var jsonText = response.responseText;
			//		var jsonData = Ext.decode(jsonText);

			//		audibleAlertUploadStatus = jsonData.audibleAlertsJson.audibleAlertUploadStatus;

					//Ext.getCmp('dispCaptionID').setValue('Critical Alarm:Major Alarm:Minor Alarm');
					//Ext.getCmp('requestFromID').setValue('../../../admin/EgSettingsTree.jsp');
					//Ext.getCmp('uploadForID').setValue('audibleAlerts');
					//Ext.getCmp('FILE_0_dstFileID').setValue('manager/tomcat/webapps/final/monitor/eg_waves/custom-high.wav');
					//Ext.getCmp('FILE_1_dstFileID').setValue('manager/tomcat/webapps/final/monitor/eg_waves/custom-medium.wav');
					//Ext.getCmp('FILE_2_dstFileID').setValue('manager/tomcat/webapps/final/monitor/eg_waves/custom-low.wav');
					////Ext.getCmp('FILE_3_dstFileID').setValue
					//Ext.getCmp('fileExtID').setValue('wav');
					//Ext.getCmp('titleID').setValue('Uploading Sound Files');
					//Ext.getCmp('fileUploadID').setValue(fileUpload);

					var urlForFile = "../servlet/com.eg.EgFileUploadForAudio?title=Uploading Sound Files&requestFrom=EgConfigLogoMsg.jsp&uploadFor=audibleAlerts&dispCaption=Critical Alarm:Major Alarm:Minor Alarm&fileExt=wav";

					var fileUploadForm = this.getFileuploadform().getForm();
					if (fileUploadForm.isValid())
					{
						Ext.getCmp('dispCaptionID').setValue('Critical Alarm:Major Alarm:Minor Alarm');
						Ext.getCmp('requestFromID').setValue('../../../admin/EgSettingsTree.jsp');
						Ext.getCmp('uploadForID').setValue('audibleAlerts');
						Ext.getCmp('FILE_0_dstFileID').setValue('manager/tomcat/webapps/final/monitor/eg_waves/custom-high.wav');
						Ext.getCmp('FILE_1_dstFileID').setValue('manager/tomcat/webapps/final/monitor/eg_waves/custom-medium.wav');
						Ext.getCmp('FILE_2_dstFileID').setValue('manager/tomcat/webapps/final/monitor/eg_waves/custom-low.wav');
						Ext.getCmp('fileExtID').setValue('wav');
						Ext.getCmp('titleID').setValue('Uploading Sound Files');
						Ext.getCmp('fileUploadID').setValue(fileUpload);

						fileUploadForm.submit({
							url: urlForFile,
							method: 'POST',
							success: function(form, action){
								var jsonText = Ext.decode(action.response.responseText);
								if(jsonText.successUpdate == 'true')
								{
									alertSoundUploadStatus = "Uploaded";
									Ext.Msg.show({
										title: fileUploadMsg,
										msg: "Request has been processed successfully",
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
								
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.getCmp('fileUpload').destroy();
								//myMask.hide();
							}
						});
					}
				//}
			//});
		}
	},

	loginImageUpdate: function()
	{
		var yesLoginlogoIdObj = Ext.getCmp('yesLoginlogoId');
		var noLoginlogoIdObj = Ext.getCmp('noLoginlogoId');
		var loginLogoAudit = Ext.getCmp('$_loginlogoID');

		var loginLogoStr = '';
		var valFlag = 'true';

		var process = 'loginscreen';

		var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;

					var loginYesStr = jsonData.loginScreenJson.loginYesStr;
					var loginNoStr = jsonData.loginScreenJson.loginNoStr;

					if (loginYesStr == 'checked')
					{
						loginLogoStr = 'Custom logo for login screen$YES';
					}

					if (loginNoStr == 'checked')
					{
						loginLogoStr = 'Custom logo for login screen$NO';
					}

					loginLogoAudit.setValue(loginLogoStr);

					Ext.getCmp('loginImageStatusID').setValue('Uploaded');
					Ext.getCmp('loginImageUploadStatusForAuditID').setValue('yes');
					Ext.getCmp('processID').setValue('loginscreen');

					if (loginImageUploadStatus == 'NotUploaded' && yesLoginlogoIdObj.getValue())
					{
						Ext.Msg.show({
							title: loginImageUpdate,
							msg: loginLogoNotUploaded,
							width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						valFlag = 'false';
					}

					var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

					Ext.Ajax.request(
					{
						url : url,
						scope:this,
						method : 'POST',
						success: function(response){
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);

							//var loginImageUploadStatus = jsonData.loginScreenJson.loginImageUploadStatus;
							Ext.getCmp('loginImageStatusID').setValue(loginImageUploadStatus);

							var loginScreenForm = this.getLoginscreen().getForm();

							if (valFlag == 'true')
							{
								if (loginScreenForm.isValid())
								{
									loginScreenForm.submit({
										url: '/final/admin/LogoMessages/data/EgconfiglogomsgJSONp.jsp?process=loginscreen',
										method: 'POST',
										success: function(form, action){
											Ext.Msg.show({
												title: loginImageUpdate,
												msg: messagesUpdated,
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
										},
										failure: function(form, action) // if result page doest not contain success:true, this method fires
										{
											Ext.Msg.show({
												title: loginImageUpdate,
												msg: messagesNotUpdated,
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
										}
									});
								}
							}
						}
					});
				}
			}
		);
	},

	monitorImageUpdate: function()
	{
		var custLogoPrefObj = Ext.getCmp('custLogoPrefID');
		var defaultLogoPrefObj = Ext.getCmp('defaultLogoPrefID');
		var noneLogoPrefObj = Ext.getCmp('noneLogoPrefID');
		var monitorLogoAudit = Ext.getCmp('$_monitorlogoID');

		var monitorLogoStr = '';
		var valFlag = 'true';

		var process = 'monitorinterface';

		var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;

					var monitorCustomImage = jsonData.monitorInterfaceJson.monitorCustomImage;

					var isCustomOption = jsonData.monitorInterfaceJson.customStr;
					var isDefaultOption = jsonData.monitorInterfaceJson.defaultStr;
					var isNoneOption = jsonData.monitorInterfaceJson.noneStr;

					if (isCustomOption == 'checked')
					{
						monitorLogoStr = 'Logo preference for monitor interface$CUSTOM';
					}

					if (isDefaultOption == 'checked')
					{
						monitorLogoStr = 'Logo preference for monitor interface$DEFAULT';
					}

					if (isNoneOption == 'checked')
					{
						monitorLogoStr = 'Logo preference for monitor interface$NONE';
					}
					monitorLogoAudit.setValue(monitorLogoStr);

					Ext.getCmp('processID').setValue('monitorinterface');

					if ((monitorImageUploadStatus == 'NotUploaded') && (custLogoPrefObj.getValue()))
					{
						Ext.Msg.show({
							title: monitorImageUpdate,
							msg: monitorLogoNotUploaded,
							width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						valFlag = 'false';
					}

					var monitorForm = this.getMonitor().getForm();

					if (valFlag == 'true')
					{
						if (monitorForm.isValid())
						{
							var params = '';
							if (!Ext.isEmpty(selectedModule) && selectedModule != undefined)
							{
								if (!Ext.isEmpty(selectedModule) && selectedModule.indexOf('&') == 0)
								{
									params = selectedModule;
								}
								else
								{
									params = '&'+selectedModule;
								}
							}
							monitorForm.submit({
								url: '/final/admin/LogoMessages/data/EgconfiglogomsgJSONp.jsp?process=monitorinterface'+params,
								method: 'POST',
								success: function(form, action){
									Ext.Msg.show({
										title: monitorImageUpdate,
										msg: messagesUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								},
								failure: function(form, action) // if result page doest not contain success:true, this method fires
								{
									Ext.Msg.show({
										title: monitorImageUpdate,
										msg: messagesNotUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								}
							});
						}
					}
				}
			}
		);
	},

	reporterImageUpdate: function()
	{
		var custLogoPrefObj = Ext.getCmp('reporterCustom');
		var defaultLogoPrefObj = Ext.getCmp('reporterDefault');
		var noneLogoPrefObj = Ext.getCmp('reporterNone');
		var reporterLogoAudit = Ext.getCmp('$_reporterlogoID');

		var reporterLogoStr = '';
		var valFlag = 'true';

		var process = 'reporterinterface';

		//discoveredComponents\app\controller
		var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;
					var reporterCustomImage = jsonData.reporterInterfaceJson.reporterCustomImage;

					var isCustomOption = jsonData.reporterInterfaceJson.repCustom;
					var isDefaultOption = jsonData.reporterInterfaceJson.repDefault;
					var isNoneOption = jsonData.reporterInterfaceJson.repNone;

					if (isCustomOption == ' checked ')
					{
						reporterLogoStr = 'Logo preference for reporter interface$CUSTOM';
					}

					if (isDefaultOption == ' checked ')
					{
						reporterLogoStr = 'Logo preference for reporter interface$DEFAULT';
					}

					if (isNoneOption == ' checked ')
					{
						reporterLogoStr = 'Logo preference for reporter interface$NONE';
					}

					reporterLogoAudit.setValue(reporterLogoStr);

					Ext.getCmp('processID').setValue('reporterinterface');

					if ((reporterImageUploadStatus == 'NotUploaded') && (custLogoPrefObj.getValue()))
					{
						Ext.Msg.show({
							title: reporterImageUpdate,
							msg: reporterLogoNotUploaded,
							width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						valFlag = 'false';
					}

					var reporterForm = this.getReporter().getForm();

					if (valFlag == 'true')
					{
						if (reporterForm.isValid())
						{
							var params = '';
							if (!Ext.isEmpty(selectedModule) && selectedModule.indexOf('&') == 0)
							{
								params = selectedModule;
							}
							else
							{
								params = '&'+selectedModule;
							}

							reporterForm.submit({
								url: '/final/admin/LogoMessages/data/EgconfiglogomsgJSONp.jsp?process=reporterinterface'+params,
								method: 'POST',
								success: function(form, action){
									Ext.Msg.show({
										title: reporterImageUpdate,
										msg: messagesUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								},
								failure: function(form, action) // if result page doest not contain success:true, this method fires
								{
									Ext.Msg.show({
										title: reporterImageUpdate,
										msg: messagesNotUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								}
							});
						}
					}
				}
			}
		);
	},

	configImageUpdate: function()
	{
		var custLogoPrefObj = Ext.getCmp('configCustom');
		var defaultLogoPrefObj = Ext.getCmp('configDefault');
		var noneLogoPrefObj = Ext.getCmp('configNone');
		var configLogoAudit = Ext.getCmp('$_configmgmtlogoID');

		var configLogoStr = '';
		//var defaultLogoStr = '';
		//var noneLogoStr = '';
		var valFlag = 'true';

		var process = 'configmanageinterface';

		var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;
					var configCustomImage = jsonData.configMgmtInterfaceJson.configCustomImage;

					var isCustomOption = jsonData.configMgmtInterfaceJson.configCustom;
					var isDefaultOption = jsonData.configMgmtInterfaceJson.configDefault;
					var isNoneOption = jsonData.configMgmtInterfaceJson.configNone;

					if (isCustomOption == ' checked ')
					{
						configLogoStr = 'Logo preference for configuration management interface$CUSTOM';
					}

					if (isDefaultOption == ' checked ')
					{
						configLogoStr = 'Logo preference for configuration management interface$DEFAULT';
					}

					if (isNoneOption == ' checked ')
					{
						configLogoStr = 'Logo preference for configuration management interface$NONE';
					}

					configLogoAudit.setValue(configLogoStr);

					Ext.getCmp('processID').setValue('configmanageinterface');

					if ((configImageUploadStatus == 'NotUploaded') && (custLogoPrefObj.getValue()))
					{
						Ext.Msg.show({
							title: configImageUpdate,
							msg: configLogoNotUploaded,
							width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						valFlag = 'false';
					}

					var configForm = this.getConfiguration().getForm();

					if (valFlag == 'true')
					{
						if (configForm.isValid())
						{
							var params = '';
							if (!Ext.isEmpty(selectedModule) && selectedModule.indexOf('&') == 0)
							{
								params = selectedModule;
							}
							else
							{
								params = '&'+selectedModule;
							}

							configForm.submit({
								url: '/final/admin/LogoMessages/data/EgconfiglogomsgJSONp.jsp?process=configmanageinterface'+params,
								method: 'POST',
								success: function(form, action){
									Ext.Msg.show({
										title: configImageUpdate,
										msg: messagesUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								},
								failure: function(form, action) // if result page doest not contain success:true, this method fires
								{
									Ext.Msg.show({
										title: configImageUpdate,
										msg: messagesNotUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								}
							});
						}
					}
				}
			}
		);
	},

	audibleAlertUpdate: function()
	{
		var custSoundPrefObj = Ext.getCmp('customSoundPref');
		var defaultSoundPrefObj = Ext.getCmp('defaultSoundPref');
		var noneSoundPrefObj = Ext.getCmp('noneSoundPref');
		var configSoundAudit = Ext.getCmp('$_customwavID');

		var alertSoundStr = '';
		//var defaultLogoStr = '';
		//var noneLogoStr = '';
		var valFlag = 'true';

		var process = 'audiblealerts';

		//discoveredComponents\app\controller
		var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;
					var isCustomOption = jsonData.audibleAlertsJson.customSelected;
					var isDefaultOption = jsonData.audibleAlertsJson.defaultSelected;
					var isNoneOption = jsonData.audibleAlertsJson.noneSelected;

					if (isCustomOption == 'checked')
					{
						alertSoundStr = 'Preference for audio alerts$CUSTOM';
					}

					if (isDefaultOption == 'checked')
					{
						alertSoundStr = 'Preference for audio alerts$DEFAULT';
					}

					if (isNoneOption == 'checked')
					{
						alertSoundStr = 'Preference for audio alerts$NONE';
					}
					configSoundAudit.setValue(alertSoundStr);

					if ((alertSoundUploadStatus == 'NotUploaded') && (custSoundPrefObj.getValue()))
					{
						Ext.Msg.show({
							title: alertUpdate,
							msg: alertSoundNotUploaded,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						valFlag = 'false';
					}

					Ext.getCmp('processID').setValue('audiblealerts');

					var audibleAlerts = this.getAudiblealerts().getForm();

					if (valFlag == 'true')
					{
						if (audibleAlerts.isValid())
						{
							audibleAlerts.submit({
								url: '/final/admin/LogoMessages/data/EgconfiglogomsgJSONp.jsp?process=audiblealerts',
								method: 'POST',
								success: function(form, action){
									Ext.Msg.show({
										title: alertUpdate,
										msg: messagesUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								},
								failure: function(form, action) // if result page doest not contain success:true, this method fires
								{
									Ext.Msg.show({
										title: alertUpdate,
										msg: messagesNotUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								}
							});
						}
					}
				}
			}
		);
	},

	messagesUpdate: function()
	{
		var logo_caption=true;
		var err_msg=true;
		var warr_msg=true;
		var mail_alert=true;

		var captionObj = Ext.getCmp('captionID');
		var msg1Obj = Ext.getCmp('msg1ID');
		var msg2Obj = Ext.getCmp('msg2ID');
		var msg3Obj = Ext.getCmp('msg3ID');
		var mailIdObj = Ext.getCmp('subscMailId');
		var footerObj = Ext.getCmp('pdffooter');

		var caption = Ext.getCmp('captionID').getValue();
		var msg1 = Ext.getCmp('msg1ID').getValue();
		var msg2 = Ext.getCmp('msg2ID').getValue();
		var msg3 = Ext.getCmp('msg3ID').getValue();
		var mailId = Ext.getCmp('subscMailId').getValue();
		var pdffooter1 = Ext.getCmp('pdffooter').getValue();

		msg2 = parent.filterEncode(msg2);
		Ext.getCmp('msg2ID').setValue(msg2);

		msg3 = parent.filterEncode(msg3);
		Ext.getCmp('msg3ID').setValue(msg3);

		var process = 'messages';

		//discoveredComponents\app\controller
		var url = "/final/admin/LogoMessages/data/EgConfigLogoMsgJSON.jsp?process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					isDouble = jsonData.isDouble;
					var prevCaptionText = jsonData.messagesJson.caption;
					var prevMsg1 = jsonData.messagesJson.mess1;
					var prevMsg2 = jsonData.messagesJson.mess2;
					var prevMsg3 = jsonData.messagesJson.mess3;
					var prevMailId = jsonData.messagesJson.mailid;
					var prevpdfFooter = jsonData.messagesJson.pdfFooter;

					var captionStr = 'Caption displayed at login$'+prevCaptionText;
					var msg1Str = 'Error message displayed upon subscription expiry$'+prevMsg1;
					var msg2Str = 'Warning message displayed prior to subscription expiry$'+prevMsg2;
					var msg3Str = 'Mail alert sent prior to subscription expiry$'+prevMsg3;
					var mailIdStr = 'Subscription manager mail ID$'+prevMailId;
					var pdfFooterStr = 'PDF footer message in Reporter module$'+prevpdfFooter;
					var process = 'messages';
					
					msg3Str = parent.filterEncode(msg3Str);
					msg2Str = parent.filterEncode(msg2Str);

					Ext.getCmp('$_captionID').setValue(captionStr);
					Ext.getCmp('$_msg1ID').setValue(msg1Str);
					Ext.getCmp('$_msg2ID').setValue(msg2Str);
					Ext.getCmp('$_msg3ID').setValue(msg3Str);
					Ext.getCmp('$_subscMailId').setValue(mailIdStr);
					Ext.getCmp('$_pdfFooterId').setValue(pdfFooterStr);
					Ext.getCmp('processID').setValue(process);

					if(isDouble == "false")
					{
						logo_caption = validateSingleByte(caption);
						err_msg = validateSingleByte(msg1);
						warr_msg = validateSingleByte(msg2);
						mail_alert = validateSingleByte(msg3);
					}
					
					if (caption.length > 130)
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: alertForMsgLength,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if(!checkspecial(caption,"`~#$%^+=\'\"\\;<>?\/"))
					{
						return false;
					}
					else if(!logo_caption)
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: captionNotAllowedInDBL,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if (Ext.isEmpty(msg1))
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: noSubscrExpiryMsg,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if(!checkspecial(msg1,"`~#$%^&*+={}\\:;<>?\/"))
					{
						//thisForm.msg1.focus();
						return false;
					}
					else if(!err_msg)
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: errorMsgNotAllowedInDBL,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if (Ext.isEmpty(msg2))
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: noSubscrExpiryMsg,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if(!warr_msg)
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: warningMsgNotAllowedInDBL,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if (Ext.isEmpty(msg3))
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: noSubscrExpiryMsg,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if(!mail_alert)
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: mailAlertNotAllowedInDBL,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					else if(!checkspecial(msg2,"`~#$%^&*+={}\\:;<>?\/"))
					{
						//thisForm.msg2.focus();
						return false;
					}
					else if(!validateEmail(mailId))
					{
						Ext.Msg.show({
							title: messagesUpdate,
							msg: notValidMailId,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}

					var messagesForm = this.getMessages().getForm();

					//if (valFlag == 'true')
					{
						if (messagesForm.isValid())
						{
							messagesForm.submit({
								url: '/final/admin/LogoMessages/data/EgconfiglogomsgJSONp.jsp?process=messages',
								method: 'POST',
								success: function(form, action){
									Ext.Msg.show({
										title: messagesUpdate,
										msg: messagesUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});

									msg2 = parent.filterDecode(msg2);
									Ext.getCmp('msg2ID').setValue(msg2);

									msg3 = parent.filterDecode(msg3);
									Ext.getCmp('msg3ID').setValue(msg3);
								},
								failure: function(form, action) // if result page doest not contain success:true, this method fires
								{
									Ext.Msg.show({
										title: messagesUpdate,
										msg: messagesNotUpdated,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								}
							});
						}
					}
				}
			}
		);
	}
});

function validateSingleByte(input)
{
	for(var i=0;i<input.length;i++)
	{
		var charValue=input.charCodeAt(i);
		if(charValue>255)
			return false;
	}
	return true;
}

function checkspecial(value,s_spl)
{
	/*if (typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else*/
	{
		obj_val = value;
	}
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			Ext.Msg.show({
				title: messagesUpdate,
				msg: specialCharInMessages,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
	}
	return true;
}




