Ext.define('LogoMessages.view.SettingList', {
	extend: 'Ext.tree.Panel',
	xtype: 'settinglist',
	id: 'logoMsgTreePanel',
	requires: [
		'LogoMessages.store.Settings'
	],
	cls:'treePanelDesign',
	title: 'Logo & Messages',
	rootVisible: false,

	//lines: true,
	useArrows: true,
	frame:true,
	margin:'10 0 10 10',
	store: 'Settings',
	listeners: {
		afterrender: function() {
			if (!Ext.isEmpty(isHKTEnable) && isHKTEnable.toLowerCase() == "true")
			{
				var logoMsgTreePanel = Ext.getCmp('logoMsgTreePanel').store;
				var rootNode = logoMsgTreePanel.getRootNode();
				var totalNodes = rootNode.childNodes;
				if (rootNode.hasChildNodes() && totalNodes.length >= 6)
				{
					var rootData = {
						expanded: true,
						children:[
							{
								text: 'Audible Alerts',
								id:'audioScrnId',
								leaf: true,
								iconCls:'iconAudibleAlerts'
							},
							{
								text: 'Messages',
								leaf: true,
								iconCls:'iconMessages'
							}
						]
					};
					Ext.getCmp('logoMsgTreePanel').setRootNode(rootData);
				}
			}
		}
	}
});



