var originalShow = Ext.window.MessageBox.prototype.show;
Ext.override(Ext.window.MessageBox,{
	minWidth : 300,
	show: function(cfg) 
	{
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}

		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;
			Ext.applyIf(cfg,{width : tmpWidth});
		}

		originalShow.apply(this, arguments);
	},

	alert: function(cfg, msg, fn, scope) 
	{
		if (Ext.isString(cfg)) 
		{
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}

			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},

	confirm: function(cfg, msg, fn, scope) 
	{
		if (Ext.isString(cfg)) 
		{
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}

			cfg = 
			{
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.override(Ext.form.field.File,{
	listeners: {
		change: function(field, value) {
			if(value.indexOf("\\")> -1)
				filename = value.substring(value.lastIndexOf("\\")+1,value.length);
			else if(value.indexOf("/")> -1)
				filename = value.substring(value.lastIndexOf("/")+1,value.length);
			else
				filename = value;
			field.setRawValue(filename);
		}
	}
});


Ext.define('LogoMessages.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	id: 'mainViewId',
	alias: 'widget.viewport',
	requires: [
		'LogoMessages.view.SettingList',
		'LogoMessages.view.LoginScreen',
		'LogoMessages.view.FileUpload',
		'LogoMessages.view.Monitor',
		'LogoMessages.view.Reporter',
		'LogoMessages.view.Configuration',
		'LogoMessages.view.AudibleAlerts',
		'LogoMessages.view.Messages',
		'utilities.OuterPanel'
	],

	initComponent: function() {

		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}

		this.items = [
			{
				//xtype: 'panel',
				//margin:10,
				layout: 'border',
				border:false,
				bodyPadding:0,
				padding:0,
				frame:false,
				items: [
					{
						region: 'west',
						xtype: 'settinglist',
						width:260,
						margin :'8 0 0 8',
						layout:{type:'vbox',align:'stretch'},
						collapsible:true,
						hideCollapseTool:true,
						scroll:false,
						autoScroll:false,
						split: true,
						collapsed:false,
						collapseMode :'mini'
					},
					{
						region: 'center',
						xtype: 'outerPanel',
						id: 'innerPanel',
						cls:'outerpanel',
						id: 'innerPanel',
						margin :'8 8 0 0',
						flex:4,
						frame:true,
						hideCollapseTool:true,
						scroll: true,
						autoScroll : true,
						layout:{type:'vbox',align:'stretch'},
						dockedItems:[
							{
								xtype:'toolbar',
								dock:'top',
								cls:'adminHeadInfoText',
								width:'100%',
								height: 25,
								padding: 3,
								layout:{pack:'center'},
								items:[
									{
										xtype: 'component',
										html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + loginScreenLogoDesc + '</center>',
									}
								]
							}
						],
						items: [
							{
								xtype: 'loginscreen',
								autoScroll:true
							}
						]
					}
				]
			}
		];

		this.callParent();
	}
});



