
Ext.define('MailAlertFilter.controller.Main',{
	extend:'Ext.app.Controller',
	requires : [
		'MailAlertFilter.view.Main',
		'MailAlertFilter.view.EgMailAlertSuppress',
		'Ext.ux.form.MultiSelectSI',
		'Ext.ux.form.ItemSelectorSI',
		'utilities.ScrollCombo',
	],
	views: ['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'egmailalertsuppress', ref:'egmailalertsuppress'}
	],
	init:function(){

		appCnt = this;
		this.buildMainData();
		this.control({

			'main':
			{
				'boxready':this.afterMainRender
			},
			'main button[id="backButton"]':
			{
				'click':this.goBack
			},
			'egmailalertsuppress combo[id="filter"]':
			{
				'select':this.popFilterDetails
			},
			'egmailalertsuppress combo[id="CompTypes"]':
			{
				'select':this.popCompTypes
			},
			'egmailalertsuppress combo[id="TestTypes"]':
			{
				'select':this.popTestTypes
			},
			'egmailalertsuppress combo[id="compTypesIn"]':
			{
				'select':this.viewByCriteria
			},
			'egmailalertsuppress combo[id="serseg"]':
			{
				'select':this.changeByServer
			},
			'egmailalertsuppress combo[id="Test"]':
			{
				'select':this.changeByTest
			},
			'egmailalertsuppress multiselectSi[id="compName"]':
			{
				'change':this.changeByComponentName
			},
			'egmailalertsuppress button[id="includeMore"]':
			{
				'click':this.assignAndAddMoreFilters
			},
			'egmailalertsuppress button[id="mailSubmit"]':
			{
				'click':this.submitUserFilterElements
			},
			'egmailalertsuppress button[id="btnViewFilters"]':
			{
				'click':this.viewFilteredElements
			},
			'egmailalertsuppress button[id="componentExpander"]':
			{
				'click':this.showComponentSelector
			},
			'egmailalertsuppress trigger[name="searchbox"]':
			{
				'change': this.egTitleSearch
			}
		});
	},
	
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			async: false,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				var isFilterControlEnabled = publicJSON.isFilterControlEnabled;
				if (isFilterControlEnabled)
				{
					mailFilterOption = publicJSON.filterControlDefaultSelection;
				}
			}
		});
	},
	setMeasureInMailMode : function(obj)
	{
		var selectedVal = obj.getValue().msgmode;
		var measure_in_mail_mode = Ext.getCmp('measure_in_mail_mode');
		var tmpData = publicJSON['mailAlertSettings']['measure_in_mail_mode'];
		var selectedMailMode = publicJSON['mailAlertSettings']['selectedMailMode'];
		measure_in_mail_mode.getStore().loadRawData(tmpData);
		if (selectedMailMode != null && selectedMailMode == "DATA")
		{
			measure_in_mail_mode.setValue(selectedMailMode);
		}
		else
		{
			measure_in_mail_mode.setValue(measure_in_mail_mode.getStore().getAt(0).get("valueField"));
		}
		if (selectedVal == "T")
		{
			measure_in_mail_mode.getStore().removeAt(2);
		}
	},
	submitUserFilterElements : function(obj)
	{
		var me = this;
		obj.setDisabled(true);

		if (mailFilterOption == "Descriptors_Only")
		{
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			me.setFilterValues("finish");

			var tmpStore = Ext.getCmp('exclude');
			var arrInc1 = new Array();
			var arrExc1 = new Array();
			var fromStore = tmpStore.fromField.store;
			var toStore = tmpStore.toField.store;

			for(var z = 0;z<fromStore.getCount();z++)
			{
				var tmpVal = fromStore.getAt(z).get("valueField");
				arrExc1.push(tmpVal);
			}

			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z).get("valueField");
				arrInc1.push(tmpVal);
			}
			if (arrExc1.length == 0 && arrInc1.length == 0)
			{
				Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
				obj.setDisabled(false);
				return;
			}

			var compNames = Ext.getCmp("compName").getValue();
			tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();

			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						Ext.Msg.show({
							title: pageIntnl82,
							msg: pageIntnl99,
							buttons: Ext.Msg.OK,
							width : 400,
							icon: 'iconInformation',
							fn : function(){
								me.showUserAddForm();
							}
						});
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		else
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			me.setFilterValues("finish");

			if (filterBy == "filterByDescriptor")
			{
				var compNames = Ext.getCmp("compName").getValue();
				tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			}
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						Ext.Msg.show({
							title: pageIntnl82,
							msg: pageIntnl99,
							buttons: Ext.Msg.OK,
							width : 400,
							icon: 'iconInformation',
							fn : function(){
								window.location.href="/final/admin/userProfile.jsp";
							}
						});
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						window.location.href="/final/admin/userProfile.jsp";
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	assignAndAddMoreFilters : function(obj)
	{
		var me = this;
		obj.setDisabled(true);

		if (mailFilterOption == "Descriptors_Only")
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			var compNames = Ext.getCmp("compName").getValue();
			tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);

			var tmpStore = Ext.getCmp('exclude');
			var arrInc1 = new Array();
			var arrExc1 = new Array();
			var fromStore = tmpStore.fromField.store;
			var toStore = tmpStore.toField.store;
			for(var z = 0;z<fromStore.getCount();z++)
			{
				var tmpVal = fromStore.getAt(z).get("valueField");
				arrExc1.push(tmpVal);
			}

			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z).get("valueField");
				arrInc1.push(tmpVal);
			}
			if (arrExc1.length == 0 && arrInc1.length == 0)
			{
				Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
				obj.setDisabled(false);
				return;
			}

			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		else
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			if(filterBy == "-1")
			{
				Ext.MessageBox.alert(pageIntnl82,pageIntnl90);
				obj.setDisabled(false);
				return;
			}

			if (filterBy == "filterByDescriptor")
			{
				var compNames = Ext.getCmp("compName").getValue();
				tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			}
			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	showResultText : function()
	{
		if (Ext.getCmp('resultCt') == null || Ext.getCmp('resultCt') == undefined)
		{
			var panelAbsolute = Ext.create('Ext.container.Container',{
				floatable : true,
				floating:true,
				id : 'resultCt',
				width : 380,
				items : [
					{
						xtype : 'component',
						padding :0,
						margin:5,
						cls : 'popupAlertUser',
						html  : '<table border="0" width="100%"><tr><td><div class="iconRight" style="margin:4px;float:left"></div><div style="margin:4px;float:left">Changes have been updated successfully.</div><div class="iconClosePopup" style="float:right;margin:4px"></div><td></tr></table>',
					}
				]
			});
			var VWidth = Ext.Element.getViewportWidth();
			panelAbsolute.showAt(VWidth-410,85);
			Ext.select('.iconClosePopup').on('click',function(){
				panelAbsolute.destroy();
			},this);

			var task = new Ext.util.DelayedTask(function(){
				panelAbsolute.destroy();
			});
			task.delay(2000);
		}
	},
	setFilterValues : function(cntValue)
	{
		var hiddenFieldsKeys = userMailJSON['hiddenFields'];
		var hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
		var tmpStore = Ext.getCmp('exclude');
		var arrInc = new Array();
		var arrExc = new Array();
		var fromStore = tmpStore.fromField.store;
		var toStore = tmpStore.toField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			arrExc.push(tmpVal);
		}

		for(var z = 0;z<toStore.getCount();z++)
		{
			var tmpVal = toStore.getAt(z).get("valueField");
			arrInc.push(tmpVal);
		}
		if(userMailJSON['excludedBoxHostVal'] && userMailJSON['excludedBoxHostVal'] != undefined)
		{
			var valueHost =userMailJSON['excludedBoxHostVal'];
			if(valueHost !=null && valueHost != "")
			{
				arrExc[arrExc.length] = valueHost;
			}
		}
		if (mailFilterOption == "Descriptors_Only")
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		else
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		hiddenFieldsContainerObj.removeAll();
		hiddenFieldsContainerObj.add(includedBoxVal);
		hiddenFieldsContainerObj.add(excludedBoxVal);
		hiddenFieldsContainerObj.add(tmpActionObj);
		//if (!Ext.isEmpty(hiddenFieldsKeys.previousExcVal))
		//{
			var tmpPrevExcValObj = {
				xtype : 'hiddenfield',
				name : 'previousExcVal',
				value : hiddenFieldsKeys.previousExcVal
			}
			hiddenFieldsContainerObj.add(tmpPrevExcValObj);
		//}
	},
	goBack : function()
	{
		window.location.href = "/final/admin/userProfile.jsp";
	},
	afterMainRender:function()
	{
		var mainObj = Ext.getCmp('main');
		var mailAlertSuppressObj = Ext.getCmp('egmailalertsuppress');
		if (reqfrom != 'navlink' && reqfrom != 'adduser')
		{
			Ext.getCmp('backButton').show();
		}

		var me = this;
		mainObj.setTitle(pageTitle4 +" '"+selectedUserID+"'");
		//if (Ext.isEmpty(mailAlertSuppressObj))
		//{
			//mainObj.removeAll();
			//mainObj.add({xtype : 'egmailalertsuppress'});

		//}
		var tmpUserID = selectedUserID;
		var url = "EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(tmpUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
		me.updateUserMailSuppressList(url);
		me.updateFilterComponents();
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		if (isComponentsAssociated)
		{
			if (mailFilterOption == "Descriptors_Only")
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').hide();
					Ext.getCmp('filterLabelID').show();
					me.showFilterDetails();
					Ext.getCmp('btnViewFilters').setText(pageIntnl97);
				}
			}
			else
			{

				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').show();
					Ext.getCmp('filterLabelID').hide();
					Ext.getCmp('btnViewFilters').setText(pageIntnl87);
				}
			}
		}
		me.initUserMailConfigs();
	},

	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			if ((key == 'previousSelectedValue' || key == 'previousVMs' || key == 'previouscomponents' || key == 'previoussegments' || key == 'previousservicegroup' || key == 'previousservices' || key == 'previouszones' || key == 'previousExcVal') && !Ext.isEmpty(key))
			{
				continue;
			}

			if (key == "vsTypes")
			{
				continue;
			}
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},

	updateFilterComponents : function()
	{
		var me = this;
		var elementFilteringTabObj = Ext.getCmp('main');
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		if (isComponentsAssociated == true)
		{
			var egmailalertsuppressObj = Ext.getCmp('egmailalertsuppress');
			if (egmailalertsuppressObj == null || egmailalertsuppressObj == 'undefined' || egmailalertsuppressObj == undefined)
			{
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({xtype : 'egmailalertsuppress'});
			}
			Ext.getCmp('filterUserID').setValue(selectedUserID);
		}
		else
		{
			var tmpUserID = userMailJSON['userID'];
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'panel',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	setLangEntries : function(landEntriesJson)
	{
		for (var key in landEntriesJson)
		{
			var tmpObj = Ext.getCmp(key);
			if (tmpObj ==  null || tmpObj == 'undefined')
			{
				continue;
			}
			if (tmpObj.getXType() == "checkboxfield" || tmpObj.getXType() == "radiofield")
			{
				if (tmpObj.boxLabelEl == null || tmpObj.boxLabelEl == undefined || tmpObj.boxLabelEl == 'undefined')
				{
					continue;
				}
				tmpObj.boxLabelEl.update(landEntriesJson[key]);
			}
			else
			{
				tmpObj.setFieldLabel(landEntriesJson[key]);
			}
		}
	},
	initUserMailConfigs : function()
	{
		var me = this;
		var queryStatus = userMailJSON.requestStatus;
		if (queryStatus == "success")
		{
			var tmpUserID = selectedUserID;
			this.setLangEntries(userMailJSON.langEntries);
			var filters = userMailJSON.filters;
			var isComponentsAssociated = userMailJSON.isComponentsAssociated;
			if (isComponentsAssociated == true)
			{
				var associateObj = Ext.getCmp('filter');
				associateObj.getStore().loadRawData(filters);
				associateObj.setValue("-1");
				Ext.getCmp('CompTypes').hide();
				var tmpStore = Ext.getCmp('exclude');
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
			}
			else
			{
				var elementFilteringTabObj = Ext.getCmp('main');
				var tmpUserID = selectedUserID;
				var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({
					xtype : 'component',
					border : false,
					padding:160,
					style:{'text-align':'center'},
					html:message
				});
			}
		}
		else
		{
			var elementFilteringTabObj = Ext.getCmp('main');
			var message = me.getErrorMessageTemplate(userMailJSON.errors);
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'component',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var tmpTable = '<div class="x-table"><table cellspacing="0" width="100%" cellpadding="5" border="0" align="center" class="x-grid-table" style="border:1px solid #c3c3c3"><thead><tr class="x-grid-row"><th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">Error</div></td></tr></thead>'
		for (var key in tmpObj)
		{
			if (key == "title") continue ;
			var errorMessage = tmpObj[key];
			tmpTable = tmpTable + '<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
		}
		tmpTable = tmpTable + '</table></div>';
		return tmpTable;
	},
	updateFilterResultPanel : function()
	{
				var me = this;
		var userFilterContainerObj = Ext.getCmp('userFilterContainer');
		var filters = userMailJSON.filters;
		userFilterContainerObj.removeAll();
		if (userMailJSON['isFiltersAvailable'] != null && userMailJSON['isFiltersAvailable'] != undefined && userMailJSON['isFiltersAvailable'] == true)
		{
			var excludedElements = userMailJSON.excludedElements;
			var gridHeaderMapping = userMailJSON.gridHeaderMapping;
			for (var key in excludedElements)
			{
				var gridObj = excludedElements[key];
				if (key == "excludedComponents" || key == "allExcludedLayersByType" || key == "exculdedTestsForAllTypes" || key == "exculdedDescriptor")
				{
					var gridTitle = gridHeaderMapping[key];
					if (gridObj == "" || gridObj.length == 0)
					{
						continue;
					}
					var tmpPanel = {
						xtype : 'panel',
						cls : 'outerpanel',
						border : false,
						width : '95%',
						title : gridTitle,
						html : gridObj
					}
					userFilterContainerObj.add(tmpPanel);
				}
				else
				{
					var gridTitle = gridHeaderMapping[key];
					if (Ext.isEmpty(gridObj))
					{
						continue;
					}
					var tmpResult = me.getGridPanel(gridObj,gridTitle);
					userFilterContainerObj.add(tmpResult);
				}
			}
			userFilterContainerObj.doLayout();
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No elements are excluded for this user</b></div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				html : message
			}
			userFilterContainerObj.add(tmpPanel);
		}
		Ext.getCmp('userFilterWindow').doLayout();
	},
	updateHTMLFilterResultPanel : function(urlStr)
	{
		var me = this;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var userFilterContainerObj = Ext.getCmp('userFilterContainer');
				userFilterContainerObj.update(jsonText);
				Ext.getCmp('userFilterWindow').doLayout();
				delete jsonText;
				delete userFilterContainerObj;
			}
		});
	},
	updateDescriptorHTMLFiltePanel : function(urlStr)
	{
		var me = this;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var userFilterContainerObj = Ext.getCmp('userFilterContainer');
				userFilterContainerObj.update(jsonText);
				Ext.getCmp('userFilterWindow').doLayout();
				delete jsonText;
				delete userFilterContainerObj;
			}
		});
	},
	updateFilterResultPanel2 : function()
	{
		var me = this;
		var userFilterContainerObj = Ext.getCmp('userFilterContainer');
		var filters = userMailJSON.filters;
		userFilterContainerObj.removeAll();
		if (userMailJSON['isFiltersAvailable'] != null && userMailJSON['isFiltersAvailable'] != undefined && userMailJSON['isFiltersAvailable'] == true)
		{
			var excludedElements = userMailJSON.excludedElements;
			var gridHeaderMapping = userMailJSON.gridHeaderMapping;
			for (var key in excludedElements)
			{
				var gridObj = excludedElements[key];
				if (key == "exculdedDescriptor")
				{
					var gridTitle = gridHeaderMapping[key];
					if (gridObj == "" || gridObj.length == 0)
					{
						continue;
					}
					var tmpPanel = {
						xtype : 'panel',
						cls : 'outerpanel',
						border : false,
						width : '95%',
						title : gridTitle,
						html : gridObj
					}
					userFilterContainerObj.add(tmpPanel);
				}
			}
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No elements are included for this user</b></div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				html : message
			}
			userFilterContainerObj.add(tmpPanel);
		}
		Ext.getCmp('userFilterWindow').doLayout();
	},
	getGridPanel : function(gridArray,gridTitle)
	{
		var fieldstoStore =  new Array();
		fieldstoStore.push("compType_1");
		fieldstoStore.push("compType_2");
		fieldstoStore.push("compType_3");
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		for (var key in fieldstoStore)
		{
			var gridColumn = fieldstoStore[key];
			mainColumnsObjArray.push({
				header: gridColumn,
				dataIndex: gridColumn,
				align:'left',
				flex:1
			});
		}
		var gridpanel = Ext.widget('usergridpanel',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:false,
			cls:'gridSkin',
			title : gridTitle,
			width : '95%',
			columns:mainColumnsObjArray,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			sortable: false,
			hideable: false,
			hideHeaders : true
		});
		return gridpanel;
	},
	showComponentSelector : function()
	{
		var me = this;
		if (Ext.getCmp('componentWinSelector') == undefined)
		{
			var cloneStore = Ext.getCmp('compName').getStore();
			var expandWindow = Ext.create('Ext.window.Window',{
					title:'Components',
					id : 'componentWinSelector',
					//width:650,
					//height:370,
					doClose: function() {
						this.destroy();
					},
					buttonAlign:'center',
					items:[
						{
							xype:'container',
							cls:'multisearchlist',
							width: 580,
							layout : {
								type : 'hbox',
								pack : 'center'
							},
							margin : '5 5 0 5',
							items:[
							{
								xtype: 'trigger',
								name:'componentSearch',
								id:'componentSearch',
								trigger1Cls: 'x-form-clear-trigger',
								trigger2Cls: 'x-form-search-trigger', 
								cls: 'whitedropdown_search',
								emptyText:'Search',
								margin: '5 5 5 5',
								labelAlign: 'top',
								width: 400,
								getTriggerMarkup: function() {
									var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

									// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
									// single triggerCls config. Should rethink this, perhaps something more structured like a list of
									// trigger config objects that hold cls, handler, etc.
									// triggerCls is a synonym for trigger1Cls, so copy it.
									if (!me.trigger1Cls) {
										me.trigger1Cls = me.triggerCls;
									}

									// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
									for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

										if (i == 0)
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style + "display:none;",
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
										else
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style,
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
									}
									triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

									return Ext.DomHelper.markup(triggerConfigs);
								},
								onTrigger1Click : function() { 
									this.reset(); 
								},
								onTriggerClick: function()
								{
									me.egTitleSearch(this.getValue());
								},
								listeners : {
									specialkey: function(field, e)
									{
										// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN, // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN 
										if(e.getKey() == e.ENTER) 
										{ 
											me.egTitleSearch(field.getValue());
										}
									}
								}
							}]
						},
						{
							xtype: 'multiselectfieldSi',
							margin : '0 5 5 5',
							autoScroll:true,
							scroll:true,
							name: 'multiselect',
							id: 'componentClonedID',
							store: cloneStore,
							value: Ext.getCmp('compName').getValue(),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							width: 580,
							height:230
						}
					],
					buttons:[
						{
							text:'Select',
							id: 'expand',
							cls:'button20',
							name: 'expand',
							handler: function()
							{
								if (Ext.getCmp('componentClonedID').getValue() != '' )
								{
									var selectedList = Ext.getCmp('componentClonedID').getValue();
									Ext.getCmp('compName').setValue(selectedList);
									expandWindow.destroy();
								}
							}
						}
					]
			}).show();
		}
	},
	egTitleSearch : function(id)
	{
		var value = id.value;
		var cloneStore = Ext.getCmp('compName').getStore();
		var clonedStore = compNameArrTemp;
		var compNameObj = Ext.getCmp('compName');
		var excludeItemObj = Ext.getCmp('exclude');
		excludeItemObj.getStore().removeAll();
		if(excludeItemObj.fromField.store.getCount() > 0)
		{
			excludeItemObj.fromField.store.removeAll();
		}
		if(excludeItemObj.toField.store.getCount() > 0)
		{
			excludeItemObj.toField.store.removeAll();
		}

		if (Ext.isEmpty(value))
		{
			Ext.get('MyTrigger_searchbox_0').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_1').setStyle('display','block');
			//compNameObj.getStore().clearFilter(true);
			compNameObj.getStore().loadRawData(compNameArrTemp);
		}
		else
		{
			Ext.get('MyTrigger_searchbox_1').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_0').setStyle('display','block');
			//clonedStore.filter('displayField',value);
			var compNameObj = Ext.getCmp('compName');
			var findVal = value;
			var isRecordFound = false;
			//var genStore = new Ext.data.Store({
			//						fields : ['displayField','valueField'],
			//						data : []                                
			//					});
			var genStoreArr = new Array();
			for ( var i = 0; i < clonedStore.length ; i++ )
			{
				var getRecord = clonedStore[i]['displayField'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStoreArr.push({
						'displayField': clonedStore[i]['displayField'],
						'valueField': clonedStore[i]['valueField'],
					});
				}
			}

			compNameObj.getStore().removeAll();    
			if ( isRecordFound )
			{
				compNameObj.getStore().loadRawData(genStoreArr);
				//for ( var i = 0; i < genStore.getCount() ; i++ )
				//{
					//var getRecord = genStore.getAt(i);
					//compNameObj.getStore().add(getRecord);
				//}
			}
			else
			{
				compNameObj.store.loadData({
						'displayField': 'No data found',
						'valueField': '-1',
					},true);
			}
			Ext.getCmp('searchbox').focus();
		}
	},
	popFilterDetails : function(obj)
	{
		var me = this;
		var page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
		var selectedOption = obj.getValue();
		if(selectedOption != "-1")
		{
			page = page+"&filterBy="+selectedOption;
			if(selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
			{
				page = page + "&serverType=-1";
			}
			else if(selectedOption == "filterByLayer" || selectedOption == "filterByTest")
			{
				page = page + "&serverType=filterByAll";
			}
			page = page + "&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.getStore().loadRawData(excludedItems);
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					var compTypeContainer = Ext.getCmp('CompTypes');
					var compTypesInCt = Ext.getCmp('compTypesIn');
					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					compTypeContainer.hide();
					compTypesInCt.hide();
					serverTestsOuterCt.hide();
					Ext.getCmp('serseg').hide();
					if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
						selectedOption == "filterByDescriptor")
					{
						var tmpCompObj = Ext.getCmp('CompTypes');
						var compopnentTypes = userMailJSON['compopnentTypes'];
						tmpCompObj.getStore().loadRawData(compopnentTypes);
						if (selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
						{
							tmpCompObj.setValue("-1");
						}
						else
						{
							tmpCompObj.setValue("filterByAll");
						}
						if (userMailJSON.isOtherGroupsFound)
						{
							compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
							compTypesInCt.setValue(userMailJSON.displayText);
							compTypesInCt.show();
							if (compTypesInCt.getValue() != 'cType')
							{
								Ext.getCmp('serseg').show();
							}
						}
						else
						{
							compTypesInCt.hide();
						}

						compTypeContainer.show();
						if (selectedOption == "filterByDescriptor")
						{
							var testObj = Ext.getCmp('Test');
							Ext.getCmp('compName').getStore().removeAll();
							serverTestsOuterCt.show();
							Ext.getCmp('searchbox').setDisabled(true);
							Ext.getCmp('searchbox').setValue('');
							testObj.show();
							testObj.getStore().removeAll();
							testObj.getStore().loadRawData(userMailJSON.testArray);
							testObj.setValue("-1");
						}
					}
					var testTypeObj = Ext.getCmp('TestTypes');
					if(isConfigEnabled == "true")
					{
						if(selectedOption == "filterByTest")
						{
							testTypeObj.show();
							testTypeObj.getStore().removeAll();
							testTypeObj.getStore().loadRawData(userMailJSON.testTypesArr);
							testTypeObj.setValue("performance");
						}
						else
						{
							testTypeObj.hide();
						}
					}
					else
					{
						testTypeObj.hide();
					}
					tmpStore.fromField.getComponent(0).setTitle(userMailJSON['itemTitle1']);
					tmpStore.toField.getComponent(0).setTitle(userMailJSON['itemTitle2']);
				}
			});
		}
		else
		{
			Ext.suspendLayouts();
			var tmpStore = Ext.getCmp('exclude');
			tmpStore.fromField.getComponent(0).setTitle("Excluded from alerts");
			tmpStore.toField.getComponent(0).setTitle("Included for alerts");
			Ext.getCmp('CompTypes').hide();
			Ext.getCmp('compTypesIn').hide();
			Ext.getCmp('serseg').hide();
			Ext.getCmp('serverTestsOuterCt').hide();
			Ext.resumeLayouts(true);
		}
	},
	showFilterDetails : function(obj)
	{
		var me = this;
		var page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&filterBy=filterByDescriptor&reqfrom="+reqFrom;

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				var includedItems = userMailJSON['includedAlerts'];
				var excludedItems = userMailJSON['excludedAlerts'];
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(excludedItems))
				{
					tmpStore.fromField.store.add(excludedItems);
				}
				if (!Ext.isEmpty(includedItems))
				{
					tmpStore.toField.store.add(includedItems);
				}
				var compTypeContainer = Ext.getCmp('CompTypes');
				var compTypesInCt = Ext.getCmp('compTypesIn');
				var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
				compTypeContainer.hide();
				compTypesInCt.hide();
				serverTestsOuterCt.hide();
				Ext.getCmp('serseg').hide();
				//if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
				//	selectedOption == "filterByDescriptor")
				{
					var tmpCompObj = Ext.getCmp('CompTypes');
					var compopnentTypes = userMailJSON['compopnentTypes'];
					tmpCompObj.getStore().loadRawData(compopnentTypes);
					tmpCompObj.setValue("-1");
					if (userMailJSON.isOtherGroupsFound)
					{
						compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
						compTypesInCt.setValue(userMailJSON.displayText);
						compTypesInCt.show();
						if (compTypesInCt.getValue() != 'cType')
						{
							Ext.getCmp('serseg').show();
						}
					}
					else
					{
						compTypesInCt.hide();
					}

					compTypeContainer.show();
					var testObj = Ext.getCmp('Test');
					Ext.getCmp('compName').getStore().removeAll();
					serverTestsOuterCt.show();
					testObj.show();
					testObj.getStore().removeAll();
					testObj.getStore().loadRawData(userMailJSON.testArray);
					testObj.setValue("-1");
				}
			}
		});
	},
	viewByCriteria : function(obj)
	{
		var viewByValue = obj.getValue();
		var filterObj = Ext.getCmp("filter");
		var filterBy = filterObj.getValue();
		var sersegObj = Ext.getCmp('serseg');
		var testCombo = Ext.getCmp('Test');
		var compTypes = Ext.getCmp('CompTypes');
		var page = "";
		var me = this;
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="2:31 EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}

					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}

					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}
					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	changeByServer : function(obj)
	{
		var viewByServer = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var CompTypesObj = Ext.getCmp('CompTypes');
		var testCombo = Ext.getCmp('Test');
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				CompTypesObj.getStore().loadRawData(userMailJSON.compopnentTypes);
				if(viewByServer == "-1")
				{
					CompTypesObj.getStore().removeAll();
					CompTypesObj.getStore().loadData([
						{
							'displayField' : 'Not Applicable',
							'valueField' : '-1'
						}
					]);
				}
				testCombo.getStore().removeAll();
				testCombo.getStore().loadData([
					{
						'displayField' : 'Not Applicable',
						'valueField' : '-1'
					}
				]);
				Ext.getCmp('compName').getStore().removeAll();
				Ext.getCmp('searchbox').setDisabled(true);
				Ext.getCmp('searchbox').setValue('');
				if(CompTypesObj.getStore().getCount() > 0)
				{
					CompTypesObj.setValue(CompTypesObj.getStore().getAt(0));
				}
				if(testCombo.getStore().getCount() > 0)
				{
					testCombo.setValue(testCombo.getStore().getAt(0));
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByTest : function(obj)
	{
		var viewByTest = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		
		if (!Ext.isEmpty(viewByTest) && viewByTest == '-1')
		{
			Ext.getCmp('searchbox').setDisabled(true);
			Ext.getCmp('searchbox').setValue('');
		}
		else
		{
			Ext.getCmp('searchbox').setDisabled(false);
			Ext.getCmp('searchbox').setValue('');
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				var compNameObj = Ext.getCmp('compName');
				compNameObj.getStore().loadRawData(userMailJSON.compNameArr);
				compNameArrTemp = userMailJSON.compNameArr;
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByComponentName : function(obj)
	{
		var compNames = obj.getValue();
		if(compNames == "" || compNames == "-1")
		{
			var excludeItemObj = Ext.getCmp('exclude');
			excludeItemObj.getStore().removeAll();
			if(excludeItemObj.fromField.store.getCount() > 0)
			{
				excludeItemObj.fromField.store.removeAll();
			}
			if(excludeItemObj.toField.store.getCount() > 0)
			{
				excludeItemObj.toField.store.removeAll();
			}
			return;
		}
		var filterBy = Ext.getCmp('filter').getValue();
		var Test = Ext.getCmp('Test').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var compTypesInObj = Ext.getCmp('compTypesIn');

		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(includedItems))
					{
						//tmpStore.fromField.store.add(excludedItems);
						tmpStore.fromField.store.add(includedItems);
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.toField.store.add(includedItems);
						tmpStore.toField.store.add(excludedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	popCompTypes : function(obj)
	{
		var tmpUserID = publicJSON.userID;
		var filterBy = Ext.getCmp('filter').getValue();
		var serverType = obj.getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy=filterByDescriptor&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//if (filterBy == "filterByDescriptor")
					{
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');

						testCt.getStore().removeAll();
						Ext.getCmp('compName').getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime();

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//var serverTestsCt = Ext.getCmp('serverTestsCt');
					if (filterBy == "filterByDescriptor")
					{
						testCt.getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
						serverTestsOuterCt.show();
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
						testCt.show();
						//serverTestsCt.hide();
					}
					else
					{
						serverTestsOuterCt.hide();
						testCt.hide();
						//serverTestsCt.hide();
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	popTestTypes : function(obj)
	{
		updateSettings = false;
		var tmpUserID = Ext.getCmp('uname').getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var testType = obj.getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();		
		var configTestType = "no";
		if(testType == "configuration")
		{
			configTestType = "yes";
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&serverType="+encodeURIComponent(compTypes)+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&date="+new Date().getTime();
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				var includedItems = userMailJSON['includedAlerts'];
				var excludedItems = userMailJSON['excludedAlerts'];
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(excludedItems))
				{
					tmpStore.fromField.store.add(excludedItems);
				}
				if (!Ext.isEmpty(includedItems))
				{
					tmpStore.toField.store.add(includedItems);
				}
				var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
				var testCt = Ext.getCmp('Test');
				if (filterBy == "filterByDescriptor")
				{
					testCt.getStore().removeAll();
					testCt.getStore().loadRawData(userMailJSON.testArray);
					testCt.setValue(userMailJSON.selectedDescriptorText);
					serverTestsOuterCt.show();
					Ext.getCmp('compName').getStore().removeAll();
					Ext.getCmp('searchbox').setDisabled(true);
					Ext.getCmp('searchbox').setValue('');
					testCt.show();
				}
				else
				{
					serverTestsOuterCt.hide();
					testCt.hide();
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	updateResultPanel : function()
	{
		var isElementsAssociated = userElementJSON.isElementsAssociated;
		var userAssociationContainer = Ext.getCmp('userAssociationContainer');
		var elementassociationcontainer = Ext.getCmp('elementassociationcontainer');
		userAssociationContainer.removeAll();
		if (isElementsAssociated == true)
		{
			
			userAssociationContainer.add(
				{
				xtype : 'componentgroupedsummarygrid',
				store: new Ext.data.Store({
					fields: ['col_1', 'category','col_2','col_3'],
					groupField: 'category',
					data: userElementJSON.userTableData,
				})
			});
			userAssociationContainer.doLayout();
			Ext.getCmp('Expand').show();
		}
		else
		{
			Ext.getCmp('Expand').hide();
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>"+intnlLabel5+".</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			userAssociationContainer.add(tmpPanel);
		}
	},
	updateUserMailSuppressList : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userMailJSON = Ext.decode(jsonText);
			}
		});
	},
	viewFilteredElements : function()
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			id:'userFilterWindow',
			width: '95%',
			height: 450,
			border : false,
			modal : true,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					if (mailFilterOption == "Descriptors_Only")
					{
						var title = filterMessage2 + ": "+selectedUserID;
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "EgChangeUserProfile/data/EgMailAlertIncludeSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						me.updateDescriptorHTMLFiltePanel(url);
					}
					else
					{
						var title = filterMessage + ": "+selectedUserID;
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "EgChangeUserProfile/data/EgMailAlertSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						me.updateHTMLFilterResultPanel(url);
					}
				}
			},
			items:[
				{
					xtype: 'container',
					id: 'userFilterContainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					defaults: {
						margin : 8
					}
				}
			]
		}).show();
	}
});





