Ext.define('MailAlertSettings.controller.MailAlertPreferCtrl',{
	extend: 'Ext.app.Controller',

	view: ['MailAlertPreference'],

	refs: [
		{
			selector: 'mailalertpreference',
			ref: 'mailalertpreference'
		},
	],

	init: function(){
		this.control({
			'mailalertpreference': {
				'afterrender' : this.afterMainRender
			}
		});
	},

	afterMainRender : function() {
		Ext.getCmp('homepageurl').setValue(publicJSON['mailHomeUrl']);
		Ext.getCmp('maxtimealert').setValue(publicJSON['mailCheckPeriod']);

		var editMailId = publicJSON['editMailId'];
		if (editMailId == 'No')
		{
			Ext.getCmp('allowmonuserno').setValue(true);
		}
		else
		{
			Ext.getCmp('allowmonuseryes').setValue(true);
		}

		var alertAgentsNotRunning = publicJSON['alertAgentsNotRunning'];
		if (alertAgentsNotRunning == 'No')
		{
			Ext.getCmp('alertagentrunno').setValue(true);
		}
		else
		{
			Ext.getCmp('alertagentrunyes').setValue(true);
		}

		var mailLastValue = publicJSON['mailLastValue'];
		if (mailLastValue == 'No')
		{
			Ext.getCmp('showlastmeasureno').setValue(true);
		}
		else
		{
			Ext.getCmp('showlastmeasureyes').setValue(true);
		}

		var stopEsconAckMail = publicJSON['stopEsconAckMail'];
		if (stopEsconAckMail == 'No')
		{
			Ext.getCmp('stopEsconAckMailNo').setValue(true);
		}
		else
		{
			Ext.getCmp('stopEsconAckMailYes').setValue(true);
		}

		var mailSubFormat = publicJSON['mailSubjectFormatToUse'];  
		if (mailSubFormat == 'DefinedFormat')
		{
			Ext.getCmp('mailsubformatno').setValue(true);
			Ext.getCmp('mailsubject').hide();
			Ext.getCmp('calarmidcontent').hide();
			Ext.getCmp('cprioritycontent').hide();
			Ext.getCmp('startmailsubject').show();
			Ext.getCmp('startmailsubject').setValue(publicJSON['mailSubjectStart']);
			Ext.getCmp('servicescontent').show()
			Ext.getCmp('servicescontent').setValue(publicJSON['mailSubject_SV']);
			Ext.getCmp('cmpnamecontent').show()
			Ext.getCmp('cmpnamecontent').setValue(publicJSON['mailSubject_CN']);
			Ext.getCmp('cmptypecontent').show()
			Ext.getCmp('cmptypecontent').setValue(publicJSON['mailSubject_CT']);
			Ext.getCmp('layercontent').show()
			Ext.getCmp('layercontent').setValue(publicJSON['mailSubject_LY']);
			Ext.getCmp('testcontent').show()
			Ext.getCmp('descriptioncontent').show()
			Ext.getCmp('prioritycontent').show()
			Ext.getCmp('prioritycontent').setValue(publicJSON['mailSubject_PT']);
			Ext.getCmp('alarmidcontent').show()
			Ext.getCmp('alarmidcontent').setValue(publicJSON['mailSubject_AID']);
			Ext.getCmp('maxCmp').show();
			Ext.getCmp('maxCmp').setValue(publicJSON['mailSubjectLength']);

			var showLastMeasure = Ext.getCmp('showlastmeasureyes').getValue();
			var descriptive = Ext.getCmp('mailsubformatno').getValue();

			/*if (mailLastValue == 'Yes')
			{
				//Ext.getCmp('testcontent').setValue(true).disable();
				//Ext.getCmp('descriptioncontent').setValue(true).disable();
				//Ext.getCmp('lastmeasurecontent').show();
				//Ext.getCmp('lastmeasurecontent').hide();
				//Ext.getCmp('lastmeasurecontent').setValue(true).disable();
			}
			else
			{
				Ext.getCmp('testcontent').setValue(publicJSON['mailSubject_TN']).enable();
				Ext.getCmp('descriptioncontent').setValue(publicJSON['mailSubject_DC']).enable();
				//Ext.getCmp('lastmeasurecontent').hide();
			}*/
			Ext.getCmp('lastmeasurecontent').setValue(publicJSON['mailSubject_LM']).enable();
			Ext.getCmp('testcontent').setValue(publicJSON['mailSubject_TN']).enable();
			Ext.getCmp('descriptioncontent').setValue(publicJSON['mailSubject_DC']).enable();

			if(MailDefaultTestEnableWhenDescSelect)
			{
				if(Ext.getCmp('lastmeasurecontent').getValue() == true){
					Ext.getCmp('testcontent').disable();
					Ext.getCmp('descriptioncontent').disable();
				}
			}
		}
		else
		{
			Ext.getCmp('mailsubformatyes').setValue(true);
			Ext.getCmp('mailsubject').show();
			Ext.getCmp('mailsubject').setValue(publicJSON['strmSub']);
			Ext.getCmp('startmailsubject').hide();
			Ext.getCmp('calarmidcontent').show();
			Ext.getCmp('cprioritycontent').show();
			Ext.getCmp('servicescontent').hide();
			Ext.getCmp('cmpnamecontent').hide();
			Ext.getCmp('cmptypecontent').hide();
			Ext.getCmp('layercontent').hide();
			Ext.getCmp('testcontent').hide();
			Ext.getCmp('descriptioncontent').hide();
			Ext.getCmp('prioritycontent').hide();
			Ext.getCmp('alarmidcontent').hide();
			Ext.getCmp('cprioritycontent').setValue(publicJSON['mailSubject_CPT']);
			Ext.getCmp('calarmidcontent').setValue(publicJSON['mailSubject_CAID']);
			Ext.getCmp('maxCmp').hide();
		}
		Ext.getCmp('servicesmail').setValue(publicJSON['mail5']);
		//Ext.getCmp('cmpnamemail').setValue(publicJSON['mail1']);
		//Ext.getCmp('cmptypemail').setValue(publicJSON['mail2']);
		Ext.getCmp('layermail').setValue(publicJSON['mail3']);
		Ext.getCmp('alarmIdMail').setValue(publicJSON['mail9']);

		if (mailLastValue == 'Yes')
		{
			Ext.getCmp('testmail').setValue(true).disable();
			Ext.getCmp('descriptionmail').setValue(true).disable();
			//Ext.getCmp('lastmeasuremail').show();
			Ext.getCmp('lastmeasuremail').hide();
			Ext.getCmp('lastmeasuremail').setValue(true).disable();
		}
		else
		{
			Ext.getCmp('testmail').setValue(publicJSON['mail6']).enable();
			Ext.getCmp('descriptionmail').setValue(publicJSON['mail4']).enable();
			Ext.getCmp('lastmeasuremail').hide();
		}
		//Ext.getCmp('measurementhost').setValue(publicJSON['mail8']);
		
		var separateMail = publicJSON['strmailseparate'];
		if (separateMail == 'true')
		{
			Ext.getCmp('sepmailalertyes').setValue(true);
		}
		else
		{
			Ext.getCmp('sepmailalertno').setValue(true);
		}

		var mailAsAttachment = publicJSON['mailAsAttachment'];
		if (mailAsAttachment == 'true')
		{
			Ext.getCmp('sendalertattachmentyes').setValue(true);
		}
		else
		{
			Ext.getCmp('sendalertattachmentno').setValue(true);
		}

		var normalMail = publicJSON['normalMail'];
		if (normalMail == 'true')
		{
			Ext.getCmp('sendmailalrmclearyes').setValue(true);
		}
		else
		{
			Ext.getCmp('sendmailalrmclearno').setValue(true);
		}

		var ddMail = publicJSON['ddMail'];
		if (ddMail == 'yes')
		{
			Ext.getCmp('ddmailalertyes').setValue(true);
		}
		else
		{
			Ext.getCmp('ddmailalertno').setValue(true);
		}
 
		var isConfigSupport = publicJSON['isConfigSupported'];
		if (isConfigSupport == true)
		{
			var configChanges = publicJSON['configChangesInMail'];
			if (configChanges == 'true')
			{
				Ext.getCmp('incconfigyes').setValue(true);
			}
			else
			{
				Ext.getCmp('incconfigno').setValue(true);
			}
		}

		var smsLastValue = publicJSON['smsLastValue'];
		if (smsLastValue == 'No')
		{
			Ext.getCmp('showsmslastmeasureno').setValue(true);
		}
		else
		{
			Ext.getCmp('showsmslastmeasureyes').setValue(true);
		}

		Ext.getCmp('smssubject').setValue(publicJSON['strsSub']);

		Ext.getCmp('servicessms').setValue(publicJSON['type4']);
		Ext.getCmp('cmpnamesms').setValue(publicJSON['type1']);
		Ext.getCmp('cmptypesms').setValue(publicJSON['type2']);
		Ext.getCmp('layersms').setValue(publicJSON['type8']);
		Ext.getCmp('alarmIdsms').setValue(publicJSON['type11']);
		if (smsLastValue == 'Yes')
		{
			Ext.getCmp('testsms').setValue(true).disable();
			Ext.getCmp('descriptionsms').setValue(true).disable();
			//Ext.getCmp('lastmeasuresms').show();
			Ext.getCmp('lastmeasuresms').hide();
			Ext.getCmp('lastmeasuresms').setValue(true).disable();
		}
		else
		{
			Ext.getCmp('testsms').setValue(publicJSON['type5']).enable();
			Ext.getCmp('descriptionsms').setValue(publicJSON['type3']).enable();
			Ext.getCmp('lastmeasuresms').hide();
		}

		Ext.getCmp('measurehostsms').setValue(publicJSON['type7']);
		Ext.getCmp('prioritysms').setValue(publicJSON['type9']);
		Ext.getCmp('probtimesms').setValue(publicJSON['type10']);

		var strsmsseparate = publicJSON['strsmsseparate'];
		if (strsmsseparate == 'Yes')
		{
			Ext.getCmp('sendseparatesmsyes').setValue(true);
		}
		else
		{
			Ext.getCmp('sendseparatesmsno').setValue(true);
		}

		var hiddenObj = Ext.getCmp('hiddencontainer');
		var hiddenObjValue = publicJSON['hiddenObject'];
		for (var key in hiddenObjValue)
		{
			var hiddenTempField = {
				xtype: 'hiddenfield',
				name: key,
				value: hiddenObjValue[key],
			};
			hiddenObj.add(hiddenTempField);
		}

		if(publicJSON!=null && publicJSON.hasOwnProperty('enableWhatsAppAlert'))
		{
			var enableWhatsAppAlert = publicJSON['enableWhatsAppAlert'];
			var selectedGateWay = publicJSON['selectedGateWay'];
			var whastAppEnableObj = Ext.getCmp('whastAppEnable');
			if(enableWhatsAppAlert!=null && enableWhatsAppAlert.toLowerCase() == 'yes')
			{
				whastAppEnableObj.setValue(true);
				if(selectedGateWay!=null && selectedGateWay!='')
				{
					if (selectedGateWay == 'ChatAPI')
					{
						Ext.getCmp('chatAPIGateWay').setValue(true);
					}
					else
					{
						Ext.getCmp('whatsMateGateWay').setValue(true);
					}

				}
			}
			else
			{
				whastAppEnableObj.setValue(false);
			}

			Ext.getCmp('chatAPIurl').setValue(publicJSON['chatURL']);
			Ext.getCmp('chatAPIToken').setValue(publicJSON['chatToken']);
			Ext.getCmp('whatsMateUrl').setValue(publicJSON['whatsURL']);
			Ext.getCmp('clientSecret').setValue(publicJSON['clientSecret']);
			Ext.getCmp('clientID').setValue(publicJSON['clientID']);
			Ext.getCmp('instanceID').setValue(publicJSON['instanceID']);
			
		}
	}
});



