var licSendDatesForAudit;
var licSendMailIDForAudit;
var licvalchkForAudit;
Ext.define('MailAlertSettings.controller.Main',{
	extend:'Ext.app.Controller',

	views: ['MainPane','MailAlertPreference','SettingList','HeartBeat','AlarmEscalation','ShiftPeriods','MailLogDetails','FilterMailSms','LicenseUsageMail','ConfigMailAlertSettings'],
	requires: ['MailAlertSettings.view.MainPane','MailAlertSettings.view.SettingList'],

	refs: [
		{selector:'mainpane',ref:'mainpane'},
		{selector:'settinglist',ref:'settinglist'},
		{selector:'mailalertpreference',ref:'mailalertpreference'},
		{selector:'heartbeat',ref:'heartbeat'},
		{selector:'alarmescalation',ref:'alarmescalation'},
		{selector:'shiftperiods',ref:'shiftperiods'},
		{selector:'maillogdetails',ref:'maillogdetails'},
		{selector:'filtermailsms',ref:'filtermailsms'},
		{selector:'licenseusagemail',ref:'licenseusagemail'},
		{selector:'configmailalertsettings',ref:'configmailalertsettings'}
	],

	init: function() {
		me = this;
		this.buildFieldData()

		this.control({
			'mainpane': {
				'afterrender': this.afterMainRender
			},
			'settinglist': {
				'itemclick': this.loadServerAgentSettingsPage
			},
			//'mailalertpreference radio[id="showlastmeasureyes"]': {
				//'change' : this.radLastMeasureVal
			//},
			//'mailalertpreference radio[id="showsmslastmeasureyes"]': {
				//'change' : this.radSMSLastMeasureVal
			//},
			'mailalertpreference checkbox[id="testcontent"]': {
				'change' : this.checkContentTest
			},
			'mailalertpreference checkbox[id="descriptioncontent"]': {
				'change' : this.checkContentDesc
			},
			'mailalertpreference checkbox[id="testmail"]': {
				'change' : this.checkMailTest
			},
			'mailalertpreference checkbox[id="descriptionmail"]': {
				'change' : this.checkMailDesc
			},
			'mailalertpreference checkbox[id="testsms"]': {
				'change' : this.checkSmsTest
			},
			'mailalertpreference checkbox[id="descriptionsms"]': {
				'change' : this.checkSmsDesc
			},
			'mailalertpreference radio[id="mailsubformatyes"]': {
				'change' : this.radMailSubjectFormat
			},
			'shiftperiods radio[id="allwshiftconfigyes"]': {
				'change' : this.radShiftPeriodConfig
			},
			'maillogdetails radio[id="logmailmgryes"]': {
				'change' : this.radMailLogDetails
			},
			'filtermailsms radio[id="allowmailsmsfilteryes"]': {
				'change' : this.radFilterMail
			},
			'heartbeat textfield[id="heartbeatfreq"]': {
				'change' : this.radHeartBeatFreq
			},
			'alarmescalation textfield[id="escalarm"]': {
				'change' : this.radAlarmEsc
			},
			'alarmescalation button[id="updateEscBtn"]': {
				'click': this.updationAlmEsc
			},
			'filtermailsms button[id="updateFilterBtn"]': {
				'click': this.updationFilterSms
			},
			'heartbeat button[id="updateHBBtn"]': {
				'click': this.updationHeartBeart
			},
			'mailalertpreference button[id="updateMAPreferBtn"]': {
				'click': this.updationMAPrefer
			},
			'maillogdetails button[id="updateLogBtn"]': {
				'click': this.updationLog
			},
			'shiftperiods button[id="updateShiftBtn"]': {
				'click': this.updationShift
			},
			'licenseusagemail button[id="updateCertBtn"]': {
				'click': this.updationLicenseUsage
			},
			'configmailalertsettings radio[id="enableconfigalertyes"]':{
				'change': this.onChangeEnableCnfgAlert
			},
			'configmailalertsettings radio[id="logconfigmailmgryes"]':{
				'change': this.radConfigMailLogDetails
			},
			'configmailalertsettings button[id="configMailUpdateBtn"]':{
				'click': this.updateConfigMailAlertSettings
			},
			'mailalertpreference radiogroup[id="gateWay"]' : {
				'change' : this.changeWhatsAppGateWay
			},
		});
	},
	changeWhatsAppGateWay : function(radioObj)
	{
		var gateWayObj = radioObj.getChecked();
		var selectedGateWay = gateWayObj[0].inputValue;
		var chatAPIContainer = Ext.getCmp('chatAPIContainer');
		var whatsMateContainer = Ext.getCmp('whatsMateContainer');
		if(selectedGateWay!=null && selectedGateWay=='ChatAPI')
		{
			chatAPIContainer.show();
			whatsMateContainer.hide();
		}
		else
		{
			whatsMateContainer.show();
			chatAPIContainer.hide();
		}
	},
	LicenseUsageRender: function() 
	{
		var licenseMailValidAlert = publicJSON['licenseMailValidAlert'];
		var enableLicenseValidityChk = publicJSON['enableLicenseValidityChk'];

		if (!Ext.isEmpty(licenseMailValidAlert) && licenseMailValidAlert.toLowerCase() == 'yes')
		{
			Ext.getCmp('licensevaliditymailyes').setValue(true);
		}
		else
		{
			Ext.getCmp('licensevaliditymailno').setValue(true);
		}

		if (enableLicenseValidityChk.toLowerCase() == 'yes')
		{
			var LicenseValidityChk = publicJSON['LicenseValidityChk'];
			Ext.getCmp('licensevalchkcont').show();
			Ext.getCmp('licensevalchk').setValue(LicenseValidityChk);
		}
		else
		{
			Ext.getCmp('licensevalchkcont').hide();
			Ext.getCmp('licensevalchk').setValue('');
		}

		var certUsageAlert = publicJSON['certUsageAlert'];
		var zoneUsageAlert = publicJSON['zoneUsageAlert'];
		var detailTypeAlert = publicJSON['detailTypeAlert'];
		var licAttachmenttypeAlert =  publicJSON['SelectedAttachmentType'];
		var enableLicenseUsage = publicJSON['enableLicenseUsage'];
		var enableZoneUsage = publicJSON['enableZoneUsage'];
		if (!Ext.isEmpty(certUsageAlert) && certUsageAlert.toLowerCase() == 'yes')
		{
			Ext.getCmp('certusagemailyes').setValue(true);
		}
		else
		{
			Ext.getCmp('certusagemailno').setValue(true);
		}
		if (!Ext.isEmpty(zoneUsageAlert) && zoneUsageAlert.toLowerCase() == 'yes')
		{
			Ext.getCmp('zoneusagemailyes').setValue(true);
		}
		else
		{
			Ext.getCmp('zoneusagemailno').setValue(true);
		}
		if (!Ext.isEmpty(detailTypeAlert) && detailTypeAlert.toLowerCase() == 'concise')
		{
			Ext.getCmp('concisefieldvalue').setValue(true);
		}
		else
		{
			Ext.getCmp('detailfieldvalue').setValue(true);
		}
		if (licAttachmenttypeAlert.toLowerCase() == 'pdf')
		{
			Ext.getCmp('attachmenttype').setValue(licAttachmenttypeAlert);
		}


		var licenseSendCont = Ext.getCmp('licensesenddatescont');
		var licenseSendDates = Ext.getCmp('licensesenddates');
		var licenseSendMailid = Ext.getCmp('licensesendmailid');
		var licAttachmenttype = Ext.getCmp("attachmenttype");
		var detailtypeShow = Ext.getCmp('detailtype');

		if (enableLicenseUsage.toLowerCase() == 'yes' || enableZoneUsage.toLowerCase() == 'yes')
		{
			var enableDates = publicJSON['enableDates'];
			var enableMailID = publicJSON['enableMailID'];
			var selAttachmntType = publicJSON['SelectedAttachmentType'];
			licenseSendCont.show();
			licenseSendMailid.show();
			licAttachmenttype.show();
			detailtypeShow.show();
			licenseSendDates.setValue(enableDates);
			licenseSendMailid.setValue(enableMailID);
			licAttachmenttype.setValue(selAttachmntType);
		}
		else
		{
			licenseSendCont.hide();
			licenseSendMailid.hide();
			licAttachmenttype.hide();
			detailtypeShow.hide();
		}
	},
	loadLicenseUseData: function() {
		var licenseUseData = this;
		licenseUseData.buildFieldData('licenseusagemail');
		licenseUseData.LicenseUsageRender();
	},
	radLicenseUsageVal: function()
	{
		var licenseUsageShow = Ext.getCmp('certusagemailyes').getValue();
		var zoneUsageShow = Ext.getCmp('zoneusagemailyes').getValue();
		var detailtypeShow = Ext.getCmp('detailtype');
		var licenseSendCont = Ext.getCmp('licensesenddatescont');
		var licenseSendMailid = Ext.getCmp('licensesendmailid');
		var licAttachmenttype = Ext.getCmp("attachmenttype");
		var licAttachmenttypeVal = Ext.getCmp("attachmenttype").getValue();
		licSendDatesForAudit = publicJSON['enableDates'];
		licSendMailIDForAudit = publicJSON['enableMailID'];

		if (licenseUsageShow == true || zoneUsageShow == true)
		{
			detailtypeShow.show();
			licenseSendCont.show();
			licenseSendMailid.show();
			licAttachmenttype.show();
			if(licAttachmenttypeVal == null)
			{
				Ext.getCmp("attachmenttype").setValue("PDF");
			}
		}
		else
		{
			licenseSendCont.hide();
			licenseSendMailid.hide();
			licAttachmenttype.hide();
			detailtypeShow.hide();
		}
	},
	radLicenseValidity: function()
	{
		var showLicenseValidity = Ext.getCmp('licensevaliditymailyes').getValue();
		licvalchkForAudit = publicJSON['LicenseValidityChk'];

		if (showLicenseValidity == true)
		{
			var LicenseValidityChk = publicJSON['LicenseValidityChk'];
			Ext.getCmp('licensevalchkcont').show();
			Ext.getCmp('licensevalchk').setValue(LicenseValidityChk);
		}
		else
		{
			Ext.getCmp('licensevalchkcont').hide();
		}
	},
	updationLicenseUsage: function()
	{
		licvalchkForAudit = publicJSON['LicenseValidityChk'];
		licSendDatesForAudit = publicJSON['enableDates'];
		licSendMailIDForAudit = publicJSON['enableMailID'];
		licAttachmentTypeForAudit = publicJSON['SelectedAttachmentType'];

		var showLicenseValidity = Ext.getCmp('licensevaliditymailyes').getValue();
		var licenseUsageShow = Ext.getCmp('certusagemailyes').getValue();
		var zoneUsageShow = Ext.getCmp('zoneusagemailyes').getValue();
		var allowUpdate = true;
		if (showLicenseValidity)
		{
			var licenseValidChkDay = Ext.getCmp('licensevalchk').getValue();
			if (!checkblank(licenseValidChkDay))
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensevalchk").focus();
					}
				});
				allowUpdate = false;
				return;
			}

			var val = licenseValidChkDay;
			if (val.length >  1 && val.indexOf('.') == -1)
			{
				if(val.charAt(0) == '0' )
				{
					while (val.substr(0,1) == '0' && val.length > 1) 
					{
						val = val.substr(1,9999); 
					}
					licenseValidChkDay = val;
				}
			}

			if (!checknumber("+",licenseValidChkDay))
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: _checkInt,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensevalchk").focus();
					}
				});
				allowUpdate = false;
				return;
			}
			else if (licenseValidChkDay.indexOf(".") > -1)
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: _checkfordecimal,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensevalchk").focus();
					}
				});
				allowUpdate = false;
				return;
			}
			else if (parseInt(licenseValidChkDay) < 0)
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: enterPositiveValue,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensevalchk").focus();
					}
				});
				allowUpdate = false;
				return;
			}
			else if (parseInt(licenseValidChkDay) < 7)
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: enterValidChkDays,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensevalchk").focus();
					}
				});
				allowUpdate = false;
				return;
			}
			Ext.getCmp('licensevalchk').setValue(licenseValidChkDay);
		}
		else
		{
			Ext.getCmp('licensevalchk').setValue(licvalchkForAudit);
		}

		if (licenseUsageShow || zoneUsageShow)
		{
			var licenseSendDates = Ext.getCmp('licensesenddates').getValue();
			var licenseSendMailID = Ext.getCmp('licensesendmailid').getValue();
			if (!checkblank(licenseSendDates))
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensesenddates").focus();
					}
				});
				allowUpdate = false;
				return;
				
			}
			else if (!isNotValidDates(licenseSendDates))
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: licenseSendDatesLbl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensesenddates").focus();
					}
				});
				allowUpdate = false;
				return;
				
			}
			else if (licenseSendDates.charAt(0) == ',' || licenseSendDates.charAt(licenseSendDates.length - 1) == ',')
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: licenseSendDatesComma,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensesenddates").focus();
					}
				});
				allowUpdate = false;
				return;
				
			}
			var multipleDates = licenseSendDates.split(",");
			var realDates = '';
			for (var mul=0;mul < multipleDates.length ;mul++ )
			{
				var val = multipleDates[mul];

				if (val.length >  1 && val.indexOf('.') == -1)
				{
					if(val.charAt(0) == '0' )
					{
						while (val.substr(0,1) == '0' && val.length > 1) 
						{
							val = val.substr(1,9999); 
						}
						val = val;
					}
				}
				realDates = realDates + "," + val;

				if (parseInt(val) < 0)
				{
					Ext.Msg.show({
						title: licenseUsageAndValidity_Label,
						msg: 'please enter possitive value!',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp("licensesenddates").focus();
						}
					});
					allowUpdate = false;
					return;
				}
				else if (parseInt(val) < 1 || parseInt(val) > 31)
				{
					Ext.Msg.show({
						title: licenseUsageAndValidity_Label,
						msg: licenseSendDatesFormat,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp("licensesenddates").focus();
						}
					});
					allowUpdate = false;
					return;
				}
			}
			if (!Ext.isEmpty(realDates) && realDates.charAt(0) == ',')
			{
				realDates = realDates.substring(1);
			}
			Ext.getCmp('licensesenddates').setValue(realDates);

			if (!checkblank(licenseSendMailID))
			{
				Ext.Msg.show({
					title: licenseUsageAndValidity_Label,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp("licensesendmailid").focus();
					}
				});
				allowUpdate = false;
				return;
				
			}


			if (licenseSendMailID.length > 0)
			{
				var mailIDs = licenseSendMailID.replace("\r","").split("\n");
				for (var i=0;i<mailIDs.length && mailIDs[i] !="";i++)
				{
					var tempString = trim(mailIDs[i]);
					if (!Ext.isEmpty(tempString))
					{
						tempResult = validateEmail(tempString);
						if(tempResult == null || tempResult == undefined || tempResult == false)
						{
							Ext.Msg.show({
								title : licenseUsageAndValidity_Label,
								msg : enterValidSendToId+'.',
								icon : 'iconExclamation',
								buttons : Ext.Msg.OK,
								fn : function(btn){
									Ext.getCmp('licensesendmailid').focus(true);
								}
							});
							allowUpdate = false;
							break;
						}
						else if(!validateSingleByte(mailIDs[i]))
						{
							Ext.Msg.show({
								title : licenseUsageAndValidity_Label,
								msg : singleByte_mailIds,
								icon : 'iconExclamation',
								buttons:Ext.Msg.OK,
								fn : function(btn){
									Ext.getCmp('licensesendmailid').focus(true);
								}
							});
							allowUpdate = false;
							return;
						}
					}
				}
			}
		}
		else
		{
			Ext.getCmp('licensesenddates').setValue(licSendDatesForAudit);
			Ext.getCmp('licensesendmailid').setValue(licSendMailIDForAudit);
			Ext.getCmp('attachmenttype').setValue(licAttachmentTypeForAudit);
		}

		if (allowUpdate)
		{
			urlLink = "MailAlertSettings/data/egAlertOptionspJson.jsp?operation=licenseuse";

			var hiddenObj = Ext.getCmp('hiddencontainer');
			var hiddenFilterValue = publicJSON['hiddenLicenseUsageValidObj'];
			for (var key in hiddenFilterValue)
			{
				var hiddenTempField = {
					xtype: 'hiddenfield',
					name: key,
					value: hiddenFilterValue[key],
				};
				hiddenObj.add(hiddenTempField);
			}

			var meCert = this;
			var hiddenFilterSmsObj = Ext.getCmp('licenseusagemail').getForm();
			if (hiddenFilterSmsObj.isValid())
			{
				var myCertMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myCertMask.show();
				hiddenFilterSmsObj.submit({
					url: urlLink,
					method: 'POST',
					standardSubmit: false,
					success: function( form,action )
					{
						myCertMask.hide();
						var jsonText = action.response.responseText;
						publicJSON = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
						{
							var resultStatus = publicJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								var resultStatus = publicJSON['result'];
								Ext.MessageBox.show({
									title : licenseUsageAndValidity_Label,
									msg : resultStatus['message1'],
									icon : 'iconInformation',
									buttons : Ext.Msg.OK,
									fn : meCert.loadLicenseUseData()
								});
							}
						}
						hiddenObj.removeAll();
					},
					failure: function()
					{
						myCertMask.hide();
						hiddenObj.removeAll();
					}
				});
			}
		}
	},
	buildFieldData: function(selectedNodeId) {
		Ext.Ajax.request({
			url: 'MailAlertSettings/data/egAlertOptionsJson.jsp?selectedNode='+selectedNodeId,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	checkContentTest: function() {
		var testValue = Ext.getCmp('testcontent').getValue();
		if (testValue == false )
		{
			if(MailDefaultTestEnableWhenDescSelect)
				Ext.getCmp('descriptioncontent').setValue(false);
		}
	},

	checkMailTest: function() {
		var testMailVal = Ext.getCmp('testmail').getValue();
		if (testMailVal == false)
		{
			Ext.getCmp('descriptionmail').setValue(false);
		}
	},

	checkSmsTest: function() {
		var testSmsVal = Ext.getCmp('testsms').getValue();
		if (testSmsVal == false)
		{
			Ext.getCmp('descriptionsms').setValue(false);
		}
	},

	checkContentDesc: function() {
		var checkDesc = Ext.getCmp('descriptioncontent').getValue();
		if (checkDesc == true)
		{
			if(MailDefaultTestEnableWhenDescSelect)
				Ext.getCmp('testcontent').setValue(true);
		}
	},

	checkMailDesc: function() {
		var checkMailDesc = Ext.getCmp('descriptionmail').getValue();
		if (checkMailDesc == true)
		{
			Ext.getCmp('testmail').setValue(true);
		}
	},

	checkSmsDesc: function() {
		var checkSmsDesc = Ext.getCmp('descriptionsms').getValue();
		if (checkSmsDesc == true)
		{
			Ext.getCmp('testsms').setValue(true);
		}
	},

	radLastMeasureVal: function() {
		var showLastMeasure = Ext.getCmp('showlastmeasureyes').getValue();
		var descriptive = Ext.getCmp('mailsubformatno').getValue();

		if (showLastMeasure == true)
		{
			/*Ext.Msg.show({
				title : PageTitle,
				msg : lastMeasureAlert+" '"+showLast_Label+"' "+mailLastMeasureAlert+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});*/
			if (descriptive == true)
			{
				Ext.getCmp('testcontent').show();
				Ext.getCmp('descriptioncontent').show();
				Ext.getCmp('lastmeasurecontent').show();
				//bala
				
				if(MailDefaultTestEnableWhenDescSelect)
				{
					if(Ext.getCmp('lastmeasurecontent').getValue() == true){
						Ext.getCmp('testcontent').setValue(true).disable();
						Ext.getCmp('descriptioncontent').setValue(true).disable();
					}
				}
				////Ext.getCmp('lastmeasurecontent').setValue(true).disable();
			}
			Ext.getCmp('testmail').setValue(true).disable();
			Ext.getCmp('descriptionmail').setValue(true).disable();
			//Ext.getCmp('lastmeasuremail').show();
			Ext.getCmp('lastmeasuremail').setValue(true).disable();
			//Ext.getCmp('testsms').setValue(true).disable();
			//Ext.getCmp('descriptionsms').setValue(true).disable();
			//Ext.getCmp('lastmeasuresms').show();
			//Ext.getCmp('lastmeasuresms').setValue(true).disable();
		}
		else
		{
			if (descriptive == true)
			{	
				Ext.getCmp('lastmeasurecontent').setValue(false);
				Ext.getCmp('lastmeasurecontent').enable();
				if(MailDefaultTestEnableWhenDescSelect)
				{
					Ext.getCmp('testcontent').enable();
					Ext.getCmp('descriptioncontent').enable();
				}
			}
			Ext.getCmp('testmail').enable();
			Ext.getCmp('descriptionmail').enable();
			Ext.getCmp('lastmeasuremail').hide();
			//Ext.getCmp('testsms').enable();
			//Ext.getCmp('descriptionsms').enable();
			//Ext.getCmp('lastmeasuresms').hide();
		}

	},	
	radMailSubLastMeasureVal : function(){
		if(MailDefaultTestEnableWhenDescSelect)
		{
			var val = Ext.getCmp('lastmeasurecontent').getValue();
			if(val == true){
				Ext.getCmp('testcontent').setValue(true).disable();
				Ext.getCmp('descriptioncontent').setValue(true).disable();
			}else{
				Ext.getCmp('testcontent').enable();
				Ext.getCmp('descriptioncontent').enable();
			}
		}
	},

	radSMSLastMeasureVal : function()
	{
		var showSMSLastMeasure = Ext.getCmp('showsmslastmeasureyes').getValue();
		if (showSMSLastMeasure == true)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : lastMeasureAlert+" '"+showSMSLast_Label+"' "+smsLastMeasureAlert+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});

			Ext.getCmp('testsms').setValue(true).disable();
			Ext.getCmp('descriptionsms').setValue(true).disable();
			//Ext.getCmp('lastmeasuresms').show();
			Ext.getCmp('lastmeasuresms').setValue(true).disable();
		}
		else
		{
			Ext.getCmp('testsms').enable();
			Ext.getCmp('descriptionsms').enable();
			Ext.getCmp('lastmeasuresms').hide();
		}
	},

	radMailSubjectFormat: function() {
		var mailSubForm = Ext.getCmp('mailsubformatyes').getValue();
		if (mailSubForm == true)
		{
			Ext.getCmp('mailsubject').show();
			Ext.getCmp('startmailsubject').hide();
			Ext.getCmp('calarmidcontent').show();
			Ext.getCmp('cprioritycontent').show();
			Ext.getCmp('servicescontent').hide();
			Ext.getCmp('cmpnamecontent').hide();
			Ext.getCmp('cmptypecontent').hide();
			Ext.getCmp('layercontent').hide();
			Ext.getCmp('testcontent').hide();
			Ext.getCmp('descriptioncontent').hide();
			Ext.getCmp('lastmeasurecontent').hide();
			Ext.getCmp('prioritycontent').hide();
			Ext.getCmp('alarmidcontent').hide();
			Ext.getCmp('maxCmp').hide();
		}
		else
		{
			Ext.getCmp('mailsubject').hide();
			Ext.getCmp('startmailsubject').show();
			Ext.getCmp('calarmidcontent').hide();
			Ext.getCmp('cprioritycontent').hide();
			Ext.getCmp('servicescontent').show();
			Ext.getCmp('cmpnamecontent').show();
			Ext.getCmp('cmptypecontent').show();
			Ext.getCmp('layercontent').show();
			Ext.getCmp('lastmeasurecontent').show();

			var mailLastValue = publicJSON['mailLastValue'];
			//if (mailLastValue == 'Yes')
			//{
				//Ext.getCmp('lastmeasurecontent').show();
			//}
			var showalertyes = Ext.getCmp('showlastmeasureyes').getValue();
			if (showalertyes == true)
			{
				//Ext.getCmp('lastmeasurecontent').show();
				//Ext.getCmp('lastmeasurecontent').setValue(true).disable();
				Ext.getCmp('testcontent').show();
				//Ext.getCmp('testcontent').setValue(true).disable();
				Ext.getCmp('descriptioncontent').show();
				//Ext.getCmp('descriptioncontent').setValue(true).disable();
			}
			else
			{
				Ext.getCmp('testcontent').show();
				Ext.getCmp('descriptioncontent').show();
				Ext.getCmp('testcontent').enable();
				Ext.getCmp('descriptioncontent').enable();
				//Ext.getCmp('lastmeasurecontent').hide();
			}

			Ext.getCmp('prioritycontent').show();
			Ext.getCmp('alarmidcontent').show();
			Ext.getCmp('maxCmp').show();
			if (firstClick != null && firstClick == 'Yes')
			{
				Ext.getCmp('cmpnamecontent').setValue(true);
				Ext.getCmp('prioritycontent').setValue(true);
				firstClick = "";
			}
		}
	},

	radShiftPeriodConfig: function() {
		var isShiftPeriod = Ext.getCmp('allwshiftconfigyes').getValue();
		if (isShiftPeriod == true)
		{
			Ext.getCmp('maxnoofdayshift').show();
			var maxNoOfDays = Ext.getCmp('maxnoofdayshift').getValue();
			if (maxNoOfDays == null)
			{
				Ext.getCmp('maxnoofdayshift').setValue(publicJSON['maximumShifts']);
			}
			else
			{
				Ext.getCmp('maxnoofdayshift').setValue(maxNoOfDays);
			}
		}
		else
		{
			Ext.getCmp('maxnoofdayshift').hide();
		}
	},
		
	radMailLogDetails: function() {
		var mailLogDet = Ext.getCmp('logmailmgryes').getValue();
		if (mailLogDet == true)
		{
			Ext.getCmp('maxsizeoflog').show();
			Ext.getCmp('maxnooflog').show();
			Ext.getCmp('alarmloggeddet').show();
			var maxSize = Ext.getCmp('maxsizeoflog').getValue();
			var maxnoOfLogRoll = Ext.getCmp('maxnooflog').getValue();
			if (maxSize == null || maxSize == '')
			{
				Ext.getCmp('maxsizeoflog').setValue(publicJSON['mailLogMaxSize']);
			}
			else
			{
				Ext.getCmp('maxsizeoflog').setValue(maxSize);
			}

			if (maxnoOfLogRoll == null || maxnoOfLogRoll == '')
			{
				Ext.getCmp('maxnooflog').setValue(publicJSON['mailLogMaxRollFile']);
			}
			else
			{
				Ext.getCmp('maxnooflog').setValue(maxnoOfLogRoll);
			}
			var aListToken = publicJSON['logPreference'];
			if (aListToken != "undefined" && aListToken != "" && aListToken != undefined)
			{
				var cnameChecked = false;
				var ctypeChecked = false;
				var layerChecked = false;
				var testChecked = false;
				var descChecked = false;
				var alarmdateChecked = false;

				var aListTokenArr = aListToken.split(",");
				for (var j=0;j<aListTokenArr.length;j++ )
				{
					if (aListTokenArr[j] == 'cName')
					{
						cnameChecked = true;
					}
					if (aListTokenArr[j] == 'cType')
					{
						ctypeChecked = true;
					}
					if (aListTokenArr[j] == 'layer')
					{
						layerChecked = true;
					}
					if (aListTokenArr[j] == 'test')
					{
						testChecked = true;
					}
					if (aListTokenArr[j] == 'desc')
					{
						descChecked = true;
					}
					if (aListTokenArr[j] == 'alarmdate')
					{
						alarmdateChecked = true;
					}
				}
				if (cnameChecked)
				{
					Ext.getCmp('cmpnamealrm').setValue(true).disable();
				}
				if (ctypeChecked)
				{
					Ext.getCmp('cmptypealrm').setValue(true).disable();
				}
				if (layerChecked)
				{
					Ext.getCmp('layeralrm').setValue(true).disable();
				}
				if (testChecked)
				{
					Ext.getCmp('testalrm').setValue(true).disable();
				}
				if (descChecked)
				{
					Ext.getCmp('descriptionalrm').setValue(true);
				}
				if (alarmdateChecked)
				{
					Ext.getCmp('strtdatetimealrm').setValue(true);
				}
			}
		}
		else
		{
			Ext.getCmp('maxsizeoflog').hide();
			Ext.getCmp('maxnooflog').hide();
			Ext.getCmp('alarmloggeddet').hide();
		}
	},

	radFilterMail: function() {
		var filterMail = Ext.getCmp('allowmailsmsfilteryes').getValue();
		if (filterMail == true)
		{
			Ext.getCmp('nonadmin').show();
			var nonAdminVal = publicJSON['filterconfig_nonadmins'];
			if (nonAdminVal == 'Yes')
			{
				Ext.getCmp('nonadminupdateyes').setValue(true);
			}
			else
			{
				Ext.getCmp('nonadminupdateno').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('nonadmin').hide();
		}
	},

	radHeartBeatFreq: function() {
		var heartBeatFq = Ext.getCmp('heartbeatfreq').getValue();

		heartBeatFq = heartBeatFq*60;
		var maxTimeEAlerts = publicJSON['mailCheckPeriod'];
		if (heartBeatFq >= maxTimeEAlerts)
		{
			Ext.getCmp('sendheartbeat').show();
			Ext.getCmp('sendhbto').show();
			Ext.getCmp('modeofhb').show();

			var sendingHB = publicJSON['heartbeatAlways'];
			if (sendingHB == "True")
			{
				Ext.getCmp('sendheartbeatyes').setValue(true);
			}
			else
			{
				Ext.getCmp('sendheartbeatno').setValue(true);
			}

			var modeOfHBVal = publicJSON['heartbeatMailMode'];
			if (modeOfHBVal == "Text")
			{
				Ext.getCmp('modeofhbtext').setValue(true);
			}
			else
			{
				Ext.getCmp('modeofhbhtml').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('sendheartbeat').hide();
			Ext.getCmp('sendhbto').hide();
			Ext.getCmp('modeofhb').hide();
		}
	},

	radAlarmEsc: function() {
		var escAlarm = Ext.getCmp('escalarm').getValue();
		var check = (/^[1-9][0-9]*$/).test(escAlarm);
		if (check)
		{
			Ext.getCmp('escalrmprty').show();
			Ext.getCmp('escalrmprty').setValue(['High','Medium','Low']);
		}
		else
		{
			Ext.getCmp('escalrmprty').hide();
		}
	},

	updationHeartBeart: function() {
		var HeartbeatFreq = Ext.getCmp('heartbeatfreq').getValue();
		var HeartbeatTo = Ext.getCmp('sendhbto').getValue();
		var me = this;
		var ischeckHBValide = me.checkHBValidation();
		if (ischeckHBValide)
		{
			urlLink = "MailAlertSettings/data/egAlertOptionspJson.jsp?HeartbeatFreq="+HeartbeatFreq;
			var myHBMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myHBMask.show();

			var hiddenObj = Ext.getCmp('hiddencontainer');
			var hiddenHeartBeatObj = publicJSON['hiddenHeartBeatObj'];
			for (var key in hiddenHeartBeatObj)
			{
				var hiddenTempField = {
					xtype: 'hiddenfield',
					name: key,
					value: hiddenHeartBeatObj[key],
				};
				hiddenObj.add(hiddenTempField);
			}
			var MailAlertOptionsObj = Ext.getCmp('heartbeat').getForm();
			MailAlertOptionsObj.submit({
			url: urlLink,
			method: 'POST',
			standardSubmit: false,
			success: function( form,action )
			{
				myHBMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show({
							title : Heartbeat_Label,
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : me.loadHBData()
						});
					}
				}
				hiddenObj.removeAll();
			},
				failure: function()
			{
				hiddenObj.removeAll();
			}
		});
		}
	},

	checkHBValidation: function() {
		var HBres = "true";
		var hbVal = Ext.getCmp('heartbeatfreq').getValue();
		if (hbVal.length != 0)
		{
			if(isNaN(hbVal))
			{
				Ext.Msg.show({
					title : Heartbeat_Label,
					msg : "' "+hbVal+" '  " +notValidNo+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('heartbeatfreq').focus();
					}
				});
				HBres = "false";
				return;
			}
			if(isValid(hbVal)=="false")
			{
				Ext.Msg.show({
					title : Heartbeat_Label,
					msg : isheartBeatValid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('heartbeatfreq').focus();
					}
				});
				HBres = "false";
				return;
			}
			if(hbVal.indexOf(".")>-1)
			{
				Ext.Msg.show({
					title : Heartbeat_Label,
					msg : isheartBeatValid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('heartbeatfreq').focus();
					}
				});
				HBres = "false";
				return;
			}
			hbVal=hbVal*60;
			var mailCheckPeriod = publicJSON['mailCheckPeriod'];
			if(!(hbVal>=mailCheckPeriod))
			{
				Ext.Msg.show({
					title : Heartbeat_Label,
					msg : heartFreq_MaxTime+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn :function(btn){
						Ext.getCmp('heartbeatfreq').focus();
					}
				});
				HBres = "false";
				return;
			}
			var email =Ext.getCmp('sendhbto').getValue();
			var result=validateEmail(email);
			if(result == null || result == undefined || result == false)
			{
				Ext.Msg.show({
					title : Heartbeat_Label,
					msg : enterValidId+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('sendhbto').focus();
					}
				});
				HBres = "false";
				return;
			}
			if (HBres = "true")
			{
				return true;
			}
		}
		else
		{
			return true;
		}
	},

	updationAlmEsc: function(btn) {
		var AlarmEscalationPeriod = Ext.getCmp('escalarm').getValue();
		var selectedAlarms = Ext.getCmp('escalrmprty').getValue();
		var AlarmEscalationType = Ext.getCmp('escalrmprty').getValue();

		var me = this;
		var isAlarmValidate = me.checkAlarmValidation();
		if (isAlarmValidate)
		{
			urlLink = "MailAlertSettings/data/egAlertOptionspJson.jsp?AlarmEscalationPeriod="+AlarmEscalationPeriod+"&selectedAlarms="+selectedAlarms+"&AlarmEscalationType="+AlarmEscalationType;
			var myAlrmMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myAlrmMask.show();

			var hiddenObj = Ext.getCmp('hiddencontainer');
			var hiddenAlarmEscValue = publicJSON['hiddenAlarmEscObj'];
			for (var key in hiddenAlarmEscValue)
			{
				var hiddenTempField = {
					xtype: 'hiddenfield',
					name: key,
					value: hiddenAlarmEscValue[key],
				};
				hiddenObj.add(hiddenTempField);
			}

			var MailAlertOptionsObj = Ext.getCmp('alarmescalation').getForm();
			MailAlertOptionsObj.submit({
			url: urlLink,
			method: 'POST',
			standardSubmit: false,
			success: function( form,action )
			{
				myAlrmMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show({
							title : AlarmEsc_Label,
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : me.loadArmData()
						});
					}
				}
				hiddenObj.removeAll();
			},
			failure: function()
			{
				hiddenObj.removeAll();
			}
		});
		}
	},

	checkAlarmValidation: function() {
		var alarmRes = "true";
		var esalarm = Ext.getCmp('escalarm').getValue();
		if (esalarm.length != 0)
		{
			if(isNaN(esalarm))
			{
				Ext.Msg.show({
					title : AlarmEsc_Label,
					msg : "' "+esalarm+" '  " + notValidNo+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('escalarm').focus();
					}
				});
				alarmRes = "false";
				return;
			}
			if(isValid(esalarm)=="false")
			{
				Ext.Msg.show({
					title : AlarmEsc_Label,
					msg : isEscalateAlarms+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('escalarm').focus();
					}
				});
				alarmRes = "false";
				return;
			}
			if(esalarm.indexOf(".")>-1)
			{
				Ext.Msg.show({
					title : AlarmEsc_Label,
					msg : noEscalateAlarms+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('escalarm').focus();
					}
				});
				alarmRes = "false";
				return;
			}
			esalarm=esalarm*60;
			var maxTimeAlert = publicJSON['mailCheckPeriod'];
			if(!(esalarm>=maxTimeAlert))
			{
				Ext.Msg.show({
					title : AlarmEsc_Label,
					msg : escalate_maxTime+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('escalarm').focus();
					}
				});
				alarmRes = "false";
				return;
			}
			var escalpartt = Ext.getCmp('escalrmprty').getValue();
			if (escalpartt.length == 0)
			{
				Ext.Msg.show({
					title : AlarmEsc_Label,
					msg : alarmPriority+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('escalrmprty').focus();
					}
				});
				alarmRes = "false";
				return;
			}
			if (alarmRes = "true")
			{
				return true;
			}
		}
		else
		{
			return true;
		}
	},

	updationShift: function() {
		var shiftLoad = this;
		var MaximumShifts = Ext.getCmp('maxnoofdayshift').getValue();
		urlLink = "MailAlertSettings/data/egAlertOptionspJson.jsp?MaximumShifts="+MaximumShifts;

		var myShiftMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myShiftMask.show();

		var hiddenObj = Ext.getCmp('hiddencontainer');
		var hiddenShiftPeriodValue = publicJSON['hiddenShiftPeriodObj'];
		for (var key in hiddenShiftPeriodValue)
		{
			var hiddenTempField = {
				xtype: 'hiddenfield',
				name: key,
				value: hiddenShiftPeriodValue[key],
			};
			hiddenObj.add(hiddenTempField);
		}

		var ShiftPeriodsObj = Ext.getCmp('shiftperiods').getForm();
		ShiftPeriodsObj.submit({
		url: urlLink,
		method: 'POST',
		standardSubmit: false,
		success: function( form,action )
		{
			myShiftMask.hide();
			var jsonText = action.response.responseText;
			publicJSON = Ext.decode(jsonText);
			if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
			{
				var resultStatus = publicJSON['requestStatus'];
				if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
				{
					var resultStatus = publicJSON['result'];
					Ext.MessageBox.show({
						title : ShiftPeriods_Label,
						msg : resultStatus['message1'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK,
						fn : shiftLoad.loadShiftData()
					});
				}
			}
			hiddenObj.removeAll();
		},
		failure: function()
		{
			hiddenObj.removeAll();
		}
	});
	},

	updationFilterSms: function() {
		urlLink = "MailAlertSettings/data/egAlertOptionspJson.jsp";

		var myFilterMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myFilterMask.show();

		var hiddenObj = Ext.getCmp('hiddencontainer');
		var hiddenFilterValue = publicJSON['hiddenFilterObj'];
		for (var key in hiddenFilterValue)
		{
			var hiddenTempField = {
				xtype: 'hiddenfield',
				name: key,
				value: hiddenFilterValue[key],
			};
			hiddenObj.add(hiddenTempField);
		}

		var meFilter = this;
		var hiddenFilterSmsObj = Ext.getCmp('filtermailsms').getForm();
		hiddenFilterSmsObj.submit({
		url: urlLink,
		method: 'POST',
		standardSubmit: false,
		success: function( form,action )
		{
			myFilterMask.hide();
			var jsonText = action.response.responseText;
			publicJSON = Ext.decode(jsonText);
			if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
			{
				var resultStatus = publicJSON['requestStatus'];
				if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
				{
					var resultStatus = publicJSON['result'];
					Ext.MessageBox.show({
						title : filterMail_Label,
						msg : resultStatus['message1'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK,
						fn : meFilter.loadFilterData()
					});
				}
			}
			hiddenObj.removeAll();
		},
		failure: function()
		{
			hiddenObj.removeAll();
		}
	});
	},

	updationLog: function() {
		var maxsizeoflog = Ext.getCmp('maxsizeoflog').getValue();
		var maxnooflog = Ext.getCmp('maxnooflog').getValue();
		var Arr = new Array();
		var desc = Ext.getCmp('descriptionalrm').getValue();
		var strtdate = Ext.getCmp('strtdatetimealrm').getValue();
		if (desc == true)
		{
			Arr[Arr.length] = "desc";
		}
		if (strtdate == true)
		{
			Arr[Arr.length] = "alarmdate";
		}
		var logPreference = Arr;
		if (logPreference.length == 0)
		{
			logPreference = " ";
		}

		var me = this;
		var isLogValidate = me.checkLogValidation();

		if (isLogValidate)
		{
			urlLink = "MailAlertSettings/data/egAlertOptionspJson.jsp?LogMaxSize="+maxsizeoflog+"&LogMaxFile="+maxnooflog+"&LogPreferance="+logPreference;

			var myLogMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myLogMask.show();

			var hiddenObj = Ext.getCmp('hiddencontainer');
			var hiddenMailLogValue = publicJSON['hiddenMailLogObj'];
			for (var key in hiddenMailLogValue)
			{
				var hiddenTempField = {
					xtype: 'hiddenfield',
					name: key,
					value: hiddenMailLogValue[key],
				};
				hiddenObj.add(hiddenTempField);
			}

			var hiddenMailLogDetObj = Ext.getCmp('maillogdetails').getForm();
			hiddenMailLogDetObj.submit({
			url: urlLink,
			method: 'POST',
			standardSubmit: false,
			success: function( form,action )
			{
				myLogMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show({
							title : mailLogDet_Label,
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : me.logLoadData()
						});
					}
				}
				hiddenObj.removeAll();
			},
			failure: function()
			{
				hiddenObj.removeAll();
			}
		});
		}
	},

	checkLogValidation: function() {
		var logRes = "true";
		var isMailLogEnabled = Ext.getCmp('logmailmgryes').getValue();
		if (isMailLogEnabled)
		{
			var size = Ext.getCmp('maxsizeoflog').getValue();
			if (size == null || size == "")
			{
				Ext.Msg.show({
					title : mailLogDet_Label,
					msg : maxSizeOfLogFile+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxsizeoflog').focus();
					}
				});
				logRes = "false";
				return;
			}
			var regExp = /^[0-9.]+$/;
			if(!regExp.test(size))
			{
				Ext.Msg.show({
					title : mailLogDet_Label,
					msg : numbericLog+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxsizeoflog').focus();
					}
				});
				logRes = "false";
				return;
			}

			var file = Ext.getCmp('maxnooflog').getValue();
			if (file == null || file == "")
			{
				Ext.Msg.show({
					title : mailLogDet_Label,
					msg : noOfLog+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxnooflog').focus();
					}
				});
				logRes = "false";
				return;
			}
			regExp = /^[0-9]+$/;
			if(!regExp.test(file))
			{
				Ext.Msg.show({
					title : mailLogDet_Label,
					msg : intLog+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxnooflog').focus();
					}
				});
				logRes = "false";
				return;
			}
			if (logRes = "true")
			{
				return true;
			}
		}
		else
		{
			return true;
		}
	},

	updationMAPrefer: function() {
		var mailsub = Ext.getCmp('mailsubject').getValue();
		var MailSubjectStart = Ext.getCmp('startmailsubject').getValue();
		var MailSubjectLength = Ext.getCmp('maxCmp').getValue();
		var smssub = Ext.getCmp('smssubject').getValue();
		var MailCheckPeriod = Ext.getCmp('maxtimealert').getValue();
		var MailHomeUrl = Ext.getCmp('homepageurl').getValue();

		var whastAppEnable = Ext.getCmp('whastAppEnable').getValue();
		var gateWay = Ext.getCmp('gateWay').getValue();
		var whastAppEnabled = 'No';
		var selectedGateWay = '';
		var chatURL='';
		var chatToken='';
		var whatsURL='';
		var clientSecret='';
		var instanceID='';
		var clientID='';
		if(whastAppEnable)
		{
			whastAppEnabled = 'Yes';
			if(!Ext.isEmpty(gateWay))
			{
				selectedGateWay = gateWay['whatsAppGateWay'];
			}
			if(selectedGateWay!=null && selectedGateWay=='ChatAPI')
			{
				chatURL = Ext.getCmp('chatAPIurl').getValue();
				chatToken = Ext.getCmp('chatAPIToken').getValue();
			}
			else if(selectedGateWay!=null && selectedGateWay=='WhatsMate')
			{
				whatsURL = Ext.getCmp('whatsMateUrl').getValue();
				clientSecret = Ext.getCmp('clientSecret').getValue();
				instanceID = Ext.getCmp('clientID').getValue();
				clientID = Ext.getCmp('instanceID').getValue();
			}
		}
		
		var mailSubjectTest = "";
		var mailSubjectTestVal = Ext.getCmp('testcontent').getValue();
		if (mailSubjectTestVal == true)
		{
			mailSubjectTest = "Test";
		}

		var mailSubjectDesc = "";
		var mailSubjectDescVal = Ext.getCmp('descriptioncontent').getValue();
		if (mailSubjectDescVal == true)
		{
			mailSubjectDesc = "Description";
		}

		var mailSubjectLMV = "";
		var mailSubjectLMVVal = Ext.getCmp('lastmeasurecontent').getValue();
		if (mailSubjectLMVVal == true)
		{
			mailSubjectLMV = "LMV";
		}

		var mailtest = "";
		var mailtestVal = Ext.getCmp('testmail').getValue();
		if (mailtestVal == true)
		{
			mailtest = "test";
		}

		var maildesc = "";
		var maildescVal = Ext.getCmp('descriptionmail').getValue();
		if (maildescVal == true)
		{
			maildesc = "desc";
		}

		var mailmeasure = "";
		var mailmeasureVal = Ext.getCmp('lastmeasuremail').getValue();
		if (mailmeasureVal == true)
		{
			mailmeasure = "measure";
		}

		var test = "";
		var testVal = Ext.getCmp('testsms').getValue();
		if (testVal == true)
		{
			test = "test";
		}

		var desc = "";
		var descVal = Ext.getCmp('descriptionsms').getValue();
		if (descVal == true)
		{
			desc = "desc";
		}

		var measure = "";
		var measureVal = Ext.getCmp('lastmeasuresms').getValue();
		if (measureVal == true)
		{
			measure = "measure";
		}

		var hiddenObj = Ext.getCmp('hiddencontainer');
		hiddenObj.removeAll();
		var temp = {
			xtype: 'hiddenfield',
			name: 'mailsub',
			value: mailsub,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'MailCheckPeriod',
			value: MailCheckPeriod,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'MailHomeUrl',
			value: MailHomeUrl,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'mailSubjectTest',
			value: mailSubjectTest,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'mailSubjectDesc',
			value: mailSubjectDesc,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'mailSubjectLMV',
			value: mailSubjectLMV,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'mailtest',
			value: mailtest,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'maildesc',
			value: maildesc,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'mailmeasure',
			value: mailmeasure,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'test',
			value: test,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'desc',
			value: desc,
		};
		hiddenObj.add(temp);

		temp = {
			xtype: 'hiddenfield',
			name: 'measure',
			value: measure,
		};
		hiddenObj.add(temp);

		var me = this;
		var isMailValidate = me.checkForMailValidation();
		if (isMailValidate)
		{
			urlLink = "MailAlertSettings/data/egAlertOptionspJson.jsp?MailSubjectStart="+MailSubjectStart+"&MailSubjectLength="+MailSubjectLength+"&smssub="+encodeURIComponent(smssub)+"&fromMailSmsPrefer=true&whastAppEnabled="+encodeURIComponent(whastAppEnabled)+"&selectedGateWay="+encodeURIComponent(selectedGateWay);
			if(whastAppEnable)
			{
				if(selectedGateWay!=null && selectedGateWay=='ChatAPI')
				{
					var pattern = /^((http|https):\/\/)/;
					if(!pattern.test(chatURL)) {
						Ext.Msg.show({
							title: alertTitle,
							msg: gateWayUrlAlert,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					if((chatToken==null || chatToken=='') || chatToken=='$unconfigured') {
						Ext.Msg.show({
							title: alertTitle,
							msg: gateWayTokenAlert,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					urlLink = urlLink+"&chatURL="+encodeURIComponent(chatURL)+"&chatToken="+encodeURIComponent(chatToken);
				}
				else if(selectedGateWay!=null && selectedGateWay=='WhatsMate')
				{
					var pattern = /^((http|https):\/\/)/;
					if(!pattern.test(whatsURL)) {
						Ext.Msg.show({
							title: alertTitle,
							msg: gateWayUrlAlert,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					if((clientSecret==null || clientSecret=='') || clientSecret=='$unconfigured') {
						Ext.Msg.show({
							title: alertTitle,
							msg: clientSecretAlert,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					if((clientID==null || clientID=='') || clientID=='$unconfigured') {
						Ext.Msg.show({
							title: alertTitle,
							msg: clientIDAlert,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					if((instanceID==null || instanceID=='') || instanceID=='$unconfigured') {
						Ext.Msg.show({
							title: alertTitle,
							msg: instanceIDAlert,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false;
					}
					urlLink = urlLink+"&whatsURL="+encodeURIComponent(whatsURL)+"&clientSecret="+encodeURIComponent(clientSecret)+"&instanceID="+encodeURIComponent(instanceID)+"&clientID="+encodeURIComponent(clientID);
				}
			}
			var myMask = new Ext.LoadMask(Ext.getCmp('MailAlertSettingsRightPane'), {msg: 'Updating...'});
			myMask.show();

			var hiddenMailAlertObj = Ext.getCmp('mailalertpreference').getForm();
			hiddenMailAlertObj.submit({
			url: urlLink,
			method: 'POST',
			standardSubmit: false,
			success: function( form,action )
			{
				myMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show({
							title : PageTitle,
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : loadingMAPrefer
						});
					}
				}
				hiddenObj.removeAll();
			},
			failure: function()
			{
				hiddenObj.removeAll();
			}
		});
		}
	},

	checkForMailValidation: function() {
		var res = "true";
		var mailhomeUrl = Ext.getCmp('homepageurl').getValue();
		if (mailhomeUrl.length == 0)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : validHomePageUrl+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('homepageurl').focus();
				}
			});
			res="false";
			return;
		}
		var maxTimeAl = Ext.getCmp('maxtimealert').getValue();
		if(isNaN(maxTimeAl))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : "' "+maxTimeAl+" '  " +notValidNo+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('maxtimealert').focus();
				}
			});
			res="false";
			return;
		}
		if(isValid(maxTimeAl))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : timeEmailAlert+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('maxtimealert').focus();
				}
			});
			res="false";
			return;
		}
		var mail_Sub = true;
		var sms_Sub=true;
		if(isDouble == "false")
		{
			mail_Sub= validateSingleByte(Ext.getCmp('mailsubject').getValue());
			if (smsEnabled)
			{
				sms_Sub= validateSingleByte(Ext.getCmp('smssubject').getValue());
			}
		}
		
		var mailSub = Ext.getCmp('mailsubject').getValue();
		if(this.specialCharacterCheck(mailSub))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : 'special characters not allowed.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function()
				{
					Ext.getCmp('mailsubject').focus();
				}
			});
			return ;
		}
		
		if (smsEnabled)
		{
			var smsSub = Ext.getCmp('smssubject').getValue();
			if(this.specialCharacterCheck(smsSub))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : 'special characters not allowed.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function()
					{
						Ext.getCmp('smssubject').focus();
					}
				});
				return ;
			}
		}
		if(!checkMailSubject())
		{
			res="false";
			return;
		}
		if (!mail_Sub)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg :  mailSubSingleByte+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('mailsubject').focus();
				}
			});
			res="false";
			return;
		}
		if (!sms_Sub)
		{
			Ext.Msg.show({
				title :PageTitle,
				msg : smsSubSingleByte+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smssubject').focus();
				}
			});
			res="false";
			return;
		}
		if (res = "true")
		{
			return true;
		}
	},
	specialCharacterCheck: function(text)
	{
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<,?\/";
		try
		{
			for(count = 0; count < text.length; count++)
			{
				var check_char = s_spl.indexOf(text.charAt(count));
				if(check_char >= 0)
					return true;
			}
		}
		catch (e)
		{
		}
		return false;
	},
	afterMainRender : function() {
		var disObject = Ext.getCmp('MailAlertSettingsRightPane');
		disObject.removeAll();

		var treePanel = Ext.getCmp('settingList');
		var record = treePanel.getStore().getNodeById('mailalertpreferences');
		treePanel.getSelectionModel().select(record);
		
		var initData = this;
		initData.buildFieldData('mailalertpreferences');
		disObject.add({xtype:'mailalertpreference'});
		this.getController('MailAlertSettings.controller.MailAlertPreferCtrl').afterMainRender();
		Ext.getCmp('MailAlertSettingsRightPane').setTitle(PageTitle);
		Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
	},

	loadServerAgentSettingsPage : function(view, record, item, index, event){
		selectedNodeId = record.data.id;
		var disObject = Ext.getCmp('MailAlertSettingsRightPane');
		disObject.removeAll();
		var me = this;

		if (selectedNodeId == 'mailalertpreferences')
		{
			var myClickMask = new Ext.LoadMask(Ext.getCmp('MailAlertSettingsRightPane'), {msg: 'Loading...'});
			myClickMask.show();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(PageTitle);
			Ext.Ajax.request({
				url: 'MailAlertSettings/data/egAlertOptionsJson.jsp?selectedNode='+selectedNodeId,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
						disObject.add({xtype:'mailalertpreference'});
						me.getController('MailAlertSettings.controller.MailAlertPreferCtrl').afterMainRender();
						//Ext.getCmp('MailAlertSettingsRightPane').setTitle(PageTitle);
						Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
						myClickMask.hide();
					}
				}
			});
		}
		else if (selectedNodeId == 'heartbeat')
		{
			disObject.add({xtype:'heartbeat'});
			me.buildFieldData(selectedNodeId);
			me.HeartBeatRender();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(Heartbeat_Label);
			Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'alarmescalation')
		{
			disObject.add({xtype:'alarmescalation'});
			me.buildFieldData(selectedNodeId);
			me.AlarmEscalationRender();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(AlarmEsc_Label);
			Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'shiftperiods')
		{
			disObject.add({xtype:'shiftperiods'});
			me.buildFieldData(selectedNodeId);
			me.ShiftPeriodRender();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(ShiftPeriods_Label);
			Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'maillogdetails')
		{
			disObject.add({xtype:'maillogdetails'});
			me.buildFieldData(selectedNodeId);
			me.MailLogDetailsRender();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(mailLogDet_Label);
			Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'filtermailsms')
		{
			disObject.add({xtype:'filtermailsms'});
			me.buildFieldData(selectedNodeId);
			me.FilterMailSmsRender();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(filterMail_Label);
			Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'licenseusagemail')
		{
			disObject.add({xtype:'licenseusagemail'});
			me.buildFieldData(selectedNodeId);
			me.LicenseUsageRender();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(licenseUsageAndValidity_Label);
			Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'configMailSettings')
		{
			disObject.add({xtype:'configmailalertsettings'});
			me.buildFieldData(selectedNodeId);
			me.configMailAlertRender();
			Ext.getCmp('MailAlertSettingsRightPane').setTitle(configMailSettingsPageLabel);
			Ext.getCmp('MailAlertSettingsRightPane').getHeader().show();
		}
	},

	HeartBeatRender: function() {
		var hbFreq = publicJSON['heartbeatFreq'];
		if (hbFreq != "" && !Ext.isEmpty(hbFreq) && hbFreq.length > 0)
		{
			Ext.getCmp('heartbeatfreq').setValue(hbFreq);
			var heartbeatAlways = publicJSON['heartbeatAlways'];
			if (heartbeatAlways == "True")
			{
				Ext.getCmp('sendheartbeatyes').setValue(true);
			}
			else
			{
				Ext.getCmp('sendheartbeatno').setValue(true);
			}
			Ext.getCmp('sendhbto').setValue(publicJSON['HeartbeatTo']);
			var heartbeatMailMode = publicJSON['heartbeatMailMode'];
			if (heartbeatMailMode == "Text")
			{
				Ext.getCmp('modeofhbtext').setValue(true);
			}
			else
			{
				Ext.getCmp('modeofhbhtml').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('sendheartbeat').hide();
			Ext.getCmp('sendhbto').hide();
			Ext.getCmp('modeofhb').hide();
		}
	},
	
	loadHBData: function() {
		var HBLoad = this;
		HBLoad.buildFieldData('heartbeat');
		HBLoad.HeartBeatRender();
	},

	AlarmEscalationRender: function() {
		var alarmEscalationPeriod = publicJSON['alarmEscalationPeriod'];
		if (alarmEscalationPeriod != "" && !Ext.isEmpty(alarmEscalationPeriod))
		{
			Ext.getCmp('escalarm').setValue(alarmEscalationPeriod);
			Ext.getCmp('escalrmprty').setValue(publicJSON['alarmEscalationType']);
		}
		else
		{
			Ext.getCmp('escalrmprty').hide();
		}
	},
	
	loadArmData: function() {
		var almData = this;
		almData.buildFieldData('alarmescalation');
		almData.AlarmEscalationRender();
	},

	ShiftPeriodRender: function() {
		var shiftPeriodConfig = publicJSON['shiftPeriodConfig'];
		if (shiftPeriodConfig == "true")
		{
			Ext.getCmp('maxnoofdayshift').show();
			Ext.getCmp('allwshiftconfigyes').setValue(true);
			Ext.getCmp('maxnoofdayshift').setValue(publicJSON['maximumShifts']);
		}
		else
		{
			Ext.getCmp('allwshiftconfigno').setValue(true);
			Ext.getCmp('maxnoofdayshift').hide();
		}
	},

	loadShiftData: function() {
		var shftData = this;
		shftData.buildFieldData('shiftperiods');
		shftData.ShiftPeriodRender();
	},

	MailLogDetailsRender: function() {
		var mailLogDebug = publicJSON['mailLogDebug'];
		if (mailLogDebug == "Yes")
		{
			Ext.getCmp('maxsizeoflog').show();
			Ext.getCmp('maxnooflog').show();
			Ext.getCmp('alarmloggeddet').show();

			Ext.getCmp('logmailmgryes').setValue(true);
			Ext.getCmp('maxsizeoflog').setValue(publicJSON['mailLogMaxSize']);
			Ext.getCmp('maxnooflog').setValue(publicJSON['mailLogMaxRollFile']);
			var aListToken = publicJSON['logPreference'];
			
			var cnameChecked = false;
			var ctypeChecked = false;
			var layerChecked = false;
			var testChecked = false;
			var descChecked = false;
			var alarmdateChecked = false;

			var aListTokenArr = aListToken.split(",");
			for (var j=0;j<aListTokenArr.length;j++ )
			{
				if (aListTokenArr[j] == 'cName')
				{
					cnameChecked = true;
				}
				if (aListTokenArr[j] == 'cType')
				{
					ctypeChecked = true;
				}
				if (aListTokenArr[j] == 'layer')
				{
					layerChecked = true;
				}
				if (aListTokenArr[j] == 'test')
				{
					testChecked = true;
				}
				if (aListTokenArr[j] == 'desc')
				{
					descChecked = true;
				}
				if (aListTokenArr[j] == 'alarmdate')
				{
					alarmdateChecked = true;
				}
			}
			if (cnameChecked)
			{
				Ext.getCmp('cmpnamealrm').setValue(true).disable();
			}
			if (ctypeChecked)
			{
				Ext.getCmp('cmptypealrm').setValue(true).disable();
			}
			if (layerChecked)
			{
				Ext.getCmp('layeralrm').setValue(true).disable();
			}
			if (testChecked)
			{
				Ext.getCmp('testalrm').setValue(true).disable();
			}
			if (descChecked)
			{
				Ext.getCmp('descriptionalrm').setValue(true);
			}
			if (alarmdateChecked)
			{
				Ext.getCmp('strtdatetimealrm').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('maxsizeoflog').hide();
			Ext.getCmp('maxnooflog').hide();
			Ext.getCmp('alarmloggeddet').hide();
			Ext.getCmp('logmailmgrno').setValue(true);
		}
	},

	logLoadData: function() {
		var logData = this;
		logData.buildFieldData('maillogdetails');
		logData.MailLogDetailsRender();
	},

	FilterMailSmsRender: function() {
		var filter_mailalerts = publicJSON['filter_mailalerts'];
		if (filter_mailalerts == 'Yes')
		{
			Ext.getCmp('nonadmin').show();
			Ext.getCmp('allowmailsmsfilteryes').setValue(true);
			var filterconfig_nonadmins = publicJSON['filterconfig_nonadmins'];
			if (filterconfig_nonadmins == 'Yes')
			{
				Ext.getCmp('nonadminupdateyes').setValue(true);
			}
			else
			{
				Ext.getCmp('nonadminupdateno').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('allowmailsmsfilterno').setValue(true);
			Ext.getCmp('nonadmin').hide();
		}
	},

	loadFilterData: function() {
		var filterData = this;
		filterData.buildFieldData('filtermailsms');
		filterData.FilterMailSmsRender();
	},

	// config mail alert - changes starts here
	configMailAlertRender: function()
	{
		var enableConfigAlert = publicJSON.enableConfigAlert;
		if (!Ext.isEmpty(enableConfigAlert) && (enableConfigAlert.toLowerCase() == 'yes' || enableConfigAlert.toLowerCase() == 'true'))
		{
			Ext.getCmp('enableconfigalertyes').setValue(true);
			Ext.getCmp('cnt2').show();
		}
		else
		{
			Ext.getCmp('enableconfigalertno').setValue(true);
			Ext.getCmp('cnt2').hide();
		}

		Ext.getCmp('configmailalertfrequency').setValue(publicJSON.configMailCheckPeriod);
		Ext.getCmp('configmailsubject').setValue(publicJSON.configMailSubject);

		var sendConfigMailAsAttachment = publicJSON.sendConfigMailAsAttachment;
		if (!Ext.isEmpty(sendConfigMailAsAttachment) && (sendConfigMailAsAttachment.toLowerCase() == 'yes' || sendConfigMailAsAttachment.toLowerCase() == 'true'))
		{
			Ext.getCmp('sendconfigalertattachmentyes').setValue(true);
		}
		else
		{
			Ext.getCmp('sendconfigalertattachmentno').setValue(true);
		}

		var configMailManagerDebug = publicJSON.configMailManagerDebug;
		if (!Ext.isEmpty(configMailManagerDebug) && (configMailManagerDebug.toLowerCase() == 'yes' || configMailManagerDebug.toLowerCase() == 'true'))
		{
			Ext.getCmp('logconfigmailmgryes').setValue(true);
			Ext.getCmp('maxsizeofconfiglog').show();
			Ext.getCmp('maxnoofconfiglog').show();
			Ext.getCmp('maxsizeofconfiglog').setValue(publicJSON.configMailmanagerLogMaxRollSize);
			Ext.getCmp('maxnoofconfiglog').setValue(publicJSON.configMailmanagerLogMaxFiles);
		}
		else
		{
			Ext.getCmp('logconfigmailmgrno').setValue(true);
			Ext.getCmp('maxsizeofconfiglog').hide();
			Ext.getCmp('maxnoofconfiglog').hide();
		}
		Ext.getCmp('configsmssubject').setValue(publicJSON.configSmsSubject);
	},

	onChangeEnableCnfgAlert: function()
	{
		var selVal = Ext.getCmp('enableconfigalertyes').getGroupValue();

		if (!Ext.isEmpty(selVal) && selVal.toLowerCase() == 'yes')
		{
			Ext.getCmp('cnt2').show();
		}
		else
		{
			Ext.getCmp('cnt2').hide();
		}
	},

	radConfigMailLogDetails: function()
	{
		var selVal = Ext.getCmp('logconfigmailmgryes').getGroupValue();

		if (selVal.toLowerCase() == 'yes')
		{
			Ext.getCmp('maxsizeofconfiglog').show();
			Ext.getCmp('maxnoofconfiglog').show();
			Ext.getCmp('maxsizeofconfiglog').setValue(publicJSON.configMailmanagerLogMaxRollSize);
			Ext.getCmp('maxnoofconfiglog').setValue(publicJSON.configMailmanagerLogMaxFiles);
		}
		else
		{
			Ext.getCmp('maxsizeofconfiglog').hide();
			Ext.getCmp('maxnoofconfiglog').hide();
		}
	},

	validateConfigMailAlertPage: function()
	{
		var enableconfigalert = Ext.getCmp('enableconfigalertyes').getGroupValue();
		var configMailAlertFreq = Ext.getCmp('configmailalertfrequency').getValue();
		var configMailSubject = Ext.getCmp('configmailsubject').getValue();
		var configSMSSubject = Ext.getCmp('configsmssubject').getValue();
		var sendConfigAlertsAsAttachment = Ext.getCmp('sendconfigalertattachmentyes').getGroupValue();
		var isMailLogEnabled = Ext.getCmp('logconfigmailmgryes').getGroupValue();
		var size = Ext.getCmp('maxsizeofconfiglog').getValue();
		var file = Ext.getCmp('maxnoofconfiglog').getValue();

		if (!Ext.isEmpty(enableconfigalert) && enableconfigalert == 'No')
		{
			return true;
		}
		if(isNaN(configMailAlertFreq))
		{
			Ext.Msg.show({
				title : configMailSettingsPageLabel,
				msg : "' "+configMailAlertFreq+" '  " +notValidNo+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('configmailalertfrequency').focus();
				}
			});
			return false;
		}
		if(isValid(configMailAlertFreq) == "false")
		{
			Ext.Msg.show({
				title : configMailSettingsPageLabel,
				msg : timeEmailAlert+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('configmailalertfrequency').focus();
				}
			});
			return false;
		}
		if (Ext.isEmpty(configMailSubject) || Ext.String.trim(configMailSubject).length == 0)
		{
			Ext.Msg.show({
				title : configMailSettingsPageLabel,
				msg : notmailSubBlank+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('configmailsubject').focus();
				}
			});
			return false;
		}

		var mail_Sub = true;
		var sms_Sub=true;
		if(isDouble == "false")
		{
			mail_Sub= validateSingleByte(configMailSubject);
			if (smsEnabled)
			{
				sms_Sub= validateSingleByte(Ext.getCmp('configsmssubject').getValue());
			}
		}
		if (!mail_Sub)
		{
			Ext.Msg.show({
				title : configMailSettingsPageLabel,
				msg :  mailSubSingleByte+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('configmailsubject').focus();
				}
			});
			return false;
		}
		if (!sms_Sub)
		{
			Ext.Msg.show({
				title :PageTitle,
				msg : smsSubSingleByte+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('configsmssubject').focus();
				}
			});
			return false;
		}

		if (isMailLogEnabled.toLowerCase() == 'yes')
		{
			var regExp = /^[0-9.]+$/;
			var regExpForFile = /^[0-9]+$/;
			if (Ext.isEmpty(size) || Ext.String.trim(size).length == 0)
			{
				Ext.Msg.show({
					title : configMailSettingsPageLabel,
					msg : maxSizeOfLogFile+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxsizeofconfiglog').focus();
					}
				});
				return false;
			}
			else if(!regExp.test(size))
			{
				Ext.Msg.show({
					title : configMailSettingsPageLabel,
					msg : numbericLog+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxsizeofconfiglog').focus();
					}
				});
				return false;
			}
			else if (Ext.isEmpty(file) || Ext.String.trim(file).length == 0)
			{
				Ext.Msg.show({
					title : configMailSettingsPageLabel,
					msg : noOfLog+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxnoofconfiglog').focus();
					}
				});
				return false;
			}
			else if(!regExpForFile.test(file))
			{
				Ext.Msg.show({
					title : configMailSettingsPageLabel,
					msg : intLog+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('maxnoofconfiglog').focus();
					}
				});
				return false;
			}
			else
				return true;
		}
		else
		{
			return true;
		}
	},

	updateConfigMailAlertSettings: function()
	{
		var enableconfigalert = Ext.getCmp('enableconfigalertyes').getGroupValue();
		var configMailAlertFreq = Ext.getCmp('configmailalertfrequency').getValue();
		var configMailSubject = Ext.getCmp('configmailsubject').getValue();
		var configSMSSubject = Ext.getCmp('configsmssubject').getValue();
		var sendConfigAlertsAsAttachment = Ext.getCmp('sendconfigalertattachmentyes').getGroupValue();
		var logconfigmailmgr = Ext.getCmp('logconfigmailmgryes').getGroupValue();
		var maxsizeofconfiglog = Ext.getCmp('maxsizeofconfiglog').getValue();
		var maxnoofconfiglog = Ext.getCmp('maxnoofconfiglog').getValue();
		var qryStr = "fromConfigMailAlertSettings=yes&enableconfigalert="+enableconfigalert+"&configMailAlertFreq="+configMailAlertFreq+"&configMailSubject="+configMailSubject+"&configSMSSubject="+configSMSSubject+"&sendConfigAlertsAsAttachment="+sendConfigAlertsAsAttachment+"&logconfigmailmgr="+logconfigmailmgr;
		if (logconfigmailmgr.toLowerCase() == 'yes')
		{
			qryStr += "&maxsizeofconfiglog="+maxsizeofconfiglog+"&maxnoofconfiglog="+maxnoofconfiglog;
		}

		var validationStatus = me.validateConfigMailAlertPage();

		if (validationStatus)
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();

			var configMailAlertForm = Ext.getCmp('configmailalertsettings').getForm();
			configMailAlertForm.submit({
				url: 'MailAlertSettings/data/egAlertOptionspJson.jsp',
				params: qryStr,
				method: 'POST',
				standardSubmit: false,
				success: function( form,action )
				{
					myMask.hide();
					var jsonText = action.response.responseText;
					if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
					{
						var jsonData = Ext.decode(jsonText);
						var resultStatus = jsonData['ConfigMailAlertSettingsUpdated'];
						if (!Ext.isEmpty(resultStatus) && resultStatus.toLowerCase() == "yes")
						{
							Ext.MessageBox.show({
								title : configMailSettingsPageLabel,
								msg : jsonData.ConfigMailResultMsg,
								icon : 'iconInformation',
								buttons : Ext.Msg.OK
							});
						}
					}
				},
				failure: function()
				{
					myMask.hide();
					Ext.Msg.alert(configMailSettingsPageLabel,configMailSettingsErrMsg+".");
				}
			});
		}
	}

	// config mail alert - changes ends here

});

function trim(stringToTrim) {
	return stringToTrim.replace(/^\s+|\s+$/g,"");
}

function isNotValidDates(val)
{
	var number_format = ",0123456789";
	for (var i = 0; i < val.length; i++)
	{
		check_char = number_format.indexOf(val.charAt(i))
		if (check_char < 0)
		{
			return false;
		}
	}
	return true;
}

function isValid(val)
{
	if(val.length==0||val.indexOf('0')==0)
	{
		return "false";
	}
	if(parseInt(val)<=0)
	{
		return "false";
	}
}

function checkMailSubject()
{
	var subFormat = '';
	var selectFormat = Ext.getCmp('mailsubformatyes').getValue();
	if (selectFormat == true)
	{
		subFormat = 'CustomFormat';
	}
	else
	{
		subFormat = 'DefinedFormat';
	}
	var val;
	if(subFormat =="CustomFormat")
	{
		val = Ext.getCmp('mailsubject').getValue();;
		if(val==''||val.length<0)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : notmailSubBlank+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('mailsubject').focus();
				}
			});
			return false;
		}
	}
	if(subFormat =="DefinedFormat")
	{
		var startMailSub= true;
		val = Ext.getCmp('startmailsubject').getValue();
		if(val.length==0)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : notstartmailSubBlank+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('startmailsubject').focus();
				}
			});
			return false;
		}
		if(isDouble == "false")
		{
			startMailSub = validateSingleByte(val);
			if(!startMailSub)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailSubSingleByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('startmailsubject').focus();
					}
				});
				return false;
			}
		}
		if (Ext.getCmp('servicescontent').getValue() == false &&
			Ext.getCmp('cmpnamecontent').getValue() == false &&
			Ext.getCmp('cmptypecontent').getValue() == false &&
			Ext.getCmp('layercontent').getValue() == false &&
			Ext.getCmp('testcontent').getValue() == false &&
			Ext.getCmp('descriptioncontent').getValue() == false &&
			Ext.getCmp('prioritycontent').getValue() == false &&
			Ext.getCmp('alarmidcontent').getValue() == false)
		{
			if(Ext.getCmp('lastmeasurecontent').getValue() != null && Ext.getCmp('lastmeasurecontent').getValue() == false)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : selectMailsub+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
			else
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : selectMailsub+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
		}

		val = Ext.getCmp('maxCmp').getValue();
		if(isNaN(val))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : "' "+val+" '  " + notValidNo+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('maxCmp').focus();
				}
			});
			return false;
		}
		if(val.length==0||val.indexOf('0')==0||parseInt(val)<=0||val.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : maxCmpNo+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('maxCmp').focus();
				}
			});
			return false;
		}
	}
	return true;
}

function loadingMAPrefer() {
	Ext.Ajax.request({
		url: 'MailAlertSettings/data/egAlertOptionsJson.jsp?selectedNode=mailalertpreferences',
		method: 'POST',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );

				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					Ext.getCmp('homepageurl').setValue(publicJSON['mailHomeUrl']);
					Ext.getCmp('maxtimealert').setValue(publicJSON['mailCheckPeriod']);

					var editMailId = publicJSON['editMailId'];
					if (editMailId == 'No')
					{
						Ext.getCmp('allowmonuserno').setValue(true);
					}
					else
					{
						Ext.getCmp('allowmonuseryes').setValue(true);
					}

					var alertAgentsNotRunning = publicJSON['alertAgentsNotRunning'];
					if (alertAgentsNotRunning == 'No')
					{
						Ext.getCmp('alertagentrunno').setValue(true);
					}
					else
					{
						Ext.getCmp('alertagentrunyes').setValue(true);
					}

					var mailLastValue = publicJSON['mailLastValue'];
					if (mailLastValue == 'No')
					{
						Ext.getCmp('showlastmeasureno').setValue(true);
					}
					else
					{
						Ext.getCmp('showlastmeasureyes').setValue(true);
					}

					var stopEsconAckMail = publicJSON['stopEsconAckMail'];
					if (stopEsconAckMail == 'No')
					{
						Ext.getCmp('stopEsconAckMailNo').setValue(true);
					}
					else
					{
						Ext.getCmp('stopEsconAckMailYes').setValue(true);
					}

					var mailSubFormat = publicJSON['mailSubjectFormatToUse'];  
					if (mailSubFormat == 'DefinedFormat')
					{
						Ext.getCmp('mailsubformatno').setValue(true);
						Ext.getCmp('mailsubject').hide();
						Ext.getCmp('calarmidcontent').hide();
						Ext.getCmp('cprioritycontent').hide();
						Ext.getCmp('startmailsubject').show();
						Ext.getCmp('startmailsubject').setValue(publicJSON['mailSubjectStart']);
						Ext.getCmp('servicescontent').show()
						Ext.getCmp('servicescontent').setValue(publicJSON['mailSubject_SV']);
						Ext.getCmp('cmpnamecontent').show()
						Ext.getCmp('cmpnamecontent').setValue(publicJSON['mailSubject_CN']);
						Ext.getCmp('cmptypecontent').show()
						Ext.getCmp('cmptypecontent').setValue(publicJSON['mailSubject_CT']);
						Ext.getCmp('layercontent').show();
						Ext.getCmp('layercontent').setValue(publicJSON['mailSubject_LY']);
						Ext.getCmp('testcontent').show()
						Ext.getCmp('descriptioncontent').show()
						Ext.getCmp('prioritycontent').show()
						Ext.getCmp('prioritycontent').setValue(publicJSON['mailSubject_PT']);
						Ext.getCmp('alarmidcontent').show()
						Ext.getCmp('alarmidcontent').setValue(publicJSON['mailSubject_AID']);
						Ext.getCmp('maxCmp').show();
						Ext.getCmp('maxCmp').setValue(publicJSON['mailSubjectLength']);

						var showLastMeasure = Ext.getCmp('showlastmeasureyes').getValue();
						var descriptive = Ext.getCmp('mailsubformatno').getValue();
						
						Ext.getCmp('testcontent').setValue(publicJSON['mailSubject_TN']).enable();
						Ext.getCmp('descriptioncontent').setValue(publicJSON['mailSubject_DC']).enable();
						Ext.getCmp('lastmeasurecontent').setValue(publicJSON['mailSubject_LM']).enable();
						if(MailDefaultTestEnableWhenDescSelect)
						{
							if(Ext.getCmp('lastmeasurecontent').getValue() == true){
								Ext.getCmp('testcontent').disable();
								Ext.getCmp('descriptioncontent').disable();
							}
						}

						/*if (mailLastValue == 'Yes')
						{
							Ext.getCmp('testcontent').setValue(true).disable();
							Ext.getCmp('descriptioncontent').setValue(true).disable();
							//Ext.getCmp('lastmeasurecontent').show();
							Ext.getCmp('lastmeasurecontent').setValue(true).disable();
						}
						else
						{
							Ext.getCmp('testcontent').setValue(publicJSON['mailSubject_TN']).enable();
							Ext.getCmp('descriptioncontent').setValue(publicJSON['mailSubject_DC']).enable();
							Ext.getCmp('lastmeasurecontent').hide();
						}*/
					}
					else
					{
						Ext.getCmp('mailsubformatyes').setValue(true);
						Ext.getCmp('mailsubject').show();
						Ext.getCmp('mailsubject').setValue(publicJSON['strmSub']);
						Ext.getCmp('startmailsubject').hide();
						Ext.getCmp('calarmidcontent').show();
						Ext.getCmp('cprioritycontent').show();
						Ext.getCmp('servicescontent').hide();
						Ext.getCmp('cmpnamecontent').hide();
						Ext.getCmp('cmptypecontent').hide();
						Ext.getCmp('layercontent').hide();
						Ext.getCmp('testcontent').hide();
						Ext.getCmp('descriptioncontent').hide();
						Ext.getCmp('prioritycontent').hide();
						Ext.getCmp('alarmidcontent').hide();
						Ext.getCmp('cprioritycontent').setValue(publicJSON['mailSubject_CPT']);
						Ext.getCmp('calarmidcontent').setValue(publicJSON['mailSubject_CAID']);
						Ext.getCmp('maxCmp').hide();
					}

					Ext.getCmp('servicesmail').setValue(publicJSON['mail5']);
					Ext.getCmp('cmpnamemail').setValue(publicJSON['mail1']);
					Ext.getCmp('cmptypemail').setValue(publicJSON['mail2']);
					Ext.getCmp('layermail').setValue(publicJSON['mail3']);
					Ext.getCmp('alarmIdMail').setValue(publicJSON['mail9']);

					if (mailLastValue == 'Yes')
					{
						Ext.getCmp('testmail').setValue(true).disable();
						Ext.getCmp('descriptionmail').setValue(true).disable();
						//Ext.getCmp('lastmeasuremail').show();
						Ext.getCmp('lastmeasuremail').setValue(true).disable();
					}
					else
					{
						Ext.getCmp('testmail').setValue(publicJSON['mail6']).enable();
						Ext.getCmp('descriptionmail').setValue(publicJSON['mail4']).enable();
						Ext.getCmp('lastmeasuremail').hide();
					}
					Ext.getCmp('measurementhost').setValue(publicJSON['mail8']);
					
					var separateMail = publicJSON['strmailseparate'];
					if (separateMail == 'true')
					{
						Ext.getCmp('sepmailalertyes').setValue(true);
					}
					else
					{
						Ext.getCmp('sepmailalertno').setValue(true);
					}

					var mailAsAttachment = publicJSON['mailAsAttachment'];
					if (mailAsAttachment == 'true')
					{
						Ext.getCmp('sendalertattachmentyes').setValue(true);
					}
					else
					{
						Ext.getCmp('sendalertattachmentno').setValue(true);
					}

					var normalMail = publicJSON['normalMail'];
					if (normalMail == 'true')
					{
						Ext.getCmp('sendmailalrmclearyes').setValue(true);
					}
					else
					{
						Ext.getCmp('sendmailalrmclearno').setValue(true);
					}

					var ddMail = publicJSON['ddMail'];
					if (ddMail == 'yes')
					{
						Ext.getCmp('ddmailalertyes').setValue(true);
					}
					else
					{
						Ext.getCmp('ddmailalertno').setValue(true);
					}
			 
					var isConfigSupport = publicJSON['isConfigSupported'];
					if (isConfigSupport == true)
					{
						var configChanges = publicJSON['configChangesInMail'];
						if (configChanges == 'true')
						{
							Ext.getCmp('incconfigyes').setValue(true);
						}
						else
						{
							Ext.getCmp('incconfigno').setValue(true);
						}
					}

					var smsLastValue = publicJSON['smsLastValue'];
					if (smsLastValue == 'No')
					{
						Ext.getCmp('showsmslastmeasureno').setValue(true);
					}
					else
					{
						Ext.getCmp('showsmslastmeasureyes').setValue(true);
					}

					Ext.getCmp('smssubject').setValue(publicJSON['strsSub']);

					Ext.getCmp('servicessms').setValue(publicJSON['type4']);
					Ext.getCmp('cmpnamesms').setValue(publicJSON['type1']);
					Ext.getCmp('cmptypesms').setValue(publicJSON['type2']);
					Ext.getCmp('layersms').setValue(publicJSON['type8']);
					Ext.getCmp('alarmIdsms').setValue(publicJSON['type11']);
					if (smsLastValue == 'Yes')
					{
						Ext.getCmp('testsms').setValue(true).disable();
						Ext.getCmp('descriptionsms').setValue(true).disable();
						//Ext.getCmp('lastmeasuresms').show();
						Ext.getCmp('lastmeasuresms').setValue(true).disable();
					}
					else
					{
						Ext.getCmp('testsms').setValue(publicJSON['type5']).enable();
						Ext.getCmp('descriptionsms').setValue(publicJSON['type3']).enable();
						Ext.getCmp('lastmeasuresms').hide();
					}

					Ext.getCmp('measurehostsms').setValue(publicJSON['type7']);
					Ext.getCmp('prioritysms').setValue(publicJSON['type9']);
					Ext.getCmp('probtimesms').setValue(publicJSON['type10']);

					var strsmsseparate = publicJSON['strsmsseparate'];
					if (strsmsseparate == 'Yes')
					{
						Ext.getCmp('sendseparatesmsyes').setValue(true);
					}
					else
					{
						Ext.getCmp('sendseparatesmsno').setValue(true);
					}
				}
			}
		}
	});
}



