Ext.define('MailServerSettings.controller.Main',{
	extend:'Ext.app.Controller',
	requires : [			
	'utilities.ScrollCombo',
	],
	views: ['FormItems'],

	refs: [
		{
			selector:'formitems',
			ref:'formitems'
		},
	],

	init: function() {
		getBtnId = this;
		ValidateBckId = this;
		appnCnt = this;
		this.buildFieldData()

		this.control({
			'formitems': {
				'afterrender': this.afterMainRender
			},
			'formitems radio[id="smtpauthenticationno"]': {
				'change' : this.radSmtpChange
			},
			'formitems radio[id="mailauthenticationno"]': {
				'change' : this.radMailSetChange
			},
			'formitems button[id="updateBtn"]': {
				'click': this.updation
			},
			'formitems button[id="clearupdateBtn"]': {
				'click': this.clearandupdate
			},
			'formitems button[id="validateBtn"]': {
				'click': this.updation
			},
			'formitems > tabpanel': {
				'tabchange': this.tabchange
			},
			'formitems button[id="updateBckBtn"]': {
				'click': this.updationBackUp
			},
			'formitems button[id="addbutton"]': {
				'click': this.addbutton
			},
			'formitems button[id="backButton"]':
			{
				'click':this.goBack
			}
		});
	},

	buildFieldData: function() {
		Ext.Ajax.request({
			url: 'MailServerSettings/data/EgMailServerSettingsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	
	goBack: function()
	{
		if (reqFrom == 'enabletwofa' || reqFrom == 'egmgrmodel')
		{
			window.location.href = backHref+'&select='+reqFrom;
		}
		else
		{
			window.location.href = backHref;
		}
	},

	tabchange: function() {
		var activeTabId = Ext.getCmp('tabformitems').getActiveTab().getId();
		var me = this;
	
		if (activeTabId == 'bckmailsettings')
		{
			Ext.Ajax.request({
			url: 'MailServerSettings/data/EgBackupMailServerJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
		
				var noOfBackUp = publicJSON['noOfBackUp'];
				if (noOfBackUp != "undefined" && noOfBackUp >= 1)
				{
					Ext.getCmp('NoBckMail').hide();
					Ext.getCmp('updateBckBtn').show();
					for (var i=1;i<=noOfBackUp;i++)
					{
						if (hitmailSms == false)
						{
							addContact();
							var authUsrVal = publicJSON['authUsrVal'+i];
							if (authUsrVal != null && !Ext.isEmpty(authUsrVal) && authUsrVal.length > 0 && authUsrVal != "none")
							{
								Ext.getCmp('smtpauthenticationbckyes'+i).setValue(true);
								Ext.getCmp('smtpuserBck'+i).show();
								Ext.getCmp('smtppasswrdBck'+i).show();
								Ext.getCmp('smtpconfirmpassBck'+i).show();

								Ext.getCmp('smtpuserBck'+i).setValue(authUsrVal);
								Ext.getCmp('smtppasswrdBck'+i).setValue(publicJSON['authPassVal'+i]);
								Ext.getCmp('smtpconfirmpassBck'+i).setValue(publicJSON['authPassVal'+i]);
							}
							else
							{
								Ext.getCmp('smtpauthenticationbckno'+i).setValue(true);
								Ext.getCmp('smtpuserBck'+i).hide();
								Ext.getCmp('smtppasswrdBck'+i).hide();
								Ext.getCmp('smtpconfirmpassBck'+i).hide();
							}

							var recvMailIdVal = publicJSON['recvMailIdVal'+i];
							if (recvMailIdVal != null && !Ext.isEmpty(recvMailIdVal) && recvMailIdVal.length > 0 && recvMailIdVal != "none")
							{
								Ext.getCmp('mailauthenticationbckyes'+i).setValue(true);
								Ext.getCmp('mailrcvIdBck'+i).show();
								Ext.getCmp('mailrcvpwdBck'+i).show();
								Ext.getCmp('portforrcvmailBck'+i).show();
								Ext.getCmp('protocolforrcvmailBck'+i).show();
								Ext.getCmp('serverforrcvmailBck'+i).show();

								Ext.getCmp('mailrcvIdBck'+i).setValue(recvMailIdVal);
								Ext.getCmp('mailrcvpwdBck'+i).setValue(publicJSON['recvMailPassVal'+i]);
								Ext.getCmp('portforrcvmailBck'+i).setValue(publicJSON['recvMailPrtVal'+i]);
								Ext.getCmp('protocolforrcvmailBck'+i).setValue(publicJSON['recvMailPrtclVal'+i]);
								Ext.getCmp('serverforrcvmailBck'+i).setValue(publicJSON['recvMailSevrVal'+i]);
							}
							else
							{
								Ext.getCmp('mailauthenticationbckno'+i).setValue(true);
								Ext.getCmp('mailrcvIdBck'+i).hide();
								Ext.getCmp('mailrcvpwdBck'+i).hide();
								Ext.getCmp('portforrcvmailBck'+i).hide();
								Ext.getCmp('protocolforrcvmailBck'+i).hide();
								Ext.getCmp('serverforrcvmailBck'+i).hide();
							}

							Ext.getCmp('smtpmailhostBck'+i).setValue(publicJSON['sndrHstVal'+i]);
							Ext.getCmp('smtpmailportBck'+i).setValue(publicJSON['sndrPrtVal'+i]);
							var smptProtocolVal = publicJSON['smtpPrtclVal'+i];
							if (smptProtocolVal != "" && !Ext.isEmpty(smptProtocolVal) && smptProtocolVal != undefined)
							{
								Ext.getCmp('mailProtocolBck'+i).setValue(smptProtocolVal);
							}
							else
							{
								Ext.getCmp('mailProtocolBck'+i).setValue('SMTP');
							}
						}
					}
				}
				else
				{
					Ext.getCmp('NoBckMail').show();
					var backupcontainer = Ext.getCmp('backupcontainer');
					backupcontainer.removeAll();
					Ext.getCmp('addbutton').setText('Add');
					Ext.getCmp('updateBckBtn').hide();
				}
			}
		});
		}
		if (activeTabId == 'mailsmssettings')
		{
			hitmailSms = true;
		}
		Ext.Ajax.request({
			url: 'MailServerSettings/data/msshelpJson.jsp?activeTabId='+activeTabId,
			method: 'POST',
			async: false
		});
	},

	radSmtpChange: function() {
		var notSmtpAuthen = Ext.getCmp('smtpauthenticationno').getValue();
		if (notSmtpAuthen == true)
		{
			Ext.getCmp('smtpuser').hide();
			Ext.getCmp('smtppasssword').hide();
			Ext.getCmp('smtpconfirmpasssword').hide();
		}
		else
		{
			Ext.getCmp('smtpuser').show();
			Ext.getCmp('smtppasssword').show();
			Ext.getCmp('smtpconfirmpasssword').show();
		}
	},

	radSmtpBckChange: function(position) {
		var notSmtpBckAuthen = Ext.getCmp('smtpauthenticationbckno'+position).getValue();
		if (notSmtpBckAuthen == true)
		{
			Ext.getCmp('smtpuserBck'+position).hide();
			Ext.getCmp('smtppasswrdBck'+position).hide();
			Ext.getCmp('smtpconfirmpassBck'+position).hide();
		}
		else
		{
			Ext.getCmp('smtpuserBck'+position).show();
			Ext.getCmp('smtppasswrdBck'+position).show();
			Ext.getCmp('smtpconfirmpassBck'+position).show();
		}
	},

	radMailSetChange: function() {
		var notmailRcvSettings = Ext.getCmp('mailauthenticationno').getValue();
		if (notmailRcvSettings == true)
		{
			Ext.getCmp('mailrcvId').hide();
			Ext.getCmp('mailrcvpwd').hide();
			Ext.getCmp('portforrcvmail').hide();
			Ext.getCmp('protocolforrcvmail').hide();
			Ext.getCmp('serverforrcvmail').hide();
		}
		else
		{
			Ext.getCmp('mailrcvId').show();
			Ext.getCmp('mailrcvpwd').show();
			Ext.getCmp('portforrcvmail').show();
			Ext.getCmp('protocolforrcvmail').show();
			Ext.getCmp('serverforrcvmail').show();
		}
	},

	radMailBckSetChange: function(position) {
		var notmailBckRcvSettings = Ext.getCmp('mailauthenticationbckno'+position).getValue();
		if (notmailBckRcvSettings == true)
		{
			Ext.getCmp('mailrcvIdBck'+position).hide();
			Ext.getCmp('mailrcvpwdBck'+position).hide();
			Ext.getCmp('portforrcvmailBck'+position).hide();
			Ext.getCmp('protocolforrcvmailBck'+position).hide();
			Ext.getCmp('serverforrcvmailBck'+position).hide();
		}
		else
		{
			Ext.getCmp('mailrcvIdBck'+position).show();
			Ext.getCmp('mailrcvpwdBck'+position).show();
			Ext.getCmp('portforrcvmailBck'+position).show();
			Ext.getCmp('protocolforrcvmailBck'+position).show();
			Ext.getCmp('serverforrcvmailBck'+position).show();
		}
	},

	updation: function() {
		var authpassword = Ext.getCmp('smtppasssword').getValue();
		var $_password = "Password$"+publicJSON['strPwd'];
		var MailReceiverPasswd = Ext.getCmp('mailrcvpwd').getValue();

		var mailhost = Ext.getCmp('smtpmailhost').getValue();
		var mailport = Ext.getCmp('smtpmailport').getValue();
		var mailprotocol = Ext.getCmp('mailProtocol').getValue();
		var mailsender = Ext.getCmp('egadminmailId').getValue();

		var mailsenders = Ext.getCmp('alternatemailid').getValue();
		var revSetConfig = '';
		var revSetConfigVal = Ext.getCmp('mailauthenticationyes').getValue();
		if (revSetConfigVal == true)
		{
			revSetConfig = "true";
		}
		else
		{
			revSetConfig = "false";
		}
		var MailReceiver = Ext.getCmp('mailrcvId').getValue();
		var MailReceiverPasswd = Ext.getCmp('mailrcvpwd').getValue();
		var MailRcvPort = Ext.getCmp('portforrcvmail').getValue();
		var MailRcvProtocol = Ext.getCmp('protocolforrcvmail').getValue();
		var MailRcvServer = Ext.getCmp('serverforrcvmail').getValue();

		var authenticate ="";
		var authenticateValue = Ext.getCmp('smtpauthenticationyes').getValue();
		if (authenticateValue == true)
		{
			authenticate = "true";
		}
		else
		{
			authenticate = "false";
		}
		var user = Ext.getCmp('smtpuser').getValue();

		var measureFlag = publicJSON['measureFlag'];
		var smsMeasureFlag = publicJSON['smsMeasureFlag'];
		var mailSubjectMeasureFlag = publicJSON['mailSubjectMeasureFlag'];

		var me = this;
		var checkValidation = me.validationForMailServers();
	
		if (checkValidation)
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show(); 

			var hiddenObj = Ext.getCmp('hiddencontainer');
			urlLink = "MailServerSettings/data/EgMailServerSettingspJson.jsp?mailhost="+mailhost+"&mailport="+mailport+"&mailprotocol="+mailprotocol;

			var temp = {
				xtype: 'hiddenfield',
				name: 'authpassword',
				value: authpassword,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: '$_password',
				value: $_password,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailReceiverPasswd',
				value: MailReceiverPasswd,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'mailsenders',
				value: mailsenders,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'mailsender',
				value: mailsender,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'revSetConfig',
				value: revSetConfig,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailReceiver',
				value: MailReceiver,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailReceiverPasswd',
				value: MailReceiverPasswd,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailRcvPort',
				value: MailRcvPort,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailRcvProtocol',
				value: MailRcvProtocol,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailRcvServer',
				value: MailRcvServer,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'authenticate',
				value: authenticate,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'user',
				value: user,
			};
			hiddenObj.add(temp);

			var $_mailhost = 'Mail host$'+publicJSON['strHost'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailhost',
				value: $_mailhost,
			};
			hiddenObj.add(temp);

			var $_mailport = 'Mail port$'+publicJSON['strPort'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailport',
				value: $_mailport,
			};
			hiddenObj.add(temp);

			var $_mailprotocol = 'Mail protocol$'+publicJSON['strProtocol'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailprotocol',
				value: $_mailprotocol,
			};
			hiddenObj.add(temp);

			var $_mailsender = 'Admin mail ID$'+publicJSON['strSender'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailsender',
				value: $_mailsender,
			};
			hiddenObj.add(temp);

			var $_mailsenders = 'Mail senders ID$'+publicJSON['mailBuff'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailsenders',
				value: $_mailsenders,
			};
			hiddenObj.add(temp);
			
			var $_authenticate = '';
			var authenticateValueYes = publicJSON['authenticateYes'];
			if (authenticateValueYes == "checked")
			{
				$_authenticate = 'Authenticate$'+"true";
			}
			else
			{
				$_authenticate = 'Authenticate$'+"false";
			}
			temp = {
				xtype: 'hiddenfield',
				name: '$_authenticate',
				value: $_authenticate,
			};
			hiddenObj.add(temp);

			var $_user = 'User$'+publicJSON['strUser'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_user',
				value: $_user,
			};
			hiddenObj.add(temp);

			var $_MailReceiver = 'Mail receiver ID$'+publicJSON['mailReceiver'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailReceiver',
				value: $_MailReceiver,
			};
			hiddenObj.add(temp);

			var $_MailReceiverPasswd = 'Mail receiver password$'+publicJSON['mailReceiverPasswd'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailReceiverPasswd',
				value: $_MailReceiverPasswd,
			};
			hiddenObj.add(temp);

			var $_MailRcvPort = 'Port used for receiving mails$'+publicJSON['mailRcvPort'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailRcvPort',
				value: $_MailRcvPort,
			};
			hiddenObj.add(temp);

			var $_MailRcvProtocol = 'Protocol for receiving mails$'+publicJSON['mailRcvProtocol'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailRcvProtocol',
				value: $_MailRcvProtocol,
			};
			hiddenObj.add(temp);

			var $_MailRcvServer = 'Server for receiving mails$'+publicJSON['mailRcvServer'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailRcvServer',
				value: $_MailRcvServer,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'measureFlag',
				value: measureFlag,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'smsMeasureFlag',
				value: smsMeasureFlag,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'mailSubjectMeasureFlag',
				value: mailSubjectMeasureFlag,
			};
			hiddenObj.add(temp);

			var MailServerSetObj = Ext.getCmp('formitems').getForm();
			MailServerSetObj.submit({
			url: urlLink,
			method: 'POST',
			standardSubmit: false,
			success: function( form,action )
			{
				myMask.hide(); 
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show(
						{
							title : resultStatus['title'],
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : loadingData
						});
					}
				}
				hiddenObj.removeAll();
			},
			failure: function()
			{
				myMask.hide(); 
				hiddenObj.removeAll();
			}
		});
		}
	},
	 
	validateMailSettings: function() { 
		var mail_host = Ext.getCmp('smtpmailhost').getValue();
		var mail_port = Ext.getCmp('smtpmailport').getValue();
		var mail_protocol = Ext.getCmp('mailProtocol').getValue();
		var user = Ext.getCmp('smtpuser').getValue();
		var pwd = Ext.getCmp('smtppasssword').getValue();
		var mailSenderValue = Ext.getCmp('egadminmailId').getValue();
		var mailrecvID = Ext.getCmp('mailrcvId').getValue();
		var MailReceiverPasswd = Ext.getCmp('mailrcvpwd').getValue();
		var MailRcvPort = Ext.getCmp('portforrcvmail').getValue();
		var MailRcvProtocol = Ext.getCmp('protocolforrcvmail').getValue();
		var MailRcvServer = Ext.getCmp('serverforrcvmail').getValue();

		var authenticate;
		var authenUser = Ext.getCmp('smtpauthenticationyes').getValue();
		if (authenUser == true)
		{
			authenticate = "true";
		}
		else
		{
			authenticate = "false";
		}

		var mailRecvSetting;
		var mailRecvSetter = Ext.getCmp('mailauthenticationyes').getValue();
		if (mailRecvSetter == true)
		{
			mailRecvSetting = "true";
		}
		else
		{
			mailRecvSetting = "false";
		}

		var urlPath = "/final/admin/MailServerSettings/data/sendMailAlertJson.jsp?activeTabId=mailsmssettings";
		params="option=send&mailSenderHost="+mail_host+"&mailport="+mail_port+"&mailProtocol="+mail_protocol+"&mailSender="+mailSenderValue+"&authentication="+authenticate+"&mailUser="+encodeURIComponent(user,"UTF-8")+"&mailPassword="+encodeURIComponent(pwd,"UTF-8")+"&revSetConfig="+mailRecvSetting+"&receiverId="+mailrecvID+"&receiverPassword="+encodeURIComponent(MailReceiverPasswd,"UTF-8")+"&receiverPort="+MailRcvPort+"&mailRecverProtocol="+encodeURIComponent(MailRcvProtocol,"UTF-8")+"&receiverHost="+MailRcvServer+"&currentDate="+ new Date().getTime();
		this.loadAlertDiv(urlPath,params);
	},

	validateMailBckUpSettings: function(Host,Port,authBck,sndrrUsr,sndrrPass,sndconfrrPass,revvsettng,rccvId,rccvPass,rccvPrt,rccvPrtcl,rccvSevr,protocl) { 
		var mail_host = Ext.getCmp(Host).getValue();
		var mail_port = Ext.getCmp(Port).getValue();
		var mail_protocol = Ext.getCmp(protocl).getValue();
		var user = Ext.getCmp(sndrrUsr).getValue();
		var pwd = Ext.getCmp(sndrrPass).getValue();
		var mailrecvID = Ext.getCmp(rccvId).getValue();
		var MailReceiverPasswd = Ext.getCmp(rccvPass).getValue();
		var MailRcvPort = Ext.getCmp(rccvPrt).getValue();
		var MailRcvProtocol = Ext.getCmp(rccvPrtcl).getValue();
		var MailRcvServer = Ext.getCmp(rccvSevr).getValue();
		var mailSenderValue = Ext.getCmp('egadminmailId').getValue();
		var authenticate = "";
		var authBckk = Ext.getCmp(authBck).getValue();
		if (authBckk == true)
		{
			authenticate = "true";
		}
		else
		{
			authenticate = "false";
		}

		var mailRecvSetting = "";
		var revvsettng = Ext.getCmp(revvsettng).getValue();
		if (revvsettng == true)
		{
			mailRecvSetting = "true";
		}
		else
		{
			mailRecvSetting = "false";
		}

		var urlPath = "/final/admin/MailServerSettings/data/sendMailAlertJson.jsp?activeTabId=bckmailsettings";
		params="option=send&mailSenderHost="+mail_host+"&mailport="+mail_port+"&mailProtocol="+mail_protocol+"&mailSender="+mailSenderValue+"&authentication="+authenticate+"&mailUser="+encodeURIComponent(user,"UTF-8")+"&mailPassword="+encodeURIComponent(pwd,"UTF-8")+"&revSetConfig="+mailRecvSetting+"&receiverId="+mailrecvID+"&receiverPassword="+encodeURIComponent(MailReceiverPasswd,"UTF-8")+"&receiverPort="+MailRcvPort+"&mailRecverProtocol="+encodeURIComponent(MailRcvProtocol,"UTF-8")+"&receiverHost="+MailRcvServer+"&currentDate="+ new Date().getTime();
		this.loadAlertDiv(urlPath,params);
	},

	loadAlertDiv: function(urlPath,params) { 
		var me = this;
		var validationLoadingMsg2 = "<table width='100%' border='0' height='90px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td vlaign=top width='50%' style='text-align:center;font-size:12px'>"+validate+".</td></tr></table>";
		Ext.widget('window',{
			extend:'Ext.panel.Panel',
			title : validate,
			listeners : {
				afterrender : function()
				{
					me.validateMailCredentials(urlPath,params);
				}
			},
			closeAction: 'destory',
			id : 'validateVcenterServer',
			height: 140,
			align : 'center',
			width: 350,
			padding:'5 10 10 10',
			modal: true,
			//autoScroll : true,
			//scroll : true,
			doClose: function() {
				this.destroy();
			},
			items : [
				{
					id : 'resultContainerStr',
					border : false,
					height: 128,
					style:{'text-align':'center'},
					html:validationLoadingMsg2+'.',
				}
			]
		}).show();
	},
	
	validateMailCredentials: function(urlPath,params) { 
		var tmpData = '';
		Ext.Ajax.request({
			url : urlPath,
			params: params,
			method: 'POST',
			success: function(response)
			{
				var tmpText = response.responseText;
				var resultContainerStr = Ext.getCmp('resultContainerStr');
				resultContainerStr.update(tmpText);
			}
		});
	},

	clearandupdate: function() {
		Ext.MessageBox.show({
			title : "MAIL SERVER SETTINGS",
			msg : deleteMsg,
			fn : this.clearUpdate,
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			scope : this
		});
	},

	clearUpdate: function(btn) {
		if (btn == 'yes')
		{
			var authpassword = "";
			var $_password = "Password$"+publicJSON['strPwd'];

			var mailhost = "";
			var mailport = "";
			var mailprotocol = "";
			var mailsender = "";

			var mailsenders = "";
			var revSetConfig = "false";
			var MailReceiver = "";
			var MailReceiverPasswd = "";
			var MailRcvPort = "";
			var MailRcvProtocol = "";
			var MailRcvServer = "";

			var authenticate = "false";
			var user = "";

			var measureFlag = publicJSON['measureFlag'];
			var smsMeasureFlag = publicJSON['smsMeasureFlag'];
			var mailSubjectMeasureFlag = publicJSON['mailSubjectMeasureFlag'];

			var hiddenObj = Ext.getCmp('hiddencontainer');
			urlLink = "MailServerSettings/data/EgMailServerSettingspJson.jsp?mailhost="+mailhost+"&mailport="+mailport+"&mailprotocol="+mailprotocol+"&mailsender="+mailsender+"&clearSet=true";

			var temp = {
				xtype: 'hiddenfield',
				name: 'authpassword',
				value: authpassword,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: '$_password',
				value: $_password,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailReceiverPasswd',
				value: MailReceiverPasswd,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'mailsenders',
				value: mailsenders,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'revSetConfig',
				value: revSetConfig,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailReceiver',
				value: MailReceiver,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailReceiverPasswd',
				value: MailReceiverPasswd,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailRcvPort',
				value: MailRcvPort,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailRcvProtocol',
				value: MailRcvProtocol,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'MailRcvServer',
				value: MailRcvServer,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'authenticate',
				value: authenticate,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'user',
				value: user,
			};
			hiddenObj.add(temp);

			var $_mailhost = 'Mail host$'+publicJSON['strHost'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailhost',
				value: $_mailhost,
			};
			hiddenObj.add(temp);

			var $_mailport = 'Mail port$'+publicJSON['strPort'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailport',
				value: $_mailport,
			};
			hiddenObj.add(temp);

			var $_mailprotocol = 'Mail protocol$'+publicJSON['strProtocol'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailprotocol',
				value: $_mailprotocol,
			};
			hiddenObj.add(temp);

			var $_mailsender = 'Admin mail ID$'+publicJSON['strSender'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailsender',
				value: $_mailsender,
			};
			hiddenObj.add(temp);

			var $_mailsenders = 'Mail senders ID$'+publicJSON['mailBuff'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_mailsenders',
				value: $_mailsenders,
			};
			hiddenObj.add(temp);
			
			var $_authenticate = '';
			var authenticateValueYes = publicJSON['authenticateYes'];
			if (authenticateValueYes == "checked")
			{
				$_authenticate = 'Authenticate$'+"true";
			}
			else
			{
				$_authenticate = 'Authenticate$'+"false";
			}
			temp = {
				xtype: 'hiddenfield',
				name: '$_authenticate',
				value: $_authenticate,
			};
			hiddenObj.add(temp);

			var $_user = 'User$'+publicJSON['strUser'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_user',
				value: $_user,
			};
			hiddenObj.add(temp);

			var $_MailReceiver = 'Mail receiver ID$'+publicJSON['mailReceiver'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailReceiver',
				value: $_MailReceiver,
			};
			hiddenObj.add(temp);

			var $_MailReceiverPasswd = 'Mail receiver password$'+publicJSON['mailReceiverPasswd'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailReceiverPasswd',
				value: $_MailReceiverPasswd,
			};
			hiddenObj.add(temp);

			var $_MailRcvPort = 'Port used for receiving mails$'+publicJSON['mailRcvPort'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailRcvPort',
				value: $_MailRcvPort,
			};
			hiddenObj.add(temp);

			var $_MailRcvProtocol = 'Protocol for receiving mails$'+publicJSON['mailRcvProtocol'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailRcvProtocol',
				value: $_MailRcvProtocol,
			};
			hiddenObj.add(temp);

			var $_MailRcvServer = 'Server for receiving mails$'+publicJSON['mailRcvServer'];
			temp = {
				xtype: 'hiddenfield',
				name: '$_MailRcvServer',
				value: $_MailRcvServer,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'measureFlag',
				value: measureFlag,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'smsMeasureFlag',
				value: smsMeasureFlag,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'mailSubjectMeasureFlag',
				value: mailSubjectMeasureFlag,
			};
			hiddenObj.add(temp);

			var MailServerSetObj = Ext.getCmp('formitems').getForm();
			MailServerSetObj.submit({
			url: urlLink,
			method: 'POST',
			async: false,
			standardSubmit: false,
			success: function( form,action )
			{
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show(
						{
							title : resultStatus['title'],
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : loadingData
						});
						updateBckFun();
					}
				}
				hiddenObj.removeAll();
			},
				failure: function()
			{
				hiddenObj.removeAll();
			}
		});
		}

	},

	validationForMailServers: function() {
		var callCheckUsr = this;
		if (getBtnId == 'validateBtn')
		{
			Validate = true;
		}
		else
		{
			Validate = false;
		}
		var mail_host = Ext.getCmp('smtpmailhost').getValue();
		var mail_port = Ext.getCmp('smtpmailport').getValue();
		var user = Ext.getCmp('smtpuser').getValue();
		var pwd = Ext.getCmp('smtppasssword').getValue();

		var mailsendersIds = Ext.getCmp('alternatemailid').getValue();
		var mailsender = Ext.getCmp('egadminmailId').getValue();
		var proceedFlag = true;
		var tempResult;

		if (mailsendersIds.length > 0)
		{
			var mailIDs = mailsendersIds.replace("\r","").split("\n");
			for (var i=0;i<mailIDs.length && mailIDs[i] !="";i++)
			{
				var tempString = trim(mailIDs[i]);
				tempResult = validateEmail(tempString);
				if(!validateSingleByte(mailIDs[i]))
				{
					Ext.Msg.show({
						title : PageTitle,
						msg : singleByte_mailIds,
						icon : 'iconExclamation',
						buttons:Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('alternatemailid').focus(true);
						}
					});
					proceedFlag = false;
					return;
				}
				else if(tempResult == null || tempResult == undefined || tempResult == false )//if(tempResult == null || tempResult != tempString)
				{
					Ext.Msg.show({
						title : PageTitle,
						msg : alternate_mailId+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('alternatemailid').focus(true);
						}
					});
					proceedFlag = false;
					break;
				}
			}
		}

		var numbers = "0123456789 ";
		var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		var check_char = "";
		var check_num = "";
		var flag = "false";
		var mail_protocol = Ext.getCmp('mailProtocol').getValue();

		if(mail_host != "" && mail_host.length > 0)
		{
			for(var m=0; m< mail_host.length; m++)
			{
				check_char = alpha.indexOf(mail_host.charAt(m))
				check_num = numbers.indexOf(mail_host.charAt(m))
				//Returns value 1 if the character listed is found
				if(check_char >= 1)
				{
					flag = "true";
					break;
				}
				else if(check_num >= 1)
				{
					flag = "false";
					break;
				}
			}
		}
		if (!callCheckUsr.checkUserPwd())
		{
			return;
		}
		if(!callCheckUsr.receiverAuthentication())
		{
			return;
		}
		var mailSenderValue = Ext.getCmp('egadminmailId').getValue();
		var result = validateEmail(mailSenderValue);

		var validateMailHostVar = validateMailHostExtjs(mail_host);

		if (!checkblank(mail_host))
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : mailHost_Bnk+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else if(checkspaceExtjs(mail_port) == '17')
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : _checkblank+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(!checkdots(mail_port))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailPortDot+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(checkSpecialExtjs(mail_port,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/") == '7')
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkspecial+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(!checknumber("+",mail_port))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : validMailPort,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(checkfordecimalExtjs(mail_port) == '18')
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkfordecimal,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(mail_port == "0")
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : validInt+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(mail_port > 99999)
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : invalidPrt+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(checkSpecialExtjs(mail_host,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/") == '7')
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkspecial+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else if(!validateSingleByte(mail_host))
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : mailHstDBL+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(!checkblank(mailsender))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailRcv_valid+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if(!validateSingleByte(mailsender))
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : mailIDDBL+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if(result == null || result == undefined || result == false)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailRcv_valid+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if (mailsender.indexOf(',') != -1)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mail_valid+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if(flag == "true")
		{
			if(checkspaceExtjs(mail_host) == '17')
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : _checkblank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
			else if(!checkdots(mail_host))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : mailDot+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
			else
			{
				if (proceedFlag)
				{
					if (!Validate)
					{
						return true;
					}
					else
					{
						callCheckUsr.validateMailSettings();
					}
				}
			}
		}
		else if(!checkdots(mail_host))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailDot+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else if(validateMailHostVar != "0")
		{
			if(validateMailHostVar == "19")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _validateMailHost+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
			else if(validateMailHostVar == "10")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _checknum+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
		}
		else if(checkspaceExtjs(mail_host) == "17")
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkblank+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else
		{
			if (proceedFlag)
			{
				if (!Validate)
				{
					return true;
				}
				else
				{
					callCheckUsr.validateMailSettings();
				}
			}
		}
	},

	checkUserPwd: function() {
		var smtpAuthenYes = Ext.getCmp('smtpauthenticationyes').getValue();
		if (smtpAuthenYes == true)
		{
			var user = Ext.getCmp('smtpuser').getValue();
			var pwd = Ext.getCmp('smtppasssword').getValue();
			var conf = Ext.getCmp('smtpconfirmpasssword').getValue();
			var auth_usr=true;
			var auth_pwd=true;
			var checkSpecialVar = checkSpecialExtjs(user,"*+=|:;\"\'<>\/[]?,");
			if(isDouble == "false")
			{
				auth_usr= validateSingleByte(user);
				auth_pwd= validateSingleByte(pwd);
			}
			if (user == "null")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : userField+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if (user=="")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : userField_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
							Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if(user!=null && checkSpecialVar == '7')
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _checkspecial+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if(user!=null && trim(user) == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : Field_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if(user!=null && user.indexOf("..") > -1)
			{
				Ext.Msg.alert(_checkdots);
				Ext.getCmp('smtpuser').focus(true);
				return false;
			}
			else if (user != null && user.indexOf("  ") > -1)
			{
				Ext.Msg.alert(_checkSpaces);
				Ext.getCmp('smtpuser').focus(true);
				return false;
			}
			else if(!auth_usr)
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : auth_userByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if (pwd =="null")
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : passField+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if (pwd == "")
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : passField_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if (pwd != conf)
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : pass_Match+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if(!checkspecialnomess(pwd,"\'\"}~|"))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : passNotBeUsed+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if(!auth_pwd)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : passwordByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			return true;
		}
		else
		{
			return true;
		}
	},

	receiverAuthentication: function() {
		var revSetConfig = Ext.getCmp('mailauthenticationyes').getValue();
		if (revSetConfig == true)
		{
			var receiverId = Ext.getCmp('mailrcvId').getValue();
			var resultForRecId=validateEmail(receiverId);
			var recPort= Ext.getCmp('portforrcvmail').getValue(); 
			var recPwd= Ext.getCmp('mailrcvpwd').getValue();
			var MailRcvProtocol= Ext.getCmp('protocolforrcvmail').getValue();
			var serverForMail= Ext.getCmp('serverforrcvmail').getValue();

			if(!checkblank(receiverId))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : mailRcv_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvId').focus(true);
					}
				});
				return false;
			}
			else if(resultForRecId == null || resultForRecId == undefined || resultForRecId == false)
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : mailRcv_valid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvId').focus(true);
					}
				});
				return false;
			}
			else if (recPwd =="null")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPass+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn :function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if (recPwd == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : RcvPass_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if(!checkspecialnomess(recPwd,"\'\"}~|"))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : RcvChPass+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(recPwd))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : RcvPassByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if(isNaN(recPort))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : "' "+recPort+" '  " + notValidNo+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('portforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(isValid(recPort))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : notValidPort+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('portforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(MailRcvProtocol=="")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPrt+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('protocolforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(MailRcvProtocol))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPrtDBL+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('protocolforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!checkblank(serverForMail))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailSrv_bnk+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(checkSpecialExtjs(serverForMail,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/") == '7')
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _checkspecial+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(serverForMail))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailDBL+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!checkdots(serverForMail))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailDot+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else
			{
				return true;
			}
		}
		else
		{
			return true;
		}
	},

	updationBackUp: function() {
		var checkBackUpValidation = false;
		var hostAndPortList = new Array();
		var listCunt = 0;
		var addInputs = inputs;
		var backupMailserverEntries = "";
		for (var k=0;k<addInputs;k++ )
		{
			if (Ext.getCmp('mailProtocolBck'+k) == undefined)
			{
				continue;
			}
			var smtpHHost = Ext.getCmp('smtpmailhostBck'+k).getValue();
			var smtpPPort = Ext.getCmp('smtpmailportBck'+k).getValue();

			var smtpPrtcl = Ext.getCmp('mailProtocolBck'+k).getValue();
			var authenBck = Ext.getCmp('smtpauthenticationbckyes'+k).getValue();

			var authen = '';
			var sndrUsr = '';
			var sndrPass = '';
			var sndconfrPass = '';
			if (authenBck == true)
			{
				authen = 'Yes';
				sndrUsr = Ext.getCmp('smtpuserBck'+k).getValue();
				sndrPass = Ext.getCmp('smtppasswrdBck'+k).getValue();
				sndconfrPass = Ext.getCmp('smtpconfirmpassBck'+k).getValue();
			}
			else
			{
				authen = 'No';
				sndrUsr = 'none';
				sndrPass = 'none';
			}

			var revsett = '';
			var rcvId = '';
			var rcvPass = '';
			var rcvPrt = '';
			var rcvPrtcl = '';
			var revsettng = Ext.getCmp('mailauthenticationbckyes'+k).getValue();
			if (revsettng == true)
			{
				revsett = "Yes";
				rcvId = Ext.getCmp('mailrcvIdBck'+k).getValue();
				rcvPass = Ext.getCmp('mailrcvpwdBck'+k).getValue();
				rcvPrt = Ext.getCmp('portforrcvmailBck'+k).getValue();
				rcvPrtcl = Ext.getCmp('protocolforrcvmailBck'+k).getValue();
				rcvSevr = Ext.getCmp('serverforrcvmailBck'+k).getValue();
			}
			else
			{
				revsett = "No";
				rcvId = "none";
				rcvPass = "none";
				rcvPrt = "none";
				rcvPrtcl = "none";
				rcvSevr = "none";
			}
			hostAndPortList[listCunt] = smtpHHost+":"+smtpPPort;

			if (checkForSameHost(hostAndPortList))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : samePortHost+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return;
			}

			var me = this;
			checkBackUpValidation = me.validationForMailBackUp('smtpmailhostBck'+k,'smtpmailportBck'+k,'smtpauthenticationbckyes'+k,'smtpuserBck'+k,'smtppasswrdBck'+k,'smtpconfirmpassBck'+k,'mailauthenticationbckyes'+k,'mailrcvIdBck'+k,'mailrcvpwdBck'+k,'portforrcvmailBck'+k,'protocolforrcvmailBck'+k,'serverforrcvmailBck'+k,'mailProtocolBck'+k,k);

			if (!checkBackUpValidation)
			{
				break;
			}

			backupMailserverEntries += smtpHHost+":"+smtpPPort+"="+authen+"~|~"+sndrUsr+"~|~"+sndrPass+"~|~"+smtpPrtcl+"~|~"+revsett+"~|~"+rcvId+"~|~"+rcvPass+"~|~"+rcvPrt+"~|~"+rcvPrtcl+"~|~"+rcvSevr+"~#~";
			listCunt++;
		}

		if ( backupMailserverEntries != null && backupMailserverEntries.indexOf('~#~') > -1)
		{
			backupMailserverEntries = backupMailserverEntries.substring(0,backupMailserverEntries.lastIndexOf("~#~"));
		}
		var urlLinkBck = "MailServerSettings/data/EgBackupMailServerpJson.jsp?activeTabId=bckmailsettings&paramForBackMailSvr="+encodeURIComponent(backupMailserverEntries,'UTF-8');
	
		if (checkBackUpValidation)
		{
			Ext.Ajax.request({
				url: urlLinkBck,
				method: 'POST',
				async: false,
				success: function( response )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resultStatus = publicJSON['result'];
							Ext.MessageBox.show({
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons:Ext.Msg.OK
							});
						}
					}
				}
			});
		}
	},

	validationForMailBackUp: function(Host,Port,authBck,sndrrUsr,sndrrPass,sndconfrrPass,revvsettng,rccvId,rccvPass,rccvPrt,rccvPrtcl,rccvSevr,protocl,k) {
		var callBckupCheckUsr = this;

		if (ValidateBckId == 'validateBckBtn'+k)
		{
			ValidateBck = true;
		}
		else
		{
			ValidateBck = false;
		}

		var smtpHHost = Ext.getCmp(Host).getValue();
		var smtpPPort = Ext.getCmp(Port).getValue();

		var proceedFlag = true;
		var tempResult;

		var numbers = "0123456789 ";
		var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		var check_char = "";
		var check_num = "";
		var flag = "false";

		if(smtpHHost != "" && smtpHHost.length > 0)
		{
			for(var m=0; m< smtpHHost.length; m++)
			{
				check_char = alpha.indexOf(smtpHHost.charAt(m))
				check_num = numbers.indexOf(smtpHHost.charAt(m))
				//Returns value 1 if the character listed is found
				if(check_char >= 1)
				{
					flag = "true";
					break;
				}
				else if(check_num >= 1)
				{
					flag = "false";
					break;
				}
			}
		}

		if (!checkblank(smtpHHost))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailHost_Bnk+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp(Host).focus(true);
				}
			});
			return false;
		}
		else if(!checkspace(smtpPPort))
		{
			return false;
		}
		else if(!checkdots(smtpPPort))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailPortDot +'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn :function(btn){
					Ext.getCmp(Port).focus(true);
				}
			});
			return false;
		}
		else if(!checkspecial(smtpPPort,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
		{
			Ext.getCmp(Port).focus(true);
			return false;
		}
		else if(!checknumber("+",smtpPPort))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : validMailPort+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp(Port).focus(true);
				}
			});
			return false;
		}
		else if(!checkfordecimal(smtpPPort))
		{
			Ext.getCmp(Port).focus(true);
			return false;
		}
		else if(smtpPPort == "0")
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : validInt+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp(Port).focus(true);
				}
			});
			return false;
		}
		else if(smtpPPort > 99999)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : invalidPrt+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp(Port).focus(true);
				}
			});
			return false;
		}
		else if(!checkspecial(smtpHHost,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
		{
			Ext.getCmp(Host).focus(true);
			return false;
		}
		else if(!validateSingleByte(smtpHHost))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailHstDBL+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp(Host).focus(true);
				}
			});
			return false;
		}
		else if (!callBckupCheckUsr.checkBckUpUserPwd(authBck,sndrrUsr,sndrrPass,sndconfrrPass))
		{
			return false;
		}
		else if(!callBckupCheckUsr.receiverBckUpAuthentication(revvsettng,rccvId,rccvPass,rccvPrt,rccvPrtcl,rccvSevr))
		{
			return false;
		}
		else if(flag == "true")
		{
			if(!checkspace(smtpHHost))
			{
				Ext.getCmp(Host).focus(true);
				return false;
			}
			else if(!checkdots(smtpHHost))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailDot+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(Host).focus(true);
					}
				});
				return false;
			}
			else
			{
				if (proceedFlag)
				{
					if (!ValidateBck)
					{
						return true;
					}
					else
					{
						callBckupCheckUsr.validateMailBckUpSettings(Host,Port,authBck,sndrrUsr,sndrrPass,sndconfrrPass,revvsettng,rccvId,rccvPass,rccvPrt,rccvPrtcl,rccvSevr,protocl);
					}
				}
			}
		}
		else if(!checkdots(smtpHHost))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailDot+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp(Host).focus(true);
				}
			});
			return false;
		}
		else if(!validateMailHost(smtpHHost))
		{
			Ext.getCmp(Host).focus(true);
			return false;
		}
		else if(!checkspace(smtpHHost))
		{
			Ext.getCmp(Host).focus(true);
			return false;
		}
		else
		{
			if (proceedFlag)
			{
				if (!ValidateBck)
				{
					return true;
				}
				else
				{
					callBckupCheckUsr.validateMailBckUpSettings(Host,Port,authBck,sndrrUsr,sndrrPass,sndconfrrPass,revvsettng,rccvId,rccvPass,rccvPrt,rccvPrtcl,rccvSevr,protocl);
				}
			}
		}
	},

	checkBckUpUserPwd: function(authBck,sndrrUsr,sndrrPass,sndconfrrPass) {
		var authenBck = Ext.getCmp(authBck).getValue();
		if (authenBck == true)
		{
			var sndrUsr = Ext.getCmp(sndrrUsr).getValue();
			var sndrPass = Ext.getCmp(sndrrPass).getValue();
			var sndconfrPass = Ext.getCmp(sndconfrrPass).getValue();

			var auth_usr=true;
			var auth_pwd=true;
			if(isDouble == "false")
			{
				auth_usr= validateSingleByte(sndrUsr);
				auth_pwd= validateSingleByte(sndrPass);
			}
			if (sndrUsr == "null")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : userField+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrUsr).focus(true);
					}
				});
				return false;
			}
			else if (sndrUsr == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : userField_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrUsr).focus(true);
					}
				});
				return false;
			}
			else if(sndrUsr != null && !checkspecial(sndrUsr,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp(sndrrUsr).focus(true);
				return false;
			}
			else if(sndrUsr!=null && trim(sndrUsr) == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : Field_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrUsr).focus(true);
					}
				});
				return false;
			}
			else if(sndrUsr != null && sndrUsr.indexOf("..") > -1)
			{
				Ext.Msg.alert(_checkdots);
				return false;
			}
			else if (sndrUsr != null && sndrUsr.indexOf("  ") > -1)
			{
				Ext.Msg.alert(_checkSpaces);
				return false;
			}
			else if(!auth_usr)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : auth_userByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrUsr).focus(true);
					}
				});
				return false;
			}
			else if (sndrPass =="null")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : passField+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrPass).focus(true);
					}
				});
				return false;
			}
			else if (sndrPass == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : passField_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrPass).focus(true);
					}
				});
				return false;
			}
			else if (sndrPass != sndconfrPass)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : pass_Match+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrPass).focus(true);
					}
				});
				return false;
			}
			else if(!checkspecialnomess(sndrPass,"\'\"}~|"))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : passNotBeUsed+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrPass).focus(true);
					}
				});
				return false;
			}
			else if(!auth_pwd)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : passwordByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(sndrrPass).focus(true);
					}
				});
				return false;
			}
			return true;
		}
		else
		{
			return true;
		}
	},

	receiverBckUpAuthentication : function(revvsettng,rccvId,rccvPass,rccvPrt,rccvPrtcl,rccvSevr) {
		var revsettng = Ext.getCmp(revvsettng).getValue();
		if (revsettng == true)
		{
			var rcvId = Ext.getCmp(rccvId).getValue();
			var rcvPass = Ext.getCmp(rccvPass).getValue();
			var rcvPrt = Ext.getCmp(rccvPrt).getValue();
			var rcvPrtcl = Ext.getCmp(rccvPrtcl).getValue();
			var rcvSevr = Ext.getCmp(rccvSevr).getValue();

			var resultForRecId = validateEmail(rcvId);

			if(!checkblank(rcvId))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcv_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
			else if(resultForRecId == null || resultForRecId == undefined || resultForRecId == false)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcv_mailvalid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvId).focus(true);
					}
				});
				return false;
			}
			else if (rcvPass =="null")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPass+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPass).focus(true);
					}
				});
				return false;
			}
			else if (rcvPass == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : RcvPass_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPass).focus(true);
					}
				});
				return false;
			}
			else if(!checkspecialnomess(rcvPass,"\'\"}~|"))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : RcvChPass+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPass).focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(rcvPass))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : RcvPassByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPass).focus(true);
					}
				});
				return false;
			}
			else if(isNaN(rcvPrt))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : "' "+rcvPrt+" '  " + notValidNo+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPrt).focus(true);
					}
				});
				return false;
			}
			else if(isValid(rcvPrt))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : notValidPort+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPrt).focus(true);
					}
				});
				return false;
			}
			else if(rcvPrtcl == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPrt+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPrtcl).focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(rcvPrtcl))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPrtDBL+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvPrtcl).focus(true);
					}
				});
				return false;
			}
			else if(!checkblank(rcvSevr))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailSrv_bnk+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvSevr).focus(true);
					}
				});
				return false;
			}
			else if(!checkspecial(rcvSevr,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
			{
				Ext.getCmp(rccvSevr).focus(true);
				return false;
			}
			else if(!validateSingleByte(rcvSevr))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailDBL+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvSevr).focus(true);
					}
				});
				return false;
			}
			else if(!checkdots(rcvSevr))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailDot+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp(rccvSevr).focus(true);
					}
				});
				return false;
			}
			else
			{
				return true;
			}
		}
		else
		{
			return true;
		}
	},

	initializeFields : function() {
		var me = this;
		var executiveForm = this.getFormitems().getForm();
		var selectedProtocol = publicJSON['strProtocol'];
		if (selectedProtocol != null && selectedProtocol.length > 0 && selectedProtocol != "")
		{
			me.setValueWithOptionInList(executiveForm, 'mailProtocol', publicJSON['protocolArray'],selectedProtocol);
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'mailProtocol', publicJSON['protocolArray'],'SMTP');
		}
	},

	setValueWithOptionInList : function(form, fieldName, list, value) {
		Ext.getCmp(fieldName).getStore().loadRawData(list);
		Ext.getCmp(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				Ext.getCmp(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		
		if(!valueAssigned){
			Ext.getCmp(fieldName).setValue(list[0].valueField);
		}
		Ext.getCmp(fieldName).resumeEvents();
	},

	afterMainRender : function() {
		if (reqFrom == 'enabletwofa' || reqFrom == 'egmgrmodel')
		{
			Ext.getCmp('backButton').show();
		}
		this.initializeFields();
		var strUser = publicJSON['strUser'];
		if (strUser != null && !Ext.isEmpty(strUser) && strUser.length > 0)
		{
			Ext.getCmp('smtpauthenticationyes').setValue(true);
			Ext.getCmp('smtpuser').show();
			Ext.getCmp('smtppasssword').show();
			Ext.getCmp('smtpconfirmpasssword').show();

			Ext.getCmp('smtpuser').setValue(strUser);
			Ext.getCmp('smtppasssword').setValue(publicJSON['strPwd']);
			Ext.getCmp('smtpconfirmpasssword').setValue(publicJSON['strPwd']);
		}
		else
		{
			Ext.getCmp('smtpuser').hide();
			Ext.getCmp('smtppasssword').hide();
			Ext.getCmp('smtpconfirmpasssword').hide();
		}

		var mailReceiver = publicJSON['mailReceiver'];
		if (mailReceiver != null && !Ext.isEmpty(mailReceiver) && mailReceiver.length > 0)
		{
			Ext.getCmp('mailauthenticationyes').setValue(true);
			Ext.getCmp('mailrcvId').show();
			Ext.getCmp('mailrcvpwd').show();
			Ext.getCmp('portforrcvmail').show();
			Ext.getCmp('protocolforrcvmail').show();
			Ext.getCmp('serverforrcvmail').show();

			Ext.getCmp('mailrcvId').setValue(mailReceiver);
			Ext.getCmp('mailrcvpwd').setValue(publicJSON['mailReceiverPasswd']);
			Ext.getCmp('portforrcvmail').setValue(publicJSON['mailRcvPort']);
			Ext.getCmp('protocolforrcvmail').setValue(publicJSON['mailRcvProtocol']);
			Ext.getCmp('serverforrcvmail').setValue(publicJSON['mailRcvServer']);
		}
		else
		{
			Ext.getCmp('mailrcvId').hide();
			Ext.getCmp('mailrcvpwd').hide();
			Ext.getCmp('portforrcvmail').hide();
			Ext.getCmp('protocolforrcvmail').hide();
			Ext.getCmp('serverforrcvmail').hide();
		}

		Ext.getCmp('smtpmailhost').setValue(publicJSON['strHost']);
		if (publicJSON['strPort'] == "")
		{
			publicJSON['strPort'] = 25;
		}
		Ext.getCmp('smtpmailport').setValue(publicJSON['strPort']);
		Ext.getCmp('egadminmailId').setValue(publicJSON['strSender']);
		Ext.getCmp('alternatemailid').setValue(publicJSON['mailBuff']);

		var smtpMHost = publicJSON['strHost'];
		var smtpMPort = publicJSON['strPort'];
		var smtpMSender = publicJSON['strSender'];

		if ((smtpMHost != null && !Ext.isEmpty(smtpMHost) && smtpMHost != "") && (smtpMPort != null && !Ext.isEmpty(smtpMPort) && smtpMPort != "") && (smtpMSender != null && !Ext.isEmpty(smtpMSender) && smtpMSender != ""))
		{
			Ext.getCmp('bckmailsettings').enable();
		}
		else
		{
			Ext.getCmp('bckmailsettings').disable();
		}
	},

	addbutton: function() {
		addContact();
	},

});

function isValid(val) {
	if(val.length==0||val.indexOf('0')==0)
	{
		return "false";
	}
	if(parseInt(val)<=0)
	{
		return "false";
	}
}

function checkdots(fieldvalue) {
	var val = fieldvalue;
	if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
	{
		return false;
	}
	else
	{
		for(var k=0;k < val.length;k++)
		{
			if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : noDots+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
			else
			{
				continue;
			}
		}
	}
	return true;
}

function trim(stringToTrim) {
	return stringToTrim.replace(/^\s+|\s+$/g,"");
}

function loadingData(btn) {
	Ext.Ajax.request({
	url: 'MailServerSettings/data/EgMailServerSettingsJson.jsp',
	method: 'POST',
	success: function( response )
	{
		if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
		{
			var jsonText = response.responseText;
			publicJSON = Ext.decode( jsonText );

			var strUser = publicJSON['strUser'];
			if (!Ext.isEmpty(strUser) && strUser.length > 0)
			{
				Ext.getCmp('smtpauthenticationyes').setValue(true);
				Ext.getCmp('smtpuser').show();
				Ext.getCmp('smtppasssword').show();
				Ext.getCmp('smtpconfirmpasssword').show();

				Ext.getCmp('smtpuser').setValue(strUser);
				Ext.getCmp('smtppasssword').setValue(publicJSON['strPwd']);
				Ext.getCmp('smtpconfirmpasssword').setValue(publicJSON['strPwd']);
			}
			else
			{
				Ext.getCmp('smtpauthenticationno').setValue(true);
				Ext.getCmp('smtpuser').setValue("");
				Ext.getCmp('smtppasssword').setValue("");
				Ext.getCmp('smtpconfirmpasssword').setValue("");

				Ext.getCmp('smtpuser').hide();
				Ext.getCmp('smtppasssword').hide();
				Ext.getCmp('smtpconfirmpasssword').hide();
			}

			var mailReceiver = publicJSON['mailReceiver'];
			if (mailReceiver != null && !Ext.isEmpty(mailReceiver) && mailReceiver.length > 0)
			{
				Ext.getCmp('mailauthenticationyes').setValue(true);
				Ext.getCmp('mailrcvId').show();
				Ext.getCmp('mailrcvpwd').show();
				Ext.getCmp('portforrcvmail').show();
				Ext.getCmp('protocolforrcvmail').show();
				Ext.getCmp('serverforrcvmail').show();

				Ext.getCmp('mailrcvId').setValue(mailReceiver);
				Ext.getCmp('mailrcvpwd').setValue(publicJSON['mailReceiverPasswd']);
				Ext.getCmp('portforrcvmail').setValue(publicJSON['mailRcvPort']);
				Ext.getCmp('protocolforrcvmail').setValue(publicJSON['mailRcvProtocol']);
				Ext.getCmp('serverforrcvmail').setValue(publicJSON['mailRcvServer']);
			}
			else
			{
				Ext.getCmp('mailauthenticationno').setValue(true);
				Ext.getCmp('mailrcvId').setValue("");
				Ext.getCmp('mailrcvpwd').setValue("");
				Ext.getCmp('portforrcvmail').setValue("");
				Ext.getCmp('protocolforrcvmail').setValue("");
				Ext.getCmp('serverforrcvmail').setValue("");

				Ext.getCmp('mailrcvId').hide();
				Ext.getCmp('mailrcvpwd').hide();
				Ext.getCmp('portforrcvmail').hide();
				Ext.getCmp('protocolforrcvmail').hide();
				Ext.getCmp('serverforrcvmail').hide();
			}

			Ext.getCmp('smtpmailhost').setValue(publicJSON['strHost']);
			Ext.getCmp('smtpmailport').setValue(publicJSON['strPort']);
			Ext.getCmp('egadminmailId').setValue(publicJSON['strSender']);
			Ext.getCmp('alternatemailid').setValue(publicJSON['mailBuff']);

			var smtpMHost = publicJSON['strHost'];
			var smtpMPort = publicJSON['strPort'];
			var smtpMSender = publicJSON['strSender'];

			if ((!Ext.isEmpty(smtpMHost) && smtpMHost != "") && (!Ext.isEmpty(smtpMPort) && smtpMPort != "") && (!Ext.isEmpty(smtpMSender) && smtpMSender != ""))
			{
				Ext.getCmp('bckmailsettings').enable();
			}
			else
			{
				Ext.getCmp('bckmailsettings').disable();
			}
		}
	}
});
}

function addContact() {
	var mainForm = Ext.getCmp('formitems');
	var backupcontainer = Ext.getCmp('backupcontainer');
	var conId = "con_"+inputs
	var tmpContainer = {
		xtype : 'fieldset',
		title: 'Backup mail server setting',
		collapsible: true,
		id : conId,
		layout : {
			type : 'vbox',
			pack : 'center',
			align : 'center'
		},
		padding: '0 10 0 10',
		width: 700,
		items: [
			{
				xtype: 'container',
				width: 670,
				layout: {
					type: 'hbox',
					pack: 'end'
				},
				items : [
					{
						xtype : 'button',
						iconCls : 'iconMinus',
						listeners: {
						afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: 'Remove this setting'
						});
						}
						},
						//tooltip : '<b>Remove this setting</b>',
						smtpValue: inputs,
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeContact(conId,'smtpmailhostBck'+this.smtpValue,'smtpmailportBck'+this.smtpValue);
						}
					}
				]
			},
			{
				xtype: 'container',
				items: [
					{
						xtype: 'container',
						layout: {
							type: 'vbox',
							pack: 'center',
							align: 'center'
						},
						collapsible: true,
						width: 650,
						defaults: {
							labelSeparator: '',
							margin: 5,
							width: 600,
							labelWidth: 350
						},
						margin: 5,
						items: [
							{
								xtype: 'scrollcombo',
								fieldLabel: screenLabelMsg2,
								id : 'mailProtocolBck'+inputs,
								name: 'mailProtocolBck'+inputs,
								fieldLabel: screenLabelMsg2,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								editable: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: [{'displayField': 'SMTP','valueField':'SMTP'},
										{'displayField': 'SMTP-SSL','valueField':'SMTP-SSL'},
										{'displayField': 'SMTP-TLS','valueField':'SMTP-TLS'}
										]
									}
								),
								value: 'SMTP'
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg3,
								id: 'smtpmailhostBck'+inputs,
								name: 'smtpmailhostBck'+inputs
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg4,
								id: 'smtpmailportBck'+inputs,
								name: 'smtpmailportBck'+inputs
							},
							{
								xtype: 'radiogroup',
								cls:'radiobt',
								fieldLabel: screenLabelMsg8,
								columns: 2,
								vertical: false,
								id: 'smtpauthenbck'+inputs,
								smtpAuthId : inputs,
								items: [
									{ boxLabel: 'Yes', name: 'smtpauthenticatebck'+inputs, id:'smtpauthenticationbckyes'+inputs,  inputValue: '1'},
									{ boxLabel: 'No', name: 'smtpauthenticatebck'+inputs, id:'smtpauthenticationbckno'+inputs,  inputValue: '2', checked: true}
								],
								listeners: {
									change: function(){
									appnCnt.radSmtpBckChange(parseInt(this.smtpAuthId));
									}
								},
								name: 'smtpauthenbck'+inputs
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg11,
								id: 'smtpuserBck'+inputs,
								name: 'smtpuserBck'+inputs,
								hidden: true
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg12,
								inputType: 'password',
								id: 'smtppasswrdBck'+inputs,
								name: 'smtppasswrdBck'+inputs,
								hidden: true
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg13,
								inputType: 'password',
								id: 'smtpconfirmpassBck'+inputs,
								name: 'smtpconfirmpassBck'+inputs,
								hidden: true
							},
							{
								xtype: 'radiogroup',
								cls:'radiobt',
								fieldLabel: screenLabelMsg14,
								columns: 2,
								vertical: false,
								id: 'receiverauthenbck'+inputs,
								mailAuthId : inputs,
								items: [
									{ boxLabel: 'Yes', name: 'mailauthenticatebck'+inputs, id:'mailauthenticationbckyes'+inputs,  inputValue: '1'},
									{ boxLabel: 'No', name: 'mailauthenticatebck'+inputs, id:'mailauthenticationbckno'+inputs,  inputValue: '2', checked: true}
								],
								listeners: {
									change: function(){
									appnCnt.radMailBckSetChange(parseInt(this.mailAuthId));
									}
								},
								name: 'receiverauthenbck'+inputs
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg15,
								id: 'mailrcvIdBck'+inputs,
								name: 'mailrcvIdBck'+inputs,
								hidden: true
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg16,
								inputType: 'password',
								id: 'mailrcvpwdBck'+inputs,
								name: 'mailrcvpwdBck'+inputs,
								hidden: true
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg17,
								value: '110',
								id:'portforrcvmailBck'+inputs,
								name: 'portforrcvmailBck'+inputs,
								hidden: true
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg18,
								value: 'pop3',
								id:'protocolforrcvmailBck'+inputs,
								name: 'protocolforrcvmailBck'+inputs,
								hidden: true
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								fieldLabel: screenLabelMsg19,
								id:'serverforrcvmailBck'+inputs,
								name: 'serverforrcvmailBck'+inputs,
								hidden: true
							}
						]
					}
				]
			},
			{
				xtype: 'container',
				width: 670,
				layout: {
					type: 'hbox',
					pack: 'center'
				},
				margin: '0 0 10 0',
				items : [
					{
						xtype: 'button',
						id: 'validateBckBtn'+inputs,
						bckupValidId : inputs,
						text: 'Validate',
						cls:'button20',
						width: 80,
						listeners : {
							click : function()
							{
								ValidateBckId = Ext.getCmp('validateBckBtn'+parseInt(this.bckupValidId)).getId();
								appnCnt.validationForMailBackUp('smtpmailhostBck'+this.bckupValidId,'smtpmailportBck'+this.bckupValidId,'smtpauthenticationbckyes'+this.bckupValidId,'smtpuserBck'+this.bckupValidId,'smtppasswrdBck'+this.bckupValidId,'smtpconfirmpassBck'+this.bckupValidId,'mailauthenticationbckyes'+this.bckupValidId,'mailrcvIdBck'+this.bckupValidId,'mailrcvpwdBck'+this.bckupValidId,'portforrcvmailBck'+this.bckupValidId,'protocolforrcvmailBck'+this.bckupValidId,'serverforrcvmailBck'+this.bckupValidId,'mailProtocolBck'+this.bckupValidId,this.bckupValidId);
							}
						}
					}
				]
			}
		]
	}
	backupcontainer.add(tmpContainer);
	Ext.getCmp('smtpmailhostBck'+inputs).focus();
	mainForm.doLayout();
	inputs++;
	Ext.getCmp('addbutton').setText('Add More');
	Ext.getCmp('updateBckBtn').show();
	Ext.getCmp('NoBckMail').hide();
}

function checkForSameHost(arry)
{
	for ( var i = 0; i < arry.length ; i++)
	{
		var firstName = arry[i].toLowerCase();
		for ( var j = i+1; j < arry.length ; j++)
		{
			var scndName = arry[j].toLowerCase();
			if ( firstName == scndName)
			{
				return true;
			}
		}
	}
	return false;
}

function removeContact(containerID,smtpmailHostVal,smtpmailPortVal) {
	var btn = Ext.Msg.show({
		title : PageBckTitle,
		msg : deleteBckMsg,
		icon : 'iconConfirmation',
		buttons : Ext.Msg.YESNO,
		fn : function(btn)
		{
			if (btn == 'yes')
			{
				var removeSmtpHost = Ext.getCmp(smtpmailHostVal).getValue();
				var removeSmtpPort = Ext.getCmp(smtpmailPortVal).getValue();

				var backupcontainer = Ext.getCmp('backupcontainer');
				backupcontainer.remove(containerID);

				var bckitemsLen = backupcontainer.items.length;
				var coremailhost = Ext.getCmp("smtpmailhostBck0");
				if (bckitemsLen == 0)
				{
					Ext.getCmp('addbutton').setText('Add');
					Ext.getCmp('NoBckMail').show();
					Ext.getCmp('updateBckBtn').hide();
					updateSeparateFun();
				}
				else if (bckitemsLen != 0 && removeSmtpHost != "" && removeSmtpPort != "")
				{
					Ext.getCmp('NoBckMail').hide();
					Ext.getCmp('updateBckBtn').show();

					Ext.Ajax.request({
						url: "MailServerSettings/data/EgBackupMailServerpJson.jsp?removeSmtpHost="+removeSmtpHost+":"+removeSmtpPort+"&removehostFrmIni=true",
						method: 'POST',
						async: false,
						success: function( response )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode( jsonText );
							if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
							{
								var resultStatus = publicJSON['requestStatus'];
								if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
								{
									var resultStatus = publicJSON['result'];
									Ext.MessageBox.show({
										title : resultStatus['title'],
										msg : resultStatus['message1'],
										icon : 'iconInformation',
										buttons : Ext.Msg.OK
									});
								}
							}
						}
					});
				}
			}
		}
	});
}

function updateSeparateFun() {
	var addInputs = inputs;
	var backupMailserverEntries = "";
	Ext.getCmp('updateBckBtn').hide();

	backupMailserverEntries = "";
	var urlLinkBck = "MailServerSettings/data/EgBackupMailServerpJson.jsp?activeTabId=bckmailsettings&paramForBackMailSvr="+encodeURIComponent(backupMailserverEntries,'UTF-8')+"&clearBckSet=true";

	Ext.Ajax.request({
		url: urlLinkBck,
		method: 'POST',
		async: false,
		success: function( response )
		{
			var jsonText = response.responseText;
			publicJSON = Ext.decode( jsonText );
			if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
			{
				var resultStatus = publicJSON['requestStatus'];
				if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
				{
					var resultStatus = publicJSON['result'];
					Ext.MessageBox.show({
						title : resultStatus['title'],
						msg : resultStatus['message1'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK
					});
				}
			}
		}
	});
}

function updateBckFun() {
	var addInputs = inputs;
	var backupMailserverEntries = "";
	Ext.getCmp('updateBckBtn').hide();

	backupMailserverEntries = "";
	var urlLinkBck = "MailServerSettings/data/EgBackupMailServerpJson.jsp?activeTabId=mailsmssettings&paramForBackMailSvr="+encodeURIComponent(backupMailserverEntries,'UTF-8');

	Ext.Ajax.request({
		url: urlLinkBck,
		method: 'POST',
		async: false,
		success: function( response )
		{
			var jsonText = response.responseText;
			publicJSON = Ext.decode( jsonText );
		}
	});
}



