Ext.define('Maintenancegroup.view.Main', {
extend:'utilities.OuterPanel',
	alias: 'widget.main',
	xtype:'main',
	cls:'outerpanel',	
	title: mainPanelTitle,
	 margin: '8 8 0 8',
    id: 'main',
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	header:{cls:'zonereporthead'},
	requires:['utilities.CommonPanel'],
	//scroll:true,
	autoScroll:true,
	tools:[	
		{
			xtype:'label',
			id:'associate_label',
			hidden:true,
			name:'associate_label',
			text:showAssElemnts
		},
		{
			xtype: 'checkbox',
			//boxLabel: 'Associated Elements',
			checked: true,
			columnWidth: 0.3,
			margin: '4 0 0 10',
			inputValue : 'Never',
			cls: 'checkbt',
			hidden:true,
			name : 'associate_elemts',
			id : 'associate_elemts',
			handler: function (field, value) {		 
					maintananceGroupApp.getController("Main").afterMainRender();
			}
		},
		{
			xtype: 'trigger',
			margin: '4 0 0 10',			
			cls: 'whitedropdown_search',
			emptyText:'Search',		
			width: 150,	
			hidden:true,
			id:'listSearch',
			name:'listSearch',
			//enableKeyEvents:true,
			listeners:{  
				scope:this,  
				specialkey: function(f,e){  
					if(e.getKey()==e.ENTER){
					    lastLoadedUrl = '/final/admin/Maintenancegroup/data/egMaintenancePolicygroupListJSON.jsp?egTitleSearchStr='+f.value;
						maintananceGroupApp.getController("Main").getDataViewPanel(lastLoadedUrl);
					}  
				}
			},
			onTrigger1Click: function()
			{
				this.reset();
				maintananceGroupApp.getController("Main").afterMainRender();
			},
			onTrigger2Click: function()
			{
				lastLoadedUrl = '/final/admin/Maintenancegroup/data/egMaintenancePolicygroupListJSON.jsp?egTitleSearchStr='+this.getValue();
				maintananceGroupApp.getController("Main").getDataViewPanel(lastLoadedUrl);
			}
		},		
		{
			xtype: "tbseparator",
			id:'sep1',
			name:'sep1',
			hidden:true
		},
		{
            xtype: 'container',
            margin: '0 0px 0 0px',
            cls: 'iconBg',
            //disabled: true,
            items: [{
                xtype: 'button',
                iconCls: 'iconDelete',
				id:'deleteBtn',
				name:'deleteBtn',
				hidden:true,
                listeners: {
                    afterrender: function () {
                        Ext.create('Ext.tip.ToolTip', {
                            target: this.id,
                            anchor: 'top',
                            cls: 'yellowTip',
                            trackMouse: true,
                            html: deleteMultiPolicyGrpTooltipText
                        });
                    }
                },
				handler: function()
				{
					maintananceGroupApp.getController("Main").loadDeleteMultiplePoliciesUI();
				},
                style: {
                    background: 'none',
                    border: '0px'
                }
            }]
        },
		{
			xtype: "tbseparator",
			id:'sep2',
			name:'sep2',
			hidden:true
		},
		{
            xtype: 'button',
            text: backBtnLbl,
            cls: 'backbutton',
			iconCls:'iconBack',
			handler: function()
			{
				viewport = Ext.ComponentQuery.query('viewport')[0];
				viewport.removeAll();
				document.location.href = 'QuickMaintenance.jsp';
			}
        }
		
	],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [{
			xtype: 'component',
			html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+ListpageDesc+'</center>',
		}]
	}],
	items: [
	]
});



