var elemList;
Ext.define('ManageUnmanageSystems.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'egconfigenvformcontainer', ref:'egconfigenvformcontainer'},
		{selector:'egconfigenvformcontainer optgroupitemselector[id="componentDetails"]', ref:'componentDetailsSelector'},
	],
	init:function()
	{
		appCnt = this;
		ipMapping = null;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready': this.loadSystems
			},
			'egconfigenvformcontainer combo[id="nickname"]':
			{
				'select':this.changeOnSystems
			},
			'egconfigenvformcontainer button[id="Update"]':
			{
				'click':this.updateComponentDetails
			},
			'egconfigenvformcontainer button[id="addNewServer"]':
			{
				'click':this.addNewServer
			},
			'main button[id="backButton"]':
			{
				'click': this.loadEgConfigManagementApp
			},
		})
	},
	buildMainData : function()
	{
		if (nickName == "null" || nickName.length == 0)
		{
			nickName = "";
		}
		Ext.Ajax.request({
			url: 'ManageUnmanageSystems/data/ManageServersJson.jsp?reqfrom='+reqfrom+'&nick='+encodeURIComponent(nickName) + '&srvtype='+encodeURIComponent(strServer),
			method: 'POST',
			async : false,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			}
		});
	},
	changeOnSystems : function(obj)
	{
		var me = this;
		var selectedNickName = obj.getValue();
		var componentDetails = Ext.getCmp('componentDetails');
		if (selectedNickName == "-1")
		{
			componentDetails.fromField.getStore().removeAll();
			componentDetails.toField.getStore().removeAll();
			return;
		}
		var url = "ManageUnmanageSystems/data/ManageServersJson.jsp?nick="+encodeURIComponent(selectedNickName)+"&reqfrom="+reqfrom+ "&srvtype="+encodeURIComponent(strServer)+"&date="+new Date().getTime();

		Ext.Ajax.request({
			url: url,
			method: 'POST',
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				me.loadSystemComponents();
				ipMapping = publicJSON.nickIP;
				delete publicJSON;
			},
			failure: function(response)
			{
			}
		});
	},
	loadSystemComponents : function()
	{
		var componentDetails = Ext.getCmp('componentDetails');
		componentDetails.fromField.store.removeAll();
		componentDetails.toField.store.removeAll();
		if (!Ext.isEmpty(publicJSON.managedComponentsArr))
		{
			componentDetails.fromField.store.add(publicJSON.managedComponentsArr);
		}

		if (!Ext.isEmpty(publicJSON.discoveredComponents))
		{
			componentDetails.toField.store.add(publicJSON.discoveredComponents);
		}

		if (componentDetails.fromField.store.getCount() > 15 || componentDetails.toField.store.getCount() > 15)
		{
			Ext.getCmp('searchFieldContainer').show();
		}
		else
		{
			Ext.getCmp('searchFieldContainer').hide();
		}
		delete componentDetails;
	},
	loadSystems : function()
	{
		var systemObj = Ext.getCmp('nickname');
		systemObj.getStore().clearFilter(true);
		systemObj.getStore().loadRawData(publicJSON.nickNameArr);
		if (nickName == "null" || nickName.length == 0)
		{
			systemObj.setValue("-1");
		}
		else
		{
			ipMapping = publicJSON.nickIP;
			systemObj.setValue(nickName);
		}
		this.loadSystemComponents();
		delete systemObj;
		delete publicJSON;
	},
	showResultWindow : function(title,resultText,action)
	{
		var me = this;
		var isProceed = false;
		Ext.Msg.show({
			title: title,
			msg: resultText,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes') 
				{
					isProceed = true;
					if (action != null && action !== undefined && action == "unmanage")
					{
						me.updateComponentDetails(isProceed);
					}
				}
				else
				{
					me.loadManagedSysetems();
				}
			}
		});
	},
	viewAssociatedEntities : function(action)
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			title : associatedEntitiesTitle1,
			id:'assoEntitesWindow',
			width: '68%',
			bodyPadding:'10 10 10 10',
			height: 500,
			modal : true,
			border : false,
			
			autoScroll:true,
			scroll:true,
			ghost:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					me.updateEntityAssociationPage(action);
				}
			},
			items:[
				{
					xtype: 'container',
					flex:1,
					id: 'entityAssociationContainer',
					
					margin: 10
				}
			]
		}).show();
	},
	updateEntityAssociationPage : function(action)
	{
		var me = this;
		var urlStr = "ManageUnmanageSystems/data/EgComponentGroupedSummary.jsp?date="+new Date().getTime()+"&action="+action;//+"&srvtype="+servType;
		if (action != null && action !== undefined && (action == "showMod" || action == "showDel"))
		{
			urlStr += "&elemList=true";
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle2);
			Ext.getCmp("hiddenElemList").setValue(elemList);
		}
		else if (action != null && action !== undefined && action == "unmanage")
		{
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle1);
			me.setAvailableConfigs();
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var frmMain = this.getMain().getForm();
		if (frmMain.isValid())
		{
			this.getMain().submit({
				url: urlStr,
				method: 'POST',
				timeout : 300,
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					me.updateResultPanel(resultObj);
				},
				failure: function(form, action)
				{
					myMask.hide();
				}
			});
		}
	},
	updateResultPanel : function(resultObj)
	{
		var me = this;
		var entityAssociationCont = Ext.getCmp('entityAssociationContainer');
		entityAssociationCont.removeAll();

		var isElementsAssociated = resultObj['isElementsAssociated'];
		if (isElementsAssociated != undefined && isElementsAssociated == true)
		{
			var message = "<div>"+resultObj.usersGridArr+"</div>";
			Ext.getCmp('entityAssociationContainer').update(message);
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>No components associated.</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			entityAssociationCont.add(tmpPanel);
		}
	},
	updateComponentDetails : function(isProceed)
	{
		var me = this;
		elemList = "";
		var nickname = Ext.getCmp('nickname').getValue();
		if (nickname == "-1")
		{
			Ext.Msg.alert(pageTitle,intnlLabel14);
			return;
		}
		if(nickname.toLowerCase() == "none")
		{
			Ext.Msg.alert(pageTitle,"You are not allowed to manage eG reserved keyword \'"+nickname+"\'");
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var componentDetails = Ext.getCmp('componentDetails');
		me.setAvailableConfigs();
		var urlStr = 'ManageUnmanageSystems/data/EgenvpJson.jsp?nickName='+nickname+"&date="+new Date().getTime();
		if (isProceed != null && isProceed !== undefined && isProceed == true)
		{
			urlStr += "&isProceed="+isProceed;
		}
		var frmMain = this.getMain().getForm();
		if (frmMain.isValid())
		{
			this.getMain().submit({
				url: urlStr,
				method: 'POST',
				//standardSubmit: true,
				timeout : 120, // 2 minutes
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						var tmpObj = resultObj.result;
						Ext.Msg.show({
							title: tmpObj.title,
							width : 500,
							msg: tmpObj.message1,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
						elemList = resultObj.elemList;
						if (isProceed != null && isProceed !== undefined && isProceed != false)
						{
							me.loadManagedSysetems();
						}
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						me.showResultWindow(tmpObj.title,errorText,"unmanage");
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
				}
			});
		}
	},
	setAvailableConfigs : function()
	{
		Ext.getCmp("managedComponents").setValue("");
		Ext.getCmp("unmanagedComponents").setValue("");

		var tmpStore = Ext.getCmp('componentDetails');
		var unmanagedComponentsArr = new Array();
		var managedComponentsArr = new Array();
		var unmnglen = tmpStore.toField.store.getCount();
		var mnglen = tmpStore.fromField.store.getCount();
		var unmanagedList = tmpStore.toField.store;
		var managedList = tmpStore.fromField.store;

		for(var z = 0;z<unmnglen;z++)
		{
			var tmpVal = unmanagedList.getAt(z).get('valueField');
			unmanagedComponentsArr[z] = tmpVal;
		}

		for(var y = 0;y<mnglen;y++)
		{
			var tmpVal = managedList.getAt(y).get('valueField');
			managedComponentsArr[y] = tmpVal;
		}
		Ext.getCmp("managedComponents").setValue(managedComponentsArr);
		Ext.getCmp("unmanagedComponents").setValue(unmanagedComponentsArr);
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var me = this;
		var tmpTable = "";
		if (tmpObj.allow != null && tmpObj.allow !== undefined && tmpObj.allow == true)
		{
			for (var key in tmpObj)
			{
				if (key == "title" || key == "allow") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + errorMessage;
			}
		}
		else
		{
			tmpTable = '<div class="x-table" style="width:100%"><table cellspacing="0" width="100%" cellpadding="5" border="1" align="center" class="x-grid-table" style="border:1px solid #c3c3c3"><thead><tr class="x-grid-row"><th class="x-grid-cell"><div class="x-grid-cell-inner">'
			+errorTitle+' : '+pageIntnl15+'</div></td></tr></thead>'
			for (var key in tmpObj)
			{
				if (key == "title") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + '<tr class="x-grid-row"><td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
			}
			tmpTable = tmpTable + '</table></div>';
		}
		return tmpTable;
	},
	loadManagedSysetems : function()
	{
		var me = this;
		var nickname = Ext.getCmp('nickname').getValue();
		var url = "ManageUnmanageSystems/data/ManageServersJson.jsp?nick="+encodeURIComponent(nickname)+"&date="+new Date().getTime();

		Ext.Ajax.request({
			url: url,
			method: 'POST',
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				var componentDetails = Ext.getCmp('componentDetails');
				componentDetails.getStore().removeAll();
				componentDetails.fromField.store.removeAll();
				componentDetails.toField.store.removeAll();
				componentDetails.fromField.store.add(publicJSON.managedComponentsArr);
				componentDetails.toField.store.add(publicJSON.discoveredComponents);

				Ext.getCmp('nickname').getStore().loadRawData(publicJSON.nickNameArr);
				if (Ext.getCmp('nickname').getStore().findExact("valueField",nickname) != -1)
				{
					Ext.getCmp('nickname').setValue(nickname);
				}
				else
				{
					Ext.getCmp('nickname').setValue("-1");
				}

				if (componentDetails.fromField.store.getCount() > 15 || componentDetails.toField.store.getCount() > 15)
				{
					Ext.getCmp('searchFieldContainer').show();
				}
				else
				{
					Ext.getCmp('searchFieldContainer').hide();
				}
				delete componentDetails;
				delete publicJSON;
			}
		});
	},
	searchComponent : function(frmField,value,fieldObj)
	{
		var me = this;
		if (value == "" || value.length == 0)
		{
			Ext.get(fieldObj.getId()+'_0').setStyle('display','none');
			Ext.get(fieldObj.getId()+'_1').setStyle('display','block');
		}
		else
		{
			Ext.get(fieldObj.getId()+'_1').setStyle('display','none');
			Ext.get(fieldObj.getId()+'_0').setStyle('display','block');
		}

		var defaultCachedStore = me.getComponentDetailsSelector().fromField.getStore();
		if (frmField == "unmanaged")
		{
			defaultCachedStore = me.getComponentDetailsSelector().toField.getStore();
		}

		if (value == "" || value.length == 0)
		{
			defaultCachedStore.clearFilter();
		}
		else
		{
			defaultCachedStore.clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					if (item.get('displayField').toLowerCase().indexOf(value.toLowerCase()) != -1)
					{
						return true
					}
					else
					{
						return false;
					}
				}
			});
			defaultCachedStore.filter(userFilter);
		}
		delete defaultCachedStore;
	},
	loadEgConfigManagementApp : function()
	{
		if (reqfrom == "navlink")
		{
			window.location.href = "EgConfigEnv.jsp?reqfrom=navlink&srvtype="+encodeURIComponent(strServer)+"&fromWizard="+fromWizard;
		}
		else
		{
			window.history.go(-1);
		}
	},
	addNewServer : function()
	{
		var nickname = Ext.getCmp('nickname').getValue();
		if (nickname == "-1")
		{
			Ext.Msg.alert(pageTitle,intnlLabel14);
			return;
		}
		window.location.href = "/final/admin/EgNewServer.jsp?fromAPP=ManUnmanSystems&server=new&serverType=-1&from=addnew&serverGategory=-1&compIp="+encodeURIComponent(ipMapping)+"&compNick="+encodeURIComponent(nickname)+"&fromWizard="+fromWizard;
	}
});