Ext.define('ManagerSettings.controller.Main',{
	extend:'Ext.app.Controller',
	views:['TTManager','General','ManagerNotification','TestConfiguration','CommandExecution','ThresholdConfiguration','LogSettings','AdvancedSettings','CapacityPlanning','VirtualTopology','Auditing','Viewport','FileUpload','FileUploadForm','SettingList','AccountLockOut','SingleSignOn','PasswordPolicy','SecurityFilter','TwoFactorAuth','ListView','TTManagerSnmp','EgManagerModel','DeleteUsers'],
	refs:[
		{selector:'settinglist', ref:'settinglist'},
		{selector:'ttmanager', ref:'ttmanager'},
		{selector:'TTlistview', ref:'TTlistview'},
		{selector:'ttmanagermailsnmp', ref:'ttmanagermailsnmp'},
		{selector:'ttmanagersnmp', ref:'ttmanagersnmp'},
		{selector:'ttcommonsettings', ref:'ttcommonsettings'},
		{selector:'ttmanagerwebservice', ref:'ttmanagerwebservice'},
		{selector:'ttmanagercli', ref:'ttmanagercli'},
		{selector:'general', ref:'general'},
		{selector:'managerNotification', ref:'managerNotification'},
		{selector:'testconfiguration', ref:'testconfiguration'},
		{selector:'commandexecution', ref:'commandexecution'},
		{selector:'thresholdconfiguration', ref:'thresholdconfiguration'},
		{selector:'logsettings', ref:'logsettings'},
		{selector:'advancedsettings', ref:'advancedsettings'},
		{selector:'capacityplanning', ref:'capacityplanning'},
		{selector:'virtualtopology', ref:'virtualtopology'},
		{selector:'auditing', ref:'auditing'},
		{selector:'viewport', ref:'viewport'},
		{selector:'fileupload', ref:'fileupload'},
		{selector:'fileuploadform', ref:'fileuploadform'},
		{selector:'acklockout', ref:'acklockout'},
		{selector:'singlesignon', ref:'singlesignon'},
		{selector:'pwdpolicy', ref:'pwdpolicy'},
		{selector:'securityfilter', ref:'securityfilter'},
		{selector:'twofactorauth', ref:'twofactorauth'},
		{selector:'egmgrmodel', ref:'egmgrmodel'},
		{selector:'deleteusers', ref:'deleteusers'}
	],
	init:function(){
		thisController = this;
		archeiveFile = '';
		archeiveFileUpload = '';
		fileName = '';
		ttWrapper = '';
		TTSysForRemove = '';
		ttWrapperClass = 'Default';
		isAcmeUploaded = 'no';
		selectedIntegrationName = '';
		this.control({
			'settinglist':
			{
				'itemclick': this.onClickData
			},
			'viewport #btnBack':
			{
				'click': this.forwardToRequestedURI
			},
			'viewport':
			{
				'afterrender': this.afterMainRender
			},
			'managerNotification button[id="notificationUpdate"]':
			{
				'click': this.notificationUpdate
			},
			/*'disccomponents button[id="UpdateBtn"]':
			{
				'click': this.discCompUpdate
			},*/
			'testconfiguration button[id="testConfigUpdateBtn"]':
			{
				'click': this.testConfigUpdate
			},
			'thresholdconfiguration combo[id="threshIntervalForDisplay"]':
			{
				'select': this.threshIntervalChange
			},
			'thresholdconfiguration button[id="threshUpdateBtn"]':
			{
				'click': this.thresholdConfigUpdate
			},
			'commandexecution button[id="commandExecUpdateBtn"]':
			{
				'click': this.commandExecUpdate
			},
			'ttmanager combo[id="TT_sys"]':
			{
				'select': this.ttManagerSystemComboChange
			},
			'ttmanager button[id="UpdateBtn"]':
			{
				'click': this.ttManagerUpdate
			},
			'ttmanager radio[id="TTIntegrationEnable"]':
			{
				'change': this.radioChange
			},
			'ttmanager radio[name="ttWrapperClassNeeded"]':
			{
				'change': this.wrapperClassRadioChange
			},
			'ttmanager radio[id="TTIntegrationDisable"]':
			{
				'change': this.radioChange
			},
			'ttmanager button[id="uploadFile"]':
			{
				'click': this.uploadAcmeFile
			},
			'ttcommonsettings button[id="UpdateCommonBtn"]':
			{
				//'click': this.ttCommonSettingsUpdate
				'click': this.submitTTFilterElements////'click': this.ttCommonSettingsUpdate
			},'ttcommonsettings combo[id="filter"]':
			{
				'select':this.popFilterDetails
			},
			'ttcommonsettings combo[id="CompTypes"]':
			{
				'select':this.popCompTypes
			},
			'ttcommonsettings combo[id="compTypesIn"]':
			{
				'select':this.viewByCriteria
			},
			'ttcommonsettings combo[id="serseg"]':
			{
				'select':this.changeByServer
			},
			'ttcommonsettings combo[id="Test"]':
			{
				'select':this.changeByTest
			},
			'ttcommonsettings multiselectSi[id="compName"]':
			{
				'change':this.changeByComponentName
			},
			'ttcommonsettings button[id="includeMore"]':
			{
				'click':this.assignAndAddMoreFilters
			},
			'ttcommonsettings button[id="btnViewFilters"]':
			{
				'click':this.viewFilteredElements
			},
			'ttmanagercli button[id="UpdateCliBtn"]':
			{
				'click': this.ttCliUpdate
			},
			'ttmanagermailsnmp button[id="UpdateMailBtn"]':
			{
				'click': this.ttMailUpdate
			},
			'ttmanagersnmp button[id="UpdateSnmpBtn"]':
			{
				'click': this.ttSnmpUpdate
			},
			'ttmanagerwebservice button[id="UpdateWebserviceBtn"]':
			{
				'click': this.ttWebserviceUpdate
			},
			'ttmanagerwebservice combo[id="TT_sys"]':
			{
				'select': this.ttWebserviceSysCombo
			},
			'ttmanagerwebservice radio[name="ttWrapperClassNeeded"]':
			{
				'change': this.wrapperClassRadioChange
			},
			'ttmanagerwebservice button[id="uploadFile"]':
			{
				'click': this.uploadAcmeFile
			},
			'logsettings button[id="logUpdateBtn"]':
			{
				'click': this.logUpdate
			},
			'auditing radio[name="EnableAuditlog"]':
			{
				'change': this.auditingRadioChange
			},
			'auditing button[id="auditingUpdateBtn"]':
			{
				'click': this.auditingUpdate
			},
			'advancedsettings button[id="advSetUpdateBtn"]':
			{
				'click': this.advSetUpdate
			},
			'capacityplanning button[id="capUpdateBtn"]':
			{
				'click': this.capacityPlanningUpdate
			},
			'virtualtopology button[id="virtualTopoUpdateBtn"]':
			{
				'click': this.virtualTopoUpdate
			},
			'fileuploadform button[id="fileUploadBtn"]':
			{
				'click': this.fileUpload
			},
			'general button[id="UpdateBtn"]':
			{
				'click': this.generalSettingsUpdate
			},
			'general radio[id="yesLoginAuthentication"]':
			{
				'change': this.checkAutoLoginFeature
			},
			'acklockout radio[name="lckTypeRadio"]':
			{
				'change': this.acklckoutRadioChange
			},
			'acklockout radio[name="lckStrategyRadio"]':
			{
				'change': this.lckStrategyRadioChange
			},
			'acklockout button[id="UpdateBtn"]':
			{
				'click': this.acklockoutUpdate
			},
			'singlesignon button[id="UpdateBtn"]':
			{
				'click': this.ssoLoginUpdate
			},
			'pwdpolicy radiogroup[id="minHistoryEnable"]':
			{
				'change': this.enablePasswordHistory
			},
			'pwdpolicy button[id="UpdateBtn"]':
			{
				'click': this.pwdpolicyUpdate
			},
			'securityfilter button[id="secureFilterUpdate"]':
			{
				'click': this.secureFilterUpdate
			},
			// 2fa
			'twofactorauth radio[id="enable2FAYesFlag"]': {
				change: this.show2FACnt
			},
			'twofactorauth radio[id="compulsoryFlag"]': {
				change: this.showVerificationModePanel
			},
			'twofactorauth button[id="twofa_submit_btn"]': {
				click: this.updateTFAAuthConfigDetails
			},
			// 2fa
			'egmgrmodel radio[id="mgrModelEnterprise"]': {
				change: this.mgrModelRadioChange
			},
			'egmgrmodel button[id="mgrModelUpdate"]': {
				click: this.updateMgrModel
			},
			'deleteusers button[id="deleteUsersUpdateBtn"]':
			{
				'click': this.deleteUsersUpdate
			}
		});
	},

	idpLogoutFunc: function(obj) 
	{
		if (obj.id.toLowerCase() == 'yesssologin')
		{
			//Ext.getCmp('idpLogout').show();
			var loginAuthentication = ssoLoginJson.loginAuthentication;

			if (!Ext.isEmpty(loginAuthentication) && !loginAuthentication) // Auto login is enabled. So alert the user to turn off it to enable sso feature.
			{
				Ext.Msg.confirm(SSOTitleLbl,autoLoginAlertMsg1+". "+autoLoginAlertMsg5,function(ans){
					if(ans === "yes") // trun off auto login feature and enable sso
					{
						thisController.turnOffAutoLogin();
						Ext.getCmp('idpLogout').show();
					}
					else // dont enable sso 
					{
						Ext.getCmp('nossoLogin').setValue(true);
						Ext.getCmp('idpLogout').hide();
					}
				});
			}
			else
			{
				Ext.getCmp('idpLogout').show();
			}

			if (ssoLoginJson.isIdpLogout)
			{
				Ext.getCmp('yesidpLogout').setValue(true);
			}
			else
			{
				Ext.getCmp('noidpLogout').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('idpLogout').hide();
		}
	},
	afterMainRender: function()
	{
		var mainViewIdObj = Ext.getCmp('mainViewId');
		var innerMainPanelObj = Ext.getCmp('innerPanel');

		var yesAvgSumTrendsObj = Ext.getCmp('yesAvgSumTrends');
		var noAvgSumTrendsObj = Ext.getCmp('noAvgSumTrends');

		var trendMgrThreadsObj = Ext.getCmp('TrendMgrThreads');
		var thresholdMgrThreadsObj = Ext.getCmp('ThresholdMgrThreads');
		var thresholdRunDurationObj = Ext.getCmp('ThresholdRunDuration');
		var thresholdAdjustPeriodObj = Ext.getCmp('ThresholdAdjustPeriod');

		var timeFromObj = Ext.getCmp('timeFrom');
		var timeToObj = Ext.getCmp('timeTo');

		var yesAutoIpNameCheckObj = Ext.getCmp('yesAutoIpNameCheck');
		var noAutoIpNameCheckObj = Ext.getCmp('noAutoIpNameCheck');

		var yesNickIpCheckObj = Ext.getCmp('yesNickIpCheck');
		var noNickIpCheckObj = Ext.getCmp('noNickIpCheck');

		var yesAuthLoginObj = Ext.getCmp('yesLoginAuthentication');
		var noAuthLoginObj = Ext.getCmp('noLoginAuthentication');

		var relativeThresholdTime = '';

		Ext.getCmp('innerPanel').setTitle('GENERAL SETTINGS');

		var url = "/final/admin/ManagerSettings/data/generalSettingsJSON.jsp";

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var isDisableTrend = jsonData.isDisableTrend;
				var avgSumTrends = jsonData.avgSumTrends;

				var authModeForLogin = jsonData.authModeForLogin;
				if (authModeForLogin == 'SAML')
				{
					Ext.getCmp("idpAuthMode").setValue(true);
				}
				else if (authModeForLogin == 'Domain')
				{
					Ext.getCmp("domainAuthMode").setValue(true);
				}
				else
				{
					Ext.getCmp("eGAuthMode").setValue(true);
				}


				relativeThresholdTime = jsonData.relativeThresholdHours;

				if (avgSumTrends == 'Yes')
				{
					yesAvgSumTrendsObj.setValue(true);
				}
				else
				{
					noAvgSumTrendsObj.setValue(true);
				}

				trendMgrThreadsObj.setValue(jsonData.trendMgrThreads);
				thresholdMgrThreadsObj.setValue(jsonData.thresholdMgrThreads);
				thresholdRunDurationObj.setValue(jsonData.thresholdRunDuration);
				thresholdAdjustPeriodObj.setValue(jsonData.thresholdAdjustPeriod);

				timeFromObj.setValue(jsonData.fromTime.fromStr);

				var selectedToTime = jsonData.toTime.toStr;
				if (selectedToTime == '24:00')
				{
					timeToObj.setValue('23:59');
				}
				else
				{
					timeToObj.setValue(selectedToTime);
				}

				var autoIpNameCheck = jsonData.autoIpNameCheck;

				if (autoIpNameCheck == 'Yes')
				{
					yesAutoIpNameCheckObj.setValue(true);
				}
				else
				{
					noAutoIpNameCheckObj.setValue(true);
				}

				var nickIpCheck = jsonData.nickIpCheck;

				if (nickIpCheck == 'Yes')
				{
					yesNickIpCheckObj.setValue(true);
				}
				else
				{
					noNickIpCheckObj.setValue(true);
				}

				var authLogin = jsonData.loginAuthentication;
				if (authLogin)
				{
					yesAuthLoginObj.setValue(true);
				}
				else
				{
					noAuthLoginObj.setValue(true);
				}

				var eGMgrModel = jsonData.eGMgrModel;
				if (!Ext.isEmpty(eGMgrModel) && eGMgrModel.toLowerCase() == 'msp')
				{
					Ext.getCmp('AutoIpNameCheckID').disable();
					Ext.getCmp('NickIpCheck').disable();
					Ext.getCmp("authModeForLogin").hide();
				}

				if (!Ext.isEmpty(isDisableTrend) && isDisableTrend.toLowerCase() == 'no')
				{
					var managerSettingsTree = Ext.getCmp('managerSetTreePanel');
					var record = managerSettingsTree.getStore().getNodeById(selectedNodeID);
					managerSettingsTree.getSelectionModel().select(record);
					if (selectedNodeID == "capacityPlanningNode")
					{
						var innerMainPanelObj = Ext.getCmp('innerPanel');
						innerMainPanelObj.removeAll();
						innerMainPanelObj.add({ xtype: 'capacityplanning'});
						Ext.getCmp('innerPanel').setTitle('CAPACITY PLANNING');

						Ext.Ajax.request({
							url: '/final/admin/ManagerSettings/data/capacityPlanningJSON.jsp',
							method: 'POST',
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var jsonText = response.responseText;
									var capacityPlanningJSON = Ext.decode( jsonText );

									var yesCapacityTrendObj = Ext.getCmp('yesCapacityTrend');
									var noCapacityTrendObj = Ext.getCmp('noCapacityTrend');

									var yesCapcityreportObj = Ext.getCmp('yesCapcityreport');
									var noCapcityreportObj = Ext.getCmp('noCapcityreport');

									var capacityTrendValue = capacityPlanningJSON.capacitytrendenable;
									var capcityReportValue = capacityPlanningJSON.capacityreportenable;

									if (capacityTrendValue == 'true')
									{
										yesCapacityTrendObj.setValue('true');
									}

									if (capacityTrendValue == 'false')
									{
										noCapacityTrendObj.setValue('false');
									}

									if (capcityReportValue == 'true')
									{
										yesCapcityreportObj.setValue('true');
									}

									if (capcityReportValue == 'false')
									{
										noCapcityreportObj.setValue('false');
									}
								}
							}
						});
					}
					else if (selectedNodeID == "twofa")
					{
						var innerMainPanelObj = Ext.getCmp('innerPanel');
						Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
						innerMainPanelObj.removeAll();
						innerMainPanelObj.add({ xtype: 'twofactorauth'});
						thisController.get2FAConfigDetails();
						Ext.getCmp('innerPanel').setTitle('2-Step Verification');
					}
					else if (selectedNodeID == "egmgrmodel")
					{
						var innerMainPanelObj = Ext.getCmp('innerPanel');
						Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
						innerMainPanelObj.removeAll();
						innerMainPanelObj.add({ xtype: 'egmgrmodel'});
						Ext.getCmp('innerPanel').setTitle(mgrModelTitle.toUpperCase());
						thisController.getMgrModelDetails();
					}
				}
				else
				{
					var managerSettingsTree = Ext.getCmp('managerSetTreePanel');
					var record = managerSettingsTree.getStore().getNodeById('capacityPlanningNode');
					record.parentNode.removeChild(record);
				}

				if (isCallToEnableCPFromReporter.toLowerCase() == "true")
				{
					Ext.getCmp('btnBack').show();
				}
			}
		});
		if (isMsp)
		{
			var record = Ext.getCmp('managerSetTreePanel').getStore().getNodeById('ssoNode');
			Ext.getCmp('managerSetTreePanel').getSelectionModel().select(record);
			record.remove(true);
			Ext.getCmp('managerSetTreePanel').getStore().sync();
		}
	},

	forwardToRequestedURI : function()
	{
		if (fromPage == "home")
		{
			window.location.href = "/final/admin/EgAdminOperations.jsp";			
		}
		else
		{
			var topWindow = window;
			while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
			{
				mainWindow = topWindow;
				topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
			}
			if(topWindow.location.pathname!="/")
			{
				mainWindow=topWindow;
			}
			mainWindow.location.href = "/final/egIndex.jsp?entry=reporter&displayTab=all&integritycheckviolated=false";
			mainWindow.focus();
		}
	},
	onClickData: function(me, record, item, index, e, eOpts)
	{
		var mainViewIdObj = Ext.getCmp('mainViewId');
		var innerMainPanelObj = Ext.getCmp('innerPanel');

		if (record.data.text == gerneralTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'general'});

			Ext.getCmp('innerPanel').setTitle(gerneralTitle.toUpperCase());

			var yesAvgSumTrendsObj = Ext.getCmp('yesAvgSumTrends');
			var noAvgSumTrendsObj = Ext.getCmp('noAvgSumTrends');

			var trendMgrThreadsObj = Ext.getCmp('TrendMgrThreads');
			var thresholdMgrThreadsObj = Ext.getCmp('ThresholdMgrThreads');
			var thresholdRunDurationObj = Ext.getCmp('ThresholdRunDuration');
			var thresholdAdjustPeriodObj = Ext.getCmp('ThresholdAdjustPeriod');

			var timeFromObj = Ext.getCmp('timeFrom');
			var timeToObj = Ext.getCmp('timeTo');

			var yesAutoIpNameCheckObj = Ext.getCmp('yesAutoIpNameCheck');
			var noAutoIpNameCheckObj = Ext.getCmp('noAutoIpNameCheck');

			var yesNickIpCheckObj = Ext.getCmp('yesNickIpCheck');
			var noNickIpCheckObj = Ext.getCmp('noNickIpCheck');

			var yesAuthLoginObj = Ext.getCmp('yesLoginAuthentication');
			var noAuthLoginObj = Ext.getCmp('noLoginAuthentication');

			var relativeThresholdTime = '';

			var url = "/final/admin/ManagerSettings/data/generalSettingsJSON.jsp";

			Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var avgSumTrends = jsonData.avgSumTrends;

						var authModeForLogin = jsonData.authModeForLogin;
						if (authModeForLogin == 'SAML')
						{
							Ext.getCmp("idpAuthMode").setValue(true);
						}
						else if (authModeForLogin == 'Domain')
						{
							Ext.getCmp("domainAuthMode").setValue(true);
						}
						else
						{
							Ext.getCmp("eGAuthMode").setValue(true);
						}

						relativeThresholdTime = jsonData.relativeThresholdHours;

						if (avgSumTrends == 'Yes')
						{
							yesAvgSumTrendsObj.setValue(true);
						}
						else
						{
							noAvgSumTrendsObj.setValue(true);
						}

						trendMgrThreadsObj.setValue(jsonData.trendMgrThreads);
						thresholdMgrThreadsObj.setValue(jsonData.thresholdMgrThreads);
						thresholdRunDurationObj.setValue(jsonData.thresholdRunDuration);
						thresholdAdjustPeriodObj.setValue(jsonData.thresholdAdjustPeriod);

						timeFromObj.setValue(jsonData.fromTime.fromStr);

						var selectedToTime = jsonData.toTime.toStr;
						if (selectedToTime == '24:00')
						{
							timeToObj.setValue('23:59');
						}
						else
						{
							timeToObj.setValue(selectedToTime);
						}

						var autoIpNameCheck = jsonData.autoIpNameCheck;

						if (autoIpNameCheck == 'Yes')
						{
							yesAutoIpNameCheckObj.setValue(true);
						}
						else
						{
							noAutoIpNameCheckObj.setValue(true);
						}

						var nickIpCheck = jsonData.nickIpCheck;

						if (nickIpCheck == 'Yes')
						{
							yesNickIpCheckObj.setValue(true);
						}
						else
						{
							noNickIpCheckObj.setValue(true);
						}

						var authLogin = jsonData.loginAuthentication;
						if (authLogin)
						{
							yesAuthLoginObj.setValue(true);
						}
						else
						{
							noAuthLoginObj.setValue(true);
						}
						
						var eGMgrModel = jsonData.eGMgrModel;
						if (!Ext.isEmpty(eGMgrModel) && eGMgrModel.toLowerCase() == 'msp')
						{
							Ext.getCmp('AutoIpNameCheckID').disable();
							Ext.getCmp('NickIpCheck').disable();
							Ext.getCmp("authModeForLogin").hide();
						}
					}
				}
			);
		}

		if (record.data.text == notificationTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'managerNotification'});

			Ext.getCmp('innerPanel').setTitle(notificationTitle.toUpperCase());

			var url = "/final/admin/ManagerSettings/data/managerNotificationJSON.jsp";

			Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var enableLicenseExpiry = jsonData.enableLicenseExpiry;
						var licenseCountExpiryAlert = jsonData.licenseCountExpiryAlert;
						var popupDiscComps = jsonData.popupDiscComps;

						var alertForAgentsNotRun = jsonData.alertForAgentsNotRun;
						var alertForUnconfigAgents = jsonData.alertForUnconfigAgents;
						var alertForUpgradeTests = jsonData.alertForUpgradeTests;

						if (!Ext.isEmpty(enableLicenseExpiry) && (enableLicenseExpiry.toLowerCase() == 'true' || enableLicenseExpiry.toLowerCase() == 'yes'))
						{
							Ext.getCmp('yesExpiryAlert').setValue(true);
						}
						else
						{
							Ext.getCmp('noExpiryAlert').setValue(true);
						}

						if (!Ext.isEmpty(licenseCountExpiryAlert) && (licenseCountExpiryAlert.toLowerCase() == 'true' || licenseCountExpiryAlert.toLowerCase() == 'yes'))
						{
							Ext.getCmp('yesAgentExhaustedAlert').setValue(true);
						}
						else
						{
							Ext.getCmp('noAgentExhaustedAlert').setValue(true);
						}

						if (!Ext.isEmpty(popupDiscComps) && (popupDiscComps.toLowerCase() == 'true' || popupDiscComps.toLowerCase() == 'yes'))
						{
							Ext.getCmp('yesDiscCompsFlag').setValue(true);
						}
						else
						{
							Ext.getCmp('noDiscCompsFlag').setValue(true);
						}

						if (!Ext.isEmpty(alertForAgentsNotRun) && (alertForAgentsNotRun.toLowerCase() == 'true' || alertForAgentsNotRun.toLowerCase() == 'yes'))
						{
							Ext.getCmp('yesNotRunningAgents').setValue(true);
						}
						else
						{
							Ext.getCmp('noNotRunningAgents').setValue(true);
						}

						if (!Ext.isEmpty(alertForUnconfigAgents) && (alertForUnconfigAgents.toLowerCase() == 'true' || alertForUnconfigAgents.toLowerCase() == 'yes'))
						{
							Ext.getCmp('yesUnConfigAgentsList').setValue(true);
						}
						else
						{
							Ext.getCmp('noUnConfigAgentsList').setValue(true);
						}

						if (!Ext.isEmpty(alertForUpgradeTests) && (alertForUpgradeTests.toLowerCase() == 'true' || alertForUpgradeTests.toLowerCase() == 'yes'))
						{
							Ext.getCmp('yesUpgradeTests').setValue(true);
						}
						else
						{
							Ext.getCmp('noUpgradeTests').setValue(true);
						}
					}
				}
			);
		}

		/*if (index == 2)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'disccomponents'});

			Ext.getCmp('innerPanel').setTitle('Newly Discovered Components');

			var yesDiscCompsFlagObj = Ext.getCmp('yesDiscCompsFlag');
			var noDiscCompsFlagObj = Ext.getCmp('noDiscCompsFlag');

			var url = "/final/admin/ManagerSettings/data/managerSettingsJSON.jsp?index=disccomponents";

			Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var compsPopup = jsonData.discCompsPopupEnabled;

						if (compsPopup == true)
						{
							yesDiscCompsFlagObj.setValue('Yes');
						}

						if (compsPopup == false)
						{
							noDiscCompsFlagObj.setValue('No');
						}
					}
				}
			);
		}*/

		if (record.data.text == testConfigTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'testconfiguration'});

			Ext.getCmp('innerPanel').setTitle(testConfigTitle.toUpperCase());

			//var yesAllowPopupObj = Ext.getCmp('yesAllowpopup');
			//var noAllowPopupObj = Ext.getCmp('noAllowpopup');
			var yesEditHostObj = Ext.getCmp('yesEditHost');
			var noEditHostObj = Ext.getCmp('noEditHost');

			var url = "/final/admin/ManagerSettings/data/testConfigurationJSON.jsp";

			Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						//var allowPopup = jsonData.allowpopup;
						var editHost = jsonData.editHost;

						/*if (allowPopup == 'true' || allowPopup == 'True')
						{
							yesAllowPopupObj.setValue(true);
						}
						else
						{
							noAllowPopupObj.setValue(true);
						}*/

						if (editHost.toLowerCase() == 'true' || editHost.toLowerCase() == 'yes')
						{
							yesEditHostObj.setValue(true);
						}
						else
						{
							noEditHostObj.setValue(true);
						}
					}
				}
			);
		}

		if (record.data.text == threshConfigTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'thresholdconfiguration'});

			Ext.getCmp('innerPanel').setTitle(threshConfigTitle.toUpperCase());

			var threshIntervalForDisplayObj = Ext.getCmp('threshIntervalForDisplay');
			var thresholdCheckPeriodObj = Ext.getCmp('thresholdCheckPeriodID');
			var checkPeriodObj = Ext.getCmp('checkPeriodID');
			var daysIdObj = Ext.getCmp('daysId');

			threshIntervalForDisplayObj.setValue('Daily');

			var url = "/final/admin/ManagerSettings/data/thresholdConfigurationJSON.jsp";

			Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var thresholdChkVal = jsonData.thresholdChkVal;
						var thresholdChkInterval = jsonData.thresholdChkInterval;

						var tempShowText = '';

						thresholdCheckPeriodObj.setValue(thresholdChkVal);

						if (thresholdChkInterval == 'day')
						{
							thresholdChkIntervaltoDisplay = 'Daily';
							tempShowText = 'day' + '(s)';
						}
						else if (thresholdChkInterval == 'week')
						{
							thresholdChkIntervaltoDisplay = 'Weekly';
							tempShowText = 'week' + '(s)';
						}
						else if (thresholdChkInterval == 'month')
						{
							thresholdChkIntervaltoDisplay = 'Monthly';
							tempShowText = 'month' + '(s)';
						}

						threshIntervalForDisplayObj.setValue(thresholdChkIntervaltoDisplay);
						daysIdObj.setText(tempShowText);
					}
				}
			);
		}

		if (record.data.text == commandExecTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'commandexecution'});

			Ext.getCmp('innerPanel').setTitle(commandExecTitle.toUpperCase());

			var yesEnable_mailObj = Ext.getCmp('yesEnable_mail');
			var noEnable_mailObj = Ext.getCmp('noEnable_mail');

			var Log_maxsizeObj = Ext.getCmp('Log_maxsizeID');
			var yesLogEntriesObj = Ext.getCmp('yesLogEntries');
			var noLogEntriesObj = Ext.getCmp('noLogEntries');
			var yesSeparate_execObj = Ext.getCmp('yesSeparate_exec');

			var noSeparate_execObj = Ext.getCmp('noSeparate_exec');
			var Command_lengthObj = Ext.getCmp('Command_lengthID');
			var allowed_formatObj = Ext.getCmp('allowed_formatID');

			var url = "/final/admin/ManagerSettings/data/commandExecutionJSON.jsp";

			Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var enableCommand = jsonData.enableCommandExec;

						if (enableCommand.toLowerCase() == 'true' || enableCommand.toLowerCase() == 'yes')
						{
							yesEnable_mailObj.setValue(true);
						}
						else
						{
							noEnable_mailObj.setValue(true);
						}

						Log_maxsizeObj.setValue(jsonData.logSize);

						var logForStdout = jsonData.logForStdoutAlso;

						if (logForStdout.toLowerCase() == 'true' || logForStdout.toLowerCase() == 'yes')
						{
							yesLogEntriesObj.setValue(true);
						}
						else
						{
							noLogEntriesObj.setValue(true);
						}

						var SeparateExecution = jsonData.SeparateExec;

						if (SeparateExecution.toLowerCase() == 'true' || SeparateExecution.toLowerCase() == 'yes')
						{
							yesSeparate_execObj.setValue(true);
						}
						else
						{
							noSeparate_execObj.setValue(true);
						}

						Command_lengthObj.setValue(jsonData.cmdLength);
						allowed_formatObj.setValue(jsonData.allowed_format);

					},
				}
			);
		}

		if (record.data.text == 'Common Settings')
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'ttcommonsettings'});

			Ext.getCmp('innerPanel').setTitle('TROUBLE TICKET INTEGRATION');
			var allowedAlarmsCObj = Ext.getCmp('AllowedAlarmsC');
			var allowedAlarmsMObj = Ext.getCmp('AllowedAlarmsM');
			var allowedAlarmsMiObj = Ext.getCmp('AllowedAlarmsMi');
			//var allowedAlarmsNObj = Ext.getCmp('AllowedAlarmsN');

			var logFileMaxSizeObj = Ext.getCmp('LogFileMaxSize');

			var yesLogEntriesForStdoutAlsoObj = Ext.getCmp('yesLogEntriesForStdoutAlso');
			var noLogEntriesForStdoutAlsoObj = Ext.getCmp('noLogEntriesForStdoutAlso');

			var yesEnableDDObj = Ext.getCmp('yesEnableDD');
			var noEnableDDObj = Ext.getCmp('noEnableDD');

			var isCritical = '';
			var isMajor = '';
			var isMinor = '';
			var isNormal = '';

			var url = "/final/admin/ManagerSettings/data/commonSettingsTTI_JSON.jsp";
			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var sendNormailMail = jsonData.sendNormailMail;
					if (!Ext.isEmpty(sendNormailMail) && sendNormailMail.toLowerCase() == 'yes')
					{
						Ext.getCmp('yesSendNormalMail').setValue(true);
					}
					else
					{
						Ext.getCmp('noSendNormalMail').setValue(true);
					}

					//alarmsArray
					var allowedAlarmsArrayLength = jsonData.alarmsArray.length;
					for (var i=0; i<allowedAlarmsArrayLength; i++)
					{
						var allowedAlarmsValue = jsonData.alarmsArray[i].alarms;
						if (allowedAlarmsValue.toLowerCase() == 'critical')
						{
							isCritical = 'true';
						}
						if (allowedAlarmsValue.toLowerCase() == 'major')
						{
							isMajor = 'true';
						}
						if (allowedAlarmsValue.toLowerCase() == 'minor')
						{
							isMinor = 'true';
						}
						if (allowedAlarmsValue.toLowerCase() == 'normal')
						{
							isNormal = 'true';
						}
					}
					if (isCritical == 'true')
					{
						allowedAlarmsCObj.setValue(true);
					}
					else
					{
						allowedAlarmsCObj.setValue(false);
					}
					if (isMajor == 'true')
					{
						allowedAlarmsMObj.setValue(true);
					}
					else
					{
						allowedAlarmsMObj.setValue(false);
					}
					if (isMinor == 'true')
					{
						allowedAlarmsMiObj.setValue(true);
					}
					else
					{
						allowedAlarmsMiObj.setValue(false);
					}
					//if (isNormal == 'true')
					//{
						//allowedAlarmsNObj.setValue(true);
					//}
					//else
					//{
						//allowedAlarmsNObj.setValue(false);
					//}
					
					var enableDDStr = jsonData.enableDDStr;
					if (!Ext.isEmpty(enableDDStr) && enableDDStr.toLowerCase() == 'yes')
					{
						yesEnableDDObj.setValue(true);
					}
					else
					{
						noEnableDDObj.setValue(true);
					}

					var logEntriesForStdoutAlsoValue = jsonData.enableLogging;
					if (logEntriesForStdoutAlsoValue == 'Yes')
					{
						yesLogEntriesForStdoutAlsoObj.setValue(true);
					}
					else
					{
						noLogEntriesForStdoutAlsoObj.setValue(true);
					}

					logFileMaxSizeObj.setValue(jsonData.logFileMaxSize);
				}
			});
//
//			Ext.Ajax.request({
//				url: 'ManagerSettings/data/egttcommonsettingshelp.jsp?',
//				method: 'POST',
//			});
		}
		if (record.data.text == 'Mail / SNMP')
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'ttmanagermailsnmp'});

			Ext.getCmp('innerPanel').setTitle('TROUBLE TICKET INTEGRATION');

			var ttMailEnableObj = Ext.getCmp('TTMailEnable');
			var ttMailDisableObj = Ext.getCmp('TTMailDisable');


			var yesIncludeAllCompUserObj = Ext.getCmp('yesIncludeAllCompUser');
			var noIncludeAllCompUserObj = Ext.getCmp('noIncludeAllCompUser');

			var yesUseUniqueIdObj = Ext.getCmp('yesUseUniqueId');
			var noUseUniqueIdObj = Ext.getCmp('noUseUniqueId');

			var yesPriorityAsNumericObj = Ext.getCmp('yesPriorityAsNumeric');
			var noPriorityAsNumericObj = Ext.getCmp('noPriorityAsNumeric');

			var yesApplyPriorityForAllTTMailsObj = Ext.getCmp('yesApplyPriorityForAllTTMails');
			var noApplyPriorityForAllTTMailsObj = Ext.getCmp('noApplyPriorityForAllTTMails');

			var yesEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('yesEnableTTIntegrationForSNMPTraps');
			var noEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('noEnableTTIntegrationForSNMPTraps');
			
			var url = "/final/admin/ManagerSettings/data/mailSnmpTTI_JSON.jsp";

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var strEnableMail = jsonData.strEnableMail;

					if (!Ext.isEmpty(strEnableMail) && strEnableMail.toLowerCase() == 'yes')
					{
						ttMailEnableObj.setValue(true);
					}
					else
					{
						ttMailDisableObj.setValue(true);
					}

					if (!Ext.isEmpty(strEnableMail) && strEnableMail.toLowerCase() == 'yes')
					{
						Ext.getCmp('mailSettings').show();
						Ext.getCmp('MailSubject').setDisabled(false);
						Ext.getCmp('MailTo').setDisabled(false);
						Ext.getCmp('OutputFormat').setDisabled(false);


						var mailSubjectVal = jsonData.mailSubject;
						var mailToVal = jsonData.mailTo;
						var outputFormatVal = jsonData.outputFormat;
						var includeAllCompUserVal = jsonData.includeAllCompUser;
						var useUniqueIdVal = jsonData.useUniqueId;
						var priorityAsNumericVal = jsonData.priorityAsNumeric;
						var applyPriorityForAllTTMailsVal = jsonData.applyPriorityForAllTTMails;


						if (!Ext.isEmpty(mailSubjectVal))
						{
							Ext.getCmp('MailSubject').setValue(mailSubjectVal);
						}
						
						if (!Ext.isEmpty(mailToVal))
						{
							Ext.getCmp('MailTo').setValue(mailToVal);
						}
						if (!Ext.isEmpty(outputFormatVal))
						{
							Ext.getCmp('OutputFormat').setValue(outputFormatVal);
						}
						
						if (includeAllCompUserVal)
						{
							yesIncludeAllCompUserObj.setValue(true);
						}
						else
						{
							noIncludeAllCompUserObj.setValue(true);
						}

						if (useUniqueIdVal)
						{
							yesUseUniqueIdObj.setValue(true);
						}
						else
						{
							noUseUniqueIdObj.setValue(true);
						}
						
						if (priorityAsNumericVal)
						{
							yesPriorityAsNumericObj.setValue(true);
						}
						else
						{
							noPriorityAsNumericObj.setValue(true);
						}
						
						if (applyPriorityForAllTTMailsVal)
						{
							yesApplyPriorityForAllTTMailsObj.setValue(true);
						}
						else
						{
							noApplyPriorityForAllTTMailsObj.setValue(true);
						}
					}
					else
					{
						Ext.getCmp('mailSettings').hide();
						Ext.getCmp('MailSubject').setDisabled(true);
						Ext.getCmp('MailTo').setDisabled(true);
						Ext.getCmp('OutputFormat').setDisabled(true);
					}
					
					var enableTTIntegrationForSNMPTrapsVal = jsonData.enableTTIntegrationForSNMPTraps;
					if (enableTTIntegrationForSNMPTrapsVal)
					{
						yesEnableTTIntegrationForSNMPTrapsObj.setValue(true);
					}
					else
					{
						noEnableTTIntegrationForSNMPTrapsObj.setValue(true);
					}
				}
			});
		}
		if (record.data.text == 'CLI')
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'ttmanagercli'});

			Ext.getCmp('innerPanel').setTitle('TROUBLE TICKET INTEGRATION');

			var yesEnableExecForTTObj = Ext.getCmp('yesEnableExecForTT');
			var noEnableExecForTTObj = Ext.getCmp('noEnableExecForTT');

			var command2Obj = Ext.getCmp('Command2');
			var commandObj = Ext.getCmp('Command');

			var aDateFormatObj = Ext.getCmp('DateFormat');

			var commandLengthObj = Ext.getCmp('CommandLength');
			var probDescLengthObj = Ext.getCmp('ProbDescLength');

			var url = "/final/admin/ManagerSettings/data/cliTTI_JSON.jsp";
			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var enableExecForTTValue = jsonData.enableExecForTT;
					var commandValue = jsonData.command;

					if (enableExecForTTValue == 'Yes')
					{
						yesEnableExecForTTObj.setValue('Yes');
					}
					else
					{
						yesEnableExecForTTObj.setValue('No');
					}

					command2Obj.setValue(jsonData.command);
					commandObj.setValue(jsonData.execOutFormat);

					aDateFormatObj.getStore().loadRawData(jsonData.formatForDateArray);
					aDateFormatObj.setValue(jsonData.dateFormat);

					commandLengthObj.setValue(jsonData.commandLength);
					probDescLengthObj.setValue(jsonData.probDescLength);
				}
			});
		}
		if (record.data.text == itsmTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			var url = "/final/admin/ManagerSettings/data/TTintegrationListViewJSON.jsp";
			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					
					innerMainPanelObj.add({ 
						xtype: 'TTlistview',
						dataforView: jsonData['integrationList']
						});
					
					Ext.getCmp('innerPanel').setTitle(ttListPageTitle);		
				},
				failure: function(response){
					Ext.Msg.show({
						title: ttSettings,
						msg: 'Failed to load TT Integration List Page',
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
				}
				});
		}

		if (record.data.text == 'Web services')
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'ttmanagerwebservice'});

			Ext.getCmp('innerPanel').setTitle('TROUBLE TICKET INTEGRATION');

			isAcmeUploaded = 'no';
			var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
			var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

			var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
			var ttNameObj = Ext.getCmp('TT_Other');
			var ttUrlObj = Ext.getCmp('TT_Url');
			var ttUserNameObj = Ext.getCmp('TT_User_Name');
			var ttPasswordObj = Ext.getCmp('TT_Password');

			var ttOutputObj = Ext.getCmp('TT_Output');
			var ttApiKeyObj = Ext.getCmp('TT_Api_Key');
			var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
			var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
			
			var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp";
			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
					var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;

					archeiveFile = jsonData.ArchieveFile;
					var labelTxt = '<b>' + archeiveFile + '</b>';

					if (Ext.isEmpty(archeiveFile) || archeiveFile == ''){				
							Ext.getCmp('uploadLabel').hide();
							Ext.getCmp('removeLink').hide();						
					}
					else
					{
						Ext.getCmp('uploadLabel').show();
						Ext.getCmp('removeLink').show();
						isAcmeUploaded = 'yes';
						if(archeiveFile != null && archeiveFile.toLowerCase() != 'none')
						{
							if(archeiveFile.indexOf('.') == -1)
							{
								Ext.getCmp('uploadLabel').setText(archeiveFile+'.'+onlyJar,true);
							}
							else
							{
								Ext.getCmp('uploadLabel').setText(archeiveFile,true);
							}
						}
						else
						{
							Ext.getCmp('uploadLabel').hide();
							Ext.getCmp('removeLink').hide();
						}
					}

					if (TTIntegrationEnableValue.toLowerCase() =='yes' || TTIntegrationEnableValue.toLowerCase() == 'true')
					{
						ttIntegrationEnableObj.setValue(true);
					}
					else
					{
						ttIntegrationDisableObj.setValue(true);
					}
					ttIntegrationSystemObj.getStore().loadRawData(jsonData.ttIntegrationSystemArray);
					if (!Ext.isEmpty(jsonData.TTSys) && jsonData.TTSys == 'OTHERS')
					{
						ttIntegrationSystemObj.setValue(jsonData.ttIntegrationSystemArray[0].valueField);
					}
					else
					{
						ttIntegrationSystemObj.setValue(jsonData.TTSys);
					}

					var ttIntegrationSystem = jsonData.ttIntegrationSystemArray[0].displayField;

					var TTSys = jsonData.TTSys;
					TTSysForRemove = TTSys;

					var nameInOthersEngine = jsonData.TTOtherDispName;

					//if (TTSys != 'OTHERS')
					//{
						//Ext.getCmp('removeBtn').show();
					//}
					//else
					//{
						//Ext.getCmp('removeBtn').hide();
					//}

					if (ttIntegrationEnableObj.getValue())
					{
						Ext.suspendLayouts();
						Ext.getCmp('integrationSystem').show();
						Ext.getCmp('integrationSystemc').removeAll();
						Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
						Ext.getCmp('integrationSystemc').doLayout();
						//Ext.getCmp('wrapperClassNeeded').show();
						//Ext.getCmp('archiveUpload').show();
						//Ext.getCmp('wrapperClassNeeded').show();						
						Ext.resumeLayouts(true);

						if (isUploadArchieveEnable == 'block' && Ext.isEmpty(jsonData.TTWrapper))
						{
							yesttWrapperClassNeededObj.setValue(true);
						}
						else
						{
							nottWrapperClassNeededObj.setValue(true);
						}
						
					}

					if (ttIntegrationDisableObj.getValue())
					{
						Ext.suspendLayouts();
						Ext.getCmp('integrationSystem').hide();
						Ext.getCmp('integrationSystemc').removeAll();
						//Ext.getCmp('wrapperClassNeeded').hide();
						//Ext.getCmp('archiveUpload').hide();
						//Ext.getCmp('wrapperClassNeeded').hide();
						Ext.resumeLayouts(true);
					}
				}
			});

			Ext.Ajax.request({
				url: 'ManagerSettings/data/uploadWrapperJSONp.jsp?',
				method: 'POST',
			});
		}
		//if (index == 5)
		//{
			//innerMainPanelObj.removeAll();
			//innerMainPanelObj.add({ xtype: 'ttmanager'});

			//Ext.getCmp('innerPanel').setTitle('TT MANAGER');

			//var allowedAlarmsToSet = '';
			//isAcmeUploaded = 'no';

			//var yesEnableExecForTTObj = Ext.getCmp('yesEnableExecForTT');
			//var noEnableExecForTTObj = Ext.getCmp('noEnableExecForTT');

			//var command2Obj = Ext.getCmp('Command2');
			//var commandObj = Ext.getCmp('Command');
			//var logFileMaxSizeObj = Ext.getCmp('LogFileMaxSize');

			//var yesLogEntriesForStdoutAlsoObj = Ext.getCmp('yesLogEntriesForStdoutAlso');
			//var noLogEntriesForStdoutAlsoObj = Ext.getCmp('noLogEntriesForStdoutAlso');
			//var aDateFormatObj = Ext.getCmp('DateFormat');

			//var commandLengthObj = Ext.getCmp('CommandLength');
			//var probDescLengthObj = Ext.getCmp('ProbDescLength');
			//var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
			//var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

			//var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
			//var ttNameObj = Ext.getCmp('TT_Other');
			//var ttUrlObj = Ext.getCmp('TT_Url');
			//var ttUserNameObj = Ext.getCmp('TT_User_Name');
			//var ttPasswordObj = Ext.getCmp('TT_Password');

			//var ttOutputObj = Ext.getCmp('TT_Output');
			//var ttApiKeyObj = Ext.getCmp('TT_Api_Key');
			//var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
			//var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
			


			//var url = "/final/admin/ManagerSettings/data/managerSettingsJSON.jsp?index=ttmanager";

			//Ext.Ajax.request(
				//{
					//url : url,
					//scope:this,
					//method : 'POST',
					//success: function(response){
						//var jsonText = response.responseText;
						//var jsonData = Ext.decode(jsonText);

						//var enableExecForTTValue = jsonData.enableExecForTT;
						//var commandValue = jsonData.command;
						////alarmsArray
						//var allowedAlarmsArrayLength = jsonData.alarmsArray.length;
						//var logEntriesForStdoutAlsoValue = jsonData.logEntriesForStdoutAlso;
						//var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
						//var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;

						//var criticalAlarmsChecked = jsonData.criticalAlarms;
						//var majorAlarmsChecked = jsonData.majorAlarms;
						//var minorAlarmsChecked = jsonData.minorAlarms;
						//var normalAlarmsChecked = jsonData.normalAlarms;

						//archeiveFile = jsonData.ArchieveFile;
						//var labelTxt = '<b>' + archeiveFile + '</b>';

						//if (Ext.isEmpty(archeiveFile) || archeiveFile == '')
						//{
							//Ext.getCmp('uploadLabel').hide();
							//Ext.getCmp('removeLink').hide();
						//}
						//else
						//{
							//Ext.getCmp('uploadLabel').show();
							//Ext.getCmp('removeLink').show();
							//isAcmeUploaded = 'yes';
							//Ext.getCmp('uploadLabel').setText(archeiveFile+'.'+onlyJar,true);
						//}

						//if (enableExecForTTValue == 'Yes')
						//{
							//yesEnableExecForTTObj.setValue('Yes');
						//}
						//else
						//{
							//yesEnableExecForTTObj.setValue('No');
						//}

						//command2Obj.setValue(jsonData.command);
						//commandObj.setValue(jsonData.execOutFormat);

						//for (var i=0; i<allowedAlarmsArrayLength; i++)
						//{
							//var allowedAlarmsValue = jsonData.alarmsArray[i].alarms;

							//if (allowedAlarmsValue == 'critical')
							//{
								//isCritical = 'true';
							//}
							//if (allowedAlarmsValue == 'major')
							//{
								//isMajor = 'true';
							//}
							//if (allowedAlarmsValue == 'minor')
							//{
								//isMinor = 'true';
							//}
							//if (allowedAlarmsValue == 'normal')
							//{
								//isNormal = 'true';
							//}
						//}
						//if (isCritical == 'true')
						//{
							//allowedAlarmsCObj.setValue(true);
						//}
						//else
						//{
							//allowedAlarmsCObj.setValue(false);
						//}
						//if (isMajor == 'true')
						//{
							//allowedAlarmsMObj.setValue(true);
						//}
						//else
						//{
							//allowedAlarmsMObj.setValue(false);
						//}
						//if (isMinor == 'true')
						//{
							//allowedAlarmsMiObj.setValue(true);
						//}
						//else
						//{
							//allowedAlarmsMiObj.setValue(false);
						//}
						//if (isNormal == 'true')
						//{
							//allowedAlarmsNObj.setValue(true);
						//}
						//else
						//{
							//allowedAlarmsNObj.setValue(false);
						//}

						//aDateFormatObj.getStore().loadRawData(jsonData.formatForDateArray);
						//aDateFormatObj.setValue(jsonData.dateFormat);

						//commandLengthObj.setValue(jsonData.commandLength);
						//probDescLengthObj.setValue(jsonData.probDescLength);

						//if (TTIntegrationEnableValue == 'Yes')
						//{
							//ttIntegrationEnableObj.setValue(true);
						//}
						//else
						//{
							//ttIntegrationDisableObj.setValue(true);
						//}

						//ttIntegrationSystemObj.getStore().loadRawData(jsonData.ttIntegrationSystemArray);
						//ttIntegrationSystemObj.setValue(jsonData.TTSys);

						//var ttIntegrationSystem = jsonData.ttIntegrationSystemArray[0].displayField;

						//var TTSys = jsonData.TTSys;
						//TTSysForRemove = TTSys;

						//var nameInOthersEngine = jsonData.TTOtherDispName;

						//if (TTSys != 'OTHERS')
						//{
							////Ext.getCmp('TT_Other').hide();
							//Ext.getCmp('removeBtn').show();
						//}
						//else
						//{
							////Ext.getCmp('TT_Other').show();
							////Ext.getCmp('TT_Other').setValue(nameInOthersEngine);
							//Ext.getCmp('removeBtn').hide();
						//}

						//if (ttIntegrationEnableObj.getValue())
						//{
							//Ext.suspendLayouts();
							//Ext.getCmp('integrationSystem').show();
							///*Ext.getCmp('TT_Url').show();
							//Ext.getCmp('TT_User_Name').show();
							//Ext.getCmp('TT_Password').show();

							//Ext.getCmp('TT_Output').show();*/
							//Ext.getCmp('integrationSystemc').removeAll();
							//Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
							//Ext.getCmp('integrationSystemc').doLayout();
							//Ext.getCmp('wrapperClassNeeded').show();
							//Ext.getCmp('archiveUpload').show();
							////Ext.getCmp('TT_Api_Key').show();

							////Ext.getCmp('TT_Output').show();
							//Ext.getCmp('wrapperClassNeeded').show();
							////Ext.getCmp('TT_Api_Key').show();

							//Ext.getCmp('allowedAlarms').show();
							//Ext.resumeLayouts(true);

							//if (isUploadArchieveEnable == 'block')
							//{
								//yesttWrapperClassNeededObj.setValue(true);
							//}
							//else
							//{
								//nottWrapperClassNeededObj.setValue(true);
							//}
						
							////ttUrlObj.setValue(jsonData.TTUrl);
							////ttUserNameObj.setValue(jsonData.TTUsername);
							////ttPasswordObj.setValue(jsonData.TTPassword);
							////ttOutputObj.setValue(jsonData.TTOutput);

							////ttApiKeyObj.setValue(jsonData.TTApiKey);

							//if (criticalAlarmsChecked == 'checked')
							//{
								//ttAllowedAlarmsCObj.setValue(true);
							//}
							//else
							//{
								//ttAllowedAlarmsCObj.setValue(false);
							//}
							//if (majorAlarmsChecked == 'checked')
							//{
								//ttAllowedAlarmsMObj.setValue(true);
							//}
							//else
							//{
								//ttAllowedAlarmsMObj.setValue(false);
							//}
							//if (minorAlarmsChecked == 'checked')
							//{
								//ttAllowedAlarmsMiObj.setValue(true);
							//}
							//else
							//{
								//ttAllowedAlarmsMiObj.setValue(false);
							//}
							//if (normalAlarmsChecked == 'checked')
							//{
								//ttAllowedAlarmsNObj.setValue(true);
							//}
							//else
							//{
								//ttAllowedAlarmsNObj.setValue(false);
							//}
						//}

						//if (ttIntegrationDisableObj.getValue())
						//{
							//Ext.suspendLayouts();

							//Ext.getCmp('integrationSystem').hide();
							///*Ext.getCmp('TT_Other').hide();
							//Ext.getCmp('TT_Url').hide();
							//Ext.getCmp('TT_User_Name').hide();
							//Ext.getCmp('TT_Password').hide();

							//Ext.getCmp('TT_Output').hide();*/
							//Ext.getCmp('integrationSystemc').removeAll();
							//Ext.getCmp('wrapperClassNeeded').hide();
							//Ext.getCmp('archiveUpload').hide();
							////Ext.getCmp('TT_Api_Key').hide();

							////Ext.getCmp('TT_Output').hide();
							//Ext.getCmp('wrapperClassNeeded').hide();
							////Ext.getCmp('TT_Api_Key').hide();

							//Ext.getCmp('allowedAlarms').hide();

							//Ext.resumeLayouts(true);
						//}

					//}
				//}
			//);
		//}

		if (record.data.text == logSettingsPageTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'logsettings'});

			Ext.getCmp('innerPanel').setTitle(logSettingsPageTitle.toUpperCase());

			var yesLogDbCleanupObj = Ext.getCmp('yesLogDbCleanup');
			var noLogDbCleanupObj = Ext.getCmp('noLogDbCleanup');

			var yesLogScheduleReportsObj = Ext.getCmp('yesLogScheduleReports');
			var noLogScheduleReportsObj = Ext.getCmp('noLogScheduleReports');

			var yesTrendLogObj = Ext.getCmp('yesTrendLog');
			var noTrendLogObj = Ext.getCmp('noTrendLog');

			var yesThresholdLogObj = Ext.getCmp('yesThresholdLog');
			var noThresholdLogObj = Ext.getCmp('noThresholdLog');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/logSettingsJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );

						var logDbCleanupValue = publicJSON.logDbCleanup;
						var logScheduleReportsValue = publicJSON.logScheduleReports;
						var trendLogValue = publicJSON.trendLog;
						var thresholdLogValue = publicJSON.thresholdLog;

						if (logDbCleanupValue.toLowerCase() == 'true' || logDbCleanupValue.toLowerCase() == 'yes')
						{
							yesLogDbCleanupObj.setValue('Yes');
						}
						else
						{
							noLogDbCleanupObj.setValue('No');
						}

						if (logScheduleReportsValue.toLowerCase() == 'true' || logScheduleReportsValue.toLowerCase() == 'yes')
						{
							yesLogScheduleReportsObj.setValue('Yes');
						}
						else
						{
							noLogScheduleReportsObj.setValue('No');
						}

						if (trendLogValue.toLowerCase() == 'true' || trendLogValue.toLowerCase() == 'yes')
						{
							yesTrendLogObj.setValue('Yes');
						}
						else
						{
							noTrendLogObj.setValue('No');
						}

						if (thresholdLogValue.toLowerCase() == 'true' || thresholdLogValue.toLowerCase() == 'yes')
						{
							yesThresholdLogObj.setValue('Yes');
						}
						else
						{
							noThresholdLogObj.setValue('No');
						}
					}
				}
			});
		}

		if (record.data.text == auditSetTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'auditing'});

			Ext.getCmp('innerPanel').setTitle(auditSetTitle.toUpperCase());

			var yesEnableAuditlogObj = Ext.getCmp('yesEnableAuditlog');
			var noEnableAuditlogObj = Ext.getCmp('noEnableAuditlog');

			var yesAuditlogForCLIObj = Ext.getCmp('yesAuditlogForCLI');
			var noAuditlogForCLIObj = Ext.getCmp('noAuditlogForCLI');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/auditingJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var auditingJSON = Ext.decode( jsonText );

						var enableAuditLog = auditingJSON.auditLogJson.EnableAuditlog;

						var auditlogForCLI = auditingJSON.auditLogJson.auditlogForCLI;

						if (enableAuditLog == 'yes')
						{
							yesEnableAuditlogObj.setValue('yes');
						}

						if (enableAuditLog == 'no')
						{
							noEnableAuditlogObj.setValue('no');
						}

						if (auditlogForCLI == 'true')
						{
							yesAuditlogForCLIObj.setValue('true');
						}

						if (auditlogForCLI == 'false')
						{
							noAuditlogForCLIObj.setValue('false');
						}
					}
				}
			});
		}

		if (record.data.text == advSetTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'advancedsettings'});

			Ext.getCmp('innerPanel').setTitle(advSetTitle.toUpperCase());

			var yesStlnMgrRestartObj = Ext.getCmp('yesStlnMgrRestart');
			var noStlnMgrRestartObj = Ext.getCmp('noStlnMgrRestart');

			var stlnMgrRestart_stand_alone = Ext.getCmp('stlnMgrRestart');
			var stlnMgrRestart_pri = Ext.getCmp('stlnMgrRestart_pri');
			var stlnMgrRestart_sec = Ext.getCmp('stlnMgrRestart_sec');

			var yesMgrOutputObj = Ext.getCmp('yesMgrOutput');
			var noMgrOutputObj = Ext.getCmp('noMgrOutput');

			var yesMgrOutputOverWirteObj = Ext.getCmp('yesMgrOutputOverWirte');
			var noMgrOutputOverWirteObj = Ext.getCmp('noMgrOutputOverWirte');

			var yesManConfigObj = Ext.getCmp('yesManConfig');
			var noManConfigObj = Ext.getCmp('noManConfig');

			var yesExtAgentObj = Ext.getCmp('yesExtAgent');
			var noExtAgentObj = Ext.getCmp('noExtAgent');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/advanceSettingsJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var advSetJSON = Ext.decode( jsonText );

						var managerOutputValue = advSetJSON.managerOutput;
						var mgrOutputOverWriteValue = advSetJSON.mgrOutputOverWirte;
						var updateManConfigValue = advSetJSON.updateManConfig;
						var nowExtAgentValue = advSetJSON.nowExtAgent;
						var manualDebug = advSetJSON.managerDebug;
						if(manualDebug == 'yes')
						{
							var comp = Ext.getCmp('mgrOutput');
							comp.setDisabled(true);
							comp.setFieldLabel(' * '+comp.getFieldLabel());
							var display = Ext.create('Ext.form.field.Display',{
								value: '* Manager output and error has been manually enabled.'
							});
							Ext.getCmp('display').show();
							Ext.getCmp('display').setTitle('<b>Note</b>');
							Ext.getCmp('display').add(display);
						}
						noStlnMgrRestartObj.setValue(true);

						if(advSetJSON.isClusterManager)
						{
							stlnMgrRestart_stand_alone.setVisible(false);
							stlnMgrRestart_pri.setVisible(true);
							stlnMgrRestart_sec.setVisible(true);
						}
						else
						{
							stlnMgrRestart_stand_alone.setVisible(true);
							stlnMgrRestart_pri.setVisible(false);
							stlnMgrRestart_sec.setVisible(false);
						}
						if (managerOutputValue == 'yes')
						{
							yesMgrOutputObj.setValue('Yes');
						}

						if (managerOutputValue == 'no')
						{
							noMgrOutputObj.setValue('No');
						}

						if (mgrOutputOverWriteValue == 'yes')
						{
							yesMgrOutputOverWirteObj.setValue('Yes');
						}

						if (mgrOutputOverWriteValue == 'no')
						{
							noMgrOutputOverWirteObj.setValue('No');
						}

						if(nowExtAgentValue == 'yes')
						{
							yesExtAgentObj.setValue('yes');
						}
						else if(nowExtAgentValue == 'no')
						{
							noExtAgentObj.setValue('no');
						}
						if(advSetJSON.aggregateLicenseSupported)
						{
							Ext.getCmp('extAgent').show();
						}
						else
						{
							Ext.getCmp('extAgent').hide();
						}
						noManConfigObj.setValue('no');
					}
				}
			});
		}

		if (record.data.text == capPlanTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'capacityplanning'});

			Ext.getCmp('innerPanel').setTitle(capPlanTitle.toUpperCase());

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/capacityPlanningJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var capacityPlanningJSON = Ext.decode( jsonText );

						var yesCapacityTrendObj = Ext.getCmp('yesCapacityTrend');
						var noCapacityTrendObj = Ext.getCmp('noCapacityTrend');

						var yesCapcityreportObj = Ext.getCmp('yesCapcityreport');
						var noCapcityreportObj = Ext.getCmp('noCapcityreport');

						var capacityTrendValue = capacityPlanningJSON.capacitytrendenable;
						var capcityReportValue = capacityPlanningJSON.capacityreportenable;

						if (capacityTrendValue == 'true')
						{
							yesCapacityTrendObj.setValue('true');
						}

						if (capacityTrendValue == 'false')
						{
							noCapacityTrendObj.setValue('false');
						}

						if (capcityReportValue == 'true')
						{
							yesCapcityreportObj.setValue('true');
						}

						if (capcityReportValue == 'false')
						{
							noCapcityreportObj.setValue('false');
						}
					}
				}
			});
		}

		if (record.data.text == virtualTopoTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'virtualtopology'});

			Ext.getCmp('innerPanel').setTitle(virtualTopoTitle.toUpperCase());

			var yesVirtualmappingObj = Ext.getCmp('yesVirtualmapping');
			var noVirtualmappingObj = Ext.getCmp('noVirtualmapping');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/virtualTopologyJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var virtualTopoJSON = Ext.decode( jsonText );

						var virtualMappingValue = virtualTopoJSON.strVirtualMapping;

						if (virtualMappingValue == 'true')
						{
							yesVirtualmappingObj.setValue('Auto');
						}

						if (virtualMappingValue == 'false')
						{
							noVirtualmappingObj.setValue('Manual');
						}
					}
				}
			});
		}
		
		if (record.data.text == lockoutTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'acklockout'});

			Ext.getCmp('innerPanel').setTitle(lockoutTitle.toUpperCase());

			var genericObj = Ext.getCmp('generic');
			var specificObj = Ext.getCmp('specific');

			var yesLockObj = Ext.getCmp('yesLock');
			var noLockObj = Ext.getCmp('noLock');
			
			var resetObj = Ext.getCmp('rlckStrategy');
			var timeperiodObj = Ext.getCmp('tlckStrategy');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/accountLockoutJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var acklckJSON = Ext.decode( jsonText );

						var InvalidLoginMsg = acklckJSON.InvalidLoginMsg;
						var userAL = acklckJSON.userAL;
						var userNA = acklckJSON.userNA;
						var userLS = acklckJSON.userLS;
						var userTP = acklckJSON.userTP;
			
						if (InvalidLoginMsg == 'G')
						{
							genericObj.setValue(true);
						}
						else
						{
							specificObj.setValue(true);
						}


						var useral = userAL.toLowerCase();

						Ext.getCmp('nofAttmpt').setValue(acklckJSON['userNA']);
						Ext.getCmp('timeperiod').setValue(acklckJSON['userTP']);

						if (useral == 'true' || useral == 'yes' )
						{
							useral = 'yes';
						}
						else
						{
							useral = 'no';
						}

						if (useral == 'yes' && userLS == 'R')
						{
							yesLockObj.setValue(true);
							resetObj.setValue(true);
							Ext.getCmp('nofAttmpt').show();
							Ext.getCmp('timeperiod').hide();
						}
						else if (useral == 'yes' && userLS == 'T')
						{
							yesLockObj.setValue(true);
							timeperiodObj.setValue(true);
							Ext.getCmp('nofAttmpt').show();
							Ext.getCmp('timeperiod').show();
						}
						else if (useral == 'no' && userLS == 'T')
						{
							noLockObj.setValue(true);
							timeperiodObj.setValue(true);
							Ext.getCmp('nofAttmpt').hide();
							Ext.getCmp('lckStrategy').hide();
							Ext.getCmp('timeperiod').hide();
						}
						else if (useral == 'no' && userLS == 'R')
						{
							noLockObj.setValue(true);
							resetObj.setValue(true);
							Ext.getCmp('nofAttmpt').hide();
							Ext.getCmp('lckStrategy').hide();
							Ext.getCmp('timeperiod').hide();
						}
					}
				}
			});
		}

		if (record.data.text == SSOTitleLbl)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'singlesignon'});

			Ext.getCmp('innerPanel').setTitle(SSOTitleLbl.toUpperCase());

			var yesLoginObj = Ext.getCmp('yesssoLogin');
			var noLoginObj = Ext.getCmp('nossoLogin');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/EgSamlSsoJson.jsp',
				method: 'POST',
				timeout: 120000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						ssoLoginJson = Ext.decode( jsonText );
						if (ssoLoginJson.isLogin)
						{
							yesLoginObj.setValue(true);

							Ext.getCmp('idpLogout').show();

							if (ssoLoginJson.isIdpLogout)
							{
								Ext.getCmp('yesidpLogout').setValue(true);

							}
							else
							{
								Ext.getCmp('noidpLogout').setValue(true);
							}
						}
						else
						{
							noLoginObj.setValue(true);

							if (!Ext.isEmpty(Ext.getCmp('idpLogout')) && Ext.getCmp('idpLogout').isVisible())
							{
								Ext.getCmp('idpLogout').hide();
							}
						}
					}
				}
			});
		}

		if (record.data.text == pwdpolicyTitle)
		{
			var mee = this;
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'pwdpolicy'});

			Ext.getCmp('innerPanel').setTitle(pwdpolicyTitle.toUpperCase());

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/passwordPolicyJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var pwdpolicyJSON = Ext.decode( jsonText );
						Ext.getCmp('minLen').setValue(pwdpolicyJSON['pwdMinLength']);
						if(pwdpolicyJSON['pwdMinHistoryEnable'] == "true" || pwdpolicyJSON['pwdMinHistoryEnable'] == "yes")
						{
							Ext.getCmp('minHistoryEnableYes').setValue(true);
							Ext.getCmp('minHistoryEnableNo').setValue(false);
							Ext.getCmp('minHistory').show();
						}
						else
						{
							Ext.getCmp('minHistoryEnableYes').setValue(false);
							Ext.getCmp('minHistoryEnableNo').setValue(true);
							Ext.getCmp('minHistory').hide();
						}
						Ext.getCmp('minHistory1').setValue(pwdpolicyJSON['pwdMinHistory']);
						mee.setPasswordComplexity(pwdpolicyJSON['pwdComplexity']);
					}
				}
			});
		}

		if (record.data.text == secureFilterTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'securityfilter'});

			Ext.getCmp('innerPanel').setTitle(secureFilterTitle.toUpperCase());

			var yesSecurityfilterObj = Ext.getCmp('yesSecurityfilter');
			var noSecurityfilterObj = Ext.getCmp('noSecurityfilter');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/EgSecurityFilterJson.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var secureJson = Ext.decode( jsonText );

						var isEnableSecurityFilters = secureJson.isEnableSecurityFilters;

						if (isEnableSecurityFilters)
						{
							yesSecurityfilterObj.setValue(true);
						}
						else 
						{
							noSecurityfilterObj.setValue(true);
						}
					}
				}
			});
		}

		// for 2fa - starts here
		if (record.data.text == TFATitle2)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'twofactorauth'});
			thisController.get2FAConfigDetails();

			Ext.getCmp('innerPanel').setTitle(TFATitle2.toUpperCase());
		}
		// for 2fa - ends here
		
		if (record.data.text == ipPolicyTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + ipPolicyDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ 
				xtype: 'fieldset',
				title: '<b>'+ipPolicyTitle.toUpperCase()+'</b>',
				layout: {
					type: 'vbox',
					pack: 'center',
					align: 'center'
				},
				defaults: {
					labelSeparator: ' ',
					margin: 5,
					labelWidth: 200
				},
				margin: 20,
				id: 'egippolicy',
				items: [
					{
						xtype: 'label',
						id: 'adminPolicyLabel',
						hidden: true,
						html: '<center>Restrict admin activities to the below IP addresses/range.</center>',
						style: {
							fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',
							fontSize: '10px'
						},
						height: 25,
						margin: '5 5 10 5'
					},
					{
						xtype: 'container',
						id: 'backupmultiipcontainer',
						width: 350,
						layout: {
							type: 'vbox',
							pack: 'center',
							align: 'stretch'
						}
					},
					{
						xtype: 'container',
						id: 'NoMultiIPPattern',
						width: 400,
						hidden: true,
						layout: {
							type: 'hbox',
							pack: 'center',
							align: 'center'
						},
						border:true,
						flex:1,
						columnWidth:1,
						items: [
							{
								xtype: 'label',
								html: '<table border="0px"><tr><td align="center"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+noIPPolicyMsg+'!</div></td></tr></table></td></tr></table>'
							}
						]
					}
				]
			},
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					pack: 'center'
				},
				margin: '0 0 10 0',
				items: [
					{
						xtype: 'button',
						cls: 'button20',
						id: 'addMultiIP',
						width: 110,
						text: addMorePolicyMsg,
						listeners : 
						{
							'click' : function()
							{
								addMultiIPPolicy();
							}
						}
					},
					{
						xtype: 'button',
						cls: 'button20',
						text: updateBtnText,
						width: 110,
						id: 'updateMultiIP',
						name: 'updateMultiIP',
						margin: '0 0 0 10',
						listeners : 
						{
							'click' : function()
							{
								thisController.updateMultiIPPolicy();
							}
						}
					},
					{
						xtype: 'button',
						cls: 'button20',
						text: deleteAllMsg,
						width: 110,
						id: 'clearMultiIP',
						name: 'clearMultiIP',
						margin: '0 0 0 10',
						listeners : 
						{
							'click' : function()
							{
								thisController.clearMultiIPPolicy();
							}
						}
					}
				]
			});
			Ext.getCmp('innerPanel').setTitle(ipPolicyTitle);
			thisController.interConfigMultiIPPolicy();
		}

		if (record.data.text == mgrModelTitle)
		{
			Ext.getCmp('pageDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + generalSettingsDesc + '</center>');
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'egmgrmodel'});
			Ext.getCmp('innerPanel').setTitle(mgrModelTitle.toUpperCase());
			thisController.getMgrModelDetails();
		}
		if (record.data.text == deleteUseresSetTitle)
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'deleteusers'});

			Ext.getCmp('innerPanel').setTitle('DELETE USER ACCOUNTS');

			Ext.Ajax.request({
				url: '/final/admin/ManagerSettings/data/deleteUsersJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if(response.status == 200 && !Ext.isEmpty( response.responseText))
					{
						var expiredUsersJson = Ext.decode( response.responseText );
						var showCompDel=true;
						if(expiredUsersJson.deleteUsersJson.eGMgrModel=='msp')
						{
							if(expiredUsersJson.deleteUsersJson.allowDeleteOrg)
							{
								var allowDeleteOrg = Ext.getCmp('allowDeleteOrg');
								allowDeleteOrg.items.items[0].setValue(true);
								allowDeleteOrg.show();

								var deleteOrgRadio = Ext.getCmp('deleteOrg');
								if(expiredUsersJson.deleteUsersJson.deleteOrg=='true')
								{
									deleteOrgRadio.items.items[0].setValue(true);
									Ext.getCmp('deletecontents').show();
								}
								else
								{
									deleteOrgRadio.items.items[1].setValue(true);
									Ext.getCmp('deletecontents').show();
								}
								Ext.getCmp('deleteOrg').show();
								Ext.getCmp('deleteSubOU').hide();
							}
							else
							{
								var allowDeleteOrg = Ext.getCmp('allowDeleteOrg');
								allowDeleteOrg.items.items[1].setValue(true);
								allowDeleteOrg.show();

								Ext.getCmp('deleteOrg').hide();
								Ext.getCmp('deleteSubOU').hide();
								Ext.getCmp('deletecontents').hide();

								var deleteImmediatelyRadio = Ext.getCmp('immediateDeleteType');
								deleteImmediatelyRadio.items.items[0].setValue(true);
								deleteImmediatelyRadio.hide();
								Ext.getCmp('daysNotReporting').hide();
								Ext.getCmp('daysNotReportingContainer').hide();
								Ext.getCmp('daysId').hide();

							}
						}
						else
						{
							Ext.getCmp('allowDeleteOrg').hide();
							Ext.getCmp('deleteOrg').hide();
							Ext.getCmp('deleteSubOU').show();

							var deleteSubOURadio = Ext.getCmp('deleteSubOU');
							if(expiredUsersJson.deleteUsersJson.deleteSubOU)
							{
								deleteSubOURadio.items.items[0].setValue(true);
								Ext.getCmp('deletecontents').show();
							}
							else
							{
								deleteSubOURadio.items.items[1].setValue(true);
								Ext.getCmp('deletecontents').hide();
								showCompDel=false;

								var deleteImmediatelyRadio = Ext.getCmp('immediateDeleteType');
								deleteImmediatelyRadio.items.items[0].setValue(true);
								deleteImmediatelyRadio.hide();
								Ext.getCmp('daysNotReporting').hide();
								Ext.getCmp('daysNotReportingContainer').hide();
								Ext.getCmp('daysId').hide();
							}
						}

						Ext.getCmp('zones').setValue(expiredUsersJson.deleteUsersJson.zones);
						Ext.getCmp('servicegroups').setValue(expiredUsersJson.deleteUsersJson.servicegroups);
						Ext.getCmp('services').setValue(expiredUsersJson.deleteUsersJson.services);
						Ext.getCmp('segments').setValue(expiredUsersJson.deleteUsersJson.segments);
						Ext.getCmp('groups').setValue(expiredUsersJson.deleteUsersJson.groups);
						Ext.getCmp('components').setValue(expiredUsersJson.deleteUsersJson.components);
						Ext.getCmp('exremote').setValue(expiredUsersJson.deleteUsersJson.exremote);

						Ext.getCmp('daysAfter').setValue(expiredUsersJson.deleteUsersJson.autoDeleteDays);
						if(expiredUsersJson.deleteUsersJson.components || expiredUsersJson.deleteUsersJson.exremote)
						{
							Ext.getCmp('immediateDeleteType').show();

							Ext.getCmp('daysNotReporting').setValue(expiredUsersJson.deleteUsersJson.compsNotReportingDays);
							var deleteImmediatelyRadio = Ext.getCmp('immediateDeleteType');
							if(expiredUsersJson.deleteUsersJson.deleteImmediately=='yes')
							{
								deleteImmediatelyRadio.items.items[0].setValue(true);
								Ext.getCmp('daysNotReporting').hide();
								Ext.getCmp('daysNotReportingContainer').hide();
								Ext.getCmp('daysId').hide();
							}
							else
							{
								deleteImmediatelyRadio.items.items[1].setValue(true);
								Ext.getCmp('daysNotReporting').show();
								Ext.getCmp('daysNotReportingContainer').show();
								Ext.getCmp('daysId').show();
							}
						}
						else
						{
							Ext.getCmp('immediateDeleteType').hide();
							Ext.getCmp('daysNotReporting').hide();
							Ext.getCmp('daysNotReportingContainer').hide();
							Ext.getCmp('daysId').hide();

							Ext.getCmp('daysNotReporting').setValue(expiredUsersJson.deleteUsersJson.compsNotReportingDays);
							var deleteImmediatelyRadio = Ext.getCmp('immediateDeleteType');
							if(expiredUsersJson.deleteUsersJson.deleteImmediately=='yes')
							{
								deleteImmediatelyRadio.items.items[0].setValue(true);
							}
							else
							{
								deleteImmediatelyRadio.items.items[1].setValue(true);
							}
						}
						var autoDeleteExpUsersRadio = Ext.getCmp('autoDeleteExpUsers');
						if(expiredUsersJson.deleteUsersJson.autoDeleteExpUsers=='yes')
						{
							autoDeleteExpUsersRadio.items.items[0].setValue(true);
							Ext.getCmp('daysAfter').show();
							Ext.getCmp('daysNotReportingContainer_auto').show();
							Ext.getCmp('daysId_auto').show();
						}
						else
						{
							autoDeleteExpUsersRadio.items.items[1].setValue(true);
							Ext.getCmp('daysAfter').hide();
							Ext.getCmp('daysNotReportingContainer_auto').hide();
							Ext.getCmp('daysId_auto').hide();
						}
					}
				},
				failure: function(response)
				{
					alert('Error in delete user settings of manager settings');
				}
			});
		}
	},

	getMgrModelDetails: function()
	{
		Ext.Ajax.request(
		{
			url : 'ManagerSettings/data/EgManagerModelJson.jsp',
			method: 'POST',
			params :
			{
				'comeFrom' : 'getMgrModel'
			},
			success: function(response)
			{
				var jsonText = response.responseText;
				var publicJson = Ext.decode(jsonText);
				var eGMgrModel = publicJson['eGMgrModel'];
				var issueUUID = publicJson['issueUUID'];
				if (!Ext.isEmpty(eGMgrModel) && eGMgrModel.toLowerCase() == "msp")
				{
					Ext.getCmp('mgrModelMsp').setValue(true);
				}
				else
				{
					Ext.getCmp('mgrModelEnterprise').setValue(true);
				}

				if (!Ext.isEmpty(issueUUID) && (issueUUID.toLowerCase() == "yes" || issueUUID.toLowerCase() == "true"))
				{
					Ext.getCmp('issueuuidyes').setValue(true);
				}
				else
				{
					Ext.getCmp('issueuuidno').setValue(true);
				}

				var mgrModelEnterprise = Ext.getCmp('mgrModelEnterprise').getGroupValue();
				if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "enterprise")
				{
					//Ext.getCmp('issueuuid').show();
				}
				else
				{
					//Ext.getCmp('issueuuid').hide();
				}
			},
			failure : function()
			{
			}
		});
	},
	
	mgrModelRadioChange: function()
	{
		var mgrModelEnterprise = Ext.getCmp('mgrModelEnterprise').getGroupValue();
		if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "enterprise")
		{
			Ext.getCmp('issueuuidno').setValue(true);
			//Ext.getCmp('issueuuid').show();
			var configureMailServerSettings = Ext.getCmp('configureMailServerSettings');
			if (configureMailServerSettings != null && configureMailServerSettings != undefined)
			{
				mgrModelFieldSet = Ext.getCmp('mgrModelFieldSet');
				mgrModelFieldSet.remove(configureMailServerSettings);
				mgrModelFieldSet.doLayout();
			}
			Ext.getCmp('mgrModelUpdate').enable();
		}
		else
		{
			if (!Ext.isEmpty(isMailSettingsConfiguredForMSP) && !isMailSettingsConfiguredForMSP)
			{
				var win1 = Ext.widget('grid',{
					modal: true,
					id: 'configureMailServerSettings',
					layout: 'fit',
					cls: 'gridSkin',
					flex: 1,
					margin: 5,
					hideHeaders: true,
					emptyText: 'No data found',
					viewConfig: {
						deferEmptyText: false
					},
					store:new Ext.data.Store({
						fields: ['Message'],
						data: {'Message' : '<table align="center"><tr><td><div class="iconExclamation"></div></td><td><div style="padding:2px">Before enabling this flag, please configure </div></td><td><div style="cursor:pointer;text-decoration:underline;padding:2px" onClick="javascript:thisController.goToconfigureMailServerSettings()">Mail Server Settings!</div></td></tr></table>'},
					}),
					columns:{
						items: [
							{
								dataIndex: 'Message',
								flex : 1,
								renderer:function(val, metaData, record, row, col, store, gridView) {
									val = '<div style="cursor:pointer;">'+val+'</div>';
									if (val != null || val != '')
										return val;
								}
							}
						]
					}
				});
				mgrModelFieldSet = Ext.getCmp('mgrModelFieldSet');
				mgrModelFieldSet.add(win1);
				mgrModelFieldSet.doLayout();
				Ext.getCmp('mgrModelUpdate').disable();
			}
			else
			{
				Ext.getCmp('mgrModelUpdate').enable();
			}
		}
	},
	
	goToconfigureMailServerSettings : function()
	{
		window.location.href="EgMailServerSettings.jsp?reqfrom=egmgrmodel";
	},

	updateMgrModel: function()
	{
		var mgrModelEnterprise = Ext.getCmp('mgrModelEnterprise').getGroupValue();
		var issueuuidyes = Ext.getCmp('issueuuidyes').getGroupValue();
		if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "msp")
		{
			issueuuidyes = "yes";
		}
		Ext.Ajax.request(
		{
			url : 'ManagerSettings/data/EgManagerModelJson.jsp',
			method: 'POST',
			params :
			{
				'comeFrom' : 'updateMgrModel',
				'eGMgrModel' : mgrModelEnterprise,
				'issueUUID' : issueuuidyes
			},
			success: function(response)
			{
				var jsonText = response.responseText;
				var publicJson = Ext.decode(jsonText);
				if (publicJson['success'] == true)
				{
					Ext.Msg.show({
						title : mgrModelTitle,
						msg : mgrUpdateSuccessMsg+'.',
						icon : 'iconInformation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							window.location.href = '/final/admin/EgManagerSettingsTree.jsp?select=egmgrmodel';
						}
					});
				}
				else
				{
					Ext.Msg.show({
						title : mgrModelTitle,
						msg : mgrUpdateErrorMsg+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK
					});
				}
			},
			failure : function()
			{
			}
		});
		
	},
	
	interConfigMultiIPPolicy: function() 
	{
		inputs = 1;
		Ext.Ajax.request(
		{
			url : 'ManagerSettings/data/IPAddressValidatorJson.jsp?comeFrom=getIPPolicy',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var publicJson = Ext.decode(jsonText);
				var configuredIp = publicJson['screenLabels']['configuredIp'];
				if (configuredIp == '*')
				{
					Ext.getCmp('addMultiIP').disable();
				}
				if (configuredIp!=null && configuredIp!='undefined')
				{
					var splitconfiguredIp = configuredIp.split(",");
				}
				Ext.suspendLayouts();
				if (configuredIp != null || configuredIp != undefined)
				{
					Ext.getCmp('adminPolicyLabel').setVisible(true);
					Ext.getCmp('clearMultiIP').enable();
					for (var k =0;k<splitconfiguredIp.length;k++ )
					{
						addMultiIPPolicy();
					}
					for (multidom=1;multidom<splitconfiguredIp.length+1;multidom++)
					{
						Ext.getCmp('ip'+multidom).setValue(splitconfiguredIp[multidom-1]);
					}
				}
				else
				{
					Ext.getCmp('NoMultiIPPattern').show();
					Ext.getCmp('updateMultiIP').disable();
					Ext.getCmp('clearMultiIP').disable();
					Ext.getCmp('addMultiIP').setText(addPolicyMsg);
					Ext.getCmp('adminPolicyLabel').setVisible(false);
				}
				Ext.resumeLayouts(true);
			},
			failure : function()
			{
			}
		});
	},

	clearMultiIPPolicy : function()
	{
		var backupmulticontainer = Ext.getCmp('backupmultiipcontainer');
		Ext.Msg.show({
			title : ipPolicyTitle,
			msg : deleteAllIPMsg+'?',
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText){
				if (buttonText == "yes") 
				{
					Ext.Ajax.request(
					{
						url : 'ManagerSettings/data/IPAddressValidatorJson.jsp?comeFrom=deleteAllIPPolicy',
						method: 'POST',
						success: function(response)
						{
							var publicJSON = Ext.decode(response.responseText);
							var success = publicJSON['screenLabels']['success'];
							if (success == 'true')
							{
								backupmulticontainer.removeAll();
								inputs = 1;
								Ext.getCmp('NoMultiIPPattern').show();
								Ext.getCmp('updateMultiIP').disable();
								Ext.getCmp('clearMultiIP').disable();
								Ext.getCmp('addMultiIP').setText(addPolicyMsg);
								Ext.getCmp('adminPolicyLabel').setVisible(false);
								Ext.Msg.show({
									title : ipPolicyTitle,
									msg : deleteAllIPMsgSuccess+'.',
									icon : 'iconInformation',
									buttons : Ext.Msg.OK
								});
							}
							else
							{
								Ext.Msg.show({
									title : ipPolicyTitle,
									msg : deleteAllIPMsgFailure+'.',
									icon : 'iconExclamation',
									buttons : Ext.Msg.OK
								});
							}
						},
						failure: function()
						{
						}
					});
				}
			}
		});
	},

	updateMultiIPPolicy : function()
	{
		var multiinputs = inputs;
		var totalIP = '';
		for (var mul=1;mul<=multiinputs-1;mul++)
		{
			if (Ext.getCmp('ip'+mul) == undefined)
			{
				continue;
			}
			var ip = Ext.getCmp('ip'+mul).getValue();

			if (multiinputs > 2)
			{
				if (ip == '*')
				{
					Ext.Msg.show({
						title : ipPolicyTitle,
						msg : allowAllErrMsg+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('ip'+mul).focus(true);
						}
					});
					return false;
				}
			}
			if (!checkblank(ip))
			{
				Ext.Msg.show({
					title : ipPolicyTitle,
					msg : ipFieldBlankMsg+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('ip'+mul).focus(true);
					}
				});
				return false;
			}
			else if (ip.indexOf(" ") > -1)
			{
				Ext.Msg.show({
					title: ipPolicyTitle,
					msg: ipFieldSpaceMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('ip'+mul).focus(true);
					}
				});
				return;
			}
			else if (!checkspecialnomess(ip,"GHIJKLMNOPQRSTUVWXYZghijklmnopqrstuvwxyz~!@#$%^&()'<>"))
			{
				Ext.Msg.show({
					title: ipPolicyTitle,
					msg: invalidIPMsg + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('ip'+mul).focus(true);
					}
				});
				return false;
			}
			else if (ip.length > 0 && (ip.indexOf("..") > -1 ||
				ip.charAt(0) == "-" ||
				ip.charAt(ip.length - 1) == "-" ||
				ip.indexOf("--") > -1))
			{
				Ext.Msg.show({
					title: ipPolicyTitle,
					msg: invalidIPRangeMsg + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('ip'+mul).focus(true);
					}
				});
				return false;
			}
			else if (ip.indexOf(".,") > -1 ||
				ip.indexOf(",.") > -1 ||
				ip.indexOf(",") > -1 ||
				ip.charAt(0) == ",")
			{
				Ext.Msg.show({
					title: ipPolicyTitle,
					msg: commaRestrictionMsg + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('ip'+mul).focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(ip))
			{
				Ext.Msg.show({
					title: ipPolicyTitle,
					msg: dblIPRangeMsg + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('ip'+mul).focus(true);
					}
				});
				return false;
			}
			else if (ip.indexOf('-') > -1 && ip.indexOf('*') > -1)
			{
				Ext.Msg.show({
					title: ipPolicyTitle,
					msg: rangeAndPatternErrMsg + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('ip'+mul).focus(true);
					}
				});
				return false;
			}
			if(ip != null)
			{
				if (totalIP.indexOf(ip) == -1)
				{
					totalIP+=ip+",";
				}
				else
				{
					Ext.Msg.show({
						title: ipPolicyTitle,
						msg: duplicateIPMsg + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('ip'+mul).focus(true);
						}
					});
					return false;
				}
				
			}
		}
		totalIP = totalIP.substring(0,totalIP.length-1);

		if (totalIP.length > 0)
		{
			Ext.Ajax.request({
				url : 'ManagerSettings/data/IPAddressValidatorJson.jsp?iprange='+encodeURIComponent(totalIP)+'&comeFrom=validate',
				method : 'POST',
				async : false,
				success : function(response)
				{
					var publicJSON = Ext.decode(response.responseText);
					var isValidIP = publicJSON['screenLabels']['isValid'];
					if(isValidIP=="false")
					{
						var tmpVal = publicJSON['screenLabels']['ErrorIn'];
						Ext.Msg.show({
							title : ipPolicyTitle,
							msg : publicJSON['screenLabels']['admin.common.Error']+'.',
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('ip'+tmpVal).focus(true);
							}
						});
					}
					else
					{
						Ext.Ajax.request({
							url : 'ManagerSettings/data/IPAddressValidatorJson.jsp?iprange='+encodeURIComponent(totalIP)+'&comeFrom=update',
							method : 'POST',
							async : false,
							success : function(response)
							{
								var publicJSON = Ext.decode(response.responseText);
								var isUpdated = publicJSON['screenLabels']['success'];
								if (isUpdated == 'true')
								{
									Ext.Msg.show({
										title : ipPolicyTitle,
										msg : successMsg+'.',
										icon : 'iconInformation',
										buttons : Ext.Msg.OK,
										fn : function(btn){
											Ext.getCmp('clearMultiIP').enable();
										}
									});
								}
								else
								{
									Ext.Msg.show({
										title : ipPolicyTitle,
										msg : errorMsg+'.',
										icon : 'iconExclamation',
										buttons : Ext.Msg.OK
									});
								}
							},
							failure : function()
							{
							}
						});
					}
				},
				failure : function()
				{
				}
			});
		}
	},

	changeTTIntegration: function()
	{
		var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
		var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

		var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
		var ttNameObj = Ext.getCmp('TT_Other');
		var ttUrlObj = Ext.getCmp('TT_Url');
		var ttUserNameObj = Ext.getCmp('TT_User_Name');
		var ttPasswordObj = Ext.getCmp('TT_Password');

		var ttOutputObj = Ext.getCmp('TT_Output');
		var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
		var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
		var ttApiKeyObj = Ext.getCmp('TT_Api_Key');

		var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp";

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var TTSys = jsonData.TTSys;

				var nameInOthersEngine = jsonData.TTOtherDispName;
				var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
				var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;

				var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
				if (!Ext.isEmpty(jsonData.ttIntegrationSystemArray))
				{
					ttIntegrationSystemObj.getStore().removeAll();
					ttIntegrationSystemObj.getStore().loadRawData(jsonData.ttIntegrationSystemArray);
					if (!Ext.isEmpty(jsonData.TTSys) && jsonData.TTSys == 'OTHERS')
					{
						ttIntegrationSystemObj.setValue(jsonData.ttIntegrationSystemArray[0].valueField);
					}
					else
					{
						ttIntegrationSystemObj.setValue(jsonData.TTSys);
					}
				}
				nottWrapperClassNeededObj.setValue(true);

				//if (TTSys != 'OTHERS')
				//{
					//Ext.getCmp('removeBtn').show();
				//}
				//else
				//{
					//Ext.getCmp('removeBtn').hide();
				//}

				if (ttIntegrationEnableObj.getValue())
				{
					Ext.suspendLayouts();
					Ext.getCmp('integrationSystem').show();
					Ext.getCmp('integrationSystemc').removeAll();
					Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
					Ext.getCmp('integrationSystemc').doLayout();
					//Ext.getCmp('wrapperClassNeeded').show();
					Ext.resumeLayouts(true);

				}

				archeiveFile = jsonData.ArchieveFile;
				var labelTxt = '<b>' + archeiveFile + '</b>';

				if (Ext.isEmpty(archeiveFile) || archeiveFile == '' || archeiveFile.toLowerCase() == 'none')
				{
					Ext.suspendLayouts();
					//Ext.getCmp('archiveUpload').hide();
					Ext.getCmp('uploadLabel').hide();
					Ext.getCmp('removeLink').hide();
					Ext.resumeLayouts(true);
				}
				else
				{
					Ext.suspendLayouts();
					//Ext.getCmp('archiveUpload').show();
					Ext.getCmp('uploadLabel').show();
					Ext.getCmp('removeLink').show();
					if(archeiveFile != null && archeiveFile.toLowerCase() != 'none')
					{
						if(archeiveFile.indexOf('.') == -1)
						{
							Ext.getCmp('uploadLabel').setText(archeiveFile+'.'+onlyJar,true);
						}
						else
						{
							Ext.getCmp('uploadLabel').setText(archeiveFile,true);
						}
					}
					else
					{
						Ext.getCmp('uploadLabel').hide();
						Ext.getCmp('removeLink').hide();
					}
					Ext.resumeLayouts(true);
				}

				if (ttIntegrationDisableObj.getValue())
				{
					Ext.suspendLayouts();
					Ext.getCmp('integrationSystem').hide();
					Ext.getCmp('integrationSystemc').removeAll();
					//Ext.getCmp('wrapperClassNeeded').hide();
					//Ext.getCmp('archiveUpload').hide();
					//Ext.getCmp('wrapperClassNeeded').hide();
					Ext.resumeLayouts(true);
				}
			}
		});
	},
	changeRadioField:function(jsonArr, isEnabled)
	{
		
		Ext.suspendLayouts();

		for(var k in jsonArr) {
			if(isEnabled){
				if (typeof jsonArr[k] != 'undefined' && jsonArr[k].indexOf('_radioGrp')> -1)
				{
					Ext.getCmp(jsonArr[k]).enable();
					var yesradioID = jsonArr[k].substr(0, jsonArr[k].indexOf('_radioGrp'));
					var isChecked = Ext.getCmp(yesradioID).getValue();
					if (isChecked && jsonArr[k] == 'isProxyAuthenticated_radioGrp')
					{
						Ext.getCmp('proxyUserName').enable();
						Ext.getCmp('proxyPassword').enable();
					}
				} else {
					Ext.getCmp(jsonArr[k]).enable();
					Ext.getCmp('$_'+jsonArr[k]).show();
				}
			} else {
			
				if (typeof jsonArr[k] != 'undefined' && jsonArr[k].indexOf('_radioGrp')> -1)
				{
					Ext.getCmp(jsonArr[k]).disable();
				} else {
					Ext.getCmp(jsonArr[k]).disable();
					Ext.getCmp('$_'+jsonArr[k]).hide();
					
				}
				
			}
		}
		Ext.resumeLayouts(true);
	},
	changeMail:  function()
	{
		var ttMailEnableObj = Ext.getCmp('TTMailEnable');
		var ttMailDisableObj = Ext.getCmp('TTMailDisable');

		var yesIncludeAllCompUserObj = Ext.getCmp('yesIncludeAllCompUser');
		var noIncludeAllCompUserObj = Ext.getCmp('noIncludeAllCompUser');

		var yesUseUniqueIdObj = Ext.getCmp('yesUseUniqueId');
		var noUseUniqueIdObj = Ext.getCmp('noUseUniqueId');

		var yesPriorityAsNumericObj = Ext.getCmp('yesPriorityAsNumeric');
		var noPriorityAsNumericObj = Ext.getCmp('noPriorityAsNumeric');

		var yesApplyPriorityForAllTTMailsObj = Ext.getCmp('yesApplyPriorityForAllTTMails');
		var noApplyPriorityForAllTTMailsObj = Ext.getCmp('noApplyPriorityForAllTTMails');

		var yesEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('yesEnableTTIntegrationForSNMPTraps');
		var noEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('noEnableTTIntegrationForSNMPTraps');
		
		var url = "/final/admin/ManagerSettings/data/mailSnmpTTI_JSON.jsp";

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var strEnableMail = jsonData.strEnableMail;

				if (ttMailEnableObj.getValue())
				{
					Ext.getCmp('mailSettings').show();
					Ext.getCmp('MailSubject').setDisabled(false);
					Ext.getCmp('MailTo').setDisabled(false);
					Ext.getCmp('OutputFormat').setDisabled(false);


					var mailSubjectVal = jsonData.mailSubject;
					var mailToVal = jsonData.mailTo;
					var outputFormatVal = jsonData.outputFormat;
					var includeAllCompUserVal = jsonData.includeAllCompUser;
					var useUniqueIdVal = jsonData.useUniqueId;
					var priorityAsNumericVal = jsonData.priorityAsNumeric;
					var applyPriorityForAllTTMailsVal = jsonData.applyPriorityForAllTTMails;


					if (!Ext.isEmpty(mailSubjectVal))
					{
						Ext.getCmp('MailSubject').setValue(mailSubjectVal);
					}
					
					if (!Ext.isEmpty(mailToVal))
					{
						Ext.getCmp('MailTo').setValue(mailToVal);
					}
					if (!Ext.isEmpty(outputFormatVal))
					{
						Ext.getCmp('OutputFormat').setValue(outputFormatVal);
					}
					
					if (includeAllCompUserVal)
					{
						yesIncludeAllCompUserObj.setValue(true);
					}
					else
					{
						noIncludeAllCompUserObj.setValue(true);
					}

					if (useUniqueIdVal)
					{
						yesUseUniqueIdObj.setValue(true);
					}
					else
					{
						noUseUniqueIdObj.setValue(true);
					}
					
					if (priorityAsNumericVal)
					{
						yesPriorityAsNumericObj.setValue(true);
					}
					else
					{
						noPriorityAsNumericObj.setValue(true);
					}
					
					if (applyPriorityForAllTTMailsVal)
					{
						yesApplyPriorityForAllTTMailsObj.setValue(true);
					}
					else
					{
						noApplyPriorityForAllTTMailsObj.setValue(true);
					}
				}
				else if (ttMailDisableObj.getValue())
				{
					Ext.getCmp('mailSettings').hide();
					Ext.getCmp('MailSubject').setDisabled(true);
					Ext.getCmp('MailTo').setDisabled(true);
					Ext.getCmp('OutputFormat').setDisabled(true);
				}
				
				var enableTTIntegrationForSNMPTrapsVal = jsonData.enableTTIntegrationForSNMPTraps;
				if (enableTTIntegrationForSNMPTrapsVal)
				{
					yesEnableTTIntegrationForSNMPTrapsObj.setValue(true);
				}
				else
				{
					noEnableTTIntegrationForSNMPTrapsObj.setValue(true);
				}
			}
		});

	},
	radioChange: function()
	{
		var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
		var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

		var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
		var ttNameObj = Ext.getCmp('TT_Other');
		var ttUrlObj = Ext.getCmp('TT_Url');
		var ttUserNameObj = Ext.getCmp('TT_User_Name');
		var ttPasswordObj = Ext.getCmp('TT_Password');

		var ttOutputObj = Ext.getCmp('TT_Output');
		var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
		var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
		var ttApiKeyObj = Ext.getCmp('TT_Api_Key');

		var ttAllowedAlarmsCObj = Ext.getCmp('criticalAlarms');
		var ttAllowedAlarmsMObj = Ext.getCmp('majorAlarms');
		var ttAllowedAlarmsMiObj = Ext.getCmp('minorAlarms');
		var ttAllowedAlarmsNObj = Ext.getCmp('normalAlarms');

		var isCritical = '';
		var isMajor = '';
		var isMinor = '';
		var isNormal = '';

		var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var TTSys = jsonData.TTSys;

					var nameInOthersEngine = jsonData.TTOtherDispName;
					var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
					var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;

					var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
					ttIntegrationSystemObj.setValue(TTSys);

					//if (TTSys != 'OTHERS')
					//{
						////Ext.getCmp('TT_Other').hide();
						//Ext.getCmp('removeBtn').show();
					//}
					//else
					//{
						////Ext.getCmp('TT_Other').show();
						////Ext.getCmp('TT_Other').setValue(nameInOthersEngine);
						//Ext.getCmp('removeBtn').hide();
					//}

					if (ttIntegrationEnableObj.getValue())
					{
						Ext.suspendLayouts();
						Ext.getCmp('integrationSystem').show();
						/*Ext.getCmp('TT_Url').show();
						Ext.getCmp('TT_User_Name').show();
						Ext.getCmp('TT_Password').show();

						Ext.getCmp('TT_Output').show();
						Ext.getCmp('wrapperClassNeeded').show();
						Ext.getCmp('archiveUpload').show();
						Ext.getCmp('TT_Api_Key').show();

						Ext.getCmp('TT_Output').show();*/
						Ext.getCmp('integrationSystemc').removeAll();
						Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
						Ext.getCmp('integrationSystemc').doLayout();
						//Ext.getCmp('wrapperClassNeeded').show();
						//Ext.getCmp('TT_Api_Key').show();

						Ext.getCmp('allowedAlarms').show();
						Ext.resumeLayouts(true);

						//ttUrlObj.setValue(jsonData.TTUrl);
						//ttUserNameObj.setValue(jsonData.TTUsername);
						//ttPasswordObj.setValue(jsonData.TTPassword);
						//ttOutputObj.setValue(jsonData.TTOutput);

						if (isUploadArchieveEnable == 'block')
						{
							yesttWrapperClassNeededObj.setValue(true);
						}
						else
						{
							nottWrapperClassNeededObj.setValue(true);
						}

						//ttApiKeyObj.setValue(jsonData.TTApiKey);

						var criticalAlarmsChecked = jsonData.criticalAlarms;
						var majorAlarmsChecked = jsonData.majorAlarms;
						var minorAlarmsChecked = jsonData.minorAlarms;
						var normalAlarmsChecked = jsonData.normalAlarms;

						if (criticalAlarmsChecked == 'checked')
						{
							ttAllowedAlarmsCObj.setValue(true);
						}
						else
						{
							ttAllowedAlarmsCObj.setValue(false);
						}
						if (majorAlarmsChecked == 'checked')
						{
							ttAllowedAlarmsMObj.setValue(true);
						}
						else
						{
							ttAllowedAlarmsMObj.setValue(false);
						}
						if (minorAlarmsChecked == 'checked')
						{
							ttAllowedAlarmsMiObj.setValue(true);
						}
						else
						{
							ttAllowedAlarmsMiObj.setValue(false);
						}
						if (normalAlarmsChecked == 'checked')
						{
							ttAllowedAlarmsNObj.setValue(true);
						}
						else
						{
							ttAllowedAlarmsNObj.setValue(false);
						}
					}

					archeiveFile = jsonData.ArchieveFile;
					var labelTxt = '<b>' + archeiveFile + '</b>';

					if (Ext.isEmpty(archeiveFile) || archeiveFile == '')
					{
						Ext.suspendLayouts();
						//Ext.getCmp('archiveUpload').hide();
						Ext.getCmp('uploadLabel').hide();
						Ext.getCmp('removeLink').hide();
						Ext.resumeLayouts(true);
					}
					else
					{
						Ext.suspendLayouts();
						//Ext.getCmp('archiveUpload').show();
						Ext.getCmp('uploadLabel').show();
						Ext.getCmp('removeLink').show();
						Ext.resumeLayouts(true);
					}

					if (ttIntegrationDisableObj.getValue())
					{
						Ext.suspendLayouts();
						Ext.getCmp('integrationSystem').hide();
						/*Ext.getCmp('TT_Other').hide();
						Ext.getCmp('TT_Url').hide();
						Ext.getCmp('TT_User_Name').hide();
						Ext.getCmp('TT_Password').hide();

						Ext.getCmp('TT_Output').hide();*/
						Ext.getCmp('integrationSystemc').removeAll();
						//Ext.getCmp('wrapperClassNeeded').hide();
						//Ext.getCmp('archiveUpload').hide();
						//Ext.getCmp('TT_Api_Key').hide();

						//Ext.getCmp('TT_Output').hide();
						//Ext.getCmp('wrapperClassNeeded').hide();
						//Ext.getCmp('TT_Api_Key').hide();

						Ext.getCmp('allowedAlarms').hide();
						Ext.resumeLayouts(true);
					}

					/*ttUrlObj.setValue(jsonData.TTUrl);
					ttUserNameObj.setValue(jsonData.TTUsername);
					ttPasswordObj.setValue(jsonData.TTPassword);
					ttOutputObj.setValue(jsonData.TTOutput);

					if (isUploadArchieveEnable == 'block')
					{
						yesttWrapperClassNeededObj.setValue(true);
					}
					else
					{
						nottWrapperClassNeededObj.setValue(true);
					}

					ttApiKeyObj.setValue(jsonData.TTApiKey);

					var criticalAlarmsChecked = jsonData.criticalAlarms;
					var majorAlarmsChecked = jsonData.majorAlarms;
					var minorAlarmsChecked = jsonData.minorAlarms;
					var normalAlarmsChecked = jsonData.normalAlarms;*/

					/*archeiveFile = jsonData.ArchieveFile;
					var labelTxt = '<b>' + archeiveFile + '</b>';

					if (Ext.isEmpty(archeiveFile) || archeiveFile == '')
					{
						Ext.getCmp('archiveUpload').hide();
						Ext.getCmp('uploadLabel').hide();
						Ext.getCmp('removeLink').hide();
					}
					else
					{
						Ext.getCmp('archiveUpload').show();
						Ext.getCmp('uploadLabel').show();
						Ext.getCmp('removeLink').show();
					}*/

					/*ttAllowedAlarmsCObj.setValue(true);
					if (majorAlarmsChecked == 'checked')
					{
						ttAllowedAlarmsMObj.setValue(true);
					}
					else
					{
						ttAllowedAlarmsMObj.setValue(false);
					}
					if (minorAlarmsChecked == 'checked')
					{
						ttAllowedAlarmsMiObj.setValue(true);
					}
					else
					{
						ttAllowedAlarmsMiObj.setValue(false);
					}
					if (normalAlarmsChecked == 'checked')
					{
						ttAllowedAlarmsNObj.setValue(true);
					}
					else
					{
						ttAllowedAlarmsNObj.setValue(false);
					}*/
				}
			}
		);
	},

	radioRestartChange: function()
	{
		var yesStlnMgrRestartObj = Ext.getCmp('yesStlnMgrRestart');
		var noStlnMgrRestartObj = Ext.getCmp('noStlnMgrRestart');

		if (yesStlnMgrRestartObj.getSubmitValue() == 'Yes')
		{
			var isConfirmed = Ext.MessageBox.confirm('Advanced Settings','Are you sure you want to restart the eG Manager',this.confirmFunc,this);
		}
	},

	confirmFunc: function(id)
	{
		var stlnMgrRestartObj = Ext.getCmp('stlnMgrRestart');
		var noStlnMgrRestartObj = Ext.getCmp('noStlnMgrRestart');

		if (id == 'no')
		{
			noStlnMgrRestartObj.reset();
		}
	},
	radioRestartChange_pri: function()
	{
		var yesStlnMgrRestartObj_pri = Ext.getCmp('yesStlnMgrRestart_pri');
		var noStlnMgrRestartObj_pri = Ext.getCmp('noStlnMgrRestart_pri');
		if (yesStlnMgrRestartObj_pri.getSubmitValue() == 'Yes')
		{
			var isConfirmed = Ext.MessageBox.confirm('Advanced Settings','Are you sure you want to restart the primary eG Manager',this.confirmFunc_pri,this);
		}
	},
	confirmFunc_pri: function(id)
	{
		var stlnMgrRestartObj_pri = Ext.getCmp('stlnMgrRestart_pri');
		var noStlnMgrRestartObj_pri = Ext.getCmp('noStlnMgrRestart_pri');
		if (id == 'no')
		{
			noStlnMgrRestartObj_pri.reset();
		}
	},
	radioRestartChange_sec: function()
	{
		var yesStlnMgrRestartObj_sec = Ext.getCmp('yesStlnMgrRestart_sec');
		var noStlnMgrRestartObj_sec = Ext.getCmp('noStlnMgrRestart_sec');

		if (yesStlnMgrRestartObj_sec.getSubmitValue() == 'Yes')
		{
			var isConfirmed = Ext.MessageBox.confirm('Advanced Settings','Are you sure you want to restart the secondary eG Manager',this.confirmFunc_sec,this);
		}
	},
	confirmFunc_sec: function(id)
	{
		var stlnMgrRestartObj_sec = Ext.getCmp('stlnMgrRestart_sec');
		var noStlnMgrRestartObj_sec = Ext.getCmp('noStlnMgrRestart_sec');
		if (id == 'no')
		{
			noStlnMgrRestartObj_sec.reset();
		}
	},
	ttWebserviceSysCombo: function()
	{
		var ttSystem = Ext.getCmp('TT_sys').getValue();
		var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
		var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');
		var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
		var ttNameObj = Ext.getCmp('TT_Other');
		var ttUrlObj = Ext.getCmp('TT_Url');
		var ttUserNameObj = Ext.getCmp('TT_User_Name');
		var ttPasswordObj = Ext.getCmp('TT_Password');
		var ttOutputObj = Ext.getCmp('TT_Output');
		var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
		var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
		var ttApiKeyObj = Ext.getCmp('TT_Api_Key');

		var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp?selectSysName="+ttSystem;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				//if (ttSystem != 'OTHERS')
				//{
					//Ext.getCmp('removeBtn').show();
				//}
				//else
				//{
					//Ext.getCmp('removeBtn').hide();
				//}

				var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
				var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;

				archeiveFile = jsonData.ArchieveFile;
				var labelTxt = '<b>' + archeiveFile + '</b>';

				if (Ext.isEmpty(archeiveFile) || archeiveFile == '')
				{
					Ext.getCmp('uploadLabel').hide();
					Ext.getCmp('removeLink').hide();
				}
				else
				{
					Ext.getCmp('uploadLabel').show();
					Ext.getCmp('removeLink').show();
					if(archeiveFile != null && archeiveFile.toLowerCase() != 'none')
					{
						if(archeiveFile.indexOf('.') == -1)
						{
							Ext.getCmp('uploadLabel').setText(archeiveFile+'.'+onlyJar,true);
						}
						else
						{
							Ext.getCmp('uploadLabel').setText(archeiveFile,true);
						}
					}
					else
					{
						Ext.getCmp('uploadLabel').hide();
						Ext.getCmp('removeLink').hide();
					}
				}
				if (TTIntegrationEnableValue)
				{
					ttIntegrationEnableObj.setValue(true);
				}
				else
				{
					ttIntegrationDisableObj.setValue(true);
				}

				ttIntegrationSystemObj.getStore().loadRawData(jsonData.ttIntegrationSystemArray);
				ttIntegrationSystemObj.setValue(jsonData.TTSys);

				var ttIntegrationSystem = jsonData.ttIntegrationSystemArray[0].displayField;

				var TTSys = jsonData.TTSys;
				TTSysForRemove = TTSys;

				var nameInOthersEngine = jsonData.TTOtherDispName;

				//if (TTSys != 'OTHERS')
				//{
					//Ext.getCmp('removeBtn').show();
				//}
				//else if (TTSys == 'OTHERS' && ttIntegrationEnableObj.getValue())
				//{
					//Ext.getCmp('removeBtn').hide();
				//}

				if (ttIntegrationEnableObj.getValue())
				{
					Ext.getCmp('integrationSystem').show();
					Ext.getCmp('integrationSystemc').removeAll();
					Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
					Ext.getCmp('integrationSystemc').doLayout();
					//Ext.getCmp('wrapperClassNeeded').show();
					//Ext.getCmp('archiveUpload').show();
					//Ext.getCmp('wrapperClassNeeded').show();
				}

				if (ttIntegrationDisableObj.getValue())
				{
					Ext.getCmp('integrationSystem').hide();
					Ext.getCmp('integrationSystemc').removeAll();
					//Ext.getCmp('wrapperClassNeeded').hide();
					//Ext.getCmp('archiveUpload').hide();
					//Ext.getCmp('wrapperClassNeeded').hide();
				}

				if (isUploadArchieveEnable == 'block' && Ext.isEmpty(jsonData.TTWrapper))
				{
					yesttWrapperClassNeededObj.setValue(true);
				}
				else
				{
					nottWrapperClassNeededObj.setValue(true);
				}
			}
		});
	},
	ttManagerSystemComboChange: function()
	{
		var ttSystem = Ext.getCmp('TT_sys').getValue();

		var allowedAlarmsToSet = '';

		var yesEnableExecForTTObj = Ext.getCmp('yesEnableExecForTT');
		var noEnableExecForTTObj = Ext.getCmp('noEnableExecForTT');

		var command2Obj = Ext.getCmp('Command2');
		var commandObj = Ext.getCmp('Command');
		var allowedAlarmsCObj = Ext.getCmp('AllowedAlarmsC');
		var allowedAlarmsMObj = Ext.getCmp('AllowedAlarmsM');

		var allowedAlarmsMiObj = Ext.getCmp('AllowedAlarmsMi');
		var allowedAlarmsNObj = Ext.getCmp('AllowedAlarmsN');
		var logFileMaxSizeObj = Ext.getCmp('LogFileMaxSize');

		var yesLogEntriesForStdoutAlsoObj = Ext.getCmp('yesLogEntriesForStdoutAlso');
		var noLogEntriesForStdoutAlsoObj = Ext.getCmp('noLogEntriesForStdoutAlso');
		var aDateFormatObj = Ext.getCmp('DateFormat');

		var commandLengthObj = Ext.getCmp('CommandLength');
		var probDescLengthObj = Ext.getCmp('ProbDescLength');
		var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
		var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

		var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
		var ttNameObj = Ext.getCmp('TT_Other');
		var ttUrlObj = Ext.getCmp('TT_Url');
		var ttUserNameObj = Ext.getCmp('TT_User_Name');
		var ttPasswordObj = Ext.getCmp('TT_Password');

		var ttOutputObj = Ext.getCmp('TT_Output');
		var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
		var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
		var ttApiKeyObj = Ext.getCmp('TT_Api_Key');

		var ttAllowedAlarmsCObj = Ext.getCmp('criticalAlarms');
		var ttAllowedAlarmsMObj = Ext.getCmp('majorAlarms');
		var ttAllowedAlarmsMiObj = Ext.getCmp('minorAlarms');
		var ttAllowedAlarmsNObj = Ext.getCmp('normalAlarms');

		var isCritical = '';
		var isMajor = '';
		var isMinor = '';
		var isNormal = '';

		var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp?selectSysName="+ttSystem;
		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var enableExecForTTValue = jsonData.enableExecForTT;

					//if (ttSystem != 'OTHERS')
					//{
						////Ext.getCmp('TT_Other').hide();
						//Ext.getCmp('removeBtn').show();
					//}
					//else
					//{
						////Ext.getCmp('TT_Other').show();
						//Ext.getCmp('removeBtn').hide();
					//}

					var commandValue = jsonData.command;
					//alarmsArray
					var allowedAlarmsArrayLength = jsonData.alarmsArray.length;
					var logEntriesForStdoutAlsoValue = jsonData.enableLogging;
					var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
					var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;
					var criticalAlarmsChecked = jsonData.criticalAlarms;
					var majorAlarmsChecked = jsonData.majorAlarms;
					var minorAlarmsChecked = jsonData.minorAlarms;
					var normalAlarmsChecked = jsonData.normalAlarms;

					archeiveFile = jsonData.ArchieveFile;
					var labelTxt = '<b>' + archeiveFile + '</b>';

					if (Ext.isEmpty(archeiveFile) || archeiveFile == '')
					{
						Ext.getCmp('uploadLabel').hide();
						Ext.getCmp('removeLink').hide();
					}
					else
					{
						Ext.getCmp('uploadLabel').show();
						Ext.getCmp('removeLink').show();
						if(archeiveFile != null && archeiveFile.toLowerCase() != 'none')
						{
							if(archeiveFile.indexOf('.') == -1)
							{
								Ext.getCmp('uploadLabel').setText(archeiveFile+'.'+onlyJar,true);
							}
							else
							{
								Ext.getCmp('uploadLabel').setText(archeiveFile,true);
							}
						}
						else
						{
							Ext.getCmp('uploadLabel').hide();
							Ext.getCmp('removeLink').hide();
						}
					}

					if (enableExecForTTValue == 'Yes')
					{
						yesEnableExecForTTObj.setValue('Yes');
					}
					else
					{
						yesEnableExecForTTObj.setValue('No');
					}

					command2Obj.setValue(jsonData.command);
					commandObj.setValue(jsonData.execOutFormat);

					for (var i=0; i<allowedAlarmsArrayLength; i++)
					{
						var allowedAlarmsValue = jsonData.alarmsArray[i].alarms;
						if (allowedAlarmsValue == 'critical')
						{
							isCritical = 'true';
						}
						if (allowedAlarmsValue == 'major')
						{
							isMajor = 'true';
						}
						if (allowedAlarmsValue == 'minor')
						{
							isMinor = 'true';
						}
						if (allowedAlarmsValue == 'normal')
						{
							isNormal = 'true';
						}
					}
					if (isCritical == 'true')
					{
						allowedAlarmsCObj.setValue(true);
					}
					else
					{
						allowedAlarmsCObj.setValue(false);
					}
					if (isMajor == 'true')
					{
						allowedAlarmsMObj.setValue(true);
					}
					else
					{
						allowedAlarmsMObj.setValue(false);
					}
					if (isMinor == 'true')
					{
						allowedAlarmsMiObj.setValue(true);
					}
					else
					{
						allowedAlarmsMiObj.setValue(false);
					}
					if (isNormal == 'true')
					{
						allowedAlarmsNObj.setValue(true);
					}
					else
					{
						allowedAlarmsNObj.setValue(false);
					}

					logFileMaxSizeObj.setValue(jsonData.logFileMaxSize);

					if (logEntriesForStdoutAlsoValue == 'Yes')
					{
						yesLogEntriesForStdoutAlsoObj.setValue(true);
					}
					else
					{
						noLogEntriesForStdoutAlsoObj.setValue(true);
					}

					aDateFormatObj.getStore().loadRawData(jsonData.formatForDateArray);
					aDateFormatObj.setValue(jsonData.dateFormat);

					commandLengthObj.setValue(jsonData.commandLength);
					probDescLengthObj.setValue(jsonData.probDescLength);

					if (TTIntegrationEnableValue == 'Yes' || TTIntegrationEnableValue == 'yes')
					{
						ttIntegrationEnableObj.setValue(true);
					}
					else
					{
						ttIntegrationDisableObj.setValue(true);
					}

					ttIntegrationSystemObj.getStore().loadRawData(jsonData.ttIntegrationSystemArray);
					ttIntegrationSystemObj.setValue(jsonData.TTSys);

					var ttIntegrationSystem = jsonData.ttIntegrationSystemArray[0].displayField;

					var TTSys = jsonData.TTSys;
					TTSysForRemove = TTSys;

					var nameInOthersEngine = jsonData.TTOtherDispName;

					//if (TTSys != 'OTHERS')
					//{
						////Ext.getCmp('TT_Other').hide();
						//Ext.getCmp('removeBtn').show();
					//}
					//else if (TTSys == 'OTHERS' && ttIntegrationEnableObj.getValue())
					//{
						////Ext.getCmp('TT_Other').show();
						////Ext.getCmp('TT_Other').setValue(nameInOthersEngine);
						//Ext.getCmp('removeBtn').hide();
					//}

					if (ttIntegrationEnableObj.getValue())
					{
						Ext.getCmp('integrationSystem').show();
						/*Ext.getCmp('TT_Url').show();
						Ext.getCmp('TT_User_Name').show();
						Ext.getCmp('TT_Password').show();

						Ext.getCmp('TT_Output').show();*/
						Ext.getCmp('integrationSystemc').removeAll();
						Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
						Ext.getCmp('integrationSystemc').doLayout();
						//Ext.getCmp('wrapperClassNeeded').show();
						//Ext.getCmp('archiveUpload').show();
						//Ext.getCmp('TT_Api_Key').show();

						//Ext.getCmp('TT_Output').show();
						//Ext.getCmp('wrapperClassNeeded').show();
						//Ext.getCmp('TT_Api_Key').show();

						Ext.getCmp('allowedAlarms').show();
					}

					if (ttIntegrationDisableObj.getValue())
					{
						Ext.getCmp('integrationSystem').hide();
						/*Ext.getCmp('TT_Other').hide();
						Ext.getCmp('TT_Url').hide();
						Ext.getCmp('TT_User_Name').hide();
						Ext.getCmp('TT_Password').hide();

						Ext.getCmp('TT_Output').hide();*/
						Ext.getCmp('integrationSystemc').removeAll();
						//Ext.getCmp('wrapperClassNeeded').hide();
						//Ext.getCmp('archiveUpload').hide();
						//Ext.getCmp('TT_Api_Key').hide();

						//Ext.getCmp('TT_Output').hide();
						//Ext.getCmp('wrapperClassNeeded').hide();
						//Ext.getCmp('TT_Api_Key').hide();

						Ext.getCmp('allowedAlarms').hide();
					}

					/*ttUrlObj.setValue(jsonData.TTUrl);
					ttUserNameObj.setValue(jsonData.TTUsername);
					ttPasswordObj.setValue(jsonData.TTPassword);
					ttOutputObj.setValue(jsonData.TTOutput);*/

					if (isUploadArchieveEnable == 'block')
					{
						yesttWrapperClassNeededObj.setValue(true);
					}
					else
					{
						nottWrapperClassNeededObj.setValue(true);
					}

					//ttApiKeyObj.setValue(jsonData.TTApiKey);

					ttAllowedAlarmsCObj.setValue(true);
					if (majorAlarmsChecked == 'checked')
					{
						ttAllowedAlarmsMObj.checked = true;
					}
					else
					{
						ttAllowedAlarmsMObj.setValue(false);
					}
					if (minorAlarmsChecked == 'checked')
					{
						ttAllowedAlarmsMiObj.setValue(true);
					}
					else
					{
						ttAllowedAlarmsMiObj.setValue(false);
					}
					if (normalAlarmsChecked == 'checked')
					{
						ttAllowedAlarmsNObj.setValue(true);
					}
					else
					{
						ttAllowedAlarmsNObj.setValue(false);
					}
				}
			}
		);
	},
	ttCommonSettingsUpdate: function(appendTTFilter,isComponentsAssociated)
	{
		var allowedAlarmsToSet = '';

		var allowedAlarmsStr = '';
		var logFileMaxSizeStr = '';
		var logMaxFilesStr = '';
		var enableGraphStr = '';
		var logEntriesForStdoutAlsoStr = '';
		var enableDDStr = '';
		var sendNormalTTMailStr = '';

		var isCritical = '';
		var isMajor = '';
		var isMinor = '';
		var isNormal = '';
		var url = "/final/admin/ManagerSettings/data/commonSettingsTTI_JSON.jsp";
		
		var logFileMaxSizeObj = Ext.getCmp('LogFileMaxSize');
		var logMaxFilesObj = Ext.getCmp('logMaxFiles');
		var enableGraphObj = Ext.getCmp('enableGraph');
		if(logFileMaxSizeObj)
		{
			var logFileMaxSize = logFileMaxSizeObj.getRawValue( );
			if(!checkblank(logFileMaxSize))
			{
				Ext.Msg.show({
					title : ttSettings,
					msg : alertForNocommon+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('LogFileMaxSize').focus(true);
					}
				});
				return false;
			}
		}
		if(logMaxFilesObj)
		{
			var logMaxFiles = logMaxFilesObj.getRawValue( );
			if(!checkblank(logMaxFiles))
			{
				Ext.Msg.show({
					title : ttSettings,
					msg : alertForNocommon+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('logMaxFiles').focus(true);
					}
				});
				return false;
			}
		}


		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var allowedAlarmsArrayLength = jsonData.alarmsArray.length;
				var logEntriesForStdoutAlsoValue = jsonData.enableLogging;
				var enableDDStrValue = jsonData.enableDDStr;
				var sendNormalTTMailVal = jsonData.sendNormailMail;
				var enableTTFilterVal = jsonData.enableTTFilter;

				var forAudit = '';
				var allowedAlarmsForAudit = 'Allowed alarms';
				for (var i=0; i<allowedAlarmsArrayLength; i++)
				{
					var allowedAlarmsValue = jsonData.alarmsArray[i].alarms;
					if(forAudit == '')
						forAudit += '$' + allowedAlarmsValue;
					else
						forAudit += ',' + allowedAlarmsValue;
					if (allowedAlarmsValue == 'critical')
					{
						isCritical = 'true';
					}
					if (allowedAlarmsValue == 'major')
					{
						isMajor = 'true';
					}
					if (allowedAlarmsValue == 'minor')
					{
						isMinor = 'true';
					}
					if (allowedAlarmsValue == 'normal')
					{
						isNormal = 'true';
					}
				}
				allowedAlarmsForAudit = allowedAlarmsForAudit + forAudit;

				if (isCritical == 'true')
				{
					allowedAlarmsStr = 'Allowed alarms$critical';
				}

				if (isMajor == 'true')
				{
					allowedAlarmsStr = 'Allowed alarms$major';
				}

				if (isMinor == 'true')
				{
					allowedAlarmsStr = 'Allowed alarms$minor';
				}
				
				if (isNormal == 'true')
				{
					allowedAlarmsStr = 'Allowed alarms$normal';
				}
					
				if (logEntriesForStdoutAlsoValue == 'Yes')
				{
					logEntriesForStdoutAlsoStr = 'Log entries for stdout also -  TT Manager CLI$Yes';
				}
				else
				{
					logEntriesForStdoutAlsoStr = 'Log entries for stdout also -  TT Manager CLI$No';
				}
				
				if (enableTTFilterVal == 'Yes')
				{
					enableTTFilterStr = 'Trouble ticket Filter$Yes';
				}
				else
				{
					enableTTFilterStr = 'Trouble ticket Filter$No';
				}

				if (enableDDStrValue.toLowerCase() == 'yes')
				{
					enableDDStr = 'Enable DD -  TT Manager$Yes';
				}
				else
				{
					enableDDStr = 'Enable DD -  TT Manager$No';
				}
				
				if (sendNormalTTMailVal.toLowerCase() == 'yes')
				{
					sendNormalTTMailStr = 'send Normal TT Mails for -  TT Manager$Yes';
				}
				else
				{
					sendNormalTTMailStr = 'send Normal TT Mails for -  TT Manager$No';
				}

				//logFileMaxSizeStr = 'Log file maximum size (MB)$'+jsonData.logFileMaxSize;
				logFileMaxSizeStr = 'Log file maximum size MB$'+jsonData.logFileMaxSize;
				logMaxFilesStr = 'Maximum number of log files$'+jsonData.logMaxFiles;
				enableGraphStr = 'Enable Graph$' + jsonData.enableGraph;
				
				Ext.getCmp('$_AllowedAlarms').setValue(allowedAlarmsForAudit);
				Ext.getCmp('$_SendNormalAlarms').setValue(sendNormalTTMailStr);
				Ext.getCmp('$_EnableDD').setValue(enableDDStr);
				Ext.getCmp('$_LogFileMaxSize').setValue(logFileMaxSizeStr);
				Ext.getCmp('$_logMaxFiles').setValue(logMaxFilesStr);
				Ext.getCmp('$_enableGraph').setValue(enableGraphStr);
				
				Ext.getCmp('$_enableLogging').setValue(logEntriesForStdoutAlsoStr);
				Ext.getCmp('$_EnableTTFilter').setValue(enableTTFilterStr);

				var urlForUpdation = '/final/admin/ManagerSettings/data/commonSettingsTTI_JSONp.jsp';

				var high = Ext.getCmp('AllowedAlarmsC').getValue(); 
				var medium = Ext.getCmp('AllowedAlarmsM').getValue();
				var low = Ext.getCmp('AllowedAlarmsMi').getValue();
				
				var alramSelected = false;
				var value = '';
				if(high != null && high == true)
				{
					alramSelected = true;
					value = value + 'Critical'
				}
				
				if(medium != null && medium == true)
				{
					alramSelected = true;
					if(value == '')
						value = 'Major';
					else
						value = value + '$Major'
				}
				
				if(low != null && low == true)
				{
					alramSelected = true;
					if(value == '')
						value = 'Minor';
					else
						value = value + '$Minor'
				}

				//Ext.getCmp('AllowedAlarms').setValue(value);


				if(!alramSelected)
				{
					Ext.Msg.show ({
						title: ttSettings,
						msg: alert6,
						width: alert6.length * 7,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
					});
					return;
				}
				if(!appendTTFilter || !isComponentsAssociated)
				{
				var ttManagerCommonForm = this.getTtcommonsettings().getForm();
				if (ttManagerCommonForm.isValid())
				{
					ttManagerCommonForm.submit({
						url: urlForUpdation,
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: ttSettings,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
							/**	fn: function() {
										thisController.reloadIntegrationPage();
								}**/
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: ttSettings,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					});
				}
				else
				{
					Ext.Msg.show({
						title: ttSettings,
						msg: settingsNoSuccessUpdate,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					}
				}
			}
		});
	},
	ttCliUpdate: function()
	{
		var enableExecForTTStr = '';
		var command2Str = '';
		var commandStr = '';
		var aDateFormatStr = '';
		var commandLengthStr = '';
		var probDescLengthStr = '';
		var urlForUpdation = '';
		var encodeThis = this;
		var yesEnableExecForTTObj = Ext.getCmp('yesEnableExecForTT');
		//var noEnableExecForTTObj = Ext.getCmp('noEnableExecForTT');

		var command2Obj = Ext.getCmp('Command2');
		var commandObj = Ext.getCmp('Command');
		var aDateFormatObj = Ext.getCmp('DateFormat');

		var commandLengthObj = Ext.getCmp('CommandLength');
		var probDescLengthObj = Ext.getCmp('ProbDescLength');
		var command_args='';
		var encodedCommand_args='';
		if(commandObj)
		{
			var commandagr = commandObj.getValue();
			command_args=commandagr;
			encodedCommand_args=encodeThis.filterEncode(command_args);
		}
		if(yesEnableExecForTTObj && yesEnableExecForTTObj.getValue() === true )
		{
			if(commandObj)
			{
				if(!checkblank(commandagr))
				{
					Ext.Msg.show({
						title : ttManagerCLI,
						msg : alertForNocommon+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('Command').focus(true);
						}
					});
					return false;
				}
			}
			if(command2Obj)
			{
				var command = command2Obj.getValue();
				if(!checkblank(command))
				{
					Ext.Msg.show({
						title : ttManagerCLI,
						msg : alertForNocommon+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('Command2').focus(true);
						}
					});
					return false;
				}
			}
			if(commandLengthObj)
			{
				var commandLength = commandLengthObj.getRawValue();
				if(!checkblank(commandLength))
				{
					Ext.Msg.show({
						title : ttManagerCLI,
						msg : alertForNocommon+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('CommandLength').focus(true);
						}
					});
					return false;
				}
			}
			
			if(probDescLengthObj)
			{
				var probDescLength = probDescLengthObj.getRawValue();
				if(!checkblank(probDescLength))
				{
					Ext.Msg.show({
						title : ttManagerCLI,
						msg : alertForNocommon+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('ProbDescLength').focus(true);
						}
					});
					return false;
				}
			}
		}

		var url = "/final/admin/ManagerSettings/data/cliTTI_JSON.jsp";

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var enableExecForTTValue = jsonData.enableExecForTT;
				var commandValue = jsonData.command;

				if (Ext.getCmp('yesEnableExecForTT').getValue())
				{
					Ext.getCmp('EnableExecForTT').setValue('Yes');
				}else {
					Ext.getCmp('EnableExecForTT').setValue('No');
				}
				/**
				if (Ext.getCmp('noEnableExecForTT').getValue())
				{
					Ext.getCmp('EnableExecForTT').setValue('No');
				}**/

				if(yesEnableExecForTTObj && !yesEnableExecForTTObj.getValue() && enableExecForTTValue.toLowerCase() == 'no')
				{
					Ext.Msg.show({
						title: ttIntegrationTitle,
						msg: ttEnableCLIMsg,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return;
				}

				if (enableExecForTTValue == 'Yes')
				{
					enableExecForTTStr = 'Enable CLI$Yes';
				}
				else
				{
					enableExecForTTStr = 'Enable CLI$No';
				}

				command2Str = 'Command$'+jsonData.command;
				commandStr = 'Command Arguments$'+jsonData.execOutFormat;

				aDateFormatStr = 'Date format to be used$'+jsonData.dateFormat+ ' ' +'HH:mm:ss';
				commandLengthStr = 'Command length  (chars) for TT Manager CLI$'+jsonData.commandLength;
				probDescLengthStr = 'Problem description length (chars)$'+jsonData.probDescLength;
				Ext.getCmp('$_EnableExecForTT').setValue(enableExecForTTStr);
				Ext.getCmp('$_Command2').setValue(command2Str);
				Ext.getCmp('$_Command').setValue(encodeThis.filterEncode(commandStr)); // fix
				Ext.getCmp('$_DateFormat').setValue(aDateFormatStr);
				Ext.getCmp('$_CommandLength').setValue(encodeThis.filterEncode(commandLengthStr));
				Ext.getCmp('$_ProbDescLength').setValue(encodeThis.filterEncode(probDescLengthStr));

				commandObj.setValue(encodedCommand_args);
				urlForUpdation = '/final/admin/ManagerSettings/data/cliTTI_JSONp.jsp?';
				var ttManagerCliForm = this.getTtmanagercli().getForm();
				if (ttManagerCliForm.isValid())
				{
					ttManagerCliForm.submit({
						url: urlForUpdation,
						method: 'POST',
						success: function(form, action){
							commandObj.setValue(command_args);
							Ext.Msg.show({
								title: ttManagerCLI,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function() {
										thisController.reloadIntegrationPage();
								}
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: ttManagerCLI,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					});
				}
				else
				{
					Ext.Msg.show({
						title: ttManagerCLI,
						msg: settingsNoSuccessUpdate,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
				}
			}
		});
	},
	filterEncode: function(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
	ttMailUpdate: function()
	{
		var enableExecForTTStr = '';
		var command2Str = '';
		var commandStr = '';
		var allowedAlarmsStr = '';
		var logFileMaxSizeStr = '';
		var logEntriesForStdoutAlsoStr = '';
		var aDateFormatStr = '';
		var commandLengthStr = '';
		var probDescLengthStr = '';
		var ttIntegrationEnableStr = '';
		var ttIntegrationSystemStr = '';
		var ttUrlStr = '';
		var ttUserNameStr = '';
		var ttPasswordStr = '';
		var ttOutputStr = '';
		var ttWrapperClassNeededStr = '';
		var ttApiKeyStr = '';
		var ttAllowedAlarmsStr = '';
		var urlForUpdation = '';
		var encodeThis=this;

		var ttMailEnableObj = Ext.getCmp('TTMailEnable');

		var yesIncludeAllCompUserObj = Ext.getCmp('yesIncludeAllCompUser');
		var noIncludeAllCompUserObj = Ext.getCmp('noIncludeAllCompUser');

		var yesUseUniqueIdObj = Ext.getCmp('yesUseUniqueId');
		var noUseUniqueIdObj = Ext.getCmp('noUseUniqueId');

		var yesPriorityAsNumericObj = Ext.getCmp('yesPriorityAsNumeric');
		var noPriorityAsNumericObj = Ext.getCmp('noPriorityAsNumeric');

		var yesApplyPriorityForAllTTMailsObj = Ext.getCmp('yesApplyPriorityForAllTTMails');
		var noApplyPriorityForAllTTMailsObj = Ext.getCmp('noApplyPriorityForAllTTMails');

		var yesEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('yesEnableTTIntegrationForSNMPTraps');
		var noEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('noEnableTTIntegrationForSNMPTraps');

		var url = "/final/admin/ManagerSettings/data/mailSnmpTTI_JSON.jsp?integrationType=MAIL";
		var encoded_OutputFormat='';
		var output_Format='';
		var outputFormat = Ext.getCmp('OutputFormat').getValue();
		output_Format=outputFormat;
		encoded_OutputFormat=encodeThis.filterEncode(outputFormat);
		if (!Ext.isEmpty(ttMailEnableObj) && ttMailEnableObj.getValue())
		{
			var mailSubject = Ext.getCmp('MailSubject').getValue();
			var mailID = Ext.getCmp('MailTo').getValue();
			var result = true;

			if (mailID.length > 0 && mailID.indexOf(',') != -1)
			{
				var mailIDs = mailID.split(",");
				for (var i=0;i<mailIDs.length && mailIDs[i] !="";i++)
				{
					var tempString = trim(mailIDs[i]);
					var tempResult = validateEmail(tempString);
					if(!validateSingleByte(mailIDs[i]))
					{
						Ext.Msg.show({
							title : ttManagerMail,
							msg : mailIDDBL,
							icon : 'iconExclamation',
							buttons:Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('MailTo').focus(true);
							}
						});
						return;
					}					
					else if(tempResult == null || tempResult == undefined || tempResult == false)
					{
						result = false;
						break;
					}
				}
			}
			else if(mailID.length > 0)
			{
				var tempString = trim(mailID);
				var tempResult = validateEmail(tempString);
				if(tempResult == null || tempResult == undefined || tempResult == false)
				{
					result = false;
				}
			}

			if(!checkblank(mailSubject))
			{
				Ext.Msg.show({
					title : ttManagerMail,
					msg : mailSubjectBnk+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('MailSubject').focus(true);
					}
				});
				return false;
			}
			else if(mailSubject == '$unconfigured')
			{
				Ext.Msg.show({
					title : ttManagerMail,
					msg : mailSubjectValid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('MailSubject').focus(true);
					}
				});
				return false;
			}
			else if(!checkblank(mailID))
			{
				Ext.Msg.show({
					title : ttManagerMail,
					msg : mailValid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('MailTo').focus(true);
					}
				});
				return false;
			}
			else if(!result)
			{
				Ext.Msg.show({
					title : ttManagerMail,
					msg : mailValid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('MailTo').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(mailID))
			{
				Ext.Msg.show(
				{
					title : ttManagerMail,
					msg : mailIDDBL+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('MailTo').focus(true);
					}
				});
				return false;
			}
			else if(!checkblank(outputFormat))
			{
				Ext.Msg.show({
					title : ttManagerMail,
					msg : alertForNocommon+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('OutputFormat').focus(true);
					}
				});
				return false;
			}
		}
		/**else
		{
			Ext.getCmp('MailSubject').setDisabled(true);
			Ext.getCmp('MailTo').setDisabled(true);
			Ext.getCmp('OutputFormat').setDisabled(true);
		}**/

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var enableMail = jsonData.strEnableMail;
				var mailSubject = jsonData.mailSubject;
				var mailTo = jsonData.mailTo;
				var outputFormat = jsonData.outputFormat;
				var includeAllCompUser = jsonData.includeAllCompUser;
				var useUniqueId = jsonData.useUniqueId;
				var priorityAsNumeric = jsonData.priorityAsNumeric;
				var applyPriorityForAllTTMails = jsonData.applyPriorityForAllTTMails;
				var enableTTIntegrationForSNMPTraps = jsonData.enableTTIntegrationForSNMPTraps;

				if(!Ext.isEmpty(ttMailEnableObj) && !ttMailEnableObj.getValue() && enableMail != null && (enableMail.toLowerCase() == 'no' || enableMail.toLowerCase() == 'false')){
					Ext.Msg.show({
						title: ttIntegrationTitle,
						msg: ttEnableMailMsg,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
						
					});
					return;
				}

				if(enableMail != null && (enableMail.toLowerCase() == 'yes' || enableMail.toLowerCase() == 'true'))
				{
					enableMail = 'Enable mail alert$Yes';
				}
				else
				{
					enableMail = 'Enable mail alert$No';
				}

				if(mailSubject != null && mailSubject.length > 0)
				{
					mailSubject = "Subject$"+mailSubject;
				}

				if(mailTo != null && mailTo.length > 0)
				{
					mailTo = "Mail ID$"+mailTo;
				}

				if(outputFormat != null && outputFormat.length > 0)
				{
					outputFormat = "Mail output format$"+outputFormat;
				}

				if(includeAllCompUser != null && includeAllCompUser == true)
				{
					includeAllCompUser = "Include user details in mail$Yes";
				}
				else
				{
					includeAllCompUser = "Include user details in mail$No";
				}

				if(useUniqueId != null && useUniqueId == true)
				{
					useUniqueId = "Use unique ID$Yes";
				}
				else
				{
					useUniqueId = "Use unique ID$No";
				}

				if(priorityAsNumeric != null && priorityAsNumeric == true)
				{
					priorityAsNumeric = "Priority as numeric$Yes";
				}
				else
				{
					priorityAsNumeric = "Priority as numeric$No";
				}

				if(applyPriorityForAllTTMails != null && applyPriorityForAllTTMails == true)
				{
					applyPriorityForAllTTMails = "Apply priority for all TT mails$Yes";
				}
				else
				{
					applyPriorityForAllTTMails= "Apply priority for all TT mails$No";
				}

				if(enableTTIntegrationForSNMPTraps != null && enableTTIntegrationForSNMPTraps == true)
				{
					enableTTIntegrationForSNMPTraps = "Enable TT integration over SNMP trap$Yes";
				}
				else
				{
					enableTTIntegrationForSNMPTraps = "Enable TT integration over SNMP trap$No";
				}
				var encodedOutputFormat=encodeThis.filterEncode(outputFormat);
				Ext.getCmp('$_EnableMail').setValue(enableMail);
				Ext.getCmp('$_MailSubject').setValue(mailSubject);
				Ext.getCmp('$_MailTo').setValue(mailTo);
				Ext.getCmp('$_OutputFormat').setValue(encodedOutputFormat);
				Ext.getCmp('$_IncludeAllCompUser').setValue(includeAllCompUser);
				Ext.getCmp('$_UseUniqueId').setValue(useUniqueId);
				Ext.getCmp('$_PriorityAsNumeric').setValue(priorityAsNumeric);
				Ext.getCmp('$_ApplyPriorityForAllTTMails').setValue(applyPriorityForAllTTMails);
				//Ext.getCmp('$_EnableTTIntegrationForSNMPTraps').setValue(enableTTIntegrationForSNMPTraps);

				Ext.getCmp('OutputFormat').setValue(encoded_OutputFormat);
				urlForUpdation = '/final/admin/ManagerSettings/data/mailSnmpTTI_JSONp.jsp?integrationType=MAIL';
				var ttMailSnmpForm = this.getTtmanagermailsnmp().getForm();
				if (ttMailSnmpForm.isValid())
				{
					ttMailSnmpForm.submit({
						url: urlForUpdation,
						method: 'POST',
						success: function(form, action){
							Ext.getCmp('OutputFormat').setValue(output_Format);
							Ext.Msg.show({
								title: ttManagerMail,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function() {
									thisController.reloadIntegrationPage();
								}
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: ttManagerMail,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					});
				} else 
				{
						Ext.Msg.show({
								title: ttManagerMail,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
						});
				}
			}
		});
	},

ttSnmpUpdate: function()
{
		var urlForUpdation = '';

		var yesEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('yesEnableTTIntegrationForSNMPTraps');
		var noEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('noEnableTTIntegrationForSNMPTraps');

		var url = "/final/admin/ManagerSettings/data/mailSnmpTTI_JSON.jsp?integrationType=SNMP";

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var enableTTIntegrationForSNMPTraps = jsonData.enableTTIntegrationForSNMPTraps;
			
				if(!yesEnableTTIntegrationForSNMPTrapsObj.getValue() && enableTTIntegrationForSNMPTraps != null && enableTTIntegrationForSNMPTraps == false){
					Ext.Msg.show({
						title: ttIntegrationTitle,
						msg: ttEnableSNMPMsg,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return;
				}

				if(enableTTIntegrationForSNMPTraps != null && enableTTIntegrationForSNMPTraps == true)
				{
					enableTTIntegrationForSNMPTraps = "Enable TT integration over SNMP trap$Yes";
				}
				else
				{
					enableTTIntegrationForSNMPTraps = "Enable TT integration over SNMP trap$No";
				}

			
				Ext.getCmp('$_EnableTTIntegrationForSNMPTraps').setValue(enableTTIntegrationForSNMPTraps);


				urlForUpdation = '/final/admin/ManagerSettings/data/mailSnmpTTI_JSONp.jsp?integrationType=SNMP';

				var ttSnmpForm = this.getTtmanagersnmp().getForm();
				if (ttSnmpForm.isValid())
				{
					ttSnmpForm.submit({
						url: urlForUpdation,
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: ttManagerSnmp,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function() {
										thisController.reloadIntegrationPage();
								}
							});
							
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: ttManagerSnmp,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					});
				}
			}
		});
	},
	ttWebserviceUpdate: function()
	{
		var ttIntegrationEnableStr = '';
		var ttIntegrationSystemStr = '';
		var ttUrlStr = '';
		var ttUserNameStr = '';
		var ttPasswordStr = '';
		var ttOutputStr = '';
		var ttWrapperClassNeededStr = '';
		var ttApiKeyStr = '';
		var ttAllowedAlarmsStr = '';
		var urlForUpdation = '';
		var pattern = /^((http|https):\/\/)/;
		
		var urlObj = Ext.getCmp('url');
		var webhookURLObj = Ext.getCmp('webhookURL');
		var wsdlURLObj = Ext.getCmp('wsdl_url');
		var restURLObj = Ext.getCmp('rest_url');
		var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
		var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');
		var ttIntegrationEnabled = ttIntegrationEnableObj.getValue();

		var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
		var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
		var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
		archeiveFile = fileName;
		Ext.getCmp('ArchieveFile').setValue(archeiveFile);
		Ext.getCmp('mainWrapperClass').setValue(ttWrapper);
		
		var payloadObj = Ext.getCmp('payload');
		if (payloadObj){
			var payload = payloadObj.getValue();
			if(payload){
				payload = payload.trim();
			}
			if(!this.isValidJSONPayload(payload)){
				return false;
			}
			
		}
		
		if(urlObj){
			var url = urlObj.getValue();
			if(!pattern.test(url)) {
				Ext.Msg.show({
					title: ttIntegrationTitle,
					msg: urlAlertMsg,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		} else if(webhookURLObj){
			var url = webhookURLObj.getValue();
			if(!pattern.test(url)){
				Ext.Msg.show({
					title: ttIntegrationTitle,
					msg: urlAlertMsg,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}else if(wsdlURLObj){
			var url = wsdlURLObj.getValue();
			if(!pattern.test(url)){
				Ext.Msg.show({
					title: ttIntegrationTitle,
					msg: urlAlertMsg,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}else if(restURLObj){
			var url = restURLObj.getValue();
			if(!pattern.test(url)){
				Ext.Msg.show({
					title: ttIntegrationTitle,
					msg: urlAlertMsg,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}
		

		var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp?selectSysName="+selectedIntegrationName;
		Ext.Ajax.request({
				url: url,
				scope:this,
				method: 'POST',
				success: function(response)
				{
					var me = this;
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var ttIntegrationSys = selectedIntegrationName;
					var TTIntegrationSysOld = jsonData.OldTTSys;
					var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
					var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;
					var wrapperClass = jsonData.TTWrapper;
					archeiveFile = jsonData.ArchieveFile;
		
					Ext.getCmp('integrationSys').setValue(TTIntegrationSysOld);
					Ext.getCmp('integrationFlagOld').setValue(TTIntegrationEnableValue);
					if(TTIntegrationEnableValue != null && TTIntegrationEnableValue.toLowerCase() == 'no')
					{
						if(!ttIntegrationEnabled && TTIntegrationSysOld == ttIntegrationSys)
						{
							Ext.Msg.show({
								title: ttIntegrationTitle,
								msg: ttEnableWebservicsMsg,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
								
							});
							return;
						}
					}
					if(!ttIntegrationEnabled && TTIntegrationSysOld != ttIntegrationSys){
			
							Ext.Msg.show({
								title: ttIntegrationTitle,
								msg: ttEnableWebservicsMsg,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
					}
					if(ttIntegrationEnabled)
					{
						if(ttIntegrationSys == 'SERVICE NOW')
						{
							var serviceNow = jsonData.TTServiceNow;
							var serviceNowFields = serviceNow.split(',');
							for(var i = 0; i < serviceNowFields.length; i++)
							{
								if(serviceNowFields[i] == 'ttIntegratorClass' || serviceNowFields[i] == 'supportingJar')
								{
									continue;
								}
								Ext.getCmp('$_'+serviceNowFields[i]).setValue(jsonData[serviceNowFields[i]]);
							}
	//						var TTUrl = jsonData.url;
	//						var TTPassword = jsonData.password;
	//						var TTUsername = jsonData.user;
	//						var TTPort = jsonData.port;
	//						var TTCallerID = jsonData.callerId;
	//						var TTAssignGroup = jsonData.assignmentGroup;
	//						var TTAssignTo = jsonData.assignmentTo;
	//						var TTCategory = jsonData.category;
	//						var TTCriticalDueDate = jsonData.criticalDueDatePeriod;
	//						var TTMajorDueDate = jsonData.majorDueDatePeriod;
	//						var TTMinorDueDate = jsonData.minorDueDatePeriod;
	//						var TTTicketTitleFormat = jsonData.ticketTitleFormat;
						}
						else if(ttIntegrationSys == 'MANAGE ENGINE')
						{
							var manageEngine = jsonData.TTManageEngine;
							var manageEngineFields = manageEngine.split(',');
							for(var i = 0; i < manageEngineFields.length; i++)
							{
								if(manageEngineFields[i] == 'ttIntegratorClass' || manageEngineFields[i] == 'supportingJar')
								{
									continue;
								}
								Ext.getCmp('$_'+manageEngineFields[i]).setValue(jsonData[manageEngineFields[i]]);
							}
	//						var TTUrl = jsonData.url;
	//						var TTPassword = jsonData.password;
	//						var TTUsername = jsonData.user;
	//						var TTApiKey = jsonData.apiKey;
	//						var TTOutput = jsonData.outputFormat;
						}
						else if(ttIntegrationSys == 'AUTO TASK')
						{
							var autoTask = jsonData.TTAutoTask;
							var autoTaskFields = autoTask.split(',');
							for(var i = 0; i < autoTaskFields.length; i++)
							{
								if(autoTaskFields[i] == 'ttIntegratorClass' || autoTaskFields[i] == 'supportingJar')
								{
									continue;
								}
								Ext.getCmp('$_'+autoTaskFields[i]).setValue(jsonData[autoTaskFields[i]]);
							}
	//						var TTUrl = jsonData.url;
	//						var TTPassword = jsonData.password;
	//						var TTUsername = jsonData.user;
	//						var TTAcctDiscPeriod = jsonData.accountDiscoverPeriod;
	//						var TTQueueID = jsonData.queueId;
	//						var TTDefaultAcct = jsonData.defaultAccount;
	//						var TTTicketType = jsonData.ticketType;
	//						var TTWorkType = jsonData.workType;
	//						var TTCriticalDueDate = jsonData.criticalDueDatePeriod;
	//						var TTMajorDueDate = jsonData.majorDueDatePeriod;
	//						var TTMinorDueDate = jsonData.minorDueDatePeriod;
	//						var TTTicketTitleFormat = jsonData.ticketTitleFormat;
						}
						else if(ttIntegrationSys == 'REMEDY FORCE')
						{
							var remedyForce = jsonData.TTRemedyForce;
							var remedyForceFields = remedyForce.split(',');
							for(var i = 0; i < remedyForceFields.length; i++)
							{
								if(remedyForceFields[i] == 'ttIntegratorClass' || remedyForceFields[i] == 'supportingJar')
								{
									continue;
								}
								Ext.getCmp('$_'+remedyForceFields[i]).setValue(jsonData[remedyForceFields[i]]);
							}
	//						var TTUrl = jsonData.url;
	//						var TTPartnerUtl = jsonData.partnerurl;
	//						var TTPassword = jsonData.password;
	//						var TTUsername = jsonData.user;
						}
						else if(ttIntegrationSys == 'PAGER DUTY')
						{
							var pagerDuty = jsonData.TTPagerDuty;
							var pagerDutyFields = pagerDuty.split(',');
							for(var i = 0; i < pagerDutyFields.length; i++)
							{
								if(pagerDutyFields[i] == 'ttIntegratorClass' || pagerDutyFields[i] == 'supportingJar')
								{
									continue;
								}
								Ext.getCmp('$_'+pagerDutyFields[i]).setValue(jsonData[pagerDutyFields[i]]);
							}
	//						var TTServiceURL = jsonData.ServiceURL;
	//						var TTServiceKey = jsonData.ServiceKey;
	//						var TTTitleFormat = jsonData.TitleFormat;
	//						var TTDescFormat = jsonData.DescriptionFormat;
	//						var TTClient = jsonData.Client;
	//						var TTClientURL = jsonData.ClientURL;
						}
						var labelTxt = '<b>' + archeiveFile + '</b>';

						if ((Ext.isEmpty(archeiveFile) || archeiveFile == '') && (Ext.isEmpty(archeiveFileUpload) || archeiveFileUpload == ''))
						{
							Ext.getCmp('uploadLabel').hide();
							Ext.getCmp('removeLink').hide();
						}
						else
						{
							if(archeiveFile != 'None')
							{
								Ext.getCmp('uploadLabel').show();
								Ext.getCmp('removeLink').show();
							}
						}
					}
					
					if (Ext.getCmp('TTIntegrationEnable').getValue() || Ext.getCmp('TTIntegrationEnable').getValue() == 'Yes')
					{
						for(var i=0;i<jsonData.filters.length;i++)
						{
							var filter=jsonData.filters[i];
							var ttDataVal = Ext.getCmp(filter.id).getValue();
							if(filter.type=="Textfield" || filter.type=="TextArea")
							{
								if(ttDataVal)
								{
									ttDataVal = ttDataVal.trim();
								}
								if (Ext.isEmpty(ttDataVal))
								{
									Ext.Msg.show({
										title: ttIntegrationTitle,
										msg: alertForNocommon,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp(filter.id).focus(true);
										}
									});
									return;
								}
								if(ttIntegrationSys == 'SERVICE NOW')
								{
									if(filter.id == 'proxyHostName' || filter.id == 'proxyPort' || filter.id == 'proxyUserName' || filter.id == 'proxyPassword')
									{
										var isProxyEnabled = Ext.getCmp('isProxyEnabled').getValue();
										var isProxyAuthenticated = Ext.getCmp('isProxyAuthenticated').getValue();
										
										if(isProxyAuthenticated && isProxyEnabled )
										{
											if(ttDataVal === '$unconfigured')
											{
												Ext.Msg.show({
													title: ttIntegrationTitle,
													msg: ttConfigureDetailsMsg,
													width: 300,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp(filter.id).focus(true);
													}
												});
												return;
											}
										} else if (isProxyEnabled)
										{
											if(filter.id == 'proxyHostName' || filter.id == 'proxyPort' )
											{
												if(ttDataVal === '$unconfigured')
												{
													Ext.Msg.show({
														title: ttIntegrationTitle,
														msg: ttConfigureDetailsMsg,
														width: 300,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp(filter.id).focus(true);
														}
													});
													return;
												}
											}
										}
									} else 
									{
										if(ttDataVal === '$unconfigured'){
				
											Ext.Msg.show({
												title: ttIntegrationTitle,
												msg: ttConfigureDetailsMsg,
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation',
												fn: function() {
													Ext.getCmp(filter.id).focus(true);
												}
											});
											return;
										}
										
									}
									
								} else if(ttDataVal === '$unconfigured')
								{
		
									Ext.Msg.show({
										title: ttIntegrationTitle,
										msg: ttConfigureDetailsMsg,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp(filter.id).focus(true);
										}
									});
									return;
								}

								if (filter.id == 'payload' )
								{
									if(!this.isValidJSONPayload(ttDataVal)){
										return false;
									}
								}
							}
						}
						var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
						if (isAcmeUploaded == 'no' && yesttWrapperClassNeededObj.getValue())
						{
							Ext.Msg.show({
								title: ttIntegrationTitle,
								msg: ttNoFileUpload,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}
					}

					if (ttWrapper == 'None')
					{
						urlForUpdation = '/final/admin/ManagerSettings/data/webServicesTTI_JSONp.jsp?mainWrapperClass=None&ttIntegrationEnabled='+ttIntegrationEnabled+'&TT_sys='+selectedIntegrationName;
					}
					else
					{
						urlForUpdation = '/final/admin/ManagerSettings/data/webServicesTTI_JSONp.jsp?ttIntegrationEnabled='+ttIntegrationEnabled+'&TT_sys='+selectedIntegrationName;
					}
					if(TTIntegrationEnableValue != null && TTIntegrationEnableValue.toLowerCase() == 'yes'&& ttIntegrationEnabled && TTIntegrationSysOld != ttIntegrationSys)
					{
						Ext.Msg.confirm('Confirmation', 'Do you want to change ' + capitalizeFirstLetter(TTIntegrationSysOld.toLowerCase()) + ' to ' + capitalizeFirstLetter(ttIntegrationSys.toLowerCase())+' Integration',
							function (btn){
								if (btn === "yes"){ 
								 me.ttWebserviceFormSubmit(urlForUpdation, me);
								}else {
									return false;
								}
						});
					} else {
						me.ttWebserviceFormSubmit(urlForUpdation, me);
					}
				}
			}
		);
	},
	ttWebserviceFormSubmit: function(urlForUpdation,me){
		
					var ttWebserviceForm = me.getTtmanagerwebservice().getForm();
					if (ttWebserviceForm.isValid())
					{
						ttWebserviceForm.submit({
							url: urlForUpdation,
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: ttIntegrationTitle,
									msg: settingsSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
										fn: function() {
											//alert('alert123');
											thisController.reloadIntegrationPage();
										}
									
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: ttIntegrationTitle,
									msg: settingsNoSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title: ttIntegrationTitle,
							msg: settingsNoSuccessUpdate,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
	},
	isValidJSONPayload: function(payload){
		/**if( payload == '$unconfigured' || payload == 'none'){
				Ext.Msg.show({
							title: ttIntegrationTitle,
							msg: ttJSONPayloadMsg,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							
				});
				return false;
		
		}**/
		if(payload && payload != '$unconfigured' && payload != 'none')
		{
				try
				{
					JSON.parse(payload);
				} 
				catch (e)
				{
					//alert('Invalid JSON format1');
						Ext.Msg.show({
							title: ttIntegrationTitle,
							msg: ttJSONPayloadMsg,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							
						});
					return false;
				}
		}
		return true;
	},
	ttManagerUpdate: function()
	{
		var allowedAlarmsToSet = '';

		var enableExecForTTStr = '';
		var command2Str = '';
		var commandStr = '';
		var allowedAlarmsStr = '';
		var logFileMaxSizeStr = '';
		var logEntriesForStdoutAlsoStr = '';
		var aDateFormatStr = '';
		var commandLengthStr = '';
		var probDescLengthStr = '';
		var ttIntegrationEnableStr = '';
		var ttIntegrationSystemStr = '';
		var ttUrlStr = '';
		var ttUserNameStr = '';
		var ttPasswordStr = '';
		var ttOutputStr = '';
		var ttWrapperClassNeededStr = '';
		var ttApiKeyStr = '';
		var ttAllowedAlarmsStr = '';
		var urlForUpdation = '';

		var allowedAlarmsToSet = '';

		var yesEnableExecForTTObj = Ext.getCmp('yesEnableExecForTT');
		var noEnableExecForTTObj = Ext.getCmp('noEnableExecForTT');

		var command2Obj = Ext.getCmp('Command2');
		var commandObj = Ext.getCmp('Command');
		var allowedAlarmsCObj = Ext.getCmp('AllowedAlarmsC');
		var allowedAlarmsMObj = Ext.getCmp('AllowedAlarmsM');

		var allowedAlarmsMiObj = Ext.getCmp('AllowedAlarmsMi');
		var allowedAlarmsNObj = Ext.getCmp('AllowedAlarmsN');
		var logFileMaxSizeObj = Ext.getCmp('LogFileMaxSize');

		var yesLogEntriesForStdoutAlsoObj = Ext.getCmp('yesLogEntriesForStdoutAlso');
		var noLogEntriesForStdoutAlsoObj = Ext.getCmp('noLogEntriesForStdoutAlso');
		var aDateFormatObj = Ext.getCmp('DateFormat');

		var commandLengthObj = Ext.getCmp('CommandLength');
		var probDescLengthObj = Ext.getCmp('ProbDescLength');
		var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
		var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

		var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
		//var ttNameObj = Ext.getCmp('TT_Other');
		//var ttUrlObj = Ext.getCmp('TT_Url');
		//var ttUserNameObj = Ext.getCmp('TT_User_Name');
		//var ttPasswordObj = Ext.getCmp('TT_Password');

		//var ttOutputObj = Ext.getCmp('TT_Output');
		var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
		var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
		//var ttApiKeyObj = Ext.getCmp('TT_Api_Key');

		var ttAllowedAlarmsCObj = Ext.getCmp('criticalAlarms');
		var ttAllowedAlarmsMObj = Ext.getCmp('majorAlarms');
		var ttAllowedAlarmsMiObj = Ext.getCmp('minorAlarms');
		var ttAllowedAlarmsNObj = Ext.getCmp('normalAlarms');

		var ttAllowedAlarmsC = Ext.getCmp('criticalAlarms').getValue();
		var ttAllowedAlarmsM = Ext.getCmp('majorAlarms').getValue();
		var ttAllowedAlarmsMi = Ext.getCmp('minorAlarms').getValue();
		var ttAllowedAlarmsN = Ext.getCmp('normalAlarms').getValue();

		archeiveFile = fileName;
		Ext.getCmp('ArchieveFile').setValue(archeiveFile);

		Ext.getCmp('mainWrapperClass').setValue(ttWrapper);

		var isCritical = '';
		var isMajor = '';
		var isMinor = '';
		var isNormal = '';
		var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp?selectSysName="+ttIntegrationSystemObj.getValue();

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var enableExecForTTValue = jsonData.enableExecForTT;
					var commandValue = jsonData.command;
					//alarmsArray
					var allowedAlarmsArrayLength = jsonData.alarmsArray.length;
					var logEntriesForStdoutAlsoValue = jsonData.enableLogging;
					var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
					var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;
					var criticalAlarmsChecked = jsonData.criticalAlarms;
					var majorAlarmsChecked = jsonData.majorAlarms;
					var minorAlarmsChecked = jsonData.minorAlarms;
					var normalAlarmsChecked = jsonData.normalAlarms;
					var wrapperClass = jsonData.TTWrapper;

					archeiveFile = jsonData.ArchieveFile;
					var labelTxt = '<b>' + archeiveFile + '</b>';

					if ((Ext.isEmpty(archeiveFile) || archeiveFile == '') && (Ext.isEmpty(archeiveFileUpload) || archeiveFileUpload == ''))
					{
						Ext.getCmp('uploadLabel').hide();
						Ext.getCmp('removeLink').hide();
					}
					else
					{
						Ext.getCmp('uploadLabel').show();
						Ext.getCmp('removeLink').show();
					}
					
					if (Ext.getCmp('yesEnableExecForTT').getValue())
					{
						Ext.getCmp('EnableExecForTT').setValue('Yes');
					}
		
					if (Ext.getCmp('noEnableExecForTT').getValue())
					{
						Ext.getCmp('EnableExecForTT').setValue('No');
					}

					if (Ext.getCmp('TTIntegrationEnable').getValue() || Ext.getCmp('TTIntegrationEnable').getValue() == 'Yes')
					{
						/*var ttUrl = Ext.getCmp('TT_Url').getValue();
						var ttUserName = Ext.getCmp('TT_User_Name').getValue();
						var ttPassword = Ext.getCmp('TT_Password').getValue();
						var ttOutput = Ext.getCmp('TT_Output').getValue();
						var ttApiKey = Ext.getCmp('TT_Api_Key').getValue();

						if (Ext.isEmpty(ttUrl))
						{
							Ext.Msg.show({
								title: ttIntegration,
								msg: alertForNoURL,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}

						if (Ext.isEmpty(ttUserName))
						{
							Ext.Msg.show({
								title: ttIntegration,
								msg: alertForNoUsername,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}

						if (Ext.isEmpty(ttPassword))
						{
							Ext.Msg.show({
								title: ttIntegration,
								msg: alertForNoPassword,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}

						if (Ext.isEmpty(ttOutput))
						{
							Ext.Msg.show({
								title: ttIntegration,
								msg: alertForNoOutputFields,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}

						if (Ext.isEmpty(ttApiKey))
						{
							Ext.Msg.show({
								title: ttIntegration,
								msg: alertForNoAPI,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}*/
						var ttAllowedAlarmsC = Ext.getCmp('criticalAlarms').getValue();
						var ttAllowedAlarmsM = Ext.getCmp('majorAlarms').getValue();
						var ttAllowedAlarmsMi = Ext.getCmp('minorAlarms').getValue();
						var ttAllowedAlarmsN = Ext.getCmp('normalAlarms').getValue();
						for(var i=0;i<jsonData.filters.length;i++)
						{
							var filter=jsonData.filters[i];
							var ttDataVal = Ext.getCmp(filter.id).getValue();
							if(filter.type=="Textfield" || filter.type=="TextArea")
							{
								
								if (Ext.isEmpty(ttDataVal))
								{
									Ext.Msg.show({
										title: ttIntegration,
										msg: alertForNocommon,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
									return;
								}
							}
						}
						var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
						if (isAcmeUploaded == 'no' && yesttWrapperClassNeededObj.getValue())
						{
							Ext.Msg.show({
								title: ttIntegration,
								msg: ttNoFileUpload,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}
						if (!ttAllowedAlarmsC && !ttAllowedAlarmsM  && !ttAllowedAlarmsMi && !ttAllowedAlarmsN)
						{
							Ext.Msg.show({
								title: ttIntegration,
								msg: alertForNoAlarm,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							return;
						}
					}

					if (enableExecForTTValue == 'Yes')
					{
						enableExecForTTStr = 'Enable CLI$Yes';
					}
					else
					{
						enableExecForTTStr = 'Enable CLI$No';
					}

					command2Str = 'Command$'+jsonData.command;
					commandStr = 'Command Arguments$'+jsonData.execOutFormat;

					var forAudit = '';
					var allowedAlarmsForAudit = 'Allowed alarms';
					for (var i=0; i<allowedAlarmsArrayLength; i++)
					{
						var oldValue = '$';
						var allowedAlarmsValue = jsonData.alarmsArray[i].alarms;

						forAudit += oldValue + allowedAlarmsValue;
						if (allowedAlarmsValue == 'critical')
						{
							isCritical = 'true';
						}
						if (allowedAlarmsValue == 'major')
						{
							isMajor = 'true';
						}
						if (allowedAlarmsValue == 'minor')
						{
							isMinor = 'true';
						}
						if (allowedAlarmsValue == 'normal')
						{
							isNormal = 'true';
						}
					}

					allowedAlarmsForAudit = allowedAlarmsForAudit + forAudit;

					if (isCritical == 'true')
					{
						allowedAlarmsStr = 'Allowed alarms$critical';
					}

					if (isMajor == 'true')
					{
						allowedAlarmsStr = 'Allowed alarms$major';
					}

					if (isMinor == 'true')
					{
						allowedAlarmsStr = 'Allowed alarms$minor';
					}
					
					if (isNormal == 'true')
					{
						allowedAlarmsStr = 'Allowed alarms$normal';
					}
					
					if (logEntriesForStdoutAlsoValue == 'Yes')
					{
						logEntriesForStdoutAlsoStr = 'Log entries for stdout also -  TT Manager CLI$Yes';
					}
					else
					{
						logEntriesForStdoutAlsoStr = 'Log entries for stdout also -  TT Manager CLI$No';
					}

					aDateFormatStr = 'Date format to be used$'+jsonData.dateFormat+ ' ' +'HH:mm:ss';

					commandLengthStr = 'Command length  (chars) for TT Manager CLI$'+jsonData.commandLength;

					probDescLengthStr = 'Problem description length (chars)$'+jsonData.probDescLength;

					//logFileMaxSizeStr = 'Log file maximum size (MB)$'+jsonData.logFileMaxSize;
					logFileMaxSizeStr = 'Log file maximum size MB$'+jsonData.logFileMaxSize;
					enableGraphStr = 'Enable Graph$' + jsonData.enableGraph;
					Ext.getCmp('$_EnableExecForTT').setValue(enableExecForTTStr);
					Ext.getCmp('$_Command2').setValue(command2Str);
					Ext.getCmp('Command').setValue(commandStr);
					Ext.getCmp('$_AllowedAlarms').setValue(allowedAlarmsForAudit);

					Ext.getCmp('$_LogFileMaxSize').setValue(logFileMaxSizeStr);
					Ext.getCmp('$_LogEntriesForStdoutAlso').setValue(logEntriesForStdoutAlsoStr);
					Ext.getCmp('$_DateFormat').setValue(aDateFormatStr);

					Ext.getCmp('$_CommandLength').setValue(commandLengthStr);
					Ext.getCmp('$_ProbDescLength').setValue(probDescLengthStr);

					Ext.getCmp('process').setValue('ttmanagercli');
					Ext.getCmp('from').setValue('mgrstree');

					if (ttWrapper == 'None')
					{
						urlForUpdation = '/final/admin/ManagerSettings/data/managerSettingsJSONp.jsp?mainWrapperClass=None&index=ttmanager';
					}
					else
					{
						urlForUpdation = '/final/admin/ManagerSettings/data/managerSettingsJSONp.jsp?index=ttmanager';
					}

					var ttManagerForm = this.getTtmanager().getForm();
					if (ttManagerForm.isValid())
					{
						ttManagerForm.submit({
							url: urlForUpdation,
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: pageTitle,
									msg: settingsSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: pageTitle,
									msg: settingsNoSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: settingsNoSuccessUpdate,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		);
	},
	generalSettingsUpdate: function()
	{
		var relativeThresholdTime = '';

		var url = "/final/admin/ManagerSettings/data/generalSettingsJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var authModeForLogin = jsonData.authModeForLogin;
					authModeForLogin = 'Authentication mode for login$'+authModeForLogin;

					var avgSumTrends = jsonData.avgSumTrends;
					relativeThresholdTime = jsonData.relativeThresholdHours;

					var trendMgrThreads = jsonData.trendMgrThreads;
					var thresholdMgrThreads = jsonData.thresholdMgrThreads;
					var thresholdRunDuration = jsonData.thresholdRunDuration;
					var thresholdAdjustPeriod = jsonData.thresholdAdjustPeriod;

					var fromStr = jsonData.fromTime.fromStr;
					var toStr = jsonData.toTime.toStr;

					var autoIpNameCheck = jsonData.autoIpNameCheck;

					var nickIpCheck = jsonData.nickIpCheck;
					var authLogin = jsonData.loginAuthentication;

					var trendManagerValue = Ext.getCmp('TrendMgrThreads').getValue();
					var threshManagerValue = Ext.getCmp('ThresholdMgrThreads').getValue();
					var threshRunDuration = Ext.getCmp('ThresholdRunDuration').getValue();
					var threshAdjustPeriod = Ext.getCmp('ThresholdAdjustPeriod').getValue();

					var mgrTrendVal = validateTextBoxes('general', 'trendComp', trendManagerValue);
					var mgrThreshVal = validateTextBoxes('general', 'threshComp', threshManagerValue);
					var mgrRunDuration = validateTextBoxes('general', 'freqThresh', threshRunDuration);
					var mgrAdjustPeriod = validateTextBoxes('general', 'dataPeriod', threshAdjustPeriod);

					var trendManager = '';
					var trendManagerThreadsStr = '';
					var thresholdManagerThreadsStr = '';
					var thresholdRunDurationStr = '';
					var thresholdAdjustPeriodStr = '';
					var relativeThresholdTimeStr = '';
					var autoIPNameCheckStr = '';
					var nickIpCheckStr = '';
					var authLoginStr = '';
					var relativeThresholdStr = '';

					var yesAvgSumTrends = Ext.getCmp('yesAvgSumTrends').getValue();
					var noAvgSumTrends = Ext.getCmp('noAvgSumTrends').getValue();

					var yesAutoIpNameCheck = Ext.getCmp('yesAutoIpNameCheck').getValue();
					var noAutoIpNameCheck = Ext.getCmp('noAutoIpNameCheck').getValue();

					var yesNickIpCheck = Ext.getCmp('yesNickIpCheck').getValue();
					var noNickIpCheck = Ext.getCmp('noNickIpCheck').getValue();

					if (avgSumTrends == 'Yes' || avgSumTrends == 'yes')
					{
						trendManager = 'Compute average/sum of metrics while trending$Yes';
					}
					else
					{
						trendManager = 'Compute average/sum of metrics while trending$No';
					}

					trendManagerThreadsStr = 'Number of threads for trend computation$' + trendMgrThreads;

					thresholdManagerThreadsStr = 'Number of threads for threshold computation$' + thresholdMgrThreads;

					//thresholdRunDurationStr = 'How frequently thresholds are computed (mins)$' + thresholdRunDuration;
					thresholdRunDurationStr = 'How frequently thresholds are computed in mins$' + thresholdRunDuration;

					thresholdAdjustPeriodStr = 'Data period that is used for sliding-window thresholds$' + thresholdAdjustPeriod;

					relativeThresholdTimeStr = new String(relativeThresholdTime);

					var thresholdFromTime = relativeThresholdTimeStr.substring(0,relativeThresholdTimeStr.indexOf('-'));

					var thresholdToTime = relativeThresholdTimeStr.substring(relativeThresholdTimeStr.indexOf('-')+1);

					timeForAuditStr = new String(thresholdFromTime);

					var timeFromForAudit = timeForAuditStr.substring(0,timeForAuditStr.indexOf(':'));

					var minFromForAudit = timeForAuditStr.substring(timeForAuditStr.indexOf(':'));

					timeToAuditStr = new String(thresholdToTime);
					var timeToForAudit = timeToAuditStr.substring(0,timeToAuditStr.indexOf(':'));

					var minToForAudit = timeToAuditStr.substring(timeToAuditStr.indexOf(':'));

					var addedTimeForAudit = timeFromForAudit + minFromForAudit + "-" + timeToForAudit + minToForAudit;

					var relativeThresholdAuditTime = 'Hours for which relative thresholds are computed$From : ' + timeFromForAudit + ' Hrs ' + minFromForAudit + ' Mins  To : ' + timeToForAudit + ' Hrs ' + minToForAudit +' Mins';

					var timeFrom = Ext.getCmp('timeFrom').getValue();

					timeFrom = Ext.Date.format(timeFrom, 'H:i');

					timeFromStr = new String(timeFrom);
					var hourFrom = timeFromStr.substring(0,timeFromStr.indexOf(':'));

					minFromStr = new String(timeFrom);
					var minFrom = minFromStr.substring(minFromStr.indexOf(':'));

					var timeTo = Ext.getCmp('timeTo').getValue();
					timeTo = Ext.Date.format(timeTo, 'H:i');

					if (timeTo != null && timeTo != "" && timeTo == "23:59")
					{
						timeTo = "24:00";
					}

					timeToStr = new String(timeTo);
					var hourTo = timeToStr.substring(0,timeToStr.indexOf(':'));

					minToStr = new String(timeTo);
					var minTo = minToStr.substring(minToStr.indexOf(':'));

					var temp = hourFrom + minFrom + "-" + hourTo + minTo;

					Ext.getCmp('timefrom').setValue(hourFrom);
					Ext.getCmp('minfrom').setValue(minFrom);

					Ext.getCmp('timeto').setValue(hourTo);
					Ext.getCmp('minto').setValue(minTo);

					relativeThresholdStr = 'Hours for which relative thresholds are computed$From : ' + hourFrom + ' Hrs ' + minFrom + ' Mins  To : ' + hourTo + ' Hrs ' + minTo + +' Mins';

					if (autoIpNameCheck == 'Yes' || autoIpNameCheck == 'yes')
					{
						autoIPNameCheckStr = 'Identify agents only using nick names$Yes';
					}
					else
					{
						autoIPNameCheckStr = 'Identify agents only using nick names$No';
					}

					if (nickIpCheck == 'Yes' || nickIpCheck == 'yes')
					{
						nickIpCheckStr = 'Verify if agent is reporting from configured IP$Yes';
					}
					else
					{
						nickIpCheckStr = 'Verify if agent is reporting from configured IP$No';
					}

					if (authLogin)
					{
						authLoginStr = 'Authenticate users for login$Yes';
					}
					else
					{
						authLoginStr = 'Authenticate users for login$No';
					}
					
					Ext.getCmp('$_AvgSumTrends').setValue(trendManager);
					Ext.getCmp('$_TrendMgrThreads').setValue(trendManagerThreadsStr);
					Ext.getCmp('$_ThresholdMgrThreads').setValue(thresholdManagerThreadsStr);
					Ext.getCmp('$_ThresholdRunDuration').setValue(thresholdRunDurationStr);
					Ext.getCmp('$_ThresholdAdjustPeriod').setValue(thresholdAdjustPeriodStr);
					Ext.getCmp('RelativeThresholdHours').setValue(temp);
					Ext.getCmp('$_AutoIpNameCheck').setValue(autoIPNameCheckStr);
					Ext.getCmp('$_NickIpCheck').setValue(nickIpCheckStr);
					Ext.getCmp('$_LoginAuthentication').setValue(authLoginStr);
					Ext.getCmp('$_relativeThresholdTime').setValue(relativeThresholdAuditTime);
					Ext.getCmp('$_AuthenticationModeForLogin').setValue(authModeForLogin);

					Ext.getCmp('process').setValue('general');
					Ext.getCmp('from').setValue('mgrstree');

					var process = 'general';
					var from = 'mgrstree';

					var action = '';
					var pageTitle = '<egui:intnl text="admin.generalsettings.General Settings"/>';

					var generalSettingsForm = this.getGeneral().getForm();

					if (mgrTrendVal == 'false')
					{
						Ext.Msg.show({
							title: generalPageTitle,
							msg: alertForTrendComp,
							width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}

					if (mgrThreshVal == 'false')
					{
						Ext.Msg.show({
							title: generalPageTitle,
							msg: alertForThreshComp,
							width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}

					if (mgrRunDuration == 'false')
					{
						Ext.Msg.show({
							title: generalPageTitle,
							msg: alertForFreqThresh,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}

					if (mgrAdjustPeriod == 'false')
					{
						Ext.Msg.show({
							title: generalPageTitle,
							msg: alertForDataPeriod,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}

					if (mgrTrendVal == 'true' && mgrThreshVal == 'true' && mgrRunDuration == 'true' && mgrAdjustPeriod == 'true')
					{
						if (generalSettingsForm.isValid())
						{
							generalSettingsForm.submit({
								url: '/final/admin/ManagerSettings/data/generalSettingsJSONp.jsp',
								params: 'requestFrom=updateGeneralSettings',
								method: 'POST',
								success: function(form, action){
									Ext.Msg.show({
										title: generalPageTitle,
										msg: settingsSuccessUpdate,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								},
								failure: function(form, action) // if result page doest not contain success:true, this method fires
								{
									Ext.Msg.show({
										title: generalPageTitle,
										msg: settingsNoSuccessUpdate,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								}
							});
						}
						else
						{
							Ext.Msg.show({
								title: generalPageTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					}
				}
			}
		);
	},

	notificationUpdate: function()
	{
		var url = "/final/admin/ManagerSettings/data/managerNotificationJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					/* Code added for audit log */
					var enableLicenseExpiry = jsonData.enableLicenseExpiry;
					var licenseCountExpiryAlert = jsonData.licenseCountExpiryAlert;
					var popupDiscComps = jsonData.popupDiscComps;

					var alertForAgentsNotRun = jsonData.alertForAgentsNotRun;
					var alertForUnconfigAgents = jsonData.alertForUnconfigAgents;
					var alertForUpgradeTests = jsonData.alertForUpgradeTests;

					var enableLicenseExpiryAudit = '';
					var licenseCountAlertAudit = '';
					var popupDiscCompsAudit = '';
					var alertForAgentsNotRunAudit = '';
					var alertForUnconfigAgentsAudit = '';
					var alertForUpgradeTestsAudit = '';

					if (!Ext.isEmpty(enableLicenseExpiry) && enableLicenseExpiry == 'True')
					{
						enableLicenseExpiryAudit = 'Alert when license expires$Yes';
					}
					else
					{
						enableLicenseExpiryAudit = 'Alert when license expires$No';
					}
					Ext.getCmp('$_LICENSE_EXPIRY_ALERT$enableID').setValue(enableLicenseExpiryAudit);

					if (!Ext.isEmpty(licenseCountExpiryAlert) && licenseCountExpiryAlert == 'True')
					{
						licenseCountAlertAudit = 'Alert when agent licenses are exhausted$Yes';
					}
					else
					{
						licenseCountAlertAudit = 'Alert when agent licenses are exhausted$No';
					}
					Ext.getCmp('$_MISC_ARGS$LICENSE_COUNT_EXHAUSTED_ALERT_ID').setValue(licenseCountAlertAudit);

					if (!Ext.isEmpty(popupDiscComps) && popupDiscComps == 'Yes')
					{
						popupDiscCompsAudit = 'Notify newly discovered components$Yes';
					}
					else
					{
						popupDiscCompsAudit = 'Notify newly discovered components$No';
					}
					Ext.getCmp('$_DiscCompsFlag').setValue(popupDiscCompsAudit);

					if (!Ext.isEmpty(alertForAgentsNotRun) && alertForAgentsNotRun == 'Yes')
					{
						alertForAgentsNotRunAudit = 'Alert if agents are not running$Yes';
					}
					else
					{
						alertForAgentsNotRunAudit = 'Alert if agents are not running$No';
					}
					Ext.getCmp('$_MISC_ARGS$UIAlertForAgentsNotRunningID').setValue(alertForAgentsNotRunAudit);

					if (!Ext.isEmpty(alertForUnconfigAgents) && alertForUnconfigAgents == 'Yes')
					{
						alertForUnconfigAgentsAudit = 'Alert when agents are not mapped to components$Yes';
					}
					else
					{
						alertForUnconfigAgentsAudit = 'Alert when agents are not mapped to components$No';
					}
					Ext.getCmp('$_MISC_ARGS$UIAlertForUnconfiguredAgentsID').setValue(alertForUnconfigAgentsAudit);
					
					if (!Ext.isEmpty(alertForUpgradeTests) && alertForUpgradeTests == 'Yes')
					{
						alertForUpgradeTestsAudit = 'Notify new/deprecated tests are available after upgrade$Yes';
					}
					else
					{
						alertForUpgradeTestsAudit = 'Notify new/deprecated tests are available after upgrade$No';
					}
					Ext.getCmp('$_MISC_ARGS$UIAlertForUpgradeTests').setValue(alertForUpgradeTestsAudit);
					/* End of code added for auditlog */

					Ext.getCmp('process').setValue('managerNotification');
					Ext.getCmp('from').setValue('mgrstree');

					var notificationForm = this.getManagerNotification().getForm();
					if (notificationForm.isValid())
					{
						notificationForm.submit({
							url: '/final/admin/ManagerSettings/data/managerNotificationJSONp.jsp',
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: notificationSuccessTitle,
									msg: settingsSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: notificationSuccessTitle,
									msg: settingsNoSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title: notificationSuccessTitle,
							msg: settingsNoSuccessUpdate,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		);
	},
	
	acklockoutUpdate : function()
	{
		var invalidloginmsgFlag = '';
		var lockoutmsgFlag = '';
		var lckStrategymsgFlag = '';
		var nofattmptsmsgFlag = '';
		var timeperiodmsgFlag = '';
		var nofAttmpt = Ext.getCmp('nofAttmpt').getValue();
		var timeperiod = Ext.getCmp('timeperiod').getValue();
		
		var url = "/final/admin/ManagerSettings/data/accountLockoutJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var invalidloginmsg = jsonData.InvalidLoginMsg;
					var lockoutFlag = jsonData.userAL;
					var lockstrategyFlag = jsonData.userLS;
					var nofattmptsFlag = jsonData.userNA;
					var timeperiodFlag = jsonData.userTP;
					
					if (invalidloginmsg == 'G')
					{
						invalidloginmsgFlag = 'MessageType$Generic';
					}

					if (invalidloginmsg == 'S')
					{
						invalidloginmsgFlag = 'MessageType$Specific';
					}

					if (lockoutFlag == 'yes')
					{
						lockoutmsgFlag = 'Enable account lockout$yes';
					}

					if (lockoutFlag == 'no')
					{
						lockoutmsgFlag = 'Enable account lockout$no';
					}
					
					if (lockstrategyFlag == 'R')
					{
						lckStrategymsgFlag = 'Lockout Strategy$Reset';
					}
					
					if (lockstrategyFlag == 'T')
					{
						lckStrategymsgFlag = 'Lockout Strategy$Time';
					}

					nofattmptsmsgFlag = 'Allowed login failure attempts$'+nofattmptsFlag;
					timeperiodmsgFlag = 'Time period$'+timeperiodFlag;

					Ext.getCmp('$_msgTypeRadio').setValue(invalidloginmsgFlag);
					Ext.getCmp('$_lckTypeRadio').setValue(lockoutmsgFlag);
					Ext.getCmp('$_lckStrategyRadio').setValue(lckStrategymsgFlag);
					Ext.getCmp('$_nofAttmpt').setValue(nofattmptsmsgFlag);
					Ext.getCmp('$_timeperiod').setValue(timeperiodmsgFlag);
					Ext.getCmp('process').setValue('acklockout');
					Ext.getCmp('from').setValue('mgrstree');

					var accountLockOutForm = this.getAcklockout().getForm();
					if (accountLockOutForm.isValid())
					{
						accountLockOutForm.submit({
						url: '/final/admin/ManagerSettings/data/accountLockoutJSONp.jsp?timeperiod='+timeperiod+'&nofAttmpt='+nofAttmpt,
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: lockoutTitle,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: lockoutTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						});
					}
					else
					{
						Ext.Msg.show({
							title: lockoutTitle,
							msg: settingsNoSuccessUpdate,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		);
	},

	getPasswordComplexity : function()
	{
		var lower = Ext.getCmp('lowercase').getValue();
		var upper = Ext.getCmp('uppercase').getValue();
		var digit = Ext.getCmp('number').getValue();
		var special = Ext.getCmp('specialchar').getValue();
		var result = "";
		if(lower)
		{
			result += "LC";
		}
		if(upper)
		{
			result += "," + "UC";
		}
		if(digit)
		{
			result += "," + "DG";
		}
		if(special)
		{
			result += "," + "SP";
		}
		if(result.indexOf(",") == 0)
		{
			result = result.substring(1);
		}
		return result;
	},

	setPasswordComplexity : function(val)
	{
		var temp;
		if(val.indexOf(",") > -1)
		{
			temp = val.split(",");
			for(var k=0; k<temp.length; k++)
			{
				var tempVal = temp[k].toLowerCase();
				if(tempVal == "lc")
				{
					Ext.getCmp("lowercase").setValue(true);
				}
				else if(tempVal == "uc")
				{
					Ext.getCmp("uppercase").setValue(true);
				}
				else if(tempVal == "dg")
				{
					Ext.getCmp("number").setValue(true);
				}
				else if(tempVal == "sp")
				{
					Ext.getCmp("specialchar").setValue(true);
				}
			}
		}
		else
		{
			temp = val.toString().toLowerCase();
			if(temp == "uc")
			{
				Ext.getCmp("uppercase").setValue(true);
			}
			else if(temp == "dg")
			{
				Ext.getCmp("number").setValue(true);
			}
			else if(temp == "sp")
			{
				Ext.getCmp("specialchar").setValue(true);
			}
			else
			{
				Ext.getCmp("lowercase").setValue(true);
			}
		}
	},
	
	enablePasswordHistory : function(obj)
	{
		var enableValue = obj.getValue().minHisEnable;
		if (enableValue.toLowerCase() == "yes" || enableValue.toLowerCase() == "true")
		{
			Ext.getCmp("minHistory").show();
		}
		else
		{
			Ext.getCmp("minHistory").hide();
		}
	},

	pwdpolicyUpdate : function()
	{
		var pwdLengthObj = Ext.getCmp('minLen');
		var pwdLength = pwdLengthObj.getValue();
		var pwdComplexity = this.getPasswordComplexity();
		var pwdHistoryEnable = Ext.getCmp('minHistoryEnableYes').getValue();
		var pwdHistory = Ext.getCmp('minHistory1').getValue();
		var validFlag = 'true';
		var url = "/final/admin/ManagerSettings/data/passwordPolicyJSON.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				minLenPrevious = jsonData.pwdMinLength;
				passComplexity = jsonData.pwdComplexity;
				minHisEnablePrevious = jsonData.pwdMinHistoryEnable;

				minLenPreviousStr = 'Minimum length of a password$'+minLenPrevious;
				minPassComplexStr = 'Password complexity$'+passComplexity;

				Ext.getCmp('$_minLen').setValue(minLenPreviousStr);
				Ext.getCmp('$_pwdComplexity').setValue(minPassComplexStr);
				Ext.getCmp('process').setValue('pwdpolicy');
				Ext.getCmp('from').setValue('mgrstree');

				var hiddenvars = "&$_minLen="+minLenPreviousStr+"&$_pwdComplexity="+minPassComplexStr+"&process=pwdpolicy&from=mgrstree";
				
				if(minHisEnablePrevious)
				{
					minHisPrevious = jsonData.pwdMinHistory;
					minHisEnablePreviousStr = 'Minimum History Enable$'+minHisEnablePrevious;
					minHisPreviousStr = 'Minimum History of a password$'+minHisPrevious;
					Ext.getCmp('$_minHisEnable').setValue(minHisEnablePreviousStr);
					Ext.getCmp('$_minHis').setValue(minHisPreviousStr);
					hiddenvars += "&$_minHisEnable="+minHisEnablePreviousStr+"&$_minHis="+minHisPreviousStr;
				}
				
				var pwdPolicyValidation = this.checkpwdpolicy();
				if (pwdPolicyValidation != "true")
				{
					if (pwdPolicyValidation == "1")
					{
						Ext.Msg.show({
							title: pwdpolicyTitle,
							msg: noLenAlert,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn)
							{
								pwdLengthObj.focus();
							}
						});
					}
					else if(pwdPolicyValidation == "2")
					{
						Ext.Msg.show({
							title: pwdpolicyTitle,
							msg: defMinLenAlert,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn)
							{
								pwdLengthObj.focus();
							}
						});
					}
					else if(pwdPolicyValidation == "3")
					{
						Ext.Msg.show({
							title: pwdpolicyTitle,
							msg: maxLenAlert,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn)
							{
								pwdLengthObj.focus();
							}
						});
					}
					Ext.getCmp('minLen').focus();
					validFlag = 'false';
					return;
				}
				var pwdComplexityValidation = this.pwdComplexityCheck();
				if(pwdComplexityValidation != "true")
				{
					validFlag = 'false';
					return;
				}
				if(pwdHistoryEnable != null && pwdHistoryEnable == true)
				{
					var pwdHistoryValidation = this.checkpwdhistory();
					if (pwdHistoryValidation != "true")
					{
						if (pwdHistory == null)
						{
							Ext.Msg.show({
								title: pwdpolicyTitle,
								msg: noHistoryAlert,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						else if (pwdHistoryValidation == "1")
						{
							Ext.Msg.show({
								title: pwdpolicyTitle,
								msg: minHistoryAlert,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						else if (pwdHistoryValidation == "2")
						{
							Ext.Msg.show({
								title: pwdpolicyTitle,
								msg: maxHistoryAlert,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						Ext.getCmp('minHistory1').focus();
						validFlag = 'false';
					}
				}
				var pwdPolicyForm = this.getPwdpolicy().getForm();
				if (validFlag == 'true')
				{
					//if (pwdPolicyForm.isValid())
					{
						Ext.Ajax.request({//pwdPolicyForm.submit({//
						url: '/final/admin/ManagerSettings/data/passwordPolicyJSONp.jsp?minLen='+pwdLength+'&pwdComplexity='+pwdComplexity+'&minHistoryEnable='+pwdHistoryEnable+'&minHistory='+pwdHistory+hiddenvars,
						method: 'POST',
						success: function(response){//success: function(form, action){//
							Ext.Msg.show({
								title: pwdpolicyTitle,
								msg: settingsSuccessUpdate,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: pwdpolicyTitle,
								msg: settingsNoSuccessUpdate,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						});
					}
				}
			}
		});
	},
	secureFilterUpdate : function()
	{
		var strEnableYes = Ext.getCmp('yesSecurityfilter').getValue();
		var validFlag = 'No';
		if (!Ext.isEmpty(strEnableYes))
		{
			if (strEnableYes)
			{
				validFlag = "Yes";
			}
			else
			{
				validFlag = "No";
			}
		}
		var url = "/final/admin/ManagerSettings/data/EgSecurityFilterJson.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				isEnableSecurityFiltersPrevious = jsonData.isEnableSecurityFilters;
				if (!Ext.isEmpty(isEnableSecurityFiltersPrevious))
				{
					if (isEnableSecurityFiltersPrevious)
					{
						isEnableSecurityFiltersPrevious = "Yes";
					}

					if (!isEnableSecurityFiltersPrevious)
					{
						isEnableSecurityFiltersPrevious = "No";
					}
				}
				secureFilterPrevStr = 'Enable Security Filters$'+isEnableSecurityFiltersPrevious;

				Ext.getCmp('$_enableSecureFilter').setValue(secureFilterPrevStr);
				Ext.getCmp('process').setValue('securityfilter');
				Ext.getCmp('from').setValue('mgrstree');
				

				var secureFilterForm = this.getSecurityfilter().getForm();
				if (secureFilterForm.isValid())
				{
					var infoMsg = settingsSuccessUpdate;
					if (strEnableYes)
					{
						infoMsg = enableMsg;
					}
					else
					{
						infoMsg = disableMsg;
					}
					secureFilterForm.submit({
					url: '/final/admin/ManagerSettings/data/EgSecurityFilterJsonp.jsp?enableSecureFilter='+validFlag,
					method: 'POST',
					success: function(form, action){
						Ext.Msg.show({
							title: secureFilterTitle,
							msg: infoMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						Ext.Msg.show({
							title: secureFilterTitle,
							msg: settingsNoSuccessUpdate,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
					});
				}
			}
		});
	},
	ssoLoginUpdate : function()
	{
		var isIdpLogout = Ext.getCmp('yesidpLogout').getValue();
		var url = "/final/admin/ManagerSettings/data/EgSamlSsoJson.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var isLoginPrevious = jsonData.isLogin;
				var isIdpLogoutPrevious = jsonData.isIdpLogout;

				var prevSsoLogin = "false";
				if (!Ext.isEmpty(isLoginPrevious) && isLoginPrevious)
				{
					prevSsoLogin = "true";
				}
				//var isLoginPrevStr = ssoLoginLbl+'$'+isLoginPrevious;
				var isLoginPrevStr = 'Enable single sign-on SSO$'+isLoginPrevious;
				var isIdpLogoutPrevStr = 'Allow the user to logout from the Identity Provider IdP$'+isIdpLogoutPrevious;

				Ext.getCmp('$_ssoLogin').setValue(isLoginPrevStr);
				Ext.getCmp('$_idpLogout').setValue(isIdpLogoutPrevStr);
				Ext.getCmp('process').setValue('ssologinsetting');
				Ext.getCmp('from').setValue('mgrstree');
				
				var ssoLoginForm = this.getSinglesignon().getForm();
				if (ssoLoginForm.isValid())
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Please wait...'});
					tmpMask.show();
					var infoMsg = updateLogoutUrlMsg;
					if (!isIdpLogout)
					{
						infoMsg = successMsgSSOLbl;
					}

					ssoLoginForm.submit({
						url: '/final/admin/ManagerSettings/data/EgSamlSsoJsonp.jsp?',
						method: 'POST',
						success: function(form, action){
							tmpMask.hide();
							Ext.Msg.show({
								title: SSOTitleLbl,
								msg: infoMsg,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							tmpMask.hide();
							switch (action.failureType) {
								case Ext.form.action.Action.CLIENT_INVALID:
									Ext.Msg.show({
										title: SSOTitleLbl,
										msg: 'Form fields may not be submitted with invalid values. '+action.response.statusText,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
									break;
								case Ext.form.action.Action.CONNECT_FAILURE:
									Ext.Msg.show({
										title: SSOTitleLbl,
										msg: 'Ajax communication failed. '+action.response.statusText,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								case Ext.form.action.Action.SERVER_INVALID:
									Ext.Msg.show({
										title: SSOTitleLbl,
										msg: action.response.statusText,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
							}
						}
					});
				}
			}
		});
	},

	checkpwdpolicy : function()
	{
		var pwdLength = Ext.getCmp('minLen').getValue();
		if (pwdLength == null)
		{
			return "1";
		}
		else if(pwdLength < 2)
		{
			return "2";
		}
		else if(pwdLength > 16)
		{
			return "3";
		}
		else
		{
			return "true"
		}
	},
	pwdComplexityCheck : function()
	{
		var pwdLengthObj = Ext.getCmp('minLen');
		var pwdMinLength = pwdLengthObj.getValue();
		var pwdCompLC = Ext.getCmp('lowercase').getValue();
		var pwdCompUC = Ext.getCmp('uppercase').getValue();
		var pwdCompDG = Ext.getCmp('number').getValue();
		var pwdCompSP = Ext.getCmp('specialchar').getValue();
		var pwdComplexityCount = 0;
		if (pwdCompLC)
		{
			pwdComplexityCount++;
		}
		if (pwdCompUC)
		{
			pwdComplexityCount++;
		}
		if (pwdCompDG)
		{
			pwdComplexityCount++;
		}
		if (pwdCompSP)
		{
			pwdComplexityCount++;
		}

		if(pwdMinLength < pwdComplexityCount)
		{
			Ext.Msg.show({
				title: pwdpolicyTitle,
				msg: minLenAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn)
				{
					pwdLengthObj.focus();
				}
			});
		}
		else
		{
			return "true";
		}
	},
	checkpwdhistory : function()
	{
		var pwdMinHistory = Ext.getCmp('minHistory1').getValue();

		if (pwdMinHistory < 1)
		{
			return "1";
		}
		else if(pwdMinHistory > 20)
		{
			return "2";
		}
		else
		{
			return "true";
		}
	},
	/*discCompUpdate: function()
	{
		var discCompsFlagStr = '';
		var hideTimeStr = '';

		var yesDiscCompsFlagObj = Ext.getCmp('yesDiscCompsFlag');
		var noDiscCompsFlagObj = Ext.getCmp('noDiscCompsFlag');

		var url = "/final/admin/ManagerSettings/data/managerSettingsJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var compsPopup = jsonData.discCompsPopupEnabled;

					if (compsPopup == true)
					{
						discCompsFlagStr = 'Show pop-up$Yes';
					}

					if (compsPopup == false)
					{
						discCompsFlagStr = 'Show pop-up$No';
					}

					Ext.getCmp('$_DiscCompsFlag').setValue(discCompsFlagStr);
					Ext.getCmp('process').setValue('discompopup');
					Ext.getCmp('from').setValue('mgrstree');

					var discoverComponentsForm = this.getDisccomponents().getForm();
					if (discoverComponentsForm.isValid())
					{
						discoverComponentsForm.submit({
						url: '/final/admin/ManagerSettings/data/managerSettingsJSONp.jsp?index=disccomponents',
						method: 'POST',
						success: function(form, action){
							Ext.Msg.alert(discoveredCompPageTitle,settingsSuccessUpdate);
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.alert(discoveredCompPageTitle,settingsNoSuccessUpdate);
						}
						});
					}
				}
			}
		);
	},*/

	testConfigUpdate: function()
	{
		//var yesAllowPopup = Ext.getCmp('yesAllowpopup').getValue();
		//var noAllowPopup = Ext.getCmp('noAllowpopup').getValue();
		var yesEditHost = Ext.getCmp('yesEditHost').getValue();
		var noEditHost = Ext.getCmp('noEditHost').getValue();

		//var allowPopupStr = '';
		var editHostStr = '';

		var url = "/final/admin/ManagerSettings/data/testConfigurationJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					//var allowPopup = jsonData.allowpopup;
					var editHost = jsonData.editHost;

					/*if (allowPopup == 'true' || allowPopup == 'True')
					{
						allowPopupStr = 'Pop up list of unconfigured tests$true';
					}
					else
					{
						allowPopupStr = 'Pop up list of unconfigured tests$false';
					}*/

					if (editHost.toLowerCase() == 'true' || editHost.toLowerCase() == 'yes')
					{
						editHostStr = 'Is host editable$Yes';
					}
					else
					{
						editHostStr = 'Is host editable$No';
					}

					//Ext.getCmp('$_allowpopup').setValue(allowPopupStr);
					Ext.getCmp('$_EditHost').setValue(editHostStr);

					Ext.getCmp('process').setValue('testconfig');
					Ext.getCmp('from').setValue('mgrstree');

					var testConfigSettingForm = this.getTestconfiguration().getForm();
					if (testConfigSettingForm.isValid())
					{
						testConfigSettingForm.submit({
							url: '/final/admin/ManagerSettings/data/testConfigurationJSONp.jsp',
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: testConfigPageTitle,
									msg: settingsSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: testConfigPageTitle,
									msg: settingsNoSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						});
					}
				}
			}
		);
	},

	thresholdConfigUpdate: function()
	{
		var threshIntervalForDisplay = Ext.getCmp('threshIntervalForDisplay').getValue();
		var thresholdCheckPeriod = Ext.getCmp('thresholdCheckPeriodID').getValue();
		var threshIntervalObj = Ext.getCmp('threshInterval');

		var threshIntervalStr = '';
		var thresholdCheckPeriodStr = '';
		var tempShowText = '';

		var valFlag = 'true';

		if (threshIntervalForDisplay == 'Daily')
		{
			tempShowText = 'day' + '(s)';
			threshIntervalObj.setValue('day');
		}
		else if (threshIntervalForDisplay == 'Weekly')
		{
			tempShowText = 'week' + '(s)';
			threshIntervalObj.setValue('week');
		}
		else if (threshIntervalForDisplay == 'Monthly')
		{
			tempShowText = 'month' + '(s)';
			threshIntervalObj.setValue('month');
		}

		var url = "/final/admin/ManagerSettings/data/thresholdConfigurationJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var thresholdChkVal = jsonData.thresholdChkVal;
					var thresholdChkInterval = jsonData.thresholdChkInterval;

					threshIntervalStr = 'Automatic threshold computation policy$'+thresholdChkInterval;

					thresholdCheckPeriodStr = 'Lookback period to compute automatic thresholds$'+thresholdChkVal;

					Ext.getCmp('$_threshInterval').setValue(threshIntervalStr);
					Ext.getCmp('$_thresholdCheckPeriod').setValue(thresholdCheckPeriodStr);
					//Ext.getCmp('dummy_threshInterval').setValue(tempShowText);

					Ext.getCmp('process').setValue('thresholdconfig');
					Ext.getCmp('from').setValue('mgrstree');

					var threshConfigSettingForm = this.getThresholdconfiguration().getForm();

					var chkValid = isAValidNumber(thresholdCheckPeriod);
					var greaterThanZero = parseInt(thresholdCheckPeriod) <= 0;

					if(greaterThanZero == 'true' || greaterThanZero == true)
					{
						Ext.Msg.show({
							title: threshConfigPageTitle,
							msg: alertForNotGreaterThanZero,
							width: 530,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});

						valFlag = 'false';
					}

					if (chkValid == 'false')
					{
						Ext.Msg.show({
							title: threshConfigPageTitle,
							msg: alertForNoLookBackPeriod,
							width: 530,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});

						valFlag = 'false';
					}


					if (valFlag == 'true')
					{
						if (threshConfigSettingForm.isValid())
						{
							threshConfigSettingForm.submit({
							url: '/final/admin/ManagerSettings/data/thresholdConfigurationJSONp.jsp',
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: threshConfigPageTitle,
									msg: settingsSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: threshConfigPageTitle,
									msg: settingsNoSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
							});
						}
						else
						{
							Ext.Msg.show({
								title: threshConfigPageTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					}
				}
			}
		);
	},

	threshIntervalChange: function()
	{
		var threshIntervalForDisplay = Ext.getCmp('threshIntervalForDisplay').getValue();
		var daysIdObj = Ext.getCmp('daysId');

		if (threshIntervalForDisplay == 'Daily')
		{
			tempShowText = 'day' + '(s)';
			daysIdObj.setText(tempShowText);
		}
		else if (threshIntervalForDisplay == 'Weekly')
		{
			tempShowText = 'week' + '(s)';
			daysIdObj.setText(tempShowText);
		}
		else if (threshIntervalForDisplay == 'Monthly')
		{
			tempShowText = 'month' + '(s)';
			daysIdObj.setText(tempShowText);
		}
	},

	commandExecUpdate: function()
	{
		var enableEmailStr = '';
		var logMaxSizeStr = '';
		var logEntriesStr = '';
		var seperateExcStr = '';
		var commandLengthStr = '';
		var allowedFormatStr = '';
		var validFlag = 'true';

		var yesEnable_mail = Ext.getCmp('yesEnable_mail').getValue();
		var noEnable_mail = Ext.getCmp('noEnable_mail').getValue();

		var log_maxsize = Ext.getCmp('Log_maxsizeID').getValue();
		var yesLogEntries = Ext.getCmp('yesLogEntries').getValue();
		var noLogEntries = Ext.getCmp('noLogEntries').getValue();
		var yesSeparate_exec = Ext.getCmp('yesSeparate_exec').getValue();

		var noSeparate_exec = Ext.getCmp('noSeparate_exec').getValue();
		var Command_length = Ext.getCmp('Command_lengthID').getValue();
		var allowed_format = Ext.getCmp('allowed_formatID').getValue();

		var url = "/final/admin/ManagerSettings/data/commandExecutionJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var enableCommand = jsonData.enableCommandExec;

					if (enableCommand == 'Yes')
					{
						enableEmailStr = 'Enable Command Execution$Yes';
					}
					else
					{
						enableEmailStr = 'Enable Command Execution$No';
					}

					var logForStdout = jsonData.logForStdoutAlso;

					if (logForStdout == 'Yes')
					{
						logEntriesStr = 'Log entries for stdout also - Command Execution$Yes';
					}
					else
					{
						logEntriesStr = 'Log entries for stdout also - Command Execution$No';
					}

					var SeparateExecution = jsonData.SeparateExec;

					if (SeparateExecution == 'Yes')
					{
						seperateExcStr = 'Separate Execution$Yes';
					}
					else
					{
						seperateExcStr = 'Separate Execution$No';
					}

					var commandLength = jsonData.cmdLength;
					var allowedFormat = jsonData.allowed_format;

					//commandLengthStr = 'Command length (chars) for Command Execution$'+commandLength;
					commandLengthStr = 'Command length in chars for Command Execution$'+commandLength;
					allowedFormatStr = 'Allowed script types for Command Execution$'+allowedFormat;

					Ext.getCmp('$_Enable_mail').setValue(enableEmailStr);
					Ext.getCmp('$_Log_maxsize').setValue(logMaxSizeStr);
					Ext.getCmp('$_LogEntries').setValue(logEntriesStr);
					Ext.getCmp('$_Separate_exec').setValue(seperateExcStr);
					Ext.getCmp('$_Command_length').setValue(commandLengthStr);
					Ext.getCmp('$_allowed_format').setValue(allowedFormatStr);
					Ext.getCmp('process').setValue('commandexecution');
					Ext.getCmp('from').setValue('mgrstree');

					var validPeriodValue = validateTextBoxes('commandexecution','logMaxSize',log_maxsize);
					var validCommandLength = validateTextBoxes('commandexecution','commandLength',Command_length);

					if (validPeriodValue == 'false')
					{
						Ext.Msg.show({
							title: commandExecPageTitle,
							msg: alertForLogMaximumSize,
							//width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});

						validFlag = 'false';
					}

					if (validCommandLength == 'false')
					{
						Ext.Msg.show({
							title: commandExecPageTitle,
							msg: alertForCommandLength,
							//width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});

						validFlag = 'false';
					}
					var commandExecutionForm = this.getCommandexecution().getForm();

					if (validFlag == 'true')
					{
						if (commandExecutionForm.isValid())
						{
							commandExecutionForm.submit({
							url: '/final/admin/ManagerSettings/data/commandExecutionJSONp.jsp',
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: commandExecPageTitle,
									msg: settingsSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: commandExecPageTitle,
									msg: settingsNoSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
							});
						}
						else
						{
							Ext.Msg.show({
								title: commandExecPageTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					}
				},
			}
		);
	},

	logUpdate: function()
	{
		var logDbCleanUpStr = '';
		var logScheduleReportsStr = '';
		var trendLogStr = '';
		var thresholdLogStr = '';

		var generalPanelObj = Ext.getCmp('generalPanel');
		var yesLogDbCleanupObj = Ext.getCmp('yesLogDbCleanup');
		var noLogDbCleanupObj = Ext.getCmp('noLogDbCleanup');
		var logDbCleanupObj = Ext.getCmp('logCleanUp');

		var yesLogScheduleReportsObj = Ext.getCmp('yesLogScheduleReports');
		var noLogScheduleReportsObj = Ext.getCmp('noLogScheduleReports');
		var logScheduleReportsObj = Ext.getCmp('logScheduleReports');

		var yesTrendLogObj = Ext.getCmp('yesTrendLog');
		var noTrendLogObj = Ext.getCmp('noTrendLog');
		var trendLogObj = Ext.getCmp('logTrendActivity');

		var yesThresholdLogObj = Ext.getCmp('yesThresholdLog');
		var noThresholdLogObj = Ext.getCmp('noThresholdLog');
		var thresholdLogObj = Ext.getCmp('logThreshComputeActivity');

		var url = "/final/admin/ManagerSettings/data/logSettingsJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var logDbCleanupValue = jsonData.logDbCleanup;
					var logScheduleReportsValue = jsonData.logScheduleReports;
					var trendLogValue = jsonData.trendLog;
					var thresholdLogValue = jsonData.thresholdLog;


					if (logDbCleanupValue.toLowerCase() == 'true' || logDbCleanupValue.toLowerCase() == 'yes')
					{
						logDbCleanUpStr = 'Log eG database cleanup operations$Yes';
					}
					else
					{
						logDbCleanUpStr = 'Log eG database cleanup operations$No';
					}

					if (logScheduleReportsValue.toLowerCase() == 'true' || logScheduleReportsValue.toLowerCase() == 'yes')
					{
						logScheduleReportsStr = 'Log the scheduling of reports$Yes';
					}
					else
					{
						logScheduleReportsStr = 'Log the scheduling of reports$No';
					}

					if (trendLogValue.toLowerCase() == 'true' || trendLogValue.toLowerCase() == 'yes')
					{
						trendLogStr = 'Log data trending activity$Yes';
					}
					else
					{
						trendLogStr = 'Log data trending activity$No';
					}

					if (thresholdLogValue.toLowerCase() == 'true' || thresholdLogValue.toLowerCase() == 'yes')
					{
						thresholdLogStr = 'Log threshold computation activity$Yes';
					}
					else
					{
						thresholdLogStr = 'Log threshold computation activity$No';
					}

					var hiddenCleanUpField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_LogDbCleanup',
						name: '$_LogDbCleanup',
						value: logDbCleanUpStr,
					});
					logDbCleanupObj.add(hiddenCleanUpField);

					var hiddenScheduleReportsField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_LogScheduleReports',
						name: '$_LogScheduleReports',
						value: logScheduleReportsStr,
					});
					logScheduleReportsObj.add(hiddenScheduleReportsField);

					var hiddenTrendLogField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_TrendLog',
						name: '$_TrendLog',
						value: trendLogStr,
					});
					logScheduleReportsObj.add(hiddenTrendLogField);

					var hiddenThresholdLogField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_ThresholdLog',
						name: '$_ThresholdLog',
						value: thresholdLogStr,
					});
					logScheduleReportsObj.add(hiddenThresholdLogField);

					var hiddenProcessField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'process',
						name: 'process',
						value: 'logsettings',
					});
					generalPanelObj.add(hiddenProcessField); 

					var hiddenFromField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'from',
						name: 'from',
						value: 'mgrstree',
					});
					generalPanelObj.add(hiddenFromField);

					var logSettingsForm = this.getLogsettings().getForm();
					if (logSettingsForm.isValid())
					{
						logSettingsForm.submit({
						url: '/final/admin/ManagerSettings/data/logSettingsJSONp.jsp',
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: logSettingsPageTitle,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: logSettingsPageTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						});
					}
				}
			}
		);
	},

	auditingRadioChange: function()
	{
		var yesAuditingRadioObj = Ext.getCmp('yesEnableAuditlog');
		var noAuditingRadioObj = Ext.getCmp('noEnableAuditlog');

		if (yesAuditingRadioObj.getValue())
		{
			Ext.getCmp('commandLineActivity').show();
		}

		if (noAuditingRadioObj.getValue())
		{
			Ext.getCmp('commandLineActivity').hide();
		}

	},
	acklckoutRadioChange : function()
	{
		var yesLockRadioObj = Ext.getCmp('yesLock');
		var noLockRadioObj = Ext.getCmp('noLock');

		var resetObj = Ext.getCmp('rlckStrategy');
		var timeperiodObj = Ext.getCmp('tlckStrategy');

		if (yesLockRadioObj.getValue())
		{
			Ext.getCmp('nofAttmpt').show();
			Ext.getCmp('lckStrategy').show();
			if (resetObj.getValue())
			{
				Ext.getCmp('timeperiod').hide();
			}
			if (timeperiodObj.getValue())
			{
				Ext.getCmp('timeperiod').show();
			}
		}

		if (noLockRadioObj.getValue())
		{
			Ext.getCmp('nofAttmpt').hide();
			Ext.getCmp('lckStrategy').hide();
			Ext.getCmp('timeperiod').hide();
		}
	},
	lckStrategyRadioChange : function()
	{
		var resetRadioObj = Ext.getCmp('rlckStrategy');
		var timeRadioObj = Ext.getCmp('tlckStrategy');
		
		if (resetRadioObj.getValue())
		{
			Ext.getCmp('timeperiod').hide();
		}

		if (timeRadioObj.getValue())
		{
			Ext.getCmp('timeperiod').show();
		}
	},
	auditingUpdate: function()
	{
		var auditLogForCLIStr = '';
		var enableAuditlogStr = '';
		var trendLogStr = '';
		var thresholdLogStr = '';

		var generalPanelObj = Ext.getCmp('generalPanel');

		var yesEnableAuditlogObj = Ext.getCmp('yesEnableAuditlog');
		var noEnableAuditlogObj = Ext.getCmp('noEnableAuditlog');
		var enableAuditlogObj = Ext.getCmp('enableAuditing');

		var yesAuditlogForCLIObj = Ext.getCmp('yesAuditlogForCLI');
		var noAuditlogForCLIObj = Ext.getCmp('noAuditlogForCLI');
		var auditLogForCLIObj = Ext.getCmp('commandLineActivity');

		var url = "/final/admin/ManagerSettings/data/auditingJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var enableAuditLog = jsonData.auditLogJson.EnableAuditlog;

					var auditlogForCLI = jsonData.auditLogJson.auditlogForCLI;

					if (enableAuditLog == 'yes' || enableAuditLog == 'Yes')
					{
						enableAuditlogStr = 'AuditlogEnabled$true';
					}

					if (enableAuditLog == 'no' || enableAuditLog == 'No')
					{
						enableAuditlogStr = 'AuditlogEnabled$false';
					}

					if (auditlogForCLI == 'true')
					{
						auditLogForCLIStr = 'Display command line interface in auditlog$true';
					}

					if (auditlogForCLI == 'false')
					{
						auditLogForCLIStr = 'Display command line interface in auditlog$false';
					}

					var hiddenAuditLogCLIField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_AuditlogForCLI',
						name: '$_AuditlogForCLI',
						value: auditLogForCLIStr,
					});
					generalPanelObj.add(hiddenAuditLogCLIField);

					var hiddenEnableAuditLogField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_EnableAuditlog',
						name: '$_EnableAuditlog',
						value: enableAuditlogStr,
					});
					generalPanelObj.add(hiddenEnableAuditLogField);

					var auditingForm = this.getAuditing().getForm();
					if (auditingForm.isValid())
					{
						auditingForm.submit({
						url: '/final/admin/ManagerSettings/data/auditingJSONp.jsp',
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: auditingPageTitle,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: auditingPageTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						});
					}
				}
			}
		);
	},

	advSetUpdate: function()
	{
		var stlnMgrRestartStr = '';
		var mgrOutputStr = '';
		var mgrOutputOverWirteStr = '';
		var manConfigStr = '';
		var extAgentStr = '';

		var generalPanelObj = Ext.getCmp('generalPanel');

		var yesStlnMgrRestartObj = Ext.getCmp('yesStlnMgrRestart');
		var noStlnMgrRestartObj = Ext.getCmp('noStlnMgrRestart');
		var stlnMgrRestartObj = Ext.getCmp('stlnMgrRestart');

		var yesMgrOutputObj = Ext.getCmp('yesMgrOutput');
		var noMgrOutputObj = Ext.getCmp('noMgrOutput');
		var mgrOutputObj = Ext.getCmp('mgrOutput');

		var yesMgrOutputOverWirteObj = Ext.getCmp('yesMgrOutputOverWirte');
		var noMgrOutputOverWirteObj = Ext.getCmp('noMgrOutputOverWirte');
		var mgrOutputOverWirteObj = Ext.getCmp('mgrOutputOverWirte');

		var yesManConfigObj = Ext.getCmp('yesManConfig');
		var noManConfigObj = Ext.getCmp('noManConfig');
		var manConfigObj = Ext.getCmp('manConfig');

		var yesExtAgentObj = Ext.getCmp('yesExtAgent');
		var noExtAgentObj = Ext.getCmp('noExtAgent');
		var extAgentObj = Ext.getCmp('extAgent');

		var me = this;

		Ext.Ajax.request({
			url: '/final/admin/ManagerSettings/data/advanceSettingsJSON.jsp',
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var advSetJSON = Ext.decode( jsonText );

					var managerOutputValue = advSetJSON.managerOutput;
					var mgrOutputOverWriteValue = advSetJSON.mgrOutputOverWirte;
					var updateManConfigValue = advSetJSON.updateManConfig;
					var nowExtAgentValue = advSetJSON.nowExtAgent;

					var stlnMgrRestartStr = 'Restart the manager now ?$No';

					if (managerOutputValue == 'Yes' || managerOutputValue == 'yes')
					{
						mgrOutputStr = 'Manager Output and Error$Yes';
					}

					if (managerOutputValue == 'No' || managerOutputValue == 'no')
					{
						mgrOutputStr = 'Manager Output and Error$No';
					}

					if (mgrOutputOverWriteValue == 'Yes' || mgrOutputOverWriteValue == 'yes')
					{
						mgrOutputOverWirteStr = 'Output mode$Yes';
					}

					if (mgrOutputOverWriteValue == 'No' || mgrOutputOverWriteValue == 'no')
					{
						mgrOutputOverWirteStr = 'Output mode$No';
					}

					if (updateManConfigValue == 'Yes' || updateManConfigValue == 'yes')
					{
						manConfigStr = 'Update Manual Config Files$Yes';
					}

					if (updateManConfigValue == 'No' || updateManConfigValue == 'no')
					{
						manConfigStr = 'Update Manual Config Files$No';
					}

					if (nowExtAgentValue == 'Yes' || nowExtAgentValue == 'yes')
					{
						extAgentStr = 'External agents for aggregate components$Yes';
					}
					if (nowExtAgentValue == 'No' || nowExtAgentValue == 'no')
					{
						extAgentStr = 'External agents for aggregate components$No';
					}

					var mgrRestartField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_stlnMgrRestart',
						name: '$_stlnMgrRestart',
						value: stlnMgrRestartStr,
					});
					stlnMgrRestartObj.add(mgrRestartField);

					var mgrOutputField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_mgrOutput',
						name: '$_mgrOutput',
						value: mgrOutputStr,
					});
					mgrOutputObj.add(mgrOutputField);

					var mgrOutputOverWirteField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_mgrOutputOverWirte',
						name: '$_mgrOutputOverWirte',
						value: mgrOutputOverWirteStr,
					});
					mgrOutputOverWirteObj.add(mgrOutputOverWirteField);

					var manConfigField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_manConfig',
						name: '$_manConfig',
						value: manConfigStr,
					});
					manConfigObj.add(manConfigField);

					var extAgentField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_extAgent',
						name: '$_extAgent',
						value: extAgentStr,
					});
					extAgentObj.add(extAgentField);

					var hiddenProcessField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'process',
						name: 'process',
						value: 'advancedmgrsettings',
					});
					generalPanelObj.add(hiddenProcessField); 

					var hiddenFromField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'from',
						name: 'from',
						value: 'mgrstree',
					});
					generalPanelObj.add(hiddenFromField);

					var advancedMgrForm = me.getAdvancedsettings().getForm();
					if (advancedMgrForm.isValid())
					{
						advancedMgrForm.submit({
						url: '/final/admin/ManagerSettings/data/advanceSettingsJSONp.jsp',
						method: 'POST',
						success: function(form, action){
							var showdefault = true;
								if(action.response.status == 200 && !Ext.isEmpty( action.response.responseText))
								{
									var aggregateJSON=Ext.decode(action.response.responseText);
									if(aggregateJSON.errorMessageFound)
									{
										showdefault=false;
										noManConfigObj.setValue('no');
										Ext.Msg.show({
											title: 'Advanced Settings',
											msg: aggregateJSON.aggregateErrorMsg,
											width: 300,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
									}
								}
								if(showdefault)
								{
									noManConfigObj.setValue('no');
									Ext.Msg.show({
										title: 'Advanced Settings',
										msg: settingsSuccessUpdate,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
								if(!Ext.getCmp('stlnMgrRestart_sec').isHidden())
								{
									Ext.getCmp('stlnMgrRestart_sec').items.items[1].setValue(true);
								}
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								if(!Ext.getCmp('stlnMgrRestart_sec').isHidden())
								{
									Ext.getCmp('stlnMgrRestart_sec').items.items[1].setValue(true);
								}
								Ext.Msg.show({
									title: 'Advanced Settings',
									msg: settingsNoSuccessUpdate,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						});
					}
				}
			}
		});
	},

	capacityPlanningUpdate: function()
	{
		var capacityTrendStr = '';
		var capcityReportStr = '';

		var generalPanelObj = Ext.getCmp('generalPanel');

		var yesCapacityTrendObj = Ext.getCmp('yesCapacityTrend');
		var noCapacityTrendObj = Ext.getCmp('noCapacityTrend');
		var capacityTrendObj = Ext.getCmp('capacitytrend');

		var yesCapcityreportObj = Ext.getCmp('yesCapcityreport');
		var noCapcityreportObj = Ext.getCmp('noCapcityreport');
		var capcityreportObj = Ext.getCmp('capcityreport');

		var me = this;

		Ext.Ajax.request({
			url: '/final/admin/ManagerSettings/data/capacityPlanningJSON.jsp',
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var advSetJSON = Ext.decode( jsonText );

					var capacityTrendValue = advSetJSON.capacitytrendenable;
					var capcityReportValue = advSetJSON.capacityreportenable;

					if (capacityTrendValue == 'true')
					{
						capacityTrendStr = 'Enable capacity computation by the manager$true';
					}

					if (capacityTrendValue == 'false')
					{
						capacityTrendStr = 'Enable capacity computation by the manager$false';
					}

					if (capcityReportValue == 'true')
					{
						capcityReportStr = 'Enable capacity reports$true';
					}

					if (capcityReportValue == 'false')
					{
						capcityReportStr = 'Enable capacity reports$false';
					}

					var capacityTrendField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_capacitytrend',
						name: '$_capacitytrend',
						value: capacityTrendStr,
					});
					capacityTrendObj.add(capacityTrendField);

					var capcityReportField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_capcityreport',
						name: '$_capcityreport',
						value: capcityReportStr,
					});
					capcityreportObj.add(capcityReportField);

					var hiddenProcessField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'process',
						name: 'process',
						value: 'capacityplanning',
					});
					generalPanelObj.add(hiddenProcessField); 

					var hiddenFromField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'from',
						name: 'from',
						value: 'mgrstree',
					});
					generalPanelObj.add(hiddenFromField);

					var capacityPlanningForm = me.getCapacityplanning().getForm();
					if (capacityPlanningForm.isValid())
					{
						capacityPlanningForm.submit({
						url: '/final/admin/ManagerSettings/data/capacityPlanningJSONp.jsp',
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: capacityPlanPageTitle,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: capacityPlanPageTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						});
					}
				}
			}
		});
	},

	wrapperClassRadioChange: function()
	{
		if (Ext.getCmp('yesttWrapperClassNeeded').getValue())
		{
			Ext.getCmp('uploadFile').setDisabled(false);
			Ext.getCmp('archiveUpload').hide();
		}

		if (Ext.getCmp('nottWrapperClassNeeded').getValue())
		{
			Ext.getCmp('uploadFile').setDisabled(true);
			//Ext.getCmp('archiveUpload').show();
		}

		if (Ext.getCmp('yesttWrapperClassNeeded').getValue() && (archeiveFile != '' || archeiveFileUpload != ''))
		{
			//Ext.getCmp('archiveUpload').show();
		}

		if (fileName == 'None')
		{
			//Ext.getCmp('archiveUpload').hide();
		}
	},

	virtualTopoUpdate: function()
	{
		var virtualMappingStr = '';

		var generalPanelObj = Ext.getCmp('generalPanel');

		var yesVirtualmappingObj = Ext.getCmp('yesVirtualmapping');
		var noVirtualmappingObj = Ext.getCmp('noVirtualmapping');
		var virtualMappingObj = Ext.getCmp('virtualMapping');

		var me = this;

		Ext.Ajax.request({
			url: '/final/admin/ManagerSettings/data/virtualTopologyJSON.jsp',
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var advSetJSON = Ext.decode( jsonText );

					var virtualMappingValue = advSetJSON.strVirtualMapping;

					if (virtualMappingValue == 'true')
					{
						virtualMappingStr = 'Virtual topology mapping$Auto';
					}

					if (virtualMappingValue == 'false')
					{
						virtualMappingStr = 'Virtual topology mapping$Manual';
					}

					var virtualMappingField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: '$_virtualmapping',
						name: '$_virtualmapping',
						value: virtualMappingStr,
					});
					virtualMappingObj.add(virtualMappingField);

					var hiddenProcessField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'process',
						name: 'process',
						value: 'virtualtopology',
					});
					generalPanelObj.add(hiddenProcessField); 

					var hiddenFromField = new Ext.form.field.Hidden({
						xtype: 'hiddenfield',
						id: 'from',
						name: 'from',
						value: 'mgrstree',
					});
					generalPanelObj.add(hiddenFromField);

					var virtualTopologyForm = me.getVirtualtopology().getForm();
					if (virtualTopologyForm.isValid())
					{
						virtualTopologyForm.submit({
						url: '/final/admin/ManagerSettings/data/virtualTopologyJSONp.jsp',
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: virtualTopoPageTitle,
								msg: settingsSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: virtualTopoPageTitle,
								msg: settingsNoSuccessUpdate,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						});
					}
				}
			}
		});
	},

	uploadAcmeFile: function()
	{
		Ext.widget('fileupload').show();
	},

	fileUpload: function()
	{
		var fileExt = 'jar';
		var fileExtension = '';
		var fileExtClass = 'class';
		var fileExtensionClass = '';

		Ext.getCmp('uploadtypeID').setValue('main');
		var mainClassNameTextObj = Ext.getCmp('mainClassName').getValue();;
		var fileDetailsStrClass = new String(mainClassNameTextObj);
		var fileNameClass = fileDetailsStrClass.substring(fileDetailsStrClass.lastIndexOf("\\")+1,fileDetailsStrClass.indexOf("."));
		if (!Ext.isEmpty(mainClassNameTextObj))
		{
			fileExtensionClass = mainClassNameTextObj.substring(mainClassNameTextObj.indexOf('.')+1,mainClassNameTextObj.length);
		}

		if (fileExtensionClass != fileExtClass)
		{
			Ext.Msg.show({
				title: 'File Upload',
				msg: alertForFileExtension+'.class File',
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var ttWrapperName = Ext.getCmp('mainClassName').getValue();
		var fileDetails = Ext.getCmp('TT_Wrapper').getValue();
		fileDetailsStr = new String(fileDetails);

		fileName = fileDetailsStr.substring(fileDetailsStr.lastIndexOf("\\")+1,fileDetailsStr.indexOf("."));

		ttWrapper = ttWrapperName;

		if (!Ext.isEmpty(fileDetails))
		{
			fileExtension = fileDetails.substring(fileDetails.indexOf('.')+1,fileDetails.length);
		}		
		if (!Ext.isEmpty(fileDetails) && fileExtension != fileExt)
		{
			Ext.Msg.show({
				title: 'File Upload',
				msg: alertForFileExtension+'.jar File',
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		var url = '/final/admin/ManagerSettings/data/managerSettingsJSON.jsp';

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var urlForFile = "../servlet/com.eg.TTManagerWrapperUpload";

					var fileUploadForm = this.getFileuploadform().getForm();
					if (fileUploadForm.isValid())
					{
						fileUploadForm.submit({
							url: urlForFile,
							method: 'POST',
							success: function(form, action){
								isAcmeUploaded = 'yes';
								archeiveFileUpload = fileName;
								if (!Ext.isEmpty(fileName))
								{
									//Ext.getCmp('archiveUpload').show();
									Ext.getCmp('uploadLabel').show();
									Ext.getCmp('removeLink').show();
									//Ext.getCmp('archiveUpload').doComponentLayout();
								}																
								Ext.getCmp('fileUpload').destroy();	
								Ext.Msg.show({
									title: pageTitle,
									msg: uploadSuccessMessage,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								if(!Ext.isEmpty(ttWrapperName) && Ext.isEmpty(fileName)){
									Ext.getCmp('nottWrapperClassNeeded').setValue(true);									
								}else{
									if(fileName != null && fileName.toLowerCase() != 'none')
									{
										if(fileName.indexOf('.') == -1)
										{
											Ext.getCmp('uploadLabel').setText(fileName+'.'+onlyJar,true);
										}
										else
										{
											Ext.getCmp('uploadLabel').setText(fileName,true);
										}
									}
									else
									{
										Ext.getCmp('uploadLabel').hide();
										Ext.getCmp('removeLink').hide();
									}
								}
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: pageTitle,
									msg: uploadFailureMessage,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});

								Ext.getCmp('fileUpload').destroy();
							}
						});
					}
				}
			}
		);
	},

	radioMgrOutChange: function()
	{
		var yesStlnMgrOutputObj = Ext.getCmp('yesMgrOutput');
		var noStlnMgrOutputObj = Ext.getCmp('noMgrOutput');

		if (yesStlnMgrOutputObj.getSubmitValue() == 'Yes')
		{
			var isConfirmed = Ext.MessageBox.confirm(advSettingsPageTitle,enableOutputErrorAlert,this.enableConfirmFunc,this);
		}
	},

	radioMgrOutDisableChange: function()
	{
		var yesStlnMgrOutputObj = Ext.getCmp('yesMgrOutput');
		var noStlnMgrOutputObj = Ext.getCmp('noMgrOutput');

		if (noStlnMgrOutputObj.getSubmitValue() == 'No')
		{
			var isConfirmed = Ext.MessageBox.confirm(advSettingsPageTitle,disableOutputErrorAlert,this.disableConfirmFunc,this);
		}
	},

	enableConfirmFunc: function(id)
	{
		var yesStlnMgrOutputObj = Ext.getCmp('yesMgrOutput');
		var noStlnMgrOutputObj = Ext.getCmp('noMgrOutput');

		if (id == 'no')
		{
			noStlnMgrOutputObj.setValue(true);
		}
	},

	disableConfirmFunc: function(id)
	{
		var yesStlnMgrOutputObj = Ext.getCmp('yesMgrOutput');
		var noStlnMgrOutputObj = Ext.getCmp('noMgrOutput');

		if (id == 'no')
		{
			yesStlnMgrOutputObj.setValue(true);
		}
	},

	checkAutoLoginFeature: function()
	{
		var authenticateLogin = Ext.getCmp('yesLoginAuthentication').getGroupValue();

		if (!Ext.isEmpty(authenticateLogin) && authenticateLogin.toLowerCase() == 'no')
		{
			Ext.Ajax.request(
			{
				url : 'ManagerSettings/data/generalSettingsJSON.jsp',
				scope:this,
				asyn: false,
				method : 'POST',
				success : function(response){
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var isSSO2FAEnabled = jsonData.isSSO2FAEnabled;
						if (!Ext.isEmpty(isSSO2FAEnabled) && isSSO2FAEnabled.toLowerCase() == 'yes')
						{
							Ext.Msg.confirm(generalPageTitle,autoLoginAlertMsg3+". "+autoLoginAlertMsg4,function(ans){
								if(ans === "yes") // trun off sso and 2fa
								{
									thisController.turnOff2FASSO();
								}
								else
								{
									Ext.getCmp('yesLoginAuthentication').setValue(true);
								}
							});
						}
					}
				}
			});
		}
	},

	turnOff2FASSO: function()
	{
		Ext.Ajax.request(
		{
			url : 'ManagerSettings/data/generalSettingsJSONp.jsp',
			params: 'requestFrom=turnoff2fasso',
			scope:this,
			asyn: false,
			method : 'POST'
		});
	},

	// for 2fa - starts here
	get2FAConfigDetails: function()
	{
		Ext.Ajax.request(
		{
			url : 'ManagerSettings/data/twoFactorAuthenticationJson.jsp',
			scope:this,
			method : 'POST',
			success: function(response){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					tfaJsonData = Ext.decode(jsonText);

					var is2FAEnabled = tfaJsonData.is2FAEnabled;
					var twoFAOptionFlagVal = tfaJsonData.twoFAOptionFlag;
					var twoFAOTPModeFlagVal = tfaJsonData.twoFAOTPModeFlag;

					if (!Ext.isEmpty(is2FAEnabled) && (is2FAEnabled.toLowerCase() == "true" || is2FAEnabled.toLowerCase() == "yes"))
					{
						Ext.getCmp('enable2FAYesFlag').setValue(true);
					}
					else
					{
						Ext.getCmp('enable2FANoFlag').setValue(true);
					}

					var twoFAEnableFlag = Ext.getCmp('enable2FAYesFlag').getGroupValue();
					if (!Ext.isEmpty(twoFAEnableFlag) && twoFAEnableFlag.toLowerCase() == "yes")
					{
						Ext.getCmp('twoFAOptionFlag').show();
						if (!Ext.isEmpty(twoFAOptionFlagVal) && twoFAOptionFlagVal.toLowerCase() == "c")
						{
							Ext.getCmp('compulsoryFlag').setValue(true);
						}
						else
						{
							Ext.getCmp('optionalFlag').setValue(true);
						}

						if (!Ext.isEmpty(twoFAOTPModeFlagVal) && twoFAOTPModeFlagVal.toLowerCase() == "mail")
						{
							Ext.getCmp('mail').setValue(true);
						}
						else if (!Ext.isEmpty(twoFAOTPModeFlagVal) && twoFAOTPModeFlagVal.toLowerCase() == "sms")
						{
							Ext.getCmp('sms').setValue(true);
						}
						else if (!Ext.isEmpty(twoFAOTPModeFlagVal) && twoFAOTPModeFlagVal.toLowerCase() == "ga")
						{
							Ext.getCmp('ga').setValue(true);
						}
					}
					else
					{
						Ext.getCmp('twoFAOptionFlag').hide();
					}

					//if (select == 'twofa')
					//{
						//Ext.getCmp('enable2FAYesFlag').setValue(true);
						//Ext.getCmp('compulsoryFlag').setValue(true);
					//}
					//else if (select == 'enabletwofa')
					//{
						//Ext.getCmp('enable2FAYesFlag').setValue(false);
					//}
				}
			}
		});
	},

	show2FACnt: function()
	{
		var twoFAEnableFlag = Ext.getCmp('enable2FAYesFlag').getGroupValue();
		if (!Ext.isEmpty(twoFAEnableFlag) && twoFAEnableFlag.toLowerCase() == "yes")
		{
			var loginAuthentication = tfaJsonData.loginAuthentication;
			var isMailSettingsConfigured = tfaJsonData.isMailSettingsConfigured;
			if (!Ext.isEmpty(loginAuthentication) && !loginAuthentication) // Auto login is enabled. So alert the user to turn off it to enable 2fa feature.
			{
				Ext.Msg.confirm(TFATitle,autoLoginAlertMsg1+". "+autoLoginAlertMsg2,function(ans){
					if(ans === "yes") // trun off auto login feature and enable 2fa
					{
						thisController.turnOffAutoLogin();
						Ext.getCmp('twoFAOptionFlag').show();
						if (!Ext.isEmpty(isMailSettingsConfigured) && !isMailSettingsConfigured)
						{
							var win1 = Ext.widget('grid',{
								modal: true,
								id: 'unConfMailServerSettings',
								layout: 'fit',
								cls: 'gridSkin',
								flex: 1,
								margin: 5,
								hideHeaders: true,
								emptyText: 'No data found',
								viewConfig: {
									deferEmptyText: false
								},
								store:new Ext.data.Store({
									fields: ['Message'],
									data: {'Message' : '<table align="center"><tr><td><div class="iconExclamation"></div></td><td><div style="padding:2px">Before enabling this flag, please configure </div></td><td><div style="cursor:pointer;text-decoration:underline;padding:2px" onClick="javascript:thisController.goToMailServerSettings()">Mail Server Settings!</div></td></tr></table>'},
								}),
								columns:{
									items: [
										{
											dataIndex: 'Message',
											flex : 1,
											renderer:function(val, metaData, record, row, col, store, gridView) {
												val = '<div style="cursor:pointer;">'+val+'</div>';
												if (val != null || val != '')
													return val;
											}
										}
									]
								}
							});
							twofactorauth = Ext.getCmp('twofafieldset');
							twofactorauth.add(win1);
							twofactorauth.doLayout();
							Ext.getCmp('twoFAOptionFlag').show();
							Ext.getCmp('twofa_submit_btn').disable();
						}
						else
						{
							Ext.getCmp('twofa_submit_btn').enable();
							var unConfMailServerSettings = Ext.getCmp('unConfMailServerSettings');
							if (unConfMailServerSettings != null && unConfMailServerSettings != undefined)
							{
								twofactorauth = Ext.getCmp('twofafieldset');
								twofactorauth.remove(unConfMailServerSettings);
								twofactorauth.doLayout();
							}
							Ext.getCmp('twoFAOptionFlag').show();
						}
					}
					else // dont enable 2fa 
					{
						Ext.getCmp('enable2FANoFlag').setValue(true);
						Ext.getCmp('twoFAOptionFlag').hide();
					}
				});
			}
			else if (!Ext.isEmpty(isMailSettingsConfigured) && !isMailSettingsConfigured)
			{
				var win1 = Ext.widget('grid',{
					modal: true,
					id: 'unConfMailServerSettings',
					layout: 'fit',
					cls: 'gridSkin',
					flex: 1,
					margin: 5,
					hideHeaders: true,
					emptyText: 'No data found',
					viewConfig: {
						deferEmptyText: false
					},
					store:new Ext.data.Store({
						fields: ['Message'],
						data: {'Message' : '<table align="center"><tr><td><div class="iconExclamation"></div></td><td><div style="padding:2px">Before enabling this flag, please configure </div></td><td><div style="cursor:pointer;text-decoration:underline;padding:2px" onClick="javascript:thisController.goToMailServerSettings()">Mail Server Settings!</div></td></tr></table>'},
					}),
					columns:{
						items: [
							{
								dataIndex: 'Message',
								flex : 1,
								renderer:function(val, metaData, record, row, col, store, gridView) {
									val = '<div style="cursor:pointer;">'+val+'</div>';
									if (val != null || val != '')
										return val;
								}
							}
						]
					}
				});
				twofactorauth = Ext.getCmp('twofafieldset');
				twofactorauth.add(win1);
				twofactorauth.doLayout();
				Ext.getCmp('twoFAOptionFlag').show();
				Ext.getCmp('twofa_submit_btn').disable();
			}
			else
			{
				Ext.getCmp('twofa_submit_btn').enable();
				var unConfMailServerSettings = Ext.getCmp('unConfMailServerSettings');
				if (unConfMailServerSettings != null && unConfMailServerSettings != undefined)
				{
					twofactorauth = Ext.getCmp('twofafieldset');
					twofactorauth.remove(unConfMailServerSettings);
					twofactorauth.doLayout();
				}
				Ext.getCmp('twoFAOptionFlag').show();
			}
		}
		else
		{
			Ext.getCmp('twofa_submit_btn').enable();
			var unConfMailServerSettings = Ext.getCmp('unConfMailServerSettings');
			if (unConfMailServerSettings != null && unConfMailServerSettings != undefined)
			{
				twofactorauth = Ext.getCmp('twofafieldset');
				twofactorauth.remove(unConfMailServerSettings);
				twofactorauth.doLayout();
			}
			Ext.getCmp('twoFAOptionFlag').hide();
		}
		Ext.getCmp('optionalFlag').setValue(true); // reset the option flag to default value
		thisController.showVerificationModePanel();
	},
	
	goToMailServerSettings: function()
	{
		window.location.href="EgMailServerSettings.jsp?reqfrom=enabletwofa";
	},

	turnOffAutoLogin: function()
	{
		Ext.Ajax.request(
		{
			url : 'ManagerSettings/data/twoFactorAuthenticationJsonp.jsp',
			params: 'requestFrom=turnoffautologin',
			scope:this,
			asyn: false,
			method : 'POST'
		});
	},

	showVerificationModePanel: function()
	{
		var grpVal = Ext.getCmp('compulsoryFlag').getGroupValue();
		if (!Ext.isEmpty(grpVal) && grpVal.toLowerCase() == 'c')
		{
			var isMailIDConfig = tfaJsonData.isMailIDConfig;
			var loginAuthentication = tfaJsonData.loginAuthentication;
			if (!Ext.isEmpty(isMailIDConfig) && isMailIDConfig.toLowerCase() == "false") // Some of the registered user's mail ID isn't configured. So alert the admin.
			{
				Ext.getCmp('twofa_submit_btn').disable();
				thisController.showUnConfiguredMailUsers();
				return;
			}
			else
			{
				Ext.getCmp('twofa_submit_btn').enable();
				Ext.getCmp('twoFAOTPMode').show();
				var unConfMailUsersGrid = Ext.getCmp('unConfMailUsersGrid');
				if (unConfMailUsersGrid != null && unConfMailUsersGrid != undefined)
				{
					twofactorauth = Ext.getCmp('twofafieldset');
					twofactorauth.remove(unConfMailUsersGrid);
					twofactorauth.doLayout();
				}
			}
		}
		else if (!Ext.isEmpty(grpVal) && grpVal.toLowerCase() == 'o')
		{
			Ext.getCmp('twofa_submit_btn').enable();
			Ext.getCmp('twoFAOTPMode').hide();
			var unConfMailUsersGrid = Ext.getCmp('unConfMailUsersGrid');
			if (unConfMailUsersGrid != null && unConfMailUsersGrid != undefined)
			{
				twofactorauth = Ext.getCmp('twofafieldset');
				twofactorauth.remove(unConfMailUsersGrid);
				twofactorauth.doLayout();
			}
		}
		var isMailSettingsConfigured = tfaJsonData.isMailSettingsConfigured;
		if (!Ext.isEmpty(isMailSettingsConfigured) && !isMailSettingsConfigured)
		{
			Ext.getCmp('twofa_submit_btn').disable();
		}
	},

	updateTFAAuthConfigDetails: function()
	{
		var is2FAEnabled = Ext.getCmp('enable2FAYesFlag').getGroupValue();
		var grpVal = Ext.getCmp('compulsoryFlag').getGroupValue();
		var twoFAOTPModeVal = Ext.getCmp('mail').getGroupValue();
		var twofaEnableFlagVal = '';

		if (!Ext.isEmpty(is2FAEnabled) && is2FAEnabled.toLowerCase() == "yes")
		{
			twofaEnableFlagVal = 'yes';
		}
		else
		{
			twofaEnableFlagVal = 'no';
		}

		var qryString = "requestFrom=update2faConfig&twofaEnableFlagVal="+twofaEnableFlagVal+"&twofaOptionFlagVal="+grpVal+"&twofaOTPModeFlagVal="+twoFAOTPModeVal;

		var mask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		mask.show();

		Ext.Ajax.request(
		{
			url : 'ManagerSettings/data/twoFactorAuthenticationJsonp.jsp',
			params: qryString,
			scope:this,
			asyn: false,
			method : 'POST',
			success: function(response){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					mask.hide();
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var status = jsonData.success;

					if (!Ext.isEmpty(status) && status.toLowerCase() == "true")
					{
						Ext.Msg.show({
							title: TFATitle,
							msg: TFAUpdateMsg,
							width: 480,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					}
				}
			},
			failure: function(response)
			{
				mask.hide();
				Ext.Msg.show({
					title: TFATitle,
					msg: settingsNoSuccessUpdate,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		});
	},

	showUnConfiguredMailUsers: function()
	{
		var win = Ext.widget('grid',{
			title :'Users not assigned with mail IDs',
			modal: true,
			id: 'unConfMailUsersGrid',
			layout: 'fit',
			cls: 'gridSkin',
			flex: 1,
			margin: 5,
			scroll: true,
			autoScroll: true,
			height: 250,
			store:new Ext.data.Store({
				fields: ['userID1','userID2'],
				data: tfaJsonData.MailUnConfiguredUsrsList
			}),
			viewConfig: {
				deferEmptyText: true
			},
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'top',
				ui: 'footer',
				items: [
					{
						xtype: 'label',
						width:'100%',
						id: 'Expand',
						scope: this,
						html:'<div style="float:left;font-size:9px;padding:2px" id="exx">* Ensure all the users are configured with mail IDs to enforce this feauture across the Enterprise.<br>* Click on a user to configure the mail ID.</div>' 
					}
				]
			}],
			listeners : {
				'cellclick': function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
				{
					var pos = grid.getSelectionModel().getCurrentPosition();
					record = grid.store.getAt(pos.row);
					colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
					cellvalue = record.data[colname];
					if (!Ext.isEmpty(cellvalue) && (cellvalue == 'admin' || cellvalue == 'supermonitor' || cellvalue.toLowerCase() == 'egenterprise'))
					{
						Ext.Msg.show
						({
							title : TFATitle,
							msg : "Please login as "+cellvalue+" to configure mail ID.",
							buttons : Ext.Msg.OK,
							icon : 'iconExclamation'
						});
						return;
					}
					else
					{
						if (cellvalue.indexOf("(Group)") != -1)
						{
							var idx = cellvalue.indexOf("/");
							var nextIdx = cellvalue.indexOf("(Group)");
							var strtempuname = cellvalue.substring(0,idx);
							strtempuname = strtempuname + "/Grp/";
							var strtempuname_A = cellvalue.substring(idx + 1 ,nextIdx);
							cellvalue = strtempuname + strtempuname_A;
							cellvalue = cellvalue.trim();
						}
						window.location.href="EgChangeUserProfile.jsp?username="+encodeURIComponent(cellvalue)+"&qctr=1&reqfrom=twofa";
					}
				}
			},
			hideHeaders: true,
			selModel: {
				selType: 'cellmodel',
				mode: 'SINGLE'
			},
			emptyText: 'No data found',
			columns:{
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						dataIndex: 'userID1',
						flex : 1,
						renderer:function(val, metaData, record, row, col, store, gridView) {
							metaData.tdAttr = 'data-qtip="' + val + '"';
							val = '<div style="cursor:pointer;">'+val+'</div>';
							if (val != null || val != '')
								return val;
						}
					},
					{
						dataIndex: 'userID2',
						flex : 1,
						renderer:function(val, metaData, record, row, col, store, gridView) {
							metaData.tdAttr = 'data-qtip="' + val + '"';
							val = '<div style="cursor:pointer;">'+val+'</div>';
							if (val != null || val != '')
								return val;
						}
					}
				]
			}
		});
		twofactorauth = Ext.getCmp('twofafieldset');
		twofactorauth.add(win);
		twofactorauth.doLayout();
	},

reloadIntegrationPage: function(){
		var innerMainPanelObj = Ext.getCmp('innerPanel');
		innerMainPanelObj.removeAll();
		var url = "/final/admin/ManagerSettings/data/TTintegrationListViewJSON.jsp";
		var mask = new Ext.LoadMask(Ext.getBody(), {msg: 'Please wait...'});
		mask.show();
		Ext.Ajax.request({
		url : url,
		scope:this,
		method : 'POST',
		success: function(response){
			mask.hide();
			var jsonText = response.responseText;
			var jsonData = Ext.decode(jsonText);
			
			innerMainPanelObj.add({ 
			xtype: 'TTlistview',
			dataforView: jsonData['integrationList']
			});
		
		//	Ext.getCmp('innerPanel').setTitle('TROUBLE TICKET INTEGRATION');
		},
		failure: function(response)
		{
			mask.hide();
			/**Ext.Msg.show({
				title: TFATitle,
				msg: '',
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});**/
		}
	});

}

	// for 2fa - ends here

	//TT FIlter starts here

,
	loadTTFilterOption: function()
	{
		var isEnabledTTFilter = Ext.getCmp('yesEnableTTFilter').getValue();
		var filterOptionContainerObj = Ext.getCmp('filterOptionContainer');
		filterOptionContainerObj.show();
		
		if(isEnabledTTFilter)
		{
			//var reqFrom = "navlink";
			//var mailFilterOption = "";
			me = this;
			
			var url = "ManagerSettings/data/EgTTFilterSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();

			me.updateUserMailSuppressList(url);
			me.updateFilterComponents();
			me.initUserMailConfigs();
			if (mailFilterOption == "Descriptors_Only")
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').hide();
					Ext.getCmp('filterLabelID').show();
					me.showFilterDetails();
					Ext.getCmp('btnViewFilters').setText(pageIntnl97);
				}
			}
			else
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').show();
					Ext.getCmp('filterLabelID').hide();
					Ext.getCmp('btnViewFilters').setText(pageIntnl87);
				}
			}
		} else {
		
		}
		

	},updateUserMailSuppressList : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userMailJSON = Ext.decode(jsonText);
			},failure: function(response)
			{
				alert('updateUserMailSuppressList');
			},

		});
	},
	initUserMailConfigs : function()
	{
		var me = this;
		var queryStatus = userMailJSON.requestStatus;
		if (queryStatus == "success")
		{
			//var tmpUserID = Ext.getCmp('uname').getValue();
			//var tmpUserID = "admin";
			//this.setLangEntries(userMailJSON.langEntries);
			var filters = userMailJSON.filters;
			var isComponentsAssociated = userMailJSON.isComponentsAssociated;
			if (isComponentsAssociated == true)
			{
				var associateObj = Ext.getCmp('filter');
				associateObj.getStore().loadRawData(filters);
				associateObj.setValue("-1");
				Ext.getCmp('CompTypes').hide();
				var tmpStore = Ext.getCmp('exclude');
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
			}
			else
			{
				//alert('else part');
				//console.log('else part');
				/**var userformcontainerObj = Ext.getCmp('userformcontainer');
				var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
				var tmpUserID = Ext.getCmp('uname').getValue();
				var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({
					xtype : 'component',
					border : false,
					padding:160,
					style:{'text-align':'center'},
					html:message
				});**/
			}
		}
		else
		{
			//alert('else part 2');
			//console.log('else part 2');
			/**
			var userformcontainerObj = Ext.getCmp('userformcontainer');
			var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
			var message = me.getErrorMessageTemplate(userMailJSON.errors);
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'component',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
			**/
		}
	},
	popFilterDetails : function(obj)
	{
		//var reqFrom = "navlink";
		var me = this;
		updateSettings = false;
		
		var page ="ManagerSettings/data/EgTTFilterSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
		var selectedOption = obj.getValue();
		if(selectedOption != "-1")
		{
			page = page+"&filterBy="+selectedOption;
			if(selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
			{
				page = page + "&serverType=-1";
			}
			else if(selectedOption == "filterByLayer" || selectedOption == "filterByTest")
			{
				page = page + "&serverType=filterByAll";
			}
			page = page + "&date="+new Date().getTime();
			//me.updateUserMailSuppressList(page);
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.getStore().loadRawData(excludedItems);
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					var compTypeContainer = Ext.getCmp('CompTypes');
					var compTypesInCt = Ext.getCmp('compTypesIn');
					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testObj = Ext.getCmp('Test');
					var serverTestsCt = Ext.getCmp('serverTestsCt');
					compTypeContainer.hide();
					compTypesInCt.hide();
					serverTestsOuterCt.hide();
					testObj.hide();
					serverTestsCt.hide();
					Ext.getCmp('serseg').hide();
					if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
						selectedOption == "filterByDescriptor")
					{
						var tmpCompObj = Ext.getCmp('CompTypes');
						var compopnentTypes = userMailJSON['compopnentTypes'];
						tmpCompObj.getStore().loadRawData(compopnentTypes);
						if (selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
						{
							tmpCompObj.setValue("-1");
						}
						else
						{
							tmpCompObj.setValue("filterByAll");
						}
						if (userMailJSON.isOtherGroupsFound)
						{
							compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
							compTypesInCt.setValue(userMailJSON.displayText);
							compTypesInCt.show();
							if (compTypesInCt.getValue() != 'cType')
							{
								Ext.getCmp('serseg').show();
							}
						}
						else
						{
							compTypesInCt.hide();
						}
						serverTestsOuterCt.show();
						compTypeContainer.show();
						if (selectedOption == "filterByDescriptor")
						{
							Ext.getCmp('compName').getStore().removeAll();
							Ext.getCmp('searchbox').setDisabled(true);
							Ext.getCmp('searchbox').setValue('');
							testObj.show();
							serverTestsCt.show();
							testObj.getStore().removeAll();
							testObj.getStore().loadRawData(userMailJSON.testArray);
							testObj.setValue("-1");
						}
					}
					tmpStore.fromField.getComponent(0).setTitle(userMailJSON['itemTitle1']);
					tmpStore.toField.getComponent(0).setTitle(userMailJSON['itemTitle2']);
				}
			});
		}
		else
		{
			Ext.suspendLayouts();
			var tmpStore = Ext.getCmp('exclude');
			tmpStore.fromField.getComponent(0).setTitle(excludedAlertsMsg);
			tmpStore.toField.getComponent(0).setTitle(includedAlertsMsg);
			Ext.getCmp('CompTypes').hide();
			Ext.getCmp('compTypesIn').hide();
			Ext.getCmp('serseg').hide();
			Ext.getCmp('serverTestsOuterCt').hide();
			Ext.resumeLayouts(true);
		}
	},
	popCompTypes : function(obj)
	{
		updateSettings = false;
		//var reqFrom = "navlink";
		
		var filterBy = Ext.getCmp('filter').getValue();
		var serverType = obj.getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="ManagerSettings/data/EgTTFilterIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			
			page = page+"&filterBy=filterByDescriptor&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime()+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg);
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//if (filterBy == "filterByDescriptor")
					{
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
						testCt.getStore().removeAll();
						Ext.getCmp('compName').getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="ManagerSettings/data/EgTTFilterSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&date="+new Date().getTime();

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//var serverTestsCt = Ext.getCmp('serverTestsCt');
					if (filterBy == "filterByDescriptor")
					{
						testCt.getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
						serverTestsOuterCt.show();
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
						testCt.show();
						//serverTestsCt.hide();
					}
					else
					{
						//serverTestsOuterCt.hide();
						testCt.hide();
						//serverTestsCt.hide();
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		//this.updateUserMailSuppressList(page);

		
	},
	viewByCriteria : function(obj)
	{
		
		updateSettings = false;
		var viewByValue = obj.getValue();
		var filterObj = Ext.getCmp('filter');
		var filterBy = filterObj.getValue();
		var sersegObj = Ext.getCmp('serseg');
		var compTypes = Ext.getCmp('CompTypes');
		var testCombo = Ext.getCmp('Test');
		var page = "";
		var me = this;
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="ManagerSettings/data/EgTTFilterIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : notApplicableMsg,
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : notApplicableMsg,
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}
					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="ManagerSettings/data/EgTTFilterSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : notApplicableMsg,
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : notApplicableMsg,
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}
					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	changeByServer : function(obj)
	{
		updateSettings = false;
		var viewByServer = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var CompTypesObj = Ext.getCmp('CompTypes');
		var testCombo = Ext.getCmp('Test');
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="ManagerSettings/data/EgTTFilterIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}
		else
		{
			page ="ManagerSettings/data/EgTTFilterSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				CompTypesObj.getStore().loadRawData(userMailJSON.compopnentTypes);
				if(viewByServer == "-1")
				{
					CompTypesObj.getStore().removeAll();
					CompTypesObj.getStore().loadData([
						{
							'displayField' : notApplicableMsg,
							'valueField' : '-1'
						}
					]);
				}
				testCombo.getStore().removeAll();
				testCombo.getStore().loadData([
					{
						'displayField' : notApplicableMsg,
						'valueField' : '-1'
					}
				]);
				Ext.getCmp('compName').getStore().removeAll();
				Ext.getCmp('searchbox').setDisabled(true);
				Ext.getCmp('searchbox').setValue('');
				if(CompTypesObj.getStore().getCount() > 0)
				{
					CompTypesObj.setValue(CompTypesObj.getStore().getAt(0));
				}
				if(testCombo.getStore().getCount() > 0)
				{
					testCombo.setValue(testCombo.getStore().getAt(0));
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},changeByTest : function(obj)
	{
		updateSettings = false;
		var viewByTest = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="ManagerSettings/data/EgTTFilterIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="ManagerSettings/data/EgTTFilterSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		if (!Ext.isEmpty(viewByTest) && viewByTest == '-1')
		{
			Ext.getCmp('searchbox').setDisabled(true);
			Ext.getCmp('searchbox').setValue('');
		}
		else
		{
			Ext.getCmp('searchbox').setDisabled(false);
			Ext.getCmp('searchbox').setValue('');
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				var compNameObj = Ext.getCmp('compName');
				compNameObj.getStore().loadRawData(userMailJSON.compNameArr);
				compNameArrTemp = userMailJSON.compNameArr;
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByComponentName : function(obj)
	{
		var compNames = obj.getValue();
		if(compNames == "" || compNames == "-1")
		{
			var excludeItemObj = Ext.getCmp('exclude');
			excludeItemObj.getStore().removeAll();
			if(excludeItemObj.fromField.store.getCount() > 0)
			{
				excludeItemObj.fromField.store.removeAll();
			}
			if(excludeItemObj.toField.store.getCount() > 0)
			{
				excludeItemObj.toField.store.removeAll();
			}
			return;
		}
		var filterBy = Ext.getCmp('filter').getValue();
		var Test = Ext.getCmp('Test').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var compTypesInObj = Ext.getCmp('compTypesIn');

		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="ManagerSettings/data/EgTTFilterIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var serseg = Ext.getCmp('serseg');
					page = page + "&serseg="+compTypesIn;
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(includedItems))
					{
						//tmpStore.fromField.store.add(excludedItems);
						tmpStore.fromField.store.add(includedItems);
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.toField.store.add(includedItems);
						tmpStore.toField.store.add(excludedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="ManagerSettings/data/EgTTFilterSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var serseg = Ext.getCmp('serseg');
					page = page + "&serseg="+compTypesIn;
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	assignAndAddMoreFilters : function(obj)
	{
		var me = this;
		obj.setDisabled(true);

		if (mailFilterOption == "Descriptors_Only")
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "ManagerSettings/data/EgTTFilterIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			var compNames = Ext.getCmp("compName").getValue();
			tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);

			var tmpStore = Ext.getCmp('exclude');
			var arrInc1 = new Array();
			var arrExc1 = new Array();
			var fromStore = tmpStore.fromField.store;
			var toStore = tmpStore.toField.store;
			for(var z = 0;z<fromStore.getCount();z++)
			{
				var tmpVal = fromStore.getAt(z).get("valueField");
				arrExc1.push(tmpVal);
			}

			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z).get("valueField");
				arrInc1.push(tmpVal);
			}
			if (arrExc1.length == 0 && arrInc1.length == 0)
			{
				Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
				obj.setDisabled(false);
				return;
			}

			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.setHiddenFiledsForFilters(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		else
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "ManagerSettings/data/EgTTFilterSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			if(filterBy == "-1")
			{
				Ext.MessageBox.alert(pageIntnl82,pageIntnl90);
				obj.setDisabled(false);
				return;
			}

			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var compNames = "";
			if (filterBy == "filterByDescriptor")
			{
				compNames = Ext.getCmp("compName").getValue();
				//tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			}
			me.setHiddenFiledsForFilters(hiddenFieldsKeys,compNames);
			///var thisForm = me.getEgmailalertsuppress().getForm();
			var thisForm = me.getTtcommonsettings().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getTtcommonsettings().submit({
					url: tmpURL,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	showResultText : function()
	{
		if (Ext.getCmp('resultCt') == null || Ext.getCmp('resultCt') == undefined)
		{
			var panelAbsolute = Ext.create('Ext.container.Container',{
				floatable : true,
				floating:true,
				id : 'resultCt',
				width : 380,
				items : [
					{
						xtype : 'component',
						padding :0,
						margin:5,
						cls : 'popupAlertUser',
						html  : '<table border="0" width="100%"><tr><td><div class="iconRight" style="margin:4px;float:left"></div><div style="margin:4px;float:left">'+addNassignMsg+'</div><div class="iconClosePopup" style="float:right;margin:4px"></div><td></tr></table>',
					}
				]
			});
			var VWidth = Ext.Element.getViewportWidth();
			panelAbsolute.showAt(VWidth-410,85);
			Ext.select('.iconClosePopup').on('click',function(){
				panelAbsolute.destroy();
			},this);

			var task = new Ext.util.DelayedTask(function(){
				panelAbsolute.destroy();
			});
			task.delay(2000);
		}
	},
	setFilterValues : function(cntValue)
	{
		
		if (typeof userMailJSON == 'undefined'){
			//console.log('userMailJSON is undefined-> ');
			return
		}
			//console.log(' 555 userMailJSON-> ');
		var hiddenFieldsKeys = userMailJSON['hiddenFields'];
		var hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
		var tmpStore = Ext.getCmp('exclude');
		var arrInc = new Array();
		var arrExc = new Array();
		var fromStore = tmpStore.fromField.store;
		var toStore = tmpStore.toField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			arrExc.push(tmpVal);
		}

		for(var z = 0;z<toStore.getCount();z++)
		{
			var tmpVal = toStore.getAt(z).get("valueField");
			arrInc.push(tmpVal);
		}
		if(userMailJSON['excludedBoxHostVal'] && userMailJSON['excludedBoxHostVal'] != undefined)
		{
			var valueHost =userMailJSON['excludedBoxHostVal'];
			if(valueHost !=null && valueHost != "")
			{
				arrExc[arrExc.length] = valueHost;
			}
		}
		if (mailFilterOption == "Descriptors_Only")
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		else
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		hiddenFieldsContainerObj.removeAll();
		hiddenFieldsContainerObj.add(includedBoxVal);
		hiddenFieldsContainerObj.add(excludedBoxVal);
		hiddenFieldsContainerObj.add(tmpActionObj);
		//if (!Ext.isEmpty(hiddenFieldsKeys.previousExcVal))
		//{
			var tmpPrevExcValObj = {
				xtype : 'hiddenfield',
				name : 'previousExcVal',
				value : hiddenFieldsKeys.previousExcVal
			}
			hiddenFieldsContainerObj.add(tmpPrevExcValObj);
		//}
	},
	setHiddenFiledsForFilters: function(hiddenFields,compNames)
	{
		var hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
		for (key in hiddenFields)
		{
			if (key == "vsTypes")
			{
				continue;
			}
			var keyValue  = hiddenFields[key];
			hiddenFieldsContainerObj.add({xtype: 'hiddenfield',name : key,value : keyValue});
		}
		hiddenFieldsContainerObj.add({xtype: 'hiddenfield',name : 'compNames',value : compNames});
	},
	viewFilteredElements : function()
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			id:'userFilterWindow',
			width: '95%',
			height: 450,
			border : false,
			modal : true,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					if (mailFilterOption == "Descriptors_Only")
					{
						var title = filterMessage2 + ": "+selectedUserID;
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "ManagerSettings/data/EgTTFilterIncludeSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						//me.updateUserMailSuppressList(url);
						me.updateDescriptorHTMLFiltePanel(url);
					}
					else
					{
						var title = filterMessage;// + ": "+selectedUserID;
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "ManagerSettings/data/EgTTFilterSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						//me.updateUserMailSuppressList(url);
						me.updateHTMLFilterResultPanel(url);
					}
				}
			},
			items:[
				{
					xtype: 'container',
					id: 'userFilterContainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					defaults: {
						margin : 8
					}
				}
			]
		}).show();
	},updateHTMLFilterResultPanel : function(urlStr)
	{
		var me = this;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var userFilterContainerObj = Ext.getCmp('userFilterContainer');
				userFilterContainerObj.update(jsonText);
				Ext.getCmp('userFilterWindow').doLayout();
				delete jsonText;
				delete userFilterContainerObj;
			}
		});
	},
	submitTTFilterElements : function(obj)
	{
		//ttCommonSettingsUpdate();
		var me = this;
		var appendTTFilter = false;
		var yesEnableTTFilterObj = Ext.getCmp('yesEnableTTFilter');

		if(yesEnableTTFilterObj.getValue()){
			appendTTFilter = true;
		}
		
		if(appendTTFilter == true){
			var isComponentsAssociated = userMailJSON.isComponentsAssociated;
			me.ttCommonSettingsUpdate(appendTTFilter, isComponentsAssociated);
		} else {
			me.ttCommonSettingsUpdate(appendTTFilter, false);
		}
		//console.log('isComponentsAssociated---> '+isComponentsAssociated);
		if(appendTTFilter && isComponentsAssociated)
		{
			obj.setDisabled(true);
			if (mailFilterOption == "Descriptors_Only")
			{
				var tmpURL = "ManagerSettings/data/EgTTFilterIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
				me.setFilterValues("finish");

				var tmpStore = Ext.getCmp('exclude');
				var arrInc1 = new Array();
				var arrExc1 = new Array();
				var fromStore = tmpStore.fromField.store;
				var toStore = tmpStore.toField.store;

				for(var z = 0;z<fromStore.getCount();z++)
				{
					var tmpVal = fromStore.getAt(z).get("valueField");
					arrExc1.push(tmpVal);
				}

				for(var z = 0;z<toStore.getCount();z++)
				{
					var tmpVal = toStore.getAt(z).get("valueField");
					arrInc1.push(tmpVal);
				}
				if (arrExc1.length == 0 && arrInc1.length == 0)
				{
					Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
					obj.setDisabled(false);
					return;
				}

				var compNames = Ext.getCmp("compName").getValue();
				//tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
				var hiddenFieldsKeys = userMailJSON['hiddenFields'];
				//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
				me.setHiddenFiledsForFilters(hiddenFieldsKeys,compNames);
				var thisForm = me.getTtcommonsettings().getForm();
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myMask.show();

				if (thisForm.isValid())
				{
					this.getTtcommonsettings().submit({
						url: tmpURL,
						method: 'POST',
						//standardSubmit: true,
						success: function(form, action){
							myMask.hide();
							//me.showResultQBox(action.response.responseText);
							Ext.Msg.show({
								title: pageTitle,
								msg: settingsSuccessUpdate,
								//msg: pageIntnl99,
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation',
								fn : function(){
									///me.showUserAddForm();
								}
							});
							//me.showUserAddForm();
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							myMask.hide();
							//me.showUserAddForm();
						}
					});
				}
			}
			else
			{
				var filterBy = Ext.getCmp('filter').getValue();
				var tmpURL = "ManagerSettings/data/EgTTFilterSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID)+"&update=all";
				me.setFilterValues("finish");
				var compNames = "";
				if (filterBy == "filterByDescriptor")
				{
					compNames = Ext.getCmp("compName").getValue();
					//tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
				}
				var yesEnableTTFilterObj = Ext.getCmp('yesEnableTTFilter');

				var hiddenFieldsKeys = userMailJSON['hiddenFields'];
				//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
				me.setHiddenFiledsForFilters(hiddenFieldsKeys,compNames);
				
				var thisForm = me.getTtcommonsettings().getForm();
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myMask.show();
				if (thisForm.isValid())
				{
					this.getTtcommonsettings().submit({
						url: tmpURL,
						method: 'POST',
						//standardSubmit: true,
						success: function(form, action){
							myMask.hide();
							Ext.Msg.show({
								title: pageTitle,
								//title: pageIntnl82,
								//msg: pageIntnl99,
								msg: settingsSuccessUpdate,
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation',
								fn : function(){
									//me.showUserAddForm();
								}
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
						myMask.hide();
						//me.showUserAddForm();
						}
					});
				}
			}
			obj.setDisabled(false);
		}
	},updateResultPanel : function()
	{
		var isElementsAssociated = userElementJSON.isElementsAssociated;
		var userAssociationContainer = Ext.getCmp('userAssociationContainer');
		var elementassociationcontainer = Ext.getCmp('elementassociationcontainer');
		userAssociationContainer.removeAll();
		if (isElementsAssociated == true)
		{
			
			userAssociationContainer.add(
				{
				xtype : 'componentgroupedsummarygrid',
				store: new Ext.data.Store({
					fields: ['col_1', 'category','col_2','col_3'],
					groupField: 'category',
					data: userElementJSON.userTableData,
				})
			});
			userAssociationContainer.doLayout();
			Ext.getCmp('Expand').show();
		}
		else
		{
			Ext.getCmp('Expand').hide();
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>"+intnlLabel5+".</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			userAssociationContainer.add(tmpPanel);
		}
	},
	
	updateFilterComponents : function()
	{
		var me = this;
		var elementFilteringTabObj = Ext.getCmp('filterOptionContainer');
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		
		if (isComponentsAssociated != true)
		{
			var tmpUserID = selectedUserID;//Ext.getCmp('uname').getValue();
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been managed.</b></div>";
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'panel',
				border : false,
				//height:300,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	deleteUsersUpdate: function()
	{
		var val = "";
		if(Ext.getCmp('zones').getValue())
		{
			val="$zones";
		}
		if(Ext.getCmp('servicegroups').getValue())
		{
			val+="$servicegroups";
		}
		if(Ext.getCmp('services').getValue())
		{
			val+="$services";
		}
		if(Ext.getCmp('segments').getValue())
		{
			val+="$segments";
		}
		if(Ext.getCmp('groups').getValue())
		{
			val+="$groups";
		}
		if(Ext.getCmp('components').getValue())
		{
			val+="$components";
		}
		if(Ext.getCmp('exremote').getValue())
		{
			val+="$exremote";
		}
		if(val.length>0)
		{
			val=val.substring(1);
		}

		var delete_comps_val = Ext.getCmp('allowDeleteOrg').getValue().allowDeleteOrg;
		var auto_delete_expired_users = Ext.getCmp('autoDeleteExpUsers').getValue().autoDeleteExpUsers;
		var delete_after_x_days = Ext.getCmp('daysAfter').getValue();
		var delete_components = Ext.getCmp('components').getValue()?"true":"false";
		var delete_agents = Ext.getCmp('exremote').getValue()?"true":"false";
		var delete_comps_after_x_days = Ext.getCmp('daysNotReporting').getValue();
		var delete_immediately = Ext.getCmp('yesImmediateDelete').getValue()?"true":"false";

		var allow_delete_org = 'no';
		if(Ext.getCmp('yesallowDeleteOrg').getValue())
		{
			allow_delete_org = 'yes';
		}
		else
		{
			allow_delete_org = 'no';
		}
		var delete_org = 'no';
		if(Ext.getCmp('yesdeleteOrg').getValue())
		{
			delete_org = 'yes';
		}
		else
		{
			delete_org = 'no';
		}
		var delete_subou = Ext.getCmp('yesdeleteSubOU').getValue()?"true":"false";

		if(val.length==0 && ((isMsp && allow_delete_org=='yes') || (!isMsp && Ext.getCmp('deleteSubOU').getValue().deleteSubOU=='yes')))
		{
			Ext.Msg.show ({
				title: deleteUseresSetTitle,
				msg: elementSelectionAlert,
				width: elementSelectionAlert.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
		}
		else if(delete_immediately == "false" && (delete_comps_after_x_days == null || delete_comps_after_x_days.length==0  || delete_comps_after_x_days<1 || delete_comps_after_x_days>measurement_cleanup_period))
		{
			Ext.Msg.show ({
				title: deleteUseresSetTitle,
				msg: comp_not_reporting_days_alert,
				width: comp_not_reporting_days_alert.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
		}
		else if(auto_delete_expired_users=="yes" && (delete_after_x_days == null || delete_after_x_days.length==0 || delete_after_x_days<1))
		{
			Ext.Msg.show ({
				title: deleteUseresSetTitle,
				msg: auto_delete_user_after_days_alert,
				width: auto_delete_user_after_days_alert.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
		}
		else
		{
			Ext.Ajax.request(
			{
				url : '/final/admin/ManagerSettings/data/deleteUsersJSONp.jsp?autoDelete='+auto_delete_expired_users+'&autoDeleteDays='+delete_after_x_days+'&delete_components='+delete_components+'&delete_agents='+delete_agents+'&delete_comps_after_x_days='+delete_comps_after_x_days+'&delete_immediately='+delete_immediately+'&selected_elements='+val+'&delete_org='+delete_org+'&delete_subou='+delete_subou+'&allowDeleteOrg='+allow_delete_org,
				scope:this,
				method : 'POST',
				success: function(response)
				{
					Ext.Msg.show({
						title: deleteUseresSetTitle,
						msg: result_message,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				}
			});
		}
	}


	//TT Filter ends here


});

function loadTree()
{
	var urlForArcheiveName = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp";
	var deleteAcmeFile = '';
	var classFileName=Ext.getCmp('uploadLabel').text;
	
	if (Ext.isEmpty(fileName))
	{
		if(classFileName.indexOf(".class")>-1){
			deleteAcmeFile = ttDeleteAcmeFile + ' ' + classFileName + '?';
		}else{
			deleteAcmeFile = ttDeleteAcmeFile + ' ' + jarFile + '?';
		}
	}
	else
	{
		deleteAcmeFile = ttDeleteAcmeFile + ' ' + jarFile + '?';
	}

	Ext.MessageBox.confirm(ttIntegration,deleteAcmeFile, function(id) {
		if (id == 'yes')
		{
			Ext.Ajax.request(
			{
				url : urlForArcheiveName,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var fileNameIn = jsonData.ArchieveFile;

					var url = '/final/admin/ManagerSettings/data/uploadWrapperJSONp.jsp?action=remove&ArchieveFile=None&file='+fileNameIn+'&cacheCur='+new Date().getTime();

					Ext.Ajax.request(
					{
						url : url,
						scope:this,
						method : 'POST',
						success: function(response){
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);

							//Ext.getCmp('archiveUpload').hide();
							fileName = 'None';
							ttWrapper = 'None';
							isAcmeUploaded = 'no';
							Ext.getCmp('nottWrapperClassNeeded').setValue(true);
							Ext.getCmp('uploadFile').setDisabled(true);
						}
					}
					);
				}
			});
		}
	});
}

function removeTTSys()
{
	var urlForRemove = '/final/admin/ManagerSettings/data/managerSettingsJSONp.jsp?action=removeTTIntegrationConfiguration'+'&TT_sys='+TTSysForRemove;

	Ext.MessageBox.confirm(ttIntegration,ttDeleteConfiguration, function(id) {
							if (id == 'yes')
							{
								Ext.Ajax.request(
								{
									url : urlForRemove,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);

										Ext.Msg.show({
											title: ttIntegration,
											msg: ttDeletedSuccess,
											width: 300,
											buttons: Ext.Msg.OK,
											icon: 'iconInformation'
										});

										Ext.getCmp('innerPanel').setTitle('TT MANAGER');

										var allowedAlarmsToSet = '';

										var yesEnableExecForTTObj = Ext.getCmp('yesEnableExecForTT');
										var noEnableExecForTTObj = Ext.getCmp('noEnableExecForTT');

										var command2Obj = Ext.getCmp('Command2');
										var commandObj = Ext.getCmp('Command');
										var allowedAlarmsCObj = Ext.getCmp('AllowedAlarmsC');
										var allowedAlarmsMObj = Ext.getCmp('AllowedAlarmsM');

										var allowedAlarmsMiObj = Ext.getCmp('AllowedAlarmsMi');
										var allowedAlarmsNObj = Ext.getCmp('AllowedAlarmsN');
										var logFileMaxSizeObj = Ext.getCmp('LogFileMaxSize');

										var yesLogEntriesForStdoutAlsoObj = Ext.getCmp('yesLogEntriesForStdoutAlso');
										var noLogEntriesForStdoutAlsoObj = Ext.getCmp('noLogEntriesForStdoutAlso');
										var aDateFormatObj = Ext.getCmp('DateFormat');

										var commandLengthObj = Ext.getCmp('CommandLength');
										var probDescLengthObj = Ext.getCmp('ProbDescLength');
										var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
										var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

										var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
										/*var ttNameObj = Ext.getCmp('TT_Other');
										var ttUrlObj = Ext.getCmp('TT_Url');
										var ttUserNameObj = Ext.getCmp('TT_User_Name');
										var ttPasswordObj = Ext.getCmp('TT_Password');

										var ttOutputObj = Ext.getCmp('TT_Output');*/
										var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
										var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
										//var ttApiKeyObj = Ext.getCmp('TT_Api_Key');

										var ttAllowedAlarmsCObj = Ext.getCmp('criticalAlarms');
										var ttAllowedAlarmsMObj = Ext.getCmp('majorAlarms');
										var ttAllowedAlarmsMiObj = Ext.getCmp('minorAlarms');
										var ttAllowedAlarmsNObj = Ext.getCmp('normalAlarms');

										var isCritical = '';
										var isMajor = '';
										var isMinor = '';
										var isNormal = '';

										var url = "/final/admin/ManagerSettings/data/managerSettingsJSON.jsp?selectSysName=OTHERS&index=ttmanager";

										Ext.Ajax.request(
											{
												url : url,
												scope:this,
												method : 'POST',
												success: function(response){
													var jsonText = response.responseText;
													var jsonData = Ext.decode(jsonText);

													var enableExecForTTValue = jsonData.enableExecForTT;
													var commandValue = jsonData.command;
													//alarmsArray
													var allowedAlarmsArrayLength = jsonData.alarmsArray.length;
													var logEntriesForStdoutAlsoValue = jsonData.enableLogging;
													var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
													var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;
													var criticalAlarmsChecked = jsonData.criticalAlarms;
													var majorAlarmsChecked = jsonData.majorAlarms;
													var minorAlarmsChecked = jsonData.minorAlarms;
													var normalAlarmsChecked = jsonData.normalAlarms;

													archeiveFile = jsonData.ArchieveFile;
													var labelTxt = '<b>' + archeiveFile + '</b>';

													if (Ext.isEmpty(archeiveFile) || archeiveFile == '')
													{
														Ext.getCmp('uploadLabel').hide();
														Ext.getCmp('removeLink').hide();
													}
													else
													{
														Ext.getCmp('uploadLabel').show();
														Ext.getCmp('removeLink').show();
													}

													if (enableExecForTTValue == 'Yes' || enableExecForTTValue == 'yes')
													{
														yesEnableExecForTTObj.setValue('Yes');
													}
													else
													{
														yesEnableExecForTTObj.setValue('No');
													}

													command2Obj.setValue(jsonData.command);
													commandObj.setValue(jsonData.execOutFormat);

													for (var i=0; i<allowedAlarmsArrayLength; i++)
													{
														var allowedAlarmsValue = jsonData.alarmsArray[i].alarms;

														if (allowedAlarmsValue == 'critical')
														{
															isCritical = 'true';
														}
														if (allowedAlarmsValue == 'major')
														{
															isMajor = 'true';
														}
														if (allowedAlarmsValue == 'minor')
														{
															isMinor = 'true';
														}
														if (allowedAlarmsValue == 'normal')
														{
															isNormal = 'true';
														}
													}
													if (isCritical == 'true')
													{
														allowedAlarmsCObj.setValue(true);
													}
													else
													{
														allowedAlarmsCObj.setValue(false);
													}
													if (isMajor == 'true')
													{
														allowedAlarmsMObj.setValue(true);
													}
													else
													{
														allowedAlarmsMObj.setValue(false);
													}
													if (isMinor == 'true')
													{
														allowedAlarmsMiObj.setValue(true);
													}
													else
													{
														allowedAlarmsMiObj.setValue(false);
													}
													if (isNormal == 'true')
													{
														allowedAlarmsNObj.setValue(true);
													}
													else
													{
														allowedAlarmsNObj.setValue(false);
													}

													logFileMaxSizeObj.setValue(jsonData.logFileMaxSize);

													if (logEntriesForStdoutAlsoValue == 'Yes')
													{
														yesLogEntriesForStdoutAlsoObj.setValue(true);
													}
													else
													{
														noLogEntriesForStdoutAlsoObj.setValue(true);
													}

													aDateFormatObj.getStore().loadRawData(jsonData.formatForDateArray);
													aDateFormatObj.setValue(jsonData.dateFormat);

													commandLengthObj.setValue(jsonData.commandLength);
													probDescLengthObj.setValue(jsonData.probDescLength);

													if (TTIntegrationEnableValue == 'Yes' || TTIntegrationEnableValue == 'yes')
													{
														ttIntegrationEnableObj.setValue(true);
													}
													else
													{
														ttIntegrationDisableObj.setValue(true);
													}

													if (ttIntegrationEnableObj.getValue())
													{
														Ext.getCmp('integrationSystem').show();
														/*Ext.getCmp('TT_Other').show();
														Ext.getCmp('TT_Url').show();
														Ext.getCmp('TT_User_Name').show();
														Ext.getCmp('TT_Password').show();

														Ext.getCmp('TT_Output').show();*/
														Ext.getCmp('integrationSystemc').removeAll();
														Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
														Ext.getCmp('integrationSystemc').doLayout();
														//Ext.getCmp('wrapperClassNeeded').show();
														//Ext.getCmp('archiveUpload').show();
														//Ext.getCmp('TT_Api_Key').show();

														//Ext.getCmp('TT_Output').show();
														//Ext.getCmp('wrapperClassNeeded').show();
														//Ext.getCmp('TT_Api_Key').show();

														Ext.getCmp('allowedAlarms').show();
													}

													if (ttIntegrationDisableObj.getValue())
													{
														Ext.getCmp('integrationSystem').hide();
														/*Ext.getCmp('TT_Other').hide();
														Ext.getCmp('TT_Url').hide();
														Ext.getCmp('TT_User_Name').hide();
														Ext.getCmp('TT_Password').hide();*/

														//Ext.getCmp('TT_Output').hide();
														Ext.getCmp('integrationSystemc').removeAll();
														//Ext.getCmp('wrapperClassNeeded').hide();
														//Ext.getCmp('archiveUpload').hide();
														//Ext.getCmp('TT_Api_Key').hide();

														//Ext.getCmp('TT_Output').hide();
														//Ext.getCmp('wrapperClassNeeded').hide();
														//Ext.getCmp('TT_Api_Key').hide();

														Ext.getCmp('allowedAlarms').hide();
													}

													ttIntegrationSystemObj.getStore().loadRawData(jsonData.ttIntegrationSystemArray);
													ttIntegrationSystemObj.setValue(jsonData.TTSys);

													var ttIntegrationSystem = jsonData.ttIntegrationSystemArray[0].displayField;

													var TTSys = jsonData.TTSys;
													TTSysForRemove = TTSys;

													var nameInOthersEngine = jsonData.TTOtherDispName;

													if (TTSys != 'OTHERS')
													{
														//Ext.getCmp('TT_Other').hide();
														Ext.getCmp('removeBtn').show();
													}
													else
													{
														//Ext.getCmp('TT_Other').show();
														//Ext.getCmp('TT_Other').setValue(nameInOthersEngine);
														Ext.getCmp('removeBtn').hide();
													}

													//ttUrlObj.setValue(jsonData.TTUrl);
													//ttUserNameObj.setValue(jsonData.TTUsername);
													//ttPasswordObj.setValue(jsonData.TTPassword);
													//ttOutputObj.setValue(jsonData.TTOutput);

													if (isUploadArchieveEnable == 'block')
													{
														yesttWrapperClassNeededObj.setValue(true);
													}
													else
													{
														nottWrapperClassNeededObj.setValue(true);
													}

													//ttApiKeyObj.setValue(jsonData.TTApiKey);

													ttAllowedAlarmsCObj.setValue(true);
													if (majorAlarmsChecked == 'checked')
													{
														ttAllowedAlarmsMObj.setValue(true);
													}
													else
													{
														ttAllowedAlarmsMObj.setValue(false);
													}
													if (minorAlarmsChecked == 'checked')
													{
														ttAllowedAlarmsMiObj.setValue(true);
													}
													else
													{
														ttAllowedAlarmsMiObj.setValue(false);
													}
													if (normalAlarmsChecked == 'checked')
													{
														ttAllowedAlarmsNObj.setValue(true);
													}
													else
													{
														ttAllowedAlarmsNObj.setValue(false);
													}
												}
											}
										);
									}
								});
							}
						},this);
}

function isAValidNumber(val)
{
	validFigures = '0123456789';
	if(val.length > 1 && val.indexOf('0')==0)
		return "false";
	if(val.length==0)
		return "false";
	for (i=0; i<val.length; i++)
	{
		if (validFigures.indexOf(val.charAt(i),0) == -1) 
		{
			return "false";
		}
	}
	return "true";
}

function validateTextBoxes(str,mgrField,value)
{
	var strValue = str;
	var res = "true";
	var temp="";
	if(strValue == "" || strValue == "general")
	{
		if(mgrField == 'trendComp' && isAValidNumber(value) == "false")
		{	
			res="false";
		}
		if(mgrField == 'threshComp' && isAValidNumber(value)=="false")
		{	
			res="false";
			return res;
		}
		if(mgrField == 'freqThresh' && isAValidNumber(value)=="false")
		{	
			res="false";
			return res;
		}
		if(mgrField == 'dataPeriod' && isAValidNumber(value)=="false")
		{	
			res="false";
			return res;
		}		
	}
	else if (strValue == "commandexecution")
	{
		if (mgrField == 'logMaxSize' && isAValidNumber(value) == "false")
		{
			res = 'false';
		}
		else if (mgrField == 'commandLength' && isAValidNumber(value) == "false")
		{
			res = 'false';
		}
	}

	return res;
}

function createHiddenfield(filter)
{
	var hiddenfield ={
			xtype: 'hidden',
				margin:'0 0 0 0',
				cls: 'x-hidden',
			name: '$_'+filter.id,
			id: '$_'+filter.id,
	}
	return hiddenfield;
}
function createTextfield(filter)
{
	var Textfield ={
			xtype: 'textfield',
			name: filter.id,
			id: filter.id,
			value:filter.selectedValue,
			fieldLabel:filter.lable,
			cls:'textbox',
}
	if(filter.id=="password" || filter.id=='proxyPassword')
	{
		Textfield.inputType="password";
	}
	return Textfield;
}
function createTextareafield(filter)
{
	var textString = new String(filter.selectedValue)
	textString = filter.selectedValue.toString();

	var selectedValue = "";
	if(typeof filter.selectedValue == 'object')
	{
		//console.log('inside typeof filter.selectedValue == object');
		selectedValue = JSON.stringify(filter.selectedValue, null, '\t');//for playload option
		//selectedValue = JSON.stringify(filter.selectedValue);
	} else
	{
		selectedValue = filter.selectedValue;
	}
	
	var Textareafield = {
			xtype: 'textarea',
			name: filter.id,
			id: filter.id,
			value:selectedValue,
			fieldLabel:filter.lable,
			cls:'text-area'
		}
	return Textareafield;
}
function createCombo(filter)
{
	var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','name'],
			proxy:{
				type: 'memory',
				reader: {
	            	type: 'json',
	            	root:'options'
	        	}
			},
			data:filter
		});
	var Combo ={
			xtype:'scrollcombo',
					editable : false,
					store:comboStore,
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					trigerAction:'all',
					fieldLabel:filter.lable,
					value:filter.selectedValue,
					itemId:filter.id,
					queryMode:'local',
					id:filter.id,
					name:filter.id,
	}
	return Combo;
}
function createRadioButton(filter)
{
	var noRadioBtn = filter.checked ? false : true
	var radioButton = {
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: filter.lable,
					columns: 2,
					vertical: false,
					id: filter.id+'_radioGrp',
					items: [
							{
								boxLabel: yesRadioOption,
								name: filter.id,
								inputValue:'yes',
								id: filter.id,
								checked:filter.checked,
								listeners: {
									click: {
										element: 'el',
										fn: function (id)
										{
											Ext.getCmp(filter.id+'_2').setValue(false);
											Ext.getCmp(filter.id).setValue(true);
											thisController.changeRadioField(filter.yesCtrlFields, true);
										}
									}
								}
							},
							{
								boxLabel: noRadioOption,
								name: filter.id,
								inputValue:'no',
								id: filter.id+'_2',
								checked: noRadioBtn,
								listeners: {
									afterrender:function (checked)
										{
											if(this.checked){
												thisController.changeRadioField(filter.noCtrlFields, false);
											}
										},
									click: {
										element: 'el',
										fn: function (id)
										{
											Ext.getCmp(filter.id).setValue(false);
											Ext.getCmp(filter.id+'_2').setValue(true);
											var getv= Ext.getCmp(filter.id).getValue();
											thisController.changeRadioField(filter.noCtrlFields, false);
										}
									}
								}
							}
						]
					}
return radioButton;
}
function createFilters(jsonData){
	var itemsArray=new Array();
	for(var i=0;i<jsonData.filters.length;i++)
		{
			var filter=jsonData.filters[i];
			var item = this.createFilterItem(filter);
			var hiddenItem = this.createHiddenfield(filter);
			
			if(!Ext.isEmpty(item)){
				itemsArray.push(item);
				itemsArray.push(hiddenItem);
			}
		}
		return itemsArray;
	}
	

function createFilterItem(filter){
	var item=null;
	switch(filter.type){
		case "Textfield":   item=this.createTextfield(filter);
						break;
		case "Combo": 	item=this.createCombo(filter);
						break;
		case "TextArea": item=this.createTextareafield(filter);
						break;
		case "radioButton": item=this.createRadioButton(filter);
						break;
	}
	return item;
}

function trim(stringToTrim) {
	return stringToTrim.replace(/^\s+|\s+$/g,"");
}

function loadIntegrationPage(integrationType, integrationName, record)
{
	var mainViewIdObj = Ext.getCmp('mainViewId');
	var innerMainPanelObj = Ext.getCmp('innerPanel');
	Ext.getCmp('innerPanel').setTitle(ttListPageTitle);
	Ext.getCmp('TTlistviewID').hide();

	if (integrationName == 'Settings')//Common Settings
	{
		innerMainPanelObj.add({
			xtype: 'ttcommonsettings',
			
			title:'<span style="display:inline-block; vertical-align:middle;"><img src="../images/clear.png" class="'+record.data['iconClsName']+'_white" /></span><span style="display:inline-block; vertical-align:middle;"><span style="display:inline-block;font-size:15px;">'+record.data['displayName']+'</span></span>',
			header: {
				height: 60,
			}
		});

		var allowedAlarmsCObj = Ext.getCmp('AllowedAlarmsC');
		var allowedAlarmsMObj = Ext.getCmp('AllowedAlarmsM');
		var allowedAlarmsMiObj = Ext.getCmp('AllowedAlarmsMi');
		//var allowedAlarmsNObj = Ext.getCmp('AllowedAlarmsN');

		var logFileMaxSizeObj = Ext.getCmp('LogFileMaxSize');
		var logMaxFilesObj = Ext.getCmp('logMaxFiles');
		var enableGraphObj = Ext.getCmp('enableGraph');
		var yesLogEntriesForStdoutAlsoObj = Ext.getCmp('yesLogEntriesForStdoutAlso');
		//var noLogEntriesForStdoutAlsoObj = Ext.getCmp('noLogEntriesForStdoutAlso');

		var yesEnableDDObj = Ext.getCmp('yesEnableDD');
		//var noEnableDDObj = Ext.getCmp('noEnableDD');
		var enableTTFilterObj = Ext.getCmp('enableTTFilter');

		var yesEnableTTFilterObj = Ext.getCmp('yesEnableTTFilter');
		var noEnableTTFilterObj = Ext.getCmp('noEnableTTFilter');

		var isCritical = '';
		var isMajor = '';
		var isMinor = '';
		var isNormal = '';

		var url = "/final/admin/ManagerSettings/data/commonSettingsTTI_JSON.jsp";
		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var sendNormailMail = jsonData.sendNormailMail;
				if (!Ext.isEmpty(sendNormailMail) && sendNormailMail.toLowerCase() == 'yes')
				{
					Ext.getCmp('yesSendNormalMail').setValue(true);
					//Ext.getCmp('yesSendNormalMail').checked;
				}
				/**else
				{
					//Ext.getCmp('yesSendNormalMail').setValue(false);
				}**/

				//alarmsArray
				var allowedAlarmsArrayLength = jsonData.alarmsArray.length;
				for (var i = 0; i < allowedAlarmsArrayLength; i++)
				{
					var allowedAlarmsValue = jsonData.alarmsArray[i].alarms;
					if (allowedAlarmsValue.toLowerCase() == 'critical')
					{
						isCritical = 'true';
					}
					if (allowedAlarmsValue.toLowerCase() == 'major')
					{
						isMajor = 'true';
					}
					if (allowedAlarmsValue.toLowerCase() == 'minor')
					{
						isMinor = 'true';
					}
					if (allowedAlarmsValue.toLowerCase() == 'normal')
					{
						isNormal = 'true';
					}
				}
				if (isCritical == 'true')
				{
					allowedAlarmsCObj.setValue(true);
				}
				else
				{
					allowedAlarmsCObj.setValue(false);
				}
				if (isMajor == 'true')
				{
					allowedAlarmsMObj.setValue(true);
				}
				else
				{
					allowedAlarmsMObj.setValue(false);
				}
				if (isMinor == 'true')
				{
					allowedAlarmsMiObj.setValue(true);
				}
				else
				{
					allowedAlarmsMiObj.setValue(false);
				}
				/**
				if (isNormal == 'true')
				{
				allowedAlarmsNObj.setValue(true);
				}
				else
				{
				allowedAlarmsNObj.setValue(false);
				}
				**/
				var enableDDStr = jsonData.enableDDStr;
				if (!Ext.isEmpty(enableDDStr) && enableDDStr.toLowerCase() == 'yes')
				{
					yesEnableDDObj.setValue(true);
				}
				/*else
				{
					noEnableDDObj.setValue(true);
				}**/

				var logEntriesForStdoutAlsoValue = jsonData.enableLogging;
				var enableGraphValue = jsonData.enableGraph;
				if (logEntriesForStdoutAlsoValue == 'Yes')
				{
					yesLogEntriesForStdoutAlsoObj.setValue(true);
				}
				if (!Ext.isEmpty(enableGraphValue) && enableGraphValue.toLowerCase() == 'yes')
				{
					enableGraphObj.setValue(true);
				}
				/**else
				{
					noLogEntriesForStdoutAlsoObj.setValue(true);
				}**/

				logFileMaxSizeObj.setValue(jsonData.logFileMaxSize);
				logMaxFilesObj.setValue(jsonData.logMaxFiles);


				var enableTTFilterValue = jsonData.enableTTFilter;
				if (!Ext.isEmpty(enableTTFilterValue) && enableTTFilterValue.toLowerCase() == 'yes')
				{
					yesEnableTTFilterObj.setValue(true);
					//filterOptionContainer

					thisController.loadTTFilterOption();
				}
				else
				{
					noEnableTTFilterObj.setValue(true);
				}
			}
		});
		/**
			Ext.Ajax.request({
				url: 'ManagerSettings/data/egttcommonsettingshelp.jsp?',
				method: 'POST',
			});
		**/
	}
	else if (integrationType == 'Mail')
	{
		innerMainPanelObj.add({ 
			xtype: 'ttmanagermailsnmp',
				title:'<span style="display:inline-block; vertical-align:middle; "><img src="../images/clear.png" class="'+record.data['iconClsName']+'_white" /></span><span style="display:inline-block; vertical-align:middle;"><span style="display:inline-block; font-size:15px;">'+record.data['displayName']+'</span><span style="display:block;font-size:12px;">'+record.data['tagline']+'</span></span>',
				header : {
					height: 60,
				}

			});

		var ttMailEnableObj = Ext.getCmp('TTMailEnable');
		var ttMailDisableObj = Ext.getCmp('TTMailDisable');


		var yesIncludeAllCompUserObj = Ext.getCmp('yesIncludeAllCompUser');
		var noIncludeAllCompUserObj = Ext.getCmp('noIncludeAllCompUser');

		var yesUseUniqueIdObj = Ext.getCmp('yesUseUniqueId');
		var noUseUniqueIdObj = Ext.getCmp('noUseUniqueId');

		var yesPriorityAsNumericObj = Ext.getCmp('yesPriorityAsNumeric');
		var noPriorityAsNumericObj = Ext.getCmp('noPriorityAsNumeric');

		var yesApplyPriorityForAllTTMailsObj = Ext.getCmp('yesApplyPriorityForAllTTMails');
		var noApplyPriorityForAllTTMailsObj = Ext.getCmp('noApplyPriorityForAllTTMails');

		var url = "/final/admin/ManagerSettings/data/mailSnmpTTI_JSON.jsp?integrationType=" + integrationType;

		Ext.Ajax.request({
			url: url,
			scope:this,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var strEnableMail = jsonData.strEnableMail;

				if (!Ext.isEmpty(strEnableMail) && strEnableMail.toLowerCase() == 'yes')
				{
					ttMailEnableObj.setValue(true);
				}
				/**else
				{
					ttMailDisableObj.setValue(true);
				}**/

				Ext.getCmp('mailSettings').show();
			//	Ext.getCmp('mailSettings').setDisabled(true);;
			
				
				Ext.getCmp('MailSubject').setDisabled(false);
				Ext.getCmp('MailTo').setDisabled(false);
				Ext.getCmp('OutputFormat').setDisabled(false);
				//Ext.getCmp('yesIncludeAllCompUser').setDisabled(true);

				var mailSubjectVal = jsonData.mailSubject;
				var mailToVal = jsonData.mailTo;
				var outputFormatVal = jsonData.outputFormat;
				var includeAllCompUserVal = jsonData.includeAllCompUser;
				var useUniqueIdVal = jsonData.useUniqueId;
				var priorityAsNumericVal = jsonData.priorityAsNumeric;
				var applyPriorityForAllTTMailsVal = jsonData.applyPriorityForAllTTMails;


				if (!Ext.isEmpty(mailSubjectVal))
				{
					Ext.getCmp('MailSubject').setValue(mailSubjectVal);
				}
				
				if (!Ext.isEmpty(mailToVal))
				{
					Ext.getCmp('MailTo').setValue(mailToVal);
				}
				if (!Ext.isEmpty(outputFormatVal))
				{
					Ext.getCmp('OutputFormat').setValue(outputFormatVal);
				}
				
				if (includeAllCompUserVal)
				{
					yesIncludeAllCompUserObj.setValue(true);
				}
				/**else
				{
					noIncludeAllCompUserObj.setValue(true);
				}**/

				if (useUniqueIdVal)
				{
					yesUseUniqueIdObj.setValue(true);
				}
				/**else
				{
					noUseUniqueIdObj.setValue(true);
				}**/
				
				if (priorityAsNumericVal)
				{
					yesPriorityAsNumericObj.setValue(true);
				}
				/**else
				{
					noPriorityAsNumericObj.setValue(true);
				}**/
				
				if (applyPriorityForAllTTMailsVal)
				{
					yesApplyPriorityForAllTTMailsObj.setValue(true);
				}
			}
		});
	} else if (integrationType == 'SNMP')
	{
		innerMainPanelObj.add({ 
			xtype: 'ttmanagersnmp',
			title:'<span style="display:inline-block; vertical-align:middle;"><img src="../images/clear.png" class="' + record.data['iconClsName'] + '_white" /></span><span style="display:inline-block; vertical-align:middle;"><span style="display:inline-block;font-size:15px;">'+record.data['displayName'] + '</span><span style="display:block;font-size:12px;">' + record.data['tagline'] + '</span></span>',
			header : {
				height: 60,
			}
		});

		var yesEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('yesEnableTTIntegrationForSNMPTraps');
	//	var noEnableTTIntegrationForSNMPTrapsObj = Ext.getCmp('noEnableTTIntegrationForSNMPTraps');

		var url = "/final/admin/ManagerSettings/data/mailSnmpTTI_JSON.jsp?integrationType=" + integrationType;

		Ext.Ajax.request({
			url: url,
			scope:this,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var enableTTIntegrationForSNMPTrapsVal = jsonData.enableTTIntegrationForSNMPTraps;
				if (enableTTIntegrationForSNMPTrapsVal)
				{
					yesEnableTTIntegrationForSNMPTrapsObj.setValue(true);
				}
				/**else
				{
					noEnableTTIntegrationForSNMPTrapsObj.setValue(true);
				}**/
			}
		});
	} else if (integrationType == 'CLI')
	{
			innerMainPanelObj.add({
				xtype: 'ttmanagercli',
					title:'<span style="display:inline-block; vertical-align:middle;"><img src="../images/clear.png" class="' + record.data['iconClsName'] + '_white" /></span><span style="display:inline-block; vertical-align:middle;"><span style="display:inline-block;font-size:15px;">'+record.data['displayName'] + '</span><span style="display:block;font-size:12px;">' + record.data['tagline'] + '</span></span>',
					header : {
						height: 60,
					}
			});

			//Ext.getCmp('innerPanel').setTitle('TROUBLE TICKET INTEGRATION');

			var yesEnableExecForTTObj = Ext.getCmp('yesEnableExecForTT');
			//var noEnableExecForTTObj = Ext.getCmp('noEnableExecForTT');
			var command2Obj = Ext.getCmp('Command2');
			var commandObj = Ext.getCmp('Command');
			var aDateFormatObj = Ext.getCmp('DateFormat');
			var commandLengthObj = Ext.getCmp('CommandLength');
			var probDescLengthObj = Ext.getCmp('ProbDescLength');

			var url = "/final/admin/ManagerSettings/data/cliTTI_JSON.jsp";
			Ext.Ajax.request({
				url: url,
				scope:this,
				method: 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var enableExecForTTValue = jsonData.enableExecForTT;
					var commandValue = jsonData.command;
					//console.log('enableExecForTTValue--->' + enableExecForTTValue);
					if (enableExecForTTValue == 'Yes')
					{
						yesEnableExecForTTObj.setValue(true);
					}
					else
					{
						yesEnableExecForTTObj.setValue(false);
					}

					command2Obj.setValue(jsonData.command);
					commandObj.setValue(jsonData.execOutFormat);

					aDateFormatObj.getStore().loadRawData(jsonData.formatForDateArray);
					aDateFormatObj.setValue(jsonData.dateFormat);

					commandLengthObj.setValue(jsonData.commandLength);
					probDescLengthObj.setValue(jsonData.probDescLength);
				}
		});
	}else if (integrationType == 'Web_Services')
	{
		innerMainPanelObj.add({ 
			xtype: 'ttmanagerwebservice',
			listeners:{
				afterrender:function(){
							Ext.create('utilities.Toggleswitch',{
							id:'TTIntegrationEnable',
							renderTo:'header_checkbox_holder',
							listeners : {
								change: function(){
										var checked = Ext.getCmp('TTIntegrationEnable').getValue();
										if(checked) {
											Ext.get('TTIntegrationEnable').set({
												'data-qtip': disablewebservTooltipMsg
											});
										} else{
											Ext.get('TTIntegrationEnable').set({
												'data-qtip': enablewebservTooltipMsg
											});
										}
									}
								},
							})
				},
				close: function() {
						thisController.reloadIntegrationPage();
				}
			},
			id: 'ttmanagerwebserviceID',
			integrationNames:integrationName,
			title:'<span style="display:inline-block; vertical-align:middle;"><img src="../images/clear.png" class="' + record.data['iconClsName'] + '_white" /></span><span style="display:inline-block; vertical-align:middle;"><span style="display:inline-block;font-size:15px;">'+record.data['displayName'] + '</span><div id="header_checkbox_holder" data-qtip="" class="listviewpop" style="position:absolute; display:inline-block; top:6px; margin-left:-5px;"></div><span style="display:block;font-size:12px;">' + record.data['tagline'] + '</span></span>',
			header : {
				height: 60,
			}
		});

		//Ext.getCmp('innerPanel').setTitle('TROUBLE TICKET INTEGRATION');

		isAcmeUploaded = 'no';
		var ttIntegrationEnableObj = Ext.getCmp('TTIntegrationEnable');
		var ttIntegrationDisableObj = Ext.getCmp('TTIntegrationDisable');

		var ttIntegrationSystemObj = Ext.getCmp('TT_sys');
		var ttNameObj = Ext.getCmp('TT_Other');
		var ttUrlObj = Ext.getCmp('TT_Url');
		var ttUserNameObj = Ext.getCmp('TT_User_Name');
		var ttPasswordObj = Ext.getCmp('TT_Password');

		var ttOutputObj = Ext.getCmp('TT_Output');
		var ttApiKeyObj = Ext.getCmp('TT_Api_Key');
		var yesttWrapperClassNeededObj = Ext.getCmp('yesttWrapperClassNeeded');
		var nottWrapperClassNeededObj = Ext.getCmp('nottWrapperClassNeeded');
		
		selectedIntegrationName = integrationName; // assigned integration name to global var
		var url = "/final/admin/ManagerSettings/data/webServicesTTI_JSON.jsp?selectSysName=" + integrationName;
		Ext.Ajax.request({
			url: url,
			scope:this,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var TTIntegrationEnableValue = jsonData.TTIntegrationEnable;
				var isUploadArchieveEnable = jsonData.displayTTIntegrationArchive;
				var enabledTTSystem = jsonData.OldTTSys;

				if (TTIntegrationEnableValue.toLowerCase() =='yes' || TTIntegrationEnableValue.toLowerCase() == 'true')
				{
					ttIntegrationEnableObj.setValue(true);
				}
				else
				{
					ttIntegrationEnableObj.setValue(false);
				}

				if (!Ext.isEmpty(enabledTTSystem) && enabledTTSystem != integrationName)
				{
					ttIntegrationEnableObj.setValue(false);
				}

				var TTSys = jsonData.TTSys;
				TTSysForRemove = TTSys;

				var filtersDataVal = createFilters(jsonData);
				//console.log('filtersDataVal---> ',filtersDataVal);

				var total_len = filtersDataVal.length;
				//console.log('Total length-->',total_len);

				var half_len = filtersDataVal.length / 2;
			//	console.log('Half length-->',half_len);

				var left_side = filtersDataVal.splice(0,half_len);
			//	console.log('Left Side-->',left_side);

				Ext.suspendLayouts();
				//Ext.getCmp('integrationSystem').show();
				Ext.getCmp('integrationSystemc').removeAll();
				//Ext.getCmp('integrationSystemc').add(createFilters(jsonData));
				Ext.getCmp('integrationSystemc').add(left_side);
				Ext.getCmp('integrationSystemc').doLayout();

				Ext.getCmp('integrationSystemc_2').removeAll();
				Ext.getCmp('integrationSystemc_2').add(filtersDataVal);
				Ext.getCmp('integrationSystemc_2').doLayout();

				Ext.resumeLayouts(true);

				if (isUploadArchieveEnable == 'block' && Ext.isEmpty(jsonData.TTWrapper))
				{
					yesttWrapperClassNeededObj.setValue(true);
				}
				else
				{
					nottWrapperClassNeededObj.setValue(true);
				}
			}
		});

		Ext.Ajax.request({
			url: 'ManagerSettings/data/uploadWrapperJSONp.jsp?',
			method: 'POST',
		});
	}
}

function addMultiIPPolicy()
{
	var mainForm = Ext.getCmp('egippolicy');
	var backupmulticontainer = Ext.getCmp('backupmultiipcontainer');
	var conIdIP = "conIP_"+inputs
	var tmpMultiContainer = {
		xtype: 'container',
		id: conIdIP,
		layout: 'column',
		margin: 2,
		defaults: {
			labelSeparator: ' '
		},
		items: [
			{
				xtype: 'textfield',
				cls: 'textbox',
				style:{'white-space':'nowrap'},
				id:'ip'+inputs,
				emptyText: 'IP range/IP address/IP address pattern',
				columnWidth: 0.93,
				margin: '5 0 5 5'
			},
			{
				xtype : 'button',
				iconCls : 'img_removeShift',
				tooltip : '<b>Remove</b>',
				style : {
					background : 'none',
					border : '0px'
				},
				handler: function()
				{
					removeMultiIP(conIdIP);
				},
				columnWidth: 0.07,
				margin: '8 0 5 0'
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();

	Ext.getCmp('addMultiIP').setText(addMorePolicyMsg);
	Ext.getCmp('updateMultiIP').enable();
	Ext.getCmp('NoMultiIPPattern').hide();
	Ext.getCmp('adminPolicyLabel').setVisible(true);
	inputs++;
}

function removeMultiIP(containerID)
{
	var backupcontainer = Ext.getCmp('backupmultiipcontainer');
	backupcontainer.remove(containerID);
	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		inputs = 1;
		Ext.getCmp('NoMultiIPPattern').show();
		Ext.getCmp('updateMultiIP').disable();
		Ext.getCmp('clearMultiIP').disable();
		Ext.getCmp('addMultiIP').setText(addPolicyMsg);
		Ext.getCmp('adminPolicyLabel').setVisible(false);
	}
}
function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
}
function showTests(selected_testfor)
{
	if(selected_testfor=='yes')
	{
		
		Ext.getCmp('daysNotReportingContainer_auto').show();
		Ext.getCmp('daysId_auto').show();
		Ext.getCmp('daysAfter').show();
	}
	else
	{
		Ext.getCmp('daysNotReportingContainer_auto').hide();
		Ext.getCmp('daysId_auto').hide();
		Ext.getCmp('daysAfter').hide();
	}
}



