Ext.define('ManagerSettings.view.AdvancedSettings', {
	extend: 'Ext.form.Panel',
	alias: 'widget.advancedsettings',
	cls:'outerpanel',
	border: false,

	items:[
		{
			xtype: 'fieldset',
			title: '<b>' + advSetTitle + '</b>',
			id: 'generalPanelNotHidden',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 450,
				labelWidth: 200
			},
			margin: 20,
			items: [
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: advSetRestart,
					columns: 2,
					vertical: false,
					id: 'stlnMgrRestart',
					hidden: true,
					items: [
						{ boxLabel: yesRadioOption, name: 'stlnMgrRestart', inputValue: 'Yes', id: 'yesStlnMgrRestart',listeners: {
								click: {
									element: 'el',
									fn: function() 
									{
										thisController.radioRestartChange();
									}
								},
							},
						},
						{ boxLabel: noRadioOption, name: 'stlnMgrRestart', inputValue: 'No', checked: true,id: 'noStlnMgrRestart'}
					],
				},{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: 'Restart the primary manager',
					columns: 2,
					vertical: false,
					id: 'stlnMgrRestart_pri',
					hidden: true,
					items: [
						{ boxLabel: yesRadioOption, name: 'stlnMgrRestart_pri', inputValue: 'Yes', id: 'yesStlnMgrRestart_pri',listeners: {
								click: {
									element: 'el',
									fn: function() 
									{
										thisController.radioRestartChange_pri();
									}
								},
							},
						},
						{ boxLabel: noRadioOption, name: 'stlnMgrRestart_pri', inputValue: 'No', checked: true,id: 'noStlnMgrRestart_pri'}
					],
				},{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: 'Restart the secondary manager',
					columns: 2,
					vertical: false,
					id: 'stlnMgrRestart_sec',
					hidden: true,
					items: [
						{ boxLabel: yesRadioOption, name: 'stlnMgrRestart_sec', inputValue: 'Yes', id: 'yesStlnMgrRestart_sec',listeners: {
								click: {
									element: 'el',
									fn: function() 
									{
										thisController.radioRestartChange_sec();
									}
								},
							},
						},
						{ boxLabel: noRadioOption, name: 'stlnMgrRestart_sec', inputValue: 'No', checked: true,id: 'noStlnMgrRestart_sec'}
					],
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: advSetOutput,
					columns: 2,
					vertical: false,
					id: 'mgrOutput',
					items: [
						{ boxLabel: onRadioOption, name: 'mgrOutput', inputValue: 'Yes',  id: 'yesMgrOutput', listeners: {
								click: {
									element: 'el',
									fn: function() 
									{
										thisController.radioMgrOutChange();
									}
								},
							},},
						{ boxLabel: offRadioOption, name: 'mgrOutput', inputValue: 'No', id: 'noMgrOutput', listeners: {
								click: {
									element: 'el',
									fn: function() 
									{
										thisController.radioMgrOutDisableChange();
									}
								},
							},}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: advSetMode,
					columns: 2,
					vertical: false,
					id: 'mgrOutputOverWirte',
					items: [
						{ boxLabel: overWriteRadioOption, name: 'mgrOutputOverWirte', inputValue: 'Yes', id: 'yesMgrOutputOverWirte'},
						{ boxLabel: appendRadioOption, name: 'mgrOutputOverWirte', inputValue: 'No', id: 'noMgrOutputOverWirte'}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: advSetUpdFiles,
					columns: 2,
					vertical: false,
					id: 'manConfig',
					items: [
						{ boxLabel: yesRadioOption, name: 'manConfig', inputValue: 'yes', id: 'yesManConfig'},
						{ boxLabel: noRadioOption, name: 'manConfig', inputValue: 'no', id: 'noManConfig'}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: advSetAggregateComps,
					columns: 2,
					vertical: false,
					id: 'extAgent',
					hidden: true,
					items: [
						{ boxLabel: labelExternalAgent, name: 'extAgent', inputValue: 'yes', id: 'yesExtAgent'},
						{ boxLabel: labelRemoteAgent, name: 'extAgent', inputValue: 'no', id: 'noExtAgent'}
					]
				}
			]
		},
		{
			xtype: 'fieldset',
			id: 'generalPanel',
			hidden: true
		},
		{
			xtype: 'fieldset',
			id: 'display',
			margin: 20,
			hidden: true
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 20,
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: updateBtnText,
					id: 'advSetUpdateBtn',
					width: 80
				}
			]
		}
	]

});



