Ext.define('ManagerSettings.view.General', {
	extend: 'Ext.form.Panel',
	alias: 'widget.general',
	cls:'outerpanel',
	border: false,

	items:[
		{
			xtype: 'fieldset',
			title: '<b>' + gerneralTitle + '</b>',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 550,
				labelWidth: 330
			},
			margin: 20,
			items: [
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: generalComputeMetrics,
					columns: 2,
					vertical: false,
					items: [
						{ boxLabel: yesRadioOption, name: 'AvgSumTrends', inputValue: 'Yes', id: 'yesAvgSumTrends'},
						{ boxLabel: noRadioOption, name: 'AvgSumTrends', inputValue: 'No', id: 'noAvgSumTrends'}
					]
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: generalNoOfThreadsTrend,
					allowBlank: false,
					name: 'TrendMgrThreads',
					id: 'TrendMgrThreads'
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: generalNoOfThreadsThreshold,
					allowBlank: false,
					name: 'ThresholdMgrThreads',
					id: 'ThresholdMgrThreads'
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: generalThresholdFreq,
					allowBlank: false,
					name: 'ThresholdRunDuration',
					id: 'ThresholdRunDuration'
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: generalDataPeriod,
					allowBlank: false,
					name: 'ThresholdAdjustPeriod',
					id: 'ThresholdAdjustPeriod'
				},
				{
					xtype: 'fieldcontainer',
					fieldLabel: generalThresholdHours,
					layout: 'column',
					columnWidth: 1,
					name: 'RelativeThresholdHoursFld',
					id: 'RelativeThresholdHoursFld',
					items: [
						{
							xtype: 'timefield',
							cls:'dropdown',
							emptyText: 'From',
							minValue: '00:00',
							maxValue: '23:59',
							format: 'H:i',
							increment: 1,
							listConfig: {maxHeight: 150},
							hideTrigger: false,
							columnWidth: 0.5,
							id: 'timeFrom',
							editable: false
						},
						{
							xtype: 'timefield',
							cls:'dropdown',
							emptyText: 'To',
							minValue: '00:00',
							maxValue: '24:00',
							format: 'H:i',
							increment: 1,
							listConfig: {maxHeight: 150},
							hideTrigger: false,
							columnWidth: 0.5,
							margin: '0 0 0 10',
							id: 'timeTo',
							editable: false
						}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: generalAutoMappIpToName,
					columns: 2,
					vertical: false,
					id:'AutoIpNameCheckID',
					disabled: isMsp,
					items: [
						{ boxLabel: 'Yes', name: 'AutoIpNameCheck', inputValue: 'Yes', id: 'yesAutoIpNameCheck'},
						{ boxLabel: 'No', name: 'AutoIpNameCheck', inputValue: 'No', id: 'noAutoIpNameCheck'}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: generalAgentVerify,
					columns: 2,
					vertical: false,
					id:'NickIpCheck',
					disabled: isMsp,
					items: [
						{ boxLabel: yesRadioOption, name: 'NickIpCheck', inputValue: 'Yes',  id: 'yesNickIpCheck'},
						{ boxLabel: noRadioOption, name: 'NickIpCheck', inputValue: 'No', id: 'noNickIpCheck'}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: authLogin,
					columns: 2,
					vertical: false,
					id:'LoginAuthentication',
					items: [
						{ boxLabel: yesRadioOption, name: 'LoginAuthentication', inputValue: 'Yes',  id: 'yesLoginAuthentication'},
						{ boxLabel: noRadioOption, name: 'LoginAuthentication', inputValue: 'No', id: 'noLoginAuthentication'}
					]
				},
				{
					xtype: 'radiogroup',
					fieldLabel: managerSettingsMsg,
					cls: 'radiobt',
					id : 'authModeForLogin',
					name : 'authModeForLogin',
					columns: 1,
					vertical: true,
					flex:1,
					items: [
						{ boxLabel: eGEnterprisesMsg, labelWidth:200, labelAlign: 'top',name: 'AuthenticationModeForLogin',id:'eGAuthMode',inputValue: 'eG Enterprise',checked: true},
						{ boxLabel: activeDirectoryMsg, labelAlign: 'top',name: 'AuthenticationModeForLogin',id:'domainAuthMode',inputValue: 'Domain'},
						{ boxLabel: identityProviderMsg, labelAlign: 'top',name: 'AuthenticationModeForLogin',id:'idpAuthMode',inputValue: 'SAML'}
					]
				}
			]
		},
		{
			xtype: 'fieldset',
			id: 'generalPanel',
			hidden: true,
			items: [
				{
					xtype: 'hidden',
					name: '$_AvgSumTrends',
					id:'$_AvgSumTrends'
				},
				{
					xtype: 'hidden',
					name: '$_TrendMgrThreads',
					id:'$_TrendMgrThreads'
				},
				{
					xtype: 'hidden',
					name: '$_ThresholdMgrThreads',
					id: '$_ThresholdMgrThreads'
				},
				{
					xtype: 'hidden',
					name: '$_ThresholdRunDuration',
					id: '$_ThresholdRunDuration'
				},
				{
					xtype: 'hidden',
					name: '$_ThresholdAdjustPeriod',
					id:'$_ThresholdAdjustPeriod'
				},
				{
					xtype:'hidden',
					id: '$_timefrom',
					name: '$_timefrom'
				},
				{
					xtype:'hidden',
					id: '$_minfrom',
					name: '$_minfrom'
				},
				{
					xtype:'hidden',
					id: '$_timeto',
					name: '$_timeto'
				},
				{
					xtype:'hidden',
					id: '$_minto',
					name: '$_minto'
				},
				{
					xtype:'hidden',
					id: 'timefrom',
					name: 'timefrom'
				},
				{
					xtype:'hidden',
					id: 'minfrom',
					name: 'minfrom'
				},
				{
					xtype:'hidden',
					id: 'timeto',
					name: 'timeto'
				},
				{
					xtype:'hidden',
					id: 'minto',
					name: 'minto'
				},
				{
					xtype: 'hidden',
					name: 'RelativeThresholdHours',
					id: 'RelativeThresholdHours'
				},
				{
					xtype: 'hidden',
					name: '$_relativeThresholdTime',
					id:'$_relativeThresholdTime'
				},
				{
					xtype: 'hidden',
					name: '$_AutoIpNameCheck',
					id:'$_AutoIpNameCheck'
				},
				{
					xtype: 'hidden',
					name: '$_NickIpCheck',
					id:'$_NickIpCheck'
				},
				{
					xtype: 'hidden',
					name: '$_LoginAuthentication',
					id: '$_LoginAuthentication'
				},
				{
					xtype: 'hidden',
					name: 'process',
					id:'process'
				},
				{
					xtype: 'hidden',
					name: '$_AuthenticationModeForLogin',
					id:'$_AuthenticationModeForLogin',
				},	
				{
					xtype: 'hidden',
					name: 'from',
					id:'from'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 20,
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: updateBtnText,
					id: 'UpdateBtn',
					width: 80
				}
			]
		}
	]

});



