
listViewSetWidth = function(){

		var getViewWidth = 0;
		if (Ext.isChrome)
		{
			getViewWidth = Ext.getCmp('innerPanel').getWidth()-90;
		}
		else
		{
			getViewWidth = Ext.getCmp('innerPanel').getWidth()-90;
		}
		var defaultListViewWidth = 315;

		var ListViewDivide = Math.floor(getViewWidth/defaultListViewWidth);
	

		var ListViewModules = getViewWidth%defaultListViewWidth;
		var balanceAdded = Math.floor (ListViewModules/ListViewDivide);

		assignListViewFinalWidth=(defaultListViewWidth+balanceAdded);
	
		gettingListViewDashboardId = Ext.get("TTlistviewID");

		if (gettingListViewDashboardId != null && gettingListViewDashboardId != 'undefined')
		{
			gettingListViewDashboardClass = gettingListViewDashboardId.select("div.tti_listbox");

			gettingListViewDashboardClass.elements.forEach(function(el){
				Ext.fly(el).setWidth(assignListViewFinalWidth - 8);
			});
		}
};

Ext.define('ManagerSettings.view.ListView',{
	alias: 'widget.TTlistview',
	extend: 'Ext.panel.Panel',
	id: 'TTlistviewID',
	header: false,
	flex: 1,
	border: true,
	margin: 0,
	bodyPadding: 0,
	autoScroll: true,
	//layout:{type:'vbox',align:'stretch'},
	padding: 0,
	dataforView: null,
	DataForqtip: null,
	layout:{type:'vbox',align:'stretch'},
	initComponent: function()
	{
		var meListPage=this;
		
		this.items = [
			{
				xtype:'dataview',
				id: 'dataViewId',
				padding:'0 0 0 10px',			
				renderTo: Ext.getBody(),
				itemSelector: 'div.tti_listbox',
				overItemCls: 'ttlhover',
				trackOver: true,
				store: Ext.data.Store({
				fields: [{ name:'integrationName', type: 'string'},{ name: 'displayName', type: 'string'},{ name: 'integrationType', type: 'string'},{ name: 'tagline', type: 'string'},{ name: 'iconClsName', type: 'string'},{ name:'configuration',type:'boolean'}],
				data: meListPage.dataforView
			/**data :[		
						{integrationName: 'MAIl'},
						{integrationName: 'CLI'},
						{integrationName: 'SNMP'},
						{integrationName: 'JIRA'},
						{integrationName: 'SLACK'},
						{integrationName: 'HipChat'},
						{integrationName: 'ServiceNow'},
						{integrationName: 'Pagerduty'},
						{integrationName: 'Custom Integration'}
					]**/
					

				}),
				emptyText: '<table width="100%" height="480px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div styel="margin:10px auto">No TT Integration</div></td></tr></table>',
				tpl: new Ext.XTemplate(
					'<tpl for=".">',
						'<div style="width:315px;" class="tti_listbox">',
							'<div class="{iconClsName}" style="height:32px; float:left; margin-right:4%;"></div>',
							
							'<tpl if="!tagline">',
							'<div style="width:80%; float:left; display: flex; align-items: center; height: 32px;line-height:32px;">',
							'<b><p style="font-size:15px;">{displayName}</p></b>',
							'</div>',
							'<tpl else>',
							'<div style="width:80%; float:left; display: flex; align-items: center; height: 32px;">',
							'<b><p style="font-size:15px;">{displayName}</p><p>{tagline}</span></p></b>',
							'</div>',
							'</tpl>',
							'<tpl if="configuration"><div class="configure_icon"></div></tpl>',
						'</div>',
					'</tpl>'
				),
				listeners:{

					resize: function(c) {
						listViewSetWidth();
					},
				
					itemclick: function(view, record, item, index, e ) { 
						var integrationType = record.data.integrationType;
						var integrationName = record.data.integrationName;
						var iconClsName = record.data.iconClsName;
						loadIntegrationPage(integrationType, integrationName, record);
					}
				}
			}
	];
	this.callParent();
}
});

Ext.EventManager.onWindowResize(function () {
	listViewSetWidth();
});




