Ext.define('ManagerSettings.view.SingleSignOn', {
	extend: 'Ext.form.Panel',
	alias: 'widget.singlesignon',
	cls:'outerpanel',
	border: false,

	items:[
		{
			xtype: 'fieldset',
			title: '<b>' + 'Single Sign-On' + '</b>',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 600,
				labelWidth: 380
			},
			margin: 20,
			items: [
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: ssoLoginLbl,
					columns: 2,
					vertical: false,
					id:'ssoLogin',
					items: [
						{ 
							boxLabel: yesRadioOption, 
							name: 'ssoLogin', 
							inputValue: 'Yes',  
							id: 'yesssoLogin',
							listeners: {
								click: {
									element: 'el',
									fn: function()
									{
										Ext.getCmp('yesssoLogin').setValue(true);
										thisController.idpLogoutFunc(this);
									}
								}
							}
						},
						{ 
							boxLabel: noRadioOption, 
							name: 'ssoLogin', 
							inputValue: 'No', 
							id: 'nossoLogin',
							listeners: {
								click: {
									element: 'el',
									fn: function()
									{
										Ext.getCmp('nossoLogin').setValue(true);
										thisController.idpLogoutFunc(this);
									}
								}
							}
						}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: idpLogoutLbl,
					columns: 2,
					vertical: false,
					id:'idpLogout',
					hidden: true,
					items: [
						{ boxLabel: yesRadioOption, name: 'idpLogout', inputValue: 'Yes',  id: 'yesidpLogout'},
						{ boxLabel: noRadioOption, name: 'idpLogout', inputValue: 'No', id: 'noidpLogout'}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 20,
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: updateBtnText,
					width: 80,
					id:'UpdateBtn'
				}
			]
		},
		{
			xtype: 'fieldset',
			id: 'generalPanel',
			hidden: true,
			items: [
				{
					xtype: 'hidden',
					name: 'process',
					id:'process'
				},
				{
					xtype: 'hidden',
					name: 'from',
					id: 'from'
				},
				{
					xtype: 'hidden',
					name: '$_ssoLogin',
					id:'$_ssoLogin'
				},
				{
					xtype: 'hidden',
					name: '$_idpLogout',
					id:'$_idpLogout'
				}
			]
		}
	]
});
