Ext.define('ManagerSettings.view.TwoFactorAuth', {
	extend: 'Ext.form.Panel',
	alias: 'widget.twofactorauth',
	cls:'outerpanel',
	border: false,
	id: 'twofactorauth',

	items:[
		{
			xtype: 'fieldset',
			id: 'twofafieldset',
			title: '<b>' + TFATitle + '</b>',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 600,
				labelWidth: 290
			},
			flex: 1,
			margin: 20,
			items: [
				{
					xtype: 'radiogroup',
					columns: 2,
					vertical: true,
					style:{'white-space':'nowrap'},
					id: 'is2FAEnabled',
					name: 'is2FAEnabled',
					labelSeparator: '',
					fieldLabel: enable2FALabel+'?',
					items: [
						{
							boxLabel: yesRadioOption,
							cls: 'radiobt fontnormal_css',
							name: 'is2FAEnabled',
							width: 150,
							id: 'enable2FAYesFlag',
							inputValue: 'Yes'
						},
						{
							boxLabel: noRadioOption,
							cls: 'radiobt fontnormal_css',
							name: 'is2FAEnabled',
							//width:130,
							id: 'enable2FANoFlag',
							checked: true,
							inputValue: 'No'
						}
					]
				},
				{
					xtype: 'radiogroup',
					columns: 2,
					vertical: true,
					hidden: true,
					style:{'white-space':'nowrap'},
					id: 'twoFAOptionFlag',
					name: 'twoFAOptionFlag',
					labelSeparator: '',
					fieldLabel: enforce2FALabel+'?',
					items: [
						{
							boxLabel: 'Yes',
							cls: 'radiobt fontnormal_css',
							name: 'twoFAOptionFlag',
							width: 150,
							id: 'compulsoryFlag',
							inputValue: 'c'
						},
						{
							boxLabel: 'No',
							cls: 'radiobt fontnormal_css',
							name: 'twoFAOptionFlag',
							//width:130,
							id: 'optionalFlag',
							checked: true,
							inputValue: 'o'
						}
					]
				},
				{
					xtype: 'radiogroup',
					columns: 2,
					vertical: true,
					hidden: true,
					style:{'white-space':'nowrap'},
					id: 'twoFAOTPMode',
					name: 'twoFAOTPMode',
					fieldLabel: otpLabel,
					items: [
						{
							boxLabel: 'Receive via mail',
							cls: 'radiobt fontnormal_css',
							name: 'twoFAOTPMode',
							width: 150,
							id: 'mail',
							checked: true,
							inputValue: 'mail'
						},
						{
							boxLabel: 'Receive via SMS',
							cls: 'radiobt fontnormal_css',
							name: 'twoFAOTPMode',
							//width:70,
							id: 'sms',
							inputValue: 'sms',
							hidden: true
						},
						{
							boxLabel: 'Generate via Google Authenticator',
							cls: 'radiobt fontnormal_css',
							name: 'twoFAOTPMode',
							//width:130,
							id: 'ga',
							inputValue: 'ga'
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 20,
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: updateBtnText,
					id: 'twofa_submit_btn',
					width: 80
				}
			]
		}
	]
});



