<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "egurkha.TransactionBean"%>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%
	response.setContentType("application/json");

	TransactionBean transBean = new TransactionBean();

	transBean.createFile("eg_services.ini");


	final String MAIL_TAGLINE = _mapping.getTextDescription("admin.tt.Integration using Mail");
	final String SNMP_TAGLINE = _mapping.getTextDescription("admin.tt.Integration using SNMP");
	final String CLI_TAGLINE = _mapping.getTextDescription("admin.tt.Integration using CLI");
	boolean isMailEnabled = false;
	boolean isEnabledSNMPTraps = false;
	boolean isEnabledCLI = false;
	boolean isEnabledTTIntegartion = false;
	//String strArr[] = {"Mail","JIRA","SLACK","HipChat","PAGERDUTY"};
	String ttSystems = transBean.getStrValue("TT_INTEGRATION", "TT_INTEGRATION_SYSTEMS");
	String enableTTIntegration = transBean.getStrValue("TT_INTEGRATION", "ENABLE_TT_INTEGRATION");
	String enabledTTSystem = transBean.getStrValue("TT_INTEGRATION", "TT_INTEGRATION_ENABLED_SYSTEM");
	
	String enableMail = transBean.getStrValue("TTMAIL", "EnableMail");
	String enableTTIntegrationForSNMPTraps = transBean.getStrValue("TTMAIL", "EnableTTIntegrationForSNMPTraps");
	String enableExecForTT = transBean.getStrValue("EXEC_TTMANAGER", "EnableExecForTT");

	if(enableMail != null && enableMail.equalsIgnoreCase("Yes") || enableMail.equalsIgnoreCase("true")){
		isMailEnabled = true;
	}
	if(enableTTIntegrationForSNMPTraps != null && enableTTIntegrationForSNMPTraps.equalsIgnoreCase("Yes") || enableTTIntegrationForSNMPTraps.equalsIgnoreCase("true")){
		isEnabledSNMPTraps = true;
	}
	if(enableExecForTT != null && enableExecForTT.equalsIgnoreCase("Yes") || enableExecForTT.equalsIgnoreCase("true")){
		isEnabledCLI = true;
	}
	if(enableTTIntegration != null && enableTTIntegration.equalsIgnoreCase("Yes") || enableTTIntegration.equalsIgnoreCase("true")){
		isEnabledTTIntegartion = true;
	}
	
	JSONObject root = new JSONObject();
	JSONArray integrationList = new JSONArray();
	

	//### Mail ##
	JSONObject cObj = new JSONObject();
	cObj.put("integrationName", "Mail");
	cObj.put("integrationType", "Mail");
	cObj.put("tagline", MAIL_TAGLINE);
	cObj.put("displayName", _mapping.getTextDescription("admin.tt.Mail"));
	cObj.put("iconClsName", "mail_icon");
	cObj.put("configuration", isMailEnabled);
	integrationList.add(cObj);
	
	//### SNMP ##
	/*cObj = new JSONObject();
	cObj.put("integrationName", "SNMP");
	cObj.put("integrationType", "SNMP");
	cObj.put("tagline", SNMP_TAGLINE);
	cObj.put("displayName", "SNMP");
	cObj.put("iconClsName", "snmp_icon");
	cObj.put("configuration", isEnabledSNMPTraps);
	integrationList.add(cObj);*/

	//### CLI ##
	cObj = new JSONObject();
	cObj.put("integrationName", "CLI");
	cObj.put("integrationType", "CLI");
	cObj.put("tagline", CLI_TAGLINE);
	cObj.put("displayName", _mapping.getTextDescription("admin.tt.CLI"));
	cObj.put("iconClsName", "cli_icon");
	cObj.put("configuration", isEnabledCLI);
	integrationList.add(cObj);

	//### Web services ##
	StringTokenizer integrationNames = new StringTokenizer(ttSystems, ",");	
	
	while (integrationNames.hasMoreTokens())
	{
		String integrationName = integrationNames.nextToken();

		JSONObject intgrObj = new JSONObject();

		intgrObj.put("integrationName", integrationName);
		intgrObj.put("integrationType", "Web_Services");
		
		String tagline = transBean.getStrValue("TT_INTEGRATION_" + integrationName, "tagline");
		String displayName = transBean.getStrValue("TT_INTEGRATION_" + integrationName, "displayName");

		intgrObj.put("tagline", _mapping.getTextDescription("admin.tt."+tagline));
		intgrObj.put("displayName", _mapping.getTextDescription("admin.tt."+displayName));
		
		if(integrationName != null && isEnabledTTIntegartion && integrationName.trim().equalsIgnoreCase(enabledTTSystem)){
			intgrObj.put("configuration", true);//configuration:true
		} else {
			intgrObj.put("configuration", false);//configuration:true
		}
		if(integrationName != null)
		{
			String iconClsName = 	integrationName.trim().toLowerCase();
			iconClsName = iconClsName.replace(' ', '_'); // replace space with underscore (_)
			iconClsName += "_icon"; //End with _icon
			intgrObj.put("iconClsName", iconClsName);
		}

		integrationList.add(intgrObj);
	}
	
	//### Common Settings ##
		cObj = new JSONObject();

		cObj.put("integrationName", "Settings");//Common Settings
		cObj.put("integrationType", "Settings");//Common Settings
		cObj.put("tagline",  _mapping.getTextDescription("admin.tt.Common"));
		cObj.put("displayName", _mapping.getTextDescription("admin.tt.Settings"));
		cObj.put("iconClsName", "common_settings_icon");
		cObj.put("configuration", false);//configuration always false for Settings

		integrationList.add(cObj);

	root.put("integrationList", integrationList);
	//System.out.println("listJSON#########"+ root.toString());
	
	out.println(root.toString());
%>
