Ext.define('Managerlog.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ManagerLogView'],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function(){
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main combo[id="logFileDirectory"]':
			{
				'select': this.LogFileDirectoryOnchange
			},
			'main combo[id="ipnick"]':
			{
				'select': this.IpNickOnchange
			},
			'main combo[id="logFileName"]':
			{
				'select': this.LogFileNameOnchange
			},
			'main combo[id="dateFilter"]':
			{
				'select': this.DateFilterOnchange
			},
			'main button[action=refresh]':
			{ 
				'click': this.RefreshOnchange
			},
			'main button[action=download]':
			{ 
				'click': this.DownloadOnchange
			}
		});
	},
	afterMainRender: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(),{msg: "Loading..."});
		loader.show();
		Ext.Ajax.request(
		{
			url: requestURL,
			method:'GET',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var temp = response.responseText;
					var dateStr = "";
					var logs = "";
					if (jsonText.indexOf("~#~")>0 && jsonText.indexOf("^^^")>0)
					{
						dateStr = (jsonText.substring(jsonText.indexOf("~#~")+3,jsonText.indexOf("^^^")));
						jsonText = (jsonText.substring(0,jsonText.indexOf("~#~")));
						logs = (temp.substring(temp.indexOf("^^^")+3));
					}
					publicJSON = Ext.decode( jsonText );
					Ext.getCmp('resultTexts').setValue(logs);
					Ext.getCmp('ipnick').getStore().suspendEvents(true);
					Ext.getCmp('ipnick').getStore().loadRawData(publicJSON['nickNameList']);
					Ext.getCmp('ipnick').getStore().resumeEvents();
					if(ip.length == 0)
					{
						Ext.getCmp('ipnick').select(Ext.getCmp('ipnick').getStore().getAt(0));
					}
					else
					{
						Ext.getCmp('ipnick').select(ip);
					}
					Ext.getCmp('logFileDirectory').getStore().suspendEvents(true);
					Ext.getCmp('logFileDirectory').getStore().loadRawData(publicJSON['logFileDirectoryList']);
					Ext.getCmp('logFileDirectory').getStore().resumeEvents();
					if (logDir.length == 0)
					{
						Ext.getCmp('logFileDirectory').select(Ext.getCmp('logFileDirectory').getStore().getAt(0));
					}
					else
					{
						Ext.getCmp('logFileDirectory').select(logDir);
					}
					Ext.getCmp('logFileName').getStore().suspendEvents(true);
					Ext.getCmp('logFileName').getStore().loadRawData(publicJSON['logFileNameList']);
					Ext.getCmp('logFileName').getStore().resumeEvents();
					if(logFile.length == 0)
					{
						Ext.getCmp('logFileName').select(Ext.getCmp('logFileName').getStore().getAt(0));
					}
					else
					{
						Ext.getCmp('logFileName').select(logFile);
					}
					if(publicJSON['dateFilterList'] != '')
					{
						Ext.getCmp('dateFilter').getStore().suspendEvents(true);
						Ext.getCmp('dateFilter').getStore().loadRawData(publicJSON['dateFilterList']);
						Ext.getCmp('dateFilter').getStore().resumeEvents();
						if(date.length == 0)
						{
							Ext.getCmp('dateFilter').select(Ext.getCmp('dateFilter').getStore().getAt(0));
						}
						else
						{
							Ext.getCmp('dateFilter').select(date);
						}
						Ext.getCmp('dateFilter').setDisabled(false);
					}
					else
					{
						Ext.getCmp('dateFilter').setDisabled(true);
					}
					Ext.getCmp('modifiedTime').setValue(dateStr);
					loader.hide();
				}
			}
		});
	},
	IpNickOnchange:function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(),{msg: "Loading..."});
		loader.show();
		var selectedIpNick = Ext.getCmp('ipnick').getValue();
		var selectedLogDirectory = Ext.getCmp('logFileDirectory').getValue();
		var selectedLogFileName = Ext.getCmp('logFileName').getValue();
		var param = 'managerIP='+encodeURI(selectedIpNick);
		Ext.Ajax.request(
		{	
			url: 'Managerlog/data/managerLogJson.jsp',
			method:'GET',
			params: param,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var inputs = "";
					var date = "";
					if(jsonText.indexOf("#$#")==0)
					{
						Ext.Msg.alert('Alert Box',jsonText.substring(jsonText.indexOf("#$#")+3,jsonText.indexOf("^$^")));
						if(jsonText.indexOf("^$^")>0 && jsonText.indexOf("~#~")>0)
						{
							inputs = jsonText.substring(jsonText.indexOf("^$^")+3);
							date=inputs.substring(inputs.indexOf("~#~")+3);
						}
						publicJSON = Ext.decode(inputs.substring(0,inputs.indexOf("~#~")));
						Ext.getCmp('logFileDirectory').getStore().suspendEvents(true);
						Ext.getCmp('logFileDirectory').getStore().loadRawData(publicJSON['logFileDirectoryList']);
						Ext.getCmp('logFileDirectory').getStore().resumeEvents();
						Ext.getCmp('logFileDirectory').select(Ext.getCmp('logFileDirectory').getStore().getAt(0));
						Ext.getCmp('logFileName').reset();
						Ext.getCmp('dateFilter').reset();
						Ext.getCmp('resultTexts').reset();
					}
					else
					{
						var temp = response.responseText;
						var dateStr = "";
						var logs = "";
						if (jsonText.indexOf("~#~")>0 && jsonText.indexOf("^^^")>0)
						{
							dateStr = (jsonText.substring(jsonText.indexOf("~#~")+3,jsonText.indexOf("^^^")));
							jsonText = (jsonText.substring(0,jsonText.indexOf("~#~")));
							logs = (temp.substring(temp.indexOf("^^^")+3));
						}

						publicJSON = Ext.decode( jsonText );
						Ext.getCmp('resultTexts').setValue(logs);
						Ext.getCmp('logFileDirectory').getStore().suspendEvents(true);
						Ext.getCmp('logFileDirectory').getStore().loadRawData(publicJSON['logFileDirectoryList']);
						Ext.getCmp('logFileDirectory').getStore().resumeEvents();
						Ext.getCmp('logFileDirectory').select(Ext.getCmp('logFileDirectory').getStore().getAt(0));
						Ext.getCmp('logFileName').getStore().suspendEvents(true);
						Ext.getCmp('logFileName').getStore().loadRawData(publicJSON['logFileNameList']);
						Ext.getCmp('logFileName').getStore().resumeEvents();
						var count = Ext.getCmp('logFileName').store.getCount();
						var selection = false;
						for (var i=0;i<count; i++)
						{
							if(Ext.getCmp('logFileName').getStore().getAt(i) == selectedLogFileName)
							{
								Ext.getCmp('logFileName').select(Ext.getCmp('logFileName').getStore().getAt(i));
								selection = true;
								break;
							}
						}
						if(!selection)
						{
							Ext.getCmp('logFileName').select(Ext.getCmp('logFileName').getStore().getAt(0));
						}
						Ext.getCmp('dateFilter').getStore().suspendEvents(true);
						Ext.getCmp('dateFilter').getStore().loadRawData(publicJSON['dateFilterList']);
						Ext.getCmp('dateFilter').getStore().resumeEvents();
						Ext.getCmp('dateFilter').select(Ext.getCmp('dateFilter').getStore().getAt(0));
						Ext.getCmp('modifiedTime').setValue(dateStr);
						if(Ext.getCmp('dateFilter').getValue() == -1)
						{
							Ext.getCmp('dateFilter').setDisabled(true);
						}
						else
						{
							Ext.getCmp('dateFilter').setDisabled(false);
						}
					}
					loader.hide();
				}
			}
		});	
	},
	LogFileDirectoryOnchange: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(),{msg: "Loading..."});
		loader.show();
		var selectedIpNick = Ext.getCmp('ipnick').getValue();
		var selectedLogDirectory = Ext.getCmp('logFileDirectory').getValue();
		var selectedLogFileName = Ext.getCmp('logFileName').getValue();
		var param = 'managerIP='+encodeURI(selectedIpNick)+'&logsDir='+encodeURI(selectedLogDirectory);
		Ext.Ajax.request(
		{	
			url: 'Managerlog/data/managerLogJson.jsp',
			method:'GET',
			params: param,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var temp = response.responseText;
					var dateStr = "";
					var logs = "";
					if (jsonText.indexOf("~#~")>0 && jsonText.indexOf("^^^")>0)
					{
						dateStr = (jsonText.substring(jsonText.indexOf("~#~")+3,jsonText.indexOf("^^^")));
						jsonText = (jsonText.substring(0,jsonText.indexOf("~#~")));
						logs = (temp.substring(temp.indexOf("^^^")+3));
					}

					publicJSON = Ext.decode( jsonText );
					Ext.getCmp('resultTexts').setValue(logs);
					Ext.getCmp('logFileName').getStore().suspendEvents(true);
					Ext.getCmp('logFileName').getStore().loadRawData(publicJSON['logFileNameList']);
					Ext.getCmp('logFileName').getStore().resumeEvents();
					Ext.getCmp('logFileName').select(Ext.getCmp('logFileName').getStore().getAt(0));
					Ext.getCmp('dateFilter').getStore().suspendEvents(true);
					Ext.getCmp('dateFilter').getStore().loadRawData(publicJSON['dateFilterList']);
					Ext.getCmp('dateFilter').getStore().resumeEvents();
					Ext.getCmp('dateFilter').select(Ext.getCmp('dateFilter').getStore().getAt(0));
					Ext.getCmp('modifiedTime').setValue(dateStr);
					if(Ext.getCmp('dateFilter').getValue() == -1)
					{
						Ext.getCmp('dateFilter').setDisabled(true);
					}
					else
					{
						Ext.getCmp('dateFilter').setDisabled(false);
					}
					loader.hide();
				}
			}
		});
	},
	LogFileNameOnchange: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(),{msg: "Loading..."});
		loader.show();
		var selectedIpNick = Ext.getCmp('ipnick').getValue();
		var selectedLogDirectory = Ext.getCmp('logFileDirectory').getValue();
		var selectedLogFileName = Ext.getCmp('logFileName').getValue();
		var param = 'managerIP='+encodeURI(selectedIpNick)+'&mgrLogFile='+encodeURI(selectedLogFileName)+'&logsDir='+encodeURI(selectedLogDirectory);
		Ext.Ajax.request(
		{	
			url: 'Managerlog/data/managerLogJson.jsp',
			method:'GET',
			params: param,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var temp = response.responseText;
					var dateStr = "";
					var logs = "";
					if (jsonText.indexOf("~#~")>0 && jsonText.indexOf("^^^")>0)
					{
						dateStr = (jsonText.substring(jsonText.indexOf("~#~")+3,jsonText.indexOf("^^^")));
						jsonText = (jsonText.substring(0,jsonText.indexOf("~#~")));
						logs = (temp.substring(temp.indexOf("^^^")+3));
					}

					publicJSON = Ext.decode( jsonText );
					Ext.getCmp('resultTexts').setValue(logs);
					Ext.getCmp('dateFilter').getStore().suspendEvents(true);
					Ext.getCmp('dateFilter').getStore().loadRawData(publicJSON['dateFilterList']);
					Ext.getCmp('dateFilter').getStore().resumeEvents();
					Ext.getCmp('dateFilter').select(Ext.getCmp('dateFilter').getStore().getAt(0));
					Ext.getCmp('modifiedTime').setValue(dateStr);
					if(Ext.getCmp('dateFilter').getValue() == -1)
					{
						Ext.getCmp('dateFilter').setDisabled(true);
					}
					else
					{
						Ext.getCmp('dateFilter').setDisabled(false);
					}

					loader.hide();
				}
			}
		});
	},
	DateFilterOnchange: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(),{msg: "Loading..."});
		loader.show();
		var selectedIpNick = Ext.getCmp('ipnick').getValue();
		var selectedLogDirectory = Ext.getCmp('logFileDirectory').getValue();
		var selectedLogFileName = Ext.getCmp('logFileName').getValue();
		var selectedDate = Ext.getCmp('dateFilter').getValue();
		var param = 'filter='+selectedDate+'&mgrLogFile='+encodeURI(selectedLogFileName)+'&managerIP='+selectedIpNick+'&logsDir='+encodeURI(selectedLogDirectory);
		Ext.Ajax.request(
		{	
			url: 'Managerlog/data/managerLogJson.jsp',
			method:'GET',
			params: param,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var temp = response.responseText;
					var dateStr = "";
					var logs = "";
					if (jsonText.indexOf("~#~")>0 && jsonText.indexOf("^^^")>0)
					{
						dateStr = (jsonText.substring(jsonText.indexOf("~#~")+3,jsonText.indexOf("^^^")));
						jsonText = (jsonText.substring(0,jsonText.indexOf("~#~")));
						logs = (temp.substring(temp.indexOf("^^^")+3));
					}
					publicJSON = Ext.decode( jsonText );
					Ext.getCmp('resultTexts').setValue(logs);
					Ext.getCmp('modifiedTime').setValue(dateStr);
					loader.hide();
				}
			}
		});
	},
	RefreshOnchange: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(),{msg: "Loading..."});
		loader.show();
		Ext.getCmp('resultTexts').reset();
		var selectedIpNick = Ext.getCmp('ipnick').getValue();
		var selectedLogDirectory = Ext.getCmp('logFileDirectory').getValue();
		var selectedLogFileName = Ext.getCmp('logFileName').getValue();
		var param = 'managerIP='+encodeURI(selectedIpNick)+'&mgrLogFile='+encodeURI(selectedLogFileName)+'&logsDir='+encodeURI(selectedLogDirectory);
		Ext.Ajax.request(
		{	
			url: 'Managerlog/data/managerLogJson.jsp',
			method:'POST',
			params: param,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var temp = response.responseText;
					var dateStr = "";
					var logs = "";
					if (jsonText.indexOf("~#~")>0 && jsonText.indexOf("^^^")>0)
					{
						dateStr = (jsonText.substring(jsonText.indexOf("~#~")+3,jsonText.indexOf("^^^")));
						jsonText = (jsonText.substring(0,jsonText.indexOf("~#~")));
						logs = (temp.substring(temp.indexOf("^^^")+3));
					}
					publicJSON = Ext.decode( jsonText );
					Ext.getCmp('resultTexts').setValue(logs);
					Ext.getCmp('modifiedTime').setValue(dateStr);
					Ext.getCmp('dateFilter').select(Ext.getCmp('dateFilter').getStore().getAt(0));
					loader.hide();
				}
			}
		});
	},
	DownloadOnchange: function()
	{
		var selectedIpNick = Ext.getCmp('ipnick').getValue();
		var selectedLogDirectory = Ext.getCmp('logFileDirectory').getValue();
		var selectedLogFileName = Ext.getCmp('logFileName').getValue();
		var selectedDate = Ext.getCmp('dateFilter').getValue();
		window.location.href = 'Managerlog/data/managerLogJson.jsp?managerIP='+encodeURI(selectedIpNick)+'&mgrLogFile='+encodeURI(selectedLogFileName)+'&logsDir='+encodeURI(selectedLogDirectory)+'&filter='+encodeURI(selectedDate)+'&download=true&com.eg.CSRF_NONCE='+csrfToken;
	}
});



