Ext.define('ManagersList.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ConfiguredManagersListView','ManagerView'],
	refs:[
		{selector:'configuredmanagerslistview', ref:'configuredmanagerslistview'},
		{selector:'managerview', ref:'managerview'}
	],
	init:function(){
		appCnt=this;
		this.buildFieldData();

		this.control({
			'configuredmanagerslistview':
			{
				'afterrender': this.afterMainRender
			},
			'configuredmanagerslistview trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
			'configuredmanagerslistview trigger[name="unmanagedGridSearch"]': {
				'change': this.mainUnmanagedGridSearch
			},
			'configuredmanagerslistview button[id="addManager"]': {
				'click': this.addNewManager
			},
			'managerview button[id="backbutton"]':
			{
				'click': this.backbutton
			},
			'managerview button[id="addManagerBtn"]':
			{
				'click': this.updateManager
			},
			'managerview button[id="modifyManagerBtn"]':
			{
				'click': this.updateManager
			}
		});
	},
	handleEditIconClick: function(grid, rowIndex, colIndex){
		var rec = grid.getStore().getAt(rowIndex);
		var s_managerId = rec.get('managerNickname');
		var managerViewController = this.getController('ManagersList.controller.ManagerViewController');
		Ext.getCmp('viewport').removeAll();
		managerViewController.buildFieldData('ManagersList/data/displayManagers.jsp?operation=modifyManager&managerId='+s_managerId);
		Ext.getCmp('viewport').add({xtype: 'managerview'});
		managerViewController.afterMainRender('modifyManager',s_managerId);
	},
	handleDeleteIconClick: function(gridId,grid, rowIndex, colIndex){
		var thisCopy = this;
		var DispValues = Ext.getCmp(gridId).getStore().getAt(rowIndex);
		var s_managerId = DispValues.get('managerNickname');
		Ext.Msg.show({
				title: pageTitle,
				msg: deleteManagerMessage,
				buttons: Ext.Msg.YESNO,
				icon: 'iconConfirmation',
				fn: function(buttonText) {
					if (buttonText == "yes") {
						var homepage = Ext.getCmp('viewport');
						myMask = new Ext.LoadMask(homepage, {msg:pleaseWait});
						myMask.show();
						var resultUrl = "/final/servlet/com.eg.supermanager.EgConfigManagerProcess?managerId="+s_managerId+"&mode=delete";
						Ext.Ajax.request({
							url: resultUrl,
							method: 'POST',
							//async:false,
							timeout: 300000,
							success: function( response )
							{
								if(response.status == 200 && !Ext.isEmpty( response.responseText ))
								{
									resultJSON = Ext.decode(response.responseText );
									if(resultJSON['operationStatus']['status']=='success')
									{
										Ext.Msg.show({
											title: pageTitle,
											msg: resultJSON['operationStatus']['statusMessage'],
											buttons: Ext.Msg.OK,
											icon: 'iconInformation'
										});

										Ext.getCmp('viewport').removeAll();
										thisCopy.buildFieldData();
										Ext.getCmp('viewport').add({xtype: 'configuredmanagerslistview'});
										thisCopy.afterMainRender();
									}
									else
									{
										Ext.MessageBox.alert(updateManagerLabel,errorTitle);
									}
								}
								myMask.hide();
							},
							failure: function(response)
							{
								myMask.hide();
							}
						});
					}
				}
			});
	},
	handleDeleteSelected: function(gridId){
		thisCopy = this;
		var grid=Ext.getCmp(gridId).getSelectionModel().getSelection();
		var values='';
		var selectedManagerIds="";
		if(grid=="")
		{
			Ext.MessageBox.alert(pageTitle,noManagersSelected);
			return false;
		}
		for(var i=0;i<grid.length;i++)
		{
			selectedManagerIds += ',' + grid[i].get('managerNickname');
		}
		if(selectedManagerIds.length>0)
		{
			selectedManagerIds = selectedManagerIds.substring(1);
		}
		Ext.Msg.show({
			title: pageTitle,
			msg: deleteManagersMessage,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(buttonText) {
				if (buttonText == "yes")
				{
					var homepage = Ext.getCmp('viewport');
					myMask = new Ext.LoadMask(homepage, {msg:pleaseWait});
					myMask.show();
					var resultUrl = "/final/servlet/com.eg.supermanager.EgConfigManagerProcess?managerId="+selectedManagerIds+"&mode=delete";
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						//async:false,
						timeout: 300000,
						success: function( response )
						{
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								resultJSON = Ext.decode(response.responseText);
								if(resultJSON['operationStatus']['status']=='success')
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: resultJSON['operationStatus']['statusMessage'],
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
									Ext.getCmp('viewport').removeAll();
									thisCopy.buildFieldData();
									Ext.getCmp('viewport').add({xtype: 'configuredmanagerslistview'});
									thisCopy.afterMainRender();
								}
								else
								{
									Ext.MessageBox.alert(updateManagerLabel,errorTitle);
								}
							}
							myMask.hide();
						},
						failure: function(response)
						{
							myMask.hide();
						}
					});
				}
			}
		});
	},
	handleManageUnmanageIconClick: function(gridId,grid, rowIndex, colIndex){
		thisMode = '';
		message = '';
		var thisCopy = this;
		var DispValues = Ext.getCmp(gridId).getStore().getAt(rowIndex);
		var s_managerId = DispValues.get('managerNickname');
		var s_manager_status = DispValues.get('Status');
		if(s_manager_status.indexOf('#Configured')>0)
		{
			thisMode="unmanage";
			message = unmanageManagerMessage;
		}
		else
		{
			thisMode="manage";
			message = manageManagerMessage;
		}
		Ext.Msg.show({
			title: pageTitle,
			msg: message,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(buttonText) {
				if (buttonText == "yes")
				{
					var homepage = Ext.getCmp('viewport');
					myMask = new Ext.LoadMask(homepage, {msg:pleaseWait});
					myMask.show();
					var resultUrl = "/final/servlet/com.eg.supermanager.EgConfigManagerProcess?managerId="+s_managerId+"&mode="+thisMode;
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						//async:false,
						timeout: 300000,
						success: function( response )
						{
							if(response.status == 200 && !Ext.isEmpty( response.responseText ))
							{
								resultJSON = Ext.decode(response.responseText );
								if(resultJSON['operationStatus']['status']=='success' || resultJSON['operationStatus']['status']=='failed')
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: resultJSON['operationStatus']['statusMessage'],
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
									Ext.getCmp('viewport').removeAll();
									thisCopy.buildFieldData();
									Ext.getCmp('viewport').add({xtype: 'configuredmanagerslistview'});
									thisCopy.afterMainRender();
								}
								else
								{
									Ext.MessageBox.alert(pageTitle,errorTitle);
								}
							}
							myMask.hide();
						},
						failure: function(response)
						{
							myMask.hide();
						}
					});
				}
			}
		});
	},
	configureOrUnconfigureAllHeaderIconClicked: function(thisMode){
		thisCopy = this;
		var values='';
		var selectedManagerIds="";
		var grid=Ext.getCmp('managedManagersGrid').getSelectionModel().getSelection();
		if(grid=="")
		{
			Ext.MessageBox.alert(pageTitle,noManagersSelected);
			return false;
		}
		message = "";
		if(thisMode=='manage')
		{
			message = manageManagersMessage;
		}
		else
		{
			message = unmanageManagersMessage;
		}

		for(var i=0;i<grid.length;i++)
		{
			selectedManagerIds += ',' + grid[i].get('managerNickname');
		}
		if(selectedManagerIds.length>0)
		{
			selectedManagerIds = selectedManagerIds.substring(1);
		}
		Ext.Msg.show({
			title: pageTitle,
			msg: message,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(buttonText) {
				if (buttonText == "yes")
				{
					var homepage = Ext.getCmp('viewport');
					myMask = new Ext.LoadMask(homepage, {msg:pleaseWait});
					myMask.show();
					var resultUrl = "/final/servlet/com.eg.supermanager.EgConfigManagerProcess?managerId="+selectedManagerIds+"&mode="+thisMode;
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						//async:false,
						timeout: 300000,
						success: function( response )
						{
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								resultJSON = Ext.decode(response.responseText);
								if(resultJSON['operationStatus']['status']=='success')
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: resultJSON['operationStatus']['statusMessage'],
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
									Ext.getCmp('viewport').removeAll();
									thisCopy.buildFieldData();
									Ext.getCmp('viewport').add({xtype: 'configuredmanagerslistview'});
									thisCopy.afterMainRender();
								}
								else
								{
									Ext.MessageBox.alert(pageTitle,resultJSON['operationStatus']['statusMessage']);
								}
							}
							myMask.hide();
						},
						failure: function(response)
						{
							myMask.hide();
						}
					});
				}
			}
		});
	},
	backbutton: function()
	{
		var mainController = this.getController('ManagersList.controller.Main');
		Ext.getCmp('viewport').removeAll();
		mainController.buildFieldData('ManagersList/data/displayManagers.jsp?operation=displayManagers');
		Ext.getCmp('viewport').add({xtype: 'configuredmanagerslistview'});
		mainController.afterMainRender();
	},
	updateManager : function(btn)
	{
		var thisCopy = this;
		var current_managerId = Ext.getCmp('managerId').getValue();
		var current_url = Ext.getCmp('url').getValue();
		var current_alturl = Ext.getCmp('alturl').getValue();
		var isModifyOperation = false;
		var errorUrl1 = false;
		var errorUrl2 = false;
		if(current_url != null && current_url.length>0)
		{
			var finalStr = '';
			var curls = current_url.split(',');
			for(var i=0;i<curls.length;i++)
			{
				var tmp_str = curls[i];
				var lastChar = tmp_str.charAt(tmp_str.length-1);
				if(lastChar=='\\' || lastChar=='/')
				{
					errorUrl1=true;
				}
				if(tmp_str.toLowerCase().indexOf('http://')==-1 && tmp_str.toLowerCase().indexOf('https://')==-1)
				{
					finalStr+=',http://'+tmp_str;
				}
				else
				{
					finalStr+=','+tmp_str;
				}
			}
			current_url=finalStr.substring(1);			
		}
		if(current_alturl != null && current_alturl.length>0 && current_alturl.toLowerCase() != 'none')
		{
			var finalStr = '';
			var curls = current_alturl.split(',');
			for(var i=0;i<curls.length;i++)
			{
				var tmp_str = curls[i];
				var lastChar = tmp_str.charAt(tmp_str.length-1);
				if(lastChar=='\\' || lastChar=='/')
				{
					errorUrl2=true;
				}
				if(tmp_str.toLowerCase().indexOf('http://')==-1 && tmp_str.toLowerCase().indexOf('https://')==-1)
				{
					finalStr+=',http://'+tmp_str;
				}
				else
				{
					finalStr+=','+tmp_str;
				}
			}
			current_alturl=finalStr.substring(1);
		}
		if(btn.getId()=='modifyManagerBtn')
		{
			if(!checkblank(current_url))
			{
				Ext.MessageBox.alert(updateManagerLabel,'Manager URL cannot be empty');
				return;
			}
			else if(!checkValidURLs(current_url))
			{
				Ext.MessageBox.alert(updateManagerLabel,'Manager URL is not valid');
				return;
			}
			else if(current_alturl != null && current_alturl.trim().length>0 && current_alturl.toLowerCase() != 'none' && !checkValidURLs(current_alturl))
			{
				Ext.MessageBox.alert(updateManagerLabel,'Alternate manager URL(s) is not valid');
				return;
			}
			else if(current_alturl.indexOf(current_url)>-1)
			{
				Ext.MessageBox.alert(updateManagerLabel,'Alternate manager URL(s) should not contain manager URL');
				return;
			}
			else if(current_url==previous_url && current_alturl==previous_alturl)
			{
				Ext.MessageBox.alert(updateManagerLabel,managerDetailsNotChanged);
				return;
			}
			else if(errorUrl1)
			{
				Ext.MessageBox.alert(updateManagerLabel,'Manager URL should not end with \\ or /');
				return;
			}
			else if(errorUrl2)
			{
				Ext.MessageBox.alert(updateManagerLabel,'Alternate Manager URL should not end with \\ or /');
				return;
			}
			else
			{
				if(current_alturl == null || current_alturl.trim().length==0)
				{
					current_alturl='none';
				}
				var homepage = Ext.getCmp('viewport');
				myMask = new Ext.LoadMask(homepage, {msg:pleaseWait});
				myMask.show();
				var resultUrl = "/final/servlet/com.eg.supermanager.EgConfigManagerProcess?mode=update&modify=true";
				Ext.Ajax.request({
					url: resultUrl,
					method: 'POST',
					params: {"managerId":current_managerId,"url":current_url,"alturl":current_alturl},
					//async:false,
					timeout: 300000,
					success: function( response )
					{
						if(response.status == 200 && !Ext.isEmpty( response.responseText ))
						{
							resultJSON = Ext.decode(response.responseText );
							if(resultJSON['operationStatus']['status']=='success')
							{
								Ext.Msg.show({
									title: updateManagerLabel,
									msg: updateManager,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								Ext.getCmp('viewport').removeAll();
								thisCopy.buildFieldData();
								Ext.getCmp('viewport').add({xtype: 'configuredmanagerslistview'});
								thisCopy.afterMainRender();
							}
							else
							{
								Ext.MessageBox.alert(updateManagerLabel,resultJSON['operationStatus']['statusMessage']);
							}
						}
						myMask.hide();
					},
					failure: function(response)
					{
						Ext.MessageBox.alert(updateManagerLabel,modifyExceptionMessage);
						myMask.hide();
					}
				});
			}
		}
		else if(!validateManagerId(current_managerId))
		{
			return;
		}
		else if(!checkblank(current_url))
		{
			Ext.MessageBox.alert(addManagerLabel,'Manager URL cannot be empty');
			return;
		}
		else if(!checkValidURLs(current_url))
		{
			Ext.MessageBox.alert(addManagerLabel,'Manager URL is not valid');
			return;
		}
		else if(current_alturl != null && current_alturl.trim().length>0 && current_alturl.toLowerCase() != 'none' && !checkValidURLs(current_alturl))
		{
			Ext.MessageBox.alert(addManagerLabel,'Alternate manager URL(s) is not valid');
			return;
		}			
		else if(current_alturl.indexOf(current_url)>-1)
		{
			Ext.MessageBox.alert(addManagerLabel,'Alterate manager URL(s) should not contain manager URL');
			return;
		}
		else if(errorUrl1)
		{
			Ext.MessageBox.alert(addManagerLabel,'Manager URL should not end with \\ or /');
			return;
		}
		else if(errorUrl2)
		{
			Ext.MessageBox.alert(addManagerLabel,'Alternate Manager URL should not end with \\ or /');
			return;
		}
		else
		{
			if(current_alturl == null || current_alturl.trim().length==0)
			{
				current_alturl='none';
			}
			var homepage = Ext.getCmp('viewport');
			myMask = new Ext.LoadMask(homepage, {msg:pleaseWait});
			myMask.show();
			var resultUrl = "/final/servlet/com.eg.supermanager.EgConfigManagerProcess";
			Ext.Ajax.request({
				url: resultUrl,
				method: 'POST',
				params: {"managerId":current_managerId,"mode":"new"},
				//async:false,
				timeout: 300000,
				success: function( response )
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						resultJSON = Ext.decode(response.responseText );
						if(resultJSON['operationStatus']['status']=='success')
						{
							var resultUrl = "/final/servlet/com.eg.supermanager.EgConfigManagerProcess?mode=update&modify=false";
							Ext.Ajax.request({
								url: resultUrl,
								method: 'POST',
								params: {"managerId":current_managerId,"url":current_url,"alturl":current_alturl},
								//async:false,
								timeout: 300000,
								success: function( response )
								{
									if(response.status == 200 && !Ext.isEmpty( response.responseText ))
									{
										resultJSON = Ext.decode(response.responseText );
										if(resultJSON['operationStatus']['status']=='success')
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: addManager,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
											Ext.getCmp('viewport').removeAll();
											thisCopy.buildFieldData();
											Ext.getCmp('viewport').add({xtype: 'configuredmanagerslistview'});
											thisCopy.afterMainRender();
										}
										else
										{
											Ext.MessageBox.alert(addManagerLabel,resultJSON['operationStatus']['statusMessage']);
										}
									}
									myMask.hide();
								},
								failure: function(response)
								{
									Ext.MessageBox.alert(addManagerLabel,addExceptionMessage);
									myMask.hide();
								}
							});
						}
						else
						{
							Ext.MessageBox.alert(addManagerLabel,resultJSON['operationStatus']['statusMessage']);
							myMask.hide();
						}
					}
					else
					{
						myMask.hide();
					}
				},
				failure: function(response)
				{
					myMask.hide();
					Ext.MessageBox.alert(addManagerLabel,addExceptionMessage);
				}
			});
		}
	},
	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'ManagersList/data/displayManagers.jsp?operation=displayManagers',
			method: 'POST',
			async: false,
			timeout: 300000,
			success: function( response )
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		var resultsData = publicJSON['managedManagersArray'];
		if (resultsData == null || resultsData.length == 0)
		{
//			var unmanagedManagersArray = publicJSON['unmanagedManagersArray'];
//			if (unmanagedManagersArray != null && unmanagedManagersArray.length > 0)
//			{
//				Ext.getCmp('unmanagedManagersGrid').show();
//				Ext.getCmp('unmanagedManagersGrid').getStore().suspendEvents(true);
//				Ext.getCmp('unmanagedManagersGrid').getStore().loadRawData(unmanagedManagersArray);
//				Ext.getCmp('unmanagedManagersGrid').getStore().resumeEvents();
//
//				Ext.getCmp('managedManagersGrid').hide();
//				Ext.getCmp('noManagersConfigured').hide();
//				Ext.getCmp('unmanagedManagersGrid').show();
//			}
//			else
//			{
				Ext.getCmp('managedManagersGrid').hide();
				Ext.getCmp('noManagersConfigured').show();
//				Ext.getCmp('unmanagedManagersGrid').hide();
//			}
		}
		else
		{
			Ext.getCmp('managedManagersGrid').show();
			Ext.getCmp('noManagersConfigured').hide();
			Ext.getCmp('managedManagersGrid').setTitle(managedManagersLabel);

			Ext.getCmp('managedManagersGrid').getStore().suspendEvents(true);
			Ext.getCmp('managedManagersGrid').getStore().loadRawData(resultsData);
			Ext.getCmp('managedManagersGrid').getStore().resumeEvents();

//			var unmanagedManagersArray = publicJSON['unmanagedManagersArray'];
//			if (unmanagedManagersArray != null && unmanagedManagersArray.length > 0)
//			{
//				Ext.getCmp('unmanagedManagersGrid').show();
//			
//				Ext.getCmp('unmanagedManagersGrid').getStore().suspendEvents(true);
//				Ext.getCmp('unmanagedManagersGrid').getStore().loadRawData(unmanagedManagersArray);
//				Ext.getCmp('unmanagedManagersGrid').getStore().resumeEvents();
//			}
//			else
//			{
//				Ext.getCmp('unmanagedManagersGrid').hide();
//			}
		}
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url: 'ManagersList/data/displayManagers.jsp?managedSearch=true&egTitleSearchStr='+gridsearch,
			method: 'POST',
			timeout: 300000,
			success: function( response )
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var managedManagersFound = false;
					publicJSON = Ext.decode( response.responseText );
					var value = publicJSON['managedManagersArray'];
					if (value != null && value.length > 0)
					{
						managedManagersFound = true;
						Ext.getCmp('managedManagersGrid').setTitle(managedManagersLabel);
						Ext.getCmp('managedManagersGrid').getStore().suspendEvents(true);
						Ext.getCmp('managedManagersGrid').store.loadData(publicJSON['managedManagersArray']);
						Ext.getCmp('managedManagersGrid').getStore().resumeEvents();
					}
					else
					{
						Ext.getCmp('managedManagersGrid').getStore().removeAll();
						var newHeight=(publicJSON.unmanagedManagersFound)?100:300;
						Ext.get("managedMgrId").setHeight(newHeight);

					}
				}
			}
		});
	},
	mainUnmanagedGridSearch : function(obj){
		var gridsearch = Ext.getCmp('unmanagedGridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTriggerunmanaged_0').setStyle('display','none');
			Ext.get('MyTriggerunmanaged_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTriggerunmanaged_1').setStyle('display','none');
			Ext.get('MyTriggerunmanaged_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url: 'ManagersList/data/displayManagers.jsp?unmanagedSearch=true&egTitleSearchStr='+gridsearch,
			method: 'POST',
			timeout: 300000,
			success: function( response )
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					publicJSON = Ext.decode( response.responseText );
					var unmanagedManagersFound = false;
					var unmanaged_value = publicJSON['unmanagedManagersArray'];
					if (unmanaged_value != null && unmanaged_value.length > 0)
					{
						unmanagedManagersFound=true;
						Ext.getCmp('unmanagedManagersGrid').getStore().suspendEvents(true);
						Ext.getCmp('unmanagedManagersGrid').store.loadData(publicJSON['unmanagedManagersArray']);
						Ext.getCmp('unmanagedManagersGrid').getStore().resumeEvents();
					}
					else
					{
						Ext.getCmp('unmanagedManagersGrid').getStore().removeAll();
						var newHeight=(publicJSON.managedManagersFound)?100:300;
						Ext.get("unmanagedMgrId").setHeight(newHeight);
					}
				}
			}
		});
	},
	addNewManager : function()
	{
		managerViewController = this.getController('ManagersList.controller.ManagerViewController');
		Ext.getCmp('viewport').removeAll();
		managerViewController.buildFieldData('ManagersList/data/displayManagers.jsp?operation=addNewManager');
		Ext.getCmp('viewport').add({xtype: 'managerview'});
		managerViewController.afterMainRender('addNewManager','');
	}
});

// check if s_manager_id is valid
function validateManagerId(s_manager_id)
{
	var splChars = "`~!@#$%^&*()+=[]{}|\\:;\"\'<>,?\/";
	if(!checkblank(s_manager_id))
	{
		Ext.MessageBox.alert(addManagerLabel,managerIdEmpty);
		return false;
	}
	else if(!checkspace(s_manager_id))
	{
		return false;
	}
	else if(!checkdots(s_manager_id))
	{
		return false;
	}
	else if(!checkspecial(s_manager_id,splChars))
	{
		return false;
	}
	else if(s_manager_id.toLowerCase()=="supermanager")
	{
		Ext.MessageBox.alert(addManagerLabel,(s_manager_id + ' '+ reseredWord));
		return false;
	}
	return true;
}
function checkblank(str_Value)
{
	if(str_Value.length==0)
	{
		int_Flag=0;
	}
	for(i=1;i<=str_Value.length ;i++)
	{
		if(str_Value.charAt(i-1) == " ")
		{
			int_Flag=0;
		}
		else
		{
			int_Flag = 1;
			break;
		}
	}
	if(int_Flag != 1)
	{
		return false;
	}
	return true;
}
function checkspace(s_val)
{
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			Ext.MessageBox.alert(pageTitle,spaceFound);
			return false;
		}
	}
	return true;
}
function checkdots(fieldvalue)
{
	var val = fieldvalue;
	var name = name;
	if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
	{
		Ext.MessageBox.alert(pageTitle,dot);
		return false;
	}
	else
	{
		for(var k=0;k < val.length;k++)
		{
			if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
			{
				Ext.MessageBox.alert(pageTitle,dotdot);
				return false;
			}
		}
	}
	return true;
}
function checkspecial(obj_val,s_spl)
{
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			Ext.MessageBox.alert(pageTitle,_checkspecial);
			return false;
		}
	}
	return true;
}
function checkValidURLs(str) {
	var pattern = new RegExp('^((https?:)?\\/\\/)?'+ // protocol
	'((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|'+ // domain name
	'((\\d{1,3}\\.){3}\\d{1,3}))'+ // OR ip (v4) address
	'(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*'+ // port and path
	'(\\?[;&a-z\\d%_.~+=-]*)?'+ // query string
	'(\\#[-a-z\\d_]*)?$','i'); // fragment locater
	if (!pattern.test(str))
	{
		if(str.length>0)
		{
			if(str.toLowerCase().indexOf("https://")==0)
			{
				str=str.substring(8);
			}
			else if(str.toLowerCase().indexOf("http://")==0)
			{
				str=str.substring(7);
			}
			if(str.indexOf(':')>0)
			{
				str = str.substring(0,str.indexOf(':'));
			}
			if(str.length>0)
			{
				var val_chars_for_hostname = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-';
				for(var i=0;i<str.length;i++)
				{
					if(val_chars_for_hostname.indexOf(str.charAt(i))==-1)
					{
						return false;
					}
				}
				return true;
			}
		}
		return false;
	}
	else
	{
		return true;
	}
}