Ext.define('ManagersList.controller.ManagerViewController',{
	extend:'Ext.app.Controller',
	views:['ManagerView'],
	refs:[
		{selector:'managerview', ref:'managerview'},
	],
	init:function(){
		this.control({
			'managerview':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildFieldData: function(url){
		var homepage = Ext.getCmp('viewport');
		myMask = new Ext.LoadMask(homepage, {msg:pleaseWait});
		myMask.show();
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				myMask.hide();
			},
			failure: function(response)
			{
				myMask.hide();
			}
		});
	},
	afterMainRender : function(selected_operation,modify)
	{
		if(selected_operation=='addNewManager')
		{
			previous_url = null;
			previous_alturl = null;

			Ext.getCmp('managerview').setTitle(addManagerViewTitle);
			Ext.getCmp('managerId').show();
			Ext.getCmp('displayManagerId').hide();
			Ext.getCmp('createdTime').hide();
			Ext.getCmp('lastAccessedTime').hide();
			Ext.getCmp('modifyManagerBtn').hide();
			Ext.getCmp('addManagerBtn').show();
		}
		else if(selected_operation=='modifyManager')
		{
			Ext.getCmp('addManagerBtn').hide();
			Ext.getCmp('managerview').setTitle(modifyManagerViewTitle);

			previous_url = publicJSON['primaryManager']['primary_url'];
			previous_alturl = publicJSON['primaryManager']['primary_alturl'];

			Ext.getCmp('managerId').hide();
			Ext.getCmp('managerId').setValue(publicJSON['primaryManager']['primary_id']);

			Ext.getCmp('displayManagerId').show();
			Ext.getCmp('displayManagerId').setValue(publicJSON['primaryManager']['primary_id']);

			Ext.getCmp('url').setValue(previous_url);
			Ext.getCmp('alturl').setValue(previous_alturl);

			Ext.getCmp('createdTime').setValue(publicJSON['primaryManager']['primary_createdTime']);
			Ext.getCmp('lastAccessedTime').setValue(publicJSON['primaryManager']['primary_lastAccessedTime']);
			Ext.getCmp('createdTime').show();
			Ext.getCmp('lastAccessedTime').show();

			Ext.getCmp('secondaryManagerGrid').hide();
			if(publicJSON.secondaryManagerFound)
			{
				Ext.getCmp('secondaryManagerGrid').show();
				Ext.getCmp('secondaryManagerGrid').setTitle(publicJSON['screenLabels']['secondaryManagerTitle']);
				var secondaryManagerData = publicJSON['secondaryManager'];
				if (secondaryManagerData != null && secondaryManagerData.length > 0)
				{
					Ext.getCmp('secondaryManagerGrid').show();
					Ext.getCmp('secondaryManagerGrid').getStore().suspendEvents(true);
					Ext.getCmp('secondaryManagerGrid').getStore().loadRawData(secondaryManagerData);
					Ext.getCmp('secondaryManagerGrid').getStore().resumeEvents();
				}
			}
			Ext.getCmp('modifyManagerBtn').show();
		}
	}
});
