Ext.define('ManagersList.view.ConfiguredManagersListView', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.configuredmanagerslistview',
	id: 'configuredManagersList',
	cls:'outerpanel',
	title: pageTitle,
	header:{cls:'textUpper'},
	margin:'8 8 0 8',
	autoScroll: true,
	scroll: true,

	requires: [
		'utilities.CustomGrid',
	],
	dockedItems:[
	{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					html: "<center>"+'<img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle"/>&nbsp;&nbsp;'+pageDesc+"."+"</center>"
				}
			]
	}],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype:'container',
			layout:{
				type:'hbox',
				pack:'center'
			},
			margin: '5 10 0 5',
			items:[
				{
					xtype: 'tbfill'
				},
				{
					xtype: 'button',
					cls:'button20',
					text: addManagerLabel,
					id: 'addManager'
				}
			]
		},
		{
			xtype: 'container',
			id: 'noManagersConfigured',
			hidden:true,
			style:{'border':'2px solid red'},
			flex:1,
			layout: {
				type: 'hbox',
				pack: 'center',
				align:'stretch'
			},
			items: [
				{
					xtype: 'label',
					html: '<table height="100%"><tr><td align="center" height="100%"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/></td></tr><tr><td align="center" class="commonErrorMsgText" height="20px">'+noManagersConfig+'.</td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'managedManagersGrid',
			title: managedManagersLabel,
			scroll: true,
			store:new Ext.data.Store(
			{
				fields: ['managerNickname','managerType','Status'],
				data: []
			}),
			margin: 10,
			emptyText: LoadAlert1,
			viewConfig: {
				deferEmptyText: true
			},
			flex: 1,
			selModel :new Ext.selection.CheckboxModel({
				checkOnly: true,
				width:55,
				injectCheckbox: 'first',
				toggleUiHeader: function(isChecked)
				{
					var view = Ext.getCmp('managedManagersGrid').getView(),
					headerCt = view.headerCt,
					checkHd = headerCt.child('gridcolumn[isCheckerHd]');
					if(checkHd)
					{
						if(isChecked)
						{
							if(checkHd.el != undefined)
								checkHd.el.addCls(this.checkerOnCls);
						}
						else
						{
							if(checkHd.el != undefined)
								checkHd.el.removeCls(this.checkerOnCls);
						}
					}
				}
			}),
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: managerNicknameLabel,
						dataIndex: 'managerNickname',
						width: 350,
						flex:1
					},
					{
						text: managerTypeLabel,
						dataIndex: 'managerType',
						width: 200,
						flex : 0.5
					},
					{
						text: managerStatusLabel,
						dataIndex: 'Status',
						id: 'managerStatus',
						width: 200,
						flex : 0.5,
						renderer: function(value, metaData, record, row, col, store, gridView) {
							if (record.get('Status').indexOf("Running#")==0)
							{
								return '<span ><img src="/final/admin/eg_images/process-on.gif" border="0" vspace="0" title=\"'+managerRunningLabel+'\" style="margin-top:2px"></span>';
							}
							else
							{
								return '<span ><img src="/final/admin/eg_images/process-off.gif" border="0" vspace="0" title=\"'+managerNotRunningLabel+'\" style="margin-top:2px"></span>';
							}
						}
					},
					{
						header : '<div class="iconManage" data-qtip="Configure All" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						id: 'EditOver',
						iconCls: 'iconModify',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.configureOrUnconfigureAllHeaderIconClicked('manage');
							}
						},
						handler: function(grid, rowIndex, colIndex) {
							appCnt.handleEditIconClick(grid, rowIndex, colIndex);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						header : '<div class="iconUnmanage" data-qtip="Unconfigure All" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						id: 'unmanageManager',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.configureOrUnconfigureAllHeaderIconClicked('unmanage');
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							if (record.get('Status').indexOf("#Configured")>0)
							{
								metaData.tdAttr = "data-qtip='Configured' data-qclass='yellowTip'";
								return "<div style='cursor:pointer' onclick=\"javascript:appCnt.handleManageUnmanageIconClick('managedManagersGrid','"+gridView+"','"+row+"','"+col+"')\" class='iconManage'></div>";
							}
							else
							{
								metaData.tdAttr = "data-qtip='Unconfigured' data-qclass='yellowTip'";
								return "<div style='cursor:pointer' onclick=\"javascript:appCnt.handleManageUnmanageIconClick('managedManagersGrid','"+gridView+"','"+row+"','"+col+"')\" class='iconUnmanage'></div>";
							}

						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="'+deleteManagersLabel+'" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						id: 'DeleteOver',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleDeleteSelected('managedManagersGrid');
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+deleteManagerLabel+"' data-qclass='yellowTip'";
							return "<div style='cursor:pointer' onclick=\"javascript:appCnt.handleDeleteIconClick('managedManagersGrid','"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";

						}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					cls:'whitedropdown_search',
					id: 'gridSearch',
					name: 'gridSearch',
					emptyText: 'Search',
					padding: '2 6 2 0',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

					   // TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
					   // single triggerCls config. Should rethink this, perhaps something more structured like a list of
					   // trigger config objects that hold cls, handler, etc.
					   // triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}

					   // Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++)
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						appCnt.mainGridSearch();
					}
				}
			]
		}
	]
});



