Ext.define('ManagersList.view.ManagerView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.managerview',
	id: 'managerview',
	cls:'outerpanel',
	title: addManagerViewTitle,
	header:{cls:'textUpper'},
	margin:'8 8 0 8',
	autoScroll: true,
	scroll: true,

	dockedItems:[
	{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					id:'pagedescriptioncomponent',
					html: "<center>"+'<img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" />&nbsp;&nbsp;'+addOrModifyPageDesc+"."+"</center>"
				}
			]
	}],

	items:[
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			margin: 10,
			items: [
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: managerIdLabel,
					name: 'managerId',
					id: 'managerId',
					maxLength: 32,
					enforceMaxLength: true
				},
				{
					xtype: 'displayfield',
					fieldLabel: managerIdLabel,
					name: 'displayManagerId',
					id: 'displayManagerId',
					value: ' ',
					hidden: true
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: managerURLLabel,
					name: 'url',
					id: 'url'
				},
				{
					xtype: 'textareafield',
					cls:'textbox',
					fieldLabel: alternateURLLabel,
					id: 'alturl',
					name: 'alturl',
					value: 'none'
				},
				{
					xtype: 'displayfield',
					fieldLabel: createdTimeLabel,
					name: 'createdTime',
					id: 'createdTime',
					value: '-',
					hidden: true
				},
				{
					xtype: 'displayfield',
					fieldLabel: lastAccessedTimeLabel,
					name: 'lastAccessedTime',
					id: 'lastAccessedTime',
					value: '-',
					hidden: true
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'customgrid',
					cls:'gridSkin',
					id: 'secondaryManagerGrid',
					hidden: true,
					store:new Ext.data.Store(
					{
						fields: ['secondary_url','secondary_naturl','secondary_status'],
						data: []
					}),
					width: 700,
					margin: 10,
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: false,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: secondaryManagerURLLabel,
								dataIndex: 'secondary_url',
								id: 'secondary_url',
								flex:1
							},
							{
								text: secondaryNatURLLabel,
								dataIndex: 'secondary_naturl',
								id: 'secondary_naturl',
								flex:1
							},
							{
								text: managerStatusLabel,
								dataIndex: 'secondary_status',
								id: 'secondary_status',
								width: 100,
								renderer: function(value, metaData, record, row, col, store, gridView) {
									if (record.get('secondary_status') == "Running")
									{
										return '<left><img src="/final/admin/eg_images/process-on.gif" border="0" vspace="0" title=\"'+managerRunningLabel+'\" height="14"></left>';
									}
									else
									{
										return '<left><img src="/final/admin/eg_images/process-off.gif" border="0" vspace="0" title=\"'+managerNotRunningLabel+'\" height="14"></left>';
									}
								}
							}
						]
					}
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 10 20 10',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: addButtonLabel,
					id: 'addManagerBtn'
				},
				{
					xtype: 'button',
					cls:'button20',
					text: updateButtonLabel,
					id: 'modifyManagerBtn',
					hidden: true
				}
			]
		}
	],

	tools: [
		{
			xtype : 'button',
			cls:'backbutton',
			id : 'backbutton',
			iconCls:'iconBack',
			text : backBtn
		}
	]

});



