Ext.define('NewComponent.controller.MainNode',{
	extend:'Ext.app.Controller',
	views:['ViewWindow','AddNewNodeComponent'],
	requires:['NewComponent.view.IntermediateView','NewComponent.view.ViewWindow','NewComponent.view.AddNewNodeComponent'],
	refs:[
		{selector:'addnewnodecomponent', ref:'addnewnodecomponent'},
		{selector:'intermediateview', ref:'intermediateview'},
		{selector:'scriptDiv', ref:'scriptDiv'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()

		this.control({
			'addnewnodecomponent':
			{
				'boxready': this.afterMainRender
			},
			'addnewnodecomponent combo[id="addCategory"]':
			{
				'select':this.categorySelection
			},
			'addnewnodecomponent combo[id="stype"]':
			{
				'select':this.compTypesSelection
			},
			'addnewnodecomponent combo[id="almode"]':
			{
				'select':this.remoteModeSelection
			},
			'addnewnodecomponent button[id="addButton"]':
			{
				'click':this.addComponent
			},
			'intermediateview button[id="hostCheckUpdate"]':
			{
				'click':this.hostCheckAddComponent
			},
			'intermediateview button[id="hostCheckBack"]':
			{
				'click':this.hostCheckBack
			},
			'addnewnodecomponent button[id="download"]':
			{
				'click':this.download
			},
			'addnewnodecomponent combo[id="alos"]':
			{
				'select':this.remoteOsSelection
			},
			'addnewnodecomponent button[id="backButton"]':
			{
				'click':this.addNewBack
			},
			'addnewnodecomponent combo[id="alencrypt"]':
			{
				'select':this.remoteEncryptSelection
			}
		});
	},
	buildMainData: function()
	{
		var urlStr = 'NewComponent/data/EgNewServerJson.jsp?&serverType='+encodeURIComponent(serverType)+'&selectedServerGroup='+serverCategory;
				
		if (currentAction == 'add')
		{
			urlStr += '&server=new';
		}
		else if (currentAction == 'manage')
		{
			urlStr = "NewComponent/data/EgNewServerJson.jsp?"+qryStr;
		}
		else
		{
			urlStr += '&server='+encodeURIComponent(server)+'&modifyserver=true';
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		jsonDataCache = publicJSON;
	},
	getData: function(urlStr,needToCache)
	{
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
		if (needToCache)
		{
			jsonDataCache = publicJSON;
		}
	},
	afterMainRender : function()
	{
		if(fromTopology=='yes')
		{
			Ext.getCmp('backButton').hide();
			Ext.getCmp('pageDescription').hide();
		}
		if(server=='new'){
			Ext.getCmp('downloadLinkPanel').hide();
			Ext.getCmp('addButton').show();

		}
		else{
			Ext.getCmp('downloadLinkPanel').show();
			Ext.getCmp('includeScript').setValue(nodeScript);
		}

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('addCategory').getStore().clearFilter(true);
						Ext.getCmp('addCategory').getStore().loadRawData(publicJSON.category);
						Ext.getCmp('addCategory').setValue('-1');
						Ext.getCmp('stype').getStore().clearFilter(true);
						Ext.getCmp('stype').getStore().loadRawData(publicJSON.componentTypes);
						Ext.getCmp('stype').setValue('-1');
						Ext.getCmp('addPageContainer').hide();
						Ext.getCmp('buttonContainer').hide();
						return;
					}
				}
			});
		}
		
		Ext.getCmp('addCategory').getStore().clearFilter(true);
		Ext.getCmp('addCategory').getStore().loadRawData(publicJSON.category);
		Ext.getCmp('addCategory').setValue(publicJSON.selectedServerGroup);
		Ext.getCmp('stype').getStore().clearFilter(true);
		Ext.getCmp('stype').getStore().loadRawData(publicJSON.componentTypes);
		Ext.getCmp('stype').setValue(publicJSON.serverType);
		if (publicJSON.serverType == '-1')
		{
			Ext.getCmp('addPageContainer').hide();
			Ext.getCmp('buttonContainer').hide();
			//return;
		}
		else
		{
			Ext.getCmp('addPageContainer').show();
			Ext.getCmp('buttonContainer').show();
		}
		
		Ext.suspendLayouts();
		Ext.getCmp('extAgents').getStore().loadRawData(publicJSON.externalAgents);
		Ext.getCmp('extAgents').setValue(publicJSON.externalAgentsSelected);
		if (compIp != null && compIp != '')
		{
			Ext.getCmp('hostip').setValue(compIp);
		}
		if (compNick != null && compNick != '')
		{
			Ext.getCmp('hostname').setValue(compNick);			
		}
		Ext.getCmp('addPageContainer').show();
		var hideHostIP = publicJSON.hideHostIPField;
		if (hideHostIP == true)
		{
			Ext.getCmp('hostip').hide();
		}
		else
		{
			Ext.getCmp('hostip').show();
		}

		if(publicJSON.serverType == 'Oracle_server')
		{
			Ext.getCmp('sid').show();
			Ext.getCmp('sid').enable();
		}
		else
		{
			Ext.getCmp('sid').hide();
			Ext.getCmp('sid').disable();
		}
		if(publicJSON.mts)
		{
			Ext.getCmp('mtsCheck').show();
			Ext.getCmp('mtsCheck').enable();
		}
		else
		{
			Ext.getCmp('mtsCheck').hide();
			Ext.getCmp('mtsCheck').disable();
		}

		if(publicJSON.portParam)
		{
			Ext.getCmp('sportno').show();
			Ext.getCmp('sportno').enable();
			var portValJson = publicJSON.portValue;
			if(portValJson.indexOf(":") > 0)
			{
				portValJson = portValJson.substring(0,portValJson.indexOf(":"));
			}
			Ext.getCmp('sportno').setValue(portValJson);
		}
		else
		{
			Ext.getCmp('sportno').hide();
			Ext.getCmp('sportno').disable();
		}
		if (publicJSON.isPassiveParam)
		{
			Ext.getCmp('isPassiveCheck').show();
			Ext.getCmp('isPassiveCheck').enable();
		}
		else
		{
			Ext.getCmp('isPassiveCheck').hide();
			Ext.getCmp('isPassiveCheck').disable();
		}
		var isLocal = publicJSON.isLocal;
		if (!isLocal && publicJSON.agentlessOption)
		{
			Ext.getCmp('agentlessCheckGr').show();
			Ext.getCmp('enableRemoteAgent').show();
			Ext.getCmp('enableRemoteAgent').enable();
			
			if (publicJSON.agentlessElement == 'label')
			{
				Ext.getCmp('agentlessCheckGr').show();
				//Ext.getCmp('enableRemoteAgent').disable();
				Ext.getCmp('enableRemoteAgent').setReadOnly(true);
				Ext.getCmp('enableRemoteAgent').setValue(true);
				this.agentlessChange();
				this.remoteModeSelection();
			}
			else
			{
				if (publicJSON.agentlessEnabled == 'checked')
				{
					agentLess="true";
					Ext.getCmp('agentlessCheckGr').show();
					Ext.getCmp('enableRemoteAgent').setReadOnly(false);
					Ext.getCmp('enableRemoteAgent').setValue(true);
					this.agentlessChange();
					this.remoteModeSelection();
				}
				else
				{
					agentLess="false";
					Ext.getCmp('agentlessCheckGr').show();
					Ext.getCmp('enableRemoteAgent').setReadOnly(false);
					Ext.getCmp('enableRemoteAgent').setValue(false);
					Ext.getCmp('alos').hide();
					Ext.getCmp('alos').disable();
					Ext.getCmp('almode').hide();
					Ext.getCmp('almode').disable();
					Ext.getCmp('remoteAgent').hide();
					Ext.getCmp('remoteAgent').disable();
					Ext.getCmp('sshPort').hide();
					Ext.getCmp('sshPort').disable();
					Ext.getCmp('aluser').hide();
					Ext.getCmp('aluser').disable();
					Ext.getCmp('alpwd').hide();
					Ext.getCmp('alpwd').disable();
					Ext.getCmp('alencrypt').hide();
					Ext.getCmp('alencrypt').disable();
					Ext.getCmp('alkeyfile').hide();
					Ext.getCmp('alkeyfile').disable();
				}
			}
		}
		else
		{
			Ext.getCmp('agentlessCheckGr').hide();
			Ext.getCmp('enableRemoteAgent').hide();
			Ext.getCmp('enableRemoteAgent').disable();
			Ext.getCmp('alos').hide();
			Ext.getCmp('alos').disable();
			Ext.getCmp('almode').hide();
			Ext.getCmp('almode').disable();
			Ext.getCmp('remoteAgent').hide();
			Ext.getCmp('remoteAgent').disable();
			Ext.getCmp('sshPort').hide();
			Ext.getCmp('sshPort').disable();
			Ext.getCmp('aluser').hide();
			Ext.getCmp('aluser').disable();
			Ext.getCmp('alpwd').hide();
			Ext.getCmp('alpwd').disable();
			Ext.getCmp('alencrypt').hide();
			Ext.getCmp('alencrypt').disable();
			Ext.getCmp('alkeyfile').hide();
			Ext.getCmp('alkeyfile').disable();
		}
		
		if(!isLocal && publicJSON.internalAgentOption)
		{
			Ext.getCmp('intAgentModeGr').show();
			Ext.getCmp('intAgentModeGr').enable();
			Ext.getCmp('intAgentAuto').setValue(true);
			Ext.getCmp('currAgents').hide();
			Ext.getCmp('currAgents').disable();
		}
		else
		{
			Ext.getCmp('intAgentModeGr').hide();
			Ext.getCmp('intAgentModeGr').disable();
			Ext.getCmp('currAgents').hide();
			Ext.getCmp('currAgents').disable();
		}

		if(publicJSON.cloudEnv)
		{
			if (Ext.getCmp('cloudVirtual').isDisabled())
			{
				Ext.getCmp('cloudVirtual').show();
				Ext.getCmp('cloudVirtual').enable();
			}
			Ext.getCmp('underCloudCheck').show();
			Ext.getCmp('underCloudCheck').enable();
			
			Ext.getCmp('cloudServer').getStore().loadRawData(publicJSON.cloudServers);
			Ext.getCmp('cloudServer').setValue(publicJSON.cloudServerSelected);
		}
		if (publicJSON.virtualEnv)
		{
			if (Ext.getCmp('cloudVirtual').isDisabled())
			{
				Ext.getCmp('cloudVirtual').show();
				Ext.getCmp('cloudVirtual').enable();
			}
			Ext.getCmp('underVmwareCheck').show();
			Ext.getCmp('underVmwareCheck').enable();

			Ext.getCmp('esxServer').getStore().loadRawData(publicJSON.virtualServers);
			Ext.getCmp('esxServer').setValue(publicJSON.virtualServerSelected);
		}

		//Modify server
		if(currentAction == 'modify')
		{
			Ext.getCmp('addCategory').setReadOnly(true);
			Ext.getCmp('stype').setReadOnly(true);
			Ext.getCmp('hostip').setValue(publicJSON.hostIPValue);
			Ext.getCmp('hostip').setReadOnly(true);
			Ext.getCmp('hostname').setValue(publicJSON.hostname);
			if (publicJSON.sidParam)
			{
				Ext.getCmp('sid').setValue(publicJSON.sidValue);
			}
			if(publicJSON.isPassiveParam)
			{
				if(publicJSON.isPassiveEnabled == "checked")
				{
					Ext.getCmp('isPassive').setValue(true);
				}
				else if(publicJSON.isPassiveDisabled == "checked")
				{
					Ext.getCmp('isPassive').setValue(false);
				}
			}
			if (publicJSON.agentlessEnabled == 'checked' || publicJSON.agentlessElement == 'label')
			{
				Ext.getCmp('agentlessCheckGr').show();
				var enaRemAgt = Ext.getCmp('enableRemoteAgent');
				enaRemAgt.show();
				enaRemAgt.enable();						
				enaRemAgt.setValue(true);
				if (publicJSON.agentlessElement == 'label')
				{
					enaRemAgt.setReadOnly(true);
				}
				Ext.getCmp('alos').show();
				Ext.getCmp('alos').enable();
				Ext.getCmp('almode').show();
				Ext.getCmp('almode').enable();
				if (publicJSON.rmtPortOption)
				{
					if (publicJSON.rmtEncryptionType)
					{
						var encObj = Ext.getCmp('alencrypt');
						encObj.show();
						encObj.enable();
						encObj.getStore().loadRawData(publicJSON.rmtEncryptOpts);
						encObj.setValue(publicJSON.rmtEncryptSelected);
					}
					if (publicJSON.rmtKeyFile)
					{
						var txtObj = Ext.getCmp('alkeyfile');
						txtObj.show();
						txtObj.enable();
						txtObj.setValue(publicJSON.rmtKeyFileValue);
					}
					var sshPortObj = Ext.getCmp('sshPort');
					var alUsrObj = Ext.getCmp('aluser');
					var alPwdObj = Ext.getCmp('alpwd');

					sshPortObj.show();
					sshPortObj.enable(); 
					sshPortObj.setValue(publicJSON.rmtPortValue);
					alUsrObj.show();
					alUsrObj.enable(); 
					alUsrObj.setValue(publicJSON.rmtUserValue);
					alPwdObj.show();
					alPwdObj.enable(); 
					alPwdObj.setValue(publicJSON.rmtPwdValue);
				}
				Ext.getCmp('remoteAgent').show();
				Ext.getCmp('remoteAgent').enable();
				Ext.getCmp('alos').getStore().loadRawData(publicJSON.rmtOS);
				Ext.getCmp('alos').setValue(publicJSON.rmtOSSelected);
				Ext.getCmp('almode').getStore().loadRawData(publicJSON.rmtMode);
				Ext.getCmp('almode').setValue(publicJSON.rmtModeSelected);
				Ext.getCmp('remoteAgent').getStore().loadRawData(publicJSON.remoteAgentsList);
				Ext.getCmp('remoteAgent').setValue(publicJSON.remoteAgentSelected);				
				oldRemoteAgent=publicJSON.remoteAgentSelected;
			}
			if (publicJSON.internalAgentManual == 'checked')
			{
				Ext.getCmp('intAgentModeGr').show();
				Ext.getCmp('intAgentModeGr').enable();
				Ext.getCmp('intAgentManual').setValue(true);
				var intAgentsObj = Ext.getCmp('currAgents');
				intAgentsObj.show();
				intAgentsObj.enable();
				intAgentsObj.getStore().loadRawData(publicJSON.internalAgents);
				intAgentsObj.setValue(publicJSON.internalAgentSelected);
			}
			else if (publicJSON.internalAgentAuto == 'checked')
			{
				Ext.getCmp('intAgentModeGr').show();
				Ext.getCmp('intAgentModeGr').enable();
				Ext.getCmp('intAgentAuto').setValue(true);
				Ext.getCmp('currAgents').hide();
				Ext.getCmp('currAgents').disable();
			}
			if(publicJSON.cloudEnv)
			{
				if (publicJSON.cloudEnvEnabled == "Yes")
				{
					Ext.getCmp('underCloud').setValue(true);
					var cludObj = Ext.getCmp('cloudServer');
					cludObj.show();
					cludObj.enable();
					cludObj.getStore().loadRawData(publicJSON.cloudServers);
					cludObj.setValue(publicJSON.cloudServerSelected);
				}				
			}
			if (publicJSON.virtualEnv)
			{
				if (publicJSON.virtualEnvEnabled == "Yes")
				{
					Ext.getCmp('underVmware').setValue(true);
					var esxObj = Ext.getCmp('esxServer');
					esxObj.show();
					esxObj.enable();
					esxObj.getStore().loadRawData(publicJSON.virtualServers);
					esxObj.setValue(publicJSON.virtualServerSelected);
				}
			}
			if (publicJSON.mts)
			{
				Ext.getCmp('mts').show();
				Ext.getCmp('mts').disable();
				if (publicJSON.mtsEnabled == "checked")
				{
					Ext.getCmp('mts').setValue(true);
				}
				else
				{
					Ext.getCmp('mts').setValue(false);
				}
			}
			Ext.getCmp('addButton').setText(label_Update);
		}

		//Manage server - Home>Discovery Pop-up
		if(currentAction == 'manage')
		{
			if(publicJSON.serverType == 'Real_user_monitor')
			{
				Ext.getCmp('rumNickName').setValue(publicJSON.hostname);
			}
			Ext.getCmp('hostip').setValue(publicJSON.hostIPValue);
			Ext.getCmp('hostname').setValue(publicJSON.hostname);
			if (publicJSON.sidParam)
			{
				var portValJson = publicJSON.portValue;
				var sidValJson = "";
				if(portValJson.indexOf(":") > 0 && publicJSON.serverType == 'Oracle_server')
				{
					sidValJson = portValJson.substring(portValJson.indexOf(":")+1,portValJson.length);
					Ext.getCmp('sid').setValue(sidValJson);
				}
				else
				{
					Ext.getCmp('sid').setValue(publicJSON.sidValue);
				}
			}
			if (publicJSON.agentlessEnabled == 'checked')
			{
				Ext.getCmp('agentlessCheckGr').show();
				Ext.getCmp('enableRemoteAgent').show();
				Ext.getCmp('enableRemoteAgent').enable();
						
				Ext.getCmp('enableRemoteAgent').setValue(true);
				Ext.getCmp('alos').show();
				Ext.getCmp('alos').enable();
				Ext.getCmp('almode').show();
				Ext.getCmp('almode').enable();
				if (publicJSON.rmtPortOption)
				{
					if (publicJSON.rmtEncryptionType)
					{
						var encObj = Ext.getCmp('alencrypt');
						encObj.show();
						encObj.enable();
						encObj.getStore().loadRawData(publicJSON.rmtEncryptOpts);
						encObj.setValue(publicJSON.rmtEncryptSelected);
					}
					Ext.getCmp('sshPort').show();
					Ext.getCmp('sshPort').enable(); 
					Ext.getCmp('sshPort').setValue(publicJSON.rmtPortValue);
					Ext.getCmp('aluser').show();
					Ext.getCmp('aluser').enable(); 
					Ext.getCmp('aluser').setValue(publicJSON.rmtUserValue);
					Ext.getCmp('alpwd').show();
					Ext.getCmp('alpwd').enable(); 
					Ext.getCmp('alpwd').setValue(publicJSON.rmtPwdValue);
				}
				Ext.getCmp('remoteAgent').show();
				Ext.getCmp('remoteAgent').enable();
				Ext.getCmp('alos').getStore().loadRawData(publicJSON.rmtOS);
				Ext.getCmp('alos').setValue(publicJSON.rmtOSSelected);
				Ext.getCmp('almode').getStore().loadRawData(publicJSON.rmtMode);
				Ext.getCmp('almode').setValue(publicJSON.rmtModeSelected);
				Ext.getCmp('remoteAgent').getStore().loadRawData(publicJSON.remoteAgentsList);
				Ext.getCmp('remoteAgent').setValue(publicJSON.remoteAgentSelected);
				oldRemoteAgent=publicJSON.remoteAgentSelected;
			}
		}
		Ext.resumeLayouts(true);
	},
	addNewBack: function()
	{
		if (fromAPP == "NotificationManager")
		{
			window.location.href = "/final/admin/EgViewManagerNotificationDetails.jsp?type="+requestType;
		}
		else if (fromAPP == 'ManUnmanSystems')
		{
			window.location.href = "/final/admin/EgManageServers.jsp?nick="+encodeURIComponent(compNick);
		}
		else
		{
			var tmpURL = backHref;
			var idx = tmpURL.indexOf("?");
			if (idx > -1)
			{
				tmpURL = tmpURL.substring(0,idx);
			}
			tmpURL+="?category="+serverCategory+"&comptype="+encodeURIComponent(serverType);
			window.location.href = tmpURL;
		}
	},
	categorySelection: function ()
	{
		var selectedCategory = Ext.getCmp('addCategory').getValue();
		var url = 'NewComponent/data/EgNewServerJson.jsp?selectedServerGroup='+selectedCategory;
		this.getData(url);
		var comboObj = Ext.getCmp('stype').getStore();
		comboObj.removeAll();
		comboObj.clearFilter(true);
		comboObj.loadRawData(publicJSON.componentTypes);
		Ext.getCmp('stype').setValue("-1");

		Ext.getCmp('addPageContainer').hide();
		Ext.getCmp('buttonContainer').hide();
	},
	compTypesSelection: function ()
	{
		var selectedCType = Ext.getCmp('stype').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory = Ext.getCmp('addCategory').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		if (selectedCType == -1)
		{
			Ext.getCmp('addPageContainer').hide();
			Ext.getCmp('buttonContainer').hide();
			Ext.Msg.show({
				title: addButtonText,
				msg: alertMsg32,
				buttons: Ext.Msg.OK,
				width: 300,
				icon: 'iconExclamation'
			});
			return;
		}
		var url = 'NewComponent/data/EgNewServerJson.jsp?selectedServerGroup='+selectedCategory+"&server=new&serverType="+selectedCType;
		
			this.getData(url,true);
			Ext.getCmp('addPageContainer').show();
			Ext.getCmp('buttonContainer').show();
			this.afterMainRender();
	},
	agentlessChange : function()
	{
		var opt = Ext.getCmp("enableRemoteAgent").getValue();
		var compNickVal = Ext.getCmp('hostname').getValue();
		if (opt && this.validateHostNameWithRemote(compNickVal))
		{
			Ext.getCmp("enableRemoteAgent").setValue(false);
			return false;
		}
		var selectedCType = Ext.getCmp('stype').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('addCategory').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		var urlStr = "NewComponent/data/EgNewServerJson.jsp?&selectedServerGroup="+selectedCategory+"&serverType="+selectedCType+"&server=new&from=addnew";
		urlStr+="&enableRemoteAgent="+opt;
		if (currentAction == 'manage')
		{
			urlStr = "NewComponent/data/EgNewServerJson.jsp?&selectedServerGroup="+selectedCategory+"&serverType="+selectedCType+"&enableRemoteAgent="+opt+"&from=addnew";
			urlStr += "&"+qryStr;
		}
		else if (currentAction == 'modify')
		{
			urlStr = "NewComponent/data/EgNewServerJson.jsp?&selectedServerGroup="+selectedCategory+"&serverType="+selectedCType+"&enableRemoteAgent="+opt;
			urlStr += '&server='+encodeURIComponent(server)+'&modifyserver=true';
		}
	
		this.getData(urlStr);
		var isLocal = publicJSON.isLocal;
		if (opt)
		{
			Ext.getCmp('intAgentModeGr').hide();
			Ext.getCmp('intAgentModeGr').disable();
			Ext.getCmp('currAgents').hide();
			Ext.getCmp('currAgents').disable();

			Ext.getCmp('alos').show();
			Ext.getCmp('alos').enable();
			Ext.getCmp('alos').getStore().loadRawData(publicJSON.rmtOS);
			Ext.getCmp('alos').setValue(publicJSON.rmtOSSelected);
			Ext.getCmp('almode').show();
			Ext.getCmp('almode').enable();
			Ext.getCmp('almode').getStore().loadRawData(publicJSON.rmtMode);
			Ext.getCmp('almode').setValue(publicJSON.rmtModeSelected);
			Ext.getCmp('remoteAgent').show();
			Ext.getCmp('remoteAgent').enable();
			Ext.getCmp('remoteAgent').getStore().loadRawData(publicJSON.remoteAgentsList);
			Ext.getCmp('remoteAgent').setValue(publicJSON.remoteAgentSelected);
			oldRemoteAgent=publicJSON.remoteAgentSelected;
			if (publicJSON.agentlessEnabled == 'checked')
			{
				this.remoteModeSelection();
			}
		}
		else
		{
			Ext.getCmp('alos').hide();
			Ext.getCmp('alos').disable();
			Ext.getCmp('almode').hide();
			Ext.getCmp('almode').disable();
			Ext.getCmp('remoteAgent').hide();
			Ext.getCmp('remoteAgent').disable();
			if (!Ext.getCmp('sshPort').isDisabled())
			{
				Ext.getCmp('sshPort').hide();
				Ext.getCmp('sshPort').disable();
				Ext.getCmp('aluser').hide();
				Ext.getCmp('aluser').disable();
				Ext.getCmp('alpwd').hide();
				Ext.getCmp('alpwd').disable();
			}	

			if(!isLocal && publicJSON.internalAgentOption)
			{
				Ext.getCmp('intAgentModeGr').show();
				Ext.getCmp('intAgentModeGr').enable();
				Ext.getCmp('intAgentAuto').setValue(true);
			}
			
			var encObj = Ext.getCmp('alencrypt');
			encObj.hide();
			encObj.disable();
			var txtObj = Ext.getCmp('alkeyfile');
			txtObj.hide();
			txtObj.disable();
		}
		nodeOnChange();
	},
	remoteModeSelection : function()
	{
		var mode = Ext.getCmp('almode').getValue();
		var sshObj = Ext.getCmp('sshPort');
		var alUsrObj = Ext.getCmp('aluser');
		var alPwdObj = Ext.getCmp('alpwd');
		var encrtObj = Ext.getCmp('alencrypt');
		var textObj = Ext.getCmp('alkeyfile');

		if (mode == 'Rexec')
		{
			sshObj.show();
			sshObj.enable();
			sshObj.setValue('512');

			alUsrObj.show();
			alUsrObj.enable();
			alUsrObj.setValue('None');

			alPwdObj.show();
			alPwdObj.enable();
			alPwdObj.setValue('None');

			encrtObj.hide();
			encrtObj.disable();

			textObj.hide();
			textObj.disable();
		}
		else if(mode == 'SSH')
		{
			encrtObj.show();
			encrtObj.enable();
			encrtObj.getStore().loadRawData(publicJSON.rmtEncryptOpts);
			encrtObj.setValue(publicJSON.rmtEncryptSelected);

			sshObj.show();
			sshObj.enable();
			sshObj.setValue('22');

			alUsrObj.show();
			alUsrObj.enable();
			alUsrObj.setValue('None');

			alPwdObj.show();
			alPwdObj.enable();
			alPwdObj.setValue('None');
		}else
		{
			encrtObj.hide();
			encrtObj.disable();
			sshObj.hide();
			sshObj.disable();
			alUsrObj.hide();
			alUsrObj.disable();
			alPwdObj.hide();
			alPwdObj.disable();
		}
	},
	remoteOsSelection : function()
	{
		var rmtOs = Ext.getCmp('alos').getValue();
		var encrtObj = Ext.getCmp('alencrypt');
		var textObj = Ext.getCmp('alkeyfile');

		if(rmtOs=='other')
		{
			Ext.getCmp('almode').setValue('SNMP');
		}
		else if(rmtOs == 'vmware' || rmtOs == 'xen')
		{
			Ext.getCmp('almode').setValue('Other');
		}
		else if (rmtOs != 'None' && rmtOs != "nt" && rmtOs != "2003" && rmtOs != "2008"	&& rmtOs != "w2k"
				&& rmtOs != "xp" && rmtOs != "2012"	 && rmtOs != "2016" && rmtOs != "win7" && rmtOs != "win8" && rmtOs != "win10")
		{
			if (rmtOs == 'SSH')
			{
				encrtObj.show();
				encrtObj.enable();
			}else
			{
				encrtObj.hide();
				encrtObj.disable();
				textObj.hide();
				textObj.disable();
			}
			Ext.getCmp('almode').setValue('Rexec');
			Ext.getCmp('sshPort').show();
			Ext.getCmp('sshPort').enable();
			Ext.getCmp('sshPort').setValue('512');

			Ext.getCmp('aluser').show();
			Ext.getCmp('aluser').enable();
			Ext.getCmp('aluser').setValue('None');

			Ext.getCmp('alpwd').show();
			Ext.getCmp('alpwd').enable();
			Ext.getCmp('alpwd').setValue('None');
		}
		else if (rmtOs != 'None' && (rmtOs == "nt" || rmtOs == "2003" || rmtOs == "2008" || rmtOs == "w2k"
				|| rmtOs == "xp" || rmtOs == "2012" || rmtOs == "2016" || rmtOs == "win7"	|| rmtOs == "win8" || rmtOs == "win10"))
		{
			Ext.getCmp('almode').setValue('Perfmon');

			Ext.getCmp('sshPort').hide();
			Ext.getCmp('sshPort').disable();
			Ext.getCmp('aluser').hide();
			Ext.getCmp('aluser').disable();
			Ext.getCmp('alpwd').hide();
			Ext.getCmp('alpwd').disable();
			encrtObj.hide();
			encrtObj.disable();
			textObj.hide();
			textObj.disable();
		}
		else if (rmtOs == 'None')
		{
			Ext.getCmp('almode').setValue('None');

			Ext.getCmp('sshPort').hide();
			Ext.getCmp('sshPort').disable();
			Ext.getCmp('aluser').hide();
			Ext.getCmp('aluser').disable();
			Ext.getCmp('alpwd').hide();
			Ext.getCmp('alpwd').disable();
			encrtObj.hide();
			encrtObj.disable();
			textObj.hide();
			textObj.disable();
		}
	},
	remoteEncryptSelection: function()
	{
		var selVal = Ext.getCmp('alencrypt').getValue();
		var textObj = Ext.getCmp('alkeyfile');
		if (selVal == 'Keybased')
		{
			textObj.show();
			textObj.enable();
		}
		else
		{
			textObj.hide();
			textObj.disable();
		}
	},
	internalAssignChange : function()
	{
		var opt = Ext.getCmp('intAgentAuto').getValue();
		var  intOpt = 'auto';
		if(!opt)
		{
			intOpt = 'manual';
		}
		var selectedCType = Ext.getCmp('stype').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('addCategory').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		var urlStr = "NewComponent/data/EgNewServerJson.jsp?agentmap="+intOpt+"&enableRemoteAgent=false&selectedServerGroup="+selectedCategory+"&serverType="+selectedCType+"&server=new&from=addnew";

		if (currentAction == 'manage')
		{
			urlStr += "&"+qryStr;
		}
		else if (currentAction == 'modify')
		{
			urlStr = "NewComponent/data/EgNewServerJson.jsp?agentmap="+intOpt+"&enableRemoteAgent=false&selectedServerGroup="+selectedCategory+"&serverType="+selectedCType;
			urlStr += '&server='+encodeURIComponent(server)+'&modifyserver=true';
		}


		this.getData(urlStr);
		if(!opt)
		{
			Ext.getCmp('currAgents').show();
			Ext.getCmp('currAgents').enable();
			Ext.getCmp('currAgents').getStore().loadRawData(publicJSON.internalAgents);
			Ext.getCmp('currAgents').setValue(publicJSON.internalAgentSelected);
		}
		else
		{
			Ext.getCmp('currAgents').hide();
			Ext.getCmp('currAgents').disable();
		}

	},
	virtualEnvChange : function()
	{
		var  virtualSelected = 'false';
		if(Ext.getCmp('underVmware').getValue())
		{
			virtualSelected = 'true';
			var selectedCType = Ext.getCmp('stype').getValue();
			selectedCType = encodeURIComponent(selectedCType);
			var selectedCategory =	Ext.getCmp('addCategory').getValue();
			selectedCategory = encodeURIComponent(selectedCategory);
			var urlStr = "NewComponent/data/EgNewServerJson.jsp?underVmware="+virtualSelected+"&selectedServerGroup="+selectedCategory+"&serverType="+selectedCType+"&server=new&from=addnew";
			this.getData(urlStr);
			Ext.getCmp('esxServer').show();
			Ext.getCmp('esxServer').enable();
			Ext.getCmp('esxServer').getStore().loadRawData(publicJSON.virtualServers);
			Ext.getCmp('esxServer').setValue(publicJSON.virtualServerSelected);
		}
		else
		{
			Ext.getCmp('esxServer').hide();
			Ext.getCmp('esxServer').disable();
		}
	},
	cloundEnvChange : function()
	{
		var  cloudSelected = 'false';
		if(Ext.getCmp('underCloud').getValue())
		{
			cloudSelected = 'true';
			var selectedCType = Ext.getCmp('stype').getValue();
			selectedCType = encodeURIComponent(selectedCType);
			var selectedCategory =	Ext.getCmp('addCategory').getValue();
			selectedCategory = encodeURIComponent(selectedCategory);
			var urlStr = "NewComponent/data/EgNewServerJson.jsp?underCloud="+cloudSelected+"&selectedServerGroup="+selectedCategory+"&serverType="+selectedCType+"&server=new&from=addnew";
			this.getData(urlStr);
			Ext.getCmp('cloudServer').show();
			Ext.getCmp('cloudServer').enable();
			Ext.getCmp('cloudServer').getStore().loadRawData(publicJSON.cloudServers);
			Ext.getCmp('cloudServer').setValue(publicJSON.cloudServerSelected);
		}
		else
		{
			Ext.getCmp('cloudServer').hide();
			Ext.getCmp('cloudServer').disable();
		}
	},
	addComponent : function(button)
	{
		var isValid = this.addComponentValidation();
		if (!isValid)
		{
			return;
		}
	},
	actualAdd: function()
	{
		var me= this;
		var allow = true;
		var selCType = Ext.getCmp('stype').getValue();
		var parameters = '';
		me.addServerComponent(allow, ' ');
	},
	addServerComponent : function(allow, params)
	{
		var parameters = params;
		var selCType = Ext.getCmp('stype').getValue();
		if(allow)
		{
			var mainObj = this;
			var urlStr = "/final/admin/NewComponent/data/EgHostCheckJson.jsp?strPass=&from=addNew&server=new&isAggregateType=false";
			if (currentAction == 'modify')
			{
				urlStr = "/final/admin/NewComponent/data/EgHostCheckJson.jsp?isAggregateType=false&modifyserver=true";
			}
			if(fromTopology!=null && fromTopology=='yes')
			{
				urlStr += "&frmTopology="+fromTopology+"&topoSegName=Topo_Auto&frmPage="+frmPage;
			}
			var hiddenParams = publicJSON.hiddenVals;
			if(selCType == 'Real_user_monitor')
			{
				urlStr += parameters;
				hiddenParams = rumHiddenField;
			}
			var me = Ext.getCmp('hiddenContnr');
			me.removeAll();
			Ext.suspendLayouts();
			for (var param in hiddenParams) {
					me.add({
						xtype: 'hidden',
						name: param,
						value: hiddenParams[param]
					});
			}
			Ext.resumeLayouts(true);
			
			var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
			tmpMask.show();
		
			this.getAddnewnodecomponent().submit({			
				url: urlStr,
				method: 'POST',
				timeout: 120,
				success: function(form, action){
					tmpMask.hide();
					var resObj  = action.response.responseText;
					publicJSON = Ext.decode(resObj);
					var requestStatus = publicJSON.requestStatus;
					
					if (requestStatus=='failed')
					{
						if(publicJSON.error_type=='alert')
						{
							Ext.Msg.show({
								title: publicJSON.error_Info.error_Title,
								msg: alertMsg33+'<br>'+publicJSON.error_Info.error_Msg_1+'<br>'+publicJSON.error_Info.error_Msg_2,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							publicJSON = jsonDataCache;
						}else if (publicJSON.error_type=='radio')
						{
							var mainContainerObj = Ext.getCmp('newcomponentview');
							mainContainerObj.removeAll();
							mainContainerObj.add({
								xtype : 'intermediateview'
							});
							Ext.getCmp('intermediategrid').setTitle(publicJSON.main_Msg_Title);
							Ext.getCmp('intermediategrid').getStore().loadRawData(publicJSON.gridData);

							var radio1Obj = Ext.getCmp('radioOne');
							var radio2Obj = Ext.getCmp('radioTwo');
							Ext.getCmp('radioOpts').setFieldLabel(publicJSON.radio_Msg_Title);
							radio1Obj.boxLabelEl.update(publicJSON.radio1_Msg);
							radio2Obj.boxLabelEl.update(publicJSON.radio2_Msg);
							
							radio1Obj.inputValue = publicJSON.radio1_value;
							radio2Obj.enable();
							if (publicJSON.radio2_enable == 'disabled')
							{
								radio2Obj.disable();
							}
							
							if (publicJSON.radio1_checked)
							{
								radio1Obj.setValue(true);
							}
						}
						else if (publicJSON.error_type=='confirm')
						{
							Ext.Msg.show({
								title: publicJSON.error_Info.error_Title,
								msg: publicJSON.error_Info.error_Msg_1+"<br>Host IP/Name : "+publicJSON.error_Info.IP+"<br>Nick name : "+publicJSON.error_Info.nickName+'<br>'+publicJSON.error_Info.error_Msg_2,
								buttons: Ext.Msg.YESNO,
								icon: 'iconConfirmation',
								fn: function(response) {
									if(response == 'yes') 
									{
										var forwardURL = publicJSON.error_Info.forward_URL;
										var oldIP = publicJSON.error_Info.IP;
										var oldNick = publicJSON.error_Info.nickName;
										var hiddenParams = publicJSON.hiddenValues;
										var me = Ext.getCmp('hiddenContnr');
										me.removeAll();
										Ext.suspendLayouts();
										for (var param in hiddenParams) {
											var paramVal = hiddenParams[param];
											if (param == 'hostip')
											{
												paramVal = oldIP;
											}
											else if (param == 'hostname')
											{
												paramVal = oldNick;
											}
											me.add({
												xtype: 'hidden',
												name: param,
												value: paramVal
											});
										}
										Ext.resumeLayouts(true);
										forwardURL ="/final/admin/NewComponent/data/"+forwardURL;
										mainObj.forwardGivenURL(forwardURL);									
									}
									else
									{
										//Ext.getCmp('hostip').setValue("");
										Ext.getCmp('hostname').setValue("");
										//ctrler.compTypesSelection();
										var selectedCType = encodeURIComponent(selCType);
										var selectedCategory = Ext.getCmp('addCategory').getValue();
										selectedCategory = encodeURIComponent(selectedCategory);
										var url = 'NewComponent/data/EgNewServerJson.jsp?selectedServerGroup='+selectedCategory+"&server=new&serverType="+selectedCType;
										ctrler.getData(url,true);
									}
								}
							});
						}
					}
					else if (requestStatus=='success')
					{
						if (publicJSON.forward)
						{
							var forwardURL = publicJSON.forward_URL;
							var hiddenParams = publicJSON.hiddenValues;
							var me = Ext.getCmp('hiddenContnr');
							me.removeAll();
							Ext.suspendLayouts();
							for (var param in hiddenParams) {
									me.add({
										xtype: 'hidden',
										name: param,
										value: hiddenParams[param]
									});
							}
							Ext.resumeLayouts(true);
							forwardURL ="/final/admin/NewComponent/data/"+forwardURL;
							mainObj.forwardGivenURL(forwardURL);
						}
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					 tmpMask.hide();
					 switch (action.failureType) {
						case Ext.form.action.Action.CLIENT_INVALID:
							Ext.Msg.alert('Failure', alertMsg33+'. Form fields may not be submitted with invalid values');
							break;
						case Ext.form.action.Action.CONNECT_FAILURE:
							Ext.Msg.alert('Failure', alertMsg33+'. Ajax communication failed');
							break;
						case Ext.form.action.Action.SERVER_INVALID:
						   Ext.Msg.alert('Failure', alertMsg33+'. '+action.result.msg);
					}
				}
			});
		}
	},
	forwardGivenURL : function(forwardURL)
	{
		var parentWindow = window.parent;
		var resMsg = alertMsg34;
		if (currentAction == 'modify')
		{
			resMsg = alertMsg35;
		}
		var thisCtrl = this;
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAddnewnodecomponent().submit({
				url: forwardURL,
				method: 'POST',
				timeout: 120,
				//standardSubmit:true,
				success: function(form, action){
				tmpMask.hide();
				var resObj  = action.response.responseText;
				var publicJSON = Ext.decode(resObj);
				var requestStatus = publicJSON['requestStatus'];
				if(requestStatus == 'success')
				{
					if(fromTopology=='yes')
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: alertMsg42,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									parentWindow.closedManagedWindow();
								}
							}
						});
					}
					else
					{
						var cType = publicJSON.compType;
						var hostName=publicJSON.hostName;
						var portValue=publicJSON.portNo;
						var nodeGUID=publicJSON.nodeGUID;
						var agentHostIP=publicJSON.agentHostIP;
						var agentless=Ext.getCmp('enableRemoteAgent').getValue();
						var oldRemoteAgent=Ext.getCmp('remoteAgent').getValue();
						if (currentAction == 'modify')
						{
							Ext.Msg.show({
								title: pageTitle,
							msg: alertMsg35+'\nPlease download the agent file for this component and deploy it in the corresponding application.',
							buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function(response) {
								if(response == 'ok')
									{
									window.location.href = "EgNewServer.jsp?serverType=NodeJS&modifyserver=true&serverGategory=-1&hostName="+hostName+"&portValue="+portValue+"&nodeGUID="+nodeGUID+"&agentHostIP="+agentHostIP+"&agentLess="+agentless+"&oldRemoteAgent="+oldRemoteAgent;
									}
									}
							});
						}
						else
						{
							Ext.Msg.show({
								title: pageTitle,
							msg: alertMsg34+'\nPlease download the agent file for this component and deploy it in the corresponding application.',
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
								fn: function(response) {
								if(response == 'ok')
									{
									window.location.href = "EgNewServer.jsp?serverType=NodeJS&modifyserver=true&serverGategory=-1&hostName="+hostName+"&portValue="+portValue+"&nodeGUID="+nodeGUID+"&agentHostIP="+agentHostIP+"&agentLess="+agentless+"&oldRemoteAgent="+oldRemoteAgent;
									}
								}
							});
						}
					}
				}
				else if (requestStatus == 'failed')
				{
					var resObj  = action.response.responseText;
					var publicJSON = Ext.decode(resObj);
					var requestStatus = publicJSON['requestStatus'];
					Ext.Msg.show({
						title:publicJSON.Error_Title,
						msg: alertMsg33 + '<br>' + publicJSON.Error_Info.Error_Msg_1 + '<br>' + publicJSON.Error_Info.Error_Msg_2,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								if(fromTopology=='yes')
								{
									parentWindow.closedManagedWindow();
								}
								else
								{
									var url = '/final/admin/EgDispServer.jsp?&category=-1&comptype=-1';
									window.location.href = url;
								}
							}
						}
					});
				}
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				tmpMask.hide();
				 switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', alertMsg33+'. Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', alertMsg33+'. Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', alertMsg33+'. '+action.result.msg);
				}
			}
		});
	},
	hostCheckAddComponent : function()
	{
		var hostName=publicJSON.hostName;
		var portValue=publicJSON.portNo;
		var nodeGUID=publicJSON.nodeGUID;
		var agentHostIP=publicJSON.agentHostIP;
		var action = Ext.getCmp('radioOpts').getValue().notify;
		var forwardURL ="NewComponent/data/EgnewserverpJson.jsp?action="+action;
		var hiddenParams = publicJSON.hiddenValues;
		var me = Ext.getCmp('hiddenContnr2');
		me.removeAll();
		Ext.suspendLayouts();
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		Ext.resumeLayouts(true);
		var resMsg = alertMsg34;
		if (currentAction == 'modify')
		{
			resMsg = alertMsg35;
		}
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getIntermediateview().submit({
			url: forwardURL,
			method: 'POST',
			timeout: 120,
			success: function(form, action){
				tmpMask.hide();
				var resObj  = action.response.responseText;
				publicJSON = Ext.decode(resObj);
				var requestStatus = publicJSON['requestStatus'];
				var agentless=Ext.getCmp('enableRemoteAgent').getValue();
				var oldRemoteAgent=Ext.getCmp('remoteAgent').getValue();
				if(requestStatus == 'success')
				{
					if (currentAction == 'modify')
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: alertMsg35+'\nPlease download the agent file for this component and deploy it in the corresponding application.',
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok')
								{
									window.location.href = "EgNewServer.jsp?serverType=NodeJS&modifyserver=true&serverGategory=-1&hostName="+hostName+"&portValue="+portValue+"&nodeGUID="+nodeGUID+"&agentHostIP="+agentHostIP+"&agentLess="+agentless+"&oldRemoteAgent="+oldRemoteAgent;
								}
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: alertMsg34+'\nPlease download the agent file for this component and deploy it in the corresponding application.',
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok')
								{
									window.location.href = "EgNewServer.jsp?serverType=NodeJS&modifyserver=true&serverGategory=-1&hostName="+hostName+"&portValue="+portValue+"&nodeGUID="+nodeGUID+"&agentHostIP="+agentHostIP+"&agentLess="+agentless+"&oldRemoteAgent="+oldRemoteAgent;
								}
							}
						});
					}
				}
				else if (requestStatus == 'failed')
				{
					Ext.Msg.show({
						title: publicJSON.Error_Info.Error_Title,
						msg: alertMsg33 + '<br>' + publicJSON.Error_Info.Error_Msg_1 + '<br>' + publicJSON.Error_Info.Error_Msg_2,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								if(fromTopology=='yes')
								{
									window.parent.closedManagedWindow();
								}
								else
								{
									var url = "/final/admin/EgDispServer.jsp?&category="+publicJSON.selectedServerGroup+"&comptype="+encodeURIComponent(publicJSON.selectedServer);
									window.location.href = url;
								}
							}
						}
					});
				}
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				tmpMask.hide();
				 switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', alertMsg33+'. Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', alertMsg33+'. Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
						Ext.Msg.alert('Failure', alertMsg33+'. '+action.result.msg);
				}
			}
		});
	},
	addComponentValidation : function()
	{
		var me= this;
		var compType = Ext.getCmp('stype').getValue();
		var compNickObj = Ext.getCmp('hostname');
		var compNickVal = Ext.getCmp('hostname').getValue();
		var compType = Ext.getCmp('stype').getValue();
		var agentLess = Ext.getCmp('enableRemoteAgent').getValue();
		if(isDoubleByteMgr=="false")
		{
			if(!validateSingleByte(compNickVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg1,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					width: 700,
					fn: function(response) {
						if(response == 'ok') {
							compNickObj.focus(true);
						}
					}
				});
				return false;
			}
		}
		var isAggType = "";
		if(compType.indexOf("_") > 0)
		{
			isAggType = (compType.substring(0,compType.indexOf("_")) == "Agg");
			if(isAggType)
			{
				if(!checkblank(compNickVal))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg22,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								compNickObj.focus(true);
							}
						}
					});
					return false;
				}
			}
		}
		if (Ext.getCmp('extAgents').getValue() == '')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg7,
				buttons: Ext.Msg.OK,
				layout: 'auto',
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						//Ext.getCmp('extAgents').focus(true);
					}
				}
			});
			return false;
		}
		var alosObj = Ext.getCmp('alos');
		if (!alosObj.isDisabled()) //Agentless enabled
		{
			var alosVal = alosObj.getValue();
			if(alosVal =='None')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg2,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							alosObj.focus(true);
						}
					}
				});
				return false;
			}
			var almodeObj = Ext.getCmp('almode');
			var almodeVal = almodeObj.getValue();
			if (almodeVal == 'None')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							almodeObj.focus(true);
						}
					}
				});
				return false;
			}
			else if (almodeVal == "Perfmon" 
				&& alosVal != "nt" 
				&& alosVal != "2003" 
				&& alosVal != "2008" 
				&& alosVal != "w2k"
				&& alosVal != "xp"
				&& alosVal != "2012"
				&& alosVal != "2016"
				&& alosVal != "win7"
				&& alosVal != "win8"
				&& alosVal != "win10")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg4,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							almodeObj.focus(true);
						}
					}
				});
				return false;
			}
			else if (( almodeVal == "SSH" || almodeVal == "Rexec")
				&& (alosVal == "nt" 
				|| alosVal == "2003" 
				|| alosVal == "2008" 
				|| alosVal == "w2k"
				|| alosVal == "xp"
				|| alosVal == "2012"
				|| alosVal == "2016"
				|| alosVal == "win7"
				|| alosVal == "win8"
				|| alosVal == "win10"))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: almodeVal+' '+alertMsg5,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							almodeObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(almodeVal!="SNMP" &&(compType == 'AS400_server'||compType == 'Snmp_generic_server' ||compType == 'Netware_server'))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg6,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							almodeObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(almodeVal == "SSH")
			{
				var encryptVal = Ext.getCmp('alencrypt').getValue();
				if (encryptVal == 'Keybased')
				{
					var keyFileObj = Ext.getCmp('alkeyfile')
					var keyFile = keyFileObj.getValue();
					if (keyFile == '' || keyFile.toLowerCase() == 'none')
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: alertMsg40,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(response) {
								if(response == 'ok') {
									keyFileObj.focus(true);
								}
							}
						});
						return false;
					}
				}
			}
		}
		var sshPortObj = Ext.getCmp('sshPort');
		if (!sshPortObj.isDisabled())
		{
			var sshPortVal = sshPortObj.getValue();
			//Validate the port
			if(!checkblank(sshPortVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg8,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sshPortObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(!checknumber("+",sshPortVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg9,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sshPortObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(!checkfordecimal(sshPortVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg10,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sshPortObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(sshPortVal < 1)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg11,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sshPortObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(sshPortVal > 99999)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg12,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sshPortObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(!checkspace(sshPortVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg13,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sshPortObj.focus(true);
						}
					}
				});
				return false;
			}
		}
		if (!Ext.getCmp('aluser').isDisabled() && !Ext.getCmp('alpwd').isDisabled())
		{
			if(!this.checkUserPwd())
				return false;
		}
		var hostIpObj = Ext.getCmp('hostip');
		var hostIpVal = Ext.getCmp('hostip').getValue();
		
		if(!publicJSON.hideHostIPField && !checkblank(hostIpVal))
		{
			if (isAllowHostName=='false')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg18,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							hostIpObj.focus(true);
						}
					}
				});
			}
			else
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg19,
					buttons: Ext.Msg.OK,
					width: 300,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							hostIpObj.focus(true);
						}
					}
				});
			}
			return false;
		}
		else if(!publicJSON.hideHostIPField && isAllowHostName=='false' && !validateIpAddress(hostIpVal))
		{
			hostIpObj.focus(true);
			return false;
		}
		else if(!publicJSON.hideHostIPField && isAllowHostName=='true' && !validateHostField(hostIpVal))
		{
			hostIpObj.focus(true);
			return false;
		}
		else if(!publicJSON.hideHostIPField && isAllowHostName=='true' && !checkspace(hostIpVal))
		{
			hostIpObj.focus(true);
			return false;
		}
		else if(!publicJSON.hideHostIPField && isAllowHostName=='true' && !checkspecial(hostIpVal,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?/")) 
		{
			hostIpObj.focus(true);
			return false;
		}
		else if(isAllowHostName=='true' && !this.checkForHostType(compNickVal))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg20 + alertMsg21,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						compNickObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(!checkblank(compNickVal))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg22,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						compNickObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(checkspaceExtjs(compNickVal) != '0')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: "Space is not allowed",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						compNickObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(checkSpecialExtjs(compNickVal,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?/") != '0') 
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkspecial,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						compNickObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(compNickVal.toLowerCase() == "none")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: "You are not allowed to use eG reserved keyword \'"+compNickVal+"\' as component name",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						compNickObj.focus(true);
					}
				}
			});
			return false;
		}
		else if (!this.checkForHostType(compNickVal))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg20 + alertMsg21,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						compNickObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(!Ext.getCmp('underVmware').isDisabled() && Ext.getCmp('underVmware').getValue())
		{
			if (Ext.getCmp('esxServer').getValue()==-1)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg23,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							Ext.getCmp('esxServer').focus(true);
						}
					}
				});
				return false;
			}
		}
		else if(!Ext.getCmp('underCloud').isDisabled() && Ext.getCmp('underCloud').getValue())
		{
			if (Ext.getCmp('cloudServer').getValue()==-1)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg24,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							Ext.getCmp('cloudServer').focus(true);
						}
					}
				});
				return false;
			}
		}
		else if(!this.checkdots(compNickVal))
		{
			compNickObj.focus(true);
			return;
		}
		else if(!this.isValidateHostName(compNickVal) && !isAggType)
		{
			if(compNickVal != hostIpVale)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg25,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							compNickObj.focus(true);
						}
					}
				});
				return false;
			}
		}
		if (agentLess && this.validateHostNameWithRemote(compNickVal))
		{
			Ext.getCmp("enableRemoteAgent").setValue(false);
			return false;
		}
		if (isDoubleByteMgr=='false')
		{
			if(compNickVal.toLowerCase() == compType.toLowerCase())
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg26,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							compNickObj.focus(true);
						}
					}
				});
				return false;
			}
		}
		var portObj = Ext.getCmp('sportno');
		var portVal = Ext.getCmp('sportno').getValue();
		if (!portObj.isDisabled())
		{
			if(!checkblank(portVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg27,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							portObj.focus(true);
						}
					}
				});
				return false;
			}
			else if (!checknumber("+",portVal) && portVal != 'NULL')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg28,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							portObj.focus(true);
						}
					}
				});
				return false;
			}
			else if (!checkfordecimal(portVal))
			{
				portObj.focus(true);
				return false;
			}
			else if (portVal < 1)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg11,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							portObj.focus(true);
						}
					}
				});
				return false;
			}
			else if (portVal > 99999)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg12,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							portObj.focus(true);
						}
					}
				});
				return false;
			}
			else if (!checkspace(portVal))
			{
				portObj.focus(true);
				return false;
			}
			else if (Ext.getCmp('extAgents').getValue() == '')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg7,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							Ext.getCmp('extAgents').focus(true);
						}
					}
				});
				return false;
			}
		}
		if (compType=='Oracle_server')
		{
			var sidObj = Ext.getCmp('sid');
			var sidVal = Ext.getCmp('sid').getValue();
			if(!checkblank(sidVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg29,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sidObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(checkSpecialExtjs(sidVal,"&():<") != '0')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sidObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(!checkCommaValue(sidVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg29,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sidObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(checkspaceExtjs(sidVal) != '0')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: "Space is not allowed",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sidObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(!checkduplicateValue(sidVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg30,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							sidObj.focus(true);
						}
					}
				});
				return false;
			}
		}

		if(currentAction == 'modify')
		{
			var existName = publicJSON.hostname;
			var existPort = publicJSON.portValue;
			if (compNickVal != existName)
			{
				if (!this.validateHostName())
				{
					return false;
				}
			}
			
			if (serverType=='Oracle_server')
			{
				var oldSid = publicJSON.sidValue;
				var newSid = Ext.getCmp('sid').getValue();
				if(oldSid!="")
				{
					var oldSidList = oldSid.split(',');
					var newSidList = newSid.split(',');
					for(var i=0;i<oldSidList.length;i++)
					{
						var j=0;
						for(;j<newSidList.length;j++)
						{
							if(oldSidList[i] == newSidList[j])
								break;
						}
						if(j == newSidList.length)
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: alertMsg37,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(response) {
									if(response == 'ok') {
										sidObj.focus(true);
									}
								}
							});
							return false;
						}
					}
				}
			}
		}

		var optManual = Ext.getCmp('intAgentManual').getValue();
		if(optManual && !agentLess)
		{
			var extListHasAgent = false;
			var rmtListHasAgent = false;
			for(var i = 0; i < extListArr.length; i++)
			{
				var extListStrSa = extListArr[i].trim();
				if (extListStrSa == compNickVal)
				{
					extListHasAgent = true;
					break;
				}
			}
			for(var i = 0; i < rmtListArr.length; i++)
			{
				var rmtListStrSa = rmtListArr[i].trim();
				if (rmtListStrSa == compNickVal)
				{
					rmtListHasAgent = true;
					break;
				}
			}
			if(extListHasAgent || rmtListHasAgent)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg46,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							Ext.getCmp('intAgentAuto').setValue(true);
							Ext.getCmp('currAgents').hide();
							Ext.getCmp('currAgents').disable();
						}
					}
				});
				return false;
			}
		}

		if(currentAction == 'modify')
		{
			var existName = publicJSON.hostname;
			var existPort = publicJSON.portValue;
			
			if (existName != "" && (compNickVal != existName || portVal != existPort))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg36,
					buttons: Ext.Msg.OKCANCEL,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							me.actualAdd();
						}
						else
						{							
							return false;
						}
					}
				});
			}
			else
			{
				me.actualAdd();
			}
		}
		else
		{
			me.actualAdd();
		}
	},
	isValidateHostName:function (server)
	{
		var b_flag = false;
		if(checkDigit(server))
		{
			b_flag =  true;
		}
		else
		{
			if (isDoubleByteMgr=='false')
			{
				if(checkAlpha(server))
				{
					b_flag = true;
				}
			}
			else
			{
				b_flag = true;
			}
		}
		return b_flag;
	},
	checkdots : function(fieldvalue)
	{
		var val = fieldvalue;
		if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg31,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else
		{
			for(var k=0;k < val.length;k++)
			{
				if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg41,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else
				{
					continue;
				}
			}
		}
		return true;
	},
	checkUserPwd : function()
	{
		var aluserVal = Ext.getCmp('aluser').getValue();
		var alpwdVal = Ext.getCmp('alpwd').getValue();

		if(aluserVal=="null" || aluserVal=="")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg14,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('aluser').focus(true);
					}
				}
			});
			return false;
		}
		else if(!checkspecial(aluserVal,"	@#$%^&*+={}|:;\"\'<>,\/"))
		{
			Ext.getCmp('aluser').focus(true);
			return false;
		}
		else if( alpwdVal=="null" || alpwdVal=="")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('alpwd').focus(true);
					}
				}
			});
			return false;
		}

		if(alpwdVal == "")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkempty,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('alpwd').focus(true);
					}
				}
			});
			return false;
		}
		else if(!checkspecialnomess(alpwdVal,"\"|"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg16,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('alpwd').focus(true);
					}
				}
			});
			return false;
		}
		else if(!checkForPassValidity(alpwdVal))
		{
			Ext.getCmp('alpwd').focus(true);
			return false;
		}

		if(aluserVal!= null && aluserVal.indexOf(" ")> -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('aluser').focus(true);
					}
				}
			});
			return false;
		}
		return true;
	},
	/* 
	 * This function is used to check whether the given comp nick name already existing as a remote agent or not
	 * for eg: Add an agentless comp tomcat_01 with remote agent 'rem01' and external agent 'ext01'
	 * and then add an agentless comp 'rem01' with remote agent 'rem02' and external agent 'ext02'
	 * In eg_agents.ini (for the comp 'tomcat_01'), the tests under the remote agent 'rem01' was moved to 
	 * the remote agent 'rem02'. At Test specific configuration page (for the comp 'tomcat_01')
	 * it shows only external tests (other corresponding tests are not shown).
	 */
	validateHostNameWithRemote : function(hostname)
	{
		var me = this;
		var allRemAgents = publicJSON.hiddenVals.allRemAgents;
		var isRmtAgentExist = false;
		if((allRemAgents != undefined && allRemAgents != "") && (hostname != undefined && hostname != ""))
		{
			if(me.contains2(allRemAgents,hostname))
			{
				var alertMsg = alertMsg47+". "+alertMsg49;
				if (currentAction == 'modify')
				{
					alertMsg = alertMsg48+". "+alertMsg49;
				}
				Ext.Msg.show({
					title : pageTitle,
					msg : alertMsg,
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
				isRmtAgentExist = true;
			}
		}
		return isRmtAgentExist;
	},
	validateHostName : function()
	{
		var allExtAgents = publicJSON.hiddenVals.allExtAgents;
		var allRemAgents = publicJSON.hiddenVals.allRemAgents;
		var name = publicJSON.hostname;
		var isExtAgentExist = false;
		var isRmtAgentExist = false;
		if(name != "" && this.contains2(allExtAgents, name))
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : alertMsg38,
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			isExtAgentExist = true;
		}
		if(name != "" && this.contains2(allRemAgents, name))
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : alertMsg39,
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			isRmtAgentExist = true;
		}
		if (isExtAgentExist || isRmtAgentExist)
			return false;
		else
			return true;
	},
	contains2 : function(largeStr, smallStr)
	{
		var string = largeStr;
		var contains = false;
		var prevIndex = 0;
		var index = string.indexOf(',');
		while (index > -1)
		{
			var substring = string.substring(prevIndex, index);
			if (substring.toLowerCase() == smallStr.toLowerCase())
			{
				contains = true;
				break;
			}
			else
			{
				prevIndex = index;
				string = string.substring(1, string.length);
				index = string.indexOf(',');
			}
		}

		if (string.toLowerCase() == smallStr.toLowerCase())
		{
			contains = true;
		}

		return contains;
	},
	checkForHostType : function(compType)
	{
		var servers = publicJSON.servTypes;
		for (var s=0; s<servers.length;s++)
		{
			if(servers[s] == compType)
			{
				return false;
			}
		}
		return true;
	},
	//adding new function
	usedSiteNameCheck:function()
	{
		var compName = Ext.getCmp('rumNickName').getValue();
		var selectedSite = Ext.getCmp('rumserviceNameList').getValue();
		Ext.Ajax.request(
		{
			url: 'NewComponent/data/newRUMServerJson.jsp?selectedSite='+selectedSite+'&compName='+encodeURIComponent(compName)+'&currentAction='+currentAction,
			method: 'POST',
			async: false,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var myPublicJSON = Ext.decode(jsonText.substring(0,jsonText.indexOf('&*&')));
					var siteFound = myPublicJSON['siteFound'];
					var usedsiteName=myPublicJSON['used_Site_name'];
					var existingSite=myPublicJSON['existingSite'];
					var cname=myPublicJSON['usedComponetName'];
					if(siteFound)
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: 'Website '+existingSite+' is associated with component '+cname+' ,Please select different website.',
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						if(currentAction == 'modify')
						{
							Ext.getCmp('rumserviceNameList').setValue(usedsiteName);
						}else
						{
							Ext.getCmp('rumserviceNameList').setValue('-1');
						}
						
						return false;
					}
				}
			}
		});
	},
	hostCheckBack : function()
	{
		var URL ="/final/admin/EgNewServer.jsp?"+addCompURL;
		window.location.href = URL;
	},
	download: function()
	{
		download();
	},
});
function download() 
{
	var form = document.createElement("form");
    form.setAttribute("method", "post");
    form.setAttribute("action", "/final/servlet/com.eg.ProfilerScriptDownloader?&Stype="+encodeURIComponent(serverType));
    document.body.appendChild(form);
	form.submit();
}